/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.assertion;

import java.io.StringWriter;
import java.util.Deque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Objects;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventFactory;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.keycloak.saml.common.PicketLinkLogger;
import org.keycloak.saml.common.PicketLinkLoggerFactory;
import org.keycloak.saml.common.constants.JBossSAMLURIConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.parsers.StaxParser;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.assertion.SAMLAssertionQNames;
import org.keycloak.saml.processing.core.parsers.util.SAMLParserUtil;
import org.keycloak.saml.processing.core.saml.v2.util.XMLTimeUtil;

public class SAMLAttributeValueParser
implements StaxParser {
    private static final PicketLinkLogger logger = PicketLinkLoggerFactory.getLogger();
    private static final SAMLAttributeValueParser INSTANCE = new SAMLAttributeValueParser();
    private static final QName NIL = new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "nil", JBossSAMLURIConstants.XSI_PREFIX.get());
    private static final QName XSI_TYPE = new QName(JBossSAMLURIConstants.XSI_NSURI.get(), "type", JBossSAMLURIConstants.XSI_PREFIX.get());
    private static final ThreadLocal<XMLEventFactory> XML_EVENT_FACTORY = ThreadLocal.withInitial(XMLEventFactory::newInstance);

    public static SAMLAttributeValueParser getInstance() {
        return INSTANCE;
    }

    @Override
    public Object parse(XMLEventReader xmlEventReader) throws ParsingException {
        StartElement element = StaxParserUtil.getNextStartElement(xmlEventReader);
        StaxParserUtil.validate(element, SAMLAssertionQNames.ATTRIBUTE_VALUE.getQName());
        Attribute nil = element.getAttributeByName(NIL);
        if (nil != null) {
            String nilValue = StaxParserUtil.getAttributeValue(nil);
            if (nilValue != null && (nilValue.equalsIgnoreCase("true") || nilValue.equals("1"))) {
                String elementText = StaxParserUtil.getElementText(xmlEventReader);
                if (elementText == null || elementText.isEmpty()) {
                    return null;
                }
                throw logger.nullValueError("nil attribute is not in SAML20 format");
            }
            throw logger.parserRequiredAttribute(JBossSAMLURIConstants.XSI_PREFIX.get() + ":nil");
        }
        Attribute type = element.getAttributeByName(XSI_TYPE);
        if (type == null) {
            if (StaxParserUtil.hasTextAhead(xmlEventReader)) {
                return StaxParserUtil.getElementText(xmlEventReader);
            }
            XMLEvent xmlEvent = StaxParserUtil.peek(xmlEventReader);
            if (xmlEvent instanceof StartElement) {
                element = (StartElement)xmlEvent;
                QName qName = element.getName();
                if (Objects.equals(qName, SAMLAssertionQNames.NAMEID.getQName())) {
                    return SAMLParserUtil.parseNameIDType(xmlEventReader);
                }
            } else if (xmlEvent instanceof EndElement) {
                return "";
            }
            return SAMLAttributeValueParser.parseAsString(xmlEventReader);
        }
        String typeValue = StaxParserUtil.getAttributeValue(type);
        if (typeValue.contains(":string")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        if (typeValue.contains(":anyType")) {
            return SAMLAttributeValueParser.parseAsString(xmlEventReader);
        }
        if (typeValue.contains(":base64Binary")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        if (typeValue.contains(":date")) {
            return XMLTimeUtil.parse(StaxParserUtil.getElementText(xmlEventReader));
        }
        if (typeValue.contains(":boolean")) {
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        return SAMLAttributeValueParser.parseAsString(xmlEventReader);
    }

    private static String parseAsString(XMLEventReader xmlEventReader) throws ParsingException {
        try {
            if (xmlEventReader.peek().isStartElement()) {
                StringWriter sw = new StringWriter();
                XMLEventWriter writer = XMLOutputFactory.newInstance().createXMLEventWriter(sw);
                LinkedList<Map<String, String>> definedNamespaces = new LinkedList<Map<String, String>>();
                int tagLevel = 0;
                while (xmlEventReader.hasNext() && (tagLevel > 0 || !xmlEventReader.peek().isEndElement())) {
                    XMLEvent event = (XMLEvent)xmlEventReader.next();
                    writer.add(event);
                    if (event.isStartElement()) {
                        definedNamespaces.push(SAMLAttributeValueParser.addNamespaceWhenMissing(definedNamespaces, writer, event.asStartElement()));
                        ++tagLevel;
                    }
                    if (!event.isEndElement()) continue;
                    definedNamespaces.pop();
                    --tagLevel;
                }
                writer.close();
                return sw.toString();
            }
            return StaxParserUtil.getElementText(xmlEventReader);
        }
        catch (Exception e) {
            throw logger.parserError(e);
        }
    }

    private static Map<String, String> addNamespaceWhenMissing(Deque<Map<String, String>> definedNamespaces, XMLEventWriter writer, StartElement startElement) throws XMLStreamException {
        HashMap<String, String> necessaryNamespaces = new HashMap<String, String>();
        if (startElement.getName().getPrefix() != null && !startElement.getName().getPrefix().isEmpty()) {
            necessaryNamespaces.put(startElement.getName().getPrefix(), startElement.getName().getNamespaceURI());
        }
        Iterator<Attribute> attributes = startElement.getAttributes();
        while (attributes.hasNext()) {
            Attribute attribute = attributes.next();
            if (attribute.getName().getPrefix() == null || attribute.getName().getPrefix().isEmpty()) continue;
            necessaryNamespaces.put(attribute.getName().getPrefix(), attribute.getName().getNamespaceURI());
        }
        necessaryNamespaces.entrySet().removeIf(nn -> definedNamespaces.stream().anyMatch(dn -> dn.containsKey(nn.getKey())));
        Iterator<Namespace> namespaces = startElement.getNamespaces();
        while (namespaces.hasNext() && !necessaryNamespaces.isEmpty()) {
            necessaryNamespaces.remove(namespaces.next().getPrefix());
        }
        if (!necessaryNamespaces.isEmpty()) {
            XMLEventFactory xmlEventFactory = XML_EVENT_FACTORY.get();
            for (Map.Entry entry : necessaryNamespaces.entrySet()) {
                writer.add(xmlEventFactory.createNamespace((String)entry.getKey(), (String)entry.getValue()));
            }
        }
        return necessaryNamespaces;
    }
}

