/*
 * Decompiled with CFR 0.152.
 */
package com.github.kokorin.jaffree.ffmpeg;

import com.github.kokorin.jaffree.JaffreeException;
import com.github.kokorin.jaffree.Rational;
import com.github.kokorin.jaffree.ffmpeg.Frame;
import com.github.kokorin.jaffree.ffmpeg.FrameInput;
import com.github.kokorin.jaffree.ffmpeg.FrameProducer;
import com.github.kokorin.jaffree.ffmpeg.ImageFormat;
import com.github.kokorin.jaffree.ffmpeg.Stream;
import com.github.kokorin.jaffree.nut.DataItem;
import com.github.kokorin.jaffree.nut.FrameCode;
import com.github.kokorin.jaffree.nut.Info;
import com.github.kokorin.jaffree.nut.NutFrame;
import com.github.kokorin.jaffree.nut.NutOutputStream;
import com.github.kokorin.jaffree.nut.NutWriter;
import com.github.kokorin.jaffree.nut.StreamHeader;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NutFrameWriter
implements FrameInput.FrameWriter {
    private final FrameProducer producer;
    private final ImageFormat imageFormat;
    private final long frameOrderingBufferMillis;
    private static final byte[] FOURCC_PCM_S32BE = new byte[]{32, 68, 83, 80};
    private static final Logger LOGGER = LoggerFactory.getLogger(NutFrameWriter.class);

    public NutFrameWriter(FrameProducer producer, ImageFormat imageFormat, long frameOrderingBufferMillis) {
        this.producer = producer;
        this.imageFormat = imageFormat;
        this.frameOrderingBufferMillis = frameOrderingBufferMillis;
    }

    @Override
    public void write(OutputStream outputStream) throws IOException {
        NutWriter writer = new NutWriter(new NutOutputStream(outputStream), this.frameOrderingBufferMillis);
        this.write(writer);
        writer.writeFooter();
    }

    private void write(NutWriter writer) throws IOException {
        Frame frame;
        List<Stream> tracks = this.producer.produceStreams();
        LOGGER.debug("Streams: {}", tracks.toArray());
        StreamHeader[] streamHeaders = new StreamHeader[tracks.size()];
        Rational[] timebases = new Rational[tracks.size()];
        for (int i = 0; i < streamHeaders.length; ++i) {
            StreamHeader streamHeader;
            Stream stream = tracks.get(i);
            if (stream.getId() != i) {
                throw new JaffreeException("Stream ids must start with 0 and increase by 1 subsequently!");
            }
            Objects.requireNonNull(stream.getType(), "Stream type must be specified");
            Objects.requireNonNull(stream.getTimebase(), "Stream timebase must be specified");
            switch (stream.getType()) {
                case VIDEO: {
                    Objects.requireNonNull(stream.getWidth(), "Width must be specified");
                    Objects.requireNonNull(stream.getHeight(), "Height must be specified");
                    streamHeader = new StreamHeader(stream.getId(), StreamHeader.Type.VIDEO, this.imageFormat.getFourCC(), i, 0, 60000L, 0L, EnumSet.noneOf(StreamHeader.Flag.class), new byte[0], new StreamHeader.Video(stream.getWidth(), stream.getHeight(), 1, 1, StreamHeader.ColourspaceType.UNKNOWN), null);
                    break;
                }
                case AUDIO: {
                    Objects.requireNonNull(stream.getSampleRate(), "Samplerate must be specified");
                    Objects.requireNonNull(stream.getChannels(), "Number of channels must be specified");
                    streamHeader = new StreamHeader(stream.getId(), StreamHeader.Type.AUDIO, FOURCC_PCM_S32BE, i, 0, 60000L, 0L, EnumSet.noneOf(StreamHeader.Flag.class), new byte[0], null, new StreamHeader.Audio(new Rational(stream.getSampleRate(), 1L), stream.getChannels()));
                    break;
                }
                default: {
                    throw new JaffreeException("Unknown Track Type: " + (Object)((Object)stream.getType()));
                }
            }
            streamHeaders[i] = streamHeader;
            timebases[i] = new Rational(1L, stream.getTimebase());
        }
        int framecodesLength = 256;
        FrameCode[] frameCodes = new FrameCode[framecodesLength];
        frameCodes[0] = FrameCode.INVALID;
        frameCodes[1] = new FrameCode(EnumSet.of(FrameCode.Flag.CODED_FLAGS), 0, 1, 0, 0L, 0L, 0L, 0L);
        for (int i = 2; i < framecodesLength; ++i) {
            frameCodes[i] = FrameCode.INVALID;
        }
        writer.setMainHeader(tracks.size(), 32767L, timebases, frameCodes);
        writer.setStreamHeaders(streamHeaders);
        writer.setInfos(new Info[0]);
        while ((frame = this.producer.produce()) != null) {
            byte[] data;
            LOGGER.trace("Frame: {}", (Object)frame);
            StreamHeader streamHeader = streamHeaders[frame.getStreamId()];
            switch (streamHeader.streamType) {
                case VIDEO: {
                    BufferedImage image = frame.getImage();
                    data = this.imageFormat.toBytes(image);
                    break;
                }
                case AUDIO: {
                    data = new byte[frame.getSamples().length * 4];
                    ByteBuffer.wrap(data).asIntBuffer().put(frame.getSamples());
                    break;
                }
                default: {
                    throw new JaffreeException("Unexpected track: " + streamHeader.streamId + ", type: " + (Object)((Object)streamHeader.streamType));
                }
            }
            NutFrame nutFrame = new NutFrame(frame.getStreamId(), frame.getPts(), data, new DataItem[0], new DataItem[0], true, false);
            LOGGER.trace("NutFrame: {}", (Object)nutFrame);
            writer.writeFrame(nutFrame);
        }
    }
}

