/*
 * Decompiled with CFR 0.152.
 */
package org.jmol.util;

import javajs.util.AU;
import org.jmol.api.FontManager;

public final class Font {
    public final int fid;
    public final String fontFace;
    public final String fontStyle;
    public final float fontSizeNominal;
    public final int idFontFace;
    public final int idFontStyle;
    public final float fontSize;
    public final Object font;
    private final Object fontMetrics;
    private FontManager manager;
    private int ascent;
    private int descent;
    private boolean isBold;
    private boolean isItalic;
    public float fontSizeAngstroms;
    private static final int FONT_ALLOCATION_UNIT = 8;
    private static int fontkeyCount = 1;
    private static int[] fontkeys = new int[8];
    private static Font[] font3ds = new Font[8];
    public static final int FONT_FACE_SANS = 0;
    public static final int FONT_FACE_SERIF = 1;
    public static final int FONT_FACE_MONO = 2;
    private static final String[] fontFaces = new String[]{"SansSerif", "Serif", "Monospaced", ""};
    public static final int FONT_STYLE_PLAIN = 0;
    public static final int FONT_STYLE_BOLD = 1;
    public static final int FONT_STYLE_ITALIC = 2;
    public static final int FONT_STYLE_BOLDITALIC = 3;
    private static final String[] fontStyles = new String[]{"Plain", "Bold", "Italic", "BoldItalic"};

    private Font(FontManager fontManager, int n, int n2, int n3, float f, float f2, float f3, Object object) {
        this.manager = fontManager;
        this.fid = n;
        this.fontFace = fontFaces[n2];
        this.fontStyle = fontStyles[n3];
        this.idFontFace = n2;
        this.idFontStyle = n3;
        this.fontSize = f;
        this.fontSizeAngstroms = f3;
        this.isBold = (n3 & 1) == 1;
        this.isItalic = (n3 & 2) == 2;
        this.fontSizeNominal = f2;
        this.font = fontManager.newFont(fontFaces[n2], this.isBold, this.isItalic, f);
        this.fontMetrics = fontManager.getFontMetrics(this, object);
        this.descent = fontManager.getFontDescent(this.fontMetrics);
        this.ascent = fontManager.getFontAscent(this.fontMetrics);
    }

    public static Font getFont3D(int n) {
        return font3ds[n];
    }

    public static synchronized Font createFont3D(int n, int n2, float f, float f2, float f3, FontManager fontManager, Object object) {
        Font font;
        if (f > 255.0f) {
            f = 255.0f;
        }
        if (f < 0.0f) {
            f3 = -f;
            f = 10.0f;
            f2 = 10.0f;
        }
        int n3 = (int)f << 4;
        int n4 = n & 3 | (n2 & 3) << 2 | n3 << 4;
        int n5 = fontkeyCount;
        while (--n5 > 0) {
            if (n4 != fontkeys[n5] || Font.font3ds[n5].fontSizeNominal != f2) continue;
            return font3ds[n5];
        }
        if ((n5 = fontkeyCount++) == fontkeys.length) {
            fontkeys = AU.arrayCopyI(fontkeys, n5 + 8);
            font3ds = (Font[])AU.arrayCopyObject(font3ds, n5 + 8);
        }
        Font.font3ds[n5] = font = new Font(fontManager, n5, n, n2, f, f2, f3, object);
        Font.fontkeys[n5] = n4;
        return font;
    }

    public static int getFontFaceID(String string) {
        return "Monospaced".equalsIgnoreCase(string) ? 2 : ("Serif".equalsIgnoreCase(string) ? 1 : 0);
    }

    public static int getFontStyleID(String string) {
        int n = 4;
        while (--n >= 0) {
            if (!fontStyles[n].equalsIgnoreCase(string)) continue;
            return n;
        }
        return -1;
    }

    public int getAscent() {
        return this.ascent;
    }

    public int getDescent() {
        return this.descent;
    }

    public int getHeight() {
        return this.getAscent() + this.getDescent();
    }

    public Object getFontMetrics() {
        return this.fontMetrics;
    }

    public int stringWidth(String string) {
        return this.manager.fontStringWidth(this, string);
    }

    public String getInfo() {
        return String.valueOf(this.fontSizeAngstroms > 0.0f ? -this.fontSizeAngstroms : this.fontSizeNominal) + " " + this.fontFace + " " + this.fontStyle;
    }

    public String toString() {
        return "[" + this.getInfo() + "]";
    }
}

