/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.grpc.stub;

import io.grpc.stub.StreamObserver;
import io.vertx.codegen.annotations.Nullable;
import io.vertx.core.Handler;
import io.vertx.core.streams.ReadStream;

class StreamObserverReadStream<T>
implements StreamObserver<T>,
ReadStream<T> {
    private Handler<Throwable> exceptionHandler;
    private Handler<T> handler;
    private Handler<Void> endHandler;

    StreamObserverReadStream() {
    }

    public void onNext(T t) {
        if (this.handler != null) {
            this.handler.handle(t);
        }
    }

    public void onError(Throwable throwable) {
        if (this.exceptionHandler != null) {
            this.exceptionHandler.handle((Object)throwable);
        }
    }

    public void onCompleted() {
        if (this.endHandler != null) {
            this.endHandler.handle(null);
        }
    }

    public ReadStream<T> exceptionHandler(Handler<Throwable> handler) {
        this.exceptionHandler = handler;
        return this;
    }

    public ReadStream<T> handler(@Nullable Handler<T> handler) {
        this.handler = handler;
        return this;
    }

    public ReadStream<T> pause() {
        return this;
    }

    public ReadStream<T> resume() {
        return this;
    }

    public ReadStream<T> fetch(long l) {
        return this;
    }

    public ReadStream<T> endHandler(@Nullable Handler<Void> handler) {
        this.endHandler = handler;
        return this;
    }
}

