/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.ingest;

import jakarta.json.stream.JsonGenerator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.opensearch.ingest.Processor;
import org.opensearch.client.opensearch.ingest.ProcessorBase;
import org.opensearch.client.opensearch.ingest.ProcessorVariant;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class GeoIpProcessor
extends ProcessorBase
implements ProcessorVariant,
ToCopyableBuilder<Builder, GeoIpProcessor> {
    @Nullable
    private final String databaseFile;
    @Nonnull
    private final String field;
    @Nullable
    private final Boolean firstOnly;
    @Nullable
    private final Boolean ignoreMissing;
    @Nonnull
    private final List<String> properties;
    @Nullable
    private final String targetField;
    public static final JsonpDeserializer<GeoIpProcessor> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, GeoIpProcessor::setupGeoIpProcessorDeserializer);

    private GeoIpProcessor(Builder builder) {
        super(builder);
        this.databaseFile = builder.databaseFile;
        this.field = ApiTypeHelper.requireNonNull(builder.field, this, "field");
        this.firstOnly = builder.firstOnly;
        this.ignoreMissing = builder.ignoreMissing;
        this.properties = ApiTypeHelper.unmodifiable(builder.properties);
        this.targetField = builder.targetField;
    }

    public static GeoIpProcessor of(Function<Builder, ObjectBuilder<GeoIpProcessor>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Override
    public Processor.Kind _processorKind() {
        return Processor.Kind.Geoip;
    }

    @Nullable
    public final String databaseFile() {
        return this.databaseFile;
    }

    @Nonnull
    public final String field() {
        return this.field;
    }

    @Nullable
    public final Boolean firstOnly() {
        return this.firstOnly;
    }

    @Nullable
    public final Boolean ignoreMissing() {
        return this.ignoreMissing;
    }

    @Nonnull
    public final List<String> properties() {
        return this.properties;
    }

    @Nullable
    public final String targetField() {
        return this.targetField;
    }

    @Override
    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        super.serializeInternal(generator, mapper);
        if (this.databaseFile != null) {
            generator.writeKey("database_file");
            generator.write(this.databaseFile);
        }
        generator.writeKey("field");
        generator.write(this.field);
        if (this.firstOnly != null) {
            generator.writeKey("first_only");
            generator.write(this.firstOnly.booleanValue());
        }
        if (this.ignoreMissing != null) {
            generator.writeKey("ignore_missing");
            generator.write(this.ignoreMissing.booleanValue());
        }
        if (ApiTypeHelper.isDefined(this.properties)) {
            generator.writeKey("properties");
            generator.writeStartArray();
            for (String item0 : this.properties) {
                generator.write(item0);
            }
            generator.writeEnd();
        }
        if (this.targetField != null) {
            generator.writeKey("target_field");
            generator.write(this.targetField);
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupGeoIpProcessorDeserializer(ObjectDeserializer<Builder> op) {
        GeoIpProcessor.setupProcessorBaseDeserializer(op);
        op.add(Builder::databaseFile, JsonpDeserializer.stringDeserializer(), "database_file");
        op.add(Builder::field, JsonpDeserializer.stringDeserializer(), "field");
        op.add(Builder::firstOnly, JsonpDeserializer.booleanDeserializer(), "first_only");
        op.add(Builder::ignoreMissing, JsonpDeserializer.booleanDeserializer(), "ignore_missing");
        op.add(Builder::properties, JsonpDeserializer.arrayDeserializer(JsonpDeserializer.stringDeserializer()), "properties");
        op.add(Builder::targetField, JsonpDeserializer.stringDeserializer(), "target_field");
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hashCode(this.databaseFile);
        result = 31 * result + this.field.hashCode();
        result = 31 * result + Objects.hashCode(this.firstOnly);
        result = 31 * result + Objects.hashCode(this.ignoreMissing);
        result = 31 * result + Objects.hashCode(this.properties);
        result = 31 * result + Objects.hashCode(this.targetField);
        return result;
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GeoIpProcessor other = (GeoIpProcessor)o;
        return Objects.equals(this.databaseFile, other.databaseFile) && this.field.equals(other.field) && Objects.equals(this.firstOnly, other.firstOnly) && Objects.equals(this.ignoreMissing, other.ignoreMissing) && Objects.equals(this.properties, other.properties) && Objects.equals(this.targetField, other.targetField);
    }

    public static class Builder
    extends ProcessorBase.AbstractBuilder<Builder>
    implements CopyableBuilder<Builder, GeoIpProcessor> {
        @Nullable
        private String databaseFile;
        private String field;
        @Nullable
        private Boolean firstOnly;
        @Nullable
        private Boolean ignoreMissing;
        @Nullable
        private List<String> properties;
        @Nullable
        private String targetField;

        public Builder() {
        }

        private Builder(GeoIpProcessor o) {
            super(o);
            this.databaseFile = o.databaseFile;
            this.field = o.field;
            this.firstOnly = o.firstOnly;
            this.ignoreMissing = o.ignoreMissing;
            this.properties = Builder._listCopy(o.properties);
            this.targetField = o.targetField;
        }

        private Builder(Builder o) {
            super(o);
            this.databaseFile = o.databaseFile;
            this.field = o.field;
            this.firstOnly = o.firstOnly;
            this.ignoreMissing = o.ignoreMissing;
            this.properties = Builder._listCopy(o.properties);
            this.targetField = o.targetField;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Override
        @Nonnull
        protected Builder self() {
            return this;
        }

        @Nonnull
        public final Builder databaseFile(@Nullable String value) {
            this.databaseFile = value;
            return this;
        }

        @Nonnull
        public final Builder field(String value) {
            this.field = value;
            return this;
        }

        @Nonnull
        public final Builder firstOnly(@Nullable Boolean value) {
            this.firstOnly = value;
            return this;
        }

        @Nonnull
        public final Builder ignoreMissing(@Nullable Boolean value) {
            this.ignoreMissing = value;
            return this;
        }

        @Nonnull
        public final Builder properties(List<String> list) {
            this.properties = Builder._listAddAll(this.properties, list);
            return this;
        }

        @Nonnull
        public final Builder properties(String value, String ... values) {
            this.properties = Builder._listAdd(this.properties, value, values);
            return this;
        }

        @Nonnull
        public final Builder targetField(@Nullable String value) {
            this.targetField = value;
            return this;
        }

        @Override
        @Nonnull
        public GeoIpProcessor build() {
            this._checkSingleUse();
            return new GeoIpProcessor(this);
        }
    }
}

