/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.remote.metadata.client;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.opensearch.action.get.GetResponse;
import org.opensearch.common.Nullable;
import org.opensearch.core.rest.RestStatus;
import org.opensearch.core.xcontent.ToXContent;
import org.opensearch.core.xcontent.XContentParser;
import org.opensearch.remote.metadata.client.DataObjectResponse;
import org.opensearch.remote.metadata.common.SdkClientUtils;

public class GetDataObjectResponse
extends DataObjectResponse {
    private final Map<String, Object> source;
    private GetResponse getResponse;

    public GetDataObjectResponse(GetResponse getResponse) {
        super(getResponse.getIndex(), getResponse.getId(), null, false, null, null);
        this.getResponse = getResponse;
        this.source = Optional.ofNullable(getResponse.getSourceAsMap()).orElse(Collections.emptyMap());
    }

    public GetDataObjectResponse(String index, String id, XContentParser parser, boolean failed, Exception cause, RestStatus status, Map<String, Object> source) {
        super(index, id, parser, failed, cause, status);
        this.getResponse = null;
        this.source = source;
    }

    public Map<String, Object> source() {
        return this.source;
    }

    @Nullable
    public GetResponse getResponse() {
        if (this.getResponse == null) {
            GetResponse getResponse;
            block9: {
                XContentParser parser = this.parser();
                try {
                    getResponse = this.getResponse = GetResponse.fromXContent((XContentParser)parser);
                    if (parser == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (parser != null) {
                            try {
                                parser.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException | NullPointerException e) {
                        return null;
                    }
                }
                parser.close();
            }
            return getResponse;
        }
        return this.getResponse;
    }

    @Override
    public XContentParser parser() {
        if (super.parser() == null || super.parser().isClosed()) {
            try {
                return SdkClientUtils.createParser((ToXContent)this.getResponse);
            }
            catch (IOException | NullPointerException e) {
                return null;
            }
        }
        return super.parser();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder
    extends DataObjectResponse.Builder<Builder> {
        private Map<String, Object> source = Collections.emptyMap();

        public Builder source(Map<String, Object> source) {
            this.source = source == null ? Collections.emptyMap() : source;
            return this;
        }

        public GetDataObjectResponse build() {
            return new GetDataObjectResponse(this.index, this.id, this.parser, this.failed, this.cause, this.status, this.source);
        }
    }
}

