#include "widgets/buttons/InitUpdateButton.hpp"

#include "Application.hpp"
#include "widgets/buttons/PixmapButton.hpp"
#include "widgets/dialogs/UpdateDialog.hpp"

namespace chatterino {

void initUpdateButton(PixmapButton &button,
                      const std::function<void()> &relayout,
                      pajlada::Signals::SignalHolder &signalHolder)
{
    button.hide();

    // show update prompt when clicking the button
    QObject::connect(&button, &Button::leftClicked, [&button, relayout] {
        auto *dialog = new UpdateDialog();

        auto globalPoint = button.mapToGlobal(
            QPoint(int(-100 * button.scale()), button.height()));

        // Make sure that update dialog will not go off left edge of screen
        if (globalPoint.x() < 0)
        {
            globalPoint.setX(0);
        }

        dialog->moveTo(globalPoint, widgets::BoundsChecking::DesiredPosition);
        dialog->show();
        dialog->raise();

        // We can safely ignore the signal connection because the dialog will always
        // be destroyed before the button is destroyed, since it is destroyed on focus loss
        //
        // The button is either attached to a Notebook, or a Window frame
        std::ignore =
            dialog->buttonClicked.connect([&button, relayout](auto buttonType) {
                switch (buttonType)
                {
                    case UpdateDialog::Dismiss: {
                        button.hide();
                        relayout();
                    }
                    break;
                    case UpdateDialog::Install: {
                        getApp()->getUpdates().installUpdates();
                    }
                    break;
                }
            });

        //        handle.reset(dialog);
        //        dialog->closing.connect([&handle] { handle.release(); });
    });

    // update image when state changes
    auto updateChange = [&button, relayout](auto) {
        button.setVisible(getApp()->getUpdates().shouldShowUpdateButton());

        const auto *imageUrl = getApp()->getUpdates().isError()
                                   ? ":/buttons/updateError.png"
                                   : ":/buttons/update.png";
        button.setPixmap(QPixmap(imageUrl));

        relayout();
    };

    updateChange(getApp()->getUpdates().getStatus());

    signalHolder.managedConnect(getApp()->getUpdates().statusUpdated,
                                [updateChange](auto status) {
                                    updateChange(status);
                                });
}

}  // namespace chatterino
