import { BaseCore as InternalCore, IDiagnosticLogger, INotificationManager, IPlugin, ITelemetryItem } from "@microsoft/applicationinsights-core-js";
import { IExtendedAppInsightsCore, IExtendedConfiguration, IExtendedTelemetryItem } from "./DataModels";
export default class BaseCore extends InternalCore implements IExtendedAppInsightsCore {
    getWParam: () => number;
    constructor();
    /**
     * Initialize the sdk.
     * @param config - The configuration to initialize the SDK.
     * @param extensions - An array of extensions that are to be used by the core.
     */
    initialize(config: IExtendedConfiguration, extensions: IPlugin[], logger?: IDiagnosticLogger, notificationManager?: INotificationManager): void;
    track(item: IExtendedTelemetryItem | ITelemetryItem): void;
}
