/**
* KillSwitch.ts
* @author Abhilash Panwar (abpanwar)
* @copyright Microsoft 2018
*/
/**
* Class to stop certain tenants sending events.
*/
export default class KillSwitch {
    constructor();
    /**
     * Set the tenants that are to be killed along with the duration. If the duration is
     * a special value identifying that the tokens are too be killed for only this request, then
     * a array of tokens is returned.
     * @param killedTokens - Tokens that are too be marked to be killed.
     * @param killDuration - The duration for which the tokens are to be killed.
     * @returns The tokens that are killed only for this given request.
     */
    setKillSwitchTenants(killTokens: string, killDuration: string): string[];
    /**
     * Determing if the given tenant token has been killed for the moment.
     * @param tenantToken - The token to be checked.
     * @returns True if token has been killed, false otherwise.
     */
    isTenantKilled(tenantToken: string): boolean;
}
