import { ExperimentationServiceBase } from './ExperimentationServiceBase';
import { IExperimentationTelemetry } from '../contracts/IExperimentationTelemetry';
import { IExperimentationFilterProvider } from '../contracts/IExperimentationFilterProvider';
import { IKeyValueStorage } from '../contracts/IKeyValueStorage';
import { FeatureData } from './FeatureProvider/IFeatureProvider';
/**
 * Implementation of Feature provider that provides a polling feature, where the source can be re-fetched every x time given.
 */
export declare abstract class ExperimentationServiceAutoPolling extends ExperimentationServiceBase {
    protected telemetry: IExperimentationTelemetry;
    protected filterProviders: IExperimentationFilterProvider[];
    protected refreshRateMs: number;
    protected assignmentContextTelemetryPropertyName: string;
    protected telemetryEventName: string;
    protected storageKey?: string | undefined;
    protected storage?: IKeyValueStorage | undefined;
    private pollingService?;
    constructor(telemetry: IExperimentationTelemetry, filterProviders: IExperimentationFilterProvider[], refreshRateMs: number, assignmentContextTelemetryPropertyName: string, telemetryEventName: string, storageKey?: string | undefined, storage?: IKeyValueStorage | undefined);
    protected init(): void;
    /**
     * Wrapper that will reset the polling intervals whenever the feature data is fetched manually.
     */
    protected getFeaturesAsync(overrideInMemoryFeatures?: boolean): Promise<FeatureData>;
}
