"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getObservableMapValues = exports.getObservableMapKeys = exports.$try = exports.isBool = exports.hasFiles = exports.isEvent = exports.uniqueId = exports.maxKey = exports.hasIntKeys = exports.parseIntKeys = exports.allowNested = exports.hasSeparatedProps = exports.hasUnifiedProps = exports.isArrayFromStruct = exports.pathToStruct = exports.isArrayOfObjects = exports.isEmptyArray = exports.isArrayOfStrings = exports.throwError = exports.allowedProps = exports.hasProps = exports.checkPropOccurrence = exports.checkObserve = exports.props = void 0;
const lodash_1 = __importDefault(require("lodash"));
const mobx_1 = require("mobx");
const FieldProps_1 = require("./models/FieldProps");
const props_1 = require("./props");
Object.defineProperty(exports, "props", { enumerable: true, get: function () { return props_1.props; } });
const getObservableMapValues = (observableMap) => (0, mobx_1.values)(observableMap);
exports.getObservableMapValues = getObservableMapValues;
const getObservableMapKeys = (observableMap) => (0, mobx_1.keys)(observableMap);
exports.getObservableMapKeys = getObservableMapKeys;
const checkObserveItem = (change) => ({ key, to, type, exec }) => change.type === type &&
    change.name === key &&
    change.newValue === to &&
    exec.apply(change, [change]);
const checkObserve = (collection) => (change) => collection.map(checkObserveItem(change));
exports.checkObserve = checkObserve;
const checkPropOccurrence = ({ type, data }) => {
    let $check;
    switch (type) {
        case FieldProps_1.FieldPropsOccurrence.some:
            $check = ($data) => lodash_1.default.some($data, Boolean);
            break;
        case FieldProps_1.FieldPropsOccurrence.every:
            $check = ($data) => lodash_1.default.every($data, Boolean);
            break;
        default: throw new Error('Occurrence not found for specified prop');
    }
    return $check(data);
};
exports.checkPropOccurrence = checkPropOccurrence;
const hasProps = ($type, $data) => {
    let $props;
    switch ($type) {
        case FieldProps_1.AllowedFieldPropsTypes.computed:
            $props = props_1.props.computed;
            break;
        case FieldProps_1.AllowedFieldPropsTypes.observable:
            $props = [
                FieldProps_1.FieldPropsEnum.fields,
                ...props_1.props.computed,
                ...props_1.props.editable,
            ];
            break;
        case FieldProps_1.AllowedFieldPropsTypes.editable:
            $props = [
                ...props_1.props.editable,
                ...props_1.props.validation,
                ...props_1.props.functions,
                ...props_1.props.handlers,
            ];
            break;
        case FieldProps_1.AllowedFieldPropsTypes.all:
            $props = [
                FieldProps_1.FieldPropsEnum.id,
                FieldProps_1.FieldPropsEnum.key,
                FieldProps_1.FieldPropsEnum.name,
                FieldProps_1.FieldPropsEnum.path,
                ...props_1.props.computed,
                ...props_1.props.editable,
                ...props_1.props.validation,
                ...props_1.props.functions,
                ...props_1.props.handlers,
            ];
            break;
        default:
            $props = null;
    }
    return lodash_1.default.intersection($data, $props).length > 0;
};
exports.hasProps = hasProps;
/**
  Check Allowed Properties
*/
const allowedProps = (type, data) => {
    if (hasProps(type, data))
        return;
    const $msg = "The selected property is not allowed";
    throw new Error(`${$msg} (${JSON.stringify(data)})`);
};
exports.allowedProps = allowedProps;
/**
  Throw Error if undefined Fields
*/
const throwError = (path, fields, msg = null) => {
    if (!lodash_1.default.isNil(fields))
        return;
    const $msg = lodash_1.default.isNil(msg) ? "The selected field is not defined" : msg;
    throw new Error(`${$msg} (${path})`);
};
exports.throwError = throwError;
const pathToStruct = (path) => {
    let struct;
    struct = lodash_1.default.replace(path, new RegExp("[.]\\d+($|.)", "g"), "[].");
    struct = lodash_1.default.replace(struct, "..", ".");
    struct = lodash_1.default.trim(struct, ".");
    return struct;
};
exports.pathToStruct = pathToStruct;
const isArrayFromStruct = (struct, structPath) => {
    if (isArrayOfStrings(struct))
        return !!struct
            .filter((s) => s.startsWith(structPath))
            .find((s) => s.substring(structPath.length) === "[]")
            || lodash_1.default.endsWith(struct === null || struct === void 0 ? void 0 : struct.find((e) => e === structPath), '[]');
    else
        return false;
};
exports.isArrayFromStruct = isArrayFromStruct;
const hasSome = (obj, keys) => lodash_1.default.some(keys, lodash_1.default.partial(lodash_1.default.has, obj));
const isEmptyArray = (field) => lodash_1.default.isEmpty(field) && Array.isArray(field);
exports.isEmptyArray = isEmptyArray;
const isArrayOfStrings = (struct) => Array.isArray(struct) && lodash_1.default.every(struct, lodash_1.default.isString);
exports.isArrayOfStrings = isArrayOfStrings;
const isArrayOfObjects = (fields) => Array.isArray(fields) && lodash_1.default.every(fields, lodash_1.default.isPlainObject);
exports.isArrayOfObjects = isArrayOfObjects;
const getKeys = (fields) => lodash_1.default.union(...lodash_1.default.map(lodash_1.default.values(fields), (values) => lodash_1.default.keys(values)));
const hasUnifiedProps = ({ fields }) => !isArrayOfStrings({ fields }) && hasProps(FieldProps_1.AllowedFieldPropsTypes.editable, getKeys(fields));
exports.hasUnifiedProps = hasUnifiedProps;
const hasSeparatedProps = (initial) => hasSome(initial, props_1.props.separated) || hasSome(initial, props_1.props.validation);
exports.hasSeparatedProps = hasSeparatedProps;
const allowNested = (field, strictProps) => lodash_1.default.isObject(field) &&
    !lodash_1.default.isDate(field) &&
    !lodash_1.default.has(field, FieldProps_1.FieldPropsEnum.fields) &&
    !lodash_1.default.has(field, FieldProps_1.FieldPropsEnum.class) &&
    (!hasSome(field, [
        ...props_1.props.editable,
        ...props_1.props.handlers,
        ...props_1.props.validation,
        ...props_1.props.functions,
    ]) || strictProps);
exports.allowNested = allowNested;
const parseIntKeys = (fields) => lodash_1.default.map(getObservableMapKeys(fields), lodash_1.default.ary(lodash_1.default.toNumber, 1));
exports.parseIntKeys = parseIntKeys;
const hasIntKeys = (fields) => lodash_1.default.every(parseIntKeys(fields), lodash_1.default.isInteger);
exports.hasIntKeys = hasIntKeys;
const maxKey = (fields) => {
    const max = lodash_1.default.max(parseIntKeys(fields));
    return lodash_1.default.isUndefined(max) ? 0 : max + 1;
};
exports.maxKey = maxKey;
const uniqueId = (field) => lodash_1.default.uniqueId([lodash_1.default.replace(field.path, new RegExp("\\.", "g"), "-"), "--"].join(""));
exports.uniqueId = uniqueId;
const isEvent = (obj) => {
    if (lodash_1.default.isNil(obj) || typeof Event === "undefined")
        return false;
    return obj instanceof Event || !lodash_1.default.isNil(obj.target);
};
exports.isEvent = isEvent;
const hasFiles = ($) => $.target.files && $.target.files.length !== 0;
exports.hasFiles = hasFiles;
const isBool = ($, val) => lodash_1.default.isBoolean(val) && lodash_1.default.isBoolean($.target.checked);
exports.isBool = isBool;
const $try = (...args) => {
    let found = null;
    args.map((val) => found === null && !lodash_1.default.isUndefined(val) && (found = val));
    return found;
};
exports.$try = $try;
//# sourceMappingURL=utils.js.map