/*
 * Decompiled with CFR 0.152.
 */
package apdu4j.core;

import apdu4j.core.AsynchronousBIBO;
import apdu4j.core.SmartCardAppListener;
import apdu4j.core.TagRemovedException;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;

public abstract class SmartCardAppFutures
implements SmartCardAppListener,
AsynchronousBIBO {
    private volatile AsynchronousBIBO transport;
    private volatile CompletableFuture<byte[]> responseFuture;
    private AtomicReference<CompletableFuture<Map<String, Object>>> cardPresentFuture = new AtomicReference(new CompletableFuture());
    private AtomicReference<CompletableFuture<Void>> cardRemovedFuture = new AtomicReference(new CompletableFuture());

    @Override
    public CompletableFuture<byte[]> transmit(byte[] apdu) {
        if (this.transport == null) {
            throw new IllegalStateException("No transport available yet!");
        }
        if (this.responseFuture != null && !this.responseFuture.isDone()) {
            throw new IllegalStateException("Last transmit not completed yet!");
        }
        this.responseFuture = this.transport.transmit(apdu);
        return this.responseFuture;
    }

    public CompletableFuture<Map<String, Object>> getCardPresentFuture() {
        return this.cardPresentFuture.get();
    }

    public CompletableFuture<Map<String, Object>> waitForCard(TimeUnit unit, long duration) {
        return this.cardPresentFuture.get().orTimeout(duration, unit);
    }

    @Override
    public void close() {
        this.transport.close();
    }

    @Override
    public CompletableFuture<SmartCardAppListener.AppParameters> onStart(String[] argv) {
        return CompletableFuture.completedFuture(new SmartCardAppListener.AppParameters());
    }

    @Override
    public void onCardPresent(AsynchronousBIBO transport, SmartCardAppListener.CardData props) {
        this.transport = transport;
        this.cardPresentFuture.get().complete(props);
    }

    @Override
    public void onCardRemoved() {
        if (this.responseFuture != null) {
            this.responseFuture.completeExceptionally(new TagRemovedException("onCardRemoved"));
        }
        CompletableFuture newCardPresentFuture = new CompletableFuture();
        CompletableFuture newCardRemovedFuture = new CompletableFuture();
        CompletableFuture<Void> crf = this.cardRemovedFuture.get();
        CompletableFuture<Map<String, Object>> cpf = this.cardPresentFuture.get();
        if (this.cardRemovedFuture.compareAndSet(crf, newCardRemovedFuture) && this.cardPresentFuture.compareAndSet(cpf, newCardPresentFuture)) {
            crf.complete(null);
        } else {
            this.onError(new IllegalStateException("futures messed up on card removal"));
        }
    }

    @Override
    public void onError(Throwable e) {
        this.cardPresentFuture.get().completeExceptionally(e);
        this.cardRemovedFuture.get().completeExceptionally(e);
        if (this.responseFuture != null) {
            this.responseFuture.completeExceptionally(e);
        }
    }
}

