/*
 * Decompiled with CFR 0.152.
 */
package pro.javacard.pace;

import apdu4j.core.BIBO;
import apdu4j.core.BIBOException;
import apdu4j.core.CommandAPDU;
import apdu4j.core.HexUtils;
import apdu4j.core.ResponseAPDU;
import com.payneteasy.tlv.BerTag;
import com.payneteasy.tlv.BerTlv;
import com.payneteasy.tlv.BerTlvBuilder;
import com.payneteasy.tlv.BerTlvParser;
import com.payneteasy.tlv.BerTlvs;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pro.javacard.pace.PACE;
import pro.javacard.pace.SecureChannelException;

public final class AESSecureChannel
implements BIBO {
    private static final Logger log = LoggerFactory.getLogger(AESSecureChannel.class);
    private final byte[] ssc;
    private final byte[] mac_key;
    private final byte[] enc_key;
    final BIBO channel;

    public AESSecureChannel(byte[] enc, byte[] mac, BIBO channel) {
        this.enc_key = (byte[])enc.clone();
        this.mac_key = (byte[])mac.clone();
        this.ssc = new byte[16];
        this.channel = channel;
    }

    public CommandAPDU wrap(CommandAPDU apdu) throws GeneralSecurityException, IOException {
        byte[] newdata;
        log.debug("CommandAPDU  : {}", (Object)HexUtils.bin2hex(apdu.getBytes()));
        AESSecureChannel.buffer_increment(this.ssc);
        log.trace("Command SSC  : {}", (Object)HexUtils.bin2hex(this.ssc));
        byte[] iv = AESSecureChannel.encrypt(this.enc_key, new byte[16], this.ssc);
        log.trace("IV           : {}", (Object)HexUtils.bin2hex(iv));
        int cla = apdu.getCLA() | 0xC;
        int ins = apdu.getINS();
        int p1 = apdu.getP1();
        int p2 = apdu.getP2();
        ByteArrayOutputStream macinput = new ByteArrayOutputStream();
        macinput.write(this.ssc);
        ByteArrayOutputStream header = new ByteArrayOutputStream();
        header.write(cla);
        header.write(ins);
        header.write(p1);
        header.write(p2);
        macinput.write(AESSecureChannel.pad80(header.toByteArray(), 16));
        if (apdu.getData().length > 0) {
            byte[] plaintext = AESSecureChannel.pad80(apdu.getData(), 16);
            log.trace("ENC payload  : {}", (Object)HexUtils.bin2hex(plaintext));
            byte[] cgram = AESSecureChannel.encrypt(this.enc_key, iv, plaintext);
            newdata = AESSecureChannel.concatenate({-121, (byte)(cgram.length + 1), 1}, cgram);
            log.trace("New payload  : {}", (Object)HexUtils.bin2hex(newdata));
            macinput.write(AESSecureChannel.pad80(AESSecureChannel.concatenate(newdata, {-105, 1, (byte)apdu.getNe()}), 16));
        } else {
            newdata = new byte[]{};
            macinput.write(AESSecureChannel.pad80(new byte[]{-105, 1, (byte)apdu.getNe()}, 16));
        }
        log.trace("MAC input    : {}", (Object)HexUtils.bin2hex(macinput.toByteArray()));
        byte[] mac = PACE.aes_mac8(this.mac_key, macinput.toByteArray());
        log.trace("Calculated MAC: {}", (Object)HexUtils.bin2hex(mac));
        ByteArrayOutputStream payload = new ByteArrayOutputStream();
        if (apdu.getData().length > 0) {
            payload.write(newdata);
        }
        payload.write(new byte[]{-105, 1, (byte)apdu.getNe()});
        payload.write(142);
        payload.write(mac.length);
        payload.write(mac);
        return new CommandAPDU(cla, ins, p1, p2, payload.toByteArray(), 256);
    }

    public ResponseAPDU unwrap(ResponseAPDU apdu) throws SecureChannelException, IOException, GeneralSecurityException {
        BerTlv mactag;
        BerTlv swtag;
        if (apdu.getSW() == 27015) {
            throw new SecureChannelException("Expected Secure Messaging data objects are missing");
        }
        if (apdu.getSW() == 27016) {
            throw new SecureChannelException("Secure Messaging data objects are incorrect");
        }
        AESSecureChannel.buffer_increment(this.ssc);
        log.trace("Response SSC  : {}", (Object)HexUtils.bin2hex(this.ssc));
        ByteArrayOutputStream fresh = new ByteArrayOutputStream();
        ByteArrayOutputStream macinput = new ByteArrayOutputStream();
        macinput.write(this.ssc);
        byte[] cardmac = null;
        BerTlvParser parser = new BerTlvParser();
        BerTlvs tlvs = parser.parse(apdu.getData());
        BerTlv payloadtag = tlvs.find(new BerTag(135));
        if (payloadtag != null) {
            byte[] iv = AESSecureChannel.encrypt(this.enc_key, new byte[16], this.ssc);
            log.trace("IV           : {}", (Object)HexUtils.bin2hex(iv));
            byte[] payload = payloadtag.getBytesValue();
            byte[] cgram = Arrays.copyOfRange(payload, 1, payload.length);
            log.trace("cgram        : {}", (Object)HexUtils.bin2hex(cgram));
            byte[] plaintext = AESSecureChannel.decrypt(this.enc_key, iv, cgram);
            log.trace("plaintext    : {}", (Object)HexUtils.bin2hex(plaintext));
            fresh.write(AESSecureChannel.unpad80(plaintext));
            macinput.write(new BerTlvBuilder().addBytes(new BerTag(135), payload).buildArray());
        }
        if ((swtag = tlvs.find(new BerTag(153))) != null) {
            macinput.write(new BerTlvBuilder().addBytes(new BerTag(153), swtag.getBytesValue()).buildArray());
            fresh.write(swtag.getBytesValue());
        }
        if ((mactag = tlvs.find(new BerTag(142))) != null) {
            cardmac = mactag.getBytesValue();
        }
        byte[] mac = PACE.aes_mac8(this.mac_key, AESSecureChannel.pad80(macinput.toByteArray(), 16));
        log.trace("Our mac       : {}", (Object)HexUtils.bin2hex(mac));
        if (!Arrays.equals(cardmac, mac)) {
            throw new SecureChannelException("Secure channel response MAC failed");
        }
        byte[] responseapdu = fresh.toByteArray();
        log.debug("ResponseAPDU : {}", (Object)HexUtils.bin2hex(responseapdu));
        return new ResponseAPDU(responseapdu);
    }

    public static byte[] pad80(byte[] text, int blocksize) {
        int total = (text.length / blocksize + 1) * blocksize;
        byte[] result = Arrays.copyOfRange(text, 0, total);
        result[text.length] = -128;
        return result;
    }

    public static byte[] unpad80(byte[] buffer) throws BadPaddingException {
        int offset;
        if (buffer.length < 1) {
            throw new BadPaddingException("Invalid ISO 7816-4 padding");
        }
        for (offset = buffer.length - 1; offset > 0 && buffer[offset] == 0; --offset) {
        }
        if (buffer[offset] != -128) {
            throw new BadPaddingException("Invalid ISO 7816-4 padding");
        }
        return Arrays.copyOf(buffer, offset);
    }

    private static void buffer_increment(byte[] buffer, int offset, int len) {
        if (len < 1) {
            return;
        }
        for (int i = offset + len - 1; i >= offset; --i) {
            if (buffer[i] != -1) {
                int n = i;
                buffer[n] = (byte)(buffer[n] + 1);
                break;
            }
            buffer[i] = 0;
        }
    }

    public static void buffer_increment(byte[] buffer) {
        AESSecureChannel.buffer_increment(buffer, 0, buffer.length);
    }

    @Override
    public byte[] transceive(byte[] bytes) throws BIBOException {
        try {
            byte[] payload = this.wrap(new CommandAPDU(bytes)).getBytes();
            ResponseAPDU r = new ResponseAPDU(this.channel.transceive(payload));
            return this.unwrap(r).getBytes();
        }
        catch (IOException | GeneralSecurityException e) {
            throw new BIBOException("Could not wrap/unwrap: " + e.getMessage(), e);
        }
    }

    @Override
    public void close() {
        Arrays.fill(this.mac_key, (byte)0);
        Arrays.fill(this.enc_key, (byte)0);
    }

    public int getMaxTransceiveLength() {
        int chunksize = 222;
        return chunksize;
    }

    public static byte[] concatenate(byte[] ... args) {
        int length = 0;
        int pos = 0;
        for (byte[] arg : args) {
            length += arg.length;
        }
        byte[] result = new byte[length];
        for (byte[] arg : args) {
            System.arraycopy(arg, 0, result, pos, arg.length);
            pos += arg.length;
        }
        return result;
    }

    static byte[] encrypt(byte[] key, byte[] iv, byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(1, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }

    static byte[] decrypt(byte[] key, byte[] iv, byte[] data) throws GeneralSecurityException {
        Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
        cipher.init(2, (Key)new SecretKeySpec(key, "AES"), new IvParameterSpec(iv));
        return cipher.doFinal(data);
    }
}

