
module Make
          (Config : ParserConfig.CONFIG)
: sig
  
  (* The type of tokens. *)
  
  type token = Tokens.token
  
  (* This exception is raised by the monolithic API functions. *)
  
  exception Error of int
  
  (* The monolithic API. *)
  
  val stmts: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (AST.stmt)
  
  val spec: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (AST.t)
  
  val opn: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (AST.t)
  
end
