
(* The type of tokens. *)

type token = 
  | XOR
  | WHILE
  | WHEN
  | UU_WRITE
  | UU_UNPREDICTABLE_UNLESS
  | UU_UNPREDICTABLE
  | UU_UNALLOCATED
  | UU_REGISTER
  | UU_READWRITE
  | UU_POSTDECODE
  | UU_OPERATOR_TWO
  | UU_OPERATOR_ONE
  | UU_OPCODE
  | UU_NOP
  | UU_NEWMAP
  | UU_NEWEVENT
  | UU_MAP
  | UU_INSTRUCTION_SET
  | UU_INSTRUCTION
  | UU_GUARD
  | UU_FUNCTION
  | UU_FIELD
  | UU_EXECUTE
  | UU_EXCEPTIONTAKEN
  | UU_EVENT
  | UU_ENCODING
  | UU_DECODE
  | UU_CONFIG
  | UU_CONDITIONAL
  | UU_BUILTIN
  | UU_ARRAY
  | UNTIL
  | UNREACHABLE
  | UNPREDICTABLE
  | UNKNOWN
  | UNDEFINED
  | TYPEOF
  | TYPE
  | TRY
  | TO
  | THROW
  | THEN
  | STRING_LIT of (string)
  | STAR
  | SLASH
  | SEMICOLON
  | SEE
  | RPAREN
  | RETURN
  | REPEAT
  | REM
  | RECORD
  | REAL_LIT of (Q.t)
  | REAL
  | RBRACK
  | RBRACE_RBRACE
  | RBRACE
  | QUOT
  | QUALIFIER of (string)
  | PLUS_PLUS
  | PLUS_COLON
  | PLUS
  | OTHERWISE
  | OR
  | OF
  | NOT
  | MOD
  | MINUS
  | MASK_LIT of (Bitvector.mask)
  | LT_LT
  | LT_EQ
  | LT
  | LPAREN
  | LIMIT
  | LET
  | LBRACK
  | LBRACE_LBRACE
  | LBRACE
  | IS
  | INT_LIT of (Z.t)
  | INTEGER
  | INDENT
  | IN
  | IMPLIES
  | IMPLEM_DEFINED
  | IFF
  | IF
  | IDENTIFIER of (string)
  | GT_GT
  | GT_EQ
  | GT
  | FOR
  | EQ_GT
  | EQ_EQ
  | EQ
  | EOL
  | EOF
  | ENUMERATION
  | ELSIF
  | ELSE
  | DOWNTO
  | DOT_DOT
  | DOT
  | DO
  | DIV
  | DEDENT
  | DEBUG
  | CONSTRAINED_UNPRED
  | CONSTANT
  | CONFIG
  | COMMA
  | COLON
  | CATCH
  | CASE
  | CARET
  | BOOL_LIT of (bool)
  | BOOLEAN
  | BITS_LIT of (Bitvector.t)
  | BITS
  | BIT
  | BAR_BAR
  | BANG_EQ
  | BANG
  | ASSERT
  | ARRAY
  | AND
  | AMP_AMP
  | AMP

(* This exception is raised by the monolithic API functions. *)

exception Error

(* The monolithic API. *)

val spec: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (AST.t)

val opn: (Lexing.lexbuf -> token) -> Lexing.lexbuf -> (AST.t)

module MenhirInterpreter : sig
  
  (* The incremental API. *)
  
  include MenhirLib.IncrementalEngine.INCREMENTAL_ENGINE
    with type token = token
  
end

(* The entry point(s) to the incremental API. *)

module Incremental : sig
  
  val spec: Lexing.position -> (AST.t) MenhirInterpreter.checkpoint
  
  val opn: Lexing.position -> (AST.t) MenhirInterpreter.checkpoint
  
end
