# ASL code used by herd

This is only for when the architecture is `AArch64` with variant `asl`, or the
architecture is `ASL` with variant `asl+aarch64`.

## Folder content description

In those settings the following files are used. Some are generated, some are
hand-written.

### Hand-written files

Extra definitions that complete the one in the Arm ARM:

- `implementations.asl`: Extra definitions in ASLv1 to complete what is not
  defined in the Arm ARM.
- `implementations0.asl`: Extra definitions in ASLv0 to interface the ASLv1
  code in `implementations.asl` with the ASLv0 code in the Arm ARM.
- `implementations-vmsa.asl`: Extra definitions needed with the variant `vmsa`,
  i.e. when Stage 1 translation is activated.
- `physmem-std.asl`: Definition of memory accesses.
- `physmem-vmsa.asl`: Definition of memory accesses with variant `vmsa`.

Definitions that replace the ones in the Arm ARM:

- `patches.asl`: ASL definitions that replace the ones in the Arm ARM.
- `patches-vmsa.asl`: ASL definitions that replace the ones in the Arm ARM,
  needed by the variant `vmsa`.

### Generated files

Those files are automatically generated from the published machine-readable
specifications by Arm.

- `shared_pseudocode.asl`: library of ASL definitions in the Arm ARM by
  `bundler.py` with argument `--make-opns`.
- `features.asl`: definitions of ASL listing of features. This is generated by
  `build_features.py`.
- `system_registers.asl`: definitions of some system registers in ASL. This is
  generated by `bundler.py` with argument `--make-regs`.
- `aarch64/**/*.opn`: instruction pseudocode extracted from the Arm ARM by
  `bundler.py` with argument `--make-opns`.

To download the machine readable specifications and generate the files, use
`make all` (this requires an internet connection and Python>=3.9).


