/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.adapters.skins.ButtonSkin;
import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXRippler;
import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.transitions.CachedTransition;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.animation.Transition;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Insets;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.effect.DropShadow;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.CornerRadii;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Shape;
import javafx.util.Duration;

public class JFXButtonSkin
extends ButtonSkin {
    private final StackPane buttonContainer = new StackPane();
    private JFXRippler buttonRippler;
    private Transition clickedAnimation;
    private final CornerRadii defaultRadii = new CornerRadii(3.0);
    private boolean invalid = true;
    private Runnable releaseManualRippler = null;

    public JFXButtonSkin(JFXButton button) {
        super(button);
        this.buttonRippler = new JFXRippler((Node)new StackPane()){

            @Override
            protected Node getMask() {
                StackPane mask = new StackPane();
                mask.shapeProperty().bind((ObservableValue)JFXButtonSkin.this.buttonContainer.shapeProperty());
                mask.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.WHITE, JFXButtonSkin.this.buttonContainer.backgroundProperty().get() != null && JFXButtonSkin.this.buttonContainer.getBackground().getFills().size() > 0 ? ((BackgroundFill)JFXButtonSkin.this.buttonContainer.getBackground().getFills().get(0)).getRadii() : JFXButtonSkin.this.defaultRadii, JFXButtonSkin.this.buttonContainer.backgroundProperty().get() != null && JFXButtonSkin.this.buttonContainer.getBackground().getFills().size() > 0 ? ((BackgroundFill)JFXButtonSkin.this.buttonContainer.getBackground().getFills().get(0)).getInsets() : Insets.EMPTY)}), (Observable[])new Observable[]{JFXButtonSkin.this.buttonContainer.backgroundProperty()}));
                mask.resize(JFXButtonSkin.this.buttonContainer.getWidth() - JFXButtonSkin.this.buttonContainer.snappedRightInset() - JFXButtonSkin.this.buttonContainer.snappedLeftInset(), JFXButtonSkin.this.buttonContainer.getHeight() - JFXButtonSkin.this.buttonContainer.snappedBottomInset() - JFXButtonSkin.this.buttonContainer.snappedTopInset());
                return mask;
            }

            @Override
            protected void initListeners() {
                this.ripplerPane.setOnMousePressed(event -> {
                    if (JFXButtonSkin.this.releaseManualRippler != null) {
                        JFXButtonSkin.this.releaseManualRippler.run();
                    }
                    JFXButtonSkin.this.releaseManualRippler = null;
                    this.createRipple(event.getX(), event.getY());
                });
            }
        };
        ((Button)this.getSkinnable()).armedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                this.releaseManualRippler = this.buttonRippler.createManualRipple();
                if (this.clickedAnimation != null) {
                    this.clickedAnimation.setRate(1.0);
                    this.clickedAnimation.play();
                }
            } else {
                if (this.releaseManualRippler != null) {
                    this.releaseManualRippler.run();
                }
                if (this.clickedAnimation != null) {
                    this.clickedAnimation.setRate(-1.0);
                    this.clickedAnimation.play();
                }
            }
        });
        this.buttonContainer.getChildren().add((Object)this.buttonRippler);
        button.buttonTypeProperty().addListener((o, oldVal, newVal) -> this.updateButtonType((JFXButton.ButtonType)((Object)newVal)));
        button.setOnMousePressed(e -> {
            if (this.clickedAnimation != null) {
                this.clickedAnimation.setRate(1.0);
                this.clickedAnimation.play();
            }
        });
        button.setOnMouseReleased(e -> {
            if (this.clickedAnimation != null) {
                this.clickedAnimation.setRate(-1.0);
                this.clickedAnimation.play();
            }
        });
        button.focusedProperty().addListener((o, oldVal, newVal) -> {
            if (newVal.booleanValue()) {
                if (!((Button)this.getSkinnable()).isPressed()) {
                    this.buttonRippler.showOverlay();
                }
            } else {
                this.buttonRippler.hideOverlay();
            }
        });
        button.pressedProperty().addListener((o, oldVal, newVal) -> this.buttonRippler.hideOverlay());
        button.setPickOnBounds(false);
        this.buttonContainer.setPickOnBounds(false);
        this.buttonContainer.shapeProperty().bind((ObservableValue)((Button)this.getSkinnable()).shapeProperty());
        this.buttonContainer.borderProperty().bind((ObservableValue)((Button)this.getSkinnable()).borderProperty());
        this.buttonContainer.backgroundProperty().bind((ObservableValue)Bindings.createObjectBinding(() -> {
            if (button.getBackground() == null || this.isJavaDefaultBackground(button.getBackground()) || this.isJavaDefaultClickedBackground(button.getBackground())) {
                button.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, this.defaultRadii, null)}));
            }
            try {
                return new Background(new BackgroundFill[]{new BackgroundFill((Paint)(((Button)this.getSkinnable()).getBackground() != null ? ((BackgroundFill)((Button)this.getSkinnable()).getBackground().getFills().get(0)).getFill() : Color.TRANSPARENT), ((Button)this.getSkinnable()).getBackground() != null ? ((BackgroundFill)((Button)this.getSkinnable()).getBackground().getFills().get(0)).getRadii() : this.defaultRadii, Insets.EMPTY)});
            }
            catch (Exception ignored) {
                return ((Button)this.getSkinnable()).getBackground();
            }
        }, (Observable[])new Observable[]{((Button)this.getSkinnable()).backgroundProperty()}));
        button.ripplerFillProperty().addListener((o, oldVal, newVal) -> this.buttonRippler.setRipplerFill((Paint)newVal));
        if (button.getBackground() == null || this.isJavaDefaultBackground(button.getBackground())) {
            button.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)Color.TRANSPARENT, this.defaultRadii, null)}));
        }
        this.updateButtonType(button.getButtonType());
        this.updateChildren();
    }

    protected void updateChildren() {
        super.updateChildren();
        if (this.buttonContainer != null) {
            this.getChildren().add(0, (Object)this.buttonContainer);
        }
        for (int i = 1; i < this.getChildren().size(); ++i) {
            ((Node)this.getChildren().get(i)).setMouseTransparent(true);
        }
    }

    protected void layoutChildren(double x, double y, double w, double h) {
        if (this.invalid) {
            if (((JFXButton)this.getSkinnable()).getRipplerFill() == null) {
                for (int i = this.getChildren().size() - 1; i >= 1; --i) {
                    if (this.getChildren().get(i) instanceof Shape) {
                        this.buttonRippler.setRipplerFill(((Shape)this.getChildren().get(i)).getFill());
                        ((Shape)this.getChildren().get(i)).fillProperty().addListener((o, oldVal, newVal) -> this.buttonRippler.setRipplerFill((Paint)newVal));
                    } else {
                        if (!(this.getChildren().get(i) instanceof Label)) continue;
                        this.buttonRippler.setRipplerFill(((Label)this.getChildren().get(i)).getTextFill());
                        ((Label)this.getChildren().get(i)).textFillProperty().addListener((o, oldVal, newVal) -> this.buttonRippler.setRipplerFill((Paint)newVal));
                    }
                    break;
                }
            } else {
                this.buttonRippler.setRipplerFill(((JFXButton)this.getSkinnable()).getRipplerFill());
            }
            this.invalid = false;
        }
        double shift = 1.0;
        this.buttonContainer.resizeRelocate(((Button)this.getSkinnable()).getLayoutBounds().getMinX() - shift, ((Button)this.getSkinnable()).getLayoutBounds().getMinY() - shift, ((Button)this.getSkinnable()).getWidth() + 2.0 * shift, ((Button)this.getSkinnable()).getHeight() + 2.0 * shift);
        this.layoutLabelInArea(x, y, w, h);
    }

    private boolean isJavaDefaultBackground(Background background) {
        try {
            String firstFill = ((BackgroundFill)background.getFills().get(0)).getFill().toString();
            return "0xffffffba".equals(firstFill) || "0xffffffbf".equals(firstFill) || "0xffffff12".equals(firstFill) || "0xffffffbd".equals(firstFill);
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private boolean isJavaDefaultClickedBackground(Background background) {
        try {
            return "0x039ed3ff".equals(((BackgroundFill)background.getFills().get(0)).getFill().toString());
        }
        catch (Exception ignored) {
            return false;
        }
    }

    private void updateButtonType(JFXButton.ButtonType type) {
        switch (type) {
            case RAISED: {
                JFXDepthManager.setDepth((Node)this.buttonContainer, 2);
                this.clickedAnimation = new ButtonClickTransition();
                break;
            }
            default: {
                this.buttonContainer.setEffect(null);
            }
        }
    }

    private class ButtonClickTransition
    extends CachedTransition {
        public ButtonClickTransition() {
            super((Node)JFXButtonSkin.this.buttonContainer, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)((DropShadow)JFXButtonSkin.this.buttonContainer.getEffect()).radiusProperty(), (Object)JFXDepthManager.getShadowAt(2).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)JFXButtonSkin.this.buttonContainer.getEffect()).spreadProperty(), (Object)JFXDepthManager.getShadowAt(2).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)JFXButtonSkin.this.buttonContainer.getEffect()).offsetXProperty(), (Object)JFXDepthManager.getShadowAt(2).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)JFXButtonSkin.this.buttonContainer.getEffect()).offsetYProperty(), (Object)JFXDepthManager.getShadowAt(2).offsetYProperty().get(), Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)((DropShadow)JFXButtonSkin.this.buttonContainer.getEffect()).radiusProperty(), (Object)JFXDepthManager.getShadowAt(5).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)JFXButtonSkin.this.buttonContainer.getEffect()).spreadProperty(), (Object)JFXDepthManager.getShadowAt(5).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)JFXButtonSkin.this.buttonContainer.getEffect()).offsetXProperty(), (Object)JFXDepthManager.getShadowAt(5).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)JFXButtonSkin.this.buttonContainer.getEffect()).offsetYProperty(), (Object)JFXDepthManager.getShadowAt(5).offsetYProperty().get(), Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.seconds((double)0.2));
            this.setDelay(Duration.seconds((double)0.0));
        }
    }
}

