/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.mod.modrinth;

import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.jackhuang.hmcl.mod.LocalModFile;
import org.jackhuang.hmcl.mod.ModLoaderType;
import org.jackhuang.hmcl.mod.RemoteMod;
import org.jackhuang.hmcl.mod.RemoteModRepository;
import org.jackhuang.hmcl.util.DigestUtils;
import org.jackhuang.hmcl.util.Immutable;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.Pair;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.gson.JsonUtils;
import org.jackhuang.hmcl.util.io.HttpRequest;
import org.jackhuang.hmcl.util.io.NetworkUtils;
import org.jackhuang.hmcl.util.io.ResponseCodeException;
import org.jetbrains.annotations.Nullable;

public final class ModrinthRemoteModRepository
implements RemoteModRepository {
    public static final ModrinthRemoteModRepository MODS = new ModrinthRemoteModRepository("mod");
    public static final ModrinthRemoteModRepository MODPACKS = new ModrinthRemoteModRepository("modpack");
    public static final ModrinthRemoteModRepository RESOURCE_PACKS = new ModrinthRemoteModRepository("resourcepack");
    public static final ModrinthRemoteModRepository SHADER_PACKS = new ModrinthRemoteModRepository("shader");
    private static final String PREFIX = "https://api.modrinth.com";
    private final String projectType;

    private ModrinthRemoteModRepository(String projectType) {
        this.projectType = projectType;
    }

    @Override
    public RemoteModRepository.Type getType() {
        return RemoteModRepository.Type.MOD;
    }

    private static String convertSortType(RemoteModRepository.SortType sortType) {
        switch (sortType) {
            case DATE_CREATED: {
                return "newest";
            }
            case POPULARITY: 
            case NAME: 
            case AUTHOR: {
                return "relevance";
            }
            case LAST_UPDATED: {
                return "updated";
            }
            case TOTAL_DOWNLOADS: {
                return "downloads";
            }
        }
        throw new IllegalArgumentException("Unsupported sort type " + (Object)((Object)sortType));
    }

    @Override
    public RemoteModRepository.SearchResult search(String gameVersion, @Nullable RemoteModRepository.Category category, int pageOffset, int pageSize, String searchFilter, RemoteModRepository.SortType sort, RemoteModRepository.SortOrder sortOrder) throws IOException {
        ArrayList<List<String>> facets = new ArrayList<List<String>>();
        facets.add(Collections.singletonList("project_type:" + this.projectType));
        if (StringUtils.isNotBlank(gameVersion)) {
            facets.add(Collections.singletonList("versions:" + gameVersion));
        }
        if (category != null && StringUtils.isNotBlank(category.getId())) {
            facets.add(Collections.singletonList("categories:" + category.getId()));
        }
        Map<String, String> query = Lang.mapOf(Pair.pair("query", searchFilter), Pair.pair("facets", JsonUtils.UGLY_GSON.toJson(facets)), Pair.pair("offset", Integer.toString(pageOffset * pageSize)), Pair.pair("limit", Integer.toString(pageSize)), Pair.pair("index", ModrinthRemoteModRepository.convertSortType(sort)));
        Response<ProjectSearchResult> response = HttpRequest.GET(NetworkUtils.withQuery("https://api.modrinth.com/v2/search", query)).getJson(Response.typeOf(ProjectSearchResult.class));
        return new RemoteModRepository.SearchResult(response.getHits().stream().map(ProjectSearchResult::toMod), (int)Math.ceil((double)((Response)response).totalHits / (double)pageSize));
    }

    @Override
    public Optional<RemoteMod.Version> getRemoteVersionByLocalFile(LocalModFile localModFile, Path file) throws IOException {
        String sha1 = DigestUtils.digestToString("SHA-1", file);
        try {
            ProjectVersion mod = HttpRequest.GET("https://api.modrinth.com/v2/version_file/" + sha1, Pair.pair("algorithm", "sha1")).getJson(ProjectVersion.class);
            return mod.toVersion();
        }
        catch (ResponseCodeException e) {
            if (e.getResponseCode() == 404) {
                return Optional.empty();
            }
            throw e;
        }
        catch (NoSuchFileException e) {
            return Optional.empty();
        }
    }

    @Override
    public RemoteMod getModById(String id) throws IOException {
        id = StringUtils.removePrefix(id, "local-");
        Project project = HttpRequest.GET("https://api.modrinth.com/v2/project/" + id).getJson(Project.class);
        return project.toMod();
    }

    @Override
    public RemoteMod.File getModFile(String modId, String fileId) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Stream<RemoteMod.Version> getRemoteVersionsById(String id) throws IOException {
        id = StringUtils.removePrefix(id, "local-");
        List<ProjectVersion> versions = HttpRequest.GET("https://api.modrinth.com/v2/project/" + id + "/version").getJson(JsonUtils.listTypeOf(ProjectVersion.class));
        return versions.stream().map(ProjectVersion::toVersion).flatMap(Lang::toStream);
    }

    public List<Category> getCategoriesImpl() throws IOException {
        List<Category> categories = HttpRequest.GET("https://api.modrinth.com/v2/tag/category").getJson(JsonUtils.listTypeOf(Category.class));
        return categories.stream().filter(category -> category.getProjectType().equals(this.projectType)).collect(Collectors.toList());
    }

    @Override
    public Stream<RemoteModRepository.Category> getCategories() throws IOException {
        return this.getCategoriesImpl().stream().map(Category::toCategory);
    }

    public static class Response<T> {
        private final int offset;
        private final int limit;
        @SerializedName(value="total_hits")
        private final int totalHits;
        private final List<T> hits;

        public static <T> TypeToken<Response<T>> typeOf(Class<T> responseType) {
            return TypeToken.getParameterized(Response.class, new Type[]{responseType});
        }

        public Response() {
            this(0, 0, Collections.emptyList());
        }

        public Response(int offset, int limit, List<T> hits) {
            this.offset = offset;
            this.limit = limit;
            this.totalHits = hits.size();
            this.hits = hits;
        }

        public int getOffset() {
            return this.offset;
        }

        public int getLimit() {
            return this.limit;
        }

        public int getTotalHits() {
            return this.totalHits;
        }

        public List<T> getHits() {
            return this.hits;
        }
    }

    public static class ProjectSearchResult
    implements RemoteMod.IMod {
        private final String slug;
        private final String title;
        private final String description;
        private final List<String> categories;
        @SerializedName(value="project_type")
        private final String projectType;
        private final int downloads;
        @SerializedName(value="icon_url")
        private final String iconUrl;
        @SerializedName(value="project_id")
        private final String projectId;
        private final String author;
        private final List<String> versions;
        @SerializedName(value="date_created")
        private final Instant dateCreated;
        @SerializedName(value="date_modified")
        private final Instant dateModified;
        @SerializedName(value="latest_version")
        private final String latestVersion;

        public ProjectSearchResult(String slug, String title, String description, List<String> categories, String projectType, int downloads, String iconUrl, String projectId, String author, List<String> versions, Instant dateCreated, Instant dateModified, String latestVersion) {
            this.slug = slug;
            this.title = title;
            this.description = description;
            this.categories = categories;
            this.projectType = projectType;
            this.downloads = downloads;
            this.iconUrl = iconUrl;
            this.projectId = projectId;
            this.author = author;
            this.versions = versions;
            this.dateCreated = dateCreated;
            this.dateModified = dateModified;
            this.latestVersion = latestVersion;
        }

        public String getSlug() {
            return this.slug;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public String getProjectType() {
            return this.projectType;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getAuthor() {
            return this.author;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        public Instant getDateCreated() {
            return this.dateCreated;
        }

        public Instant getDateModified() {
            return this.dateModified;
        }

        public String getLatestVersion() {
            return this.latestVersion;
        }

        @Override
        public List<RemoteMod> loadDependencies(RemoteModRepository modRepository) throws IOException {
            Set dependencies = modRepository.getRemoteVersionsById(this.getProjectId()).flatMap(version -> version.getDependencies().stream()).collect(Collectors.toSet());
            ArrayList<RemoteMod> mods = new ArrayList<RemoteMod>();
            for (RemoteMod.Dependency dependency : dependencies) {
                mods.add(dependency.load());
            }
            return mods;
        }

        @Override
        public Stream<RemoteMod.Version> loadVersions(RemoteModRepository modRepository) throws IOException {
            return modRepository.getRemoteVersionsById(this.getProjectId());
        }

        public RemoteMod toMod() {
            return new RemoteMod(this.slug, this.author, this.title, this.description, this.categories, String.format("https://modrinth.com/%s/%s", this.projectType, this.projectId), this.iconUrl, this);
        }
    }

    public static class ProjectVersionFile {
        private final Map<String, String> hashes;
        private final String url;
        private final String filename;
        private final boolean primary;
        private final int size;

        public ProjectVersionFile(Map<String, String> hashes, String url, String filename, boolean primary, int size) {
            this.hashes = hashes;
            this.url = url;
            this.filename = filename;
            this.primary = primary;
            this.size = size;
        }

        public Map<String, String> getHashes() {
            return this.hashes;
        }

        public String getUrl() {
            return this.url;
        }

        public String getFilename() {
            return this.filename;
        }

        public boolean isPrimary() {
            return this.primary;
        }

        public int getSize() {
            return this.size;
        }

        public RemoteMod.File toFile() {
            return new RemoteMod.File(this.hashes, this.url, this.filename);
        }
    }

    public static class ProjectVersion
    implements RemoteMod.IVersion {
        private static final Map<String, @Nullable RemoteMod.DependencyType> DEPENDENCY_TYPE = Lang.mapOf(Pair.pair("required", RemoteMod.DependencyType.REQUIRED), Pair.pair("optional", RemoteMod.DependencyType.OPTIONAL), Pair.pair("embedded", RemoteMod.DependencyType.EMBEDDED), Pair.pair("incompatible", RemoteMod.DependencyType.INCOMPATIBLE));
        private final String name;
        @SerializedName(value="version_number")
        private final String versionNumber;
        private final String changelog;
        private final List<Dependency> dependencies;
        @SerializedName(value="game_versions")
        private final List<String> gameVersions;
        @SerializedName(value="version_type")
        private final String versionType;
        private final List<String> loaders;
        private final boolean featured;
        private final String id;
        @SerializedName(value="project_id")
        private final String projectId;
        @SerializedName(value="author_id")
        private final String authorId;
        @SerializedName(value="date_published")
        private final Instant datePublished;
        private final int downloads;
        @SerializedName(value="changelog_url")
        private final String changelogUrl;
        private final List<ProjectVersionFile> files;

        public ProjectVersion(String name, String versionNumber, String changelog, List<Dependency> dependencies, List<String> gameVersions, String versionType, List<String> loaders, boolean featured, String id, String projectId, String authorId, Instant datePublished, int downloads, String changelogUrl, List<ProjectVersionFile> files) {
            this.name = name;
            this.versionNumber = versionNumber;
            this.changelog = changelog;
            this.dependencies = dependencies;
            this.gameVersions = gameVersions;
            this.versionType = versionType;
            this.loaders = loaders;
            this.featured = featured;
            this.id = id;
            this.projectId = projectId;
            this.authorId = authorId;
            this.datePublished = datePublished;
            this.downloads = downloads;
            this.changelogUrl = changelogUrl;
            this.files = files;
        }

        public String getName() {
            return this.name;
        }

        public String getVersionNumber() {
            return this.versionNumber;
        }

        public String getChangelog() {
            return this.changelog;
        }

        public List<Dependency> getDependencies() {
            return this.dependencies;
        }

        public List<String> getGameVersions() {
            return this.gameVersions;
        }

        public String getVersionType() {
            return this.versionType;
        }

        public List<String> getLoaders() {
            return this.loaders;
        }

        public boolean isFeatured() {
            return this.featured;
        }

        public String getId() {
            return this.id;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getAuthorId() {
            return this.authorId;
        }

        public Instant getDatePublished() {
            return this.datePublished;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getChangelogUrl() {
            return this.changelogUrl;
        }

        public List<ProjectVersionFile> getFiles() {
            return this.files;
        }

        @Override
        public RemoteMod.Type getType() {
            return RemoteMod.Type.MODRINTH;
        }

        public Optional<RemoteMod.Version> toVersion() {
            RemoteMod.VersionType type = "release".equals(this.versionType) ? RemoteMod.VersionType.Release : ("beta".equals(this.versionType) ? RemoteMod.VersionType.Beta : ("alpha".equals(this.versionType) ? RemoteMod.VersionType.Alpha : RemoteMod.VersionType.Release));
            if (this.files.size() == 0) {
                return Optional.empty();
            }
            return Optional.of(new RemoteMod.Version(this, this.projectId, this.name, this.versionNumber, this.changelog, this.datePublished, type, this.files.get(0).toFile(), this.dependencies.stream().map(dependency -> {
                if (((Dependency)dependency).projectId == null) {
                    return RemoteMod.Dependency.ofBroken();
                }
                if (!DEPENDENCY_TYPE.containsKey(((Dependency)dependency).dependencyType)) {
                    throw new IllegalStateException("Broken datas");
                }
                return RemoteMod.Dependency.ofGeneral(DEPENDENCY_TYPE.get(((Dependency)dependency).dependencyType), MODS, ((Dependency)dependency).projectId);
            }).filter(Objects::nonNull).collect(Collectors.toList()), this.gameVersions, this.loaders.stream().flatMap(loader -> {
                if ("fabric".equalsIgnoreCase((String)loader)) {
                    return Stream.of(ModLoaderType.FABRIC);
                }
                if ("forge".equalsIgnoreCase((String)loader)) {
                    return Stream.of(ModLoaderType.FORGE);
                }
                if ("neoforge".equalsIgnoreCase((String)loader)) {
                    return Stream.of(ModLoaderType.NEO_FORGED);
                }
                if ("quilt".equalsIgnoreCase((String)loader)) {
                    return Stream.of(ModLoaderType.QUILT);
                }
                if ("liteloader".equalsIgnoreCase((String)loader)) {
                    return Stream.of(ModLoaderType.LITE_LOADER);
                }
                return Stream.empty();
            }).collect(Collectors.toList())));
        }
    }

    @Immutable
    public static class Dependency {
        @SerializedName(value="version_id")
        private final String versionId;
        @SerializedName(value="project_id")
        private final String projectId;
        @SerializedName(value="dependency_type")
        private final String dependencyType;

        public Dependency(String versionId, String projectId, String dependencyType) {
            this.versionId = versionId;
            this.projectId = projectId;
            this.dependencyType = dependencyType;
        }

        public String getVersionId() {
            return this.versionId;
        }

        public String getProjectId() {
            return this.projectId;
        }

        public String getDependencyType() {
            return this.dependencyType;
        }
    }

    public static class Project
    implements RemoteMod.IMod {
        private final String slug;
        private final String title;
        private final String description;
        private final List<String> categories;
        private final String body;
        @SerializedName(value="project_type")
        private final String projectType;
        private final int downloads;
        @SerializedName(value="icon_url")
        private final String iconUrl;
        private final String id;
        private final String team;
        private final Instant published;
        private final Instant updated;
        private final List<String> versions;

        public Project(String slug, String title, String description, List<String> categories, String body, String projectType, int downloads, String iconUrl, String id, String team, Instant published, Instant updated, List<String> versions) {
            this.slug = slug;
            this.title = title;
            this.description = description;
            this.categories = categories;
            this.body = body;
            this.projectType = projectType;
            this.downloads = downloads;
            this.iconUrl = iconUrl;
            this.id = id;
            this.team = team;
            this.published = published;
            this.updated = updated;
            this.versions = versions;
        }

        public String getSlug() {
            return this.slug;
        }

        public String getTitle() {
            return this.title;
        }

        public String getDescription() {
            return this.description;
        }

        public List<String> getCategories() {
            return this.categories;
        }

        public String getBody() {
            return this.body;
        }

        public String getProjectType() {
            return this.projectType;
        }

        public int getDownloads() {
            return this.downloads;
        }

        public String getIconUrl() {
            return this.iconUrl;
        }

        public String getId() {
            return this.id;
        }

        public String getTeam() {
            return this.team;
        }

        public Instant getPublished() {
            return this.published;
        }

        public Instant getUpdated() {
            return this.updated;
        }

        public List<String> getVersions() {
            return this.versions;
        }

        @Override
        public List<RemoteMod> loadDependencies(RemoteModRepository modRepository) throws IOException {
            Set dependencies = modRepository.getRemoteVersionsById(this.getId()).flatMap(version -> version.getDependencies().stream()).collect(Collectors.toSet());
            ArrayList<RemoteMod> mods = new ArrayList<RemoteMod>();
            for (RemoteMod.Dependency dependency : dependencies) {
                mods.add(dependency.load());
            }
            return mods;
        }

        @Override
        public Stream<RemoteMod.Version> loadVersions(RemoteModRepository modRepository) throws IOException {
            return modRepository.getRemoteVersionsById(this.getId());
        }

        public RemoteMod toMod() {
            return new RemoteMod(this.slug, "", this.title, this.description, this.categories, String.format("https://modrinth.com/%s/%s", this.projectType, this.id), this.iconUrl, this);
        }
    }

    public static class Category {
        private final String icon;
        private final String name;
        @SerializedName(value="project_type")
        private final String projectType;

        public Category() {
            this("", "", "");
        }

        public Category(String icon, String name, String projectType) {
            this.icon = icon;
            this.name = name;
            this.projectType = projectType;
        }

        public String getIcon() {
            return this.icon;
        }

        public String getName() {
            return this.name;
        }

        public String getProjectType() {
            return this.projectType;
        }

        public RemoteModRepository.Category toCategory() {
            return new RemoteModRepository.Category(this, this.name, Collections.emptyList());
        }
    }
}

