/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.skin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import javafx.animation.AnimationTimer;
import org.jackhuang.hmcl.ui.skin.SkinAnimation;

public class SkinAnimationPlayer {
    protected final Random random = new Random();
    protected List<SkinAnimation> animations = new ArrayList<SkinAnimation>();
    protected SkinAnimation playing;
    protected boolean running;
    protected int weightedSum = 0;
    protected long lastPlayTime = -1L;
    protected long interval = 10000000000L;
    protected AnimationTimer animationTimer = new AnimationTimer(){

        public void handle(long now) {
            if (SkinAnimationPlayer.this.playing == null || !SkinAnimationPlayer.this.playing.isPlaying() && now - SkinAnimationPlayer.this.lastPlayTime > SkinAnimationPlayer.this.interval) {
                int nextAni = SkinAnimationPlayer.this.random.nextInt(SkinAnimationPlayer.this.weightedSum);
                SkinAnimation tmp = null;
                for (SkinAnimation animation : SkinAnimationPlayer.this.animations) {
                    tmp = animation;
                    if ((nextAni -= animation.getWeight()) > 0) continue;
                    break;
                }
                SkinAnimationPlayer.this.playing = tmp;
                if (SkinAnimationPlayer.this.playing == null && SkinAnimationPlayer.this.animations.size() > 0) {
                    SkinAnimationPlayer.this.playing = SkinAnimationPlayer.this.animations.get(SkinAnimationPlayer.this.animations.size() - 1);
                }
                if (SkinAnimationPlayer.this.playing != null) {
                    SkinAnimationPlayer.this.playing.playFromStart();
                    SkinAnimationPlayer.this.lastPlayTime = now;
                }
            }
        }
    };

    public int getWeightedSum() {
        return this.weightedSum;
    }

    public void setInterval(long interval) {
        this.interval = interval;
        if (interval < 1L) {
            this.animationTimer.stop();
        } else {
            this.start();
        }
    }

    public long getInterval() {
        return this.interval;
    }

    public long getLastPlayTime() {
        return this.lastPlayTime;
    }

    public boolean isRunning() {
        return this.running;
    }

    public boolean isPlaying() {
        return this.playing != null;
    }

    public SkinAnimation getPlaying() {
        return this.playing;
    }

    public void addSkinAnimation(SkinAnimation ... animations) {
        this.animations.addAll(Arrays.asList(animations));
        this.weightedSum = this.animations.stream().mapToInt(SkinAnimation::getWeight).sum();
        this.start();
    }

    public void start() {
        if (!this.running && this.weightedSum > 0 && this.interval > 0L) {
            this.animationTimer.start();
            this.running = true;
        }
    }

    public void stop() {
        if (this.running) {
            this.animationTimer.stop();
        }
        if (this.playing != null) {
            this.playing.stop();
        }
        this.running = false;
    }
}

