/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.upgrade;

import java.nio.file.Path;
import org.jackhuang.hmcl.task.FileDownloadTask;
import org.jackhuang.hmcl.upgrade.RemoteVersion;
import org.jackhuang.hmcl.util.io.NetworkUtils;

class HMCLDownloadTask
extends FileDownloadTask {
    private RemoteVersion.Type archiveFormat;

    public HMCLDownloadTask(RemoteVersion version, Path target) {
        super(NetworkUtils.toURL(version.getUrl()), target.toFile(), version.getIntegrityCheck());
        this.archiveFormat = version.getType();
    }

    @Override
    public void execute() throws Exception {
        super.execute();
        try {
            Path target = this.getFile().toPath();
            switch (this.archiveFormat) {
                case JAR: {
                    break;
                }
                default: {
                    throw new IllegalArgumentException("Unknown format: " + (Object)((Object)this.archiveFormat));
                }
            }
        }
        catch (Throwable e) {
            this.getFile().delete();
            throw e;
        }
    }
}

