/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.io.IOException;

public final class Hex {
    private static final byte[] DIGITS_LOWER = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    private static int toDigit(char ch) throws IOException {
        if (ch >= '0' && ch <= '9') {
            return ch - 48;
        }
        if (ch >= 'a' && ch <= 'f') {
            return ch - 97 + 10;
        }
        if (ch >= 'A' && ch <= 'F') {
            return ch - 65 + 10;
        }
        throw new IOException("Illegal hexadecimal character " + ch);
    }

    public static byte[] decodeHex(String str) throws IOException {
        if ((str.length() & 1) != 0) {
            throw new IOException("Odd number of characters.");
        }
        int len = str.length() >> 1;
        byte[] out = new byte[len];
        for (int i = 0; i < len; ++i) {
            int j = i << 1;
            int f = Hex.toDigit(str.charAt(j)) << 4 | Hex.toDigit(str.charAt(j + 1));
            out[i] = (byte)f;
        }
        return out;
    }

    public static String encodeHex(byte[] data) {
        int l = data.length;
        byte[] out = new byte[l << 1];
        for (int i = 0; i < l; ++i) {
            byte b = data[i];
            int j = i << 1;
            out[j] = DIGITS_LOWER[(0xF0 & b) >>> 4];
            out[j + 1] = DIGITS_LOWER[0xF & b];
        }
        return new String(out, 0, 0, out.length);
    }

    private Hex() {
    }
}

