/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.skin;

import javafx.scene.image.Image;
import javafx.scene.image.PixelReader;
import javafx.scene.image.PixelWriter;
import javafx.scene.image.WritableImage;
import org.jackhuang.hmcl.util.skin.InvalidSkinException;

public final class NormalizedSkin {
    private final Image texture;
    private final WritableImage normalizedTexture;
    private final int scale;
    private final boolean oldFormat;

    private static void copyImage(Image src, WritableImage dst, int sx, int sy, int dx, int dy, int w, int h, boolean flipHorizontal) {
        PixelReader reader = src.getPixelReader();
        PixelWriter writer = dst.getPixelWriter();
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pixel = reader.getArgb(sx + x, sy + y);
                writer.setArgb(dx + (flipHorizontal ? w - x - 1 : x), dy + y, pixel);
            }
        }
    }

    public NormalizedSkin(Image texture) throws InvalidSkinException {
        this.texture = texture;
        int w = (int)texture.getWidth();
        int h = (int)texture.getHeight();
        if (w % 64 != 0) {
            throw new InvalidSkinException("Invalid size " + w + "x" + h);
        }
        if (w == h) {
            this.oldFormat = false;
        } else if (w == h * 2) {
            this.oldFormat = true;
        } else {
            throw new InvalidSkinException("Invalid size " + w + "x" + h);
        }
        this.scale = w / 64;
        this.normalizedTexture = new WritableImage(w, w);
        NormalizedSkin.copyImage(texture, this.normalizedTexture, 0, 0, 0, 0, w, h, false);
        if (this.oldFormat) {
            this.convertOldSkin();
        }
    }

    private void convertOldSkin() {
        this.copyImageRelative(4, 16, 20, 48, 4, 4, true);
        this.copyImageRelative(8, 16, 24, 48, 4, 4, true);
        this.copyImageRelative(0, 20, 24, 52, 4, 12, true);
        this.copyImageRelative(4, 20, 20, 52, 4, 12, true);
        this.copyImageRelative(8, 20, 16, 52, 4, 12, true);
        this.copyImageRelative(12, 20, 28, 52, 4, 12, true);
        this.copyImageRelative(44, 16, 36, 48, 4, 4, true);
        this.copyImageRelative(48, 16, 40, 48, 4, 4, true);
        this.copyImageRelative(40, 20, 40, 52, 4, 12, true);
        this.copyImageRelative(44, 20, 36, 52, 4, 12, true);
        this.copyImageRelative(48, 20, 32, 52, 4, 12, true);
        this.copyImageRelative(52, 20, 44, 52, 4, 12, true);
    }

    private void copyImageRelative(int sx, int sy, int dx, int dy, int w, int h, boolean flipHorizontal) {
        NormalizedSkin.copyImage((Image)this.normalizedTexture, this.normalizedTexture, sx * this.scale, sy * this.scale, dx * this.scale, dy * this.scale, w * this.scale, h * this.scale, flipHorizontal);
    }

    public Image getOriginalTexture() {
        return this.texture;
    }

    public Image getNormalizedTexture() {
        return this.normalizedTexture;
    }

    public int getScale() {
        return this.scale;
    }

    public boolean isOldFormat() {
        return this.oldFormat;
    }

    public boolean isSlim() {
        return this.hasTransparencyRelative(50, 16, 2, 4) || this.hasTransparencyRelative(54, 20, 2, 12) || this.hasTransparencyRelative(42, 48, 2, 4) || this.hasTransparencyRelative(46, 52, 2, 12) || this.isAreaBlackRelative(50, 16, 2, 4) && this.isAreaBlackRelative(54, 20, 2, 12) && this.isAreaBlackRelative(42, 48, 2, 4) && this.isAreaBlackRelative(46, 52, 2, 12);
    }

    private boolean hasTransparencyRelative(int x0, int y0, int w, int h) {
        PixelReader reader = this.normalizedTexture.getPixelReader();
        x0 *= this.scale;
        y0 *= this.scale;
        w *= this.scale;
        h *= this.scale;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pixel = reader.getArgb(x0 + x, y0 + y);
                if (pixel >>> 24 == 255) continue;
                return true;
            }
        }
        return false;
    }

    private boolean isAreaBlackRelative(int x0, int y0, int w, int h) {
        PixelReader reader = this.normalizedTexture.getPixelReader();
        x0 *= this.scale;
        y0 *= this.scale;
        w *= this.scale;
        h *= this.scale;
        for (int y = 0; y < h; ++y) {
            for (int x = 0; x < w; ++x) {
                int pixel = reader.getArgb(x0 + x, y0 + y);
                if (pixel == -16777216) continue;
                return false;
            }
        }
        return true;
    }
}

