/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util;

import java.util.AbstractList;
import java.util.Arrays;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import org.jetbrains.annotations.Contract;

public final class CircularArrayList<E>
extends AbstractList<E>
implements RandomAccess {
    private static final int DEFAULT_CAPACITY = 10;
    private static final Object[] EMPTY_ARRAY = new Object[0];
    private Object[] elements;
    private int begin = -1;
    private int end = 0;

    public CircularArrayList() {
        this.elements = EMPTY_ARRAY;
    }

    public CircularArrayList(int initialCapacity) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("illegal initialCapacity: " + initialCapacity);
        }
        this.elements = initialCapacity == 0 ? EMPTY_ARRAY : new Object[initialCapacity];
    }

    private static int inc(int i, int capacity) {
        return i + 1 >= capacity ? 0 : i + 1;
    }

    private static int inc(int i, int distance, int capacity) {
        if ((i += distance) - capacity >= 0) {
            i -= capacity;
        }
        return i;
    }

    private static int dec(int i, int capacity) {
        return i - 1 < 0 ? capacity - 1 : i - 1;
    }

    private static int sub(int i, int distance, int capacity) {
        if ((i -= distance) < 0) {
            i += capacity;
        }
        return i;
    }

    private void grow() {
        this.grow(this.elements.length + 1);
    }

    private void grow(int minCapacity) {
        Object[] newElements;
        int oldCapacity = this.elements.length;
        int size = this.size();
        int newCapacity = CircularArrayList.newCapacity(oldCapacity, minCapacity);
        if (size == 0) {
            newElements = new Object[newCapacity];
        } else if (this.begin < this.end) {
            newElements = Arrays.copyOf(this.elements, newCapacity, Object[].class);
        } else {
            newElements = new Object[newCapacity];
            System.arraycopy(this.elements, this.begin, newElements, 0, this.elements.length - this.begin);
            System.arraycopy(this.elements, 0, newElements, this.elements.length - this.begin, this.end);
            this.begin = 0;
            this.end = size;
        }
        this.elements = newElements;
    }

    private static int newCapacity(int oldCapacity, int minCapacity) {
        return oldCapacity == 0 ? Math.max(10, minCapacity) : Math.max(Math.max(oldCapacity, minCapacity), oldCapacity + (oldCapacity >> 1));
    }

    private static void checkElementIndex(int index, int size) throws IndexOutOfBoundsException {
        if (index < 0 || index >= size) {
            CircularArrayList.checkElementIndexFailed(index, size);
        }
    }

    @Contract(value="_, _ -> fail")
    private static void checkElementIndexFailed(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size(" + size + ") < 0");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index(" + index + ") < 0");
        }
        if (index >= size) {
            throw new IndexOutOfBoundsException("index(" + index + ") >= size(" + size + ")");
        }
        throw new AssertionError();
    }

    private static void checkPositionIndex(int index, int size) throws IndexOutOfBoundsException {
        if (index < 0 || index > size) {
            CircularArrayList.checkPositionIndexFailed(index, size);
        }
    }

    @Contract(value="_, _ -> fail")
    private static void checkPositionIndexFailed(int index, int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size(" + size + ") < 0");
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException("index(" + index + ") < 0");
        }
        if (index > size) {
            throw new IndexOutOfBoundsException("index(" + index + ") > size(" + size + ")");
        }
        throw new AssertionError();
    }

    @Override
    public boolean isEmpty() {
        return this.begin == -1;
    }

    @Override
    public int size() {
        if (this.isEmpty()) {
            return 0;
        }
        if (this.begin < this.end) {
            return this.end - this.begin;
        }
        return this.elements.length - this.begin + this.end;
    }

    @Override
    public E get(int index) {
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException("Index out of range: " + index);
        }
        if (this.begin < this.end) {
            CircularArrayList.checkElementIndex(index, this.end - this.begin);
            return (E)this.elements[this.begin + index];
        }
        CircularArrayList.checkElementIndex(index, this.elements.length - this.begin + this.end);
        return (E)this.elements[CircularArrayList.inc(this.begin, index, this.elements.length)];
    }

    @Override
    public E set(int index, E element) {
        int arrayIndex;
        if (this.isEmpty()) {
            throw new IndexOutOfBoundsException();
        }
        if (this.begin < this.end) {
            CircularArrayList.checkElementIndex(index, this.end - this.begin);
            arrayIndex = this.begin + index;
        } else {
            int size = this.elements.length - this.begin + this.end;
            CircularArrayList.checkElementIndex(index, size);
            arrayIndex = CircularArrayList.inc(this.begin, index, this.elements.length);
        }
        Object oldValue = this.elements[arrayIndex];
        this.elements[arrayIndex] = element;
        return (E)oldValue;
    }

    @Override
    public void add(int index, E element) {
        if (index == 0) {
            this.addFirst(element);
            return;
        }
        int oldSize = this.size();
        if (index == oldSize) {
            this.addLast(element);
            return;
        }
        CircularArrayList.checkPositionIndex(index, oldSize);
        if (oldSize == this.elements.length) {
            this.grow();
        }
        if (this.begin < this.end) {
            int targetIndex = this.begin + index;
            if (this.end < this.elements.length) {
                System.arraycopy(this.elements, targetIndex, this.elements, targetIndex + 1, this.end - targetIndex);
                ++this.end;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, this.begin - 1, targetIndex - this.begin + 1);
                --this.begin;
            }
            this.elements[targetIndex] = element;
        } else {
            int targetIndex = CircularArrayList.inc(this.begin, index, this.elements.length);
            if (targetIndex <= this.end) {
                System.arraycopy(this.elements, targetIndex, this.elements, targetIndex + 1, this.end - targetIndex);
                this.elements[targetIndex] = element;
                ++this.end;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, this.begin - 1, targetIndex - this.begin);
                this.elements[targetIndex - 1] = element;
                --this.begin;
            }
        }
    }

    @Override
    public E remove(int index) {
        Object res;
        int oldSize = this.size();
        CircularArrayList.checkElementIndex(index, oldSize);
        if (index == 0) {
            return this.removeFirst();
        }
        if (index == oldSize - 1) {
            return this.removeLast();
        }
        if (this.begin < this.end) {
            int targetIndex = this.begin + index;
            res = this.elements[targetIndex];
            System.arraycopy(this.elements, targetIndex + 1, this.elements, targetIndex, this.end - targetIndex - 1);
            --this.end;
        } else {
            int targetIndex = CircularArrayList.inc(this.begin, index, this.elements.length);
            res = this.elements[targetIndex];
            if (targetIndex < this.end) {
                System.arraycopy(this.elements, targetIndex + 1, this.elements, targetIndex, this.end - targetIndex - 1);
                --this.end;
            } else {
                System.arraycopy(this.elements, this.begin, this.elements, this.begin + 1, targetIndex - this.begin);
                this.begin = CircularArrayList.inc(this.begin, this.elements.length);
            }
        }
        return (E)res;
    }

    @Override
    public void clear() {
        if (this.isEmpty()) {
            return;
        }
        if (this.begin < this.end) {
            Arrays.fill(this.elements, this.begin, this.end, null);
        } else {
            Arrays.fill(this.elements, 0, this.end, null);
            Arrays.fill(this.elements, this.begin, this.elements.length, null);
        }
        this.begin = -1;
        this.end = 0;
    }

    @Override
    public void addFirst(E e) {
        int oldSize = this.size();
        if (oldSize == this.elements.length) {
            this.grow();
        }
        this.begin = oldSize == 0 ? this.elements.length - 1 : CircularArrayList.dec(this.begin, this.elements.length);
        this.elements[this.begin] = e;
    }

    @Override
    public void addLast(E e) {
        int oldSize = this.size();
        if (oldSize == this.elements.length) {
            this.grow();
        }
        this.elements[this.end] = e;
        this.end = CircularArrayList.inc(this.end, this.elements.length);
        if (oldSize == 0) {
            this.begin = 0;
        }
    }

    @Override
    public E removeFirst() {
        int oldSize = this.size();
        if (oldSize == 0) {
            throw new NoSuchElementException();
        }
        Object res = this.elements[this.begin];
        this.elements[this.begin] = null;
        if (oldSize == 1) {
            this.begin = -1;
            this.end = 0;
        } else {
            this.begin = CircularArrayList.inc(this.begin, this.elements.length);
        }
        return (E)res;
    }

    @Override
    public E removeLast() {
        int oldSize = this.size();
        if (oldSize == 0) {
            throw new NoSuchElementException();
        }
        int lastIdx = CircularArrayList.dec(this.end, this.elements.length);
        Object res = this.elements[lastIdx];
        this.elements[lastIdx] = null;
        if (oldSize == 1) {
            this.begin = -1;
            this.end = 0;
        } else {
            this.end = lastIdx;
        }
        return (E)res;
    }

    @Override
    public E getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    public E getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size() - 1);
    }
}

