/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.adapters;

import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.security.AccessController;
import sun.misc.Unsafe;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class ReflectionHelper {
    private static Unsafe unsafe = null;
    private static long objectFieldOffset;

    private static void setAccessible(AccessibleObject obj) {
        unsafe.putBoolean(obj, objectFieldOffset, true);
    }

    public static <T> T invoke(Class cls, Object obj, String methodName) {
        try {
            Method method = cls.getDeclaredMethod(methodName, new Class[0]);
            MethodHandle handle = MethodHandles.privateLookupIn(cls, MethodHandles.lookup()).unreflect(method);
            return (T)handle.invokeWithArguments(obj);
        }
        catch (Throwable var4) {
            throw new InternalError(var4);
        }
    }

    public static <T> T invoke(Object obj, String methodName) {
        return ReflectionHelper.invoke(obj.getClass(), obj, methodName);
    }

    public static VarHandle getHandle(Class<?> type, String name, Class<?> handleType) {
        try {
            MethodHandles.Lookup lookup = MethodHandles.privateLookupIn(type, MethodHandles.lookup());
            return lookup.findVarHandle(type, name, handleType);
        }
        catch (IllegalAccessException | NoSuchFieldException ex) {
            return null;
        }
    }

    public static Field getField(Class cls, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            field.setAccessible(true);
            return field;
        }
        catch (Throwable var3) {
            return null;
        }
    }

    public static <T> T getFieldContent(Object obj, String fieldName) {
        return ReflectionHelper.getFieldContent(obj.getClass(), obj, fieldName);
    }

    public static <T> T getFieldContent(Class cls, Object obj, String fieldName) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            MethodHandle handle = MethodHandles.privateLookupIn(cls, MethodHandles.lookup()).unreflectGetter(field);
            return (T)handle.invokeWithArguments(obj);
        }
        catch (Throwable var4) {
            return null;
        }
    }

    public static void setFieldContent(Class cls, Object obj, String fieldName, Object content) {
        try {
            Field field = cls.getDeclaredField(fieldName);
            MethodHandle handle = MethodHandles.privateLookupIn(cls, MethodHandles.lookup()).unreflectSetter(field);
            handle.invokeWithArguments(obj, content);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void setFieldContent(Class cls, Object obj, String fieldName, Object content, Class varType) {
        try {
            ReflectionHelper.getHandle(cls, fieldName, varType).set(obj, content);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        try {
            unsafe = (Unsafe)AccessController.doPrivileged(() -> {
                Field theUnsafe = Unsafe.class.getDeclaredField("theUnsafe");
                theUnsafe.setAccessible(true);
                return (Unsafe)theUnsafe.get(null);
            });
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

