/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.auth.authlibinjector;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Optional;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactInfo;
import org.jackhuang.hmcl.auth.authlibinjector.AuthlibInjectorArtifactProvider;
import org.jackhuang.hmcl.util.io.FileUtils;
import org.jackhuang.hmcl.util.logging.Logger;

public final class AuthlibInjectorExtractor
implements AuthlibInjectorArtifactProvider {
    private final URL source;
    private final Path artifactLocation;

    public AuthlibInjectorExtractor(URL source, Path artifactLocation) {
        if (source == null) {
            throw new IllegalArgumentException("Missing authlib injector");
        }
        this.source = source;
        this.artifactLocation = artifactLocation;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AuthlibInjectorArtifactInfo getArtifactInfo() throws IOException {
        Optional<AuthlibInjectorArtifactInfo> cached = this.getArtifactInfoImmediately();
        if (cached.isPresent()) {
            return cached.get();
        }
        AuthlibInjectorExtractor authlibInjectorExtractor = this;
        synchronized (authlibInjectorExtractor) {
            cached = this.getArtifactInfoImmediately();
            if (cached.isPresent()) {
                return cached.get();
            }
            Logger.LOG.info("No local authlib-injector found, extracting");
            Files.createDirectories(this.artifactLocation.getParent(), new FileAttribute[0]);
            try (InputStream inputStream = this.source.openStream();){
                FileUtils.saveSafely(this.artifactLocation, inputStream::transferTo);
            }
            return this.getArtifactInfoImmediately().orElseThrow(() -> new IOException("Failed to extract authlib-injector artifact"));
        }
    }

    @Override
    public Optional<AuthlibInjectorArtifactInfo> getArtifactInfoImmediately() {
        if (!Files.isRegularFile(this.artifactLocation, new LinkOption[0])) {
            return Optional.empty();
        }
        try {
            return Optional.of(AuthlibInjectorArtifactInfo.from(this.artifactLocation));
        }
        catch (IOException e) {
            Logger.LOG.warning("Bad authlib-injector artifact", e);
            return Optional.empty();
        }
    }
}

