/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.game;

import java.util.regex.Pattern;
import org.jackhuang.hmcl.util.Lang;
import org.jackhuang.hmcl.util.platform.Architecture;
import org.jackhuang.hmcl.util.platform.OperatingSystem;

public final class OSRestriction {
    private final String name;
    private final String version;
    private final String arch;

    public OSRestriction() {
        this(OperatingSystem.UNKNOWN);
    }

    public OSRestriction(OperatingSystem os) {
        this(os, null);
    }

    public OSRestriction(OperatingSystem os, String version) {
        this(os, version, null);
    }

    public OSRestriction(OperatingSystem os, String version, String arch) {
        this.name = os.getMojangName();
        this.version = version;
        this.arch = arch;
    }

    public OSRestriction(String name, String version, String arch) {
        this.name = name;
        this.version = version;
        this.arch = arch;
    }

    public boolean allow() {
        OperatingSystem os;
        String[] parts;
        if (this.name != null && (parts = this.name.split("-", 3)).length == 2) {
            OperatingSystem os2 = OperatingSystem.parseOSName(parts[0]);
            Architecture arch = Architecture.parseArchName(parts[1]);
            if (os2 != OperatingSystem.UNKNOWN && arch != Architecture.UNKNOWN) {
                if (!(os2 == OperatingSystem.CURRENT_OS || os2 == OperatingSystem.LINUX && OperatingSystem.CURRENT_OS.isLinuxOrBSD())) {
                    return false;
                }
                return arch == Architecture.SYSTEM_ARCH;
            }
        }
        if (!((os = OperatingSystem.parseOSName(this.name)) == OperatingSystem.UNKNOWN || os == OperatingSystem.CURRENT_OS || os == OperatingSystem.LINUX && OperatingSystem.CURRENT_OS.isLinuxOrBSD())) {
            return false;
        }
        if (this.version != null && Lang.test(() -> !Pattern.compile(this.version).matcher(OperatingSystem.SYSTEM_VERSION.getVersion()).matches())) {
            return false;
        }
        if (this.arch != null) {
            return !Lang.test(() -> !Pattern.compile(this.arch).matcher(Architecture.SYSTEM_ARCH.getCheckedName()).matches());
        }
        return true;
    }
}

