/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.versions;

import com.jfoenix.controls.JFXCheckBox;
import com.jfoenix.controls.JFXListView;
import com.jfoenix.controls.datamodels.treetable.RecursiveTreeObject;
import java.util.List;
import javafx.beans.binding.Bindings;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.SkinBase;
import javafx.scene.input.KeyCode;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.StackPane;
import org.jackhuang.hmcl.mod.Datapack;
import org.jackhuang.hmcl.ui.Controllers;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.ToolbarListPageSkin;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.MDListCell;
import org.jackhuang.hmcl.ui.construct.SpinnerPane;
import org.jackhuang.hmcl.ui.construct.TwoLineListItem;
import org.jackhuang.hmcl.ui.versions.DatapackListPage;
import org.jackhuang.hmcl.util.Holder;
import org.jackhuang.hmcl.util.StringUtils;
import org.jackhuang.hmcl.util.i18n.I18n;

final class DatapackListPageSkin
extends SkinBase<DatapackListPage> {
    DatapackListPageSkin(DatapackListPage skinnable) {
        super((Control)skinnable);
        StackPane pane = new StackPane();
        pane.setPadding(new Insets(10.0));
        pane.getStyleClass().addAll((Object[])new String[]{"notice-pane"});
        ComponentList root = new ComponentList();
        root.getStyleClass().add((Object)"no-padding");
        JFXListView listView = new JFXListView();
        HBox toolbar = new HBox();
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.refresh"), SVG.REFRESH, skinnable::refresh));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton2(I18n.i18n("datapack.add"), SVG.ADD, skinnable::add));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton2(I18n.i18n("button.remove"), SVG.DELETE, () -> Controllers.confirm(I18n.i18n("button.remove.confirm"), I18n.i18n("button.remove"), () -> skinnable.removeSelected((ObservableList<DatapackInfoObject>)listView.getSelectionModel().getSelectedItems()), null)));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.enable"), SVG.CHECK, () -> skinnable.enableSelected((ObservableList<DatapackInfoObject>)listView.getSelectionModel().getSelectedItems())));
        toolbar.getChildren().add((Object)ToolbarListPageSkin.createToolbarButton2(I18n.i18n("mods.disable"), SVG.CLOSE, () -> skinnable.disableSelected((ObservableList<DatapackInfoObject>)listView.getSelectionModel().getSelectedItems())));
        root.getContent().add((Object)toolbar);
        SpinnerPane center = new SpinnerPane();
        ComponentList.setVgrow((Node)center, Priority.ALWAYS);
        center.getStyleClass().add((Object)"large-spinner-pane");
        center.loadingProperty().bind((ObservableValue)skinnable.loadingProperty());
        Holder lastCell = new Holder();
        listView.setCellFactory(x -> new DatapackInfoListCell(listView, (Holder<Object>)lastCell));
        listView.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        Bindings.bindContent((List)listView.getItems(), skinnable.getItems());
        FXUtils.ignoreEvent(listView, KeyEvent.KEY_PRESSED, e -> e.getCode() == KeyCode.ESCAPE);
        center.setContent((Node)listView);
        root.getContent().add((Object)center);
        pane.getChildren().setAll((Object[])new Node[]{root});
        this.getChildren().setAll((Object[])new Node[]{pane});
    }

    private static final class DatapackInfoListCell
    extends MDListCell<DatapackInfoObject> {
        final JFXCheckBox checkBox = new JFXCheckBox();
        final TwoLineListItem content = new TwoLineListItem();
        BooleanProperty booleanProperty;

        DatapackInfoListCell(JFXListView<DatapackInfoObject> listView, Holder<Object> lastCell) {
            super(listView, lastCell);
            HBox container = new HBox(8.0);
            container.setPickOnBounds(false);
            container.setAlignment(Pos.CENTER_LEFT);
            HBox.setHgrow((Node)this.content, (Priority)Priority.ALWAYS);
            this.content.setMouseTransparent(true);
            this.setSelectable();
            StackPane.setMargin((Node)container, (Insets)new Insets(8.0));
            container.getChildren().setAll((Object[])new Node[]{this.checkBox, this.content});
            this.getContainer().getChildren().setAll((Object[])new Node[]{container});
        }

        @Override
        protected void updateControl(DatapackInfoObject dataItem, boolean empty) {
            if (empty) {
                return;
            }
            this.content.setTitle(dataItem.getTitle());
            this.content.setSubtitle(dataItem.getSubtitle());
            if (this.booleanProperty != null) {
                this.checkBox.selectedProperty().unbindBidirectional((Property)this.booleanProperty);
            }
            this.booleanProperty = dataItem.active;
            this.checkBox.selectedProperty().bindBidirectional((Property)this.booleanProperty);
        }
    }

    static class DatapackInfoObject
    extends RecursiveTreeObject<DatapackInfoObject> {
        private final BooleanProperty active;
        private final Datapack.Pack packInfo;

        DatapackInfoObject(Datapack.Pack packInfo) {
            this.packInfo = packInfo;
            this.active = packInfo.activeProperty();
        }

        String getTitle() {
            return this.packInfo.getId();
        }

        String getSubtitle() {
            return StringUtils.parseColorEscapes(this.packInfo.getDescription().toString());
        }

        Datapack.Pack getPackInfo() {
            return this.packInfo;
        }
    }
}

