/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.util.i18n;

import java.util.Locale;
import java.util.regex.Pattern;
import org.jackhuang.hmcl.download.game.GameRemoteVersion;
import org.jackhuang.hmcl.util.i18n.LocaleUtils;
import org.jackhuang.hmcl.util.i18n.SupportedLocale;
import org.jackhuang.hmcl.util.i18n.translator.Translator_lzh;
import org.jackhuang.hmcl.util.versioning.GameVersionNumber;

public final class MinecraftWiki {
    private static final Pattern SNAPSHOT_PATTERN = Pattern.compile("^[0-9]{2}w[0-9]{2}.+$");

    public static String getWikiLink(SupportedLocale locale, GameRemoteVersion version) {
        String region;
        Object wikiVersion = version.getSelfVersion();
        GameVersionNumber gameVersion = GameVersionNumber.asGameVersion((String)wikiVersion);
        if (locale.getLocale().getLanguage().equals("lzh")) {
            String translatedVersion = ((String)wikiVersion).startsWith("2.0") ? "\u4e8c\u9ede\u3007" : (((String)wikiVersion).startsWith("1.0.0-rc2") ? Translator_lzh.translateGameVersion(GameVersionNumber.asGameVersion("1.0.0-rc2")) : Translator_lzh.translateGameVersion(gameVersion));
            if (translatedVersion.equals(gameVersion.toString()) || gameVersion instanceof GameVersionNumber.Old) {
                return MinecraftWiki.getWikiLink(SupportedLocale.getLocale(LocaleUtils.LOCALE_ZH_HANT), version);
            }
            if (SNAPSHOT_PATTERN.matcher((CharSequence)wikiVersion).matches()) {
                return locale.i18n("wiki.version.game.snapshot", translatedVersion);
            }
            return locale.i18n("wiki.version.game", translatedVersion);
        }
        String variantSuffix = LocaleUtils.isChinese(locale.getLocale()) ? (!"Hant".equals(LocaleUtils.getScript(locale.getLocale())) ? "?variant=zh-cn" : ((region = locale.getLocale().getCountry()).equals("HK") || region.equals("MO") ? "?variant=zh-hk" : "?variant=zh-tw")) : "";
        if (gameVersion instanceof GameVersionNumber.Release) {
            if (((String)wikiVersion).startsWith("1.0")) {
                if (((String)wikiVersion).equals("1.0")) {
                    wikiVersion = "1.0.0";
                } else if (((String)wikiVersion).startsWith("1.0.0-rc2")) {
                    wikiVersion = "1.0.0-rc2";
                }
            }
        } else {
            String lower;
            if (gameVersion instanceof GameVersionNumber.Snapshot) {
                return locale.i18n("wiki.version.game.snapshot", wikiVersion) + variantSuffix;
            }
            if (((String)wikiVersion).length() >= 6 && ((String)wikiVersion).charAt(2) == 'w' && SNAPSHOT_PATTERN.matcher((CharSequence)wikiVersion).matches()) {
                if (((String)wikiVersion).equals("22w13oneblockatatime")) {
                    wikiVersion = "22w13oneBlockAtATime";
                }
                return locale.i18n("wiki.version.game.snapshot", wikiVersion) + variantSuffix;
            }
            switch (lower = ((String)wikiVersion).toLowerCase(Locale.ROOT)) {
                case "0.30-1": 
                case "0.30-2": 
                case "c0.30_01c": {
                    wikiVersion = "Classic_0.30";
                    break;
                }
                case "in-20100206-2103": {
                    wikiVersion = "Indev_20100206";
                    break;
                }
                case "inf-20100630-1": {
                    wikiVersion = "Infdev_20100630";
                    break;
                }
                case "inf-20100630-2": {
                    wikiVersion = "Alpha_v1.0.0";
                    break;
                }
                case "1.19_deep_dark_experimental_snapshot-1": {
                    wikiVersion = "1.19-exp1";
                    break;
                }
                case "in-20100130": {
                    wikiVersion = "Indev_0.31_20100130";
                    break;
                }
                case "b1.6-tb3": {
                    wikiVersion = "Beta_1.6_Test_Build_3";
                    break;
                }
                case "1.14_combat-212796": {
                    wikiVersion = "1.14.3_-_Combat_Test";
                    break;
                }
                case "1.14_combat-0": {
                    wikiVersion = "Combat_Test_2";
                    break;
                }
                case "1.14_combat-3": {
                    wikiVersion = "Combat_Test_3";
                    break;
                }
                case "1_15_combat-1": {
                    wikiVersion = "Combat_Test_4";
                    break;
                }
                case "1_15_combat-6": {
                    wikiVersion = "Combat_Test_5";
                    break;
                }
                case "1_16_combat-0": {
                    wikiVersion = "Combat_Test_6";
                    break;
                }
                case "1_16_combat-1": {
                    wikiVersion = "Combat_Test_7";
                    break;
                }
                case "1_16_combat-2": {
                    wikiVersion = "Combat_Test_7b";
                    break;
                }
                case "1_16_combat-3": {
                    wikiVersion = "Combat_Test_7c";
                    break;
                }
                case "1_16_combat-4": {
                    wikiVersion = "Combat_Test_8";
                    break;
                }
                case "1_16_combat-5": {
                    wikiVersion = "Combat_Test_8b";
                    break;
                }
                case "1_16_combat-6": {
                    wikiVersion = "Combat_Test_8c";
                    break;
                }
                default: {
                    if (lower.startsWith("2.0")) {
                        wikiVersion = "2.0";
                        break;
                    }
                    if (lower.startsWith("b1.8-pre1")) {
                        wikiVersion = "Beta_1.8-pre1";
                        break;
                    }
                    if (lower.startsWith("b1.1-")) {
                        wikiVersion = "Beta_1.1";
                        break;
                    }
                    if (lower.startsWith("a1.1.0")) {
                        wikiVersion = "Alpha_v1.1.0";
                        break;
                    }
                    if (lower.startsWith("a1.0.14")) {
                        wikiVersion = "Alpha_v1.0.14";
                        break;
                    }
                    if (lower.startsWith("a1.0.13_01")) {
                        wikiVersion = "Alpha_v1.0.13_01";
                        break;
                    }
                    if (lower.startsWith("in-20100214")) {
                        wikiVersion = "Indev_20100214";
                        break;
                    }
                    if (lower.contains("experimental-snapshot")) {
                        wikiVersion = lower.replace("_experimental-snapshot-", "-exp");
                        break;
                    }
                    if (lower.startsWith("inf-")) {
                        wikiVersion = lower.replace("inf-", "Infdev_");
                        break;
                    }
                    if (lower.startsWith("in-")) {
                        wikiVersion = lower.replace("in-", "Indev_");
                        break;
                    }
                    if (lower.startsWith("rd-")) {
                        wikiVersion = "pre-Classic_" + lower;
                        break;
                    }
                    if (lower.startsWith("b")) {
                        wikiVersion = lower.replace("b", "Beta_");
                        break;
                    }
                    if (lower.startsWith("a")) {
                        wikiVersion = lower.replace("a", "Alpha_v");
                        break;
                    }
                    if (!lower.startsWith("c")) break;
                    wikiVersion = lower.replace("c", "Classic_").replace("st", "SURVIVAL_TEST");
                }
            }
        }
        return locale.i18n("wiki.version.game", wikiVersion) + variantSuffix;
    }

    private MinecraftWiki() {
    }
}

