/*
 * Decompiled with CFR 0.152.
 */
package org.jackhuang.hmcl.ui.main;

import com.jfoenix.controls.JFXButton;
import com.jfoenix.controls.JFXComboBox;
import com.jfoenix.controls.JFXRadioButton;
import java.util.Arrays;
import javafx.beans.property.Property;
import javafx.geometry.Insets;
import javafx.geometry.Pos;
import javafx.geometry.VPos;
import javafx.scene.Cursor;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.ScrollPane;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.ColumnConstraints;
import javafx.scene.layout.GridPane;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Priority;
import javafx.scene.layout.RowConstraints;
import javafx.scene.layout.StackPane;
import javafx.scene.layout.VBox;
import javafx.scene.paint.Paint;
import javafx.scene.text.Text;
import javafx.scene.text.TextAlignment;
import javafx.scene.text.TextFlow;
import org.jackhuang.hmcl.setting.ConfigHolder;
import org.jackhuang.hmcl.setting.EnumCommonDirectory;
import org.jackhuang.hmcl.setting.Theme;
import org.jackhuang.hmcl.ui.FXUtils;
import org.jackhuang.hmcl.ui.SVG;
import org.jackhuang.hmcl.ui.construct.ComponentList;
import org.jackhuang.hmcl.ui.construct.ComponentSublist;
import org.jackhuang.hmcl.ui.construct.MultiFileItem;
import org.jackhuang.hmcl.ui.construct.OptionToggleButton;
import org.jackhuang.hmcl.util.i18n.I18n;
import org.jackhuang.hmcl.util.i18n.SupportedLocale;
import org.jackhuang.hmcl.util.logging.Logger;

public abstract class SettingsView
extends StackPane {
    protected final JFXComboBox<SupportedLocale> cboLanguage;
    protected final OptionToggleButton disableAutoGameOptionsPane;
    protected final MultiFileItem<EnumCommonDirectory> fileCommonLocation;
    protected final ComponentSublist fileCommonLocationSublist;
    protected final Label lblUpdate;
    protected final Label lblUpdateSub;
    protected final JFXRadioButton chkUpdateStable;
    protected final JFXRadioButton chkUpdateDev;
    protected final JFXButton btnUpdate;
    protected final OptionToggleButton previewPane;
    protected final ScrollPane scroll = new ScrollPane();

    public SettingsView() {
        this.getChildren().setAll((Object[])new Node[]{this.scroll});
        this.scroll.setStyle("-fx-font-size: 14;");
        this.scroll.setFitToWidth(true);
        VBox rootPane = new VBox();
        rootPane.setPadding(new Insets(32.0, 10.0, 32.0, 10.0));
        ComponentList settingsPane = new ComponentList();
        StackPane sponsorPane = new StackPane();
        sponsorPane.setCursor(Cursor.HAND);
        FXUtils.onClicked((Node)sponsorPane, this::onSponsor);
        sponsorPane.setPadding(new Insets(8.0, 0.0, 8.0, 0.0));
        GridPane gridPane = new GridPane();
        ColumnConstraints col = new ColumnConstraints();
        col.setHgrow(Priority.SOMETIMES);
        col.setMaxWidth(Double.POSITIVE_INFINITY);
        gridPane.getColumnConstraints().setAll((Object[])new ColumnConstraints[]{col});
        RowConstraints row = new RowConstraints();
        row.setMinHeight(Double.NEGATIVE_INFINITY);
        row.setValignment(VPos.TOP);
        row.setVgrow(Priority.SOMETIMES);
        gridPane.getRowConstraints().setAll((Object[])new RowConstraints[]{row});
        Label label = new Label(I18n.i18n("sponsor.hmcl"));
        label.setWrapText(true);
        label.setTextAlignment(TextAlignment.JUSTIFY);
        GridPane.setRowIndex((Node)label, (Integer)0);
        GridPane.setColumnIndex((Node)label, (Integer)0);
        gridPane.getChildren().add((Object)label);
        sponsorPane.getChildren().setAll((Object[])new Node[]{gridPane});
        settingsPane.getContent().add((Object)sponsorPane);
        ComponentSublist updatePane = new ComponentSublist();
        updatePane.setTitle(I18n.i18n("update"));
        updatePane.setHasSubtitle(true);
        VBox headerLeft = new VBox();
        this.lblUpdate = new Label(I18n.i18n("update"));
        this.lblUpdateSub = new Label();
        this.lblUpdateSub.getStyleClass().add((Object)"subtitle-label");
        headerLeft.getChildren().setAll((Object[])new Node[]{this.lblUpdate, this.lblUpdateSub});
        updatePane.setHeaderLeft((Node)headerLeft);
        this.btnUpdate = new JFXButton();
        this.btnUpdate.setOnAction(e -> this.onUpdate());
        this.btnUpdate.getStyleClass().add((Object)"toggle-icon4");
        this.btnUpdate.setGraphic(SVG.UPDATE.createIcon((Paint)Theme.blackFill(), 20.0));
        updatePane.setHeaderRight((Node)this.btnUpdate);
        VBox content = new VBox();
        content.setSpacing(8.0);
        this.chkUpdateStable = new JFXRadioButton(I18n.i18n("update.channel.stable"));
        this.chkUpdateDev = new JFXRadioButton(I18n.i18n("update.channel.dev"));
        TextFlow noteWrapper = new TextFlow(new Node[]{new Text(I18n.i18n("update.note"))});
        VBox.setMargin((Node)noteWrapper, (Insets)new Insets(10.0, 0.0, 0.0, 0.0));
        content.getChildren().setAll((Object[])new Node[]{this.chkUpdateStable, this.chkUpdateDev, noteWrapper});
        updatePane.getContent().add((Object)content);
        settingsPane.getContent().add((Object)updatePane);
        this.previewPane = new OptionToggleButton();
        this.previewPane.setTitle(I18n.i18n("update.preview"));
        this.previewPane.selectedProperty().bindBidirectional((Property)ConfigHolder.config().acceptPreviewUpdateProperty());
        FXUtils.installFastTooltip((Node)this.previewPane, I18n.i18n("update.preview.tooltip"));
        settingsPane.getContent().add((Object)this.previewPane);
        this.fileCommonLocation = new MultiFileItem();
        this.fileCommonLocationSublist = new ComponentSublist();
        this.fileCommonLocationSublist.getContent().add(this.fileCommonLocation);
        this.fileCommonLocationSublist.setTitle(I18n.i18n("launcher.cache_directory"));
        this.fileCommonLocationSublist.setHasSubtitle(true);
        this.fileCommonLocation.loadChildren(Arrays.asList(new MultiFileItem.Option<EnumCommonDirectory>(I18n.i18n("launcher.cache_directory.default"), EnumCommonDirectory.DEFAULT), new MultiFileItem.FileOption<EnumCommonDirectory>(I18n.i18n("settings.custom"), EnumCommonDirectory.CUSTOM).setChooserTitle(I18n.i18n("launcher.cache_directory.choose")).setDirectory(true).bindBidirectional((Property<String>)ConfigHolder.config().commonDirectoryProperty())));
        JFXButton cleanButton = FXUtils.newBorderButton(I18n.i18n("launcher.cache_directory.clean"));
        cleanButton.setOnAction(e -> this.clearCacheDirectory());
        this.fileCommonLocationSublist.setHeaderRight((Node)cleanButton);
        settingsPane.getContent().add((Object)this.fileCommonLocationSublist);
        BorderPane languagePane = new BorderPane();
        Label left = new Label(I18n.i18n("settings.launcher.language"));
        BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER_LEFT);
        languagePane.setLeft((Node)left);
        SupportedLocale currentLocale = I18n.getLocale();
        this.cboLanguage = new JFXComboBox();
        this.cboLanguage.setConverter(FXUtils.stringConverter(locale -> {
            if (locale.isDefault()) {
                return locale.getDisplayName(currentLocale);
            }
            if (locale.isSameLanguage(currentLocale)) {
                return locale.getDisplayName((SupportedLocale)locale);
            }
            return locale.getDisplayName(currentLocale) + " - " + locale.getDisplayName((SupportedLocale)locale);
        }));
        FXUtils.setLimitWidth(this.cboLanguage, 300.0);
        languagePane.setRight(this.cboLanguage);
        settingsPane.getContent().add((Object)languagePane);
        this.disableAutoGameOptionsPane = new OptionToggleButton();
        this.disableAutoGameOptionsPane.setTitle(I18n.i18n("settings.launcher.disable_auto_game_options"));
        settingsPane.getContent().add((Object)this.disableAutoGameOptionsPane);
        BorderPane debugPane = new BorderPane();
        left = new Label(I18n.i18n("settings.launcher.debug"));
        BorderPane.setAlignment((Node)left, (Pos)Pos.CENTER_LEFT);
        debugPane.setLeft((Node)left);
        JFXButton openLogFolderButton = new JFXButton(I18n.i18n("settings.launcher.launcher_log.reveal"));
        openLogFolderButton.setOnAction(e -> this.openLogFolder());
        openLogFolderButton.getStyleClass().add((Object)"jfx-button-border");
        if (Logger.LOG.getLogFile() == null) {
            openLogFolderButton.setDisable(true);
        }
        JFXButton logButton = FXUtils.newBorderButton(I18n.i18n("settings.launcher.launcher_log.export"));
        logButton.setOnAction(e -> this.onExportLogs());
        HBox buttonBox = new HBox();
        buttonBox.setSpacing(10.0);
        buttonBox.getChildren().addAll((Object[])new Node[]{openLogFolderButton, logButton});
        BorderPane.setAlignment((Node)buttonBox, (Pos)Pos.CENTER_RIGHT);
        debugPane.setRight((Node)buttonBox);
        settingsPane.getContent().add((Object)debugPane);
        rootPane.getChildren().add((Object)settingsPane);
        this.scroll.setContent((Node)rootPane);
    }

    public void openLogFolder() {
        FXUtils.openFolder(Logger.LOG.getLogFile().getParent());
    }

    protected abstract void onUpdate();

    protected abstract void onExportLogs();

    protected abstract void onSponsor();

    protected abstract void clearCacheDirectory();
}

