/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal;

import java.util.ArrayList;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.eclipse.core.runtime.ILog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMethod;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.Signature;
import org.eclipse.jdt.core.dom.IMethodBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.ParameterizedType;
import org.eclipse.jdt.core.dom.SimpleType;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.TypeNameMatch;
import org.eclipse.jdt.core.search.TypeNameMatchRequestor;

public class SignatureUtils {
    public static String createSignature(Type type, SearchEngine searchEngine, IJavaSearchScope scope, IProgressMonitor monitor) {
        IType element;
        IType resolvedType;
        ITypeBinding binding = type.resolveBinding();
        if (binding != null && !binding.isRecovered()) {
            return SignatureUtils.getSignature(binding);
        }
        String simpleName = SignatureUtils.simpleName(type);
        IJavaElement iJavaElement = binding.getJavaElement();
        IType iType = resolvedType = iJavaElement instanceof IType ? (element = (IType)iJavaElement) : null;
        if (resolvedType == null || resolvedType.exists()) {
            final ArrayList types = new ArrayList();
            try {
                searchEngine.searchAllTypeNames(null, 1, simpleName.toCharArray(), 0, 0, scope, new TypeNameMatchRequestor(){

                    public void acceptTypeNameMatch(TypeNameMatch match) {
                        types.add(match.getType());
                    }
                }, 3, monitor);
            }
            catch (JavaModelException ex) {
                ILog.get().error(ex.getMessage(), (Throwable)ex);
            }
            if (types.size() == 1) {
                resolvedType = (IType)types.get(0);
            }
        }
        StringBuilder res = new StringBuilder();
        if (resolvedType != null && resolvedType.exists()) {
            res.append('L');
            res.append(resolvedType.getFullyQualifiedName());
        } else {
            res.append('Q');
            res.append(simpleName);
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            res.append('<');
            parameterized.typeArguments().stream().map(param -> SignatureUtils.createSignature(param, searchEngine, scope, monitor)).forEach(res::append);
            res.append('>');
        }
        res.append(';');
        return res.toString();
    }

    private static String simpleName(Type type) {
        if (type instanceof SimpleType) {
            SimpleType simple = (SimpleType)type;
            return simple.getName().toString();
        }
        if (type instanceof ParameterizedType) {
            ParameterizedType parameterized = (ParameterizedType)type;
            return SignatureUtils.simpleName(parameterized.getType());
        }
        return type.toString();
    }

    public static String createSignature(IType type) {
        return SignatureUtils.getSignatureForTypeKey(type.getKey());
    }

    public static char[] getSignatureChar(ITypeBinding typeBinding) {
        return SignatureUtils.getSignature(typeBinding).toCharArray();
    }

    public static String getSignature(ITypeBinding typeBinding) {
        if (typeBinding.isArray()) {
            return Signature.createArraySignature((String)SignatureUtils.getSignature(typeBinding.getComponentType()), (int)1);
        }
        if (typeBinding.isWildcardType()) {
            return Character.toString('*');
        }
        ITypeBinding[] typeBounds = typeBinding.getTypeBounds();
        if (typeBinding.isTypeVariable() || typeBinding.isWildcardType()) {
            return "T" + typeBinding.getName() + ";";
        }
        if (typeBinding.isIntersectionType()) {
            return Signature.createIntersectionTypeSignature((String[])((String[])Stream.of(typeBounds).map(SignatureUtils::getSignature).toArray(String[]::new)));
        }
        if (typeBinding.isParameterizedType()) {
            StringBuilder res = new StringBuilder(Signature.createTypeSignature((String)typeBinding.getErasure().getQualifiedName(), (boolean)true));
            res.deleteCharAt(res.length() - 1);
            return res.toString() + "<" + Stream.of(typeBinding.getTypeArguments()).map(SignatureUtils::getSignature).collect(Collectors.joining()) + ">;";
        }
        if (typeBinding.isGenericType()) {
            StringBuilder res = new StringBuilder(Signature.createTypeSignature((String)typeBinding.getErasure().getQualifiedName(), (boolean)true));
            res.deleteCharAt(res.length() - 1);
            return res.toString() + "<" + Stream.of(typeBinding.getTypeParameters()).map(SignatureUtils::getSignature).collect(Collectors.joining()) + ">;";
        }
        return SignatureUtils.getSignatureForTypeKey(typeBinding.getKey());
    }

    public static String getSignatureForTypeKey(String key) {
        String preTypeVarStrip = key.replace('/', '.').replaceFirst("(?<=\\.|L)[_$A-Za-z][_$A-Za-z0-9]*~", "");
        return preTypeVarStrip.replaceAll("L[^;<]+;:(T[^;<]+;)", "$1");
    }

    public static String getSignature(IMethodBinding methodBinding) {
        return SignatureUtils.getSignatureForMethodKey(methodBinding.getKey());
    }

    public static char[] getSignatureChar(IMethodBinding methodBinding) {
        return SignatureUtils.getSignatureForMethodKey(methodBinding.getKey()).toCharArray();
    }

    public static char[] getSignatureChar(IMethod method) {
        return SignatureUtils.getSignatureForMethodKey(method.getKey()).toCharArray();
    }

    public static String getSignatureForMethodKey(String key) {
        String fullKey = key.replace('/', '.').replace("<+Ljava.lang.Object;>", "<*>").replace("<>;", ";");
        String removeName = fullKey.substring(fullKey.indexOf(40));
        int firstException = removeName.indexOf(124);
        String exceptionRemoved = firstException > 0 ? removeName.substring(0, firstException) : removeName;
        return exceptionRemoved.replaceAll("!L[^;]+;\\{[0-9]+\\}(\\+L[^;]+;)[0-9]+;", "$1");
    }

    public static String stripTypeArgumentsFromKey(String key) {
        if (key.indexOf(">;") < 0) {
            return key;
        }
        return key.substring(0, key.lastIndexOf("<")) + "<>;";
    }

    public static boolean isNumeric(String sig) {
        return sig.equals("B") || sig.equals("C") || sig.equals("D") || sig.equals("F") || sig.equals("I") || sig.equals("J") || sig.equals("S");
    }
}

