# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: appsync
using AWS.Compat
using AWS.UUIDs

"""
    associate_api(api_id, domain_name)
    associate_api(api_id, domain_name, params::Dict{String,<:Any})

Maps an endpoint to your custom domain.

# Arguments
- `api_id`: The API ID. Private APIs can not be associated with custom domains.
- `domain_name`: The domain name.

"""
function associate_api(
    apiId, domainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/domainnames/$(domainName)/apiassociation",
        Dict{String,Any}("apiId" => apiId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_api(
    apiId,
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/domainnames/$(domainName)/apiassociation",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("apiId" => apiId), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_merged_graphql_api(merged_api_identifier, source_api_identifier)
    associate_merged_graphql_api(merged_api_identifier, source_api_identifier, params::Dict{String,<:Any})

Creates an association between a Merged API and source API using the source API's
identifier.

# Arguments
- `merged_api_identifier`: The identifier of the AppSync Merged API. This is generated by
  the AppSync service. In most cases, Merged APIs (especially in your account) only require
  the API ID value or ARN of the merged API. However, Merged APIs in other accounts
  (cross-account use cases) strictly require the full resource ARN of the merged API.
- `source_api_identifier`: The identifier of the AppSync Source API. This is generated by
  the AppSync service. In most cases, source APIs (especially in your account) only require
  the API ID value or ARN of the source API. However, source APIs from other accounts
  (cross-account use cases) strictly require the full resource ARN of the source API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description field.
- `"sourceApiAssociationConfig"`: The SourceApiAssociationConfig object data.
"""
function associate_merged_graphql_api(
    mergedApiIdentifier,
    sourceApiIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/sourceApis/$(sourceApiIdentifier)/mergedApiAssociations",
        Dict{String,Any}("mergedApiIdentifier" => mergedApiIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_merged_graphql_api(
    mergedApiIdentifier,
    sourceApiIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/sourceApis/$(sourceApiIdentifier)/mergedApiAssociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("mergedApiIdentifier" => mergedApiIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_source_graphql_api(merged_api_identifier, source_api_identifier)
    associate_source_graphql_api(merged_api_identifier, source_api_identifier, params::Dict{String,<:Any})

Creates an association between a Merged API and source API using the Merged API's
identifier.

# Arguments
- `merged_api_identifier`: The identifier of the AppSync Merged API. This is generated by
  the AppSync service. In most cases, Merged APIs (especially in your account) only require
  the API ID value or ARN of the merged API. However, Merged APIs in other accounts
  (cross-account use cases) strictly require the full resource ARN of the merged API.
- `source_api_identifier`: The identifier of the AppSync Source API. This is generated by
  the AppSync service. In most cases, source APIs (especially in your account) only require
  the API ID value or ARN of the source API. However, source APIs from other accounts
  (cross-account use cases) strictly require the full resource ARN of the source API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description field.
- `"sourceApiAssociationConfig"`: The SourceApiAssociationConfig object data.
"""
function associate_source_graphql_api(
    mergedApiIdentifier,
    sourceApiIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations",
        Dict{String,Any}("sourceApiIdentifier" => sourceApiIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_source_graphql_api(
    mergedApiIdentifier,
    sourceApiIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("sourceApiIdentifier" => sourceApiIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_api_cache(api_caching_behavior, api_id, ttl, type)
    create_api_cache(api_caching_behavior, api_id, ttl, type, params::Dict{String,<:Any})

Creates a cache for the GraphQL API.

# Arguments
- `api_caching_behavior`: Caching behavior.    FULL_REQUEST_CACHING: All requests are fully
  cached.    PER_RESOLVER_CACHING: Individual resolvers that you specify are cached.
- `api_id`: The GraphQL API ID.
- `ttl`: TTL in seconds for cache entries. Valid values are 1–3,600 seconds.
- `type`: The cache instance type. Valid values are     SMALL     MEDIUM     LARGE
  XLARGE     LARGE_2X     LARGE_4X     LARGE_8X (not available in all regions)    LARGE_12X
   Historically, instance types were identified by an EC2-style value. As of July 2020, this
  is deprecated, and the generic identifiers above should be used. The following legacy
  instance types are available, but their use is discouraged:    T2_SMALL: A t2.small
  instance type.    T2_MEDIUM: A t2.medium instance type.    R4_LARGE: A r4.large instance
  type.    R4_XLARGE: A r4.xlarge instance type.    R4_2XLARGE: A r4.2xlarge instance type.
   R4_4XLARGE: A r4.4xlarge instance type.    R4_8XLARGE: A r4.8xlarge instance type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"atRestEncryptionEnabled"`: At-rest encryption flag for cache. You cannot update this
  setting after creation.
- `"healthMetricsConfig"`: Controls how cache health metrics will be emitted to CloudWatch.
  Cache health metrics include:   NetworkBandwidthOutAllowanceExceeded: The network packets
  dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for
  diagnosing bottlenecks in a cache configuration.   EngineCPUUtilization: The CPU
  utilization (percentage) allocated to the Redis process. This is useful for diagnosing
  bottlenecks in a cache configuration.   Metrics will be recorded by API ID. You can set the
  value to ENABLED or DISABLED.
- `"transitEncryptionEnabled"`: Transit encryption flag when connecting to cache. You
  cannot update this setting after creation.
"""
function create_api_cache(
    apiCachingBehavior, apiId, ttl, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/ApiCaches",
        Dict{String,Any}(
            "apiCachingBehavior" => apiCachingBehavior, "ttl" => ttl, "type" => type
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_api_cache(
    apiCachingBehavior,
    apiId,
    ttl,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/ApiCaches",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "apiCachingBehavior" => apiCachingBehavior, "ttl" => ttl, "type" => type
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_api_key(api_id)
    create_api_key(api_id, params::Dict{String,<:Any})

Creates a unique key that you can distribute to clients who invoke your API.

# Arguments
- `api_id`: The ID for your GraphQL API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A description of the purpose of the API key.
- `"expires"`: From the creation time, the time after which the API key expires. The date
  is represented as seconds since the epoch, rounded down to the nearest hour. The default
  value for this parameter is 7 days from creation time. For more information, see .
"""
function create_api_key(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/apikeys";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_api_key(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/apikeys",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_data_source(api_id, name, type)
    create_data_source(api_id, name, type, params::Dict{String,<:Any})

Creates a DataSource object.

# Arguments
- `api_id`: The API ID for the GraphQL API for the DataSource.
- `name`: A user-supplied name for the DataSource.
- `type`: The type of the DataSource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A description of the DataSource.
- `"dynamodbConfig"`: Amazon DynamoDB settings.
- `"elasticsearchConfig"`: Amazon OpenSearch Service settings. As of September 2021, Amazon
  Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated. For
  new data sources, use CreateDataSourceRequestopenSearchServiceConfig to create an
  OpenSearch data source.
- `"eventBridgeConfig"`: Amazon EventBridge settings.
- `"httpConfig"`: HTTP endpoint settings.
- `"lambdaConfig"`: Lambda settings.
- `"metricsConfig"`: Enables or disables enhanced data source metrics for specified data
  sources. Note that metricsConfig won't be used unless the dataSourceLevelMetricsBehavior
  value is set to PER_DATA_SOURCE_METRICS. If the dataSourceLevelMetricsBehavior is set to
  FULL_REQUEST_DATA_SOURCE_METRICS instead, metricsConfig will be ignored. However, you can
  still set its value.  metricsConfig can be ENABLED or DISABLED.
- `"openSearchServiceConfig"`: Amazon OpenSearch Service settings.
- `"relationalDatabaseConfig"`: Relational database settings.
- `"serviceRoleArn"`: The Identity and Access Management (IAM) service role Amazon Resource
  Name (ARN) for the data source. The system assumes this role when accessing the data source.
"""
function create_data_source(
    apiId, name, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/datasources",
        Dict{String,Any}("name" => name, "type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_data_source(
    apiId,
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/datasources",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("name" => name, "type" => type), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_domain_name(certificate_arn, domain_name)
    create_domain_name(certificate_arn, domain_name, params::Dict{String,<:Any})

Creates a custom DomainName object.

# Arguments
- `certificate_arn`: The Amazon Resource Name (ARN) of the certificate. This can be an
  Certificate Manager (ACM) certificate or an Identity and Access Management (IAM) server
  certificate.
- `domain_name`: The domain name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A description of the DomainName.
"""
function create_domain_name(
    certificateArn, domainName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/domainnames",
        Dict{String,Any}("certificateArn" => certificateArn, "domainName" => domainName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_domain_name(
    certificateArn,
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/domainnames",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "certificateArn" => certificateArn, "domainName" => domainName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_function(api_id, data_source_name, name)
    create_function(api_id, data_source_name, name, params::Dict{String,<:Any})

Creates a Function object. A function is a reusable entity. You can use multiple functions
to compose the resolver logic.

# Arguments
- `api_id`: The GraphQL API ID.
- `data_source_name`: The Function DataSource name.
- `name`: The Function name. The function name does not have to be unique.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"code"`: The function code that contains the request and response functions. When code
  is used, the runtime is required. The runtime value must be APPSYNC_JS.
- `"description"`: The Function description.
- `"functionVersion"`: The version of the request mapping template. Currently, the
  supported value is 2018-05-29. Note that when using VTL and mapping templates, the
  functionVersion is required.
- `"maxBatchSize"`: The maximum batching size for a resolver.
- `"requestMappingTemplate"`: The Function request mapping template. Functions support only
  the 2018-05-29 version of the request mapping template.
- `"responseMappingTemplate"`: The Function response mapping template.
- `"runtime"`:
- `"syncConfig"`:
"""
function create_function(
    apiId, dataSourceName, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/functions",
        Dict{String,Any}("dataSourceName" => dataSourceName, "name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_function(
    apiId,
    dataSourceName,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/functions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("dataSourceName" => dataSourceName, "name" => name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_graphql_api(authentication_type, name)
    create_graphql_api(authentication_type, name, params::Dict{String,<:Any})

Creates a GraphqlApi object.

# Arguments
- `authentication_type`: The authentication type: API key, Identity and Access Management
  (IAM), OpenID Connect (OIDC), Amazon Cognito user pools, or Lambda.
- `name`: A user-supplied name for the GraphqlApi.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalAuthenticationProviders"`: A list of additional authentication providers for
  the GraphqlApi API.
- `"apiType"`: The value that indicates whether the GraphQL API is a standard API (GRAPHQL)
  or merged API (MERGED).
- `"enhancedMetricsConfig"`: The enhancedMetricsConfig object.
- `"introspectionConfig"`: Sets the value of the GraphQL API to enable (ENABLED) or disable
  (DISABLED) introspection. If no value is provided, the introspection configuration will be
  set to ENABLED by default. This field will produce an error if the operation attempts to
  use the introspection feature while this field is disabled. For more information about
  introspection, see GraphQL introspection.
- `"lambdaAuthorizerConfig"`: Configuration for Lambda function authorization.
- `"logConfig"`: The Amazon CloudWatch Logs configuration.
- `"mergedApiExecutionRoleArn"`: The Identity and Access Management service role ARN for a
  merged API. The AppSync service assumes this role on behalf of the Merged API to validate
  access to source APIs at runtime and to prompt the AUTO_MERGE to update the merged API
  endpoint with the source API changes automatically.
- `"openIDConnectConfig"`: The OIDC configuration.
- `"ownerContact"`: The owner contact information for an API resource. This field accepts
  any string input with a length of 0 - 256 characters.
- `"queryDepthLimit"`: The maximum depth a query can have in a single request. Depth refers
  to the amount of nested levels allowed in the body of query. The default value is 0 (or
  unspecified), which indicates there's no depth limit. If you set a limit, it can be between
  1 and 75 nested levels. This field will produce a limit error if the operation falls out of
  bounds. Note that fields can still be set to nullable or non-nullable. If a non-nullable
  field produces an error, the error will be thrown upwards to the first nullable field
  available.
- `"resolverCountLimit"`: The maximum number of resolvers that can be invoked in a single
  request. The default value is 0 (or unspecified), which will set the limit to 10000. When
  specified, the limit value can be between 1 and 10000. This field will produce a limit
  error if the operation falls out of bounds.
- `"tags"`: A TagMap object.
- `"userPoolConfig"`: The Amazon Cognito user pool configuration.
- `"visibility"`: Sets the value of the GraphQL API to public (GLOBAL) or private
  (PRIVATE). If no value is provided, the visibility will be set to GLOBAL by default. This
  value cannot be changed once the API has been created.
- `"xrayEnabled"`: A flag indicating whether to use X-Ray tracing for the GraphqlApi.
"""
function create_graphql_api(
    authenticationType, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis",
        Dict{String,Any}("authenticationType" => authenticationType, "name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_graphql_api(
    authenticationType,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "authenticationType" => authenticationType, "name" => name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_resolver(api_id, field_name, type_name)
    create_resolver(api_id, field_name, type_name, params::Dict{String,<:Any})

Creates a Resolver object. A resolver converts incoming requests into a format that a data
source can understand, and converts the data source's responses into GraphQL.

# Arguments
- `api_id`: The ID for the GraphQL API for which the resolver is being created.
- `field_name`: The name of the field to attach the resolver to.
- `type_name`: The name of the Type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cachingConfig"`: The caching configuration for the resolver.
- `"code"`: The resolver code that contains the request and response functions. When code
  is used, the runtime is required. The runtime value must be APPSYNC_JS.
- `"dataSourceName"`: The name of the data source for which the resolver is being created.
- `"kind"`: The resolver type.    UNIT: A UNIT resolver type. A UNIT resolver is the
  default resolver type. You can use a UNIT resolver to run a GraphQL query against a single
  data source.    PIPELINE: A PIPELINE resolver type. You can use a PIPELINE resolver to
  invoke a series of Function objects in a serial manner. You can use a pipeline resolver to
  run a GraphQL query against multiple data sources.
- `"maxBatchSize"`: The maximum batching size for a resolver.
- `"metricsConfig"`: Enables or disables enhanced resolver metrics for specified resolvers.
  Note that metricsConfig won't be used unless the resolverLevelMetricsBehavior value is set
  to PER_RESOLVER_METRICS. If the resolverLevelMetricsBehavior is set to
  FULL_REQUEST_RESOLVER_METRICS instead, metricsConfig will be ignored. However, you can
  still set its value.  metricsConfig can be ENABLED or DISABLED.
- `"pipelineConfig"`: The PipelineConfig.
- `"requestMappingTemplate"`: The mapping template to use for requests. A resolver uses a
  request mapping template to convert a GraphQL expression into a format that a data source
  can understand. Mapping templates are written in Apache Velocity Template Language (VTL).
  VTL request mapping templates are optional when using an Lambda data source. For all other
  data sources, VTL request and response mapping templates are required.
- `"responseMappingTemplate"`: The mapping template to use for responses from the data
  source.
- `"runtime"`:
- `"syncConfig"`: The SyncConfig for a resolver attached to a versioned data source.
"""
function create_resolver(
    apiId, fieldName, typeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers",
        Dict{String,Any}("fieldName" => fieldName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_resolver(
    apiId,
    fieldName,
    typeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("fieldName" => fieldName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_type(api_id, definition, format)
    create_type(api_id, definition, format, params::Dict{String,<:Any})

Creates a Type object.

# Arguments
- `api_id`: The API ID.
- `definition`: The type definition, in GraphQL Schema Definition Language (SDL) format.
  For more information, see the GraphQL SDL documentation.
- `format`: The type format: SDL or JSON.

"""
function create_type(
    apiId, definition, format; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/types",
        Dict{String,Any}("definition" => definition, "format" => format);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_type(
    apiId,
    definition,
    format,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/types",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("definition" => definition, "format" => format),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_api_cache(api_id)
    delete_api_cache(api_id, params::Dict{String,<:Any})

Deletes an ApiCache object.

# Arguments
- `api_id`: The API ID.

"""
function delete_api_cache(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/ApiCaches";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_api_cache(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/ApiCaches",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_api_key(api_id, id)
    delete_api_key(api_id, id, params::Dict{String,<:Any})

Deletes an API key.

# Arguments
- `api_id`: The API ID.
- `id`: The ID for the API key.

"""
function delete_api_key(apiId, id; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/apikeys/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_api_key(
    apiId,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/apikeys/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_data_source(api_id, name)
    delete_data_source(api_id, name, params::Dict{String,<:Any})

Deletes a DataSource object.

# Arguments
- `api_id`: The API ID.
- `name`: The name of the data source.

"""
function delete_data_source(apiId, name; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/datasources/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_data_source(
    apiId,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/datasources/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_domain_name(domain_name)
    delete_domain_name(domain_name, params::Dict{String,<:Any})

Deletes a custom DomainName object.

# Arguments
- `domain_name`: The domain name.

"""
function delete_domain_name(domainName; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "DELETE",
        "/v1/domainnames/$(domainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_domain_name(
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/domainnames/$(domainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_function(api_id, function_id)
    delete_function(api_id, function_id, params::Dict{String,<:Any})

Deletes a Function.

# Arguments
- `api_id`: The GraphQL API ID.
- `function_id`: The Function ID.

"""
function delete_function(
    apiId, functionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/functions/$(functionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_function(
    apiId,
    functionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/functions/$(functionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_graphql_api(api_id)
    delete_graphql_api(api_id, params::Dict{String,<:Any})

Deletes a GraphqlApi object.

# Arguments
- `api_id`: The API ID.

"""
function delete_graphql_api(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_graphql_api(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resolver(api_id, field_name, type_name)
    delete_resolver(api_id, field_name, type_name, params::Dict{String,<:Any})

Deletes a Resolver object.

# Arguments
- `api_id`: The API ID.
- `field_name`: The resolver field name.
- `type_name`: The name of the resolver type.

"""
function delete_resolver(
    apiId, fieldName, typeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers/$(fieldName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resolver(
    apiId,
    fieldName,
    typeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers/$(fieldName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_type(api_id, type_name)
    delete_type(api_id, type_name, params::Dict{String,<:Any})

Deletes a Type object.

# Arguments
- `api_id`: The API ID.
- `type_name`: The type name.

"""
function delete_type(apiId, typeName; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/types/$(typeName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_type(
    apiId,
    typeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/types/$(typeName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_api(domain_name)
    disassociate_api(domain_name, params::Dict{String,<:Any})

Removes an ApiAssociation object from a custom domain.

# Arguments
- `domain_name`: The domain name.

"""
function disassociate_api(domainName; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "DELETE",
        "/v1/domainnames/$(domainName)/apiassociation";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_api(
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/domainnames/$(domainName)/apiassociation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_merged_graphql_api(association_id, source_api_identifier)
    disassociate_merged_graphql_api(association_id, source_api_identifier, params::Dict{String,<:Any})

Deletes an association between a Merged API and source API using the source API's
identifier and the association ID.

# Arguments
- `association_id`: The ID generated by the AppSync service for the source API association.
- `source_api_identifier`: The identifier of the AppSync Source API. This is generated by
  the AppSync service. In most cases, source APIs (especially in your account) only require
  the API ID value or ARN of the source API. However, source APIs from other accounts
  (cross-account use cases) strictly require the full resource ARN of the source API.

"""
function disassociate_merged_graphql_api(
    associationId, sourceApiIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "DELETE",
        "/v1/sourceApis/$(sourceApiIdentifier)/mergedApiAssociations/$(associationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_merged_graphql_api(
    associationId,
    sourceApiIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/sourceApis/$(sourceApiIdentifier)/mergedApiAssociations/$(associationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_source_graphql_api(association_id, merged_api_identifier)
    disassociate_source_graphql_api(association_id, merged_api_identifier, params::Dict{String,<:Any})

Deletes an association between a Merged API and source API using the Merged API's
identifier and the association ID.

# Arguments
- `association_id`: The ID generated by the AppSync service for the source API association.
- `merged_api_identifier`: The identifier of the AppSync Merged API. This is generated by
  the AppSync service. In most cases, Merged APIs (especially in your account) only require
  the API ID value or ARN of the merged API. However, Merged APIs in other accounts
  (cross-account use cases) strictly require the full resource ARN of the merged API.

"""
function disassociate_source_graphql_api(
    associationId, mergedApiIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "DELETE",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_source_graphql_api(
    associationId,
    mergedApiIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    evaluate_code(code, context, runtime)
    evaluate_code(code, context, runtime, params::Dict{String,<:Any})

Evaluates the given code and returns the response. The code definition requirements depend
on the specified runtime. For APPSYNC_JS runtimes, the code defines the request and
response functions. The request function takes the incoming request after a GraphQL
operation is parsed and converts it into a request configuration for the selected data
source operation. The response function interprets responses from the data source and maps
it to the shape of the GraphQL field output type.

# Arguments
- `code`: The code definition to be evaluated. Note that code and runtime are both required
  for this action. The runtime value must be APPSYNC_JS.
- `context`: The map that holds all of the contextual information for your resolver
  invocation. A context is required for this action.
- `runtime`: The runtime to be used when evaluating the code. Currently, only the
  APPSYNC_JS runtime is supported.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"function"`: The function within the code to be evaluated. If provided, the valid values
  are request and response.
"""
function evaluate_code(
    code, context, runtime; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/dataplane-evaluatecode",
        Dict{String,Any}("code" => code, "context" => context, "runtime" => runtime);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function evaluate_code(
    code,
    context,
    runtime,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/dataplane-evaluatecode",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "code" => code, "context" => context, "runtime" => runtime
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    evaluate_mapping_template(context, template)
    evaluate_mapping_template(context, template, params::Dict{String,<:Any})

Evaluates a given template and returns the response. The mapping template can be a request
or response template. Request templates take the incoming request after a GraphQL operation
is parsed and convert it into a request configuration for the selected data source
operation. Response templates interpret responses from the data source and map it to the
shape of the GraphQL field output type. Mapping templates are written in the Apache
Velocity Template Language (VTL).

# Arguments
- `context`: The map that holds all of the contextual information for your resolver
  invocation. A context is required for this action.
- `template`: The mapping template; this can be a request or response template. A template
  is required for this action.

"""
function evaluate_mapping_template(
    context, template; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/dataplane-evaluatetemplate",
        Dict{String,Any}("context" => context, "template" => template);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function evaluate_mapping_template(
    context,
    template,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/dataplane-evaluatetemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("context" => context, "template" => template),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    flush_api_cache(api_id)
    flush_api_cache(api_id, params::Dict{String,<:Any})

Flushes an ApiCache object.

# Arguments
- `api_id`: The API ID.

"""
function flush_api_cache(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/FlushCache";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function flush_api_cache(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "DELETE",
        "/v1/apis/$(apiId)/FlushCache",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_api_association(domain_name)
    get_api_association(domain_name, params::Dict{String,<:Any})

Retrieves an ApiAssociation object.

# Arguments
- `domain_name`: The domain name.

"""
function get_api_association(domainName; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/domainnames/$(domainName)/apiassociation";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_api_association(
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/domainnames/$(domainName)/apiassociation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_api_cache(api_id)
    get_api_cache(api_id, params::Dict{String,<:Any})

Retrieves an ApiCache object.

# Arguments
- `api_id`: The API ID.

"""
function get_api_cache(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/ApiCaches";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_api_cache(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/ApiCaches",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_source(api_id, name)
    get_data_source(api_id, name, params::Dict{String,<:Any})

Retrieves a DataSource object.

# Arguments
- `api_id`: The API ID.
- `name`: The name of the data source.

"""
function get_data_source(apiId, name; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/datasources/$(name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_source(
    apiId,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/datasources/$(name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_data_source_introspection(introspection_id)
    get_data_source_introspection(introspection_id, params::Dict{String,<:Any})

Retrieves the record of an existing introspection. If the retrieval is successful, the
result of the instrospection will also be returned. If the retrieval fails the operation,
an error message will be returned instead.

# Arguments
- `introspection_id`: The introspection ID. Each introspection contains a unique ID that
  can be used to reference the instrospection record.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeModelsSDL"`: A boolean flag that determines whether SDL should be generated for
  introspected types or not. If set to true, each model will contain an sdl property that
  contains the SDL for that type. The SDL only contains the type data and no additional
  metadata or directives.
- `"maxResults"`: The maximum number of introspected types that will be returned in a
  single response.
- `"nextToken"`: Determines the number of types to be returned in a single response before
  paginating. This value is typically taken from nextToken value from the previous response.
"""
function get_data_source_introspection(
    introspectionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/datasources/introspections/$(introspectionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_data_source_introspection(
    introspectionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/datasources/introspections/$(introspectionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_domain_name(domain_name)
    get_domain_name(domain_name, params::Dict{String,<:Any})

Retrieves a custom DomainName object.

# Arguments
- `domain_name`: The domain name.

"""
function get_domain_name(domainName; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/domainnames/$(domainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_domain_name(
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/domainnames/$(domainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_function(api_id, function_id)
    get_function(api_id, function_id, params::Dict{String,<:Any})

Get a Function.

# Arguments
- `api_id`: The GraphQL API ID.
- `function_id`: The Function ID.

"""
function get_function(apiId, functionId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/functions/$(functionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_function(
    apiId,
    functionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/functions/$(functionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_graphql_api(api_id)
    get_graphql_api(api_id, params::Dict{String,<:Any})

Retrieves a GraphqlApi object.

# Arguments
- `api_id`: The API ID for the GraphQL API.

"""
function get_graphql_api(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET", "/v1/apis/$(apiId)"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function get_graphql_api(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_graphql_api_environment_variables(api_id)
    get_graphql_api_environment_variables(api_id, params::Dict{String,<:Any})

Retrieves the list of environmental variable key-value pairs associated with an API by its
ID value.

# Arguments
- `api_id`: The ID of the API from which the environmental variable list will be retrieved.

"""
function get_graphql_api_environment_variables(
    apiId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/environmentVariables";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_graphql_api_environment_variables(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/environmentVariables",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_introspection_schema(api_id, format)
    get_introspection_schema(api_id, format, params::Dict{String,<:Any})

Retrieves the introspection schema for a GraphQL API.

# Arguments
- `api_id`: The API ID.
- `format`: The schema format: SDL or JSON.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"includeDirectives"`: A flag that specifies whether the schema introspection should
  contain directives.
"""
function get_introspection_schema(
    apiId, format; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/schema",
        Dict{String,Any}("format" => format);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_introspection_schema(
    apiId,
    format,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/schema",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("format" => format), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resolver(api_id, field_name, type_name)
    get_resolver(api_id, field_name, type_name, params::Dict{String,<:Any})

Retrieves a Resolver object.

# Arguments
- `api_id`: The API ID.
- `field_name`: The resolver field name.
- `type_name`: The resolver type name.

"""
function get_resolver(
    apiId, fieldName, typeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers/$(fieldName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resolver(
    apiId,
    fieldName,
    typeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers/$(fieldName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_schema_creation_status(api_id)
    get_schema_creation_status(api_id, params::Dict{String,<:Any})

Retrieves the current status of a schema creation operation.

# Arguments
- `api_id`: The API ID.

"""
function get_schema_creation_status(
    apiId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/schemacreation";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_schema_creation_status(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/schemacreation",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_source_api_association(association_id, merged_api_identifier)
    get_source_api_association(association_id, merged_api_identifier, params::Dict{String,<:Any})

Retrieves a SourceApiAssociation object.

# Arguments
- `association_id`: The ID generated by the AppSync service for the source API association.
- `merged_api_identifier`: The identifier of the AppSync Merged API. This is generated by
  the AppSync service. In most cases, Merged APIs (especially in your account) only require
  the API ID value or ARN of the merged API. However, Merged APIs in other accounts
  (cross-account use cases) strictly require the full resource ARN of the merged API.

"""
function get_source_api_association(
    associationId, mergedApiIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_source_api_association(
    associationId,
    mergedApiIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_type(api_id, format, type_name)
    get_type(api_id, format, type_name, params::Dict{String,<:Any})

Retrieves a Type object.

# Arguments
- `api_id`: The API ID.
- `format`: The type format: SDL or JSON.
- `type_name`: The type name.

"""
function get_type(
    apiId, format, typeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/types/$(typeName)",
        Dict{String,Any}("format" => format);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_type(
    apiId,
    format,
    typeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/types/$(typeName)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("format" => format), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_api_keys(api_id)
    list_api_keys(api_id, params::Dict{String,<:Any})

Lists the API keys for a given API.  API keys are deleted automatically 60 days after they
expire. However, they may still be included in the response until they have actually been
deleted. You can safely call DeleteApiKey to manually delete a key before it's
automatically deleted.

# Arguments
- `api_id`: The API ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_api_keys(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/apikeys";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_api_keys(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/apikeys",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_data_sources(api_id)
    list_data_sources(api_id, params::Dict{String,<:Any})

Lists the data sources for a given API.

# Arguments
- `api_id`: The API ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_data_sources(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/datasources";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_data_sources(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/datasources",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_domain_names()
    list_domain_names(params::Dict{String,<:Any})

Lists multiple custom domain names.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_domain_names(; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET", "/v1/domainnames"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_domain_names(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/domainnames",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_functions(api_id)
    list_functions(api_id, params::Dict{String,<:Any})

List multiple functions.

# Arguments
- `api_id`: The GraphQL API ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_functions(apiId; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/functions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_functions(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/functions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_graphql_apis()
    list_graphql_apis(params::Dict{String,<:Any})

Lists your GraphQL APIs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"apiType"`: The value that indicates whether the GraphQL API is a standard API (GRAPHQL)
  or merged API (MERGED).
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
- `"owner"`: The account owner of the GraphQL API.
"""
function list_graphql_apis(; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET", "/v1/apis"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_graphql_apis(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET", "/v1/apis", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_resolvers(api_id, type_name)
    list_resolvers(api_id, type_name, params::Dict{String,<:Any})

Lists the resolvers for a given API and type.

# Arguments
- `api_id`: The API ID.
- `type_name`: The type name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_resolvers(apiId, typeName; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resolvers(
    apiId,
    typeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_resolvers_by_function(api_id, function_id)
    list_resolvers_by_function(api_id, function_id, params::Dict{String,<:Any})

List the resolvers that are associated with a specific function.

# Arguments
- `api_id`: The API ID.
- `function_id`: The function ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_resolvers_by_function(
    apiId, functionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/functions/$(functionId)/resolvers";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_resolvers_by_function(
    apiId,
    functionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/functions/$(functionId)/resolvers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_source_api_associations(api_id)
    list_source_api_associations(api_id, params::Dict{String,<:Any})

Lists the SourceApiAssociationSummary data.

# Arguments
- `api_id`: The API ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_source_api_associations(
    apiId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/sourceApiAssociations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_source_api_associations(
    apiId, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/sourceApiAssociations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags for a resource.

# Arguments
- `resource_arn`: The GraphqlApi Amazon Resource Name (ARN).

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "GET",
        "/v1/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_types(api_id, format)
    list_types(api_id, format, params::Dict{String,<:Any})

Lists the types for a given API.

# Arguments
- `api_id`: The API ID.
- `format`: The type format: SDL or JSON.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_types(apiId, format; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/types",
        Dict{String,Any}("format" => format);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_types(
    apiId,
    format,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/apis/$(apiId)/types",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("format" => format), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_types_by_association(association_id, format, merged_api_identifier)
    list_types_by_association(association_id, format, merged_api_identifier, params::Dict{String,<:Any})

Lists Type objects by the source API association ID.

# Arguments
- `association_id`: The ID generated by the AppSync service for the source API association.
- `format`: The format type.
- `merged_api_identifier`: The identifier of the AppSync Merged API. This is generated by
  the AppSync service. In most cases, Merged APIs (especially in your account) only require
  the API ID value or ARN of the merged API. However, Merged APIs in other accounts
  (cross-account use cases) strictly require the full resource ARN of the merged API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results that you want the request to return.
- `"nextToken"`: An identifier that was returned from the previous call to this operation,
  which you can use to return the next set of items in the list.
"""
function list_types_by_association(
    associationId,
    format,
    mergedApiIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)/types",
        Dict{String,Any}("format" => format);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_types_by_association(
    associationId,
    format,
    mergedApiIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "GET",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)/types",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("format" => format), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_graphql_api_environment_variables(api_id, environment_variables)
    put_graphql_api_environment_variables(api_id, environment_variables, params::Dict{String,<:Any})

Creates a list of environmental variables in an API by its ID value.  When creating an
environmental variable, it must follow the constraints below:   Both JavaScript and VTL
templates support environmental variables.   Environmental variables are not evaluated
before function invocation.   Environmental variables only support string values.   Any
defined value in an environmental variable is considered a string literal and not expanded.
  Variable evaluations should ideally be performed in the function code.   When creating an
environmental variable key-value pair, it must follow the additional constraints below:
Keys must begin with a letter.   Keys must be at least two characters long.   Keys can only
contain letters, numbers, and the underscore character (_).   Values can be up to 512
characters long.   You can configure up to 50 key-value pairs in a GraphQL API.   You can
create a list of environmental variables by adding it to the environmentVariables payload
as a list in the format {\"key1\":\"value1\",\"key2\":\"value2\", …}. Note that each call
of the PutGraphqlApiEnvironmentVariables action will result in the overwriting of the
existing environmental variable list of that API. This means the existing environmental
variables will be lost. To avoid this, you must include all existing and new environmental
variables in the list each time you call this action.

# Arguments
- `api_id`: The ID of the API to which the environmental variable list will be written.
- `environment_variables`: The list of environmental variables to add to the API. When
  creating an environmental variable key-value pair, it must follow the additional
  constraints below:   Keys must begin with a letter.   Keys must be at least two characters
  long.   Keys can only contain letters, numbers, and the underscore character (_).   Values
  can be up to 512 characters long.   You can configure up to 50 key-value pairs in a GraphQL
  API.   You can create a list of environmental variables by adding it to the
  environmentVariables payload as a list in the format
  {\"key1\":\"value1\",\"key2\":\"value2\", …}. Note that each call of the
  PutGraphqlApiEnvironmentVariables action will result in the overwriting of the existing
  environmental variable list of that API. This means the existing environmental variables
  will be lost. To avoid this, you must include all existing and new environmental variables
  in the list each time you call this action.

"""
function put_graphql_api_environment_variables(
    apiId, environmentVariables; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "PUT",
        "/v1/apis/$(apiId)/environmentVariables",
        Dict{String,Any}("environmentVariables" => environmentVariables);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_graphql_api_environment_variables(
    apiId,
    environmentVariables,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "PUT",
        "/v1/apis/$(apiId)/environmentVariables",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("environmentVariables" => environmentVariables),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_data_source_introspection()
    start_data_source_introspection(params::Dict{String,<:Any})

Creates a new introspection. Returns the introspectionId of the new introspection after its
creation.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"rdsDataApiConfig"`: The rdsDataApiConfig object data.
"""
function start_data_source_introspection(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/datasources/introspections";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_data_source_introspection(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/datasources/introspections",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_schema_creation(api_id, definition)
    start_schema_creation(api_id, definition, params::Dict{String,<:Any})

Adds a new schema to your GraphQL API. This operation is asynchronous. Use to determine
when it has completed.

# Arguments
- `api_id`: The API ID.
- `definition`: The schema definition, in GraphQL schema language format.

"""
function start_schema_creation(
    apiId, definition; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/schemacreation",
        Dict{String,Any}("definition" => definition);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_schema_creation(
    apiId,
    definition,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/schemacreation",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("definition" => definition), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_schema_merge(association_id, merged_api_identifier)
    start_schema_merge(association_id, merged_api_identifier, params::Dict{String,<:Any})

Initiates a merge operation. Returns a status that shows the result of the merge operation.

# Arguments
- `association_id`: The ID generated by the AppSync service for the source API association.
- `merged_api_identifier`: The identifier of the AppSync Merged API. This is generated by
  the AppSync service. In most cases, Merged APIs (especially in your account) only require
  the API ID value or ARN of the merged API. However, Merged APIs in other accounts
  (cross-account use cases) strictly require the full resource ARN of the merged API.

"""
function start_schema_merge(
    associationId, mergedApiIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)/merge";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_schema_merge(
    associationId,
    mergedApiIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)/merge",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Tags a resource with user-supplied tags.

# Arguments
- `resource_arn`: The GraphqlApi Amazon Resource Name (ARN).
- `tags`: A TagMap object.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "POST",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Untags a resource.

# Arguments
- `resource_arn`: The GraphqlApi Amazon Resource Name (ARN).
- `tag_keys`: A list of TagKey objects.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "DELETE",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "DELETE",
        "/v1/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_api_cache(api_caching_behavior, api_id, ttl, type)
    update_api_cache(api_caching_behavior, api_id, ttl, type, params::Dict{String,<:Any})

Updates the cache for the GraphQL API.

# Arguments
- `api_caching_behavior`: Caching behavior.    FULL_REQUEST_CACHING: All requests are fully
  cached.    PER_RESOLVER_CACHING: Individual resolvers that you specify are cached.
- `api_id`: The GraphQL API ID.
- `ttl`: TTL in seconds for cache entries. Valid values are 1–3,600 seconds.
- `type`: The cache instance type. Valid values are     SMALL     MEDIUM     LARGE
  XLARGE     LARGE_2X     LARGE_4X     LARGE_8X (not available in all regions)    LARGE_12X
   Historically, instance types were identified by an EC2-style value. As of July 2020, this
  is deprecated, and the generic identifiers above should be used. The following legacy
  instance types are available, but their use is discouraged:    T2_SMALL: A t2.small
  instance type.    T2_MEDIUM: A t2.medium instance type.    R4_LARGE: A r4.large instance
  type.    R4_XLARGE: A r4.xlarge instance type.    R4_2XLARGE: A r4.2xlarge instance type.
   R4_4XLARGE: A r4.4xlarge instance type.    R4_8XLARGE: A r4.8xlarge instance type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"healthMetricsConfig"`: Controls how cache health metrics will be emitted to CloudWatch.
  Cache health metrics include:   NetworkBandwidthOutAllowanceExceeded: The network packets
  dropped because the throughput exceeded the aggregated bandwidth limit. This is useful for
  diagnosing bottlenecks in a cache configuration.   EngineCPUUtilization: The CPU
  utilization (percentage) allocated to the Redis process. This is useful for diagnosing
  bottlenecks in a cache configuration.   Metrics will be recorded by API ID. You can set the
  value to ENABLED or DISABLED.
"""
function update_api_cache(
    apiCachingBehavior, apiId, ttl, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/ApiCaches/update",
        Dict{String,Any}(
            "apiCachingBehavior" => apiCachingBehavior, "ttl" => ttl, "type" => type
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_api_cache(
    apiCachingBehavior,
    apiId,
    ttl,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/ApiCaches/update",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "apiCachingBehavior" => apiCachingBehavior, "ttl" => ttl, "type" => type
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_api_key(api_id, id)
    update_api_key(api_id, id, params::Dict{String,<:Any})

Updates an API key. You can update the key as long as it's not deleted.

# Arguments
- `api_id`: The ID for the GraphQL API.
- `id`: The API key ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A description of the purpose of the API key.
- `"expires"`: From the update time, the time after which the API key expires. The date is
  represented as seconds since the epoch. For more information, see .
"""
function update_api_key(apiId, id; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/apikeys/$(id)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_api_key(
    apiId,
    id,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/apikeys/$(id)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_data_source(api_id, name, type)
    update_data_source(api_id, name, type, params::Dict{String,<:Any})

Updates a DataSource object.

# Arguments
- `api_id`: The API ID.
- `name`: The new name for the data source.
- `type`: The new data source type.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The new description for the data source.
- `"dynamodbConfig"`: The new Amazon DynamoDB configuration.
- `"elasticsearchConfig"`: The new OpenSearch configuration. As of September 2021, Amazon
  Elasticsearch service is Amazon OpenSearch Service. This configuration is deprecated.
  Instead, use UpdateDataSourceRequestopenSearchServiceConfig to update an OpenSearch data
  source.
- `"eventBridgeConfig"`: The new Amazon EventBridge settings.
- `"httpConfig"`: The new HTTP endpoint configuration.
- `"lambdaConfig"`: The new Lambda configuration.
- `"metricsConfig"`: Enables or disables enhanced data source metrics for specified data
  sources. Note that metricsConfig won't be used unless the dataSourceLevelMetricsBehavior
  value is set to PER_DATA_SOURCE_METRICS. If the dataSourceLevelMetricsBehavior is set to
  FULL_REQUEST_DATA_SOURCE_METRICS instead, metricsConfig will be ignored. However, you can
  still set its value.  metricsConfig can be ENABLED or DISABLED.
- `"openSearchServiceConfig"`: The new OpenSearch configuration.
- `"relationalDatabaseConfig"`: The new relational database configuration.
- `"serviceRoleArn"`: The new service role Amazon Resource Name (ARN) for the data source.
"""
function update_data_source(
    apiId, name, type; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/datasources/$(name)",
        Dict{String,Any}("type" => type);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_data_source(
    apiId,
    name,
    type,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/datasources/$(name)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("type" => type), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_domain_name(domain_name)
    update_domain_name(domain_name, params::Dict{String,<:Any})

Updates a custom DomainName object.

# Arguments
- `domain_name`: The domain name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: A description of the DomainName.
"""
function update_domain_name(domainName; aws_config::AbstractAWSConfig=current_aws_config())
    return appsync(
        "POST",
        "/v1/domainnames/$(domainName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_domain_name(
    domainName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/domainnames/$(domainName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_function(api_id, data_source_name, function_id, name)
    update_function(api_id, data_source_name, function_id, name, params::Dict{String,<:Any})

Updates a Function object.

# Arguments
- `api_id`: The GraphQL API ID.
- `data_source_name`: The Function DataSource name.
- `function_id`: The function ID.
- `name`: The Function name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"code"`: The function code that contains the request and response functions. When code
  is used, the runtime is required. The runtime value must be APPSYNC_JS.
- `"description"`: The Function description.
- `"functionVersion"`: The version of the request mapping template. Currently, the
  supported value is 2018-05-29. Note that when using VTL and mapping templates, the
  functionVersion is required.
- `"maxBatchSize"`: The maximum batching size for a resolver.
- `"requestMappingTemplate"`: The Function request mapping template. Functions support only
  the 2018-05-29 version of the request mapping template.
- `"responseMappingTemplate"`: The Function request mapping template.
- `"runtime"`:
- `"syncConfig"`:
"""
function update_function(
    apiId,
    dataSourceName,
    functionId,
    name;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/functions/$(functionId)",
        Dict{String,Any}("dataSourceName" => dataSourceName, "name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_function(
    apiId,
    dataSourceName,
    functionId,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/functions/$(functionId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("dataSourceName" => dataSourceName, "name" => name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_graphql_api(api_id, authentication_type, name)
    update_graphql_api(api_id, authentication_type, name, params::Dict{String,<:Any})

Updates a GraphqlApi object.

# Arguments
- `api_id`: The API ID.
- `authentication_type`: The new authentication type for the GraphqlApi object.
- `name`: The new name for the GraphqlApi object.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalAuthenticationProviders"`: A list of additional authentication providers for
  the GraphqlApi API.
- `"enhancedMetricsConfig"`: The enhancedMetricsConfig object.
- `"introspectionConfig"`: Sets the value of the GraphQL API to enable (ENABLED) or disable
  (DISABLED) introspection. If no value is provided, the introspection configuration will be
  set to ENABLED by default. This field will produce an error if the operation attempts to
  use the introspection feature while this field is disabled. For more information about
  introspection, see GraphQL introspection.
- `"lambdaAuthorizerConfig"`: Configuration for Lambda function authorization.
- `"logConfig"`: The Amazon CloudWatch Logs configuration for the GraphqlApi object.
- `"mergedApiExecutionRoleArn"`: The Identity and Access Management service role ARN for a
  merged API. The AppSync service assumes this role on behalf of the Merged API to validate
  access to source APIs at runtime and to prompt the AUTO_MERGE to update the merged API
  endpoint with the source API changes automatically.
- `"openIDConnectConfig"`: The OpenID Connect configuration for the GraphqlApi object.
- `"ownerContact"`: The owner contact information for an API resource. This field accepts
  any string input with a length of 0 - 256 characters.
- `"queryDepthLimit"`: The maximum depth a query can have in a single request. Depth refers
  to the amount of nested levels allowed in the body of query. The default value is 0 (or
  unspecified), which indicates there's no depth limit. If you set a limit, it can be between
  1 and 75 nested levels. This field will produce a limit error if the operation falls out of
  bounds. Note that fields can still be set to nullable or non-nullable. If a non-nullable
  field produces an error, the error will be thrown upwards to the first nullable field
  available.
- `"resolverCountLimit"`: The maximum number of resolvers that can be invoked in a single
  request. The default value is 0 (or unspecified), which will set the limit to 10000. When
  specified, the limit value can be between 1 and 10000. This field will produce a limit
  error if the operation falls out of bounds.
- `"userPoolConfig"`: The new Amazon Cognito user pool configuration for the ~GraphqlApi
  object.
- `"xrayEnabled"`: A flag indicating whether to use X-Ray tracing for the GraphqlApi.
"""
function update_graphql_api(
    apiId, authenticationType, name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)",
        Dict{String,Any}("authenticationType" => authenticationType, "name" => name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_graphql_api(
    apiId,
    authenticationType,
    name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "authenticationType" => authenticationType, "name" => name
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_resolver(api_id, field_name, type_name)
    update_resolver(api_id, field_name, type_name, params::Dict{String,<:Any})

Updates a Resolver object.

# Arguments
- `api_id`: The API ID.
- `field_name`: The new field name.
- `type_name`: The new type name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"cachingConfig"`: The caching configuration for the resolver.
- `"code"`: The resolver code that contains the request and response functions. When code
  is used, the runtime is required. The runtime value must be APPSYNC_JS.
- `"dataSourceName"`: The new data source name.
- `"kind"`: The resolver type.    UNIT: A UNIT resolver type. A UNIT resolver is the
  default resolver type. You can use a UNIT resolver to run a GraphQL query against a single
  data source.    PIPELINE: A PIPELINE resolver type. You can use a PIPELINE resolver to
  invoke a series of Function objects in a serial manner. You can use a pipeline resolver to
  run a GraphQL query against multiple data sources.
- `"maxBatchSize"`: The maximum batching size for a resolver.
- `"metricsConfig"`: Enables or disables enhanced resolver metrics for specified resolvers.
  Note that metricsConfig won't be used unless the resolverLevelMetricsBehavior value is set
  to PER_RESOLVER_METRICS. If the resolverLevelMetricsBehavior is set to
  FULL_REQUEST_RESOLVER_METRICS instead, metricsConfig will be ignored. However, you can
  still set its value.  metricsConfig can be ENABLED or DISABLED.
- `"pipelineConfig"`: The PipelineConfig.
- `"requestMappingTemplate"`: The new request mapping template. A resolver uses a request
  mapping template to convert a GraphQL expression into a format that a data source can
  understand. Mapping templates are written in Apache Velocity Template Language (VTL). VTL
  request mapping templates are optional when using an Lambda data source. For all other data
  sources, VTL request and response mapping templates are required.
- `"responseMappingTemplate"`: The new response mapping template.
- `"runtime"`:
- `"syncConfig"`: The SyncConfig for a resolver attached to a versioned data source.
"""
function update_resolver(
    apiId, fieldName, typeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers/$(fieldName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_resolver(
    apiId,
    fieldName,
    typeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/types/$(typeName)/resolvers/$(fieldName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_source_api_association(association_id, merged_api_identifier)
    update_source_api_association(association_id, merged_api_identifier, params::Dict{String,<:Any})

Updates some of the configuration choices of a particular source API association.

# Arguments
- `association_id`: The ID generated by the AppSync service for the source API association.
- `merged_api_identifier`: The identifier of the AppSync Merged API. This is generated by
  the AppSync service. In most cases, Merged APIs (especially in your account) only require
  the API ID value or ARN of the merged API. However, Merged APIs in other accounts
  (cross-account use cases) strictly require the full resource ARN of the merged API.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"description"`: The description field.
- `"sourceApiAssociationConfig"`: The SourceApiAssociationConfig object data.
"""
function update_source_api_association(
    associationId, mergedApiIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_source_api_association(
    associationId,
    mergedApiIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/mergedApis/$(mergedApiIdentifier)/sourceApiAssociations/$(associationId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_type(api_id, format, type_name)
    update_type(api_id, format, type_name, params::Dict{String,<:Any})

Updates a Type object.

# Arguments
- `api_id`: The API ID.
- `format`: The new type format: SDL or JSON.
- `type_name`: The new type name.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"definition"`: The new definition.
"""
function update_type(
    apiId, format, typeName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/types/$(typeName)",
        Dict{String,Any}("format" => format);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_type(
    apiId,
    format,
    typeName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return appsync(
        "POST",
        "/v1/apis/$(apiId)/types/$(typeName)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("format" => format), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
