# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: bcm_data_exports
using AWS.Compat
using AWS.UUIDs

"""
    create_export(export)
    create_export(export, params::Dict{String,<:Any})

Creates a data export and specifies the data query, the delivery preference, and any
optional resource tags. A DataQuery consists of both a QueryStatement and
TableConfigurations. The QueryStatement is an SQL statement. Data Exports only supports a
limited subset of the SQL syntax. For more information on the SQL syntax that is supported,
see Data query. To view the available tables and columns, see the Data Exports table
dictionary. The TableConfigurations is a collection of specified TableProperties for the
table being queried in the QueryStatement. TableProperties are additional configurations
you can provide to change the data and schema of a table. Each table can have different
TableProperties. However, tables are not required to have any TableProperties. Each table
property has a default value that it assumes if not specified. For more information on
table configurations, see Data query. To view the table properties available for each
table, see the Data Exports table dictionary or use the ListTables API to get a response of
all tables and their available properties.

# Arguments
- `export`: The details of the export, including data query, name, description, and
  destination configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ResourceTags"`: An optional list of tags to associate with the specified export. Each
  tag consists of a key and a value, and each key must be unique for the resource.
"""
function create_export(Export; aws_config::AbstractAWSConfig=current_aws_config())
    return bcm_data_exports(
        "CreateExport",
        Dict{String,Any}("Export" => Export);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_export(
    Export, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bcm_data_exports(
        "CreateExport",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Export" => Export), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_export(export_arn)
    delete_export(export_arn, params::Dict{String,<:Any})

Deletes an existing data export.

# Arguments
- `export_arn`: The Amazon Resource Name (ARN) for this export.

"""
function delete_export(ExportArn; aws_config::AbstractAWSConfig=current_aws_config())
    return bcm_data_exports(
        "DeleteExport",
        Dict{String,Any}("ExportArn" => ExportArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_export(
    ExportArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "DeleteExport",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ExportArn" => ExportArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_execution(execution_id, export_arn)
    get_execution(execution_id, export_arn, params::Dict{String,<:Any})

Exports data based on the source data update.

# Arguments
- `execution_id`: The ID for this specific execution.
- `export_arn`: The Amazon Resource Name (ARN) of the Export object that generated this
  specific execution.

"""
function get_execution(
    ExecutionId, ExportArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bcm_data_exports(
        "GetExecution",
        Dict{String,Any}("ExecutionId" => ExecutionId, "ExportArn" => ExportArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_execution(
    ExecutionId,
    ExportArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "GetExecution",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ExecutionId" => ExecutionId, "ExportArn" => ExportArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_export(export_arn)
    get_export(export_arn, params::Dict{String,<:Any})

Views the definition of an existing data export.

# Arguments
- `export_arn`: The Amazon Resource Name (ARN) for this export.

"""
function get_export(ExportArn; aws_config::AbstractAWSConfig=current_aws_config())
    return bcm_data_exports(
        "GetExport",
        Dict{String,Any}("ExportArn" => ExportArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_export(
    ExportArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "GetExport",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ExportArn" => ExportArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_table(table_name)
    get_table(table_name, params::Dict{String,<:Any})

Returns the metadata for the specified table and table properties. This includes the list
of columns in the table schema, their data types, and column descriptions.

# Arguments
- `table_name`: The name of the table.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TableProperties"`: TableProperties are additional configurations you can provide to
  change the data and schema of a table. Each table can have different TableProperties.
  Tables are not required to have any TableProperties. Each table property has a default
  value that it assumes if not specified.
"""
function get_table(TableName; aws_config::AbstractAWSConfig=current_aws_config())
    return bcm_data_exports(
        "GetTable",
        Dict{String,Any}("TableName" => TableName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_table(
    TableName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "GetTable",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("TableName" => TableName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_executions(export_arn)
    list_executions(export_arn, params::Dict{String,<:Any})

Lists the historical executions for the export.

# Arguments
- `export_arn`: The Amazon Resource Name (ARN) for this export.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that are returned for the request.
- `"NextToken"`: The token to retrieve the next set of results.
"""
function list_executions(ExportArn; aws_config::AbstractAWSConfig=current_aws_config())
    return bcm_data_exports(
        "ListExecutions",
        Dict{String,Any}("ExportArn" => ExportArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_executions(
    ExportArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "ListExecutions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ExportArn" => ExportArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_exports()
    list_exports(params::Dict{String,<:Any})

Lists all data export definitions.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that are returned for the request.
- `"NextToken"`: The token to retrieve the next set of results.
"""
function list_exports(; aws_config::AbstractAWSConfig=current_aws_config())
    return bcm_data_exports(
        "ListExports"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_exports(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bcm_data_exports(
        "ListExports", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tables()
    list_tables(params::Dict{String,<:Any})

Lists all available tables in data exports.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that are returned for the request.
- `"NextToken"`: The token to retrieve the next set of results.
"""
function list_tables(; aws_config::AbstractAWSConfig=current_aws_config())
    return bcm_data_exports(
        "ListTables"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_tables(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bcm_data_exports(
        "ListTables", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

List tags associated with an existing data export.

# Arguments
- `resource_arn`: The unique identifier for the resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxResults"`: The maximum number of objects that are returned for the request.
- `"NextToken"`: The token to retrieve the next set of results.
"""
function list_tags_for_resource(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bcm_data_exports(
        "ListTagsForResource",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, resource_tags)
    tag_resource(resource_arn, resource_tags, params::Dict{String,<:Any})

Adds tags for an existing data export definition.

# Arguments
- `resource_arn`: The unique identifier for the resource.
- `resource_tags`: The tags to associate with the resource. Each tag consists of a key and
  a value, and each key must be unique for the resource.

"""
function tag_resource(
    ResourceArn, ResourceTags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bcm_data_exports(
        "TagResource",
        Dict{String,Any}("ResourceArn" => ResourceArn, "ResourceTags" => ResourceTags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ResourceArn,
    ResourceTags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "TagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceArn" => ResourceArn, "ResourceTags" => ResourceTags
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, resource_tag_keys)
    untag_resource(resource_arn, resource_tag_keys, params::Dict{String,<:Any})

Deletes tags associated with an existing data export definition.

# Arguments
- `resource_arn`: The unique identifier for the resource.
- `resource_tag_keys`: The tag keys that are associated with the resource ARN.

"""
function untag_resource(
    ResourceArn, ResourceTagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bcm_data_exports(
        "UntagResource",
        Dict{String,Any}(
            "ResourceArn" => ResourceArn, "ResourceTagKeys" => ResourceTagKeys
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ResourceArn,
    ResourceTagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "UntagResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ResourceArn" => ResourceArn, "ResourceTagKeys" => ResourceTagKeys
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_export(export, export_arn)
    update_export(export, export_arn, params::Dict{String,<:Any})

Updates an existing data export by overwriting all export parameters. All export parameters
must be provided in the UpdateExport request.

# Arguments
- `export`: The name and query details for the export.
- `export_arn`: The Amazon Resource Name (ARN) for this export.

"""
function update_export(
    Export, ExportArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return bcm_data_exports(
        "UpdateExport",
        Dict{String,Any}("Export" => Export, "ExportArn" => ExportArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_export(
    Export,
    ExportArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return bcm_data_exports(
        "UpdateExport",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Export" => Export, "ExportArn" => ExportArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
