# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: inspector
using AWS.Compat
using AWS.UUIDs

"""
    add_attributes_to_findings(attributes, finding_arns)
    add_attributes_to_findings(attributes, finding_arns, params::Dict{String,<:Any})

Assigns attributes (key and value pairs) to the findings that are specified by the ARNs of
the findings.

# Arguments
- `attributes`: The array of attributes that you want to assign to specified findings.
- `finding_arns`: The ARNs that specify the findings that you want to assign attributes to.

"""
function add_attributes_to_findings(
    attributes, findingArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "AddAttributesToFindings",
        Dict{String,Any}("attributes" => attributes, "findingArns" => findingArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_attributes_to_findings(
    attributes,
    findingArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "AddAttributesToFindings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("attributes" => attributes, "findingArns" => findingArns),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_assessment_target(assessment_target_name)
    create_assessment_target(assessment_target_name, params::Dict{String,<:Any})

Creates a new assessment target using the ARN of the resource group that is generated by
CreateResourceGroup. If resourceGroupArn is not specified, all EC2 instances in the current
AWS account and region are included in the assessment target. If the service-linked role
isn’t already registered, this action also creates and registers a service-linked role to
grant Amazon Inspector access to AWS Services needed to perform security assessments. You
can create up to 50 assessment targets per AWS account. You can run up to 500 concurrent
agents per AWS account. For more information, see  Amazon Inspector Assessment Targets.

# Arguments
- `assessment_target_name`: The user-defined name that identifies the assessment target
  that you want to create. The name must be unique within the AWS account.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resourceGroupArn"`: The ARN that specifies the resource group that is used to create
  the assessment target. If resourceGroupArn is not specified, all EC2 instances in the
  current AWS account and region are included in the assessment target.
"""
function create_assessment_target(
    assessmentTargetName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "CreateAssessmentTarget",
        Dict{String,Any}("assessmentTargetName" => assessmentTargetName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_assessment_target(
    assessmentTargetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "CreateAssessmentTarget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("assessmentTargetName" => assessmentTargetName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_assessment_template(assessment_target_arn, assessment_template_name, duration_in_seconds, rules_package_arns)
    create_assessment_template(assessment_target_arn, assessment_template_name, duration_in_seconds, rules_package_arns, params::Dict{String,<:Any})

Creates an assessment template for the assessment target that is specified by the ARN of
the assessment target. If the service-linked role isn’t already registered, this action
also creates and registers a service-linked role to grant Amazon Inspector access to AWS
Services needed to perform security assessments.

# Arguments
- `assessment_target_arn`: The ARN that specifies the assessment target for which you want
  to create the assessment template.
- `assessment_template_name`: The user-defined name that identifies the assessment template
  that you want to create. You can create several assessment templates for an assessment
  target. The names of the assessment templates that correspond to a particular assessment
  target must be unique.
- `duration_in_seconds`: The duration of the assessment run in seconds.
- `rules_package_arns`: The ARNs that specify the rules packages that you want to attach to
  the assessment template.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"userAttributesForFindings"`: The user-defined attributes that are assigned to every
  finding that is generated by the assessment run that uses this assessment template. An
  attribute is a key and value pair (an Attribute object). Within an assessment template,
  each key must be unique.
"""
function create_assessment_template(
    assessmentTargetArn,
    assessmentTemplateName,
    durationInSeconds,
    rulesPackageArns;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "CreateAssessmentTemplate",
        Dict{String,Any}(
            "assessmentTargetArn" => assessmentTargetArn,
            "assessmentTemplateName" => assessmentTemplateName,
            "durationInSeconds" => durationInSeconds,
            "rulesPackageArns" => rulesPackageArns,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_assessment_template(
    assessmentTargetArn,
    assessmentTemplateName,
    durationInSeconds,
    rulesPackageArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "CreateAssessmentTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "assessmentTargetArn" => assessmentTargetArn,
                    "assessmentTemplateName" => assessmentTemplateName,
                    "durationInSeconds" => durationInSeconds,
                    "rulesPackageArns" => rulesPackageArns,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_exclusions_preview(assessment_template_arn)
    create_exclusions_preview(assessment_template_arn, params::Dict{String,<:Any})

Starts the generation of an exclusions preview for the specified assessment template. The
exclusions preview lists the potential exclusions (ExclusionPreview) that Inspector can
detect before it runs the assessment.

# Arguments
- `assessment_template_arn`: The ARN that specifies the assessment template for which you
  want to create an exclusions preview.

"""
function create_exclusions_preview(
    assessmentTemplateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "CreateExclusionsPreview",
        Dict{String,Any}("assessmentTemplateArn" => assessmentTemplateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_exclusions_preview(
    assessmentTemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "CreateExclusionsPreview",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("assessmentTemplateArn" => assessmentTemplateArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_resource_group(resource_group_tags)
    create_resource_group(resource_group_tags, params::Dict{String,<:Any})

Creates a resource group using the specified set of tags (key and value pairs) that are
used to select the EC2 instances to be included in an Amazon Inspector assessment target.
The created resource group is then used to create an Amazon Inspector assessment target.
For more information, see CreateAssessmentTarget.

# Arguments
- `resource_group_tags`: A collection of keys and an array of possible values,
  '[{\"key\":\"key1\",\"values\":[\"Value1\",\"Value2\"]},{\"key\":\"Key2\",\"values\":[\"Valu
  e3\"]}]'. For example,'[{\"key\":\"Name\",\"values\":[\"TestEC2Instance\"]}]'.

"""
function create_resource_group(
    resourceGroupTags; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "CreateResourceGroup",
        Dict{String,Any}("resourceGroupTags" => resourceGroupTags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_resource_group(
    resourceGroupTags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "CreateResourceGroup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("resourceGroupTags" => resourceGroupTags), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_assessment_run(assessment_run_arn)
    delete_assessment_run(assessment_run_arn, params::Dict{String,<:Any})

Deletes the assessment run that is specified by the ARN of the assessment run.

# Arguments
- `assessment_run_arn`: The ARN that specifies the assessment run that you want to delete.

"""
function delete_assessment_run(
    assessmentRunArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DeleteAssessmentRun",
        Dict{String,Any}("assessmentRunArn" => assessmentRunArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_assessment_run(
    assessmentRunArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DeleteAssessmentRun",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("assessmentRunArn" => assessmentRunArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_assessment_target(assessment_target_arn)
    delete_assessment_target(assessment_target_arn, params::Dict{String,<:Any})

Deletes the assessment target that is specified by the ARN of the assessment target.

# Arguments
- `assessment_target_arn`: The ARN that specifies the assessment target that you want to
  delete.

"""
function delete_assessment_target(
    assessmentTargetArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DeleteAssessmentTarget",
        Dict{String,Any}("assessmentTargetArn" => assessmentTargetArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_assessment_target(
    assessmentTargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DeleteAssessmentTarget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("assessmentTargetArn" => assessmentTargetArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_assessment_template(assessment_template_arn)
    delete_assessment_template(assessment_template_arn, params::Dict{String,<:Any})

Deletes the assessment template that is specified by the ARN of the assessment template.

# Arguments
- `assessment_template_arn`: The ARN that specifies the assessment template that you want
  to delete.

"""
function delete_assessment_template(
    assessmentTemplateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DeleteAssessmentTemplate",
        Dict{String,Any}("assessmentTemplateArn" => assessmentTemplateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_assessment_template(
    assessmentTemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DeleteAssessmentTemplate",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("assessmentTemplateArn" => assessmentTemplateArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_assessment_runs(assessment_run_arns)
    describe_assessment_runs(assessment_run_arns, params::Dict{String,<:Any})

Describes the assessment runs that are specified by the ARNs of the assessment runs.

# Arguments
- `assessment_run_arns`: The ARN that specifies the assessment run that you want to
  describe.

"""
function describe_assessment_runs(
    assessmentRunArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DescribeAssessmentRuns",
        Dict{String,Any}("assessmentRunArns" => assessmentRunArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_assessment_runs(
    assessmentRunArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DescribeAssessmentRuns",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("assessmentRunArns" => assessmentRunArns), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_assessment_targets(assessment_target_arns)
    describe_assessment_targets(assessment_target_arns, params::Dict{String,<:Any})

Describes the assessment targets that are specified by the ARNs of the assessment targets.

# Arguments
- `assessment_target_arns`: The ARNs that specifies the assessment targets that you want to
  describe.

"""
function describe_assessment_targets(
    assessmentTargetArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DescribeAssessmentTargets",
        Dict{String,Any}("assessmentTargetArns" => assessmentTargetArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_assessment_targets(
    assessmentTargetArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DescribeAssessmentTargets",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("assessmentTargetArns" => assessmentTargetArns),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_assessment_templates(assessment_template_arns)
    describe_assessment_templates(assessment_template_arns, params::Dict{String,<:Any})

Describes the assessment templates that are specified by the ARNs of the assessment
templates.

# Arguments
- `assessment_template_arns`:

"""
function describe_assessment_templates(
    assessmentTemplateArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DescribeAssessmentTemplates",
        Dict{String,Any}("assessmentTemplateArns" => assessmentTemplateArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_assessment_templates(
    assessmentTemplateArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DescribeAssessmentTemplates",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("assessmentTemplateArns" => assessmentTemplateArns),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_cross_account_access_role()
    describe_cross_account_access_role(params::Dict{String,<:Any})

Describes the IAM role that enables Amazon Inspector to access your AWS account.

"""
function describe_cross_account_access_role(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DescribeCrossAccountAccessRole";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_cross_account_access_role(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DescribeCrossAccountAccessRole",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_exclusions(exclusion_arns)
    describe_exclusions(exclusion_arns, params::Dict{String,<:Any})

Describes the exclusions that are specified by the exclusions' ARNs.

# Arguments
- `exclusion_arns`: The list of ARNs that specify the exclusions that you want to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"locale"`: The locale into which you want to translate the exclusion's title,
  description, and recommendation.
"""
function describe_exclusions(
    exclusionArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DescribeExclusions",
        Dict{String,Any}("exclusionArns" => exclusionArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_exclusions(
    exclusionArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DescribeExclusions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("exclusionArns" => exclusionArns), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_findings(finding_arns)
    describe_findings(finding_arns, params::Dict{String,<:Any})

Describes the findings that are specified by the ARNs of the findings.

# Arguments
- `finding_arns`: The ARN that specifies the finding that you want to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"locale"`: The locale into which you want to translate a finding description,
  recommendation, and the short description that identifies the finding.
"""
function describe_findings(findingArns; aws_config::AbstractAWSConfig=current_aws_config())
    return inspector(
        "DescribeFindings",
        Dict{String,Any}("findingArns" => findingArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_findings(
    findingArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DescribeFindings",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("findingArns" => findingArns), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_resource_groups(resource_group_arns)
    describe_resource_groups(resource_group_arns, params::Dict{String,<:Any})

Describes the resource groups that are specified by the ARNs of the resource groups.

# Arguments
- `resource_group_arns`: The ARN that specifies the resource group that you want to
  describe.

"""
function describe_resource_groups(
    resourceGroupArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DescribeResourceGroups",
        Dict{String,Any}("resourceGroupArns" => resourceGroupArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_resource_groups(
    resourceGroupArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DescribeResourceGroups",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("resourceGroupArns" => resourceGroupArns), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_rules_packages(rules_package_arns)
    describe_rules_packages(rules_package_arns, params::Dict{String,<:Any})

Describes the rules packages that are specified by the ARNs of the rules packages.

# Arguments
- `rules_package_arns`: The ARN that specifies the rules package that you want to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"locale"`: The locale that you want to translate a rules package description into.
"""
function describe_rules_packages(
    rulesPackageArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "DescribeRulesPackages",
        Dict{String,Any}("rulesPackageArns" => rulesPackageArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_rules_packages(
    rulesPackageArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "DescribeRulesPackages",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("rulesPackageArns" => rulesPackageArns), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_assessment_report(assessment_run_arn, report_file_format, report_type)
    get_assessment_report(assessment_run_arn, report_file_format, report_type, params::Dict{String,<:Any})

Produces an assessment report that includes detailed and comprehensive results of a
specified assessment run.

# Arguments
- `assessment_run_arn`: The ARN that specifies the assessment run for which you want to
  generate a report.
- `report_file_format`: Specifies the file format (html or pdf) of the assessment report
  that you want to generate.
- `report_type`: Specifies the type of the assessment report that you want to generate.
  There are two types of assessment reports: a finding report and a full report. For more
  information, see Assessment Reports.

"""
function get_assessment_report(
    assessmentRunArn,
    reportFileFormat,
    reportType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "GetAssessmentReport",
        Dict{String,Any}(
            "assessmentRunArn" => assessmentRunArn,
            "reportFileFormat" => reportFileFormat,
            "reportType" => reportType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_assessment_report(
    assessmentRunArn,
    reportFileFormat,
    reportType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "GetAssessmentReport",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "assessmentRunArn" => assessmentRunArn,
                    "reportFileFormat" => reportFileFormat,
                    "reportType" => reportType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_exclusions_preview(assessment_template_arn, preview_token)
    get_exclusions_preview(assessment_template_arn, preview_token, params::Dict{String,<:Any})

Retrieves the exclusions preview (a list of ExclusionPreview objects) specified by the
preview token. You can obtain the preview token by running the CreateExclusionsPreview API.

# Arguments
- `assessment_template_arn`: The ARN that specifies the assessment template for which the
  exclusions preview was requested.
- `preview_token`: The unique identifier associated of the exclusions preview.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"locale"`: The locale into which you want to translate the exclusion's title,
  description, and recommendation.
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 100. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the GetExclusionsPreviewRequest action. Subsequent
  calls to the action fill nextToken in the request with the value of nextToken from the
  previous response to continue listing data.
"""
function get_exclusions_preview(
    assessmentTemplateArn, previewToken; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "GetExclusionsPreview",
        Dict{String,Any}(
            "assessmentTemplateArn" => assessmentTemplateArn, "previewToken" => previewToken
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_exclusions_preview(
    assessmentTemplateArn,
    previewToken,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "GetExclusionsPreview",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "assessmentTemplateArn" => assessmentTemplateArn,
                    "previewToken" => previewToken,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_telemetry_metadata(assessment_run_arn)
    get_telemetry_metadata(assessment_run_arn, params::Dict{String,<:Any})

Information about the data that is collected for the specified assessment run.

# Arguments
- `assessment_run_arn`: The ARN that specifies the assessment run that has the telemetry
  data that you want to obtain.

"""
function get_telemetry_metadata(
    assessmentRunArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "GetTelemetryMetadata",
        Dict{String,Any}("assessmentRunArn" => assessmentRunArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_telemetry_metadata(
    assessmentRunArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "GetTelemetryMetadata",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("assessmentRunArn" => assessmentRunArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_assessment_run_agents(assessment_run_arn)
    list_assessment_run_agents(assessment_run_arn, params::Dict{String,<:Any})

Lists the agents of the assessment runs that are specified by the ARNs of the assessment
runs.

# Arguments
- `assessment_run_arn`: The ARN that specifies the assessment run whose agents you want to
  list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter"`: You can use this parameter to specify a subset of data to be included in the
  action's response. For a record to match a filter, all specified filter attributes must
  match. When multiple values are specified for a filter attribute, any of the values can
  match.
- `"maxResults"`: You can use this parameter to indicate the maximum number of items that
  you want in the response. The default value is 10. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the ListAssessmentRunAgents action. Subsequent
  calls to the action fill nextToken in the request with the value of NextToken from the
  previous response to continue listing data.
"""
function list_assessment_run_agents(
    assessmentRunArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListAssessmentRunAgents",
        Dict{String,Any}("assessmentRunArn" => assessmentRunArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_assessment_run_agents(
    assessmentRunArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "ListAssessmentRunAgents",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("assessmentRunArn" => assessmentRunArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_assessment_runs()
    list_assessment_runs(params::Dict{String,<:Any})

Lists the assessment runs that correspond to the assessment templates that are specified by
the ARNs of the assessment templates.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"assessmentTemplateArns"`: The ARNs that specify the assessment templates whose
  assessment runs you want to list.
- `"filter"`: You can use this parameter to specify a subset of data to be included in the
  action's response. For a record to match a filter, all specified filter attributes must
  match. When multiple values are specified for a filter attribute, any of the values can
  match.
- `"maxResults"`: You can use this parameter to indicate the maximum number of items that
  you want in the response. The default value is 10. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the ListAssessmentRuns action. Subsequent calls to
  the action fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_assessment_runs(; aws_config::AbstractAWSConfig=current_aws_config())
    return inspector(
        "ListAssessmentRuns"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_assessment_runs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListAssessmentRuns", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_assessment_targets()
    list_assessment_targets(params::Dict{String,<:Any})

Lists the ARNs of the assessment targets within this AWS account. For more information
about assessment targets, see Amazon Inspector Assessment Targets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"filter"`: You can use this parameter to specify a subset of data to be included in the
  action's response. For a record to match a filter, all specified filter attributes must
  match. When multiple values are specified for a filter attribute, any of the values can
  match.
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 10. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the ListAssessmentTargets action. Subsequent calls
  to the action fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_assessment_targets(; aws_config::AbstractAWSConfig=current_aws_config())
    return inspector(
        "ListAssessmentTargets"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_assessment_targets(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListAssessmentTargets",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_assessment_templates()
    list_assessment_templates(params::Dict{String,<:Any})

Lists the assessment templates that correspond to the assessment targets that are specified
by the ARNs of the assessment targets.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"assessmentTargetArns"`: A list of ARNs that specifies the assessment targets whose
  assessment templates you want to list.
- `"filter"`: You can use this parameter to specify a subset of data to be included in the
  action's response. For a record to match a filter, all specified filter attributes must
  match. When multiple values are specified for a filter attribute, any of the values can
  match.
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 10. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the ListAssessmentTemplates action. Subsequent
  calls to the action fill nextToken in the request with the value of NextToken from the
  previous response to continue listing data.
"""
function list_assessment_templates(; aws_config::AbstractAWSConfig=current_aws_config())
    return inspector(
        "ListAssessmentTemplates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_assessment_templates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListAssessmentTemplates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_event_subscriptions()
    list_event_subscriptions(params::Dict{String,<:Any})

Lists all the event subscriptions for the assessment template that is specified by the ARN
of the assessment template. For more information, see SubscribeToEvent and
UnsubscribeFromEvent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 10. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the ListEventSubscriptions action. Subsequent calls
  to the action fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
- `"resourceArn"`: The ARN of the assessment template for which you want to list the
  existing event subscriptions.
"""
function list_event_subscriptions(; aws_config::AbstractAWSConfig=current_aws_config())
    return inspector(
        "ListEventSubscriptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_event_subscriptions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListEventSubscriptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_exclusions(assessment_run_arn)
    list_exclusions(assessment_run_arn, params::Dict{String,<:Any})

List exclusions that are generated by the assessment run.

# Arguments
- `assessment_run_arn`: The ARN of the assessment run that generated the exclusions that
  you want to list.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 100. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the ListExclusionsRequest action. Subsequent calls
  to the action fill nextToken in the request with the value of nextToken from the previous
  response to continue listing data.
"""
function list_exclusions(
    assessmentRunArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListExclusions",
        Dict{String,Any}("assessmentRunArn" => assessmentRunArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_exclusions(
    assessmentRunArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "ListExclusions",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("assessmentRunArn" => assessmentRunArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_findings()
    list_findings(params::Dict{String,<:Any})

Lists findings that are generated by the assessment runs that are specified by the ARNs of
the assessment runs.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"assessmentRunArns"`: The ARNs of the assessment runs that generate the findings that
  you want to list.
- `"filter"`: You can use this parameter to specify a subset of data to be included in the
  action's response. For a record to match a filter, all specified filter attributes must
  match. When multiple values are specified for a filter attribute, any of the values can
  match.
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 10. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the ListFindings action. Subsequent calls to the
  action fill nextToken in the request with the value of NextToken from the previous response
  to continue listing data.
"""
function list_findings(; aws_config::AbstractAWSConfig=current_aws_config())
    return inspector("ListFindings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function list_findings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListFindings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_rules_packages()
    list_rules_packages(params::Dict{String,<:Any})

Lists all available Amazon Inspector rules packages.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 10. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the ListRulesPackages action. Subsequent calls to
  the action fill nextToken in the request with the value of NextToken from the previous
  response to continue listing data.
"""
function list_rules_packages(; aws_config::AbstractAWSConfig=current_aws_config())
    return inspector(
        "ListRulesPackages"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_rules_packages(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListRulesPackages", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists all tags associated with an assessment template.

# Arguments
- `resource_arn`: The ARN that specifies the assessment template whose tags you want to
  list.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "ListTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    preview_agents(preview_agents_arn)
    preview_agents(preview_agents_arn, params::Dict{String,<:Any})

Previews the agents installed on the EC2 instances that are part of the specified
assessment target.

# Arguments
- `preview_agents_arn`: The ARN of the assessment target whose agents you want to preview.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: You can use this parameter to indicate the maximum number of items you
  want in the response. The default value is 10. The maximum value is 500.
- `"nextToken"`: You can use this parameter when paginating results. Set the value of this
  parameter to null on your first call to the PreviewAgents action. Subsequent calls to the
  action fill nextToken in the request with the value of NextToken from the previous response
  to continue listing data.
"""
function preview_agents(
    previewAgentsArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "PreviewAgents",
        Dict{String,Any}("previewAgentsArn" => previewAgentsArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function preview_agents(
    previewAgentsArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "PreviewAgents",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("previewAgentsArn" => previewAgentsArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_cross_account_access_role(role_arn)
    register_cross_account_access_role(role_arn, params::Dict{String,<:Any})

Registers the IAM role that grants Amazon Inspector access to AWS Services needed to
perform security assessments.

# Arguments
- `role_arn`: The ARN of the IAM role that grants Amazon Inspector access to AWS Services
  needed to perform security assessments.

"""
function register_cross_account_access_role(
    roleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "RegisterCrossAccountAccessRole",
        Dict{String,Any}("roleArn" => roleArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_cross_account_access_role(
    roleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "RegisterCrossAccountAccessRole",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("roleArn" => roleArn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_attributes_from_findings(attribute_keys, finding_arns)
    remove_attributes_from_findings(attribute_keys, finding_arns, params::Dict{String,<:Any})

Removes entire attributes (key and value pairs) from the findings that are specified by the
ARNs of the findings where an attribute with the specified key exists.

# Arguments
- `attribute_keys`: The array of attribute keys that you want to remove from specified
  findings.
- `finding_arns`: The ARNs that specify the findings that you want to remove attributes
  from.

"""
function remove_attributes_from_findings(
    attributeKeys, findingArns; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "RemoveAttributesFromFindings",
        Dict{String,Any}("attributeKeys" => attributeKeys, "findingArns" => findingArns);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_attributes_from_findings(
    attributeKeys,
    findingArns,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "RemoveAttributesFromFindings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "attributeKeys" => attributeKeys, "findingArns" => findingArns
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    set_tags_for_resource(resource_arn)
    set_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Sets tags (key and value pairs) to the assessment template that is specified by the ARN of
the assessment template.

# Arguments
- `resource_arn`: The ARN of the assessment template that you want to set tags to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A collection of key and value pairs that you want to set to the assessment
  template.
"""
function set_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "SetTagsForResource",
        Dict{String,Any}("resourceArn" => resourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function set_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "SetTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("resourceArn" => resourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_assessment_run(assessment_template_arn)
    start_assessment_run(assessment_template_arn, params::Dict{String,<:Any})

Starts the assessment run specified by the ARN of the assessment template. For this API to
function properly, you must not exceed the limit of running up to 500 concurrent agents per
AWS account.

# Arguments
- `assessment_template_arn`: The ARN of the assessment template of the assessment run that
  you want to start.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"assessmentRunName"`: You can specify the name for the assessment run. The name must be
  unique for the assessment template whose ARN is used to start the assessment run.
"""
function start_assessment_run(
    assessmentTemplateArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "StartAssessmentRun",
        Dict{String,Any}("assessmentTemplateArn" => assessmentTemplateArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_assessment_run(
    assessmentTemplateArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "StartAssessmentRun",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("assessmentTemplateArn" => assessmentTemplateArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_assessment_run(assessment_run_arn)
    stop_assessment_run(assessment_run_arn, params::Dict{String,<:Any})

Stops the assessment run that is specified by the ARN of the assessment run.

# Arguments
- `assessment_run_arn`: The ARN of the assessment run that you want to stop.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"stopAction"`: An input option that can be set to either START_EVALUATION or
  SKIP_EVALUATION. START_EVALUATION (the default value), stops the AWS agent from collecting
  data and begins the results evaluation and the findings generation process. SKIP_EVALUATION
  cancels the assessment run immediately, after which no findings are generated.
"""
function stop_assessment_run(
    assessmentRunArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "StopAssessmentRun",
        Dict{String,Any}("assessmentRunArn" => assessmentRunArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_assessment_run(
    assessmentRunArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "StopAssessmentRun",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("assessmentRunArn" => assessmentRunArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    subscribe_to_event(event, resource_arn, topic_arn)
    subscribe_to_event(event, resource_arn, topic_arn, params::Dict{String,<:Any})

Enables the process of sending Amazon Simple Notification Service (SNS) notifications about
a specified event to a specified SNS topic.

# Arguments
- `event`: The event for which you want to receive SNS notifications.
- `resource_arn`: The ARN of the assessment template that is used during the event for
  which you want to receive SNS notifications.
- `topic_arn`: The ARN of the SNS topic to which the SNS notifications are sent.

"""
function subscribe_to_event(
    event, resourceArn, topicArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "SubscribeToEvent",
        Dict{String,Any}(
            "event" => event, "resourceArn" => resourceArn, "topicArn" => topicArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function subscribe_to_event(
    event,
    resourceArn,
    topicArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "SubscribeToEvent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "event" => event, "resourceArn" => resourceArn, "topicArn" => topicArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    unsubscribe_from_event(event, resource_arn, topic_arn)
    unsubscribe_from_event(event, resource_arn, topic_arn, params::Dict{String,<:Any})

Disables the process of sending Amazon Simple Notification Service (SNS) notifications
about a specified event to a specified SNS topic.

# Arguments
- `event`: The event for which you want to stop receiving SNS notifications.
- `resource_arn`: The ARN of the assessment template that is used during the event for
  which you want to stop receiving SNS notifications.
- `topic_arn`: The ARN of the SNS topic to which SNS notifications are sent.

"""
function unsubscribe_from_event(
    event, resourceArn, topicArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return inspector(
        "UnsubscribeFromEvent",
        Dict{String,Any}(
            "event" => event, "resourceArn" => resourceArn, "topicArn" => topicArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function unsubscribe_from_event(
    event,
    resourceArn,
    topicArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "UnsubscribeFromEvent",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "event" => event, "resourceArn" => resourceArn, "topicArn" => topicArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_assessment_target(assessment_target_arn, assessment_target_name)
    update_assessment_target(assessment_target_arn, assessment_target_name, params::Dict{String,<:Any})

Updates the assessment target that is specified by the ARN of the assessment target. If
resourceGroupArn is not specified, all EC2 instances in the current AWS account and region
are included in the assessment target.

# Arguments
- `assessment_target_arn`: The ARN of the assessment target that you want to update.
- `assessment_target_name`: The name of the assessment target that you want to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"resourceGroupArn"`: The ARN of the resource group that is used to specify the new
  resource group to associate with the assessment target.
"""
function update_assessment_target(
    assessmentTargetArn,
    assessmentTargetName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "UpdateAssessmentTarget",
        Dict{String,Any}(
            "assessmentTargetArn" => assessmentTargetArn,
            "assessmentTargetName" => assessmentTargetName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_assessment_target(
    assessmentTargetArn,
    assessmentTargetName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return inspector(
        "UpdateAssessmentTarget",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "assessmentTargetArn" => assessmentTargetArn,
                    "assessmentTargetName" => assessmentTargetName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
