# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: lambda
using AWS.Compat
using AWS.UUIDs

"""
    add_layer_version_permission(action, layer_name, principal, statement_id, version_number)
    add_layer_version_permission(action, layer_name, principal, statement_id, version_number, params::Dict{String,<:Any})

Adds permissions to the resource-based policy of a version of an Lambda layer. Use this
action to grant layer usage permission to other accounts. You can grant permission to a
single account, all accounts in an organization, or all Amazon Web Services accounts.  To
revoke permission, call RemoveLayerVersionPermission with the statement ID that you
specified when you added it.

# Arguments
- `action`: The API action that grants access to the layer. For example,
  lambda:GetLayerVersion.
- `layer_name`: The name or Amazon Resource Name (ARN) of the layer.
- `principal`: An account ID, or * to grant layer usage permission to all accounts in an
  organization, or all Amazon Web Services accounts (if organizationId is not specified). For
  the last case, make sure that you really do want all Amazon Web Services accounts to have
  usage permission to this layer.
- `statement_id`: An identifier that distinguishes the policy from others on the same layer
  version.
- `version_number`: The version number.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"OrganizationId"`: With the principal set to *, grant permission to all accounts in the
  specified organization.
- `"RevisionId"`: Only update the policy if the revision ID matches the ID specified. Use
  this option to avoid modifying a policy that has changed since you last read it.
"""
function add_layer_version_permission(
    Action,
    LayerName,
    Principal,
    StatementId,
    VersionNumber;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)/policy",
        Dict{String,Any}(
            "Action" => Action, "Principal" => Principal, "StatementId" => StatementId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_layer_version_permission(
    Action,
    LayerName,
    Principal,
    StatementId,
    VersionNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)/policy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Action" => Action,
                    "Principal" => Principal,
                    "StatementId" => StatementId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_permission(action, function_name, principal, statement_id)
    add_permission(action, function_name, principal, statement_id, params::Dict{String,<:Any})

Grants an Amazon Web Service, Amazon Web Services account, or Amazon Web Services
organization permission to use a function. You can apply the policy at the function level,
or specify a qualifier to restrict access to a single version or alias. If you use a
qualifier, the invoker must use the full Amazon Resource Name (ARN) of that version or
alias to invoke the function. Note: Lambda does not support adding policies to version
LATEST. To grant permission to another account, specify the account ID as the Principal. To
grant permission to an organization defined in Organizations, specify the organization ID
as the PrincipalOrgID. For Amazon Web Services, the principal is a domain-style identifier
that the service defines, such as s3.amazonaws.com or sns.amazonaws.com. For Amazon Web
Services, you can also specify the ARN of the associated resource as the SourceArn. If you
grant permission to a service principal without specifying the source, other accounts could
potentially configure resources in their account to invoke your Lambda function. This
operation adds a statement to a resource-based permissions policy for the function. For
more information about function policies, see Using resource-based policies for Lambda.

# Arguments
- `action`: The action that the principal can use on the function. For example,
  lambda:InvokeFunction or lambda:GetFunction.
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name – my-function (name-only), my-function:v1 (with alias).    Function ARN
  – arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.
- `principal`: The Amazon Web Service or Amazon Web Services account that invokes the
  function. If you specify a service, use SourceArn or SourceAccount to limit who can invoke
  the function through that service.
- `statement_id`: A statement identifier that differentiates the statement from others in
  the same policy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventSourceToken"`: For Alexa Smart Home functions, a token that the invoker must
  supply.
- `"FunctionUrlAuthType"`: The type of authentication that your function URL uses. Set to
  AWS_IAM if you want to restrict access to authenticated users only. Set to NONE if you want
  to bypass IAM authentication to create a public endpoint. For more information, see
  Security and auth model for Lambda function URLs.
- `"PrincipalOrgID"`: The identifier for your organization in Organizations. Use this to
  grant permissions to all the Amazon Web Services accounts under this organization.
- `"Qualifier"`: Specify a version or alias to add permissions to a published version of
  the function.
- `"RevisionId"`: Update the policy only if the revision ID matches the ID that's
  specified. Use this option to avoid modifying a policy that has changed since you last read
  it.
- `"SourceAccount"`: For Amazon Web Service, the ID of the Amazon Web Services account that
  owns the resource. Use this together with SourceArn to ensure that the specified account
  owns the resource. It is possible for an Amazon S3 bucket to be deleted by its owner and
  recreated by another account.
- `"SourceArn"`: For Amazon Web Services, the ARN of the Amazon Web Services resource that
  invokes the function. For example, an Amazon S3 bucket or Amazon SNS topic. Note that
  Lambda configures the comparison using the StringLike operator.
"""
function add_permission(
    Action,
    FunctionName,
    Principal,
    StatementId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2015-03-31/functions/$(FunctionName)/policy",
        Dict{String,Any}(
            "Action" => Action, "Principal" => Principal, "StatementId" => StatementId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_permission(
    Action,
    FunctionName,
    Principal,
    StatementId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2015-03-31/functions/$(FunctionName)/policy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Action" => Action,
                    "Principal" => Principal,
                    "StatementId" => StatementId,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_alias(function_name, function_version, name)
    create_alias(function_name, function_version, name, params::Dict{String,<:Any})

Creates an alias for a Lambda function version. Use aliases to provide clients with a
function identifier that you can update to invoke a different version. You can also map an
alias to split invocation requests between two versions. Use the RoutingConfig parameter to
specify a second version and the percentage of invocation requests that it receives.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.
- `function_version`: The function version that the alias invokes.
- `name`: The name of the alias.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the alias.
- `"RoutingConfig"`: The routing configuration of the alias.
"""
function create_alias(
    FunctionName, FunctionVersion, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2015-03-31/functions/$(FunctionName)/aliases",
        Dict{String,Any}("FunctionVersion" => FunctionVersion, "Name" => Name);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_alias(
    FunctionName,
    FunctionVersion,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2015-03-31/functions/$(FunctionName)/aliases",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("FunctionVersion" => FunctionVersion, "Name" => Name),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_code_signing_config(allowed_publishers)
    create_code_signing_config(allowed_publishers, params::Dict{String,<:Any})

Creates a code signing configuration. A code signing configuration defines a list of
allowed signing profiles and defines the code-signing validation policy (action to be taken
if deployment validation checks fail).

# Arguments
- `allowed_publishers`: Signing profiles for this code signing configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CodeSigningPolicies"`: The code signing policies define the actions to take if the
  validation checks fail.
- `"Description"`: Descriptive name for this code signing configuration.
"""
function create_code_signing_config(
    AllowedPublishers; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2020-04-22/code-signing-configs/",
        Dict{String,Any}("AllowedPublishers" => AllowedPublishers);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_code_signing_config(
    AllowedPublishers,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2020-04-22/code-signing-configs/",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("AllowedPublishers" => AllowedPublishers), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_event_source_mapping(function_name)
    create_event_source_mapping(function_name, params::Dict{String,<:Any})

Creates a mapping between an event source and an Lambda function. Lambda reads items from
the event source and invokes the function. For details about how to configure different
event sources, see the following topics.      Amazon DynamoDB Streams      Amazon Kinesis
   Amazon SQS      Amazon MQ and RabbitMQ      Amazon MSK      Apache Kafka      Amazon
DocumentDB    The following error handling options are available only for stream sources
(DynamoDB and Kinesis):    BisectBatchOnFunctionError – If the function returns an error,
split the batch in two and retry.    DestinationConfig – Send discarded records to an
Amazon SQS queue or Amazon SNS topic.    MaximumRecordAgeInSeconds – Discard records
older than the specified age. The default value is infinite (-1). When set to infinite
(-1), failed records are retried until the record expires    MaximumRetryAttempts –
Discard records after the specified number of retries. The default value is infinite (-1).
When set to infinite (-1), failed records are retried until the record expires.
ParallelizationFactor – Process multiple batches from each shard concurrently.   For
information about which configuration parameters apply to each event source, see the
following topics.     Amazon DynamoDB Streams      Amazon Kinesis      Amazon SQS
Amazon MQ and RabbitMQ      Amazon MSK      Apache Kafka      Amazon DocumentDB

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – MyFunction.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Version or Alias ARN –
  arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.    Partial ARN –
  123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If
  you specify only the function name, it's limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AmazonManagedKafkaEventSourceConfig"`: Specific configuration settings for an Amazon
  Managed Streaming for Apache Kafka (Amazon MSK) event source.
- `"BatchSize"`: The maximum number of records in each batch that Lambda pulls from your
  stream or queue and sends to your function. Lambda passes all of the records in the batch
  to the function in a single call, up to the payload limit for synchronous invocation (6
  MB).    Amazon Kinesis – Default 100. Max 10,000.    Amazon DynamoDB Streams – Default
  100. Max 10,000.    Amazon Simple Queue Service – Default 10. For standard queues the max
  is 10,000. For FIFO queues the max is 10.    Amazon Managed Streaming for Apache Kafka –
  Default 100. Max 10,000.    Self-managed Apache Kafka – Default 100. Max 10,000.
  Amazon MQ (ActiveMQ and RabbitMQ) – Default 100. Max 10,000.    DocumentDB – Default
  100. Max 10,000.
- `"BisectBatchOnFunctionError"`: (Kinesis and DynamoDB Streams only) If the function
  returns an error, split the batch in two and retry.
- `"DestinationConfig"`: (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka
  only) A configuration object that specifies the destination of an event after Lambda
  processes it.
- `"DocumentDBEventSourceConfig"`: Specific configuration settings for a DocumentDB event
  source.
- `"Enabled"`: When true, the event source mapping is active. When false, Lambda pauses
  polling and invocation. Default: True
- `"EventSourceArn"`: The Amazon Resource Name (ARN) of the event source.    Amazon Kinesis
  – The ARN of the data stream or a stream consumer.    Amazon DynamoDB Streams – The ARN
  of the stream.    Amazon Simple Queue Service – The ARN of the queue.    Amazon Managed
  Streaming for Apache Kafka – The ARN of the cluster or the ARN of the VPC connection (for
  cross-account event source mappings).    Amazon MQ – The ARN of the broker.    Amazon
  DocumentDB – The ARN of the DocumentDB change stream.
- `"FilterCriteria"`: An object that defines the filter criteria that determine whether
  Lambda should process an event. For more information, see Lambda event filtering.
- `"FunctionResponseTypes"`: (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current
  response type enums applied to the event source mapping.
- `"MaximumBatchingWindowInSeconds"`: The maximum amount of time, in seconds, that Lambda
  spends gathering records before invoking the function. You can configure
  MaximumBatchingWindowInSeconds to any value from 0 seconds to 300 seconds in increments of
  seconds. For streams and Amazon SQS event sources, the default batching window is 0
  seconds. For Amazon MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB event
  sources, the default batching window is 500 ms. Note that because you can only change
  MaximumBatchingWindowInSeconds in increments of seconds, you cannot revert back to the 500
  ms default batching window after you have changed it. To restore the default batching
  window, you must create a new event source mapping. Related setting: For streams and Amazon
  SQS event sources, when you set BatchSize to a value greater than 10, you must set
  MaximumBatchingWindowInSeconds to at least 1.
- `"MaximumRecordAgeInSeconds"`: (Kinesis and DynamoDB Streams only) Discard records older
  than the specified age. The default value is infinite (-1).
- `"MaximumRetryAttempts"`: (Kinesis and DynamoDB Streams only) Discard records after the
  specified number of retries. The default value is infinite (-1). When set to infinite (-1),
  failed records are retried until the record expires.
- `"ParallelizationFactor"`: (Kinesis and DynamoDB Streams only) The number of batches to
  process from each shard concurrently.
- `"Queues"`:  (MQ) The name of the Amazon MQ broker destination queue to consume.
- `"ScalingConfig"`: (Amazon SQS only) The scaling configuration for the event source. For
  more information, see Configuring maximum concurrency for Amazon SQS event sources.
- `"SelfManagedEventSource"`: The self-managed Apache Kafka cluster to receive records from.
- `"SelfManagedKafkaEventSourceConfig"`: Specific configuration settings for a self-managed
  Apache Kafka event source.
- `"SourceAccessConfigurations"`: An array of authentication protocols or VPC components
  required to secure your event source.
- `"StartingPosition"`: The position in a stream from which to start reading. Required for
  Amazon Kinesis and Amazon DynamoDB Stream event sources. AT_TIMESTAMP is supported only for
  Amazon Kinesis streams, Amazon DocumentDB, Amazon MSK, and self-managed Apache Kafka.
- `"StartingPositionTimestamp"`: With StartingPosition set to AT_TIMESTAMP, the time from
  which to start reading. StartingPositionTimestamp cannot be in the future.
- `"Topics"`: The name of the Kafka topic.
- `"TumblingWindowInSeconds"`: (Kinesis and DynamoDB Streams only) The duration in seconds
  of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds
  indicates no tumbling window.
"""
function create_event_source_mapping(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2015-03-31/event-source-mappings/",
        Dict{String,Any}("FunctionName" => FunctionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_event_source_mapping(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2015-03-31/event-source-mappings/",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("FunctionName" => FunctionName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_function(code, function_name, role)
    create_function(code, function_name, role, params::Dict{String,<:Any})

Creates a Lambda function. To create a function, you need a deployment package and an
execution role. The deployment package is a .zip file archive or container image that
contains your function code. The execution role grants the function permission to use
Amazon Web Services, such as Amazon CloudWatch Logs for log streaming and X-Ray for request
tracing. If the deployment package is a container image, then you set the package type to
Image. For a container image, the code property must include the URI of a container image
in the Amazon ECR registry. You do not need to specify the handler and runtime properties.
If the deployment package is a .zip file archive, then you set the package type to Zip. For
a .zip file archive, the code property specifies the location of the .zip file. You must
also specify the handler and runtime properties. The code in the deployment package must be
compatible with the target instruction set architecture of the function (x86-64 or arm64).
If you do not specify the architecture, then the default value is x86-64. When you create a
function, Lambda provisions an instance of the function and its supporting resources. If
your function connects to a VPC, this process can take a minute or so. During this time,
you can't invoke or modify the function. The State, StateReason, and StateReasonCode fields
in the response from GetFunctionConfiguration indicate when the function is ready to
invoke. For more information, see Lambda function states. A function has an unpublished
version, and can have published versions and aliases. The unpublished version changes when
you update your function's code and configuration. A published version is a snapshot of
your function code and configuration that can't be changed. An alias is a named resource
that maps to a version, and can be changed to map to a different version. Use the Publish
parameter to create version 1 of your function from its initial configuration. The other
parameters let you configure version-specific and function-level settings. You can modify
version-specific settings later with UpdateFunctionConfiguration. Function-level settings
apply to both the unpublished and published versions of the function, and include tags
(TagResource) and per-function concurrency limits (PutFunctionConcurrency). You can use
code signing if your deployment package is a .zip file archive. To enable code signing for
this function, specify the ARN of a code-signing configuration. When a user attempts to
deploy a code package with UpdateFunctionCode, Lambda checks that the code package has a
valid signature from a trusted publisher. The code-signing configuration includes set of
signing profiles, which define the trusted publishers for this function. If another Amazon
Web Services account or an Amazon Web Service invokes your function, use AddPermission to
grant permission by creating a resource-based Identity and Access Management (IAM) policy.
You can grant permissions at the function level, on a version, or on an alias. To invoke
your function directly, use Invoke. To invoke your function in response to events in other
Amazon Web Services, create an event source mapping (CreateEventSourceMapping), or
configure a function trigger in the other service. For more information, see Invoking
Lambda functions.

# Arguments
- `code`: The code for the function.
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.
- `role`: The Amazon Resource Name (ARN) of the function's execution role.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Architectures"`: The instruction set architecture that the function supports. Enter a
  string array with one of the valid values (arm64 or x86_64). The default value is x86_64.
- `"CodeSigningConfigArn"`: To enable code signing for this function, specify the ARN of a
  code-signing configuration. A code-signing configuration includes a set of signing
  profiles, which define the trusted publishers for this function.
- `"DeadLetterConfig"`: A dead-letter queue configuration that specifies the queue or topic
  where Lambda sends asynchronous events when they fail processing. For more information, see
  Dead-letter queues.
- `"Description"`: A description of the function.
- `"Environment"`: Environment variables that are accessible from function code during
  execution.
- `"EphemeralStorage"`: The size of the function's /tmp directory in MB. The default value
  is 512, but can be any whole number between 512 and 10,240 MB. For more information, see
  Configuring ephemeral storage (console).
- `"FileSystemConfigs"`: Connection settings for an Amazon EFS file system.
- `"Handler"`: The name of the method within your code that Lambda calls to run your
  function. Handler is required if the deployment package is a .zip file archive. The format
  includes the file name. It can also include namespaces and other qualifiers, depending on
  the runtime. For more information, see Lambda programming model.
- `"ImageConfig"`: Container image configuration values that override the values in the
  container image Dockerfile.
- `"KMSKeyArn"`: The ARN of the Key Management Service (KMS) customer managed key that's
  used to encrypt your function's environment variables. When Lambda SnapStart is activated,
  Lambda also uses this key is to encrypt your function's snapshot. If you deploy your
  function using a container image, Lambda also uses this key to encrypt your function when
  it's deployed. Note that this is not the same key that's used to protect your container
  image in the Amazon Elastic Container Registry (Amazon ECR). If you don't provide a
  customer managed key, Lambda uses a default service key.
- `"Layers"`: A list of function layers to add to the function's execution environment.
  Specify each layer by its ARN, including the version.
- `"LoggingConfig"`: The function's Amazon CloudWatch Logs configuration settings.
- `"MemorySize"`: The amount of memory available to the function at runtime. Increasing the
  function memory also increases its CPU allocation. The default value is 128 MB. The value
  can be any multiple of 1 MB.
- `"PackageType"`: The type of deployment package. Set to Image for container image and set
  to Zip for .zip file archive.
- `"Publish"`: Set to true to publish the first version of the function during creation.
- `"Runtime"`: The identifier of the function's runtime. Runtime is required if the
  deployment package is a .zip file archive. The following list includes deprecated runtimes.
  For more information, see Runtime deprecation policy.
- `"SnapStart"`: The function's SnapStart setting.
- `"Tags"`: A list of tags to apply to the function.
- `"Timeout"`: The amount of time (in seconds) that Lambda allows a function to run before
  stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more
  information, see Lambda execution environment.
- `"TracingConfig"`: Set Mode to Active to sample and trace a subset of incoming requests
  with X-Ray.
- `"VpcConfig"`: For network connectivity to Amazon Web Services resources in a VPC,
  specify a list of security groups and subnets in the VPC. When you connect a function to a
  VPC, it can access resources and the internet only through that VPC. For more information,
  see Configuring a Lambda function to access resources in a VPC.
"""
function create_function(
    Code, FunctionName, Role; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2015-03-31/functions",
        Dict{String,Any}("Code" => Code, "FunctionName" => FunctionName, "Role" => Role);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_function(
    Code,
    FunctionName,
    Role,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2015-03-31/functions",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Code" => Code, "FunctionName" => FunctionName, "Role" => Role
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_function_url_config(auth_type, function_name)
    create_function_url_config(auth_type, function_name, params::Dict{String,<:Any})

Creates a Lambda function URL with the specified configuration parameters. A function URL
is a dedicated HTTP(S) endpoint that you can use to invoke your function.

# Arguments
- `auth_type`: The type of authentication that your function URL uses. Set to AWS_IAM if
  you want to restrict access to authenticated users only. Set to NONE if you want to bypass
  IAM authentication to create a public endpoint. For more information, see Security and auth
  model for Lambda function URLs.
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Cors"`: The cross-origin resource sharing (CORS) settings for your function URL.
- `"InvokeMode"`: Use one of the following options:    BUFFERED – This is the default
  option. Lambda invokes your function using the Invoke API operation. Invocation results are
  available when the payload is complete. The maximum payload size is 6 MB.
  RESPONSE_STREAM – Your function streams payload results as they become available. Lambda
  invokes your function using the InvokeWithResponseStream API operation. The maximum
  response payload size is 20 MB, however, you can request a quota increase.
- `"Qualifier"`: The alias name.
"""
function create_function_url_config(
    AuthType, FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2021-10-31/functions/$(FunctionName)/url",
        Dict{String,Any}("AuthType" => AuthType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_function_url_config(
    AuthType,
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2021-10-31/functions/$(FunctionName)/url",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("AuthType" => AuthType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_alias(function_name, name)
    delete_alias(function_name, name, params::Dict{String,<:Any})

Deletes a Lambda function alias.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.
- `name`: The name of the alias.

"""
function delete_alias(
    FunctionName, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2015-03-31/functions/$(FunctionName)/aliases/$(Name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_alias(
    FunctionName,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2015-03-31/functions/$(FunctionName)/aliases/$(Name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_code_signing_config(code_signing_config_arn)
    delete_code_signing_config(code_signing_config_arn, params::Dict{String,<:Any})

Deletes the code signing configuration. You can delete the code signing configuration only
if no function is using it.

# Arguments
- `code_signing_config_arn`: The The Amazon Resource Name (ARN) of the code signing
  configuration.

"""
function delete_code_signing_config(
    CodeSigningConfigArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2020-04-22/code-signing-configs/$(CodeSigningConfigArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_code_signing_config(
    CodeSigningConfigArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2020-04-22/code-signing-configs/$(CodeSigningConfigArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_event_source_mapping(uuid)
    delete_event_source_mapping(uuid, params::Dict{String,<:Any})

Deletes an event source mapping. You can get the identifier of a mapping from the output of
ListEventSourceMappings. When you delete an event source mapping, it enters a Deleting
state and might not be completely deleted for several seconds.

# Arguments
- `uuid`: The identifier of the event source mapping.

"""
function delete_event_source_mapping(
    UUID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2015-03-31/event-source-mappings/$(UUID)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_event_source_mapping(
    UUID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2015-03-31/event-source-mappings/$(UUID)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_function(function_name)
    delete_function(function_name, params::Dict{String,<:Any})

Deletes a Lambda function. To delete a specific function version, use the Qualifier
parameter. Otherwise, all versions and aliases are deleted. This doesn't require the user
to have explicit permissions for DeleteAlias. To delete Lambda event source mappings that
invoke a function, use DeleteEventSourceMapping. For Amazon Web Services and resources that
invoke your function directly, delete the trigger in the service where you originally
configured it.

# Arguments
- `function_name`: The name or ARN of the Lambda function or version.  Name formats
  Function name – my-function (name-only), my-function:1 (with version).    Function ARN
  – arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: Specify a version to delete. You can't delete a version that an alias
  references.
"""
function delete_function(FunctionName; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "DELETE",
        "/2015-03-31/functions/$(FunctionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_function(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2015-03-31/functions/$(FunctionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_function_code_signing_config(function_name)
    delete_function_code_signing_config(function_name, params::Dict{String,<:Any})

Removes the code signing configuration from the function.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.

"""
function delete_function_code_signing_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2020-06-30/functions/$(FunctionName)/code-signing-config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_function_code_signing_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2020-06-30/functions/$(FunctionName)/code-signing-config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_function_concurrency(function_name)
    delete_function_concurrency(function_name, params::Dict{String,<:Any})

Removes a concurrent execution limit from a function.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

"""
function delete_function_concurrency(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2017-10-31/functions/$(FunctionName)/concurrency";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_function_concurrency(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2017-10-31/functions/$(FunctionName)/concurrency",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_function_event_invoke_config(function_name)
    delete_function_event_invoke_config(function_name, params::Dict{String,<:Any})

Deletes the configuration for asynchronous invocation for a function, version, or alias. To
configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN -
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN -
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: A version number or alias name.
"""
function delete_function_event_invoke_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_function_event_invoke_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_function_url_config(function_name)
    delete_function_url_config(function_name, params::Dict{String,<:Any})

Deletes a Lambda function URL. When you delete a function URL, you can't recover it.
Creating a new function URL results in a different URL address.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: The alias name.
"""
function delete_function_url_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2021-10-31/functions/$(FunctionName)/url";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_function_url_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2021-10-31/functions/$(FunctionName)/url",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_layer_version(layer_name, version_number)
    delete_layer_version(layer_name, version_number, params::Dict{String,<:Any})

Deletes a version of an Lambda layer. Deleted versions can no longer be viewed or added to
functions. To avoid breaking functions, a copy of the version remains in Lambda until no
functions refer to it.

# Arguments
- `layer_name`: The name or Amazon Resource Name (ARN) of the layer.
- `version_number`: The version number.

"""
function delete_layer_version(
    LayerName, VersionNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_layer_version(
    LayerName,
    VersionNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_provisioned_concurrency_config(function_name, qualifier)
    delete_provisioned_concurrency_config(function_name, qualifier, params::Dict{String,<:Any})

Deletes the provisioned concurrency configuration for a function.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.
- `qualifier`: The version number or alias name.

"""
function delete_provisioned_concurrency_config(
    FunctionName, Qualifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2019-09-30/functions/$(FunctionName)/provisioned-concurrency",
        Dict{String,Any}("Qualifier" => Qualifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_provisioned_concurrency_config(
    FunctionName,
    Qualifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2019-09-30/functions/$(FunctionName)/provisioned-concurrency",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Qualifier" => Qualifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_account_settings()
    get_account_settings(params::Dict{String,<:Any})

Retrieves details about your account's limits and usage in an Amazon Web Services Region.

"""
function get_account_settings(; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2016-08-19/account-settings/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_account_settings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2016-08-19/account-settings/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_alias(function_name, name)
    get_alias(function_name, name, params::Dict{String,<:Any})

Returns details about a Lambda function alias.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.
- `name`: The name of the alias.

"""
function get_alias(FunctionName, Name; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/aliases/$(Name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_alias(
    FunctionName,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/aliases/$(Name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_code_signing_config(code_signing_config_arn)
    get_code_signing_config(code_signing_config_arn, params::Dict{String,<:Any})

Returns information about the specified code signing configuration.

# Arguments
- `code_signing_config_arn`: The The Amazon Resource Name (ARN) of the code signing
  configuration.

"""
function get_code_signing_config(
    CodeSigningConfigArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2020-04-22/code-signing-configs/$(CodeSigningConfigArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_code_signing_config(
    CodeSigningConfigArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2020-04-22/code-signing-configs/$(CodeSigningConfigArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_event_source_mapping(uuid)
    get_event_source_mapping(uuid, params::Dict{String,<:Any})

Returns details about an event source mapping. You can get the identifier of a mapping from
the output of ListEventSourceMappings.

# Arguments
- `uuid`: The identifier of the event source mapping.

"""
function get_event_source_mapping(UUID; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2015-03-31/event-source-mappings/$(UUID)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_event_source_mapping(
    UUID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2015-03-31/event-source-mappings/$(UUID)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_function(function_name)
    get_function(function_name, params::Dict{String,<:Any})

Returns information about the function or function version, with a link to download the
deployment package that's valid for 10 minutes. If you specify a function version, only
details that are specific to that version are returned.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name – my-function (name-only), my-function:v1 (with alias).    Function ARN
  – arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: Specify a version or alias to get details about a published version of the
  function.
"""
function get_function(FunctionName; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_function(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_function_code_signing_config(function_name)
    get_function_code_signing_config(function_name, params::Dict{String,<:Any})

Returns the code signing configuration for the specified function.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.

"""
function get_function_code_signing_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2020-06-30/functions/$(FunctionName)/code-signing-config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_function_code_signing_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2020-06-30/functions/$(FunctionName)/code-signing-config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_function_concurrency(function_name)
    get_function_concurrency(function_name, params::Dict{String,<:Any})

Returns details about the reserved concurrency configuration for a function. To set a
concurrency limit for a function, use PutFunctionConcurrency.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

"""
function get_function_concurrency(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2019-09-30/functions/$(FunctionName)/concurrency";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_function_concurrency(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2019-09-30/functions/$(FunctionName)/concurrency",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_function_configuration(function_name)
    get_function_configuration(function_name, params::Dict{String,<:Any})

Returns the version-specific settings of a Lambda function or version. The output includes
only options that can vary between versions of a function. To modify these settings, use
UpdateFunctionConfiguration. To get all of a function's details, including function-level
settings, use GetFunction.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name – my-function (name-only), my-function:v1 (with alias).    Function ARN
  – arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: Specify a version or alias to get details about a published version of the
  function.
"""
function get_function_configuration(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_function_configuration(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_function_event_invoke_config(function_name)
    get_function_event_invoke_config(function_name, params::Dict{String,<:Any})

Retrieves the configuration for asynchronous invocation for a function, version, or alias.
To configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN -
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN -
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: A version number or alias name.
"""
function get_function_event_invoke_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_function_event_invoke_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_function_url_config(function_name)
    get_function_url_config(function_name, params::Dict{String,<:Any})

Returns details about a Lambda function URL.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: The alias name.
"""
function get_function_url_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2021-10-31/functions/$(FunctionName)/url";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_function_url_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2021-10-31/functions/$(FunctionName)/url",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_layer_version(layer_name, version_number)
    get_layer_version(layer_name, version_number, params::Dict{String,<:Any})

Returns information about a version of an Lambda layer, with a link to download the layer
archive that's valid for 10 minutes.

# Arguments
- `layer_name`: The name or Amazon Resource Name (ARN) of the layer.
- `version_number`: The version number.

"""
function get_layer_version(
    LayerName, VersionNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_layer_version(
    LayerName,
    VersionNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_layer_version_by_arn(arn)
    get_layer_version_by_arn(arn, params::Dict{String,<:Any})

Returns information about a version of an Lambda layer, with a link to download the layer
archive that's valid for 10 minutes.

# Arguments
- `arn`: The ARN of the layer version.

"""
function get_layer_version_by_arn(Arn; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2018-10-31/layers?find=LayerVersion",
        Dict{String,Any}("Arn" => Arn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_layer_version_by_arn(
    Arn, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2018-10-31/layers?find=LayerVersion",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Arn" => Arn), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_layer_version_policy(layer_name, version_number)
    get_layer_version_policy(layer_name, version_number, params::Dict{String,<:Any})

Returns the permission policy for a version of an Lambda layer. For more information, see
AddLayerVersionPermission.

# Arguments
- `layer_name`: The name or Amazon Resource Name (ARN) of the layer.
- `version_number`: The version number.

"""
function get_layer_version_policy(
    LayerName, VersionNumber; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_layer_version_policy(
    LayerName,
    VersionNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_policy(function_name)
    get_policy(function_name, params::Dict{String,<:Any})

Returns the resource-based IAM policy for a function, version, or alias.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name – my-function (name-only), my-function:v1 (with alias).    Function ARN
  – arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: Specify a version or alias to get the policy for that resource.
"""
function get_policy(FunctionName; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_policy(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_provisioned_concurrency_config(function_name, qualifier)
    get_provisioned_concurrency_config(function_name, qualifier, params::Dict{String,<:Any})

Retrieves the provisioned concurrency configuration for a function's alias or version.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.
- `qualifier`: The version number or alias name.

"""
function get_provisioned_concurrency_config(
    FunctionName, Qualifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2019-09-30/functions/$(FunctionName)/provisioned-concurrency",
        Dict{String,Any}("Qualifier" => Qualifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_provisioned_concurrency_config(
    FunctionName,
    Qualifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2019-09-30/functions/$(FunctionName)/provisioned-concurrency",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Qualifier" => Qualifier), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_runtime_management_config(function_name)
    get_runtime_management_config(function_name, params::Dict{String,<:Any})

Retrieves the runtime management configuration for a function's version. If the runtime
update mode is Manual, this includes the ARN of the runtime version and the runtime update
mode. If the runtime update mode is Auto or Function update, this includes the runtime
update mode and null is returned for the ARN. For more information, see Runtime updates.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: Specify a version of the function. This can be LATEST or a published
  version number. If no value is specified, the configuration for the LATEST version is
  returned.
"""
function get_runtime_management_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2021-07-20/functions/$(FunctionName)/runtime-management-config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_runtime_management_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2021-07-20/functions/$(FunctionName)/runtime-management-config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    invoke(function_name)
    invoke(function_name, params::Dict{String,<:Any})

Invokes a Lambda function. You can invoke a function synchronously (and wait for the
response), or asynchronously. By default, Lambda invokes your function synchronously (i.e.
theInvocationType is RequestResponse). To invoke a function asynchronously, set
InvocationType to Event. Lambda passes the ClientContext object to your function for
synchronous invocations only. For synchronous invocation, details about the function
response, including errors, are included in the response body and headers. For either
invocation type, you can find more information in the execution log and trace. When an
error occurs, your function may be invoked multiple times. Retry behavior varies by error
type, client, event source, and invocation type. For example, if you invoke a function
asynchronously and it returns an error, Lambda executes the function up to two more times.
For more information, see Error handling and automatic retries in Lambda. For asynchronous
invocation, Lambda adds events to a queue before sending them to your function. If your
function does not have enough capacity to keep up with the queue, events may be lost.
Occasionally, your function may receive the same event multiple times, even if no error
occurs. To retain events that were not processed, configure your function with a
dead-letter queue. The status code in the API response doesn't reflect function errors.
Error codes are reserved for errors that prevent your function from executing, such as
permissions errors, quota errors, or issues with your function's code and configuration.
For example, Lambda returns TooManyRequestsException if running the function would cause
you to exceed a concurrency limit at either the account level
(ConcurrentInvocationLimitExceeded) or function level
(ReservedFunctionConcurrentInvocationLimitExceeded). For functions with a long timeout,
your client might disconnect during synchronous invocation while it waits for a response.
Configure your HTTP client, SDK, firewall, proxy, or operating system to allow for long
connections with timeout or keep-alive settings. This operation requires permission for the
lambda:InvokeFunction action. For details on how to set up permissions for cross-account
invocations, see Granting function access to other accounts.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name – my-function (name-only), my-function:v1 (with alias).    Function ARN
  – arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Payload"`: The JSON that you want to provide to your Lambda function as input. You can
  enter the JSON directly. For example, --payload '{ \"key\": \"value\" }'. You can also
  specify a file path. For example, --payload file://payload.json.
- `"Qualifier"`: Specify a version or alias to invoke a published version of the function.
- `"X-Amz-Client-Context"`: Up to 3,583 bytes of base64-encoded data about the invoking
  client to pass to the function in the context object. Lambda passes the ClientContext
  object to your function for synchronous invocations only.
- `"X-Amz-Invocation-Type"`: Choose from the following options.    RequestResponse
  (default) – Invoke the function synchronously. Keep the connection open until the
  function returns a response or times out. The API response includes the function response
  and additional data.    Event – Invoke the function asynchronously. Send events that fail
  multiple times to the function's dead-letter queue (if one is configured). The API response
  only includes a status code.    DryRun – Validate parameter values and verify that the
  user or role has permission to invoke the function.
- `"X-Amz-Log-Type"`: Set to Tail to include the execution log in the response. Applies to
  synchronously invoked functions only.
"""
function invoke(FunctionName; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "POST",
        "/2015-03-31/functions/$(FunctionName)/invocations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invoke(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2015-03-31/functions/$(FunctionName)/invocations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    invoke_async(function_name, invoke_args)
    invoke_async(function_name, invoke_args, params::Dict{String,<:Any})

 For asynchronous function invocation, use Invoke.  Invokes a function asynchronously.  If
you do use the InvokeAsync action, note that it doesn't support the use of X-Ray active
tracing. Trace ID is not propagated to the function, even if X-Ray active tracing is turned
on.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.
- `invoke_args`: The JSON that you want to provide to your Lambda function as input.

"""
function invoke_async(
    FunctionName, InvokeArgs; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2014-11-13/functions/$(FunctionName)/invoke-async/",
        Dict{String,Any}("InvokeArgs" => InvokeArgs);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invoke_async(
    FunctionName,
    InvokeArgs,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2014-11-13/functions/$(FunctionName)/invoke-async/",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("InvokeArgs" => InvokeArgs), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    invoke_with_response_stream(function_name)
    invoke_with_response_stream(function_name, params::Dict{String,<:Any})

Configure your Lambda functions to stream response payloads back to clients. For more
information, see Configuring a Lambda function to stream responses. This operation requires
permission for the lambda:InvokeFunction action. For details on how to set up permissions
for cross-account invocations, see Granting function access to other accounts.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Payload"`: The JSON that you want to provide to your Lambda function as input. You can
  enter the JSON directly. For example, --payload '{ \"key\": \"value\" }'. You can also
  specify a file path. For example, --payload file://payload.json.
- `"Qualifier"`: The alias name.
- `"X-Amz-Client-Context"`: Up to 3,583 bytes of base64-encoded data about the invoking
  client to pass to the function in the context object.
- `"X-Amz-Invocation-Type"`: Use one of the following options:    RequestResponse (default)
  – Invoke the function synchronously. Keep the connection open until the function returns
  a response or times out. The API operation response includes the function response and
  additional data.    DryRun – Validate parameter values and verify that the IAM user or
  role has permission to invoke the function.
- `"X-Amz-Log-Type"`: Set to Tail to include the execution log in the response. Applies to
  synchronously invoked functions only.
"""
function invoke_with_response_stream(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2021-11-15/functions/$(FunctionName)/response-streaming-invocations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function invoke_with_response_stream(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2021-11-15/functions/$(FunctionName)/response-streaming-invocations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_aliases(function_name)
    list_aliases(function_name, params::Dict{String,<:Any})

Returns a list of aliases for a Lambda function.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FunctionVersion"`: Specify a function version to only list aliases that invoke that
  version.
- `"Marker"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"MaxItems"`: Limit the number of aliases returned.
"""
function list_aliases(FunctionName; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/aliases";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_aliases(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/aliases",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_code_signing_configs()
    list_code_signing_configs(params::Dict{String,<:Any})

Returns a list of code signing configurations. A request returns up to 10,000
configurations per call. You can use the MaxItems parameter to return fewer configurations
per call.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"MaxItems"`: Maximum number of items to return.
"""
function list_code_signing_configs(; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2020-04-22/code-signing-configs/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_code_signing_configs(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2020-04-22/code-signing-configs/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_event_source_mappings()
    list_event_source_mappings(params::Dict{String,<:Any})

Lists event source mappings. Specify an EventSourceArn to show only event source mappings
for a single event source.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EventSourceArn"`: The Amazon Resource Name (ARN) of the event source.    Amazon Kinesis
  – The ARN of the data stream or a stream consumer.    Amazon DynamoDB Streams – The ARN
  of the stream.    Amazon Simple Queue Service – The ARN of the queue.    Amazon Managed
  Streaming for Apache Kafka – The ARN of the cluster or the ARN of the VPC connection (for
  cross-account event source mappings).    Amazon MQ – The ARN of the broker.    Amazon
  DocumentDB – The ARN of the DocumentDB change stream.
- `"FunctionName"`: The name or ARN of the Lambda function.  Name formats     Function name
  – MyFunction.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Version or Alias ARN –
  arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.    Partial ARN –
  123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If
  you specify only the function name, it's limited to 64 characters in length.
- `"Marker"`: A pagination token returned by a previous call.
- `"MaxItems"`: The maximum number of event source mappings to return. Note that
  ListEventSourceMappings returns a maximum of 100 items in each response, even if you set
  the number higher.
"""
function list_event_source_mappings(; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2015-03-31/event-source-mappings/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_event_source_mappings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2015-03-31/event-source-mappings/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_function_event_invoke_configs(function_name)
    list_function_event_invoke_configs(function_name, params::Dict{String,<:Any})

Retrieves a list of configurations for asynchronous invocation for a function. To configure
options for asynchronous invocation, use PutFunctionEventInvokeConfig.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - my-function.    Function ARN -
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN -
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"MaxItems"`: The maximum number of configurations to return.
"""
function list_function_event_invoke_configs(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config/list";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_function_event_invoke_configs(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config/list",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_function_url_configs(function_name)
    list_function_url_configs(function_name, params::Dict{String,<:Any})

Returns a list of Lambda function URLs for the specified function.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"MaxItems"`: The maximum number of function URLs to return in the response. Note that
  ListFunctionUrlConfigs returns a maximum of 50 items in each response, even if you set the
  number higher.
"""
function list_function_url_configs(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2021-10-31/functions/$(FunctionName)/urls";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_function_url_configs(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2021-10-31/functions/$(FunctionName)/urls",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_functions()
    list_functions(params::Dict{String,<:Any})

Returns a list of Lambda functions, with the version-specific configuration of each. Lambda
returns up to 50 functions per call. Set FunctionVersion to ALL to include all published
versions of each function in addition to the unpublished version.  The ListFunctions
operation returns a subset of the FunctionConfiguration fields. To get the additional
fields (State, StateReasonCode, StateReason, LastUpdateStatus, LastUpdateStatusReason,
LastUpdateStatusReasonCode, RuntimeVersionConfig) for a function or version, use
GetFunction.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FunctionVersion"`: Set to ALL to include entries for all published versions of each
  function.
- `"Marker"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"MasterRegion"`: For Lambda@Edge functions, the Amazon Web Services Region of the master
  function. For example, us-east-1 filters the list of functions to include only Lambda@Edge
  functions replicated from a master function in US East (N. Virginia). If specified, you
  must set FunctionVersion to ALL.
- `"MaxItems"`: The maximum number of functions to return in the response. Note that
  ListFunctions returns a maximum of 50 items in each response, even if you set the number
  higher.
"""
function list_functions(; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2015-03-31/functions/";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_functions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2015-03-31/functions/",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_functions_by_code_signing_config(code_signing_config_arn)
    list_functions_by_code_signing_config(code_signing_config_arn, params::Dict{String,<:Any})

List the functions that use the specified code signing configuration. You can use this
method prior to deleting a code signing configuration, to verify that no functions are
using it.

# Arguments
- `code_signing_config_arn`: The The Amazon Resource Name (ARN) of the code signing
  configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"MaxItems"`: Maximum number of items to return.
"""
function list_functions_by_code_signing_config(
    CodeSigningConfigArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2020-04-22/code-signing-configs/$(CodeSigningConfigArn)/functions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_functions_by_code_signing_config(
    CodeSigningConfigArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2020-04-22/code-signing-configs/$(CodeSigningConfigArn)/functions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_layer_versions(layer_name)
    list_layer_versions(layer_name, params::Dict{String,<:Any})

Lists the versions of an Lambda layer. Versions that have been deleted aren't listed.
Specify a runtime identifier to list only versions that indicate that they're compatible
with that runtime. Specify a compatible architecture to include only layer versions that
are compatible with that architecture.

# Arguments
- `layer_name`: The name or Amazon Resource Name (ARN) of the layer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CompatibleArchitecture"`: The compatible instruction set architecture.
- `"CompatibleRuntime"`: A runtime identifier. For example, java21. The following list
  includes deprecated runtimes. For more information, see Runtime deprecation policy.
- `"Marker"`: A pagination token returned by a previous call.
- `"MaxItems"`: The maximum number of versions to return.
"""
function list_layer_versions(LayerName; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2018-10-31/layers/$(LayerName)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_layer_versions(
    LayerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2018-10-31/layers/$(LayerName)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_layers()
    list_layers(params::Dict{String,<:Any})

Lists Lambda layers and shows information about the latest version of each. Specify a
runtime identifier to list only layers that indicate that they're compatible with that
runtime. Specify a compatible architecture to include only layers that are compatible with
that instruction set architecture.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CompatibleArchitecture"`: The compatible instruction set architecture.
- `"CompatibleRuntime"`: A runtime identifier. For example, java21. The following list
  includes deprecated runtimes. For more information, see Runtime deprecation policy.
- `"Marker"`: A pagination token returned by a previous call.
- `"MaxItems"`: The maximum number of layers to return.
"""
function list_layers(; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET", "/2018-10-31/layers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_layers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2018-10-31/layers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_provisioned_concurrency_configs(function_name)
    list_provisioned_concurrency_configs(function_name, params::Dict{String,<:Any})

Retrieves a list of provisioned concurrency configurations for a function.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"MaxItems"`: Specify a number to limit the number of configurations returned.
"""
function list_provisioned_concurrency_configs(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2019-09-30/functions/$(FunctionName)/provisioned-concurrency?List=ALL";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_provisioned_concurrency_configs(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2019-09-30/functions/$(FunctionName)/provisioned-concurrency?List=ALL",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags(arn)
    list_tags(arn, params::Dict{String,<:Any})

Returns a function's tags. You can also view tags with GetFunction.

# Arguments
- `arn`: The function's Amazon Resource Name (ARN). Note: Lambda does not support adding
  tags to aliases or versions.

"""
function list_tags(ARN; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "GET",
        "/2017-03-31/tags/$(ARN)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags(
    ARN, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2017-03-31/tags/$(ARN)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_versions_by_function(function_name)
    list_versions_by_function(function_name, params::Dict{String,<:Any})

Returns a list of versions, with the version-specific configuration of each. Lambda returns
up to 50 versions per call.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: Specify the pagination token that's returned by a previous request to
  retrieve the next page of results.
- `"MaxItems"`: The maximum number of versions to return. Note that ListVersionsByFunction
  returns a maximum of 50 items in each response, even if you set the number higher.
"""
function list_versions_by_function(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_versions_by_function(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "GET",
        "/2015-03-31/functions/$(FunctionName)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    publish_layer_version(content, layer_name)
    publish_layer_version(content, layer_name, params::Dict{String,<:Any})

Creates an Lambda layer from a ZIP archive. Each time you call PublishLayerVersion with the
same layer name, a new version is created. Add layers to your function with CreateFunction
or UpdateFunctionConfiguration.

# Arguments
- `content`: The function layer archive.
- `layer_name`: The name or Amazon Resource Name (ARN) of the layer.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CompatibleArchitectures"`: A list of compatible instruction set architectures.
- `"CompatibleRuntimes"`: A list of compatible function runtimes. Used for filtering with
  ListLayers and ListLayerVersions. The following list includes deprecated runtimes. For more
  information, see Runtime deprecation policy.
- `"Description"`: The description of the version.
- `"LicenseInfo"`: The layer's software license. It can be any of the following:   An SPDX
  license identifier. For example, MIT.   The URL of a license hosted on the internet. For
  example, https://opensource.org/licenses/MIT.   The full text of the license.
"""
function publish_layer_version(
    Content, LayerName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2018-10-31/layers/$(LayerName)/versions",
        Dict{String,Any}("Content" => Content);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function publish_layer_version(
    Content,
    LayerName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2018-10-31/layers/$(LayerName)/versions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Content" => Content), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    publish_version(function_name)
    publish_version(function_name, params::Dict{String,<:Any})

Creates a version from the current code and configuration of a function. Use versions to
create a snapshot of your function code and configuration that doesn't change. Lambda
doesn't publish a version if the function's configuration and code haven't changed since
the last version. Use UpdateFunctionCode or UpdateFunctionConfiguration to update the
function before publishing a version. Clients can invoke versions directly or with an
alias. To create an alias, use CreateAlias.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CodeSha256"`: Only publish a version if the hash value matches the value that's
  specified. Use this option to avoid publishing a version if the function code has changed
  since you last updated it. You can get the hash for the version that you uploaded from the
  output of UpdateFunctionCode.
- `"Description"`: A description for the version to override the description in the
  function configuration.
- `"RevisionId"`: Only update the function if the revision ID matches the ID that's
  specified. Use this option to avoid publishing a version if the function configuration has
  changed since you last updated it.
"""
function publish_version(FunctionName; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "POST",
        "/2015-03-31/functions/$(FunctionName)/versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function publish_version(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2015-03-31/functions/$(FunctionName)/versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_function_code_signing_config(code_signing_config_arn, function_name)
    put_function_code_signing_config(code_signing_config_arn, function_name, params::Dict{String,<:Any})

Update the code signing configuration for the function. Changes to the code signing
configuration take effect the next time a user tries to deploy a code package to the
function.

# Arguments
- `code_signing_config_arn`: The The Amazon Resource Name (ARN) of the code signing
  configuration.
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.

"""
function put_function_code_signing_config(
    CodeSigningConfigArn, FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2020-06-30/functions/$(FunctionName)/code-signing-config",
        Dict{String,Any}("CodeSigningConfigArn" => CodeSigningConfigArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_function_code_signing_config(
    CodeSigningConfigArn,
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2020-06-30/functions/$(FunctionName)/code-signing-config",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("CodeSigningConfigArn" => CodeSigningConfigArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_function_concurrency(function_name, reserved_concurrent_executions)
    put_function_concurrency(function_name, reserved_concurrent_executions, params::Dict{String,<:Any})

Sets the maximum number of simultaneous executions for a function, and reserves capacity
for that concurrency level. Concurrency settings apply to the function as a whole,
including all published versions and the unpublished version. Reserving concurrency both
ensures that your function has capacity to process the specified number of events
simultaneously, and prevents it from scaling beyond that level. Use GetFunction to see the
current setting for a function. Use GetAccountSettings to see your Regional concurrency
limit. You can reserve concurrency for as many functions as you like, as long as you leave
at least 100 simultaneous executions unreserved for functions that aren't configured with a
per-function limit. For more information, see Lambda function scaling.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.
- `reserved_concurrent_executions`: The number of simultaneous executions to reserve for
  the function.

"""
function put_function_concurrency(
    FunctionName,
    ReservedConcurrentExecutions;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2017-10-31/functions/$(FunctionName)/concurrency",
        Dict{String,Any}("ReservedConcurrentExecutions" => ReservedConcurrentExecutions);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_function_concurrency(
    FunctionName,
    ReservedConcurrentExecutions,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2017-10-31/functions/$(FunctionName)/concurrency",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ReservedConcurrentExecutions" => ReservedConcurrentExecutions
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_function_event_invoke_config(function_name)
    put_function_event_invoke_config(function_name, params::Dict{String,<:Any})

Configures options for asynchronous invocation on a function, version, or alias. If a
configuration already exists for a function, version, or alias, this operation overwrites
it. If you exclude any settings, they are removed. To set one option without affecting
existing settings for other options, use UpdateFunctionEventInvokeConfig. By default,
Lambda retries an asynchronous invocation twice if the function returns an error. It
retains events in a queue for up to six hours. When an event fails all processing attempts
or stays in the asynchronous invocation queue for too long, Lambda discards it. To retain
discarded events, configure a dead-letter queue with UpdateFunctionConfiguration. To send
an invocation record to a queue, topic, function, or event bus, specify a destination. You
can configure separate destinations for successful invocations (on-success) and events that
fail all processing attempts (on-failure). You can configure destinations in addition to or
instead of a dead-letter queue.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN -
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN -
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationConfig"`: A destination for events after they have been sent to a function
  for processing.  Destinations     Function - The Amazon Resource Name (ARN) of a Lambda
  function.    Queue - The ARN of a standard SQS queue.    Topic - The ARN of a standard SNS
  topic.    Event Bus - The ARN of an Amazon EventBridge event bus.
- `"MaximumEventAgeInSeconds"`: The maximum age of a request that Lambda sends to a
  function for processing.
- `"MaximumRetryAttempts"`: The maximum number of times to retry when the function returns
  an error.
- `"Qualifier"`: A version number or alias name.
"""
function put_function_event_invoke_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_function_event_invoke_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_provisioned_concurrency_config(function_name, provisioned_concurrent_executions, qualifier)
    put_provisioned_concurrency_config(function_name, provisioned_concurrent_executions, qualifier, params::Dict{String,<:Any})

Adds a provisioned concurrency configuration to a function's alias or version.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.
- `provisioned_concurrent_executions`: The amount of provisioned concurrency to allocate
  for the version or alias.
- `qualifier`: The version number or alias name.

"""
function put_provisioned_concurrency_config(
    FunctionName,
    ProvisionedConcurrentExecutions,
    Qualifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2019-09-30/functions/$(FunctionName)/provisioned-concurrency",
        Dict{String,Any}(
            "ProvisionedConcurrentExecutions" => ProvisionedConcurrentExecutions,
            "Qualifier" => Qualifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_provisioned_concurrency_config(
    FunctionName,
    ProvisionedConcurrentExecutions,
    Qualifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2019-09-30/functions/$(FunctionName)/provisioned-concurrency",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ProvisionedConcurrentExecutions" => ProvisionedConcurrentExecutions,
                    "Qualifier" => Qualifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_runtime_management_config(function_name, update_runtime_on)
    put_runtime_management_config(function_name, update_runtime_on, params::Dict{String,<:Any})

Sets the runtime management configuration for a function's version. For more information,
see Runtime updates.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.
- `update_runtime_on`: Specify the runtime update mode.    Auto (default) - Automatically
  update to the most recent and secure runtime version using a Two-phase runtime version
  rollout. This is the best choice for most customers to ensure they always benefit from
  runtime updates.    Function update - Lambda updates the runtime of your function to the
  most recent and secure runtime version when you update your function. This approach
  synchronizes runtime updates with function deployments, giving you control over when
  runtime updates are applied and allowing you to detect and mitigate rare runtime update
  incompatibilities early. When using this setting, you need to regularly update your
  functions to keep their runtime up-to-date.    Manual - You specify a runtime version in
  your function configuration. The function will use this runtime version indefinitely. In
  the rare case where a new runtime version is incompatible with an existing function, this
  allows you to roll back your function to an earlier runtime version. For more information,
  see Roll back a runtime version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: Specify a version of the function. This can be LATEST or a published
  version number. If no value is specified, the configuration for the LATEST version is
  returned.
- `"RuntimeVersionArn"`: The ARN of the runtime version you want the function to use.  This
  is only required if you're using the Manual runtime update mode.
"""
function put_runtime_management_config(
    FunctionName, UpdateRuntimeOn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2021-07-20/functions/$(FunctionName)/runtime-management-config",
        Dict{String,Any}("UpdateRuntimeOn" => UpdateRuntimeOn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_runtime_management_config(
    FunctionName,
    UpdateRuntimeOn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2021-07-20/functions/$(FunctionName)/runtime-management-config",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("UpdateRuntimeOn" => UpdateRuntimeOn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_layer_version_permission(layer_name, statement_id, version_number)
    remove_layer_version_permission(layer_name, statement_id, version_number, params::Dict{String,<:Any})

Removes a statement from the permissions policy for a version of an Lambda layer. For more
information, see AddLayerVersionPermission.

# Arguments
- `layer_name`: The name or Amazon Resource Name (ARN) of the layer.
- `statement_id`: The identifier that was specified when the statement was added.
- `version_number`: The version number.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"RevisionId"`: Only update the policy if the revision ID matches the ID specified. Use
  this option to avoid modifying a policy that has changed since you last read it.
"""
function remove_layer_version_permission(
    LayerName,
    StatementId,
    VersionNumber;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)/policy/$(StatementId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_layer_version_permission(
    LayerName,
    StatementId,
    VersionNumber,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2018-10-31/layers/$(LayerName)/versions/$(VersionNumber)/policy/$(StatementId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_permission(function_name, statement_id)
    remove_permission(function_name, statement_id, params::Dict{String,<:Any})

Revokes function-use permission from an Amazon Web Service or another Amazon Web Services
account. You can get the ID of the statement from the output of GetPolicy.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name – my-function (name-only), my-function:v1 (with alias).    Function ARN
  – arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.
- `statement_id`: Statement ID of the permission to remove.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Qualifier"`: Specify a version or alias to remove permissions from a published version
  of the function.
- `"RevisionId"`: Update the policy only if the revision ID matches the ID that's
  specified. Use this option to avoid modifying a policy that has changed since you last read
  it.
"""
function remove_permission(
    FunctionName, StatementId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "DELETE",
        "/2015-03-31/functions/$(FunctionName)/policy/$(StatementId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_permission(
    FunctionName,
    StatementId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2015-03-31/functions/$(FunctionName)/policy/$(StatementId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(arn, tags)
    tag_resource(arn, tags, params::Dict{String,<:Any})

Adds tags to a function.

# Arguments
- `arn`: The function's Amazon Resource Name (ARN).
- `tags`: A list of tags to apply to the function.

"""
function tag_resource(ARN, Tags; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "POST",
        "/2017-03-31/tags/$(ARN)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    ARN,
    Tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2017-03-31/tags/$(ARN)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(arn, tag_keys)
    untag_resource(arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a function.

# Arguments
- `arn`: The function's Amazon Resource Name (ARN).
- `tag_keys`: A list of tag keys to remove from the function.

"""
function untag_resource(ARN, tagKeys; aws_config::AbstractAWSConfig=current_aws_config())
    return lambda(
        "DELETE",
        "/2017-03-31/tags/$(ARN)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    ARN,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "DELETE",
        "/2017-03-31/tags/$(ARN)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_alias(function_name, name)
    update_alias(function_name, name, params::Dict{String,<:Any})

Updates the configuration of a Lambda function alias.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  - MyFunction.    Function ARN - arn:aws:lambda:us-west-2:123456789012:function:MyFunction.
    Partial ARN - 123456789012:function:MyFunction.   The length constraint applies only to
  the full ARN. If you specify only the function name, it is limited to 64 characters in
  length.
- `name`: The name of the alias.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the alias.
- `"FunctionVersion"`: The function version that the alias invokes.
- `"RevisionId"`: Only update the alias if the revision ID matches the ID that's specified.
  Use this option to avoid modifying an alias that has changed since you last read it.
- `"RoutingConfig"`: The routing configuration of the alias.
"""
function update_alias(
    FunctionName, Name; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2015-03-31/functions/$(FunctionName)/aliases/$(Name)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_alias(
    FunctionName,
    Name,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2015-03-31/functions/$(FunctionName)/aliases/$(Name)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_code_signing_config(code_signing_config_arn)
    update_code_signing_config(code_signing_config_arn, params::Dict{String,<:Any})

Update the code signing configuration. Changes to the code signing configuration take
effect the next time a user tries to deploy a code package to the function.

# Arguments
- `code_signing_config_arn`: The The Amazon Resource Name (ARN) of the code signing
  configuration.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowedPublishers"`: Signing profiles for this code signing configuration.
- `"CodeSigningPolicies"`: The code signing policy.
- `"Description"`: Descriptive name for this code signing configuration.
"""
function update_code_signing_config(
    CodeSigningConfigArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2020-04-22/code-signing-configs/$(CodeSigningConfigArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_code_signing_config(
    CodeSigningConfigArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2020-04-22/code-signing-configs/$(CodeSigningConfigArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_event_source_mapping(uuid)
    update_event_source_mapping(uuid, params::Dict{String,<:Any})

Updates an event source mapping. You can change the function that Lambda invokes, or pause
invocation and resume later from the same location. For details about how to configure
different event sources, see the following topics.      Amazon DynamoDB Streams      Amazon
Kinesis      Amazon SQS      Amazon MQ and RabbitMQ      Amazon MSK      Apache Kafka
Amazon DocumentDB    The following error handling options are available only for stream
sources (DynamoDB and Kinesis):    BisectBatchOnFunctionError – If the function returns
an error, split the batch in two and retry.    DestinationConfig – Send discarded records
to an Amazon SQS queue or Amazon SNS topic.    MaximumRecordAgeInSeconds – Discard
records older than the specified age. The default value is infinite (-1). When set to
infinite (-1), failed records are retried until the record expires    MaximumRetryAttempts
– Discard records after the specified number of retries. The default value is infinite
(-1). When set to infinite (-1), failed records are retried until the record expires.
ParallelizationFactor – Process multiple batches from each shard concurrently.   For
information about which configuration parameters apply to each event source, see the
following topics.     Amazon DynamoDB Streams      Amazon Kinesis      Amazon SQS
Amazon MQ and RabbitMQ      Amazon MSK      Apache Kafka      Amazon DocumentDB

# Arguments
- `uuid`: The identifier of the event source mapping.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BatchSize"`: The maximum number of records in each batch that Lambda pulls from your
  stream or queue and sends to your function. Lambda passes all of the records in the batch
  to the function in a single call, up to the payload limit for synchronous invocation (6
  MB).    Amazon Kinesis – Default 100. Max 10,000.    Amazon DynamoDB Streams – Default
  100. Max 10,000.    Amazon Simple Queue Service – Default 10. For standard queues the max
  is 10,000. For FIFO queues the max is 10.    Amazon Managed Streaming for Apache Kafka –
  Default 100. Max 10,000.    Self-managed Apache Kafka – Default 100. Max 10,000.
  Amazon MQ (ActiveMQ and RabbitMQ) – Default 100. Max 10,000.    DocumentDB – Default
  100. Max 10,000.
- `"BisectBatchOnFunctionError"`: (Kinesis and DynamoDB Streams only) If the function
  returns an error, split the batch in two and retry.
- `"DestinationConfig"`: (Kinesis, DynamoDB Streams, Amazon MSK, and self-managed Kafka
  only) A configuration object that specifies the destination of an event after Lambda
  processes it.
- `"DocumentDBEventSourceConfig"`: Specific configuration settings for a DocumentDB event
  source.
- `"Enabled"`: When true, the event source mapping is active. When false, Lambda pauses
  polling and invocation. Default: True
- `"FilterCriteria"`: An object that defines the filter criteria that determine whether
  Lambda should process an event. For more information, see Lambda event filtering.
- `"FunctionName"`: The name or ARN of the Lambda function.  Name formats     Function name
  – MyFunction.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:MyFunction.    Version or Alias ARN –
  arn:aws:lambda:us-west-2:123456789012:function:MyFunction:PROD.    Partial ARN –
  123456789012:function:MyFunction.   The length constraint applies only to the full ARN. If
  you specify only the function name, it's limited to 64 characters in length.
- `"FunctionResponseTypes"`: (Kinesis, DynamoDB Streams, and Amazon SQS) A list of current
  response type enums applied to the event source mapping.
- `"MaximumBatchingWindowInSeconds"`: The maximum amount of time, in seconds, that Lambda
  spends gathering records before invoking the function. You can configure
  MaximumBatchingWindowInSeconds to any value from 0 seconds to 300 seconds in increments of
  seconds. For streams and Amazon SQS event sources, the default batching window is 0
  seconds. For Amazon MSK, Self-managed Apache Kafka, Amazon MQ, and DocumentDB event
  sources, the default batching window is 500 ms. Note that because you can only change
  MaximumBatchingWindowInSeconds in increments of seconds, you cannot revert back to the 500
  ms default batching window after you have changed it. To restore the default batching
  window, you must create a new event source mapping. Related setting: For streams and Amazon
  SQS event sources, when you set BatchSize to a value greater than 10, you must set
  MaximumBatchingWindowInSeconds to at least 1.
- `"MaximumRecordAgeInSeconds"`: (Kinesis and DynamoDB Streams only) Discard records older
  than the specified age. The default value is infinite (-1).
- `"MaximumRetryAttempts"`: (Kinesis and DynamoDB Streams only) Discard records after the
  specified number of retries. The default value is infinite (-1). When set to infinite (-1),
  failed records are retried until the record expires.
- `"ParallelizationFactor"`: (Kinesis and DynamoDB Streams only) The number of batches to
  process from each shard concurrently.
- `"ScalingConfig"`: (Amazon SQS only) The scaling configuration for the event source. For
  more information, see Configuring maximum concurrency for Amazon SQS event sources.
- `"SourceAccessConfigurations"`: An array of authentication protocols or VPC components
  required to secure your event source.
- `"TumblingWindowInSeconds"`: (Kinesis and DynamoDB Streams only) The duration in seconds
  of a processing window for DynamoDB and Kinesis Streams event sources. A value of 0 seconds
  indicates no tumbling window.
"""
function update_event_source_mapping(
    UUID; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2015-03-31/event-source-mappings/$(UUID)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_event_source_mapping(
    UUID, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2015-03-31/event-source-mappings/$(UUID)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_function_code(function_name)
    update_function_code(function_name, params::Dict{String,<:Any})

Updates a Lambda function's code. If code signing is enabled for the function, the code
package must be signed by a trusted publisher. For more information, see Configuring code
signing for Lambda. If the function's package type is Image, then you must specify the code
package in ImageUri as the URI of a container image in the Amazon ECR registry. If the
function's package type is Zip, then you must specify the deployment package as a .zip file
archive. Enter the Amazon S3 bucket and key of the code .zip file location. You can also
provide the function code inline using the ZipFile field. The code in the deployment
package must be compatible with the target instruction set architecture of the function
(x86-64 or arm64). The function's code is locked when you publish a version. You can't
modify the code of a published version, only the unpublished version.  For a function
defined as a container image, Lambda resolves the image tag to an image digest. In Amazon
ECR, if you update the image tag to a new image, Lambda does not automatically update the
function.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Architectures"`: The instruction set architecture that the function supports. Enter a
  string array with one of the valid values (arm64 or x86_64). The default value is x86_64.
- `"DryRun"`: Set to true to validate the request parameters and access permissions without
  modifying the function code.
- `"ImageUri"`: URI of a container image in the Amazon ECR registry. Do not use for a
  function defined with a .zip file archive.
- `"Publish"`: Set to true to publish a new version of the function after updating the
  code. This has the same effect as calling PublishVersion separately.
- `"RevisionId"`: Update the function only if the revision ID matches the ID that's
  specified. Use this option to avoid modifying a function that has changed since you last
  read it.
- `"S3Bucket"`: An Amazon S3 bucket in the same Amazon Web Services Region as your
  function. The bucket can be in a different Amazon Web Services account. Use only with a
  function defined with a .zip file archive deployment package.
- `"S3Key"`: The Amazon S3 key of the deployment package. Use only with a function defined
  with a .zip file archive deployment package.
- `"S3ObjectVersion"`: For versioned objects, the version of the deployment package object
  to use.
- `"ZipFile"`: The base64-encoded contents of the deployment package. Amazon Web Services
  SDK and CLI clients handle the encoding for you. Use only with a function defined with a
  .zip file archive deployment package.
"""
function update_function_code(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2015-03-31/functions/$(FunctionName)/code";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_function_code(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2015-03-31/functions/$(FunctionName)/code",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_function_configuration(function_name)
    update_function_configuration(function_name, params::Dict{String,<:Any})

Modify the version-specific settings of a Lambda function. When you update a function,
Lambda provisions an instance of the function and its supporting resources. If your
function connects to a VPC, this process can take a minute. During this time, you can't
modify the function, but you can still invoke it. The LastUpdateStatus,
LastUpdateStatusReason, and LastUpdateStatusReasonCode fields in the response from
GetFunctionConfiguration indicate when the update is complete and the function is
processing events with the new configuration. For more information, see Lambda function
states. These settings can vary between versions of a function and are locked when you
publish a version. You can't modify the configuration of a published version, only the
unpublished version. To configure function concurrency, use PutFunctionConcurrency. To
grant invoke permissions to an Amazon Web Services account or Amazon Web Service, use
AddPermission.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeadLetterConfig"`: A dead-letter queue configuration that specifies the queue or topic
  where Lambda sends asynchronous events when they fail processing. For more information, see
  Dead-letter queues.
- `"Description"`: A description of the function.
- `"Environment"`: Environment variables that are accessible from function code during
  execution.
- `"EphemeralStorage"`: The size of the function's /tmp directory in MB. The default value
  is 512, but can be any whole number between 512 and 10,240 MB. For more information, see
  Configuring ephemeral storage (console).
- `"FileSystemConfigs"`: Connection settings for an Amazon EFS file system.
- `"Handler"`: The name of the method within your code that Lambda calls to run your
  function. Handler is required if the deployment package is a .zip file archive. The format
  includes the file name. It can also include namespaces and other qualifiers, depending on
  the runtime. For more information, see Lambda programming model.
- `"ImageConfig"`:  Container image configuration values that override the values in the
  container image Docker file.
- `"KMSKeyArn"`: The ARN of the Key Management Service (KMS) customer managed key that's
  used to encrypt your function's environment variables. When Lambda SnapStart is activated,
  Lambda also uses this key is to encrypt your function's snapshot. If you deploy your
  function using a container image, Lambda also uses this key to encrypt your function when
  it's deployed. Note that this is not the same key that's used to protect your container
  image in the Amazon Elastic Container Registry (Amazon ECR). If you don't provide a
  customer managed key, Lambda uses a default service key.
- `"Layers"`: A list of function layers to add to the function's execution environment.
  Specify each layer by its ARN, including the version.
- `"LoggingConfig"`: The function's Amazon CloudWatch Logs configuration settings.
- `"MemorySize"`: The amount of memory available to the function at runtime. Increasing the
  function memory also increases its CPU allocation. The default value is 128 MB. The value
  can be any multiple of 1 MB.
- `"RevisionId"`: Update the function only if the revision ID matches the ID that's
  specified. Use this option to avoid modifying a function that has changed since you last
  read it.
- `"Role"`: The Amazon Resource Name (ARN) of the function's execution role.
- `"Runtime"`: The identifier of the function's runtime. Runtime is required if the
  deployment package is a .zip file archive. The following list includes deprecated runtimes.
  For more information, see Runtime deprecation policy.
- `"SnapStart"`: The function's SnapStart setting.
- `"Timeout"`: The amount of time (in seconds) that Lambda allows a function to run before
  stopping it. The default is 3 seconds. The maximum allowed value is 900 seconds. For more
  information, see Lambda execution environment.
- `"TracingConfig"`: Set Mode to Active to sample and trace a subset of incoming requests
  with X-Ray.
- `"VpcConfig"`: For network connectivity to Amazon Web Services resources in a VPC,
  specify a list of security groups and subnets in the VPC. When you connect a function to a
  VPC, it can access resources and the internet only through that VPC. For more information,
  see Configuring a Lambda function to access resources in a VPC.
"""
function update_function_configuration(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2015-03-31/functions/$(FunctionName)/configuration";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_function_configuration(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2015-03-31/functions/$(FunctionName)/configuration",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_function_event_invoke_config(function_name)
    update_function_event_invoke_config(function_name, params::Dict{String,<:Any})

Updates the configuration for asynchronous invocation for a function, version, or alias. To
configure options for asynchronous invocation, use PutFunctionEventInvokeConfig.

# Arguments
- `function_name`: The name or ARN of the Lambda function, version, or alias.  Name formats
      Function name - my-function (name-only), my-function:v1 (with alias).    Function ARN -
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN -
  123456789012:function:my-function.   You can append a version number or alias to any of the
  formats. The length constraint applies only to the full ARN. If you specify only the
  function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationConfig"`: A destination for events after they have been sent to a function
  for processing.  Destinations     Function - The Amazon Resource Name (ARN) of a Lambda
  function.    Queue - The ARN of a standard SQS queue.    Topic - The ARN of a standard SNS
  topic.    Event Bus - The ARN of an Amazon EventBridge event bus.
- `"MaximumEventAgeInSeconds"`: The maximum age of a request that Lambda sends to a
  function for processing.
- `"MaximumRetryAttempts"`: The maximum number of times to retry when the function returns
  an error.
- `"Qualifier"`: A version number or alias name.
"""
function update_function_event_invoke_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "POST",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_function_event_invoke_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "POST",
        "/2019-09-25/functions/$(FunctionName)/event-invoke-config",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_function_url_config(function_name)
    update_function_url_config(function_name, params::Dict{String,<:Any})

Updates the configuration for a Lambda function URL.

# Arguments
- `function_name`: The name or ARN of the Lambda function.  Name formats     Function name
  – my-function.    Function ARN –
  arn:aws:lambda:us-west-2:123456789012:function:my-function.    Partial ARN –
  123456789012:function:my-function.   The length constraint applies only to the full ARN. If
  you specify only the function name, it is limited to 64 characters in length.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuthType"`: The type of authentication that your function URL uses. Set to AWS_IAM if
  you want to restrict access to authenticated users only. Set to NONE if you want to bypass
  IAM authentication to create a public endpoint. For more information, see Security and auth
  model for Lambda function URLs.
- `"Cors"`: The cross-origin resource sharing (CORS) settings for your function URL.
- `"InvokeMode"`: Use one of the following options:    BUFFERED – This is the default
  option. Lambda invokes your function using the Invoke API operation. Invocation results are
  available when the payload is complete. The maximum payload size is 6 MB.
  RESPONSE_STREAM – Your function streams payload results as they become available. Lambda
  invokes your function using the InvokeWithResponseStream API operation. The maximum
  response payload size is 20 MB, however, you can request a quota increase.
- `"Qualifier"`: The alias name.
"""
function update_function_url_config(
    FunctionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return lambda(
        "PUT",
        "/2021-10-31/functions/$(FunctionName)/url";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_function_url_config(
    FunctionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return lambda(
        "PUT",
        "/2021-10-31/functions/$(FunctionName)/url",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
