# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: networkmanager
using AWS.Compat
using AWS.UUIDs

"""
    accept_attachment(attachment_id)
    accept_attachment(attachment_id, params::Dict{String,<:Any})

Accepts a core network attachment request.  Once the attachment request is accepted by a
core network owner, the attachment is created and connected to a core network.

# Arguments
- `attachment_id`: The ID of the attachment.

"""
function accept_attachment(attachmentId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "POST",
        "/attachments/$(attachmentId)/accept";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function accept_attachment(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/attachments/$(attachmentId)/accept",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_connect_peer(connect_peer_id, device_id, global_network_id)
    associate_connect_peer(connect_peer_id, device_id, global_network_id, params::Dict{String,<:Any})

Associates a core network Connect peer with a device and optionally, with a link.  If you
specify a link, it must be associated with the specified device. You can only associate
core network Connect peers that have been created on a core network Connect attachment on a
core network.

# Arguments
- `connect_peer_id`: The ID of the Connect peer.
- `device_id`: The ID of the device.
- `global_network_id`: The ID of your global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LinkId"`: The ID of the link.
"""
function associate_connect_peer(
    ConnectPeerId,
    DeviceId,
    globalNetworkId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/connect-peer-associations",
        Dict{String,Any}("ConnectPeerId" => ConnectPeerId, "DeviceId" => DeviceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_connect_peer(
    ConnectPeerId,
    DeviceId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/connect-peer-associations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ConnectPeerId" => ConnectPeerId, "DeviceId" => DeviceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_customer_gateway(customer_gateway_arn, device_id, global_network_id)
    associate_customer_gateway(customer_gateway_arn, device_id, global_network_id, params::Dict{String,<:Any})

Associates a customer gateway with a device and optionally, with a link. If you specify a
link, it must be associated with the specified device.  You can only associate customer
gateways that are connected to a VPN attachment on a transit gateway or core network
registered in your global network. When you register a transit gateway or core network,
customer gateways that are connected to the transit gateway are automatically included in
the global network. To list customer gateways that are connected to a transit gateway, use
the DescribeVpnConnections EC2 API and filter by transit-gateway-id. You cannot associate a
customer gateway with more than one device and link.

# Arguments
- `customer_gateway_arn`: The Amazon Resource Name (ARN) of the customer gateway.
- `device_id`: The ID of the device.
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LinkId"`: The ID of the link.
"""
function associate_customer_gateway(
    CustomerGatewayArn,
    DeviceId,
    globalNetworkId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/customer-gateway-associations",
        Dict{String,Any}(
            "CustomerGatewayArn" => CustomerGatewayArn, "DeviceId" => DeviceId
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_customer_gateway(
    CustomerGatewayArn,
    DeviceId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/customer-gateway-associations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CustomerGatewayArn" => CustomerGatewayArn, "DeviceId" => DeviceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_link(device_id, link_id, global_network_id)
    associate_link(device_id, link_id, global_network_id, params::Dict{String,<:Any})

Associates a link to a device. A device can be associated to multiple links and a link can
be associated to multiple devices. The device and link must be in the same global network
and the same site.

# Arguments
- `device_id`: The ID of the device.
- `link_id`: The ID of the link.
- `global_network_id`: The ID of the global network.

"""
function associate_link(
    DeviceId, LinkId, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/link-associations",
        Dict{String,Any}("DeviceId" => DeviceId, "LinkId" => LinkId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_link(
    DeviceId,
    LinkId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/link-associations",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DeviceId" => DeviceId, "LinkId" => LinkId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    associate_transit_gateway_connect_peer(device_id, transit_gateway_connect_peer_arn, global_network_id)
    associate_transit_gateway_connect_peer(device_id, transit_gateway_connect_peer_arn, global_network_id, params::Dict{String,<:Any})

Associates a transit gateway Connect peer with a device, and optionally, with a link. If
you specify a link, it must be associated with the specified device.  You can only
associate transit gateway Connect peers that have been created on a transit gateway that's
registered in your global network. You cannot associate a transit gateway Connect peer with
more than one device and link.

# Arguments
- `device_id`: The ID of the device.
- `transit_gateway_connect_peer_arn`: The Amazon Resource Name (ARN) of the Connect peer.
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"LinkId"`: The ID of the link.
"""
function associate_transit_gateway_connect_peer(
    DeviceId,
    TransitGatewayConnectPeerArn,
    globalNetworkId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/transit-gateway-connect-peer-associations",
        Dict{String,Any}(
            "DeviceId" => DeviceId,
            "TransitGatewayConnectPeerArn" => TransitGatewayConnectPeerArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function associate_transit_gateway_connect_peer(
    DeviceId,
    TransitGatewayConnectPeerArn,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/transit-gateway-connect-peer-associations",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DeviceId" => DeviceId,
                    "TransitGatewayConnectPeerArn" => TransitGatewayConnectPeerArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_connect_attachment(core_network_id, edge_location, options, transport_attachment_id)
    create_connect_attachment(core_network_id, edge_location, options, transport_attachment_id, params::Dict{String,<:Any})

Creates a core network Connect attachment from a specified core network attachment.  A core
network Connect attachment is a GRE-based tunnel attachment that you can use to establish a
connection between a core network and an appliance. A core network Connect attachment uses
an existing VPC attachment as the underlying transport mechanism.

# Arguments
- `core_network_id`: The ID of a core network where you want to create the attachment.
- `edge_location`: The Region where the edge is located.
- `options`: Options for creating an attachment.
- `transport_attachment_id`: The ID of the attachment between the two connections.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: The client token associated with the request.
- `"Tags"`: The list of key-value tags associated with the request.
"""
function create_connect_attachment(
    CoreNetworkId,
    EdgeLocation,
    Options,
    TransportAttachmentId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/connect-attachments",
        Dict{String,Any}(
            "CoreNetworkId" => CoreNetworkId,
            "EdgeLocation" => EdgeLocation,
            "Options" => Options,
            "TransportAttachmentId" => TransportAttachmentId,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connect_attachment(
    CoreNetworkId,
    EdgeLocation,
    Options,
    TransportAttachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/connect-attachments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CoreNetworkId" => CoreNetworkId,
                    "EdgeLocation" => EdgeLocation,
                    "Options" => Options,
                    "TransportAttachmentId" => TransportAttachmentId,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_connect_peer(connect_attachment_id, peer_address)
    create_connect_peer(connect_attachment_id, peer_address, params::Dict{String,<:Any})

Creates a core network Connect peer for a specified core network connect attachment between
a core network and an appliance. The peer address and transit gateway address must be the
same IP address family (IPv4 or IPv6).

# Arguments
- `connect_attachment_id`: The ID of the connection attachment.
- `peer_address`: The Connect peer address.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BgpOptions"`: The Connect peer BGP options. This only applies only when the protocol is
  GRE.
- `"ClientToken"`: The client token associated with the request.
- `"CoreNetworkAddress"`: A Connect peer core network address. This only applies only when
  the protocol is GRE.
- `"InsideCidrBlocks"`: The inside IP addresses used for BGP peering.
- `"SubnetArn"`: The subnet ARN for the Connect peer. This only applies only when the
  protocol is NO_ENCAP.
- `"Tags"`: The tags associated with the peer request.
"""
function create_connect_peer(
    ConnectAttachmentId, PeerAddress; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/connect-peers",
        Dict{String,Any}(
            "ConnectAttachmentId" => ConnectAttachmentId,
            "PeerAddress" => PeerAddress,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connect_peer(
    ConnectAttachmentId,
    PeerAddress,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/connect-peers",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConnectAttachmentId" => ConnectAttachmentId,
                    "PeerAddress" => PeerAddress,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_connection(connected_device_id, device_id, global_network_id)
    create_connection(connected_device_id, device_id, global_network_id, params::Dict{String,<:Any})

Creates a connection between two devices. The devices can be a physical or virtual
appliance that connects to a third-party appliance in a VPC, or a physical appliance that
connects to another physical appliance in an on-premises network.

# Arguments
- `connected_device_id`: The ID of the second device in the connection.
- `device_id`: The ID of the first device in the connection.
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectedLinkId"`: The ID of the link for the second device.
- `"Description"`: A description of the connection. Length Constraints: Maximum length of
  256 characters.
- `"LinkId"`: The ID of the link for the first device.
- `"Tags"`: The tags to apply to the resource during creation.
"""
function create_connection(
    ConnectedDeviceId,
    DeviceId,
    globalNetworkId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/connections",
        Dict{String,Any}("ConnectedDeviceId" => ConnectedDeviceId, "DeviceId" => DeviceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_connection(
    ConnectedDeviceId,
    DeviceId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/connections",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ConnectedDeviceId" => ConnectedDeviceId, "DeviceId" => DeviceId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_core_network(global_network_id)
    create_core_network(global_network_id, params::Dict{String,<:Any})

Creates a core network as part of your global network, and optionally, with a core network
policy.

# Arguments
- `global_network_id`: The ID of the global network that a core network will be a part of.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: The client token associated with a core network request.
- `"Description"`: The description of a core network.
- `"PolicyDocument"`: The policy document for creating a core network.
- `"Tags"`: Key-value tags associated with a core network request.
"""
function create_core_network(
    GlobalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/core-networks",
        Dict{String,Any}(
            "GlobalNetworkId" => GlobalNetworkId, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_core_network(
    GlobalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/core-networks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalNetworkId" => GlobalNetworkId, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_device(global_network_id)
    create_device(global_network_id, params::Dict{String,<:Any})

Creates a new device in a global network. If you specify both a site ID and a location, the
location of the site is used for visualization in the Network Manager console.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AWSLocation"`: The Amazon Web Services location of the device, if applicable. For an
  on-premises device, you can omit this parameter.
- `"Description"`: A description of the device. Constraints: Maximum length of 256
  characters.
- `"Location"`: The location of the device.
- `"Model"`: The model of the device. Constraints: Maximum length of 128 characters.
- `"SerialNumber"`: The serial number of the device. Constraints: Maximum length of 128
  characters.
- `"SiteId"`: The ID of the site.
- `"Tags"`: The tags to apply to the resource during creation.
- `"Type"`: The type of the device.
- `"Vendor"`: The vendor of the device. Constraints: Maximum length of 128 characters.
"""
function create_device(globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/devices";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_device(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/devices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_global_network()
    create_global_network(params::Dict{String,<:Any})

Creates a new, empty global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the global network. Constraints: Maximum length of 256
  characters.
- `"Tags"`: The tags to apply to the resource during creation.
"""
function create_global_network(; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "POST", "/global-networks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_global_network(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/global-networks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_link(bandwidth, site_id, global_network_id)
    create_link(bandwidth, site_id, global_network_id, params::Dict{String,<:Any})

Creates a new link for a specified site.

# Arguments
- `bandwidth`:  The upload speed and download speed in Mbps.
- `site_id`: The ID of the site.
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the link. Constraints: Maximum length of 256 characters.
- `"Provider"`: The provider of the link. Constraints: Maximum length of 128 characters.
  Cannot include the following characters: |  ^
- `"Tags"`: The tags to apply to the resource during creation.
- `"Type"`: The type of the link. Constraints: Maximum length of 128 characters. Cannot
  include the following characters: |  ^
"""
function create_link(
    Bandwidth, SiteId, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/links",
        Dict{String,Any}("Bandwidth" => Bandwidth, "SiteId" => SiteId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_link(
    Bandwidth,
    SiteId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/links",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Bandwidth" => Bandwidth, "SiteId" => SiteId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_site(global_network_id)
    create_site(global_network_id, params::Dict{String,<:Any})

Creates a new site in a global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of your site. Constraints: Maximum length of 256
  characters.
- `"Location"`: The site location. This information is used for visualization in the
  Network Manager console. If you specify the address, the latitude and longitude are
  automatically calculated.    Address: The physical address of the site.    Latitude: The
  latitude of the site.     Longitude: The longitude of the site.
- `"Tags"`: The tags to apply to the resource during creation.
"""
function create_site(globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/sites";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_site(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/sites",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_site_to_site_vpn_attachment(core_network_id, vpn_connection_arn)
    create_site_to_site_vpn_attachment(core_network_id, vpn_connection_arn, params::Dict{String,<:Any})

Creates an Amazon Web Services site-to-site VPN attachment on an edge location of a core
network.

# Arguments
- `core_network_id`: The ID of a core network where you're creating a site-to-site VPN
  attachment.
- `vpn_connection_arn`: The ARN identifying the VPN attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: The client token associated with the request.
- `"Tags"`: The tags associated with the request.
"""
function create_site_to_site_vpn_attachment(
    CoreNetworkId, VpnConnectionArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/site-to-site-vpn-attachments",
        Dict{String,Any}(
            "CoreNetworkId" => CoreNetworkId,
            "VpnConnectionArn" => VpnConnectionArn,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_site_to_site_vpn_attachment(
    CoreNetworkId,
    VpnConnectionArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/site-to-site-vpn-attachments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CoreNetworkId" => CoreNetworkId,
                    "VpnConnectionArn" => VpnConnectionArn,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_peering(core_network_id, transit_gateway_arn)
    create_transit_gateway_peering(core_network_id, transit_gateway_arn, params::Dict{String,<:Any})

Creates a transit gateway peering connection.

# Arguments
- `core_network_id`: The ID of a core network.
- `transit_gateway_arn`: The ARN of the transit gateway for the peering request.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: The client token associated with the request.
- `"Tags"`: The list of key-value tags associated with the request.
"""
function create_transit_gateway_peering(
    CoreNetworkId, TransitGatewayArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/transit-gateway-peerings",
        Dict{String,Any}(
            "CoreNetworkId" => CoreNetworkId,
            "TransitGatewayArn" => TransitGatewayArn,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_peering(
    CoreNetworkId,
    TransitGatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/transit-gateway-peerings",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CoreNetworkId" => CoreNetworkId,
                    "TransitGatewayArn" => TransitGatewayArn,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_transit_gateway_route_table_attachment(peering_id, transit_gateway_route_table_arn)
    create_transit_gateway_route_table_attachment(peering_id, transit_gateway_route_table_arn, params::Dict{String,<:Any})

Creates a transit gateway route table attachment.

# Arguments
- `peering_id`: The ID of the peer for the
- `transit_gateway_route_table_arn`: The ARN of the transit gateway route table for the
  attachment request. For example, \"TransitGatewayRouteTableArn\":
  \"arn:aws:ec2:us-west-2:123456789012:transit-gateway-route-table/tgw-rtb-9876543210123456\".

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: The client token associated with the request.
- `"Tags"`: The list of key-value tags associated with the request.
"""
function create_transit_gateway_route_table_attachment(
    PeeringId,
    TransitGatewayRouteTableArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/transit-gateway-route-table-attachments",
        Dict{String,Any}(
            "PeeringId" => PeeringId,
            "TransitGatewayRouteTableArn" => TransitGatewayRouteTableArn,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_transit_gateway_route_table_attachment(
    PeeringId,
    TransitGatewayRouteTableArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/transit-gateway-route-table-attachments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PeeringId" => PeeringId,
                    "TransitGatewayRouteTableArn" => TransitGatewayRouteTableArn,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_vpc_attachment(core_network_id, subnet_arns, vpc_arn)
    create_vpc_attachment(core_network_id, subnet_arns, vpc_arn, params::Dict{String,<:Any})

Creates a VPC attachment on an edge location of a core network.

# Arguments
- `core_network_id`: The ID of a core network for the VPC attachment.
- `subnet_arns`: The subnet ARN of the VPC attachment.
- `vpc_arn`: The ARN of the VPC.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: The client token associated with the request.
- `"Options"`: Options for the VPC attachment.
- `"Tags"`: The key-value tags associated with the request.
"""
function create_vpc_attachment(
    CoreNetworkId, SubnetArns, VpcArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/vpc-attachments",
        Dict{String,Any}(
            "CoreNetworkId" => CoreNetworkId,
            "SubnetArns" => SubnetArns,
            "VpcArn" => VpcArn,
            "ClientToken" => string(uuid4()),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_vpc_attachment(
    CoreNetworkId,
    SubnetArns,
    VpcArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/vpc-attachments",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "CoreNetworkId" => CoreNetworkId,
                    "SubnetArns" => SubnetArns,
                    "VpcArn" => VpcArn,
                    "ClientToken" => string(uuid4()),
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_attachment(attachment_id)
    delete_attachment(attachment_id, params::Dict{String,<:Any})

Deletes an attachment. Supports all attachment types.

# Arguments
- `attachment_id`: The ID of the attachment to delete.

"""
function delete_attachment(attachmentId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "DELETE",
        "/attachments/$(attachmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_attachment(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/attachments/$(attachmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connect_peer(connect_peer_id)
    delete_connect_peer(connect_peer_id, params::Dict{String,<:Any})

Deletes a Connect peer.

# Arguments
- `connect_peer_id`: The ID of the deleted Connect peer.

"""
function delete_connect_peer(
    connectPeerId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/connect-peers/$(connectPeerId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connect_peer(
    connectPeerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/connect-peers/$(connectPeerId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_connection(connection_id, global_network_id)
    delete_connection(connection_id, global_network_id, params::Dict{String,<:Any})

Deletes the specified connection in your global network.

# Arguments
- `connection_id`: The ID of the connection.
- `global_network_id`: The ID of the global network.

"""
function delete_connection(
    connectionId, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/connections/$(connectionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_connection(
    connectionId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/connections/$(connectionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_core_network(core_network_id)
    delete_core_network(core_network_id, params::Dict{String,<:Any})

Deletes a core network along with all core network policies. This can only be done if there
are no attachments on a core network.

# Arguments
- `core_network_id`: The network ID of the deleted core network.

"""
function delete_core_network(
    coreNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/core-networks/$(coreNetworkId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_core_network(
    coreNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/core-networks/$(coreNetworkId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_core_network_policy_version(core_network_id, policy_version_id)
    delete_core_network_policy_version(core_network_id, policy_version_id, params::Dict{String,<:Any})

Deletes a policy version from a core network. You can't delete the current LIVE policy.

# Arguments
- `core_network_id`: The ID of a core network for the deleted policy.
- `policy_version_id`: The version ID of the deleted policy.

"""
function delete_core_network_policy_version(
    coreNetworkId, policyVersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/core-networks/$(coreNetworkId)/core-network-policy-versions/$(policyVersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_core_network_policy_version(
    coreNetworkId,
    policyVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/core-networks/$(coreNetworkId)/core-network-policy-versions/$(policyVersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_device(device_id, global_network_id)
    delete_device(device_id, global_network_id, params::Dict{String,<:Any})

Deletes an existing device. You must first disassociate the device from any links and
customer gateways.

# Arguments
- `device_id`: The ID of the device.
- `global_network_id`: The ID of the global network.

"""
function delete_device(
    deviceId, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/devices/$(deviceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_device(
    deviceId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/devices/$(deviceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_global_network(global_network_id)
    delete_global_network(global_network_id, params::Dict{String,<:Any})

Deletes an existing global network. You must first delete all global network objects
(devices, links, and sites), deregister all transit gateways, and delete any core networks.

# Arguments
- `global_network_id`: The ID of the global network.

"""
function delete_global_network(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_global_network(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_link(global_network_id, link_id)
    delete_link(global_network_id, link_id, params::Dict{String,<:Any})

Deletes an existing link. You must first disassociate the link from any devices and
customer gateways.

# Arguments
- `global_network_id`: The ID of the global network.
- `link_id`: The ID of the link.

"""
function delete_link(
    globalNetworkId, linkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/links/$(linkId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_link(
    globalNetworkId,
    linkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/links/$(linkId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_peering(peering_id)
    delete_peering(peering_id, params::Dict{String,<:Any})

Deletes an existing peering connection.

# Arguments
- `peering_id`: The ID of the peering connection to delete.

"""
function delete_peering(peeringId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "DELETE",
        "/peerings/$(peeringId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_peering(
    peeringId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/peerings/$(peeringId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_resource_policy(resource_arn)
    delete_resource_policy(resource_arn, params::Dict{String,<:Any})

Deletes a resource policy for the specified resource. This revokes the access of the
principals specified in the resource policy.

# Arguments
- `resource_arn`: The ARN of the policy to delete.

"""
function delete_resource_policy(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/resource-policy/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_resource_policy(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/resource-policy/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_site(global_network_id, site_id)
    delete_site(global_network_id, site_id, params::Dict{String,<:Any})

Deletes an existing site. The site cannot be associated with any device or link.

# Arguments
- `global_network_id`: The ID of the global network.
- `site_id`: The ID of the site.

"""
function delete_site(
    globalNetworkId, siteId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/sites/$(siteId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_site(
    globalNetworkId,
    siteId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/sites/$(siteId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_transit_gateway(global_network_id, transit_gateway_arn)
    deregister_transit_gateway(global_network_id, transit_gateway_arn, params::Dict{String,<:Any})

Deregisters a transit gateway from your global network. This action does not delete your
transit gateway, or modify any of its attachments. This action removes any customer gateway
associations.

# Arguments
- `global_network_id`: The ID of the global network.
- `transit_gateway_arn`: The Amazon Resource Name (ARN) of the transit gateway.

"""
function deregister_transit_gateway(
    globalNetworkId, transitGatewayArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/transit-gateway-registrations/$(transitGatewayArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_transit_gateway(
    globalNetworkId,
    transitGatewayArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/transit-gateway-registrations/$(transitGatewayArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_global_networks()
    describe_global_networks(params::Dict{String,<:Any})

Describes one or more global networks. By default, all global networks are described. To
describe the objects in your global network, you must use the appropriate Get* action. For
example, to list the transit gateways in your global network, use
GetTransitGatewayRegistrations.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"globalNetworkIds"`: The IDs of one or more global networks. The maximum is 10.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function describe_global_networks(; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET", "/global-networks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_global_networks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_connect_peer(connect_peer_id, global_network_id)
    disassociate_connect_peer(connect_peer_id, global_network_id, params::Dict{String,<:Any})

Disassociates a core network Connect peer from a device and a link.

# Arguments
- `connect_peer_id`: The ID of the Connect peer to disassociate from a device.
- `global_network_id`: The ID of the global network.

"""
function disassociate_connect_peer(
    connectPeerId, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/connect-peer-associations/$(connectPeerId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_connect_peer(
    connectPeerId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/connect-peer-associations/$(connectPeerId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_customer_gateway(customer_gateway_arn, global_network_id)
    disassociate_customer_gateway(customer_gateway_arn, global_network_id, params::Dict{String,<:Any})

Disassociates a customer gateway from a device and a link.

# Arguments
- `customer_gateway_arn`: The Amazon Resource Name (ARN) of the customer gateway.
- `global_network_id`: The ID of the global network.

"""
function disassociate_customer_gateway(
    customerGatewayArn, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/customer-gateway-associations/$(customerGatewayArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_customer_gateway(
    customerGatewayArn,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/customer-gateway-associations/$(customerGatewayArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_link(device_id, global_network_id, link_id)
    disassociate_link(device_id, global_network_id, link_id, params::Dict{String,<:Any})

Disassociates an existing device from a link. You must first disassociate any customer
gateways that are associated with the link.

# Arguments
- `device_id`: The ID of the device.
- `global_network_id`: The ID of the global network.
- `link_id`: The ID of the link.

"""
function disassociate_link(
    deviceId, globalNetworkId, linkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/link-associations",
        Dict{String,Any}("deviceId" => deviceId, "linkId" => linkId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_link(
    deviceId,
    globalNetworkId,
    linkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/link-associations",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("deviceId" => deviceId, "linkId" => linkId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disassociate_transit_gateway_connect_peer(global_network_id, transit_gateway_connect_peer_arn)
    disassociate_transit_gateway_connect_peer(global_network_id, transit_gateway_connect_peer_arn, params::Dict{String,<:Any})

Disassociates a transit gateway Connect peer from a device and link.

# Arguments
- `global_network_id`: The ID of the global network.
- `transit_gateway_connect_peer_arn`: The Amazon Resource Name (ARN) of the transit gateway
  Connect peer.

"""
function disassociate_transit_gateway_connect_peer(
    globalNetworkId,
    transitGatewayConnectPeerArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/transit-gateway-connect-peer-associations/$(transitGatewayConnectPeerArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disassociate_transit_gateway_connect_peer(
    globalNetworkId,
    transitGatewayConnectPeerArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/global-networks/$(globalNetworkId)/transit-gateway-connect-peer-associations/$(transitGatewayConnectPeerArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    execute_core_network_change_set(core_network_id, policy_version_id)
    execute_core_network_change_set(core_network_id, policy_version_id, params::Dict{String,<:Any})

Executes a change set on your core network. Deploys changes globally based on the policy
submitted..

# Arguments
- `core_network_id`: The ID of a core network.
- `policy_version_id`: The ID of the policy version.

"""
function execute_core_network_change_set(
    coreNetworkId, policyVersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/core-networks/$(coreNetworkId)/core-network-change-sets/$(policyVersionId)/execute";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function execute_core_network_change_set(
    coreNetworkId,
    policyVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/core-networks/$(coreNetworkId)/core-network-change-sets/$(policyVersionId)/execute",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_connect_attachment(attachment_id)
    get_connect_attachment(attachment_id, params::Dict{String,<:Any})

Returns information about a core network Connect attachment.

# Arguments
- `attachment_id`: The ID of the attachment.

"""
function get_connect_attachment(
    attachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/connect-attachments/$(attachmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_connect_attachment(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/connect-attachments/$(attachmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_connect_peer(connect_peer_id)
    get_connect_peer(connect_peer_id, params::Dict{String,<:Any})

Returns information about a core network Connect peer.

# Arguments
- `connect_peer_id`: The ID of the Connect peer.

"""
function get_connect_peer(connectPeerId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET",
        "/connect-peers/$(connectPeerId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_connect_peer(
    connectPeerId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/connect-peers/$(connectPeerId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_connect_peer_associations(global_network_id)
    get_connect_peer_associations(global_network_id, params::Dict{String,<:Any})

Returns information about a core network Connect peer associations.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"connectPeerIds"`: The IDs of the Connect peers.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function get_connect_peer_associations(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/connect-peer-associations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_connect_peer_associations(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/connect-peer-associations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_connections(global_network_id)
    get_connections(global_network_id, params::Dict{String,<:Any})

Gets information about one or more of your connections in a global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"connectionIds"`: One or more connection IDs.
- `"deviceId"`: The ID of the device.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function get_connections(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/connections";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_connections(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/connections",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_core_network(core_network_id)
    get_core_network(core_network_id, params::Dict{String,<:Any})

Returns information about the LIVE policy for a core network.

# Arguments
- `core_network_id`: The ID of a core network.

"""
function get_core_network(coreNetworkId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_core_network(
    coreNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_core_network_change_events(core_network_id, policy_version_id)
    get_core_network_change_events(core_network_id, policy_version_id, params::Dict{String,<:Any})

Returns information about a core network change event.

# Arguments
- `core_network_id`: The ID of a core network.
- `policy_version_id`: The ID of the policy version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function get_core_network_change_events(
    coreNetworkId, policyVersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)/core-network-change-events/$(policyVersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_core_network_change_events(
    coreNetworkId,
    policyVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)/core-network-change-events/$(policyVersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_core_network_change_set(core_network_id, policy_version_id)
    get_core_network_change_set(core_network_id, policy_version_id, params::Dict{String,<:Any})

Returns a change set between the LIVE core network policy and a submitted policy.

# Arguments
- `core_network_id`: The ID of a core network.
- `policy_version_id`: The ID of the policy version.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function get_core_network_change_set(
    coreNetworkId, policyVersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)/core-network-change-sets/$(policyVersionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_core_network_change_set(
    coreNetworkId,
    policyVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)/core-network-change-sets/$(policyVersionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_core_network_policy(core_network_id)
    get_core_network_policy(core_network_id, params::Dict{String,<:Any})

Returns details about a core network policy. You can get details about your current live
policy or any previous policy version.

# Arguments
- `core_network_id`: The ID of a core network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"alias"`: The alias of a core network policy
- `"policyVersionId"`: The ID of a core network policy version.
"""
function get_core_network_policy(
    coreNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)/core-network-policy";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_core_network_policy(
    coreNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)/core-network-policy",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_customer_gateway_associations(global_network_id)
    get_customer_gateway_associations(global_network_id, params::Dict{String,<:Any})

Gets the association information for customer gateways that are associated with devices and
links in your global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"customerGatewayArns"`: One or more customer gateway Amazon Resource Names (ARNs). The
  maximum is 10.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function get_customer_gateway_associations(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/customer-gateway-associations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_customer_gateway_associations(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/customer-gateway-associations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_devices(global_network_id)
    get_devices(global_network_id, params::Dict{String,<:Any})

Gets information about one or more of your devices in a global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"deviceIds"`: One or more device IDs. The maximum is 10.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"siteId"`: The ID of the site.
"""
function get_devices(globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/devices";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_devices(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/devices",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_link_associations(global_network_id)
    get_link_associations(global_network_id, params::Dict{String,<:Any})

Gets the link associations for a device or a link. Either the device ID or the link ID must
be specified.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"deviceId"`: The ID of the device.
- `"linkId"`: The ID of the link.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function get_link_associations(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/link-associations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_link_associations(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/link-associations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_links(global_network_id)
    get_links(global_network_id, params::Dict{String,<:Any})

Gets information about one or more links in a specified global network. If you specify the
site ID, you cannot specify the type or provider in the same request. You can specify the
type and provider in the same request.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"linkIds"`: One or more link IDs. The maximum is 10.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"provider"`: The link provider.
- `"siteId"`: The ID of the site.
- `"type"`: The link type.
"""
function get_links(globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/links";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_links(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/links",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_resource_counts(global_network_id)
    get_network_resource_counts(global_network_id, params::Dict{String,<:Any})

Gets the count of network resources, by resource type, for the specified global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"resourceType"`: The resource type. The following are the supported resource types for
  Direct Connect:    dxcon     dx-gateway     dx-vif    The following are the supported
  resource types for Network Manager:    attachment     connect-peer     connection
  core-network     device     link     peering     site    The following are the supported
  resource types for Amazon VPC:    customer-gateway     transit-gateway
  transit-gateway-attachment     transit-gateway-connect-peer     transit-gateway-route-table
      vpn-connection
"""
function get_network_resource_counts(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/network-resource-count";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_resource_counts(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/network-resource-count",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_resource_relationships(global_network_id)
    get_network_resource_relationships(global_network_id, params::Dict{String,<:Any})

Gets the network resource relationships for the specified global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountId"`: The Amazon Web Services account ID.
- `"awsRegion"`: The Amazon Web Services Region.
- `"coreNetworkId"`: The ID of a core network.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"registeredGatewayArn"`: The ARN of the registered gateway.
- `"resourceArn"`: The ARN of the gateway.
- `"resourceType"`: The resource type. The following are the supported resource types for
  Direct Connect:    dxcon     dx-gateway     dx-vif    The following are the supported
  resource types for Network Manager:    attachment     connect-peer     connection
  core-network     device     link     peering     site    The following are the supported
  resource types for Amazon VPC:    customer-gateway     transit-gateway
  transit-gateway-attachment     transit-gateway-connect-peer     transit-gateway-route-table
      vpn-connection
"""
function get_network_resource_relationships(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/network-resource-relationships";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_resource_relationships(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/network-resource-relationships",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_resources(global_network_id)
    get_network_resources(global_network_id, params::Dict{String,<:Any})

Describes the network resources for the specified global network. The results include
information from the corresponding Describe call for the resource, minus any sensitive
information such as pre-shared keys.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountId"`: The Amazon Web Services account ID.
- `"awsRegion"`: The Amazon Web Services Region.
- `"coreNetworkId"`: The ID of a core network.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"registeredGatewayArn"`: The ARN of the gateway.
- `"resourceArn"`: The ARN of the resource.
- `"resourceType"`: The resource type. The following are the supported resource types for
  Direct Connect:    dxcon     dx-gateway     dx-vif    The following are the supported
  resource types for Network Manager:    attachment     connect-peer     connection
  core-network     device     link     peering     site    The following are the supported
  resource types for Amazon VPC:    customer-gateway     transit-gateway
  transit-gateway-attachment     transit-gateway-connect-peer     transit-gateway-route-table
      vpn-connection
"""
function get_network_resources(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/network-resources";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_resources(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/network-resources",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_routes(route_table_identifier, global_network_id)
    get_network_routes(route_table_identifier, global_network_id, params::Dict{String,<:Any})

Gets the network routes of the specified global network.

# Arguments
- `route_table_identifier`: The ID of the route table.
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DestinationFilters"`: Filter by route table destination. Possible Values:
  TRANSIT_GATEWAY_ATTACHMENT_ID, RESOURCE_ID, or RESOURCE_TYPE.
- `"ExactCidrMatches"`: An exact CIDR block.
- `"LongestPrefixMatches"`: The most specific route that matches the traffic (longest
  prefix match).
- `"PrefixListIds"`: The IDs of the prefix lists.
- `"States"`: The route states.
- `"SubnetOfMatches"`: The routes with a subnet that match the specified CIDR filter.
- `"SupernetOfMatches"`: The routes with a CIDR that encompasses the CIDR filter. Example:
  If you specify 10.0.1.0/30, then the result returns 10.0.1.0/29.
- `"Types"`: The route types.
"""
function get_network_routes(
    RouteTableIdentifier,
    globalNetworkId;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/network-routes",
        Dict{String,Any}("RouteTableIdentifier" => RouteTableIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_routes(
    RouteTableIdentifier,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/network-routes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("RouteTableIdentifier" => RouteTableIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_network_telemetry(global_network_id)
    get_network_telemetry(global_network_id, params::Dict{String,<:Any})

Gets the network telemetry of the specified global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"accountId"`: The Amazon Web Services account ID.
- `"awsRegion"`: The Amazon Web Services Region.
- `"coreNetworkId"`: The ID of a core network.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"registeredGatewayArn"`: The ARN of the gateway.
- `"resourceArn"`: The ARN of the resource.
- `"resourceType"`: The resource type. The following are the supported resource types:
  connect-peer     transit-gateway-connect-peer     vpn-connection
"""
function get_network_telemetry(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/network-telemetry";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_network_telemetry(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/network-telemetry",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_resource_policy(resource_arn)
    get_resource_policy(resource_arn, params::Dict{String,<:Any})

Returns information about a resource policy.

# Arguments
- `resource_arn`: The ARN of the resource.

"""
function get_resource_policy(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/resource-policy/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_resource_policy(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/resource-policy/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_route_analysis(global_network_id, route_analysis_id)
    get_route_analysis(global_network_id, route_analysis_id, params::Dict{String,<:Any})

Gets information about the specified route analysis.

# Arguments
- `global_network_id`: The ID of the global network.
- `route_analysis_id`: The ID of the route analysis.

"""
function get_route_analysis(
    globalNetworkId, routeAnalysisId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/route-analyses/$(routeAnalysisId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_route_analysis(
    globalNetworkId,
    routeAnalysisId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/route-analyses/$(routeAnalysisId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_site_to_site_vpn_attachment(attachment_id)
    get_site_to_site_vpn_attachment(attachment_id, params::Dict{String,<:Any})

Returns information about a site-to-site VPN attachment.

# Arguments
- `attachment_id`: The ID of the attachment.

"""
function get_site_to_site_vpn_attachment(
    attachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/site-to-site-vpn-attachments/$(attachmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_site_to_site_vpn_attachment(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/site-to-site-vpn-attachments/$(attachmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sites(global_network_id)
    get_sites(global_network_id, params::Dict{String,<:Any})

Gets information about one or more of your sites in a global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"siteIds"`: One or more site IDs. The maximum is 10.
"""
function get_sites(globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/sites";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sites(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/sites",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_transit_gateway_connect_peer_associations(global_network_id)
    get_transit_gateway_connect_peer_associations(global_network_id, params::Dict{String,<:Any})

Gets information about one or more of your transit gateway Connect peer associations in a
global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"transitGatewayConnectPeerArns"`: One or more transit gateway Connect peer Amazon
  Resource Names (ARNs).
"""
function get_transit_gateway_connect_peer_associations(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/transit-gateway-connect-peer-associations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_transit_gateway_connect_peer_associations(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/transit-gateway-connect-peer-associations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_transit_gateway_peering(peering_id)
    get_transit_gateway_peering(peering_id, params::Dict{String,<:Any})

Returns information about a transit gateway peer.

# Arguments
- `peering_id`: The ID of the peering request.

"""
function get_transit_gateway_peering(
    peeringId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/transit-gateway-peerings/$(peeringId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_transit_gateway_peering(
    peeringId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/transit-gateway-peerings/$(peeringId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_transit_gateway_registrations(global_network_id)
    get_transit_gateway_registrations(global_network_id, params::Dict{String,<:Any})

Gets information about the transit gateway registrations in a specified global network.

# Arguments
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"transitGatewayArns"`: The Amazon Resource Names (ARNs) of one or more transit gateways.
  The maximum is 10.
"""
function get_transit_gateway_registrations(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/transit-gateway-registrations";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_transit_gateway_registrations(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/global-networks/$(globalNetworkId)/transit-gateway-registrations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_transit_gateway_route_table_attachment(attachment_id)
    get_transit_gateway_route_table_attachment(attachment_id, params::Dict{String,<:Any})

Returns information about a transit gateway route table attachment.

# Arguments
- `attachment_id`: The ID of the transit gateway route table attachment.

"""
function get_transit_gateway_route_table_attachment(
    attachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/transit-gateway-route-table-attachments/$(attachmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_transit_gateway_route_table_attachment(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/transit-gateway-route-table-attachments/$(attachmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_vpc_attachment(attachment_id)
    get_vpc_attachment(attachment_id, params::Dict{String,<:Any})

Returns information about a VPC attachment.

# Arguments
- `attachment_id`: The ID of the attachment.

"""
function get_vpc_attachment(
    attachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/vpc-attachments/$(attachmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_vpc_attachment(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/vpc-attachments/$(attachmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_attachments()
    list_attachments(params::Dict{String,<:Any})

Returns a list of core network attachments.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"attachmentType"`: The type of attachment.
- `"coreNetworkId"`: The ID of a core network.
- `"edgeLocation"`: The Region where the edge is located.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"state"`: The state of the attachment.
"""
function list_attachments(; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET", "/attachments"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_attachments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/attachments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_connect_peers()
    list_connect_peers(params::Dict{String,<:Any})

Returns a list of core network Connect peers.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"connectAttachmentId"`: The ID of the attachment.
- `"coreNetworkId"`: The ID of a core network.
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function list_connect_peers(; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET", "/connect-peers"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_connect_peers(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/connect-peers",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_core_network_policy_versions(core_network_id)
    list_core_network_policy_versions(core_network_id, params::Dict{String,<:Any})

Returns a list of core network policy versions.

# Arguments
- `core_network_id`: The ID of a core network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function list_core_network_policy_versions(
    coreNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)/core-network-policy-versions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_core_network_policy_versions(
    coreNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/core-networks/$(coreNetworkId)/core-network-policy-versions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_core_networks()
    list_core_networks(params::Dict{String,<:Any})

Returns a list of owned and shared core networks.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function list_core_networks(; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET", "/core-networks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_core_networks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/core-networks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_organization_service_access_status()
    list_organization_service_access_status(params::Dict{String,<:Any})

Gets the status of the Service Linked Role (SLR) deployment for the accounts in a given
Amazon Web Services Organization.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
"""
function list_organization_service_access_status(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/organizations/service-access";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_organization_service_access_status(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/organizations/service-access",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_peerings()
    list_peerings(params::Dict{String,<:Any})

Lists the peerings for a core network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"coreNetworkId"`: The ID of a core network.
- `"edgeLocation"`: Returns a list edge locations for the
- `"maxResults"`: The maximum number of results to return.
- `"nextToken"`: The token for the next page of results.
- `"peeringType"`: Returns a list of a peering requests.
- `"state"`: Returns a list of the peering request states.
"""
function list_peerings(; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "GET", "/peerings"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function list_peerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET", "/peerings", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists the tags for a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_core_network_policy(policy_document, core_network_id)
    put_core_network_policy(policy_document, core_network_id, params::Dict{String,<:Any})

Creates a new, immutable version of a core network policy. A subsequent change set is
created showing the differences between the LIVE policy and the submitted policy.

# Arguments
- `policy_document`: The policy document.
- `core_network_id`: The ID of a core network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ClientToken"`: The client token associated with the request.
- `"Description"`: a core network policy description.
- `"LatestVersionId"`: The ID of a core network policy.
"""
function put_core_network_policy(
    PolicyDocument, coreNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/core-networks/$(coreNetworkId)/core-network-policy",
        Dict{String,Any}(
            "PolicyDocument" => PolicyDocument, "ClientToken" => string(uuid4())
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_core_network_policy(
    PolicyDocument,
    coreNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/core-networks/$(coreNetworkId)/core-network-policy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "PolicyDocument" => PolicyDocument, "ClientToken" => string(uuid4())
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_resource_policy(policy_document, resource_arn)
    put_resource_policy(policy_document, resource_arn, params::Dict{String,<:Any})

Creates or updates a resource policy.

# Arguments
- `policy_document`: The JSON resource policy document.
- `resource_arn`: The ARN of the resource policy.

"""
function put_resource_policy(
    PolicyDocument, resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/resource-policy/$(resourceArn)",
        Dict{String,Any}("PolicyDocument" => PolicyDocument);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_resource_policy(
    PolicyDocument,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/resource-policy/$(resourceArn)",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("PolicyDocument" => PolicyDocument), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_transit_gateway(transit_gateway_arn, global_network_id)
    register_transit_gateway(transit_gateway_arn, global_network_id, params::Dict{String,<:Any})

Registers a transit gateway in your global network. Not all Regions support transit
gateways for global networks. For a list of the supported Regions, see Region Availability
in the Amazon Web Services Transit Gateways for Global Networks User Guide. The transit
gateway can be in any of the supported Amazon Web Services Regions, but it must be owned by
the same Amazon Web Services account that owns the global network. You cannot register a
transit gateway in more than one global network.

# Arguments
- `transit_gateway_arn`: The Amazon Resource Name (ARN) of the transit gateway.
- `global_network_id`: The ID of the global network.

"""
function register_transit_gateway(
    TransitGatewayArn, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/transit-gateway-registrations",
        Dict{String,Any}("TransitGatewayArn" => TransitGatewayArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_transit_gateway(
    TransitGatewayArn,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/transit-gateway-registrations",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("TransitGatewayArn" => TransitGatewayArn), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reject_attachment(attachment_id)
    reject_attachment(attachment_id, params::Dict{String,<:Any})

Rejects a core network attachment request.

# Arguments
- `attachment_id`: The ID of the attachment.

"""
function reject_attachment(attachmentId; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "POST",
        "/attachments/$(attachmentId)/reject";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reject_attachment(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/attachments/$(attachmentId)/reject",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_core_network_policy_version(core_network_id, policy_version_id)
    restore_core_network_policy_version(core_network_id, policy_version_id, params::Dict{String,<:Any})

Restores a previous policy version as a new, immutable version of a core network policy. A
subsequent change set is created showing the differences between the LIVE policy and
restored policy.

# Arguments
- `core_network_id`: The ID of a core network.
- `policy_version_id`: The ID of the policy version to restore.

"""
function restore_core_network_policy_version(
    coreNetworkId, policyVersionId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/core-networks/$(coreNetworkId)/core-network-policy-versions/$(policyVersionId)/restore";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_core_network_policy_version(
    coreNetworkId,
    policyVersionId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/core-networks/$(coreNetworkId)/core-network-policy-versions/$(policyVersionId)/restore",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_organization_service_access_update(action)
    start_organization_service_access_update(action, params::Dict{String,<:Any})

Enables the Network Manager service for an Amazon Web Services Organization. This can only
be called by a management account within the organization.

# Arguments
- `action`: The action to take for the update request. This can be either ENABLE or DISABLE.

"""
function start_organization_service_access_update(
    Action; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/organizations/service-access",
        Dict{String,Any}("Action" => Action);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_organization_service_access_update(
    Action, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/organizations/service-access",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Action" => Action), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_route_analysis(destination, source, global_network_id)
    start_route_analysis(destination, source, global_network_id, params::Dict{String,<:Any})

Starts analyzing the routing path between the specified source and destination. For more
information, see Route Analyzer.

# Arguments
- `destination`: The destination.
- `source`: The source from which traffic originates.
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"IncludeReturnPath"`: Indicates whether to analyze the return path. The default is false.
- `"UseMiddleboxes"`: Indicates whether to include the location of middlebox appliances in
  the route analysis. The default is false.
"""
function start_route_analysis(
    Destination, Source, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/route-analyses",
        Dict{String,Any}("Destination" => Destination, "Source" => Source);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_route_analysis(
    Destination,
    Source,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/global-networks/$(globalNetworkId)/route-analyses",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Destination" => Destination, "Source" => Source),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(tags, resource_arn)
    tag_resource(tags, resource_arn, params::Dict{String,<:Any})

Tags a specified resource.

# Arguments
- `tags`: The tags to apply to the specified resource.
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.

"""
function tag_resource(Tags, resourceArn; aws_config::AbstractAWSConfig=current_aws_config())
    return networkmanager(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("Tags" => Tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    Tags,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Tags" => Tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Removes tags from a specified resource.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the resource.
- `tag_keys`: The tag keys to remove from the specified resource.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_connection(connection_id, global_network_id)
    update_connection(connection_id, global_network_id, params::Dict{String,<:Any})

Updates the information for an existing connection. To remove information for any of the
parameters, specify an empty string.

# Arguments
- `connection_id`: The ID of the connection.
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectedLinkId"`: The ID of the link for the second device in the connection.
- `"Description"`: A description of the connection. Length Constraints: Maximum length of
  256 characters.
- `"LinkId"`: The ID of the link for the first device in the connection.
"""
function update_connection(
    connectionId, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/connections/$(connectionId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_connection(
    connectionId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/connections/$(connectionId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_core_network(core_network_id)
    update_core_network(core_network_id, params::Dict{String,<:Any})

Updates the description of a core network.

# Arguments
- `core_network_id`: The ID of a core network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: The description of the update.
"""
function update_core_network(
    coreNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "PATCH",
        "/core-networks/$(coreNetworkId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_core_network(
    coreNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/core-networks/$(coreNetworkId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_device(device_id, global_network_id)
    update_device(device_id, global_network_id, params::Dict{String,<:Any})

Updates the details for an existing device. To remove information for any of the
parameters, specify an empty string.

# Arguments
- `device_id`: The ID of the device.
- `global_network_id`: The ID of the global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AWSLocation"`: The Amazon Web Services location of the device, if applicable. For an
  on-premises device, you can omit this parameter.
- `"Description"`: A description of the device. Constraints: Maximum length of 256
  characters.
- `"Location"`:
- `"Model"`: The model of the device. Constraints: Maximum length of 128 characters.
- `"SerialNumber"`: The serial number of the device. Constraints: Maximum length of 128
  characters.
- `"SiteId"`: The ID of the site.
- `"Type"`: The type of the device.
- `"Vendor"`: The vendor of the device. Constraints: Maximum length of 128 characters.
"""
function update_device(
    deviceId, globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/devices/$(deviceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_device(
    deviceId,
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/devices/$(deviceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_global_network(global_network_id)
    update_global_network(global_network_id, params::Dict{String,<:Any})

Updates an existing global network. To remove information for any of the parameters,
specify an empty string.

# Arguments
- `global_network_id`: The ID of your global network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of the global network. Constraints: Maximum length of 256
  characters.
"""
function update_global_network(
    globalNetworkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_global_network(
    globalNetworkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_link(global_network_id, link_id)
    update_link(global_network_id, link_id, params::Dict{String,<:Any})

Updates the details for an existing link. To remove information for any of the parameters,
specify an empty string.

# Arguments
- `global_network_id`: The ID of the global network.
- `link_id`: The ID of the link.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Bandwidth"`: The upload and download speed in Mbps.
- `"Description"`: A description of the link. Constraints: Maximum length of 256 characters.
- `"Provider"`: The provider of the link. Constraints: Maximum length of 128 characters.
- `"Type"`: The type of the link. Constraints: Maximum length of 128 characters.
"""
function update_link(
    globalNetworkId, linkId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/links/$(linkId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_link(
    globalNetworkId,
    linkId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/links/$(linkId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_network_resource_metadata(metadata, global_network_id, resource_arn)
    update_network_resource_metadata(metadata, global_network_id, resource_arn, params::Dict{String,<:Any})

Updates the resource metadata for the specified global network.

# Arguments
- `metadata`: The resource metadata.
- `global_network_id`: The ID of the global network.
- `resource_arn`: The ARN of the resource.

"""
function update_network_resource_metadata(
    Metadata,
    globalNetworkId,
    resourceArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/network-resources/$(resourceArn)/metadata",
        Dict{String,Any}("Metadata" => Metadata);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_network_resource_metadata(
    Metadata,
    globalNetworkId,
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/network-resources/$(resourceArn)/metadata",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("Metadata" => Metadata), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_site(global_network_id, site_id)
    update_site(global_network_id, site_id, params::Dict{String,<:Any})

Updates the information for an existing site. To remove information for any of the
parameters, specify an empty string.

# Arguments
- `global_network_id`: The ID of the global network.
- `site_id`: The ID of your site.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: A description of your site. Constraints: Maximum length of 256
  characters.
- `"Location"`: The site location:    Address: The physical address of the site.
  Latitude: The latitude of the site.     Longitude: The longitude of the site.
"""
function update_site(
    globalNetworkId, siteId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/sites/$(siteId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_site(
    globalNetworkId,
    siteId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/global-networks/$(globalNetworkId)/sites/$(siteId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_vpc_attachment(attachment_id)
    update_vpc_attachment(attachment_id, params::Dict{String,<:Any})

Updates a VPC attachment.

# Arguments
- `attachment_id`: The ID of the attachment.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AddSubnetArns"`: Adds a subnet ARN to the VPC attachment.
- `"Options"`: Additional options for updating the VPC attachment.
- `"RemoveSubnetArns"`: Removes a subnet ARN from the attachment.
"""
function update_vpc_attachment(
    attachmentId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return networkmanager(
        "PATCH",
        "/vpc-attachments/$(attachmentId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_vpc_attachment(
    attachmentId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return networkmanager(
        "PATCH",
        "/vpc-attachments/$(attachmentId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
