# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: rds
using AWS.Compat
using AWS.UUIDs

"""
    add_role_to_dbcluster(dbcluster_identifier, role_arn)
    add_role_to_dbcluster(dbcluster_identifier, role_arn, params::Dict{String,<:Any})

Associates an Identity and Access Management (IAM) role with a DB cluster.

# Arguments
- `dbcluster_identifier`: The name of the DB cluster to associate the IAM role with.
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role to associate with the Aurora
  DB cluster, for example arn:aws:iam::123456789012:role/AuroraAccessRole.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FeatureName"`: The name of the feature for the DB cluster that the IAM role is to be
  associated with. For information about supported feature names, see DBEngineVersion.
"""
function add_role_to_dbcluster(
    DBClusterIdentifier, RoleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "AddRoleToDBCluster",
        Dict{String,Any}(
            "DBClusterIdentifier" => DBClusterIdentifier, "RoleArn" => RoleArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_role_to_dbcluster(
    DBClusterIdentifier,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "AddRoleToDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterIdentifier" => DBClusterIdentifier, "RoleArn" => RoleArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_role_to_dbinstance(dbinstance_identifier, feature_name, role_arn)
    add_role_to_dbinstance(dbinstance_identifier, feature_name, role_arn, params::Dict{String,<:Any})

Associates an Amazon Web Services Identity and Access Management (IAM) role with a DB
instance.  To add a role to a DB instance, the status of the DB instance must be available.
 This command doesn't apply to RDS Custom.

# Arguments
- `dbinstance_identifier`: The name of the DB instance to associate the IAM role with.
- `feature_name`: The name of the feature for the DB instance that the IAM role is to be
  associated with. For information about supported feature names, see DBEngineVersion.
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role to associate with the DB
  instance, for example arn:aws:iam::123456789012:role/AccessRole.

"""
function add_role_to_dbinstance(
    DBInstanceIdentifier,
    FeatureName,
    RoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "AddRoleToDBInstance",
        Dict{String,Any}(
            "DBInstanceIdentifier" => DBInstanceIdentifier,
            "FeatureName" => FeatureName,
            "RoleArn" => RoleArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_role_to_dbinstance(
    DBInstanceIdentifier,
    FeatureName,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "AddRoleToDBInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "FeatureName" => FeatureName,
                    "RoleArn" => RoleArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_source_identifier_to_subscription(source_identifier, subscription_name)
    add_source_identifier_to_subscription(source_identifier, subscription_name, params::Dict{String,<:Any})

Adds a source identifier to an existing RDS event notification subscription.

# Arguments
- `source_identifier`: The identifier of the event source to be added. Constraints:   If
  the source type is a DB instance, a DBInstanceIdentifier value must be supplied.   If the
  source type is a DB cluster, a DBClusterIdentifier value must be supplied.   If the source
  type is a DB parameter group, a DBParameterGroupName value must be supplied.   If the
  source type is a DB security group, a DBSecurityGroupName value must be supplied.   If the
  source type is a DB snapshot, a DBSnapshotIdentifier value must be supplied.   If the
  source type is a DB cluster snapshot, a DBClusterSnapshotIdentifier value must be supplied.
    If the source type is an RDS Proxy, a DBProxyName value must be supplied.
- `subscription_name`: The name of the RDS event notification subscription you want to add
  a source identifier to.

"""
function add_source_identifier_to_subscription(
    SourceIdentifier, SubscriptionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "AddSourceIdentifierToSubscription",
        Dict{String,Any}(
            "SourceIdentifier" => SourceIdentifier, "SubscriptionName" => SubscriptionName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_source_identifier_to_subscription(
    SourceIdentifier,
    SubscriptionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "AddSourceIdentifierToSubscription",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceIdentifier" => SourceIdentifier,
                    "SubscriptionName" => SubscriptionName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    add_tags_to_resource(resource_name, tag)
    add_tags_to_resource(resource_name, tag, params::Dict{String,<:Any})

Adds metadata tags to an Amazon RDS resource. These tags can also be used with cost
allocation reporting to track cost associated with Amazon RDS resources, or used in a
Condition statement in an IAM policy for Amazon RDS. For an overview on tagging your
relational database resources, see Tagging Amazon RDS Resources or Tagging Amazon Aurora
and Amazon RDS Resources.

# Arguments
- `resource_name`: The Amazon RDS resource that the tags are added to. This value is an
  Amazon Resource Name (ARN). For information about creating an ARN, see  Constructing an RDS
  Amazon Resource Name (ARN).
- `tag`: The tags to be assigned to the Amazon RDS resource.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags to be assigned to the Amazon RDS resource.
"""
function add_tags_to_resource(
    ResourceName, Tag; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "AddTagsToResource",
        Dict{String,Any}("ResourceName" => ResourceName, "Tag" => Tag);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function add_tags_to_resource(
    ResourceName,
    Tag,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "AddTagsToResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceName" => ResourceName, "Tag" => Tag),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    apply_pending_maintenance_action(apply_action, opt_in_type, resource_identifier)
    apply_pending_maintenance_action(apply_action, opt_in_type, resource_identifier, params::Dict{String,<:Any})

Applies a pending maintenance action to a resource (for example, to a DB instance).

# Arguments
- `apply_action`: The pending maintenance action to apply to this resource. Valid Values:
  system-update, db-upgrade, hardware-maintenance, ca-certificate-rotation
- `opt_in_type`: A value that specifies the type of opt-in request, or undoes an opt-in
  request. An opt-in request of type immediate can't be undone. Valid Values:    immediate -
  Apply the maintenance action immediately.    next-maintenance - Apply the maintenance
  action during the next maintenance window for the resource.    undo-opt-in - Cancel any
  existing next-maintenance opt-in requests.
- `resource_identifier`: The RDS Amazon Resource Name (ARN) of the resource that the
  pending maintenance action applies to. For information about creating an ARN, see
  Constructing an RDS Amazon Resource Name (ARN).

"""
function apply_pending_maintenance_action(
    ApplyAction,
    OptInType,
    ResourceIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ApplyPendingMaintenanceAction",
        Dict{String,Any}(
            "ApplyAction" => ApplyAction,
            "OptInType" => OptInType,
            "ResourceIdentifier" => ResourceIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function apply_pending_maintenance_action(
    ApplyAction,
    OptInType,
    ResourceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ApplyPendingMaintenanceAction",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ApplyAction" => ApplyAction,
                    "OptInType" => OptInType,
                    "ResourceIdentifier" => ResourceIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    authorize_dbsecurity_group_ingress(dbsecurity_group_name)
    authorize_dbsecurity_group_ingress(dbsecurity_group_name, params::Dict{String,<:Any})

Enables ingress to a DBSecurityGroup using one of two forms of authorization. First, EC2 or
VPC security groups can be added to the DBSecurityGroup if the application using the
database is running on EC2 or VPC instances. Second, IP ranges are available if the
application accessing your database is running on the internet. Required parameters for
this API are one of CIDR range, EC2SecurityGroupId for VPC, or (EC2SecurityGroupOwnerId and
either EC2SecurityGroupName or EC2SecurityGroupId for non-VPC). You can't authorize ingress
from an EC2 security group in one Amazon Web Services Region to an Amazon RDS DB instance
in another. You can't authorize ingress from a VPC security group in one VPC to an Amazon
RDS DB instance in another. For an overview of CIDR ranges, go to the Wikipedia Tutorial.
EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a
VPC, we recommend that you migrate as soon as possible. For more information, see Migrate
from EC2-Classic to a VPC in the Amazon EC2 User Guide, the blog EC2-Classic Networking is
Retiring – Here’s How to Prepare, and Moving a DB instance not in a VPC into a VPC in
the Amazon RDS User Guide.

# Arguments
- `dbsecurity_group_name`: The name of the DB security group to add authorization to.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CIDRIP"`: The IP range to authorize.
- `"EC2SecurityGroupId"`: Id of the EC2 security group to authorize. For VPC DB security
  groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId and either
  EC2SecurityGroupName or EC2SecurityGroupId must be provided.
- `"EC2SecurityGroupName"`: Name of the EC2 security group to authorize. For VPC DB
  security groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId
  and either EC2SecurityGroupName or EC2SecurityGroupId must be provided.
- `"EC2SecurityGroupOwnerId"`: Amazon Web Services account number of the owner of the EC2
  security group specified in the EC2SecurityGroupName parameter. The Amazon Web Services
  access key ID isn't an acceptable value. For VPC DB security groups, EC2SecurityGroupId
  must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or
  EC2SecurityGroupId must be provided.
"""
function authorize_dbsecurity_group_ingress(
    DBSecurityGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "AuthorizeDBSecurityGroupIngress",
        Dict{String,Any}("DBSecurityGroupName" => DBSecurityGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function authorize_dbsecurity_group_ingress(
    DBSecurityGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "AuthorizeDBSecurityGroupIngress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBSecurityGroupName" => DBSecurityGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    backtrack_dbcluster(backtrack_to, dbcluster_identifier)
    backtrack_dbcluster(backtrack_to, dbcluster_identifier, params::Dict{String,<:Any})

Backtracks a DB cluster to a specific time, without creating a new DB cluster. For more
information on backtracking, see  Backtracking an Aurora DB Cluster in the Amazon Aurora
User Guide.  This action applies only to Aurora MySQL DB clusters.

# Arguments
- `backtrack_to`: The timestamp of the time to backtrack the DB cluster to, specified in
  ISO 8601 format. For more information about ISO 8601, see the ISO8601 Wikipedia page.   If
  the specified time isn't a consistent time for the DB cluster, Aurora automatically chooses
  the nearest possible consistent time for the DB cluster.  Constraints:   Must contain a
  valid ISO 8601 timestamp.   Can't contain a timestamp set in the future.   Example:
  2017-07-08T18:00Z
- `dbcluster_identifier`: The DB cluster identifier of the DB cluster to be backtracked.
  This parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63
  alphanumeric characters or hyphens.   First character must be a letter.   Can't end with a
  hyphen or contain two consecutive hyphens.   Example: my-cluster1

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Force"`: Specifies whether to force the DB cluster to backtrack when binary logging is
  enabled. Otherwise, an error occurs when binary logging is enabled.
- `"UseEarliestTimeOnPointInTimeUnavailable"`: Specifies whether to backtrack the DB
  cluster to the earliest possible backtrack time when BacktrackTo is set to a timestamp
  earlier than the earliest backtrack time. When this parameter is disabled and BacktrackTo
  is set to a timestamp earlier than the earliest backtrack time, an error occurs.
"""
function backtrack_dbcluster(
    BacktrackTo, DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "BacktrackDBCluster",
        Dict{String,Any}(
            "BacktrackTo" => BacktrackTo, "DBClusterIdentifier" => DBClusterIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function backtrack_dbcluster(
    BacktrackTo,
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "BacktrackDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BacktrackTo" => BacktrackTo,
                    "DBClusterIdentifier" => DBClusterIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    cancel_export_task(export_task_identifier)
    cancel_export_task(export_task_identifier, params::Dict{String,<:Any})

Cancels an export task in progress that is exporting a snapshot or cluster to Amazon S3.
Any data that has already been written to the S3 bucket isn't removed.

# Arguments
- `export_task_identifier`: The identifier of the snapshot or cluster export task to cancel.

"""
function cancel_export_task(
    ExportTaskIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "CancelExportTask",
        Dict{String,Any}("ExportTaskIdentifier" => ExportTaskIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_export_task(
    ExportTaskIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CancelExportTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ExportTaskIdentifier" => ExportTaskIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_dbcluster_parameter_group(source_dbcluster_parameter_group_identifier, target_dbcluster_parameter_group_description, target_dbcluster_parameter_group_identifier)
    copy_dbcluster_parameter_group(source_dbcluster_parameter_group_identifier, target_dbcluster_parameter_group_description, target_dbcluster_parameter_group_identifier, params::Dict{String,<:Any})

Copies the specified DB cluster parameter group.  You can't copy a default DB cluster
parameter group. Instead, create a new custom DB cluster parameter group, which copies the
default parameters and values for the specified DB cluster parameter group family.

# Arguments
- `source_dbcluster_parameter_group_identifier`: The identifier or Amazon Resource Name
  (ARN) for the source DB cluster parameter group. For information about creating an ARN, see
   Constructing an ARN for Amazon RDS in the Amazon Aurora User Guide. Constraints:   Must
  specify a valid DB cluster parameter group.
- `target_dbcluster_parameter_group_description`: A description for the copied DB cluster
  parameter group.
- `target_dbcluster_parameter_group_identifier`: The identifier for the copied DB cluster
  parameter group. Constraints:   Can't be null, empty, or blank   Must contain from 1 to 255
  letters, numbers, or hyphens   First character must be a letter   Can't end with a hyphen
  or contain two consecutive hyphens   Example: my-cluster-param-group1

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
"""
function copy_dbcluster_parameter_group(
    SourceDBClusterParameterGroupIdentifier,
    TargetDBClusterParameterGroupDescription,
    TargetDBClusterParameterGroupIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyDBClusterParameterGroup",
        Dict{String,Any}(
            "SourceDBClusterParameterGroupIdentifier" =>
                SourceDBClusterParameterGroupIdentifier,
            "TargetDBClusterParameterGroupDescription" =>
                TargetDBClusterParameterGroupDescription,
            "TargetDBClusterParameterGroupIdentifier" =>
                TargetDBClusterParameterGroupIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_dbcluster_parameter_group(
    SourceDBClusterParameterGroupIdentifier,
    TargetDBClusterParameterGroupDescription,
    TargetDBClusterParameterGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyDBClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceDBClusterParameterGroupIdentifier" =>
                        SourceDBClusterParameterGroupIdentifier,
                    "TargetDBClusterParameterGroupDescription" =>
                        TargetDBClusterParameterGroupDescription,
                    "TargetDBClusterParameterGroupIdentifier" =>
                        TargetDBClusterParameterGroupIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_dbcluster_snapshot(source_dbcluster_snapshot_identifier, target_dbcluster_snapshot_identifier)
    copy_dbcluster_snapshot(source_dbcluster_snapshot_identifier, target_dbcluster_snapshot_identifier, params::Dict{String,<:Any})

Copies a snapshot of a DB cluster. To copy a DB cluster snapshot from a shared manual DB
cluster snapshot, SourceDBClusterSnapshotIdentifier must be the Amazon Resource Name (ARN)
of the shared DB cluster snapshot. You can copy an encrypted DB cluster snapshot from
another Amazon Web Services Region. In that case, the Amazon Web Services Region where you
call the CopyDBClusterSnapshot operation is the destination Amazon Web Services Region for
the encrypted DB cluster snapshot to be copied to. To copy an encrypted DB cluster snapshot
from another Amazon Web Services Region, you must provide the following values:    KmsKeyId
- The Amazon Web Services Key Management System (Amazon Web Services KMS) key identifier
for the key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon
Web Services Region.    TargetDBClusterSnapshotIdentifier - The identifier for the new copy
of the DB cluster snapshot in the destination Amazon Web Services Region.
SourceDBClusterSnapshotIdentifier - The DB cluster snapshot identifier for the encrypted DB
cluster snapshot to be copied. This identifier must be in the ARN format for the source
Amazon Web Services Region and is the same value as the SourceDBClusterSnapshotIdentifier
in the presigned URL.   To cancel the copy operation once it is in progress, delete the
target DB cluster snapshot identified by TargetDBClusterSnapshotIdentifier while that DB
cluster snapshot is in \"copying\" status. For more information on copying encrypted Amazon
Aurora DB cluster snapshots from one Amazon Web Services Region to another, see  Copying a
Snapshot in the Amazon Aurora User Guide. For more information on Amazon Aurora DB
clusters, see  What is Amazon Aurora? in the Amazon Aurora User Guide. For more information
on Multi-AZ DB clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `source_dbcluster_snapshot_identifier`: The identifier of the DB cluster snapshot to
  copy. This parameter isn't case-sensitive. You can't copy an encrypted, shared DB cluster
  snapshot from one Amazon Web Services Region to another. Constraints:   Must specify a
  valid system snapshot in the \"available\" state.   If the source snapshot is in the same
  Amazon Web Services Region as the copy, specify a valid DB snapshot identifier.   If the
  source snapshot is in a different Amazon Web Services Region than the copy, specify a valid
  DB cluster snapshot ARN. For more information, go to  Copying Snapshots Across Amazon Web
  Services Regions in the Amazon Aurora User Guide.   Example: my-cluster-snapshot1
- `target_dbcluster_snapshot_identifier`: The identifier of the new DB cluster snapshot to
  create from the source DB cluster snapshot. This parameter isn't case-sensitive.
  Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.   First character
  must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.   Example:
  my-cluster-snapshot2

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CopyTags"`: Specifies whether to copy all tags from the source DB cluster snapshot to
  the target DB cluster snapshot. By default, tags are not copied.
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier for an encrypted DB cluster
  snapshot. The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or
  alias name for the Amazon Web Services KMS key. If you copy an encrypted DB cluster
  snapshot from your Amazon Web Services account, you can specify a value for KmsKeyId to
  encrypt the copy with a new KMS key. If you don't specify a value for KmsKeyId, then the
  copy of the DB cluster snapshot is encrypted with the same KMS key as the source DB cluster
  snapshot. If you copy an encrypted DB cluster snapshot that is shared from another Amazon
  Web Services account, then you must specify a value for KmsKeyId. To copy an encrypted DB
  cluster snapshot to another Amazon Web Services Region, you must set KmsKeyId to the Amazon
  Web Services KMS key identifier you want to use to encrypt the copy of the DB cluster
  snapshot in the destination Amazon Web Services Region. KMS keys are specific to the Amazon
  Web Services Region that they are created in, and you can't use KMS keys from one Amazon
  Web Services Region in another Amazon Web Services Region. If you copy an unencrypted DB
  cluster snapshot and specify a value for the KmsKeyId parameter, an error is returned.
- `"PreSignedUrl"`: When you are copying a DB cluster snapshot from one Amazon Web Services
  GovCloud (US) Region to another, the URL that contains a Signature Version 4 signed request
  for the CopyDBClusterSnapshot API operation in the Amazon Web Services Region that contains
  the source DB cluster snapshot to copy. Use the PreSignedUrl parameter when copying an
  encrypted DB cluster snapshot from another Amazon Web Services Region. Don't specify
  PreSignedUrl when copying an encrypted DB cluster snapshot in the same Amazon Web Services
  Region. This setting applies only to Amazon Web Services GovCloud (US) Regions. It's
  ignored in other Amazon Web Services Regions. The presigned URL must be a valid request for
  the CopyDBClusterSnapshot API operation that can run in the source Amazon Web Services
  Region that contains the encrypted DB cluster snapshot to copy. The presigned URL request
  must contain the following parameter values:    KmsKeyId - The KMS key identifier for the
  KMS key to use to encrypt the copy of the DB cluster snapshot in the destination Amazon Web
  Services Region. This is the same identifier for both the CopyDBClusterSnapshot operation
  that is called in the destination Amazon Web Services Region, and the operation contained
  in the presigned URL.    DestinationRegion - The name of the Amazon Web Services Region
  that the DB cluster snapshot is to be created in.    SourceDBClusterSnapshotIdentifier -
  The DB cluster snapshot identifier for the encrypted DB cluster snapshot to be copied. This
  identifier must be in the Amazon Resource Name (ARN) format for the source Amazon Web
  Services Region. For example, if you are copying an encrypted DB cluster snapshot from the
  us-west-2 Amazon Web Services Region, then your SourceDBClusterSnapshotIdentifier looks
  like the following example:
  arn:aws:rds:us-west-2:123456789012:cluster-snapshot:aurora-cluster1-snapshot-20161115.   To
  learn how to generate a Signature Version 4 signed request, see  Authenticating Requests:
  Using Query Parameters (Amazon Web Services Signature Version 4) and  Signature Version 4
  Signing Process.  If you are using an Amazon Web Services SDK tool or the CLI, you can
  specify SourceRegion (or --source-region for the CLI) instead of specifying PreSignedUrl
  manually. Specifying SourceRegion autogenerates a presigned URL that is a valid request for
  the operation that can run in the source Amazon Web Services Region. If you supply a value
  for this operation's SourceRegion parameter, a pre-signed URL will be calculated on your
  behalf.
- `"SourceRegion"`: The ID of the region that contains the snapshot to be copied.
- `"Tags"`:
"""
function copy_dbcluster_snapshot(
    SourceDBClusterSnapshotIdentifier,
    TargetDBClusterSnapshotIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyDBClusterSnapshot",
        Dict{String,Any}(
            "SourceDBClusterSnapshotIdentifier" => SourceDBClusterSnapshotIdentifier,
            "TargetDBClusterSnapshotIdentifier" => TargetDBClusterSnapshotIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_dbcluster_snapshot(
    SourceDBClusterSnapshotIdentifier,
    TargetDBClusterSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyDBClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceDBClusterSnapshotIdentifier" =>
                        SourceDBClusterSnapshotIdentifier,
                    "TargetDBClusterSnapshotIdentifier" =>
                        TargetDBClusterSnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_dbparameter_group(source_dbparameter_group_identifier, target_dbparameter_group_description, target_dbparameter_group_identifier)
    copy_dbparameter_group(source_dbparameter_group_identifier, target_dbparameter_group_description, target_dbparameter_group_identifier, params::Dict{String,<:Any})

Copies the specified DB parameter group.  You can't copy a default DB parameter group.
Instead, create a new custom DB parameter group, which copies the default parameters and
values for the specified DB parameter group family.

# Arguments
- `source_dbparameter_group_identifier`: The identifier or ARN for the source DB parameter
  group. For information about creating an ARN, see  Constructing an ARN for Amazon RDS in
  the Amazon RDS User Guide. Constraints:   Must specify a valid DB parameter group.
- `target_dbparameter_group_description`: A description for the copied DB parameter group.
- `target_dbparameter_group_identifier`: The identifier for the copied DB parameter group.
  Constraints:   Can't be null, empty, or blank   Must contain from 1 to 255 letters,
  numbers, or hyphens   First character must be a letter   Can't end with a hyphen or contain
  two consecutive hyphens   Example: my-db-parameter-group

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
"""
function copy_dbparameter_group(
    SourceDBParameterGroupIdentifier,
    TargetDBParameterGroupDescription,
    TargetDBParameterGroupIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyDBParameterGroup",
        Dict{String,Any}(
            "SourceDBParameterGroupIdentifier" => SourceDBParameterGroupIdentifier,
            "TargetDBParameterGroupDescription" => TargetDBParameterGroupDescription,
            "TargetDBParameterGroupIdentifier" => TargetDBParameterGroupIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_dbparameter_group(
    SourceDBParameterGroupIdentifier,
    TargetDBParameterGroupDescription,
    TargetDBParameterGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyDBParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceDBParameterGroupIdentifier" => SourceDBParameterGroupIdentifier,
                    "TargetDBParameterGroupDescription" =>
                        TargetDBParameterGroupDescription,
                    "TargetDBParameterGroupIdentifier" => TargetDBParameterGroupIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_dbsnapshot(source_dbsnapshot_identifier, target_dbsnapshot_identifier)
    copy_dbsnapshot(source_dbsnapshot_identifier, target_dbsnapshot_identifier, params::Dict{String,<:Any})

Copies the specified DB snapshot. The source DB snapshot must be in the available state.
You can copy a snapshot from one Amazon Web Services Region to another. In that case, the
Amazon Web Services Region where you call the CopyDBSnapshot operation is the destination
Amazon Web Services Region for the DB snapshot copy. This command doesn't apply to RDS
Custom. For more information about copying snapshots, see Copying a DB Snapshot in the
Amazon RDS User Guide.

# Arguments
- `source_dbsnapshot_identifier`: The identifier for the source DB snapshot. If the source
  snapshot is in the same Amazon Web Services Region as the copy, specify a valid DB snapshot
  identifier. For example, you might specify rds:mysql-instance1-snapshot-20130805. If the
  source snapshot is in a different Amazon Web Services Region than the copy, specify a valid
  DB snapshot ARN. For example, you might specify
  arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805. If you are
  copying from a shared manual DB snapshot, this parameter must be the Amazon Resource Name
  (ARN) of the shared DB snapshot. If you are copying an encrypted snapshot this parameter
  must be in the ARN format for the source Amazon Web Services Region. Constraints:   Must
  specify a valid system snapshot in the \"available\" state.   Example:
  rds:mydb-2012-04-02-00-01  Example:
  arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20130805
- `target_dbsnapshot_identifier`: The identifier for the copy of the snapshot. Constraints:
    Can't be null, empty, or blank   Must contain from 1 to 255 letters, numbers, or hyphens
   First character must be a letter   Can't end with a hyphen or contain two consecutive
  hyphens   Example: my-db-snapshot

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CopyOptionGroup"`: Specifies whether to copy the DB option group associated with the
  source DB snapshot to the target Amazon Web Services account and associate with the target
  DB snapshot. The associated option group can be copied only with cross-account snapshot
  copy calls.
- `"CopyTags"`: Specifies whether to copy all tags from the source DB snapshot to the
  target DB snapshot. By default, tags aren't copied.
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier for an encrypted DB snapshot.
  The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name
  for the KMS key. If you copy an encrypted DB snapshot from your Amazon Web Services
  account, you can specify a value for this parameter to encrypt the copy with a new KMS key.
  If you don't specify a value for this parameter, then the copy of the DB snapshot is
  encrypted with the same Amazon Web Services KMS key as the source DB snapshot. If you copy
  an encrypted DB snapshot that is shared from another Amazon Web Services account, then you
  must specify a value for this parameter. If you specify this parameter when you copy an
  unencrypted snapshot, the copy is encrypted. If you copy an encrypted snapshot to a
  different Amazon Web Services Region, then you must specify an Amazon Web Services KMS key
  identifier for the destination Amazon Web Services Region. KMS keys are specific to the
  Amazon Web Services Region that they are created in, and you can't use KMS keys from one
  Amazon Web Services Region in another Amazon Web Services Region.
- `"OptionGroupName"`: The name of an option group to associate with the copy of the
  snapshot. Specify this option if you are copying a snapshot from one Amazon Web Services
  Region to another, and your DB instance uses a nondefault option group. If your source DB
  instance uses Transparent Data Encryption for Oracle or Microsoft SQL Server, you must
  specify this option when copying across Amazon Web Services Regions. For more information,
  see Option group considerations in the Amazon RDS User Guide.
- `"PreSignedUrl"`: When you are copying a snapshot from one Amazon Web Services GovCloud
  (US) Region to another, the URL that contains a Signature Version 4 signed request for the
  CopyDBSnapshot API operation in the source Amazon Web Services Region that contains the
  source DB snapshot to copy. This setting applies only to Amazon Web Services GovCloud (US)
  Regions. It's ignored in other Amazon Web Services Regions. You must specify this parameter
  when you copy an encrypted DB snapshot from another Amazon Web Services Region by using the
  Amazon RDS API. Don't specify PreSignedUrl when you are copying an encrypted DB snapshot in
  the same Amazon Web Services Region. The presigned URL must be a valid request for the
  CopyDBClusterSnapshot API operation that can run in the source Amazon Web Services Region
  that contains the encrypted DB cluster snapshot to copy. The presigned URL request must
  contain the following parameter values:    DestinationRegion - The Amazon Web Services
  Region that the encrypted DB snapshot is copied to. This Amazon Web Services Region is the
  same one where the CopyDBSnapshot operation is called that contains this presigned URL. For
  example, if you copy an encrypted DB snapshot from the us-west-2 Amazon Web Services Region
  to the us-east-1 Amazon Web Services Region, then you call the CopyDBSnapshot operation in
  the us-east-1 Amazon Web Services Region and provide a presigned URL that contains a call
  to the CopyDBSnapshot operation in the us-west-2 Amazon Web Services Region. For this
  example, the DestinationRegion in the presigned URL must be set to the us-east-1 Amazon Web
  Services Region.    KmsKeyId - The KMS key identifier for the KMS key to use to encrypt the
  copy of the DB snapshot in the destination Amazon Web Services Region. This is the same
  identifier for both the CopyDBSnapshot operation that is called in the destination Amazon
  Web Services Region, and the operation contained in the presigned URL.
  SourceDBSnapshotIdentifier - The DB snapshot identifier for the encrypted snapshot to be
  copied. This identifier must be in the Amazon Resource Name (ARN) format for the source
  Amazon Web Services Region. For example, if you are copying an encrypted DB snapshot from
  the us-west-2 Amazon Web Services Region, then your SourceDBSnapshotIdentifier looks like
  the following example:
  arn:aws:rds:us-west-2:123456789012:snapshot:mysql-instance1-snapshot-20161115.   To learn
  how to generate a Signature Version 4 signed request, see Authenticating Requests: Using
  Query Parameters (Amazon Web Services Signature Version 4) and Signature Version 4 Signing
  Process.  If you are using an Amazon Web Services SDK tool or the CLI, you can specify
  SourceRegion (or --source-region for the CLI) instead of specifying PreSignedUrl manually.
  Specifying SourceRegion autogenerates a presigned URL that is a valid request for the
  operation that can run in the source Amazon Web Services Region. If you supply a value for
  this operation's SourceRegion parameter, a pre-signed URL will be calculated on your behalf.
- `"SourceRegion"`: The ID of the region that contains the snapshot to be copied.
- `"Tags"`:
- `"TargetCustomAvailabilityZone"`: The external custom Availability Zone (CAZ) identifier
  for the target CAZ. Example: rds-caz-aiqhTgQv.
"""
function copy_dbsnapshot(
    SourceDBSnapshotIdentifier,
    TargetDBSnapshotIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyDBSnapshot",
        Dict{String,Any}(
            "SourceDBSnapshotIdentifier" => SourceDBSnapshotIdentifier,
            "TargetDBSnapshotIdentifier" => TargetDBSnapshotIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_dbsnapshot(
    SourceDBSnapshotIdentifier,
    TargetDBSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyDBSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceDBSnapshotIdentifier" => SourceDBSnapshotIdentifier,
                    "TargetDBSnapshotIdentifier" => TargetDBSnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    copy_option_group(source_option_group_identifier, target_option_group_description, target_option_group_identifier)
    copy_option_group(source_option_group_identifier, target_option_group_description, target_option_group_identifier, params::Dict{String,<:Any})

Copies the specified option group.

# Arguments
- `source_option_group_identifier`: The identifier for the source option group.
  Constraints:   Must specify a valid option group.
- `target_option_group_description`: The description for the copied option group.
- `target_option_group_identifier`: The identifier for the copied option group.
  Constraints:   Can't be null, empty, or blank   Must contain from 1 to 255 letters,
  numbers, or hyphens   First character must be a letter   Can't end with a hyphen or contain
  two consecutive hyphens   Example: my-option-group

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
"""
function copy_option_group(
    SourceOptionGroupIdentifier,
    TargetOptionGroupDescription,
    TargetOptionGroupIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyOptionGroup",
        Dict{String,Any}(
            "SourceOptionGroupIdentifier" => SourceOptionGroupIdentifier,
            "TargetOptionGroupDescription" => TargetOptionGroupDescription,
            "TargetOptionGroupIdentifier" => TargetOptionGroupIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function copy_option_group(
    SourceOptionGroupIdentifier,
    TargetOptionGroupDescription,
    TargetOptionGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CopyOptionGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceOptionGroupIdentifier" => SourceOptionGroupIdentifier,
                    "TargetOptionGroupDescription" => TargetOptionGroupDescription,
                    "TargetOptionGroupIdentifier" => TargetOptionGroupIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_blue_green_deployment(blue_green_deployment_name, source)
    create_blue_green_deployment(blue_green_deployment_name, source, params::Dict{String,<:Any})

Creates a blue/green deployment. A blue/green deployment creates a staging environment that
copies the production environment. In a blue/green deployment, the blue environment is the
current production environment. The green environment is the staging environment. The
staging environment stays in sync with the current production environment using logical
replication. You can make changes to the databases in the green environment without
affecting production workloads. For example, you can upgrade the major or minor DB engine
version, change database parameters, or make schema changes in the staging environment. You
can thoroughly test changes in the green environment. When ready, you can switch over the
environments to promote the green environment to be the new production environment. The
switchover typically takes under a minute. For more information, see Using Amazon RDS
Blue/Green Deployments for database updates in the Amazon RDS User Guide and  Using Amazon
RDS Blue/Green Deployments for database updates in the Amazon Aurora User Guide.

# Arguments
- `blue_green_deployment_name`: The name of the blue/green deployment. Constraints:   Can't
  be the same as an existing blue/green deployment name in the same account and Amazon Web
  Services Region.
- `source`: The Amazon Resource Name (ARN) of the source production database. Specify the
  database that you want to clone. The blue/green deployment creates this database in the
  green environment. You can make updates to the database in the green environment, such as
  an engine version upgrade. When you are ready, you can switch the database in the green
  environment to be the production database.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: Tags to assign to the blue/green deployment.
- `"TargetDBClusterParameterGroupName"`: The DB cluster parameter group associated with the
  Aurora DB cluster in the green environment. To test parameter changes, specify a DB cluster
  parameter group that is different from the one associated with the source DB cluster.
- `"TargetDBInstanceClass"`: Specify the DB instance class for the databases in the green
  environment. This parameter only applies to RDS DB instances, because DB instances within
  an Aurora DB cluster can have multiple different instance classes. If you're creating a
  blue/green deployment from an Aurora DB cluster, don't specify this parameter. After the
  green environment is created, you can individually modify the instance classes of the DB
  instances within the green DB cluster.
- `"TargetDBParameterGroupName"`: The DB parameter group associated with the DB instance in
  the green environment. To test parameter changes, specify a DB parameter group that is
  different from the one associated with the source DB instance.
- `"TargetEngineVersion"`: The engine version of the database in the green environment.
  Specify the engine version to upgrade to in the green environment.
- `"UpgradeTargetStorageConfig"`: Whether to upgrade the storage file system configuration
  on the green database. This option migrates the green DB instance from the older 32-bit
  file system to the preferred configuration. For more information, see Upgrading the storage
  file system for a DB instance.
"""
function create_blue_green_deployment(
    BlueGreenDeploymentName, Source; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "CreateBlueGreenDeployment",
        Dict{String,Any}(
            "BlueGreenDeploymentName" => BlueGreenDeploymentName, "Source" => Source
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_blue_green_deployment(
    BlueGreenDeploymentName,
    Source,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateBlueGreenDeployment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BlueGreenDeploymentName" => BlueGreenDeploymentName, "Source" => Source
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_custom_dbengine_version(engine, engine_version)
    create_custom_dbengine_version(engine, engine_version, params::Dict{String,<:Any})

Creates a custom DB engine version (CEV).

# Arguments
- `engine`: The database engine. RDS Custom for Oracle supports the following values:
  custom-oracle-ee     custom-oracle-ee-cdb     custom-oracle-se2     custom-oracle-se2-cdb
- `engine_version`: The name of your CEV. The name format is 19.customized_string. For
  example, a valid CEV name is 19.my_cev1. This setting is required for RDS Custom for
  Oracle, but optional for Amazon RDS. The combination of Engine and EngineVersion is unique
  per customer per Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DatabaseInstallationFilesS3BucketName"`: The name of an Amazon S3 bucket that contains
  database installation files for your CEV. For example, a valid bucket name is
  my-custom-installation-files.
- `"DatabaseInstallationFilesS3Prefix"`: The Amazon S3 directory that contains the database
  installation files for your CEV. For example, a valid bucket name is 123456789012/cev1. If
  this setting isn't specified, no prefix is assumed.
- `"Description"`: An optional description of your CEV.
- `"ImageId"`: The ID of the Amazon Machine Image (AMI). For RDS Custom for SQL Server, an
  AMI ID is required to create a CEV. For RDS Custom for Oracle, the default is the most
  recent AMI available, but you can specify an AMI ID that was used in a different Oracle
  CEV. Find the AMIs used by your CEVs by calling the DescribeDBEngineVersions operation.
- `"KMSKeyId"`: The Amazon Web Services KMS key identifier for an encrypted CEV. A
  symmetric encryption KMS key is required for RDS Custom, but optional for Amazon RDS. If
  you have an existing symmetric encryption KMS key in your account, you can use it with RDS
  Custom. No further action is necessary. If you don't already have a symmetric encryption
  KMS key in your account, follow the instructions in  Creating a symmetric encryption KMS
  key in the Amazon Web Services Key Management Service Developer Guide. You can choose the
  same symmetric encryption key when you create a CEV and a DB instance, or choose different
  keys.
- `"Manifest"`: The CEV manifest, which is a JSON document that describes the installation
  .zip files stored in Amazon S3. Specify the name/value pairs in a file or a quoted string.
  RDS Custom applies the patches in the order in which they are listed. The following JSON
  fields are valid:  MediaImportTemplateVersion  Version of the CEV manifest. The date is in
  the format YYYY-MM-DD.  databaseInstallationFileNames  Ordered list of installation files
  for the CEV.  opatchFileNames  Ordered list of OPatch installers used for the Oracle DB
  engine.  psuRuPatchFileNames  The PSU and RU patches for this CEV.  OtherPatchFileNames
  The patches that are not in the list of PSU and RU patches. Amazon RDS applies these
  patches after applying the PSU and RU patches.   For more information, see  Creating the
  CEV manifest in the Amazon RDS User Guide.
- `"SourceCustomDbEngineVersionIdentifier"`: The ARN of a CEV to use as a source for
  creating a new CEV. You can specify a different Amazon Machine Imagine (AMI) by using
  either Source or UseAwsProvidedLatestImage. You can't specify a different JSON manifest
  when you specify SourceCustomDbEngineVersionIdentifier.
- `"Tags"`:
- `"UseAwsProvidedLatestImage"`: Specifies whether to use the latest service-provided
  Amazon Machine Image (AMI) for the CEV. If you specify UseAwsProvidedLatestImage, you can't
  also specify ImageId.
"""
function create_custom_dbengine_version(
    Engine, EngineVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "CreateCustomDBEngineVersion",
        Dict{String,Any}("Engine" => Engine, "EngineVersion" => EngineVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_custom_dbengine_version(
    Engine,
    EngineVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateCustomDBEngineVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Engine" => Engine, "EngineVersion" => EngineVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbcluster(dbcluster_identifier, engine)
    create_dbcluster(dbcluster_identifier, engine, params::Dict{String,<:Any})

Creates a new Amazon Aurora DB cluster or Multi-AZ DB cluster. If you create an Aurora DB
cluster, the request creates an empty cluster. You must explicitly create the writer
instance for your DB cluster using the CreateDBInstance operation. If you create a Multi-AZ
DB cluster, the request creates a writer and two reader DB instances for you, each in a
different Availability Zone. You can use the ReplicationSourceIdentifier parameter to
create an Amazon Aurora DB cluster as a read replica of another DB cluster or Amazon RDS
for MySQL or PostgreSQL DB instance. For more information about Amazon Aurora, see What is
Amazon Aurora? in the Amazon Aurora User Guide. You can also use the
ReplicationSourceIdentifier parameter to create a Multi-AZ DB cluster read replica with an
RDS for MySQL or PostgreSQL DB instance as the source. For more information about Multi-AZ
DB clusters, see Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The identifier for this DB cluster. This parameter is stored as a
  lowercase string. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
  Constraints:   Must contain from 1 to 63 (for Aurora DB clusters) or 1 to 52 (for Multi-AZ
  DB clusters) letters, numbers, or hyphens.   First character must be a letter.   Can't end
  with a hyphen or contain two consecutive hyphens.   Example: my-cluster1
- `engine`: The database engine to use for this DB cluster. Valid for Cluster Type: Aurora
  DB clusters and Multi-AZ DB clusters Valid Values:    aurora-mysql     aurora-postgresql
   mysql     postgres     neptune - For information about using Amazon Neptune, see the
  Amazon Neptune User Guide .

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocatedStorage"`: The amount of storage in gibibytes (GiB) to allocate to each DB
  instance in the Multi-AZ DB cluster. Valid for Cluster Type: Multi-AZ DB clusters only This
  setting is required to create a Multi-AZ DB cluster.
- `"AutoMinorVersionUpgrade"`: Specifies whether minor engine upgrades are applied
  automatically to the DB cluster during the maintenance window. By default, minor engine
  upgrades are applied automatically. Valid for Cluster Type: Multi-AZ DB clusters only
- `"AvailabilityZones"`: A list of Availability Zones (AZs) where you specifically want to
  create DB instances in the DB cluster. For information on AZs, see Availability Zones in
  the Amazon Aurora User Guide. Valid for Cluster Type: Aurora DB clusters only Constraints:
   Can't specify more than three AZs.
- `"BacktrackWindow"`: The target backtrack window, in seconds. To disable backtracking,
  set this value to 0. Valid for Cluster Type: Aurora MySQL DB clusters only Default: 0
  Constraints:   If specified, this value must be set to a number from 0 to 259,200 (72
  hours).
- `"BackupRetentionPeriod"`: The number of days for which automated backups are retained.
  Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Default: 1
  Constraints:   Must be a value from 1 to 35.
- `"CACertificateIdentifier"`: The CA certificate identifier to use for the DB cluster's
  server certificate. For more information, see Using SSL/TLS to encrypt a connection to a DB
  instance in the Amazon RDS User Guide. Valid for Cluster Type: Multi-AZ DB clusters
- `"CharacterSetName"`: The name of the character set (CharacterSet) to associate the DB
  cluster with. Valid for Cluster Type: Aurora DB clusters only
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the DB cluster to
  snapshots of the DB cluster. The default is not to copy them. Valid for Cluster Type:
  Aurora DB clusters and Multi-AZ DB clusters
- `"DBClusterInstanceClass"`: The compute and memory capacity of each DB instance in the
  Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available
  in all Amazon Web Services Regions, or for all database engines. For the full list of DB
  instance classes and availability for your engine, see DB instance class in the Amazon RDS
  User Guide. This setting is required to create a Multi-AZ DB cluster. Valid for Cluster
  Type: Multi-AZ DB clusters only
- `"DBClusterParameterGroupName"`: The name of the DB cluster parameter group to associate
  with this DB cluster. If you don't specify a value, then the default DB cluster parameter
  group for the specified DB engine and version is used. Valid for Cluster Type: Aurora DB
  clusters and Multi-AZ DB clusters Constraints:   If supplied, must match the name of an
  existing DB cluster parameter group.
- `"DBSubnetGroupName"`: A DB subnet group to associate with this DB cluster. This setting
  is required to create a Multi-AZ DB cluster. Valid for Cluster Type: Aurora DB clusters and
  Multi-AZ DB clusters Constraints:   Must match the name of an existing DB subnet group.
  Must not be default.   Example: mydbsubnetgroup
- `"DBSystemId"`: Reserved for future use.
- `"DatabaseName"`: The name for your database of up to 64 alphanumeric characters. A
  database named postgres is always created. If this parameter is specified, an additional
  database with this name is created. Valid for Cluster Type: Aurora DB clusters and Multi-AZ
  DB clusters
- `"DeletionProtection"`: Specifies whether the DB cluster has deletion protection enabled.
  The database can't be deleted when deletion protection is enabled. By default, deletion
  protection isn't enabled. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB
  clusters
- `"Domain"`: The Active Directory directory ID to create the DB cluster in. For Amazon
  Aurora DB clusters, Amazon RDS can use Kerberos authentication to authenticate users that
  connect to the DB cluster. For more information, see Kerberos authentication in the Amazon
  Aurora User Guide. Valid for Cluster Type: Aurora DB clusters only
- `"DomainIAMRoleName"`: The name of the IAM role to use when making API calls to the
  Directory Service. Valid for Cluster Type: Aurora DB clusters only
- `"EnableCloudwatchLogsExports"`: The list of log types that need to be enabled for
  exporting to CloudWatch Logs. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB
  clusters The following values are valid for each DB engine:   Aurora MySQL - audit | error
  | general | slowquery    Aurora PostgreSQL - postgresql    RDS for MySQL - error | general
  | slowquery    RDS for PostgreSQL - postgresql | upgrade    For more information about
  exporting CloudWatch Logs for Amazon RDS, see Publishing Database Logs to Amazon CloudWatch
  Logs in the Amazon RDS User Guide. For more information about exporting CloudWatch Logs for
  Amazon Aurora, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon Aurora
  User Guide.
- `"EnableGlobalWriteForwarding"`: Specifies whether to enable this DB cluster to forward
  write operations to the primary cluster of a global cluster (Aurora global database). By
  default, write operations are not allowed on Aurora DB clusters that are secondary clusters
  in an Aurora global database. You can set this value only on Aurora DB clusters that are
  members of an Aurora global database. With this parameter enabled, a secondary cluster can
  forward writes to the current primary cluster, and the resulting changes are replicated
  back to this cluster. For the primary DB cluster of an Aurora global database, this value
  is used immediately if the primary is demoted by a global cluster API operation, but it
  does nothing until then. Valid for Cluster Type: Aurora DB clusters only
- `"EnableHttpEndpoint"`: Specifies whether to enable the HTTP endpoint for the DB cluster.
  By default, the HTTP endpoint isn't enabled. When enabled, the HTTP endpoint provides a
  connectionless web service API (RDS Data API) for running SQL queries on the DB cluster.
  You can also query your database from inside the RDS console with the RDS query editor. RDS
  Data API is supported with the following DB clusters:   Aurora PostgreSQL Serverless v2 and
  provisioned   Aurora PostgreSQL and Aurora MySQL Serverless v1   For more information, see
  Using RDS Data API in the Amazon Aurora User Guide. Valid for Cluster Type: Aurora DB
  clusters only
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. For more information, see  IAM Database Authentication in the Amazon
  Aurora User Guide. Valid for Cluster Type: Aurora DB clusters only
- `"EnableLimitlessDatabase"`: Specifies whether to enable Aurora Limitless Database. You
  must enable Aurora Limitless Database to create a DB shard group. Valid for: Aurora DB
  clusters only
- `"EnableLocalWriteForwarding"`: Specifies whether read replicas can forward write
  operations to the writer DB instance in the DB cluster. By default, write operations aren't
  allowed on reader DB instances. Valid for: Aurora DB clusters only
- `"EnablePerformanceInsights"`: Specifies whether to turn on Performance Insights for the
  DB cluster. For more information, see  Using Amazon Performance Insights in the Amazon RDS
  User Guide. Valid for Cluster Type: Multi-AZ DB clusters only
- `"EngineLifecycleSupport"`: The life cycle type for this DB cluster.  By default, this
  value is set to open-source-rds-extended-support, which enrolls your DB cluster into Amazon
  RDS Extended Support. At the end of standard support, you can avoid charges for Extended
  Support by setting the value to open-source-rds-extended-support-disabled. In this case,
  creating the DB cluster will fail if the DB major version is past its end of standard
  support date.  You can use this setting to enroll your DB cluster into Amazon RDS Extended
  Support. With RDS Extended Support, you can run the selected major engine version on your
  DB cluster past the end of standard support for that engine version. For more information,
  see the following sections:   Amazon Aurora (PostgreSQL only) - Using Amazon RDS Extended
  Support in the Amazon Aurora User Guide    Amazon RDS - Using Amazon RDS Extended Support
  in the Amazon RDS User Guide    Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB
  clusters Valid Values: open-source-rds-extended-support |
  open-source-rds-extended-support-disabled  Default: open-source-rds-extended-support
- `"EngineMode"`: The DB engine mode of the DB cluster, either provisioned or serverless.
  The serverless engine mode only applies for Aurora Serverless v1 DB clusters. Aurora
  Serverless v2 DB clusters use the provisioned engine mode. For information about
  limitations and requirements for Serverless DB clusters, see the following sections in the
  Amazon Aurora User Guide:    Limitations of Aurora Serverless v1     Requirements for
  Aurora Serverless v2    Valid for Cluster Type: Aurora DB clusters only
- `"EngineVersion"`: The version number of the database engine to use. To list all of the
  available engine versions for Aurora MySQL version 2 (5.7-compatible) and version 3 (MySQL
  8.0-compatible), use the following command:  aws rds describe-db-engine-versions --engine
  aurora-mysql --query \"DBEngineVersions[].EngineVersion\"  You can supply either 5.7 or 8.0
  to use the default engine version for Aurora MySQL version 2 or version 3, respectively. To
  list all of the available engine versions for Aurora PostgreSQL, use the following command:
   aws rds describe-db-engine-versions --engine aurora-postgresql --query
  \"DBEngineVersions[].EngineVersion\"  To list all of the available engine versions for RDS
  for MySQL, use the following command:  aws rds describe-db-engine-versions --engine mysql
  --query \"DBEngineVersions[].EngineVersion\"  To list all of the available engine versions
  for RDS for PostgreSQL, use the following command:  aws rds describe-db-engine-versions
  --engine postgres --query \"DBEngineVersions[].EngineVersion\"  For information about a
  specific engine, see the following topics:   Aurora MySQL - see Database engine updates for
  Amazon Aurora MySQL in the Amazon Aurora User Guide.   Aurora PostgreSQL - see Amazon
  Aurora PostgreSQL releases and engine versions in the Amazon Aurora User Guide.   RDS for
  MySQL - see Amazon RDS for MySQL in the Amazon RDS User Guide.   RDS for PostgreSQL - see
  Amazon RDS for PostgreSQL in the Amazon RDS User Guide.   Valid for Cluster Type: Aurora DB
  clusters and Multi-AZ DB clusters
- `"GlobalClusterIdentifier"`: The global cluster ID of an Aurora cluster that becomes the
  primary cluster in the new global database cluster. Valid for Cluster Type: Aurora DB
  clusters only
- `"Iops"`: The amount of Provisioned IOPS (input/output operations per second) to be
  initially allocated for each DB instance in the Multi-AZ DB cluster. For information about
  valid IOPS values, see Provisioned IOPS storage in the Amazon RDS User Guide. This setting
  is required to create a Multi-AZ DB cluster. Valid for Cluster Type: Multi-AZ DB clusters
  only Constraints:   Must be a multiple between .5 and 50 of the storage amount for the DB
  cluster.
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier for an encrypted DB cluster. The
  Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for
  the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key
  ARN or alias ARN. When a KMS key isn't specified in KmsKeyId:   If
  ReplicationSourceIdentifier identifies an encrypted source, then Amazon RDS uses the KMS
  key used to encrypt the source. Otherwise, Amazon RDS uses your default KMS key.   If the
  StorageEncrypted parameter is enabled and ReplicationSourceIdentifier isn't specified, then
  Amazon RDS uses your default KMS key.   There is a default KMS key for your Amazon Web
  Services account. Your Amazon Web Services account has a different default KMS key for each
  Amazon Web Services Region. If you create a read replica of an encrypted DB cluster in
  another Amazon Web Services Region, make sure to set KmsKeyId to a KMS key identifier that
  is valid in the destination Amazon Web Services Region. This KMS key is used to encrypt the
  read replica in that Amazon Web Services Region. Valid for Cluster Type: Aurora DB clusters
  and Multi-AZ DB clusters
- `"ManageMasterUserPassword"`: Specifies whether to manage the master user password with
  Amazon Web Services Secrets Manager. For more information, see Password management with
  Amazon Web Services Secrets Manager in the Amazon RDS User Guide and Password management
  with Amazon Web Services Secrets Manager in the Amazon Aurora User Guide.  Valid for
  Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Constraints:   Can't manage the
  master user password with Amazon Web Services Secrets Manager if MasterUserPassword is
  specified.
- `"MasterUserPassword"`: The password for the master database user. Valid for Cluster
  Type: Aurora DB clusters and Multi-AZ DB clusters Constraints:   Must contain from 8 to 41
  characters.   Can contain any printable ASCII character except \"/\", \"\"\", or \"@\".
  Can't be specified if ManageMasterUserPassword is turned on.
- `"MasterUserSecretKmsKeyId"`: The Amazon Web Services KMS key identifier to encrypt a
  secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
  This setting is valid only if the master user password is managed by RDS in Amazon Web
  Services Secrets Manager for the DB cluster. The Amazon Web Services KMS key identifier is
  the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a
  different Amazon Web Services account, specify the key ARN or alias ARN. If you don't
  specify MasterUserSecretKmsKeyId, then the aws/secretsmanager KMS key is used to encrypt
  the secret. If the secret is in a different Amazon Web Services account, then you can't use
  the aws/secretsmanager KMS key to encrypt the secret, and you must use a customer managed
  KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
  Services account has a different default KMS key for each Amazon Web Services Region. Valid
  for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
- `"MasterUsername"`: The name of the master user for the DB cluster. Valid for Cluster
  Type: Aurora DB clusters and Multi-AZ DB clusters Constraints:   Must be 1 to 16 letters or
  numbers.   First character must be a letter.   Can't be a reserved word for the chosen
  database engine.
- `"MonitoringInterval"`: The interval, in seconds, between points when Enhanced Monitoring
  metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring
  metrics, specify 0. If MonitoringRoleArn is specified, also set MonitoringInterval to a
  value other than 0. Valid for Cluster Type: Multi-AZ DB clusters only Valid Values: 0 | 1 |
  5 | 10 | 15 | 30 | 60  Default: 0
- `"MonitoringRoleArn"`: The Amazon Resource Name (ARN) for the IAM role that permits RDS
  to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is
  arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role, see
  Setting up and enabling Enhanced Monitoring in the Amazon RDS User Guide. If
  MonitoringInterval is set to a value other than 0, supply a MonitoringRoleArn value. Valid
  for Cluster Type: Multi-AZ DB clusters only
- `"NetworkType"`: The network type of the DB cluster. The network type is determined by
  the DBSubnetGroup specified for the DB cluster. A DBSubnetGroup can support only the IPv4
  protocol or the IPv4 and the IPv6 protocols (DUAL). For more information, see  Working with
  a DB instance in a VPC in the Amazon Aurora User Guide.  Valid for Cluster Type: Aurora DB
  clusters only Valid Values: IPV4 | DUAL
- `"OptionGroupName"`: The option group to associate the DB cluster with. DB clusters are
  associated with a default option group that can't be modified.
- `"PerformanceInsightsKMSKeyId"`: The Amazon Web Services KMS key identifier for
  encryption of Performance Insights data. The Amazon Web Services KMS key identifier is the
  key ARN, key ID, alias ARN, or alias name for the KMS key. If you don't specify a value for
  PerformanceInsightsKMSKeyId, then Amazon RDS uses your default KMS key. There is a default
  KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
  different default KMS key for each Amazon Web Services Region. Valid for Cluster Type:
  Multi-AZ DB clusters only
- `"PerformanceInsightsRetentionPeriod"`: The number of days to retain Performance Insights
  data. Valid for Cluster Type: Multi-AZ DB clusters only Valid Values:    7     month * 31,
  where month is a number of months from 1-23. Examples: 93 (3 months * 31), 341 (11 months *
  31), 589 (19 months * 31)    731    Default: 7 days If you specify a retention period that
  isn't valid, such as 94, Amazon RDS issues an error.
- `"Port"`: The port number on which the instances in the DB cluster accept connections.
  Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Valid Values:
  1150-65535  Default:   RDS for MySQL and Aurora MySQL - 3306    RDS for PostgreSQL and
  Aurora PostgreSQL - 5432
- `"PreSignedUrl"`: When you are replicating a DB cluster from one Amazon Web Services
  GovCloud (US) Region to another, an URL that contains a Signature Version 4 signed request
  for the CreateDBCluster operation to be called in the source Amazon Web Services Region
  where the DB cluster is replicated from. Specify PreSignedUrl only when you are performing
  cross-Region replication from an encrypted DB cluster. The presigned URL must be a valid
  request for the CreateDBCluster API operation that can run in the source Amazon Web
  Services Region that contains the encrypted DB cluster to copy. The presigned URL request
  must contain the following parameter values:    KmsKeyId - The KMS key identifier for the
  KMS key to use to encrypt the copy of the DB cluster in the destination Amazon Web Services
  Region. This should refer to the same KMS key for both the CreateDBCluster operation that
  is called in the destination Amazon Web Services Region, and the operation contained in the
  presigned URL.    DestinationRegion - The name of the Amazon Web Services Region that
  Aurora read replica will be created in.    ReplicationSourceIdentifier - The DB cluster
  identifier for the encrypted DB cluster to be copied. This identifier must be in the Amazon
  Resource Name (ARN) format for the source Amazon Web Services Region. For example, if you
  are copying an encrypted DB cluster from the us-west-2 Amazon Web Services Region, then
  your ReplicationSourceIdentifier would look like Example:
  arn:aws:rds:us-west-2:123456789012:cluster:aurora-cluster1.   To learn how to generate a
  Signature Version 4 signed request, see  Authenticating Requests: Using Query Parameters
  (Amazon Web Services Signature Version 4) and  Signature Version 4 Signing Process.  If you
  are using an Amazon Web Services SDK tool or the CLI, you can specify SourceRegion (or
  --source-region for the CLI) instead of specifying PreSignedUrl manually. Specifying
  SourceRegion autogenerates a presigned URL that is a valid request for the operation that
  can run in the source Amazon Web Services Region.  Valid for Cluster Type: Aurora DB
  clusters onlyIf you supply a value for this operation's SourceRegion parameter, a
  pre-signed URL will be calculated on your behalf.
- `"PreferredBackupWindow"`: The daily time range during which automated backups are
  created if automated backups are enabled using the BackupRetentionPeriod parameter. Valid
  for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters The default is a 30-minute
  window selected at random from an 8-hour block of time for each Amazon Web Services Region.
  To view the time blocks available, see  Backup window in the Amazon Aurora User Guide.
  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal Coordinated
  Time (UTC).   Must not conflict with the preferred maintenance window.   Must be at least
  30 minutes.
- `"PreferredMaintenanceWindow"`: The weekly time range during which system maintenance can
  occur. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters The default is a
  30-minute window selected at random from an 8-hour block of time for each Amazon Web
  Services Region, occurring on a random day of the week. To see the time blocks available,
  see  Adjusting the Preferred DB Cluster Maintenance Window in the Amazon Aurora User Guide.
  Constraints:   Must be in the format ddd:hh24:mi-ddd:hh24:mi.   Days must be one of Mon |
  Tue | Wed | Thu | Fri | Sat | Sun.   Must be in Universal Coordinated Time (UTC).   Must be
  at least 30 minutes.
- `"PubliclyAccessible"`: Specifies whether the DB cluster is publicly accessible. When the
  DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
  private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to
  the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is
  ultimately controlled by the security group it uses. That public access isn't permitted if
  the security group assigned to the DB cluster doesn't permit it. When the DB cluster isn't
  publicly accessible, it is an internal DB cluster with a DNS name that resolves to a
  private IP address. Valid for Cluster Type: Multi-AZ DB clusters only Default: The default
  behavior varies depending on whether DBSubnetGroupName is specified. If DBSubnetGroupName
  isn't specified, and PubliclyAccessible isn't specified, the following applies:   If the
  default VPC in the target Region doesn’t have an internet gateway attached to it, the DB
  cluster is private.   If the default VPC in the target Region has an internet gateway
  attached to it, the DB cluster is public.   If DBSubnetGroupName is specified, and
  PubliclyAccessible isn't specified, the following applies:   If the subnets are part of a
  VPC that doesn’t have an internet gateway attached to it, the DB cluster is private.   If
  the subnets are part of a VPC that has an internet gateway attached to it, the DB cluster
  is public.
- `"RdsCustomClusterConfiguration"`: Reserved for future use.
- `"ReplicationSourceIdentifier"`: The Amazon Resource Name (ARN) of the source DB instance
  or DB cluster if this DB cluster is created as a read replica. Valid for Cluster Type:
  Aurora DB clusters and Multi-AZ DB clusters
- `"ScalingConfiguration"`: For DB clusters in serverless DB engine mode, the scaling
  properties of the DB cluster. Valid for Cluster Type: Aurora DB clusters only
- `"ServerlessV2ScalingConfiguration"`:
- `"SourceRegion"`: The ID of the region that contains the source for the read replica.
- `"StorageEncrypted"`: Specifies whether the DB cluster is encrypted. Valid for Cluster
  Type: Aurora DB clusters and Multi-AZ DB clusters
- `"StorageType"`: The storage type to associate with the DB cluster. For information on
  storage types for Aurora DB clusters, see Storage configurations for Amazon Aurora DB
  clusters. For information on storage types for Multi-AZ DB clusters, see Settings for
  creating Multi-AZ DB clusters. This setting is required to create a Multi-AZ DB cluster.
  When specified for a Multi-AZ DB cluster, a value for the Iops parameter is required. Valid
  for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Valid Values:   Aurora DB
  clusters - aurora | aurora-iopt1    Multi-AZ DB clusters - io1 | io2 | gp3    Default:
  Aurora DB clusters - aurora    Multi-AZ DB clusters - io1     When you create an Aurora DB
  cluster with the storage type set to aurora-iopt1, the storage type is returned in the
  response. The storage type isn't returned when you set it to aurora.
- `"Tags"`: Tags to assign to the DB cluster. Valid for Cluster Type: Aurora DB clusters
  and Multi-AZ DB clusters
- `"VpcSecurityGroupIds"`: A list of EC2 VPC security groups to associate with this DB
  cluster. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
"""
function create_dbcluster(
    DBClusterIdentifier, Engine; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "CreateDBCluster",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier, "Engine" => Engine);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbcluster(
    DBClusterIdentifier,
    Engine,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterIdentifier" => DBClusterIdentifier, "Engine" => Engine
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbcluster_endpoint(dbcluster_endpoint_identifier, dbcluster_identifier, endpoint_type)
    create_dbcluster_endpoint(dbcluster_endpoint_identifier, dbcluster_identifier, endpoint_type, params::Dict{String,<:Any})

Creates a new custom endpoint and associates it with an Amazon Aurora DB cluster.  This
action applies only to Aurora DB clusters.

# Arguments
- `dbcluster_endpoint_identifier`: The identifier to use for the new endpoint. This
  parameter is stored as a lowercase string.
- `dbcluster_identifier`: The DB cluster identifier of the DB cluster associated with the
  endpoint. This parameter is stored as a lowercase string.
- `endpoint_type`: The type of the endpoint, one of: READER, WRITER, ANY.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExcludedMembers"`: List of DB instance identifiers that aren't part of the custom
  endpoint group. All other eligible instances are reachable through the custom endpoint.
  This parameter is relevant only if the list of static members is empty.
- `"StaticMembers"`: List of DB instance identifiers that are part of the custom endpoint
  group.
- `"Tags"`: The tags to be assigned to the Amazon RDS resource.
"""
function create_dbcluster_endpoint(
    DBClusterEndpointIdentifier,
    DBClusterIdentifier,
    EndpointType;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBClusterEndpoint",
        Dict{String,Any}(
            "DBClusterEndpointIdentifier" => DBClusterEndpointIdentifier,
            "DBClusterIdentifier" => DBClusterIdentifier,
            "EndpointType" => EndpointType,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbcluster_endpoint(
    DBClusterEndpointIdentifier,
    DBClusterIdentifier,
    EndpointType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBClusterEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterEndpointIdentifier" => DBClusterEndpointIdentifier,
                    "DBClusterIdentifier" => DBClusterIdentifier,
                    "EndpointType" => EndpointType,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbcluster_parameter_group(dbcluster_parameter_group_name, dbparameter_group_family, description)
    create_dbcluster_parameter_group(dbcluster_parameter_group_name, dbparameter_group_family, description, params::Dict{String,<:Any})

Creates a new DB cluster parameter group. Parameters in a DB cluster parameter group apply
to all of the instances in a DB cluster. A DB cluster parameter group is initially created
with the default parameters for the database engine used by instances in the DB cluster. To
provide custom values for any of the parameters, you must modify the group after creating
it using ModifyDBClusterParameterGroup. Once you've created a DB cluster parameter group,
you need to associate it with your DB cluster using ModifyDBCluster. When you associate a
new DB cluster parameter group with a running Aurora DB cluster, reboot the DB instances in
the DB cluster without failover for the new DB cluster parameter group and associated
settings to take effect. When you associate a new DB cluster parameter group with a running
Multi-AZ DB cluster, reboot the DB cluster without failover for the new DB cluster
parameter group and associated settings to take effect.  After you create a DB cluster
parameter group, you should wait at least 5 minutes before creating your first DB cluster
that uses that DB cluster parameter group as the default parameter group. This allows
Amazon RDS to fully complete the create action before the DB cluster parameter group is
used as the default for a new DB cluster. This is especially important for parameters that
are critical when creating the default database for a DB cluster, such as the character set
for the default database defined by the character_set_database parameter. You can use the
Parameter Groups option of the Amazon RDS console or the DescribeDBClusterParameters
operation to verify that your DB cluster parameter group has been created or modified.  For
more information on Amazon Aurora, see  What is Amazon Aurora? in the Amazon Aurora User
Guide. For more information on Multi-AZ DB clusters, see  Multi-AZ DB cluster deployments
in the Amazon RDS User Guide.

# Arguments
- `dbcluster_parameter_group_name`: The name of the DB cluster parameter group.
  Constraints:   Must not match the name of an existing DB cluster parameter group.    This
  value is stored as a lowercase string.
- `dbparameter_group_family`: The DB cluster parameter group family name. A DB cluster
  parameter group can be associated with one and only one DB cluster parameter group family,
  and can be applied only to a DB cluster running a database engine and engine version
  compatible with that DB cluster parameter group family.  Aurora MySQL  Example:
  aurora-mysql5.7, aurora-mysql8.0   Aurora PostgreSQL  Example: aurora-postgresql14   RDS
  for MySQL  Example: mysql8.0   RDS for PostgreSQL  Example: postgres13  To list all of the
  available parameter group families for a DB engine, use the following command:  aws rds
  describe-db-engine-versions --query \"DBEngineVersions[].DBParameterGroupFamily\" --engine
  &lt;engine&gt;  For example, to list all of the available parameter group families for the
  Aurora PostgreSQL DB engine, use the following command:  aws rds
  describe-db-engine-versions --query \"DBEngineVersions[].DBParameterGroupFamily\" --engine
  aurora-postgresql   The output contains duplicates.  The following are the valid DB engine
  values:    aurora-mysql     aurora-postgresql     mysql     postgres
- `description`: The description for the DB cluster parameter group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: Tags to assign to the DB cluster parameter group.
"""
function create_dbcluster_parameter_group(
    DBClusterParameterGroupName,
    DBParameterGroupFamily,
    Description;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBClusterParameterGroup",
        Dict{String,Any}(
            "DBClusterParameterGroupName" => DBClusterParameterGroupName,
            "DBParameterGroupFamily" => DBParameterGroupFamily,
            "Description" => Description,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbcluster_parameter_group(
    DBClusterParameterGroupName,
    DBParameterGroupFamily,
    Description,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterParameterGroupName" => DBClusterParameterGroupName,
                    "DBParameterGroupFamily" => DBParameterGroupFamily,
                    "Description" => Description,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbcluster_snapshot(dbcluster_identifier, dbcluster_snapshot_identifier)
    create_dbcluster_snapshot(dbcluster_identifier, dbcluster_snapshot_identifier, params::Dict{String,<:Any})

Creates a snapshot of a DB cluster. For more information on Amazon Aurora, see  What is
Amazon Aurora? in the Amazon Aurora User Guide. For more information on Multi-AZ DB
clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The identifier of the DB cluster to create a snapshot for. This
  parameter isn't case-sensitive. Constraints:   Must match the identifier of an existing
  DBCluster.   Example: my-cluster1
- `dbcluster_snapshot_identifier`: The identifier of the DB cluster snapshot. This
  parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63
  letters, numbers, or hyphens.   First character must be a letter.   Can't end with a hyphen
  or contain two consecutive hyphens.   Example: my-cluster1-snapshot1

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: The tags to be assigned to the DB cluster snapshot.
"""
function create_dbcluster_snapshot(
    DBClusterIdentifier,
    DBClusterSnapshotIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBClusterSnapshot",
        Dict{String,Any}(
            "DBClusterIdentifier" => DBClusterIdentifier,
            "DBClusterSnapshotIdentifier" => DBClusterSnapshotIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbcluster_snapshot(
    DBClusterIdentifier,
    DBClusterSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterIdentifier" => DBClusterIdentifier,
                    "DBClusterSnapshotIdentifier" => DBClusterSnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbinstance(dbinstance_class, dbinstance_identifier, engine)
    create_dbinstance(dbinstance_class, dbinstance_identifier, engine, params::Dict{String,<:Any})

Creates a new DB instance. The new DB instance can be an RDS DB instance, or it can be a DB
instance in an Aurora DB cluster. For an Aurora DB cluster, you can call this operation
multiple times to add more than one DB instance to the cluster. For more information about
creating an RDS DB instance, see  Creating an Amazon RDS DB instance in the Amazon RDS User
Guide. For more information about creating a DB instance in an Aurora DB cluster, see
Creating an Amazon Aurora DB cluster in the Amazon Aurora User Guide.

# Arguments
- `dbinstance_class`: The compute and memory capacity of the DB instance, for example
  db.m5.large. Not all DB instance classes are available in all Amazon Web Services Regions,
  or for all database engines. For the full list of DB instance classes, and availability for
  your engine, see DB instance classes in the Amazon RDS User Guide or Aurora DB instance
  classes in the Amazon Aurora User Guide.
- `dbinstance_identifier`: The identifier for this DB instance. This parameter is stored as
  a lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.
   First character must be a letter.   Can't end with a hyphen or contain two consecutive
  hyphens.   Example: mydbinstance
- `engine`: The database engine to use for this DB instance. Not every database engine is
  available in every Amazon Web Services Region. Valid Values:    aurora-mysql (for Aurora
  MySQL DB instances)    aurora-postgresql (for Aurora PostgreSQL DB instances)
  custom-oracle-ee (for RDS Custom for Oracle DB instances)    custom-oracle-ee-cdb (for RDS
  Custom for Oracle DB instances)    custom-oracle-se2 (for RDS Custom for Oracle DB
  instances)    custom-oracle-se2-cdb (for RDS Custom for Oracle DB instances)
  custom-sqlserver-ee (for RDS Custom for SQL Server DB instances)    custom-sqlserver-se
  (for RDS Custom for SQL Server DB instances)    custom-sqlserver-web (for RDS Custom for
  SQL Server DB instances)    db2-ae     db2-se     mariadb     mysql     oracle-ee
  oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee
  sqlserver-se     sqlserver-ex     sqlserver-web

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocatedStorage"`: The amount of storage in gibibytes (GiB) to allocate for the DB
  instance. This setting doesn't apply to Amazon Aurora DB instances. Aurora cluster volumes
  automatically grow as the amount of data in your database increases, though you are only
  charged for the space that you use in an Aurora cluster volume.  Amazon RDS Custom
  Constraints to the amount of storage for each storage type are the following:   General
  Purpose (SSD) storage (gp2, gp3): Must be an integer from 40 to 65536 for RDS Custom for
  Oracle, 16384 for RDS Custom for SQL Server.   Provisioned IOPS storage (io1, io2): Must be
  an integer from 40 to 65536 for RDS Custom for Oracle, 16384 for RDS Custom for SQL Server.
     RDS for Db2  Constraints to the amount of storage for each storage type are the
  following:   General Purpose (SSD) storage (gp3): Must be an integer from 20 to 65536.
  Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.    RDS for
  MariaDB  Constraints to the amount of storage for each storage type are the following:
  General Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.
  Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.   Magnetic
  storage (standard): Must be an integer from 5 to 3072.    RDS for MySQL  Constraints to the
  amount of storage for each storage type are the following:   General Purpose (SSD) storage
  (gp2, gp3): Must be an integer from 20 to 65536.   Provisioned IOPS storage (io1, io2):
  Must be an integer from 100 to 65536.   Magnetic storage (standard): Must be an integer
  from 5 to 3072.    RDS for Oracle  Constraints to the amount of storage for each storage
  type are the following:   General Purpose (SSD) storage (gp2, gp3): Must be an integer from
  20 to 65536.   Provisioned IOPS storage (io1, io2): Must be an integer from 100 to 65536.
  Magnetic storage (standard): Must be an integer from 10 to 3072.    RDS for PostgreSQL
  Constraints to the amount of storage for each storage type are the following:   General
  Purpose (SSD) storage (gp2, gp3): Must be an integer from 20 to 65536.   Provisioned IOPS
  storage (io1, io2): Must be an integer from 100 to 65536.   Magnetic storage (standard):
  Must be an integer from 5 to 3072.    RDS for SQL Server  Constraints to the amount of
  storage for each storage type are the following:   General Purpose (SSD) storage (gp2,
  gp3):   Enterprise and Standard editions: Must be an integer from 20 to 16384.   Web and
  Express editions: Must be an integer from 20 to 16384.     Provisioned IOPS storage (io1,
  io2):   Enterprise and Standard editions: Must be an integer from 100 to 16384.   Web and
  Express editions: Must be an integer from 100 to 16384.     Magnetic storage (standard):
  Enterprise and Standard editions: Must be an integer from 20 to 1024.   Web and Express
  editions: Must be an integer from 20 to 1024.
- `"AutoMinorVersionUpgrade"`: Specifies whether minor engine upgrades are applied
  automatically to the DB instance during the maintenance window. By default, minor engine
  upgrades are applied automatically. If you create an RDS Custom DB instance, you must set
  AutoMinorVersionUpgrade to false.
- `"AvailabilityZone"`: The Availability Zone (AZ) where the database will be created. For
  information on Amazon Web Services Regions and Availability Zones, see Regions and
  Availability Zones. For Amazon Aurora, each Aurora DB cluster hosts copies of its storage
  in three separate Availability Zones. Specify one of these Availability Zones. Aurora
  automatically chooses an appropriate Availability Zone if you don't specify one. Default: A
  random, system-chosen Availability Zone in the endpoint's Amazon Web Services Region.
  Constraints:   The AvailabilityZone parameter can't be specified if the DB instance is a
  Multi-AZ deployment.   The specified Availability Zone must be in the same Amazon Web
  Services Region as the current endpoint.   Example: us-east-1d
- `"BackupRetentionPeriod"`: The number of days for which automated backups are retained.
  Setting this parameter to a positive number enables backups. Setting this parameter to 0
  disables automated backups. This setting doesn't apply to Amazon Aurora DB instances. The
  retention period for automated backups is managed by the DB cluster. Default: 1
  Constraints:   Must be a value from 0 to 35.   Can't be set to 0 if the DB instance is a
  source to read replicas.   Can't be set to 0 for an RDS Custom for Oracle DB instance.
- `"BackupTarget"`: The location for storing automated backups and manual snapshots. Valid
  Values:    outposts (Amazon Web Services Outposts)    region (Amazon Web Services Region)
  Default: region  For more information, see Working with Amazon RDS on Amazon Web Services
  Outposts in the Amazon RDS User Guide.
- `"CACertificateIdentifier"`: The CA certificate identifier to use for the DB instance's
  server certificate. This setting doesn't apply to RDS Custom DB instances. For more
  information, see Using SSL/TLS to encrypt a connection to a DB instance in the Amazon RDS
  User Guide and  Using SSL/TLS to encrypt a connection to a DB cluster in the Amazon Aurora
  User Guide.
- `"CharacterSetName"`: For supported engines, the character set (CharacterSet) to
  associate the DB instance with. This setting doesn't apply to the following DB instances:
  Amazon Aurora - The character set is managed by the DB cluster. For more information, see
  CreateDBCluster.   RDS Custom - However, if you need to change the character set, you can
  change it on the database itself.
- `"CopyTagsToSnapshot"`: Specifies whether to copy tags from the DB instance to snapshots
  of the DB instance. By default, tags are not copied. This setting doesn't apply to Amazon
  Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting this
  value for an Aurora DB instance has no effect on the DB cluster setting.
- `"CustomIamInstanceProfile"`: The instance profile associated with the underlying Amazon
  EC2 instance of an RDS Custom DB instance. This setting is required for RDS Custom.
  Constraints:   The profile must exist in your account.   The profile must have an IAM role
  that Amazon EC2 has permissions to assume.   The instance profile name and the associated
  IAM role name must start with the prefix AWSRDSCustom.   For the list of permissions
  required for the IAM role, see  Configure IAM and your VPC in the Amazon RDS User Guide.
- `"DBClusterIdentifier"`: The identifier of the DB cluster that this DB instance will
  belong to. This setting doesn't apply to RDS Custom DB instances.
- `"DBName"`: The meaning of this parameter differs according to the database engine you
  use.  Amazon Aurora MySQL  The name of the database to create when the primary DB instance
  of the Aurora MySQL DB cluster is created. If this parameter isn't specified for an Aurora
  MySQL DB cluster, no database is created in the DB cluster. Constraints:   Must contain 1
  to 64 alphanumeric characters.   Can't be a word reserved by the database engine.    Amazon
  Aurora PostgreSQL  The name of the database to create when the primary DB instance of the
  Aurora PostgreSQL DB cluster is created. A database named postgres is always created. If
  this parameter is specified, an additional database with this name is created. Constraints:
    It must contain 1 to 63 alphanumeric characters.   Must begin with a letter. Subsequent
  characters can be letters, underscores, or digits (0 to 9).   Can't be a word reserved by
  the database engine.    Amazon RDS Custom for Oracle  The Oracle System ID (SID) of the
  created RDS Custom DB instance. If you don't specify a value, the default value is ORCL for
  non-CDBs and RDSCDB for CDBs. Default: ORCL  Constraints:   Must contain 1 to 8
  alphanumeric characters.   Must contain a letter.   Can't be a word reserved by the
  database engine.    Amazon RDS Custom for SQL Server  Not applicable. Must be null.  RDS
  for Db2  The name of the database to create when the DB instance is created. If this
  parameter isn't specified, no database is created in the DB instance. In some cases, we
  recommend that you don't add a database name. For more information, see Additional
  considerations in the Amazon RDS User Guide. Constraints:   Must contain 1 to 64 letters or
  numbers.   Must begin with a letter. Subsequent characters can be letters, underscores, or
  digits (0-9).   Can't be a word reserved by the specified database engine.    RDS for
  MariaDB  The name of the database to create when the DB instance is created. If this
  parameter isn't specified, no database is created in the DB instance. Constraints:   Must
  contain 1 to 64 letters or numbers.   Must begin with a letter. Subsequent characters can
  be letters, underscores, or digits (0-9).   Can't be a word reserved by the specified
  database engine.    RDS for MySQL  The name of the database to create when the DB instance
  is created. If this parameter isn't specified, no database is created in the DB instance.
  Constraints:   Must contain 1 to 64 letters or numbers.   Must begin with a letter.
  Subsequent characters can be letters, underscores, or digits (0-9).   Can't be a word
  reserved by the specified database engine.    RDS for Oracle  The Oracle System ID (SID) of
  the created DB instance. If you don't specify a value, the default value is ORCL. You can't
  specify the string null, or any other reserved word, for DBName. Default: ORCL
  Constraints:   Can't be longer than 8 characters.    RDS for PostgreSQL  The name of the
  database to create when the DB instance is created. A database named postgres is always
  created. If this parameter is specified, an additional database with this name is created.
  Constraints:   Must contain 1 to 63 letters, numbers, or underscores.   Must begin with a
  letter. Subsequent characters can be letters, underscores, or digits (0-9).   Can't be a
  word reserved by the specified database engine.    RDS for SQL Server  Not applicable. Must
  be null.
- `"DBParameterGroupName"`: The name of the DB parameter group to associate with this DB
  instance. If you don't specify a value, then Amazon RDS uses the default DB parameter group
  for the specified DB engine and version. This setting doesn't apply to RDS Custom DB
  instances. Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   The first
  character must be a letter.   Can't end with a hyphen or contain two consecutive hyphens.
- `"DBSecurityGroups"`: A list of DB security groups to associate with this DB instance.
  This setting applies to the legacy EC2-Classic platform, which is no longer used to create
  new DB instances. Use the VpcSecurityGroupIds setting instead.
- `"DBSubnetGroupName"`: A DB subnet group to associate with this DB instance. Constraints:
    Must match the name of an existing DB subnet group.   Must not be default.   Example:
  mydbsubnetgroup
- `"DBSystemId"`: The Oracle system identifier (SID), which is the name of the Oracle
  database instance that manages your database files. In this context, the term \"Oracle
  database instance\" refers exclusively to the system global area (SGA) and Oracle
  background processes. If you don't specify a SID, the value defaults to RDSCDB. The Oracle
  SID is also the name of your CDB.
- `"DedicatedLogVolume"`: Indicates whether the DB instance has a dedicated log volume
  (DLV) enabled.
- `"DeletionProtection"`: Specifies whether the DB instance has deletion protection
  enabled. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled. For more information, see  Deleting a DB Instance. This
  setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion
  protection for the DB cluster. For more information, see CreateDBCluster. DB instances in a
  DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
- `"Domain"`: The Active Directory directory ID to create the DB instance in. Currently,
  you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances
  in an Active Directory Domain. For more information, see  Kerberos Authentication in the
  Amazon RDS User Guide. This setting doesn't apply to the following DB instances:   Amazon
  Aurora (The domain is managed by the DB cluster.)   RDS Custom
- `"DomainAuthSecretArn"`: The ARN for the Secrets Manager secret with the credentials for
  the user joining the domain. Example:
  arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456
- `"DomainDnsIps"`: The IPv4 DNS IP addresses of your primary and secondary Active
  Directory domain controllers. Constraints:   Two IP addresses must be provided. If there
  isn't a secondary domain controller, use the IP address of the primary domain controller
  for both entries in the list.   Example: 123.124.125.126,234.235.236.237
- `"DomainFqdn"`: The fully qualified domain name (FQDN) of an Active Directory domain.
  Constraints:   Can't be longer than 64 characters.   Example:
  mymanagedADtest.mymanagedAD.mydomain
- `"DomainIAMRoleName"`: The name of the IAM role to use when making API calls to the
  Directory Service. This setting doesn't apply to the following DB instances:   Amazon
  Aurora (The domain is managed by the DB cluster.)   RDS Custom
- `"DomainOu"`: The Active Directory organizational unit for your DB instance to join.
  Constraints:   Must be in the distinguished name format.   Can't be longer than 64
  characters.   Example: OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain
- `"EnableCloudwatchLogsExports"`: The list of log types to enable for exporting to
  CloudWatch Logs. For more information, see  Publishing Database Logs to Amazon CloudWatch
  Logs in the Amazon RDS User Guide. This setting doesn't apply to the following DB
  instances:   Amazon Aurora (CloudWatch Logs exports are managed by the DB cluster.)   RDS
  Custom   The following values are valid for each DB engine:   RDS for Db2 - diag.log |
  notify.log    RDS for MariaDB - audit | error | general | slowquery    RDS for Microsoft
  SQL Server - agent | error    RDS for MySQL - audit | error | general | slowquery    RDS
  for Oracle - alert | audit | listener | trace | oemagent    RDS for PostgreSQL - postgresql
  | upgrade
- `"EnableCustomerOwnedIp"`: Specifies whether to enable a customer-owned IP address (CoIP)
  for an RDS on Outposts DB instance. A CoIP provides local or external connectivity to
  resources in your Outpost subnets through your on-premises network. For some use cases, a
  CoIP can provide lower latency for connections to the DB instance from outside of its
  virtual private cloud (VPC) on your local network. For more information about RDS on
  Outposts, see Working with Amazon RDS on Amazon Web Services Outposts in the Amazon RDS
  User Guide. For more information about CoIPs, see Customer-owned IP addresses in the Amazon
  Web Services Outposts User Guide.
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. For more information, see  IAM Database Authentication for MySQL and
  PostgreSQL in the Amazon RDS User Guide. This setting doesn't apply to the following DB
  instances:   Amazon Aurora (Mapping Amazon Web Services IAM accounts to database accounts
  is managed by the DB cluster.)   RDS Custom
- `"EnablePerformanceInsights"`: Specifies whether to enable Performance Insights for the
  DB instance. For more information, see Using Amazon Performance Insights in the Amazon RDS
  User Guide. This setting doesn't apply to RDS Custom DB instances.
- `"EngineLifecycleSupport"`: The life cycle type for this DB instance.  By default, this
  value is set to open-source-rds-extended-support, which enrolls your DB instance into
  Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
  Extended Support by setting the value to open-source-rds-extended-support-disabled. In this
  case, creating the DB instance will fail if the DB major version is past its end of
  standard support date.  This setting applies only to RDS for MySQL and RDS for PostgreSQL.
  For Amazon Aurora DB instances, the life cycle type is managed by the DB cluster. You can
  use this setting to enroll your DB instance into Amazon RDS Extended Support. With RDS
  Extended Support, you can run the selected major engine version on your DB instance past
  the end of standard support for that engine version. For more information, see Using Amazon
  RDS Extended Support in the Amazon RDS User Guide. Valid Values:
  open-source-rds-extended-support | open-source-rds-extended-support-disabled  Default:
  open-source-rds-extended-support
- `"EngineVersion"`: The version number of the database engine to use. This setting doesn't
  apply to Amazon Aurora DB instances. The version number of the database engine the DB
  instance uses is managed by the DB cluster. For a list of valid engine versions, use the
  DescribeDBEngineVersions operation. The following are the database engines and links to
  information about the major and minor versions that are available with Amazon RDS. Not
  every database engine is available for every Amazon Web Services Region.  Amazon RDS Custom
  for Oracle  A custom engine version (CEV) that you have previously created. This setting is
  required for RDS Custom for Oracle. The CEV name has the following format:
  19.customized_string. A valid CEV name is 19.my_cev1. For more information, see  Creating
  an RDS Custom for Oracle DB instance in the Amazon RDS User Guide.  Amazon RDS Custom for
  SQL Server  See RDS Custom for SQL Server general requirements in the Amazon RDS User
  Guide.  RDS for Db2  For information, see Db2 on Amazon RDS versions in the Amazon RDS User
  Guide.  RDS for MariaDB  For information, see MariaDB on Amazon RDS versions in the Amazon
  RDS User Guide.  RDS for Microsoft SQL Server  For information, see Microsoft SQL Server
  versions on Amazon RDS in the Amazon RDS User Guide.  RDS for MySQL  For information, see
  MySQL on Amazon RDS versions in the Amazon RDS User Guide.  RDS for Oracle  For
  information, see Oracle Database Engine release notes in the Amazon RDS User Guide.  RDS
  for PostgreSQL  For information, see Amazon RDS for PostgreSQL versions and extensions in
  the Amazon RDS User Guide.
- `"Iops"`: The amount of Provisioned IOPS (input/output operations per second) to
  initially allocate for the DB instance. For information about valid IOPS values, see Amazon
  RDS DB instance storage in the Amazon RDS User Guide. This setting doesn't apply to Amazon
  Aurora DB instances. Storage is managed by the DB cluster. Constraints:   For RDS for Db2,
  MariaDB, MySQL, Oracle, and PostgreSQL - Must be a multiple between .5 and 50 of the
  storage amount for the DB instance.   For RDS for SQL Server - Must be a multiple between 1
  and 50 of the storage amount for the DB instance.
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier for an encrypted DB instance.
  The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name
  for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the
  key ARN or alias ARN. This setting doesn't apply to Amazon Aurora DB instances. The Amazon
  Web Services KMS key identifier is managed by the DB cluster. For more information, see
  CreateDBCluster. If StorageEncrypted is enabled, and you do not specify a value for the
  KmsKeyId parameter, then Amazon RDS uses your default KMS key. There is a default KMS key
  for your Amazon Web Services account. Your Amazon Web Services account has a different
  default KMS key for each Amazon Web Services Region. For Amazon RDS Custom, a KMS key is
  required for DB instances. For most RDS engines, if you leave this parameter empty while
  enabling StorageEncrypted, the engine uses the default KMS key. However, RDS Custom doesn't
  use the default key when this parameter is empty. You must explicitly specify a key.
- `"LicenseModel"`: The license model information for this DB instance.  License models for
  RDS for Db2 require additional configuration. The Bring Your Own License (BYOL) model
  requires a custom parameter group. The Db2 license through Amazon Web Services Marketplace
  model requires an Amazon Web Services Marketplace subscription. For more information, see
  RDS for Db2 licensing options in the Amazon RDS User Guide. The default for RDS for Db2 is
  bring-your-own-license.  This setting doesn't apply to Amazon Aurora or RDS Custom DB
  instances. Valid Values:   RDS for Db2 - bring-your-own-license | marketplace-license
  RDS for MariaDB - general-public-license    RDS for Microsoft SQL Server - license-included
     RDS for MySQL - general-public-license    RDS for Oracle - bring-your-own-license |
  license-included    RDS for PostgreSQL - postgresql-license
- `"ManageMasterUserPassword"`: Specifies whether to manage the master user password with
  Amazon Web Services Secrets Manager. For more information, see Password management with
  Amazon Web Services Secrets Manager in the Amazon RDS User Guide.  Constraints:   Can't
  manage the master user password with Amazon Web Services Secrets Manager if
  MasterUserPassword is specified.
- `"MasterUserPassword"`: The password for the master user. This setting doesn't apply to
  Amazon Aurora DB instances. The password for the master user is managed by the DB cluster.
  Constraints:   Can't be specified if ManageMasterUserPassword is turned on.   Can include
  any printable ASCII character except \"/\", \"\"\", or \"@\". For RDS for Oracle, can't
  include the \"&amp;\" (ampersand) or the \"'\" (single quotes) character.   Length
  Constraints:   RDS for Db2 - Must contain from 8 to 255 characters.   RDS for MariaDB -
  Must contain from 8 to 41 characters.   RDS for Microsoft SQL Server - Must contain from 8
  to 128 characters.   RDS for MySQL - Must contain from 8 to 41 characters.   RDS for Oracle
  - Must contain from 8 to 30 characters.   RDS for PostgreSQL - Must contain from 8 to 128
  characters.
- `"MasterUserSecretKmsKeyId"`: The Amazon Web Services KMS key identifier to encrypt a
  secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
  This setting is valid only if the master user password is managed by RDS in Amazon Web
  Services Secrets Manager for the DB instance. The Amazon Web Services KMS key identifier is
  the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a
  different Amazon Web Services account, specify the key ARN or alias ARN. If you don't
  specify MasterUserSecretKmsKeyId, then the aws/secretsmanager KMS key is used to encrypt
  the secret. If the secret is in a different Amazon Web Services account, then you can't use
  the aws/secretsmanager KMS key to encrypt the secret, and you must use a customer managed
  KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
  Services account has a different default KMS key for each Amazon Web Services Region.
- `"MasterUsername"`: The name for the master user. This setting doesn't apply to Amazon
  Aurora DB instances. The name for the master user is managed by the DB cluster. This
  setting is required for RDS DB instances. Constraints:   Must be 1 to 16 letters, numbers,
  or underscores.   First character must be a letter.   Can't be a reserved word for the
  chosen database engine.
- `"MaxAllocatedStorage"`: The upper limit in gibibytes (GiB) to which Amazon RDS can
  automatically scale the storage of the DB instance. For more information about this
  setting, including limitations that apply to it, see  Managing capacity automatically with
  Amazon RDS storage autoscaling in the Amazon RDS User Guide. This setting doesn't apply to
  the following DB instances:   Amazon Aurora (Storage is managed by the DB cluster.)   RDS
  Custom
- `"MonitoringInterval"`: The interval, in seconds, between points when Enhanced Monitoring
  metrics are collected for the DB instance. To disable collection of Enhanced Monitoring
  metrics, specify 0. If MonitoringRoleArn is specified, then you must set MonitoringInterval
  to a value other than 0. This setting doesn't apply to RDS Custom DB instances. Valid
  Values: 0 | 1 | 5 | 10 | 15 | 30 | 60  Default: 0
- `"MonitoringRoleArn"`: The ARN for the IAM role that permits RDS to send enhanced
  monitoring metrics to Amazon CloudWatch Logs. For example,
  arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role, see
  Setting Up and Enabling Enhanced Monitoring in the Amazon RDS User Guide. If
  MonitoringInterval is set to a value other than 0, then you must supply a MonitoringRoleArn
  value. This setting doesn't apply to RDS Custom DB instances.
- `"MultiAZ"`: Specifies whether the DB instance is a Multi-AZ deployment. You can't set
  the AvailabilityZone parameter if the DB instance is a Multi-AZ deployment. This setting
  doesn't apply to the following DB instances:   Amazon Aurora (DB instance Availability
  Zones (AZs) are managed by the DB cluster.)   RDS Custom
- `"MultiTenant"`: Specifies whether to use the multi-tenant configuration or the
  single-tenant configuration (default). This parameter only applies to RDS for Oracle
  container database (CDB) engines. Note the following restrictions:    The DB engine that
  you specify in the request must support the multi-tenant configuration. If you attempt to
  enable the multi-tenant configuration on a DB engine that doesn't support it, the request
  fails.   If you specify the multi-tenant configuration when you create your DB instance,
  you can't later modify this DB instance to use the single-tenant configuration.
- `"NcharCharacterSetName"`: The name of the NCHAR character set for the Oracle DB
  instance. This setting doesn't apply to RDS Custom DB instances.
- `"NetworkType"`: The network type of the DB instance. The network type is determined by
  the DBSubnetGroup specified for the DB instance. A DBSubnetGroup can support only the IPv4
  protocol or the IPv4 and the IPv6 protocols (DUAL). For more information, see  Working with
  a DB instance in a VPC in the Amazon RDS User Guide.  Valid Values: IPV4 | DUAL
- `"OptionGroupName"`: The option group to associate the DB instance with. Permanent
  options, such as the TDE option for Oracle Advanced Security TDE, can't be removed from an
  option group. Also, that option group can't be removed from a DB instance after it is
  associated with a DB instance. This setting doesn't apply to Amazon Aurora or RDS Custom DB
  instances.
- `"PerformanceInsightsKMSKeyId"`: The Amazon Web Services KMS key identifier for
  encryption of Performance Insights data. The Amazon Web Services KMS key identifier is the
  key ARN, key ID, alias ARN, or alias name for the KMS key. If you don't specify a value for
  PerformanceInsightsKMSKeyId, then Amazon RDS uses your default KMS key. There is a default
  KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
  different default KMS key for each Amazon Web Services Region. This setting doesn't apply
  to RDS Custom DB instances.
- `"PerformanceInsightsRetentionPeriod"`: The number of days to retain Performance Insights
  data. This setting doesn't apply to RDS Custom DB instances. Valid Values:    7     month *
  31, where month is a number of months from 1-23. Examples: 93 (3 months * 31), 341 (11
  months * 31), 589 (19 months * 31)    731    Default: 7 days If you specify a retention
  period that isn't valid, such as 94, Amazon RDS returns an error.
- `"Port"`: The port number on which the database accepts connections. This setting doesn't
  apply to Aurora DB instances. The port number is managed by the cluster. Valid Values:
  1150-65535  Default:   RDS for Db2 - 50000    RDS for MariaDB - 3306    RDS for Microsoft
  SQL Server - 1433    RDS for MySQL - 3306    RDS for Oracle - 1521    RDS for PostgreSQL -
  5432    Constraints:   For RDS for Microsoft SQL Server, the value can't be 1234, 1434,
  3260, 3343, 3389, 47001, or 49152-49156.
- `"PreferredBackupWindow"`: The daily time range during which automated backups are
  created if automated backups are enabled, using the BackupRetentionPeriod parameter. The
  default is a 30-minute window selected at random from an 8-hour block of time for each
  Amazon Web Services Region. For more information, see Backup window in the Amazon RDS User
  Guide. This setting doesn't apply to Amazon Aurora DB instances. The daily time range for
  creating automated backups is managed by the DB cluster. Constraints:   Must be in the
  format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict
  with the preferred maintenance window.   Must be at least 30 minutes.
- `"PreferredMaintenanceWindow"`: The time range each week during which system maintenance
  can occur. For more information, see Amazon RDS Maintenance Window in the Amazon RDS User
  Guide.  The default is a 30-minute window selected at random from an 8-hour block of time
  for each Amazon Web Services Region, occurring on a random day of the week. Constraints:
  Must be in the format ddd:hh24:mi-ddd:hh24:mi.   The day values must be mon | tue | wed |
  thu | fri | sat | sun.    Must be in Universal Coordinated Time (UTC).   Must not conflict
  with the preferred backup window.   Must be at least 30 minutes.
- `"ProcessorFeatures"`: The number of CPU cores and the number of threads per core for the
  DB instance class of the DB instance. This setting doesn't apply to Amazon Aurora or RDS
  Custom DB instances.
- `"PromotionTier"`: The order of priority in which an Aurora Replica is promoted to the
  primary instance after a failure of the existing primary instance. For more information,
  see  Fault Tolerance for an Aurora DB Cluster in the Amazon Aurora User Guide. This setting
  doesn't apply to RDS Custom DB instances. Default: 1  Valid Values: 0 - 15
- `"PubliclyAccessible"`: Specifies whether the DB instance is publicly accessible. When
  the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to
  the private IP address from within the DB instance's virtual private cloud (VPC). It
  resolves to the public IP address from outside of the DB instance's VPC. Access to the DB
  instance is ultimately controlled by the security group it uses. That public access is not
  permitted if the security group assigned to the DB instance doesn't permit it. When the DB
  instance isn't publicly accessible, it is an internal DB instance with a DNS name that
  resolves to a private IP address. Default: The default behavior varies depending on whether
  DBSubnetGroupName is specified. If DBSubnetGroupName isn't specified, and
  PubliclyAccessible isn't specified, the following applies:   If the default VPC in the
  target Region doesn’t have an internet gateway attached to it, the DB instance is
  private.   If the default VPC in the target Region has an internet gateway attached to it,
  the DB instance is public.   If DBSubnetGroupName is specified, and PubliclyAccessible
  isn't specified, the following applies:   If the subnets are part of a VPC that doesn’t
  have an internet gateway attached to it, the DB instance is private.   If the subnets are
  part of a VPC that has an internet gateway attached to it, the DB instance is public.
- `"StorageEncrypted"`: Specifes whether the DB instance is encrypted. By default, it isn't
  encrypted. For RDS Custom DB instances, either enable this setting or leave it unset.
  Otherwise, Amazon RDS reports an error. This setting doesn't apply to Amazon Aurora DB
  instances. The encryption for DB instances is managed by the DB cluster.
- `"StorageThroughput"`: The storage throughput value for the DB instance. This setting
  applies only to the gp3 storage type. This setting doesn't apply to Amazon Aurora or RDS
  Custom DB instances.
- `"StorageType"`: The storage type to associate with the DB instance. If you specify io1,
  io2, or gp3, you must also include a value for the Iops parameter. This setting doesn't
  apply to Amazon Aurora DB instances. Storage is managed by the DB cluster. Valid Values:
  gp2 | gp3 | io1 | io2 | standard  Default: io1, if the Iops parameter is specified.
  Otherwise, gp2.
- `"Tags"`: Tags to assign to the DB instance.
- `"TdeCredentialArn"`: The ARN from the key store with which to associate the instance for
  TDE encryption. This setting doesn't apply to Amazon Aurora or RDS Custom DB instances.
- `"TdeCredentialPassword"`: The password for the given ARN from the key store in order to
  access the device. This setting doesn't apply to RDS Custom DB instances.
- `"Timezone"`: The time zone of the DB instance. The time zone parameter is currently
  supported only by RDS for Db2 and RDS for SQL Server.
- `"VpcSecurityGroupIds"`: A list of Amazon EC2 VPC security groups to associate with this
  DB instance. This setting doesn't apply to Amazon Aurora DB instances. The associated list
  of EC2 VPC security groups is managed by the DB cluster. Default: The default EC2 VPC
  security group for the DB subnet group's VPC.
"""
function create_dbinstance(
    DBInstanceClass,
    DBInstanceIdentifier,
    Engine;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBInstance",
        Dict{String,Any}(
            "DBInstanceClass" => DBInstanceClass,
            "DBInstanceIdentifier" => DBInstanceIdentifier,
            "Engine" => Engine,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbinstance(
    DBInstanceClass,
    DBInstanceIdentifier,
    Engine,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceClass" => DBInstanceClass,
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "Engine" => Engine,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbinstance_read_replica(dbinstance_identifier)
    create_dbinstance_read_replica(dbinstance_identifier, params::Dict{String,<:Any})

Creates a new DB instance that acts as a read replica for an existing source DB instance or
Multi-AZ DB cluster. You can create a read replica for a DB instance running Db2, MariaDB,
MySQL, Oracle, PostgreSQL, or SQL Server. You can create a read replica for a Multi-AZ DB
cluster running MySQL or PostgreSQL. For more information, see Working with read replicas
and Migrating from a Multi-AZ DB cluster to a DB instance using a read replica in the
Amazon RDS User Guide. Amazon Aurora doesn't support this operation. To create a DB
instance for an Aurora DB cluster, use the CreateDBInstance operation. All read replica DB
instances are created with backups disabled. All other attributes (including DB security
groups and DB parameter groups) are inherited from the source DB instance or cluster,
except as specified.  Your source DB instance or cluster must have backup retention
enabled.

# Arguments
- `dbinstance_identifier`: The DB instance identifier of the read replica. This identifier
  is the unique key that identifies a DB instance. This parameter is stored as a lowercase
  string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocatedStorage"`: The amount of storage (in gibibytes) to allocate initially for the
  read replica. Follow the allocation rules specified in CreateDBInstance.  Be sure to
  allocate enough storage for your read replica so that the create operation can succeed. You
  can also allocate additional storage for future growth.
- `"AutoMinorVersionUpgrade"`: Specifies whether to automatically apply minor engine
  upgrades to the read replica during the maintenance window. This setting doesn't apply to
  RDS Custom DB instances. Default: Inherits the value from the source DB instance.
- `"AvailabilityZone"`: The Availability Zone (AZ) where the read replica will be created.
  Default: A random, system-chosen Availability Zone in the endpoint's Amazon Web Services
  Region. Example: us-east-1d
- `"CACertificateIdentifier"`: The CA certificate identifier to use for the read replica's
  server certificate. This setting doesn't apply to RDS Custom DB instances. For more
  information, see Using SSL/TLS to encrypt a connection to a DB instance in the Amazon RDS
  User Guide and  Using SSL/TLS to encrypt a connection to a DB cluster in the Amazon Aurora
  User Guide.
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the read replica to
  snapshots of the read replica. By default, tags aren't copied.
- `"CustomIamInstanceProfile"`: The instance profile associated with the underlying Amazon
  EC2 instance of an RDS Custom DB instance. The instance profile must meet the following
  requirements:   The profile must exist in your account.   The profile must have an IAM role
  that Amazon EC2 has permissions to assume.   The instance profile name and the associated
  IAM role name must start with the prefix AWSRDSCustom.   For the list of permissions
  required for the IAM role, see  Configure IAM and your VPC in the Amazon RDS User Guide.
  This setting is required for RDS Custom DB instances.
- `"DBInstanceClass"`: The compute and memory capacity of the read replica, for example
  db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions,
  or for all database engines. For the full list of DB instance classes, and availability for
  your engine, see DB Instance Class in the Amazon RDS User Guide. Default: Inherits the
  value from the source DB instance.
- `"DBParameterGroupName"`: The name of the DB parameter group to associate with this DB
  instance. If you don't specify a value for DBParameterGroupName, then Amazon RDS uses the
  DBParameterGroup of the source DB instance for a same Region read replica, or the default
  DBParameterGroup for the specified DB engine for a cross-Region read replica. Specifying a
  parameter group for this operation is only supported for MySQL DB instances for
  cross-Region read replicas and for Oracle DB instances. It isn't supported for MySQL DB
  instances for same Region read replicas or for RDS Custom. Constraints:   Must be 1 to 255
  letters, numbers, or hyphens.   First character must be a letter.   Can't end with a hyphen
  or contain two consecutive hyphens.
- `"DBSubnetGroupName"`: A DB subnet group for the DB instance. The new DB instance is
  created in the VPC associated with the DB subnet group. If no DB subnet group is specified,
  then the new DB instance isn't created in a VPC. Constraints:   If supplied, must match the
  name of an existing DB subnet group.   The specified DB subnet group must be in the same
  Amazon Web Services Region in which the operation is running.   All read replicas in one
  Amazon Web Services Region that are created from the same source DB instance must either:
  Specify DB subnet groups from the same VPC. All these read replicas are created in the same
  VPC.   Not specify a DB subnet group. All these read replicas are created outside of any
  VPC.     Example: mydbsubnetgroup
- `"DedicatedLogVolume"`: Indicates whether the DB instance has a dedicated log volume
  (DLV) enabled.
- `"DeletionProtection"`: Specifies whether to enable deletion protection for the DB
  instance. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled. For more information, see  Deleting a DB Instance.
- `"Domain"`: The Active Directory directory ID to create the DB instance in. Currently,
  only MySQL, Microsoft SQL Server, Oracle, and PostgreSQL DB instances can be created in an
  Active Directory Domain. For more information, see  Kerberos Authentication in the Amazon
  RDS User Guide. This setting doesn't apply to RDS Custom DB instances.
- `"DomainAuthSecretArn"`: The ARN for the Secrets Manager secret with the credentials for
  the user joining the domain. Example:
  arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456
- `"DomainDnsIps"`: The IPv4 DNS IP addresses of your primary and secondary Active
  Directory domain controllers. Constraints:   Two IP addresses must be provided. If there
  isn't a secondary domain controller, use the IP address of the primary domain controller
  for both entries in the list.   Example: 123.124.125.126,234.235.236.237
- `"DomainFqdn"`: The fully qualified domain name (FQDN) of an Active Directory domain.
  Constraints:   Can't be longer than 64 characters.   Example:
  mymanagedADtest.mymanagedAD.mydomain
- `"DomainIAMRoleName"`: The name of the IAM role to use when making API calls to the
  Directory Service. This setting doesn't apply to RDS Custom DB instances.
- `"DomainOu"`: The Active Directory organizational unit for your DB instance to join.
  Constraints:   Must be in the distinguished name format.   Can't be longer than 64
  characters.   Example: OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain
- `"EnableCloudwatchLogsExports"`: The list of logs that the new DB instance is to export
  to CloudWatch Logs. The values in the list depend on the DB engine being used. For more
  information, see Publishing Database Logs to Amazon CloudWatch Logs  in the Amazon RDS User
  Guide. This setting doesn't apply to RDS Custom DB instances.
- `"EnableCustomerOwnedIp"`: Specifies whether to enable a customer-owned IP address (CoIP)
  for an RDS on Outposts read replica. A CoIP provides local or external connectivity to
  resources in your Outpost subnets through your on-premises network. For some use cases, a
  CoIP can provide lower latency for connections to the read replica from outside of its
  virtual private cloud (VPC) on your local network. For more information about RDS on
  Outposts, see Working with Amazon RDS on Amazon Web Services Outposts in the Amazon RDS
  User Guide. For more information about CoIPs, see Customer-owned IP addresses in the Amazon
  Web Services Outposts User Guide.
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. For more information about IAM database authentication, see  IAM
  Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide. This setting
  doesn't apply to RDS Custom DB instances.
- `"EnablePerformanceInsights"`: Specifies whether to enable Performance Insights for the
  read replica. For more information, see Using Amazon Performance Insights in the Amazon RDS
  User Guide. This setting doesn't apply to RDS Custom DB instances.
- `"Iops"`: The amount of Provisioned IOPS (input/output operations per second) to
  initially allocate for the DB instance.
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier for an encrypted read replica.
  The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name
  for the KMS key. If you create an encrypted read replica in the same Amazon Web Services
  Region as the source DB instance or Multi-AZ DB cluster, don't specify a value for this
  parameter. A read replica in the same Amazon Web Services Region is always encrypted with
  the same KMS key as the source DB instance or cluster. If you create an encrypted read
  replica in a different Amazon Web Services Region, then you must specify a KMS key
  identifier for the destination Amazon Web Services Region. KMS keys are specific to the
  Amazon Web Services Region that they are created in, and you can't use KMS keys from one
  Amazon Web Services Region in another Amazon Web Services Region. You can't create an
  encrypted read replica from an unencrypted DB instance or Multi-AZ DB cluster. This setting
  doesn't apply to RDS Custom, which uses the same KMS key as the primary replica.
- `"MaxAllocatedStorage"`: The upper limit in gibibytes (GiB) to which Amazon RDS can
  automatically scale the storage of the DB instance. For more information about this
  setting, including limitations that apply to it, see  Managing capacity automatically with
  Amazon RDS storage autoscaling in the Amazon RDS User Guide.
- `"MonitoringInterval"`: The interval, in seconds, between points when Enhanced Monitoring
  metrics are collected for the read replica. To disable collection of Enhanced Monitoring
  metrics, specify 0. The default is 0. If MonitoringRoleArn is specified, then you must set
  MonitoringInterval to a value other than 0. This setting doesn't apply to RDS Custom DB
  instances. Valid Values: 0, 1, 5, 10, 15, 30, 60  Default: 0
- `"MonitoringRoleArn"`: The ARN for the IAM role that permits RDS to send enhanced
  monitoring metrics to Amazon CloudWatch Logs. For example,
  arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role, go
  to To create an IAM role for Amazon RDS Enhanced Monitoring in the Amazon RDS User Guide.
  If MonitoringInterval is set to a value other than 0, then you must supply a
  MonitoringRoleArn value. This setting doesn't apply to RDS Custom DB instances.
- `"MultiAZ"`: Specifies whether the read replica is in a Multi-AZ deployment. You can
  create a read replica as a Multi-AZ DB instance. RDS creates a standby of your replica in
  another Availability Zone for failover support for the replica. Creating your read replica
  as a Multi-AZ DB instance is independent of whether the source is a Multi-AZ DB instance or
  a Multi-AZ DB cluster. This setting doesn't apply to RDS Custom DB instances.
- `"NetworkType"`: The network type of the DB instance. Valid Values:    IPV4     DUAL
  The network type is determined by the DBSubnetGroup specified for read replica. A
  DBSubnetGroup can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (DUAL).
  For more information, see  Working with a DB instance in a VPC in the Amazon RDS User
  Guide.
- `"OptionGroupName"`: The option group to associate the DB instance with. If not
  specified, RDS uses the option group associated with the source DB instance or cluster.
  For SQL Server, you must use the option group associated with the source.  This setting
  doesn't apply to RDS Custom DB instances.
- `"PerformanceInsightsKMSKeyId"`: The Amazon Web Services KMS key identifier for
  encryption of Performance Insights data. The Amazon Web Services KMS key identifier is the
  key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value
  for PerformanceInsightsKMSKeyId, then Amazon RDS uses your default KMS key. There is a
  default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
  a different default KMS key for each Amazon Web Services Region. This setting doesn't apply
  to RDS Custom DB instances.
- `"PerformanceInsightsRetentionPeriod"`: The number of days to retain Performance Insights
  data. This setting doesn't apply to RDS Custom DB instances. Valid Values:    7     month *
  31, where month is a number of months from 1-23. Examples: 93 (3 months * 31), 341 (11
  months * 31), 589 (19 months * 31)    731    Default: 7 days If you specify a retention
  period that isn't valid, such as 94, Amazon RDS returns an error.
- `"Port"`: The port number that the DB instance uses for connections. Valid Values:
  1150-65535  Default: Inherits the value from the source DB instance.
- `"PreSignedUrl"`: When you are creating a read replica from one Amazon Web Services
  GovCloud (US) Region to another or from one China Amazon Web Services Region to another,
  the URL that contains a Signature Version 4 signed request for the
  CreateDBInstanceReadReplica API operation in the source Amazon Web Services Region that
  contains the source DB instance. This setting applies only to Amazon Web Services GovCloud
  (US) Regions and China Amazon Web Services Regions. It's ignored in other Amazon Web
  Services Regions. This setting applies only when replicating from a source DB instance.
  Source DB clusters aren't supported in Amazon Web Services GovCloud (US) Regions and China
  Amazon Web Services Regions. You must specify this parameter when you create an encrypted
  read replica from another Amazon Web Services Region by using the Amazon RDS API. Don't
  specify PreSignedUrl when you are creating an encrypted read replica in the same Amazon Web
  Services Region. The presigned URL must be a valid request for the
  CreateDBInstanceReadReplica API operation that can run in the source Amazon Web Services
  Region that contains the encrypted source DB instance. The presigned URL request must
  contain the following parameter values:    DestinationRegion - The Amazon Web Services
  Region that the encrypted read replica is created in. This Amazon Web Services Region is
  the same one where the CreateDBInstanceReadReplica operation is called that contains this
  presigned URL. For example, if you create an encrypted DB instance in the us-west-1 Amazon
  Web Services Region, from a source DB instance in the us-east-2 Amazon Web Services Region,
  then you call the CreateDBInstanceReadReplica operation in the us-east-1 Amazon Web
  Services Region and provide a presigned URL that contains a call to the
  CreateDBInstanceReadReplica operation in the us-west-2 Amazon Web Services Region. For this
  example, the DestinationRegion in the presigned URL must be set to the us-east-1 Amazon Web
  Services Region.    KmsKeyId - The KMS key identifier for the key to use to encrypt the
  read replica in the destination Amazon Web Services Region. This is the same identifier for
  both the CreateDBInstanceReadReplica operation that is called in the destination Amazon Web
  Services Region, and the operation contained in the presigned URL.
  SourceDBInstanceIdentifier - The DB instance identifier for the encrypted DB instance to be
  replicated. This identifier must be in the Amazon Resource Name (ARN) format for the source
  Amazon Web Services Region. For example, if you are creating an encrypted read replica from
  a DB instance in the us-west-2 Amazon Web Services Region, then your
  SourceDBInstanceIdentifier looks like the following example:
  arn:aws:rds:us-west-2:123456789012:instance:mysql-instance1-20161115.   To learn how to
  generate a Signature Version 4 signed request, see Authenticating Requests: Using Query
  Parameters (Amazon Web Services Signature Version 4) and Signature Version 4 Signing
  Process.  If you are using an Amazon Web Services SDK tool or the CLI, you can specify
  SourceRegion (or --source-region for the CLI) instead of specifying PreSignedUrl manually.
  Specifying SourceRegion autogenerates a presigned URL that is a valid request for the
  operation that can run in the source Amazon Web Services Region.  SourceRegion isn't
  supported for SQL Server, because Amazon RDS for SQL Server doesn't support cross-Region
  read replicas.  This setting doesn't apply to RDS Custom DB instances.If you supply a value
  for this operation's SourceRegion parameter, a pre-signed URL will be calculated on your
  behalf.
- `"ProcessorFeatures"`: The number of CPU cores and the number of threads per core for the
  DB instance class of the DB instance. This setting doesn't apply to RDS Custom DB instances.
- `"PubliclyAccessible"`: Specifies whether the DB instance is publicly accessible. When
  the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to
  the private IP address from within the DB cluster's virtual private cloud (VPC). It
  resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB
  cluster is ultimately controlled by the security group it uses. That public access isn't
  permitted if the security group assigned to the DB cluster doesn't permit it. When the DB
  instance isn't publicly accessible, it is an internal DB instance with a DNS name that
  resolves to a private IP address. For more information, see CreateDBInstance.
- `"ReplicaMode"`: The open mode of the replica database: mounted or read-only.  This
  parameter is only supported for Oracle DB instances.  Mounted DB replicas are included in
  Oracle Database Enterprise Edition. The main use case for mounted replicas is cross-Region
  disaster recovery. The primary database doesn't use Active Data Guard to transmit
  information to the mounted replica. Because it doesn't accept user connections, a mounted
  replica can't serve a read-only workload. You can create a combination of mounted and
  read-only DB replicas for the same primary DB instance. For more information, see Working
  with Oracle Read Replicas for Amazon RDS in the Amazon RDS User Guide. For RDS Custom, you
  must specify this parameter and set it to mounted. The value won't be set by default. After
  replica creation, you can manage the open mode manually.
- `"SourceDBClusterIdentifier"`: The identifier of the Multi-AZ DB cluster that will act as
  the source for the read replica. Each DB cluster can have up to 15 read replicas.
  Constraints:   Must be the identifier of an existing Multi-AZ DB cluster.   Can't be
  specified if the SourceDBInstanceIdentifier parameter is also specified.   The specified DB
  cluster must have automatic backups enabled, that is, its backup retention period must be
  greater than 0.   The source DB cluster must be in the same Amazon Web Services Region as
  the read replica. Cross-Region replication isn't supported.
- `"SourceDBInstanceIdentifier"`: The identifier of the DB instance that will act as the
  source for the read replica. Each DB instance can have up to 15 read replicas, with the
  exception of Oracle and SQL Server, which can have up to five. Constraints:   Must be the
  identifier of an existing Db2, MariaDB, MySQL, Oracle, PostgreSQL, or SQL Server DB
  instance.   Can't be specified if the SourceDBClusterIdentifier parameter is also
  specified.   For the limitations of Oracle read replicas, see Version and licensing
  considerations for RDS for Oracle replicas in the Amazon RDS User Guide.   For the
  limitations of SQL Server read replicas, see Read replica limitations with SQL Server in
  the Amazon RDS User Guide.   The specified DB instance must have automatic backups enabled,
  that is, its backup retention period must be greater than 0.   If the source DB instance is
  in the same Amazon Web Services Region as the read replica, specify a valid DB instance
  identifier.   If the source DB instance is in a different Amazon Web Services Region from
  the read replica, specify a valid DB instance ARN. For more information, see Constructing
  an ARN for Amazon RDS in the Amazon RDS User Guide. This doesn't apply to SQL Server or RDS
  Custom, which don't support cross-Region replicas.
- `"SourceRegion"`: The ID of the region that contains the source for the read replica.
- `"StorageThroughput"`: Specifies the storage throughput value for the read replica. This
  setting doesn't apply to RDS Custom or Amazon Aurora DB instances.
- `"StorageType"`: The storage type to associate with the read replica. If you specify io1,
  io2, or gp3, you must also include a value for the Iops parameter. Valid Values: gp2 | gp3
  | io1 | io2 | standard  Default: io1 if the Iops parameter is specified. Otherwise, gp2.
- `"Tags"`:
- `"UpgradeStorageConfig"`: Whether to upgrade the storage file system configuration on the
  read replica. This option migrates the read replica from the old storage file system layout
  to the preferred layout.
- `"UseDefaultProcessorFeatures"`: Specifies whether the DB instance class of the DB
  instance uses its default processor features. This setting doesn't apply to RDS Custom DB
  instances.
- `"VpcSecurityGroupIds"`: A list of Amazon EC2 VPC security groups to associate with the
  read replica. This setting doesn't apply to RDS Custom DB instances. Default: The default
  EC2 VPC security group for the DB subnet group's VPC.
"""
function create_dbinstance_read_replica(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "CreateDBInstanceReadReplica",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbinstance_read_replica(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBInstanceReadReplica",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbparameter_group(dbparameter_group_family, dbparameter_group_name, description)
    create_dbparameter_group(dbparameter_group_family, dbparameter_group_name, description, params::Dict{String,<:Any})

Creates a new DB parameter group. A DB parameter group is initially created with the
default parameters for the database engine used by the DB instance. To provide custom
values for any of the parameters, you must modify the group after creating it using
ModifyDBParameterGroup. Once you've created a DB parameter group, you need to associate it
with your DB instance using ModifyDBInstance. When you associate a new DB parameter group
with a running DB instance, you need to reboot the DB instance without failover for the new
DB parameter group and associated settings to take effect. This command doesn't apply to
RDS Custom.  After you create a DB parameter group, you should wait at least 5 minutes
before creating your first DB instance that uses that DB parameter group as the default
parameter group. This allows Amazon RDS to fully complete the create action before the
parameter group is used as the default for a new DB instance. This is especially important
for parameters that are critical when creating the default database for a DB instance, such
as the character set for the default database defined by the character_set_database
parameter. You can use the Parameter Groups option of the Amazon RDS console or the
DescribeDBParameters command to verify that your DB parameter group has been created or
modified.

# Arguments
- `dbparameter_group_family`: The DB parameter group family name. A DB parameter group can
  be associated with one and only one DB parameter group family, and can be applied only to a
  DB instance running a database engine and engine version compatible with that DB parameter
  group family. To list all of the available parameter group families for a DB engine, use
  the following command:  aws rds describe-db-engine-versions --query
  \"DBEngineVersions[].DBParameterGroupFamily\" --engine &lt;engine&gt;  For example, to list
  all of the available parameter group families for the MySQL DB engine, use the following
  command:  aws rds describe-db-engine-versions --query
  \"DBEngineVersions[].DBParameterGroupFamily\" --engine mysql   The output contains
  duplicates.  The following are the valid DB engine values:    aurora-mysql
  aurora-postgresql     db2-ae     db2-se     mysql     oracle-ee     oracle-ee-cdb
  oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se
  sqlserver-ex     sqlserver-web
- `dbparameter_group_name`: The name of the DB parameter group. Constraints:   Must be 1 to
  255 letters, numbers, or hyphens.   First character must be a letter   Can't end with a
  hyphen or contain two consecutive hyphens    This value is stored as a lowercase string.
- `description`: The description for the DB parameter group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: Tags to assign to the DB parameter group.
"""
function create_dbparameter_group(
    DBParameterGroupFamily,
    DBParameterGroupName,
    Description;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBParameterGroup",
        Dict{String,Any}(
            "DBParameterGroupFamily" => DBParameterGroupFamily,
            "DBParameterGroupName" => DBParameterGroupName,
            "Description" => Description,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbparameter_group(
    DBParameterGroupFamily,
    DBParameterGroupName,
    Description,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBParameterGroupFamily" => DBParameterGroupFamily,
                    "DBParameterGroupName" => DBParameterGroupName,
                    "Description" => Description,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbproxy(auth, dbproxy_name, engine_family, role_arn, vpc_subnet_ids)
    create_dbproxy(auth, dbproxy_name, engine_family, role_arn, vpc_subnet_ids, params::Dict{String,<:Any})

Creates a new DB proxy.

# Arguments
- `auth`: The authorization mechanism that the proxy uses.
- `dbproxy_name`: The identifier for the proxy. This name must be unique for all proxies
  owned by your Amazon Web Services account in the specified Amazon Web Services Region. An
  identifier must begin with a letter and must contain only ASCII letters, digits, and
  hyphens; it can't end with a hyphen or contain two consecutive hyphens.
- `engine_family`: The kinds of databases that the proxy can connect to. This value
  determines which database network protocol the proxy recognizes when it interprets network
  traffic to and from the database. For Aurora MySQL, RDS for MariaDB, and RDS for MySQL
  databases, specify MYSQL. For Aurora PostgreSQL and RDS for PostgreSQL databases, specify
  POSTGRESQL. For RDS for Microsoft SQL Server, specify SQLSERVER.
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access
  secrets in Amazon Web Services Secrets Manager.
- `vpc_subnet_ids`: One or more VPC subnet IDs to associate with the new proxy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DebugLogging"`: Specifies whether the proxy includes detailed information about SQL
  statements in its logs. This information helps you to debug issues involving SQL behavior
  or the performance and scalability of the proxy connections. The debug information includes
  the text of SQL statements that you submit through the proxy. Thus, only enable this
  setting when needed for debugging, and only when you have security measures in place to
  safeguard any sensitive information that appears in the logs.
- `"IdleClientTimeout"`: The number of seconds that a connection to the proxy can be
  inactive before the proxy disconnects it. You can set this value higher or lower than the
  connection timeout limit for the associated database.
- `"RequireTLS"`: Specifies whether Transport Layer Security (TLS) encryption is required
  for connections to the proxy. By enabling this setting, you can enforce encrypted TLS
  connections to the proxy.
- `"Tags"`: An optional set of key-value pairs to associate arbitrary data of your choosing
  with the proxy.
- `"VpcSecurityGroupIds"`: One or more VPC security group IDs to associate with the new
  proxy.
"""
function create_dbproxy(
    Auth,
    DBProxyName,
    EngineFamily,
    RoleArn,
    VpcSubnetIds;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBProxy",
        Dict{String,Any}(
            "Auth" => Auth,
            "DBProxyName" => DBProxyName,
            "EngineFamily" => EngineFamily,
            "RoleArn" => RoleArn,
            "VpcSubnetIds" => VpcSubnetIds,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbproxy(
    Auth,
    DBProxyName,
    EngineFamily,
    RoleArn,
    VpcSubnetIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBProxy",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "Auth" => Auth,
                    "DBProxyName" => DBProxyName,
                    "EngineFamily" => EngineFamily,
                    "RoleArn" => RoleArn,
                    "VpcSubnetIds" => VpcSubnetIds,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbproxy_endpoint(dbproxy_endpoint_name, dbproxy_name, vpc_subnet_ids)
    create_dbproxy_endpoint(dbproxy_endpoint_name, dbproxy_name, vpc_subnet_ids, params::Dict{String,<:Any})

Creates a DBProxyEndpoint. Only applies to proxies that are associated with Aurora DB
clusters. You can use DB proxy endpoints to specify read/write or read-only access to the
DB cluster. You can also use DB proxy endpoints to access a DB proxy through a different
VPC than the proxy's default VPC.

# Arguments
- `dbproxy_endpoint_name`: The name of the DB proxy endpoint to create.
- `dbproxy_name`: The name of the DB proxy associated with the DB proxy endpoint that you
  create.
- `vpc_subnet_ids`: The VPC subnet IDs for the DB proxy endpoint that you create. You can
  specify a different set of subnet IDs than for the original DB proxy.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
- `"TargetRole"`: The role of the DB proxy endpoint. The role determines whether the
  endpoint can be used for read/write or only read operations. The default is READ_WRITE. The
  only role that proxies for RDS for Microsoft SQL Server support is READ_WRITE.
- `"VpcSecurityGroupIds"`: The VPC security group IDs for the DB proxy endpoint that you
  create. You can specify a different set of security group IDs than for the original DB
  proxy. The default is the default security group for the VPC.
"""
function create_dbproxy_endpoint(
    DBProxyEndpointName,
    DBProxyName,
    VpcSubnetIds;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBProxyEndpoint",
        Dict{String,Any}(
            "DBProxyEndpointName" => DBProxyEndpointName,
            "DBProxyName" => DBProxyName,
            "VpcSubnetIds" => VpcSubnetIds,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbproxy_endpoint(
    DBProxyEndpointName,
    DBProxyName,
    VpcSubnetIds,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBProxyEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBProxyEndpointName" => DBProxyEndpointName,
                    "DBProxyName" => DBProxyName,
                    "VpcSubnetIds" => VpcSubnetIds,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbsecurity_group(dbsecurity_group_description, dbsecurity_group_name)
    create_dbsecurity_group(dbsecurity_group_description, dbsecurity_group_name, params::Dict{String,<:Any})

Creates a new DB security group. DB security groups control access to a DB instance. A DB
security group controls access to EC2-Classic DB instances that are not in a VPC.
EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a
VPC, we recommend that you migrate as soon as possible. For more information, see Migrate
from EC2-Classic to a VPC in the Amazon EC2 User Guide, the blog EC2-Classic Networking is
Retiring – Here’s How to Prepare, and Moving a DB instance not in a VPC into a VPC in
the Amazon RDS User Guide.

# Arguments
- `dbsecurity_group_description`: The description for the DB security group.
- `dbsecurity_group_name`: The name for the DB security group. This value is stored as a
  lowercase string. Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   First
  character must be a letter   Can't end with a hyphen or contain two consecutive hyphens
  Must not be \"Default\"   Example: mysecuritygroup

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: Tags to assign to the DB security group.
"""
function create_dbsecurity_group(
    DBSecurityGroupDescription,
    DBSecurityGroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBSecurityGroup",
        Dict{String,Any}(
            "DBSecurityGroupDescription" => DBSecurityGroupDescription,
            "DBSecurityGroupName" => DBSecurityGroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbsecurity_group(
    DBSecurityGroupDescription,
    DBSecurityGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBSecurityGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBSecurityGroupDescription" => DBSecurityGroupDescription,
                    "DBSecurityGroupName" => DBSecurityGroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbshard_group(dbcluster_identifier, dbshard_group_identifier, max_acu)
    create_dbshard_group(dbcluster_identifier, dbshard_group_identifier, max_acu, params::Dict{String,<:Any})

Creates a new DB shard group for Aurora Limitless Database. You must enable Aurora
Limitless Database to create a DB shard group. Valid for: Aurora DB clusters only

# Arguments
- `dbcluster_identifier`: The name of the primary DB cluster for the DB shard group.
- `dbshard_group_identifier`: The name of the DB shard group.
- `max_acu`: The maximum capacity of the DB shard group in Aurora capacity units (ACUs).

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ComputeRedundancy"`: Specifies whether to create standby instances for the DB shard
  group. Valid values are the following:   0 - Creates a single, primary DB instance for each
  physical shard. This is the default value, and the only one supported for the preview.   1
  - Creates a primary DB instance and a standby instance in a different Availability Zone
  (AZ) for each physical shard.   2 - Creates a primary DB instance and two standby instances
  in different AZs for each physical shard.
- `"PubliclyAccessible"`: Specifies whether the DB shard group is publicly accessible. When
  the DB shard group is publicly accessible, its Domain Name System (DNS) endpoint resolves
  to the private IP address from within the DB shard group's virtual private cloud (VPC). It
  resolves to the public IP address from outside of the DB shard group's VPC. Access to the
  DB shard group is ultimately controlled by the security group it uses. That public access
  is not permitted if the security group assigned to the DB shard group doesn't permit it.
  When the DB shard group isn't publicly accessible, it is an internal DB shard group with a
  DNS name that resolves to a private IP address. Default: The default behavior varies
  depending on whether DBSubnetGroupName is specified. If DBSubnetGroupName isn't specified,
  and PubliclyAccessible isn't specified, the following applies:   If the default VPC in the
  target Region doesn’t have an internet gateway attached to it, the DB shard group is
  private.   If the default VPC in the target Region has an internet gateway attached to it,
  the DB shard group is public.   If DBSubnetGroupName is specified, and PubliclyAccessible
  isn't specified, the following applies:   If the subnets are part of a VPC that doesn’t
  have an internet gateway attached to it, the DB shard group is private.   If the subnets
  are part of a VPC that has an internet gateway attached to it, the DB shard group is
  public.
"""
function create_dbshard_group(
    DBClusterIdentifier,
    DBShardGroupIdentifier,
    MaxACU;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBShardGroup",
        Dict{String,Any}(
            "DBClusterIdentifier" => DBClusterIdentifier,
            "DBShardGroupIdentifier" => DBShardGroupIdentifier,
            "MaxACU" => MaxACU,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbshard_group(
    DBClusterIdentifier,
    DBShardGroupIdentifier,
    MaxACU,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBShardGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterIdentifier" => DBClusterIdentifier,
                    "DBShardGroupIdentifier" => DBShardGroupIdentifier,
                    "MaxACU" => MaxACU,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbsnapshot(dbinstance_identifier, dbsnapshot_identifier)
    create_dbsnapshot(dbinstance_identifier, dbsnapshot_identifier, params::Dict{String,<:Any})

Creates a snapshot of a DB instance. The source DB instance must be in the available or
storage-optimization state.

# Arguments
- `dbinstance_identifier`: The identifier of the DB instance that you want to create the
  snapshot of. Constraints:   Must match the identifier of an existing DBInstance.
- `dbsnapshot_identifier`: The identifier for the DB snapshot. Constraints:   Can't be
  null, empty, or blank   Must contain from 1 to 255 letters, numbers, or hyphens   First
  character must be a letter   Can't end with a hyphen or contain two consecutive hyphens
  Example: my-snapshot-id

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`:
"""
function create_dbsnapshot(
    DBInstanceIdentifier,
    DBSnapshotIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBSnapshot",
        Dict{String,Any}(
            "DBInstanceIdentifier" => DBInstanceIdentifier,
            "DBSnapshotIdentifier" => DBSnapshotIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbsnapshot(
    DBInstanceIdentifier,
    DBSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "DBSnapshotIdentifier" => DBSnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_dbsubnet_group(dbsubnet_group_description, dbsubnet_group_name, subnet_identifier)
    create_dbsubnet_group(dbsubnet_group_description, dbsubnet_group_name, subnet_identifier, params::Dict{String,<:Any})

Creates a new DB subnet group. DB subnet groups must contain at least one subnet in at
least two AZs in the Amazon Web Services Region.

# Arguments
- `dbsubnet_group_description`: The description for the DB subnet group.
- `dbsubnet_group_name`: The name for the DB subnet group. This value is stored as a
  lowercase string. Constraints:   Must contain no more than 255 letters, numbers, periods,
  underscores, spaces, or hyphens.   Must not be default.   First character must be a letter.
    Example: mydbsubnetgroup
- `subnet_identifier`: The EC2 Subnet IDs for the DB subnet group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SubnetIds"`: The EC2 Subnet IDs for the DB subnet group.
- `"Tags"`: Tags to assign to the DB subnet group.
"""
function create_dbsubnet_group(
    DBSubnetGroupDescription,
    DBSubnetGroupName,
    SubnetIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBSubnetGroup",
        Dict{String,Any}(
            "DBSubnetGroupDescription" => DBSubnetGroupDescription,
            "DBSubnetGroupName" => DBSubnetGroupName,
            "SubnetIdentifier" => SubnetIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_dbsubnet_group(
    DBSubnetGroupDescription,
    DBSubnetGroupName,
    SubnetIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateDBSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBSubnetGroupDescription" => DBSubnetGroupDescription,
                    "DBSubnetGroupName" => DBSubnetGroupName,
                    "SubnetIdentifier" => SubnetIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_event_subscription(sns_topic_arn, subscription_name)
    create_event_subscription(sns_topic_arn, subscription_name, params::Dict{String,<:Any})

Creates an RDS event notification subscription. This operation requires a topic Amazon
Resource Name (ARN) created by either the RDS console, the SNS console, or the SNS API. To
obtain an ARN with SNS, you must create a topic in Amazon SNS and subscribe to the topic.
The ARN is displayed in the SNS console. You can specify the type of source (SourceType)
that you want to be notified of and provide a list of RDS sources (SourceIds) that triggers
the events. You can also provide a list of event categories (EventCategories) for events
that you want to be notified of. For example, you can specify SourceType = db-instance,
SourceIds = mydbinstance1, mydbinstance2 and EventCategories = Availability, Backup. If you
specify both the SourceType and SourceIds, such as SourceType = db-instance and SourceIds =
myDBInstance1, you are notified of all the db-instance events for the specified source. If
you specify a SourceType but do not specify SourceIds, you receive notice of the events for
that source type for all your RDS sources. If you don't specify either the SourceType or
the SourceIds, you are notified of events generated from all RDS sources belonging to your
customer account. For more information about subscribing to an event for RDS DB engines,
see  Subscribing to Amazon RDS event notification in the Amazon RDS User Guide. For more
information about subscribing to an event for Aurora DB engines, see  Subscribing to Amazon
RDS event notification in the Amazon Aurora User Guide.

# Arguments
- `sns_topic_arn`: The Amazon Resource Name (ARN) of the SNS topic created for event
  notification. SNS automatically creates the ARN when you create a topic and subscribe to
  it.  RDS doesn't support FIFO (first in, first out) topics. For more information, see
  Message ordering and deduplication (FIFO topics) in the Amazon Simple Notification Service
  Developer Guide.
- `subscription_name`: The name of the subscription. Constraints: The name must be less
  than 255 characters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Enabled"`: Specifies whether to activate the subscription. If the event notification
  subscription isn't activated, the subscription is created but not active.
- `"EventCategories"`: A list of event categories for a particular source type (SourceType)
  that you want to subscribe to. You can see a list of the categories for a given source type
  in the \"Amazon RDS event categories and event messages\" section of the  Amazon RDS User
  Guide  or the  Amazon Aurora User Guide . You can also see this list by using the
  DescribeEventCategories operation.
- `"SourceIds"`: The list of identifiers of the event sources for which events are
  returned. If not specified, then all sources are included in the response. An identifier
  must begin with a letter and must contain only ASCII letters, digits, and hyphens. It can't
  end with a hyphen or contain two consecutive hyphens. Constraints:   If SourceIds are
  supplied, SourceType must also be provided.   If the source type is a DB instance, a
  DBInstanceIdentifier value must be supplied.   If the source type is a DB cluster, a
  DBClusterIdentifier value must be supplied.   If the source type is a DB parameter group, a
  DBParameterGroupName value must be supplied.   If the source type is a DB security group, a
  DBSecurityGroupName value must be supplied.   If the source type is a DB snapshot, a
  DBSnapshotIdentifier value must be supplied.   If the source type is a DB cluster snapshot,
  a DBClusterSnapshotIdentifier value must be supplied.   If the source type is an RDS Proxy,
  a DBProxyName value must be supplied.
- `"SourceType"`: The type of source that is generating the events. For example, if you
  want to be notified of events generated by a DB instance, you set this parameter to
  db-instance. For RDS Proxy events, specify db-proxy. If this value isn't specified, all
  events are returned. Valid Values: db-instance | db-cluster | db-parameter-group |
  db-security-group | db-snapshot | db-cluster-snapshot | db-proxy | zero-etl |
  custom-engine-version | blue-green-deployment
- `"Tags"`:
"""
function create_event_subscription(
    SnsTopicArn, SubscriptionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "CreateEventSubscription",
        Dict{String,Any}(
            "SnsTopicArn" => SnsTopicArn, "SubscriptionName" => SubscriptionName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_event_subscription(
    SnsTopicArn,
    SubscriptionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateEventSubscription",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SnsTopicArn" => SnsTopicArn, "SubscriptionName" => SubscriptionName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_global_cluster()
    create_global_cluster(params::Dict{String,<:Any})

Creates an Aurora global database spread across multiple Amazon Web Services Regions. The
global database contains a single primary cluster with read-write capability, and a
read-only secondary cluster that receives data from the primary cluster through high-speed
replication performed by the Aurora storage subsystem. You can create a global database
that is initially empty, and then create the primary and secondary DB clusters in the
global database. Or you can specify an existing Aurora cluster during the create operation,
and this cluster becomes the primary cluster of the global database.  This operation
applies only to Aurora DB clusters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DatabaseName"`: The name for your database of up to 64 alphanumeric characters. If you
  don't specify a name, Amazon Aurora doesn't create a database in the global database
  cluster. Constraints:   Can't be specified if SourceDBClusterIdentifier is specified. In
  this case, Amazon Aurora uses the database name from the source DB cluster.
- `"DeletionProtection"`: Specifies whether to enable deletion protection for the new
  global database cluster. The global database can't be deleted when deletion protection is
  enabled.
- `"Engine"`: The database engine to use for this global database cluster. Valid Values:
  aurora-mysql | aurora-postgresql  Constraints:   Can't be specified if
  SourceDBClusterIdentifier is specified. In this case, Amazon Aurora uses the engine of the
  source DB cluster.
- `"EngineLifecycleSupport"`: The life cycle type for this global database cluster.  By
  default, this value is set to open-source-rds-extended-support, which enrolls your global
  cluster into Amazon RDS Extended Support. At the end of standard support, you can avoid
  charges for Extended Support by setting the value to
  open-source-rds-extended-support-disabled. In this case, creating the global cluster will
  fail if the DB major version is past its end of standard support date.  This setting only
  applies to Aurora PostgreSQL-based global databases. You can use this setting to enroll
  your global cluster into Amazon RDS Extended Support. With RDS Extended Support, you can
  run the selected major engine version on your global cluster past the end of standard
  support for that engine version. For more information, see Using Amazon RDS Extended
  Support in the Amazon Aurora User Guide. Valid Values: open-source-rds-extended-support |
  open-source-rds-extended-support-disabled  Default: open-source-rds-extended-support
- `"EngineVersion"`: The engine version to use for this global database cluster.
  Constraints:   Can't be specified if SourceDBClusterIdentifier is specified. In this case,
  Amazon Aurora uses the engine version of the source DB cluster.
- `"GlobalClusterIdentifier"`: The cluster identifier for this global database cluster.
  This parameter is stored as a lowercase string.
- `"SourceDBClusterIdentifier"`: The Amazon Resource Name (ARN) to use as the primary
  cluster of the global database. If you provide a value for this parameter, don't specify
  values for the following settings because Amazon Aurora uses the values from the specified
  source DB cluster:    DatabaseName     Engine     EngineVersion     StorageEncrypted
- `"StorageEncrypted"`: Specifies whether to enable storage encryption for the new global
  database cluster. Constraints:   Can't be specified if SourceDBClusterIdentifier is
  specified. In this case, Amazon Aurora uses the setting from the source DB cluster.
"""
function create_global_cluster(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "CreateGlobalCluster"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function create_global_cluster(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "CreateGlobalCluster",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_integration(integration_name, source_arn, target_arn)
    create_integration(integration_name, source_arn, target_arn, params::Dict{String,<:Any})

Creates a zero-ETL integration with Amazon Redshift.

# Arguments
- `integration_name`: The name of the integration.
- `source_arn`: The Amazon Resource Name (ARN) of the database to use as the source for
  replication.
- `target_arn`: The ARN of the Redshift data warehouse to use as the target for replication.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AdditionalEncryptionContext"`: An optional set of non-secret key–value pairs that
  contains additional contextual information about the data. For more information, see
  Encryption context in the Amazon Web Services Key Management Service Developer Guide. You
  can only include this parameter if you specify the KMSKeyId parameter.
- `"DataFilter"`: Data filtering options for the integration. For more information, see
  Data filtering for Aurora zero-ETL integrations with Amazon Redshift.  Valid for:
  Integrations with Aurora MySQL source DB clusters only
- `"Description"`: A description of the integration.
- `"KMSKeyId"`: The Amazon Web Services Key Management System (Amazon Web Services KMS) key
  identifier for the key to use to encrypt the integration. If you don't specify an
  encryption key, RDS uses a default Amazon Web Services owned key.
- `"Tags"`:
"""
function create_integration(
    IntegrationName,
    SourceArn,
    TargetArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateIntegration",
        Dict{String,Any}(
            "IntegrationName" => IntegrationName,
            "SourceArn" => SourceArn,
            "TargetArn" => TargetArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_integration(
    IntegrationName,
    SourceArn,
    TargetArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateIntegration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "IntegrationName" => IntegrationName,
                    "SourceArn" => SourceArn,
                    "TargetArn" => TargetArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_option_group(engine_name, major_engine_version, option_group_description, option_group_name)
    create_option_group(engine_name, major_engine_version, option_group_description, option_group_name, params::Dict{String,<:Any})

Creates a new option group. You can create up to 20 option groups. This command doesn't
apply to RDS Custom.

# Arguments
- `engine_name`: The name of the engine to associate this option group with. Valid Values:
    db2-ae     db2-se     mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2
   oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se     sqlserver-ex
  sqlserver-web
- `major_engine_version`: Specifies the major version of the engine that this option group
  should be associated with.
- `option_group_description`: The description of the option group.
- `option_group_name`: Specifies the name of the option group to be created. Constraints:
  Must be 1 to 255 letters, numbers, or hyphens   First character must be a letter   Can't
  end with a hyphen or contain two consecutive hyphens   Example: myoptiongroup

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Tags"`: Tags to assign to the option group.
"""
function create_option_group(
    EngineName,
    MajorEngineVersion,
    OptionGroupDescription,
    OptionGroupName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateOptionGroup",
        Dict{String,Any}(
            "EngineName" => EngineName,
            "MajorEngineVersion" => MajorEngineVersion,
            "OptionGroupDescription" => OptionGroupDescription,
            "OptionGroupName" => OptionGroupName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_option_group(
    EngineName,
    MajorEngineVersion,
    OptionGroupDescription,
    OptionGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateOptionGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "EngineName" => EngineName,
                    "MajorEngineVersion" => MajorEngineVersion,
                    "OptionGroupDescription" => OptionGroupDescription,
                    "OptionGroupName" => OptionGroupName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_tenant_database(dbinstance_identifier, master_user_password, master_username, tenant_dbname)
    create_tenant_database(dbinstance_identifier, master_user_password, master_username, tenant_dbname, params::Dict{String,<:Any})

Creates a tenant database in a DB instance that uses the multi-tenant configuration. Only
RDS for Oracle container database (CDB) instances are supported.

# Arguments
- `dbinstance_identifier`: The user-supplied DB instance identifier. RDS creates your
  tenant database in this DB instance. This parameter isn't case-sensitive.
- `master_user_password`: The password for the master user in your tenant database.
  Constraints:   Must be 8 to 30 characters.   Can include any printable ASCII character
  except forward slash (/), double quote (\"), at symbol (@), ampersand (&amp;), or single
  quote (').
- `master_username`: The name for the master user account in your tenant database. RDS
  creates this user account in the tenant database and grants privileges to the master user.
  This parameter is case-sensitive. Constraints:   Must be 1 to 16 letters, numbers, or
  underscores.   First character must be a letter.   Can't be a reserved word for the chosen
  database engine.
- `tenant_dbname`: The user-supplied name of the tenant database that you want to create in
  your DB instance. This parameter has the same constraints as DBName in CreateDBInstance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CharacterSetName"`: The character set for your tenant database. If you don't specify a
  value, the character set name defaults to AL32UTF8.
- `"NcharCharacterSetName"`: The NCHAR value for the tenant database.
- `"Tags"`:
"""
function create_tenant_database(
    DBInstanceIdentifier,
    MasterUserPassword,
    MasterUsername,
    TenantDBName;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateTenantDatabase",
        Dict{String,Any}(
            "DBInstanceIdentifier" => DBInstanceIdentifier,
            "MasterUserPassword" => MasterUserPassword,
            "MasterUsername" => MasterUsername,
            "TenantDBName" => TenantDBName,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_tenant_database(
    DBInstanceIdentifier,
    MasterUserPassword,
    MasterUsername,
    TenantDBName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "CreateTenantDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "MasterUserPassword" => MasterUserPassword,
                    "MasterUsername" => MasterUsername,
                    "TenantDBName" => TenantDBName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_blue_green_deployment(blue_green_deployment_identifier)
    delete_blue_green_deployment(blue_green_deployment_identifier, params::Dict{String,<:Any})

Deletes a blue/green deployment. For more information, see Using Amazon RDS Blue/Green
Deployments for database updates in the Amazon RDS User Guide and Using Amazon RDS
Blue/Green Deployments for database updates in the Amazon Aurora User Guide.

# Arguments
- `blue_green_deployment_identifier`: The unique identifier of the blue/green deployment to
  delete. This parameter isn't case-sensitive. Constraints:    Must match an existing
  blue/green deployment identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeleteTarget"`: Specifies whether to delete the resources in the green environment. You
  can't specify this option if the blue/green deployment status is SWITCHOVER_COMPLETED.
"""
function delete_blue_green_deployment(
    BlueGreenDeploymentIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteBlueGreenDeployment",
        Dict{String,Any}("BlueGreenDeploymentIdentifier" => BlueGreenDeploymentIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_blue_green_deployment(
    BlueGreenDeploymentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteBlueGreenDeployment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BlueGreenDeploymentIdentifier" => BlueGreenDeploymentIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_custom_dbengine_version(engine, engine_version)
    delete_custom_dbengine_version(engine, engine_version, params::Dict{String,<:Any})

Deletes a custom engine version. To run this command, make sure you meet the following
prerequisites:   The CEV must not be the default for RDS Custom. If it is, change the
default before running this command.   The CEV must not be associated with an RDS Custom DB
instance, RDS Custom instance snapshot, or automated backup of your RDS Custom instance.
Typically, deletion takes a few minutes.  The MediaImport service that imports files from
Amazon S3 to create CEVs isn't integrated with Amazon Web Services CloudTrail. If you turn
on data logging for Amazon RDS in CloudTrail, calls to the DeleteCustomDbEngineVersion
event aren't logged. However, you might see calls from the API gateway that accesses your
Amazon S3 bucket. These calls originate from the MediaImport service for the
DeleteCustomDbEngineVersion event.  For more information, see Deleting a CEV in the Amazon
RDS User Guide.

# Arguments
- `engine`: The database engine. RDS Custom for Oracle supports the following values:
  custom-oracle-ee     custom-oracle-ee-cdb     custom-oracle-se2     custom-oracle-se2-cdb
- `engine_version`: The custom engine version (CEV) for your DB instance. This option is
  required for RDS Custom, but optional for Amazon RDS. The combination of Engine and
  EngineVersion is unique per customer per Amazon Web Services Region.

"""
function delete_custom_dbengine_version(
    Engine, EngineVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteCustomDBEngineVersion",
        Dict{String,Any}("Engine" => Engine, "EngineVersion" => EngineVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_custom_dbengine_version(
    Engine,
    EngineVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteCustomDBEngineVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Engine" => Engine, "EngineVersion" => EngineVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbcluster(dbcluster_identifier)
    delete_dbcluster(dbcluster_identifier, params::Dict{String,<:Any})

The DeleteDBCluster action deletes a previously provisioned DB cluster. When you delete a
DB cluster, all automated backups for that DB cluster are deleted and can't be recovered.
Manual DB cluster snapshots of the specified DB cluster are not deleted. If you're deleting
a Multi-AZ DB cluster with read replicas, all cluster members are terminated and read
replicas are promoted to standalone instances. For more information on Amazon Aurora, see
What is Amazon Aurora? in the Amazon Aurora User Guide. For more information on Multi-AZ DB
clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The DB cluster identifier for the DB cluster to be deleted. This
  parameter isn't case-sensitive. Constraints:   Must match an existing DBClusterIdentifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeleteAutomatedBackups"`: Specifies whether to remove automated backups immediately
  after the DB cluster is deleted. This parameter isn't case-sensitive. The default is to
  remove automated backups immediately after the DB cluster is deleted.
- `"FinalDBSnapshotIdentifier"`: The DB cluster snapshot identifier of the new DB cluster
  snapshot created when SkipFinalSnapshot is disabled.  Specifying this parameter and also
  skipping the creation of a final DB cluster snapshot with the SkipFinalShapshot parameter
  results in an error.  Constraints:   Must be 1 to 255 letters, numbers, or hyphens.   First
  character must be a letter   Can't end with a hyphen or contain two consecutive hyphens
- `"SkipFinalSnapshot"`: Specifies whether to skip the creation of a final DB cluster
  snapshot before the DB cluster is deleted. If skip is specified, no DB cluster snapshot is
  created. If skip isn't specified, a DB cluster snapshot is created before the DB cluster is
  deleted. By default, skip isn't specified, and the DB cluster snapshot is created. By
  default, this parameter is disabled.  You must specify a FinalDBSnapshotIdentifier
  parameter if SkipFinalSnapshot is disabled.
"""
function delete_dbcluster(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBCluster",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbcluster(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbcluster_automated_backup(db_cluster_resource_id)
    delete_dbcluster_automated_backup(db_cluster_resource_id, params::Dict{String,<:Any})

Deletes automated backups using the DbClusterResourceId value of the source DB cluster or
the Amazon Resource Name (ARN) of the automated backups.

# Arguments
- `db_cluster_resource_id`: The identifier for the source DB cluster, which can't be
  changed and which is unique to an Amazon Web Services Region.

"""
function delete_dbcluster_automated_backup(
    DbClusterResourceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBClusterAutomatedBackup",
        Dict{String,Any}("DbClusterResourceId" => DbClusterResourceId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbcluster_automated_backup(
    DbClusterResourceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBClusterAutomatedBackup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DbClusterResourceId" => DbClusterResourceId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbcluster_endpoint(dbcluster_endpoint_identifier)
    delete_dbcluster_endpoint(dbcluster_endpoint_identifier, params::Dict{String,<:Any})

Deletes a custom endpoint and removes it from an Amazon Aurora DB cluster.  This action
only applies to Aurora DB clusters.

# Arguments
- `dbcluster_endpoint_identifier`: The identifier associated with the custom endpoint. This
  parameter is stored as a lowercase string.

"""
function delete_dbcluster_endpoint(
    DBClusterEndpointIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBClusterEndpoint",
        Dict{String,Any}("DBClusterEndpointIdentifier" => DBClusterEndpointIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbcluster_endpoint(
    DBClusterEndpointIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBClusterEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterEndpointIdentifier" => DBClusterEndpointIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbcluster_parameter_group(dbcluster_parameter_group_name)
    delete_dbcluster_parameter_group(dbcluster_parameter_group_name, params::Dict{String,<:Any})

Deletes a specified DB cluster parameter group. The DB cluster parameter group to be
deleted can't be associated with any DB clusters. For more information on Amazon Aurora,
see  What is Amazon Aurora? in the Amazon Aurora User Guide. For more information on
Multi-AZ DB clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_parameter_group_name`: The name of the DB cluster parameter group.
  Constraints:   Must be the name of an existing DB cluster parameter group.   You can't
  delete a default DB cluster parameter group.   Can't be associated with any DB clusters.

"""
function delete_dbcluster_parameter_group(
    DBClusterParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBClusterParameterGroup",
        Dict{String,Any}("DBClusterParameterGroupName" => DBClusterParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbcluster_parameter_group(
    DBClusterParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterParameterGroupName" => DBClusterParameterGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbcluster_snapshot(dbcluster_snapshot_identifier)
    delete_dbcluster_snapshot(dbcluster_snapshot_identifier, params::Dict{String,<:Any})

Deletes a DB cluster snapshot. If the snapshot is being copied, the copy operation is
terminated.  The DB cluster snapshot must be in the available state to be deleted.  For
more information on Amazon Aurora, see  What is Amazon Aurora? in the Amazon Aurora User
Guide. For more information on Multi-AZ DB clusters, see  Multi-AZ DB cluster deployments
in the Amazon RDS User Guide.

# Arguments
- `dbcluster_snapshot_identifier`: The identifier of the DB cluster snapshot to delete.
  Constraints: Must be the name of an existing DB cluster snapshot in the available state.

"""
function delete_dbcluster_snapshot(
    DBClusterSnapshotIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBClusterSnapshot",
        Dict{String,Any}("DBClusterSnapshotIdentifier" => DBClusterSnapshotIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbcluster_snapshot(
    DBClusterSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBClusterSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterSnapshotIdentifier" => DBClusterSnapshotIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbinstance(dbinstance_identifier)
    delete_dbinstance(dbinstance_identifier, params::Dict{String,<:Any})

Deletes a previously provisioned DB instance. When you delete a DB instance, all automated
backups for that instance are deleted and can't be recovered. However, manual DB snapshots
of the DB instance aren't deleted. If you request a final DB snapshot, the status of the
Amazon RDS DB instance is deleting until the DB snapshot is created. This operation can't
be canceled or reverted after it begins. To monitor the status of this operation, use
DescribeDBInstance. When a DB instance is in a failure state and has a status of failed,
incompatible-restore, or incompatible-network, you can only delete it when you skip
creation of the final snapshot with the SkipFinalSnapshot parameter. If the specified DB
instance is part of an Amazon Aurora DB cluster, you can't delete the DB instance if both
of the following conditions are true:   The DB cluster is a read replica of another Amazon
Aurora DB cluster.   The DB instance is the only instance in the DB cluster.   To delete a
DB instance in this case, first use the PromoteReadReplicaDBCluster operation to promote
the DB cluster so that it's no longer a read replica. After the promotion completes, use
the DeleteDBInstance operation to delete the final instance in the DB cluster.  For RDS
Custom DB instances, deleting the DB instance permanently deletes the EC2 instance and the
associated EBS volumes. Make sure that you don't terminate or delete these resources before
you delete the DB instance. Otherwise, deleting the DB instance and creation of the final
snapshot might fail.

# Arguments
- `dbinstance_identifier`: The DB instance identifier for the DB instance to be deleted.
  This parameter isn't case-sensitive. Constraints:   Must match the name of an existing DB
  instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DeleteAutomatedBackups"`: Specifies whether to remove automated backups immediately
  after the DB instance is deleted. This parameter isn't case-sensitive. The default is to
  remove automated backups immediately after the DB instance is deleted.
- `"FinalDBSnapshotIdentifier"`: The DBSnapshotIdentifier of the new DBSnapshot created
  when the SkipFinalSnapshot parameter is disabled.  If you enable this parameter and also
  enable SkipFinalShapshot, the command results in an error.  This setting doesn't apply to
  RDS Custom. Constraints:   Must be 1 to 255 letters or numbers.   First character must be a
  letter.   Can't end with a hyphen or contain two consecutive hyphens.   Can't be specified
  when deleting a read replica.
- `"SkipFinalSnapshot"`: Specifies whether to skip the creation of a final DB snapshot
  before deleting the instance. If you enable this parameter, RDS doesn't create a DB
  snapshot. If you don't enable this parameter, RDS creates a DB snapshot before the DB
  instance is deleted. By default, skip isn't enabled, and the DB snapshot is created.  If
  you don't enable this parameter, you must specify the FinalDBSnapshotIdentifier parameter.
  When a DB instance is in a failure state and has a status of failed, incompatible-restore,
  or incompatible-network, RDS can delete the instance only if you enable this parameter. If
  you delete a read replica or an RDS Custom instance, you must enable this setting. This
  setting is required for RDS Custom.
"""
function delete_dbinstance(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBInstance",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbinstance(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbinstance_automated_backup()
    delete_dbinstance_automated_backup(params::Dict{String,<:Any})

Deletes automated backups using the DbiResourceId value of the source DB instance or the
Amazon Resource Name (ARN) of the automated backups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceAutomatedBackupsArn"`: The Amazon Resource Name (ARN) of the automated
  backups to delete, for example,
  arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE. This setting
  doesn't apply to RDS Custom.
- `"DbiResourceId"`: The identifier for the source DB instance, which can't be changed and
  which is unique to an Amazon Web Services Region.
"""
function delete_dbinstance_automated_backup(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBInstanceAutomatedBackup";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbinstance_automated_backup(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBInstanceAutomatedBackup",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbparameter_group(dbparameter_group_name)
    delete_dbparameter_group(dbparameter_group_name, params::Dict{String,<:Any})

Deletes a specified DB parameter group. The DB parameter group to be deleted can't be
associated with any DB instances.

# Arguments
- `dbparameter_group_name`: The name of the DB parameter group. Constraints:   Must be the
  name of an existing DB parameter group   You can't delete a default DB parameter group
  Can't be associated with any DB instances

"""
function delete_dbparameter_group(
    DBParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBParameterGroup",
        Dict{String,Any}("DBParameterGroupName" => DBParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbparameter_group(
    DBParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBParameterGroupName" => DBParameterGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbproxy(dbproxy_name)
    delete_dbproxy(dbproxy_name, params::Dict{String,<:Any})

Deletes an existing DB proxy.

# Arguments
- `dbproxy_name`: The name of the DB proxy to delete.

"""
function delete_dbproxy(DBProxyName; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DeleteDBProxy",
        Dict{String,Any}("DBProxyName" => DBProxyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbproxy(
    DBProxyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBProxy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DBProxyName" => DBProxyName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbproxy_endpoint(dbproxy_endpoint_name)
    delete_dbproxy_endpoint(dbproxy_endpoint_name, params::Dict{String,<:Any})

Deletes a DBProxyEndpoint. Doing so removes the ability to access the DB proxy using the
endpoint that you defined. The endpoint that you delete might have provided capabilities
such as read/write or read-only operations, or using a different VPC than the DB proxy's
default VPC.

# Arguments
- `dbproxy_endpoint_name`: The name of the DB proxy endpoint to delete.

"""
function delete_dbproxy_endpoint(
    DBProxyEndpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBProxyEndpoint",
        Dict{String,Any}("DBProxyEndpointName" => DBProxyEndpointName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbproxy_endpoint(
    DBProxyEndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBProxyEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBProxyEndpointName" => DBProxyEndpointName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbsecurity_group(dbsecurity_group_name)
    delete_dbsecurity_group(dbsecurity_group_name, params::Dict{String,<:Any})

Deletes a DB security group. The specified DB security group must not be associated with
any DB instances.  EC2-Classic was retired on August 15, 2022. If you haven't migrated from
EC2-Classic to a VPC, we recommend that you migrate as soon as possible. For more
information, see Migrate from EC2-Classic to a VPC in the Amazon EC2 User Guide, the blog
EC2-Classic Networking is Retiring – Here’s How to Prepare, and Moving a DB instance
not in a VPC into a VPC in the Amazon RDS User Guide.

# Arguments
- `dbsecurity_group_name`: The name of the DB security group to delete.  You can't delete
  the default DB security group.  Constraints:   Must be 1 to 255 letters, numbers, or
  hyphens.   First character must be a letter   Can't end with a hyphen or contain two
  consecutive hyphens   Must not be \"Default\"

"""
function delete_dbsecurity_group(
    DBSecurityGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBSecurityGroup",
        Dict{String,Any}("DBSecurityGroupName" => DBSecurityGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbsecurity_group(
    DBSecurityGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBSecurityGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBSecurityGroupName" => DBSecurityGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbshard_group(dbshard_group_identifier)
    delete_dbshard_group(dbshard_group_identifier, params::Dict{String,<:Any})

Deletes an Aurora Limitless Database DB shard group.

# Arguments
- `dbshard_group_identifier`: Teh name of the DB shard group to delete.

"""
function delete_dbshard_group(
    DBShardGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBShardGroup",
        Dict{String,Any}("DBShardGroupIdentifier" => DBShardGroupIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbshard_group(
    DBShardGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBShardGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBShardGroupIdentifier" => DBShardGroupIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbsnapshot(dbsnapshot_identifier)
    delete_dbsnapshot(dbsnapshot_identifier, params::Dict{String,<:Any})

Deletes a DB snapshot. If the snapshot is being copied, the copy operation is terminated.
The DB snapshot must be in the available state to be deleted.

# Arguments
- `dbsnapshot_identifier`: The DB snapshot identifier. Constraints: Must be the name of an
  existing DB snapshot in the available state.

"""
function delete_dbsnapshot(
    DBSnapshotIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBSnapshot",
        Dict{String,Any}("DBSnapshotIdentifier" => DBSnapshotIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbsnapshot(
    DBSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBSnapshotIdentifier" => DBSnapshotIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_dbsubnet_group(dbsubnet_group_name)
    delete_dbsubnet_group(dbsubnet_group_name, params::Dict{String,<:Any})

Deletes a DB subnet group.  The specified database subnet group must not be associated with
any DB instances.

# Arguments
- `dbsubnet_group_name`: The name of the database subnet group to delete.  You can't delete
  the default subnet group.  Constraints: Must match the name of an existing DBSubnetGroup.
  Must not be default. Example: mydbsubnetgroup

"""
function delete_dbsubnet_group(
    DBSubnetGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteDBSubnetGroup",
        Dict{String,Any}("DBSubnetGroupName" => DBSubnetGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_dbsubnet_group(
    DBSubnetGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteDBSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("DBSubnetGroupName" => DBSubnetGroupName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_event_subscription(subscription_name)
    delete_event_subscription(subscription_name, params::Dict{String,<:Any})

Deletes an RDS event notification subscription.

# Arguments
- `subscription_name`: The name of the RDS event notification subscription you want to
  delete.

"""
function delete_event_subscription(
    SubscriptionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteEventSubscription",
        Dict{String,Any}("SubscriptionName" => SubscriptionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_event_subscription(
    SubscriptionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteEventSubscription",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SubscriptionName" => SubscriptionName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_global_cluster(global_cluster_identifier)
    delete_global_cluster(global_cluster_identifier, params::Dict{String,<:Any})

Deletes a global database cluster. The primary and secondary clusters must already be
detached or destroyed first.  This action only applies to Aurora DB clusters.

# Arguments
- `global_cluster_identifier`: The cluster identifier of the global database cluster being
  deleted.

"""
function delete_global_cluster(
    GlobalClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteGlobalCluster",
        Dict{String,Any}("GlobalClusterIdentifier" => GlobalClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_global_cluster(
    GlobalClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteGlobalCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("GlobalClusterIdentifier" => GlobalClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_integration(integration_identifier)
    delete_integration(integration_identifier, params::Dict{String,<:Any})

Deletes a zero-ETL integration with Amazon Redshift.

# Arguments
- `integration_identifier`: The unique identifier of the integration.

"""
function delete_integration(
    IntegrationIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteIntegration",
        Dict{String,Any}("IntegrationIdentifier" => IntegrationIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_integration(
    IntegrationIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteIntegration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IntegrationIdentifier" => IntegrationIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_option_group(option_group_name)
    delete_option_group(option_group_name, params::Dict{String,<:Any})

Deletes an existing option group.

# Arguments
- `option_group_name`: The name of the option group to be deleted.  You can't delete
  default option groups.

"""
function delete_option_group(
    OptionGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteOptionGroup",
        Dict{String,Any}("OptionGroupName" => OptionGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_option_group(
    OptionGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteOptionGroup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("OptionGroupName" => OptionGroupName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_tenant_database(dbinstance_identifier, tenant_dbname)
    delete_tenant_database(dbinstance_identifier, tenant_dbname, params::Dict{String,<:Any})

Deletes a tenant database from your DB instance. This command only applies to RDS for
Oracle container database (CDB) instances. You can't delete a tenant database when it is
the only tenant in the DB instance.

# Arguments
- `dbinstance_identifier`: The user-supplied identifier for the DB instance that contains
  the tenant database that you want to delete.
- `tenant_dbname`: The user-supplied name of the tenant database that you want to remove
  from your DB instance. Amazon RDS deletes the tenant database with this name. This
  parameter isn’t case-sensitive.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FinalDBSnapshotIdentifier"`: The DBSnapshotIdentifier of the new DBSnapshot created
  when the SkipFinalSnapshot parameter is disabled.  If you enable this parameter and also
  enable SkipFinalShapshot, the command results in an error.
- `"SkipFinalSnapshot"`: Specifies whether to skip the creation of a final DB snapshot
  before removing the tenant database from your DB instance. If you enable this parameter,
  RDS doesn't create a DB snapshot. If you don't enable this parameter, RDS creates a DB
  snapshot before it deletes the tenant database. By default, RDS doesn't skip the final
  snapshot. If you don't enable this parameter, you must specify the
  FinalDBSnapshotIdentifier parameter.
"""
function delete_tenant_database(
    DBInstanceIdentifier, TenantDBName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeleteTenantDatabase",
        Dict{String,Any}(
            "DBInstanceIdentifier" => DBInstanceIdentifier, "TenantDBName" => TenantDBName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_tenant_database(
    DBInstanceIdentifier,
    TenantDBName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeleteTenantDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "TenantDBName" => TenantDBName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    deregister_dbproxy_targets(dbproxy_name)
    deregister_dbproxy_targets(dbproxy_name, params::Dict{String,<:Any})

Remove the association between one or more DBProxyTarget data structures and a
DBProxyTargetGroup.

# Arguments
- `dbproxy_name`: The identifier of the DBProxy that is associated with the
  DBProxyTargetGroup.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBClusterIdentifiers"`: One or more DB cluster identifiers.
- `"DBInstanceIdentifiers"`: One or more DB instance identifiers.
- `"TargetGroupName"`: The identifier of the DBProxyTargetGroup.
"""
function deregister_dbproxy_targets(
    DBProxyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DeregisterDBProxyTargets",
        Dict{String,Any}("DBProxyName" => DBProxyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function deregister_dbproxy_targets(
    DBProxyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DeregisterDBProxyTargets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DBProxyName" => DBProxyName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_account_attributes()
    describe_account_attributes(params::Dict{String,<:Any})

Lists all of the attributes for a customer account. The attributes include Amazon RDS
quotas for the account, such as the number of DB instances allowed. The description for a
quota includes the quota name, current usage toward that quota, and the quota's maximum
value. This command doesn't take any parameters.

"""
function describe_account_attributes(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeAccountAttributes"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_account_attributes(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeAccountAttributes",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_blue_green_deployments()
    describe_blue_green_deployments(params::Dict{String,<:Any})

Describes one or more blue/green deployments. For more information, see Using Amazon RDS
Blue/Green Deployments for database updates in the Amazon RDS User Guide and  Using Amazon
RDS Blue/Green Deployments for database updates in the Amazon Aurora User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BlueGreenDeploymentIdentifier"`: The blue/green deployment identifier. If you specify
  this parameter, the response only includes information about the specific blue/green
  deployment. This parameter isn't case-sensitive. Constraints:   Must match an existing
  blue/green deployment identifier.
- `"Filters"`: A filter that specifies one or more blue/green deployments to describe.
  Valid Values:    blue-green-deployment-identifier - Accepts system-generated identifiers
  for blue/green deployments. The results list only includes information about the blue/green
  deployments with the specified identifiers.    blue-green-deployment-name - Accepts
  user-supplied names for blue/green deployments. The results list only includes information
  about the blue/green deployments with the specified names.    source - Accepts source
  databases for a blue/green deployment. The results list only includes information about the
  blue/green deployments with the specified source databases.    target - Accepts target
  databases for a blue/green deployment. The results list only includes information about the
  blue/green deployments with the specified target databases.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeBlueGreenDeployments request. If you specify this parameter, the response only
  includes records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:   Must
  be a minimum of 20.   Can't exceed 100.
"""
function describe_blue_green_deployments(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeBlueGreenDeployments";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_blue_green_deployments(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeBlueGreenDeployments",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_certificates()
    describe_certificates(params::Dict{String,<:Any})

Lists the set of certificate authority (CA) certificates provided by Amazon RDS for this
Amazon Web Services account. For more information, see Using SSL/TLS to encrypt a
connection to a DB instance in the Amazon RDS User Guide and  Using SSL/TLS to encrypt a
connection to a DB cluster in the Amazon Aurora User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateIdentifier"`: The user-supplied certificate identifier. If this parameter is
  specified, information for only the identified certificate is returned. This parameter
  isn't case-sensitive. Constraints:   Must match an existing CertificateIdentifier.
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous DescribeCertificates
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeCertificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeCertificates",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbcluster_automated_backups()
    describe_dbcluster_automated_backups(params::Dict{String,<:Any})

Displays backups for both current and deleted DB clusters. For example, use this operation
to find details about automated backups for previously deleted clusters. Current clusters
are returned for both the DescribeDBClusterAutomatedBackups and DescribeDBClusters
operations. All parameters are optional.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBClusterIdentifier"`: (Optional) The user-supplied DB cluster identifier. If this
  parameter is specified, it must match the identifier of an existing DB cluster. It returns
  information from the specific DB cluster's automated backup. This parameter isn't
  case-sensitive.
- `"DbClusterResourceId"`: The resource ID of the DB cluster that is the source of the
  automated backup. This parameter isn't case-sensitive.
- `"Filters"`: A filter that specifies which resources to return based on status. Supported
  filters are the following:    status     retained - Automated backups for deleted clusters
  and after backup replication is stopped.      db-cluster-id - Accepts DB cluster
  identifiers and Amazon Resource Names (ARNs). The results list includes only information
  about the DB cluster automated backups identified by these ARNs.    db-cluster-resource-id
  - Accepts DB resource identifiers and Amazon Resource Names (ARNs). The results list
  includes only information about the DB cluster resources identified by these ARNs.
  Returns all resources by default. The status for each resource is specified in the response.
- `"Marker"`: The pagination token provided in the previous request. If this parameter is
  specified the response includes only records beyond the marker, up to MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results.
"""
function describe_dbcluster_automated_backups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterAutomatedBackups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbcluster_automated_backups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterAutomatedBackups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbcluster_backtracks(dbcluster_identifier)
    describe_dbcluster_backtracks(dbcluster_identifier, params::Dict{String,<:Any})

Returns information about backtracks for a DB cluster. For more information on Amazon
Aurora, see  What is Amazon Aurora? in the Amazon Aurora User Guide.  This action only
applies to Aurora MySQL DB clusters.

# Arguments
- `dbcluster_identifier`: The DB cluster identifier of the DB cluster to be described. This
  parameter is stored as a lowercase string. Constraints:   Must contain from 1 to 63
  alphanumeric characters or hyphens.   First character must be a letter.   Can't end with a
  hyphen or contain two consecutive hyphens.   Example: my-cluster1

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BacktrackIdentifier"`: If specified, this value is the backtrack identifier of the
  backtrack to be described. Constraints:   Must contain a valid universally unique
  identifier (UUID). For more information about UUIDs, see Universally unique identifier.
  Example: 123e4567-e89b-12d3-a456-426655440000
- `"Filters"`: A filter that specifies one or more DB clusters to describe. Supported
  filters include the following:    db-cluster-backtrack-id - Accepts backtrack identifiers.
  The results list includes information about only the backtracks identified by these
  identifiers.    db-cluster-backtrack-status - Accepts any of the following backtrack status
  values:    applying     completed     failed     pending    The results list includes
  information about only the backtracks identified by these values.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeDBClusterBacktracks request. If this parameter is specified, the response includes
  only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbcluster_backtracks(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterBacktracks",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbcluster_backtracks(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeDBClusterBacktracks",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbcluster_endpoints()
    describe_dbcluster_endpoints(params::Dict{String,<:Any})

Returns information about endpoints for an Amazon Aurora DB cluster.  This action only
applies to Aurora DB clusters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBClusterEndpointIdentifier"`: The identifier of the endpoint to describe. This
  parameter is stored as a lowercase string.
- `"DBClusterIdentifier"`: The DB cluster identifier of the DB cluster associated with the
  endpoint. This parameter is stored as a lowercase string.
- `"Filters"`: A set of name-value pairs that define which endpoints to include in the
  output. The filters are specified as name-value pairs, in the format
  Name=endpoint_type,Values=endpoint_type1,endpoint_type2,.... Name can be one of:
  db-cluster-endpoint-type, db-cluster-endpoint-custom-type, db-cluster-endpoint-id,
  db-cluster-endpoint-status. Values for the  db-cluster-endpoint-type filter can be one or
  more of: reader, writer, custom. Values for the db-cluster-endpoint-custom-type filter can
  be one or more of: reader, any. Values for the db-cluster-endpoint-status filter can be one
  or more of: available, creating, deleting, inactive, modifying.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeDBClusterEndpoints request. If this parameter is specified, the response includes
  only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbcluster_endpoints(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBClusterEndpoints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbcluster_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbcluster_parameter_groups()
    describe_dbcluster_parameter_groups(params::Dict{String,<:Any})

Returns a list of DBClusterParameterGroup descriptions. If a DBClusterParameterGroupName
parameter is specified, the list will contain only the description of the specified DB
cluster parameter group. For more information on Amazon Aurora, see  What is Amazon Aurora?
in the Amazon Aurora User Guide. For more information on Multi-AZ DB clusters, see
Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBClusterParameterGroupName"`: The name of a specific DB cluster parameter group to
  return details for. Constraints:   If supplied, must match the name of an existing
  DBClusterParameterGroup.
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeDBClusterParameterGroups request. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbcluster_parameter_groups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterParameterGroups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbcluster_parameter_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterParameterGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbcluster_parameters(dbcluster_parameter_group_name)
    describe_dbcluster_parameters(dbcluster_parameter_group_name, params::Dict{String,<:Any})

Returns the detailed parameter list for a particular DB cluster parameter group. For more
information on Amazon Aurora, see  What is Amazon Aurora? in the Amazon Aurora User Guide.
For more information on Multi-AZ DB clusters, see  Multi-AZ DB cluster deployments in the
Amazon RDS User Guide.

# Arguments
- `dbcluster_parameter_group_name`: The name of a specific DB cluster parameter group to
  return parameter details for. Constraints:   If supplied, must match the name of an
  existing DBClusterParameterGroup.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeDBClusterParameters request. If this parameter is specified, the response includes
  only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"Source"`: A specific source to return parameters for. Valid Values:    customer
  engine     service
"""
function describe_dbcluster_parameters(
    DBClusterParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterParameters",
        Dict{String,Any}("DBClusterParameterGroupName" => DBClusterParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbcluster_parameters(
    DBClusterParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeDBClusterParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterParameterGroupName" => DBClusterParameterGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbcluster_snapshot_attributes(dbcluster_snapshot_identifier)
    describe_dbcluster_snapshot_attributes(dbcluster_snapshot_identifier, params::Dict{String,<:Any})

Returns a list of DB cluster snapshot attribute names and values for a manual DB cluster
snapshot. When sharing snapshots with other Amazon Web Services accounts,
DescribeDBClusterSnapshotAttributes returns the restore attribute and a list of IDs for the
Amazon Web Services accounts that are authorized to copy or restore the manual DB cluster
snapshot. If all is included in the list of values for the restore attribute, then the
manual DB cluster snapshot is public and can be copied or restored by all Amazon Web
Services accounts. To add or remove access for an Amazon Web Services account to copy or
restore a manual DB cluster snapshot, or to make the manual DB cluster snapshot public or
private, use the ModifyDBClusterSnapshotAttribute API action.

# Arguments
- `dbcluster_snapshot_identifier`: The identifier for the DB cluster snapshot to describe
  the attributes for.

"""
function describe_dbcluster_snapshot_attributes(
    DBClusterSnapshotIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterSnapshotAttributes",
        Dict{String,Any}("DBClusterSnapshotIdentifier" => DBClusterSnapshotIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbcluster_snapshot_attributes(
    DBClusterSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeDBClusterSnapshotAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterSnapshotIdentifier" => DBClusterSnapshotIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbcluster_snapshots()
    describe_dbcluster_snapshots(params::Dict{String,<:Any})

Returns information about DB cluster snapshots. This API action supports pagination. For
more information on Amazon Aurora DB clusters, see  What is Amazon Aurora? in the Amazon
Aurora User Guide. For more information on Multi-AZ DB clusters, see  Multi-AZ DB cluster
deployments in the Amazon RDS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBClusterIdentifier"`: The ID of the DB cluster to retrieve the list of DB cluster
  snapshots for. This parameter can't be used in conjunction with the
  DBClusterSnapshotIdentifier parameter. This parameter isn't case-sensitive. Constraints:
  If supplied, must match the identifier of an existing DBCluster.
- `"DBClusterSnapshotIdentifier"`: A specific DB cluster snapshot identifier to describe.
  This parameter can't be used in conjunction with the DBClusterIdentifier parameter. This
  value is stored as a lowercase string. Constraints:   If supplied, must match the
  identifier of an existing DBClusterSnapshot.   If this identifier is for an automated
  snapshot, the SnapshotType parameter must also be specified.
- `"DbClusterResourceId"`: A specific DB cluster resource ID to describe.
- `"Filters"`: A filter that specifies one or more DB cluster snapshots to describe.
  Supported filters:    db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon
  Resource Names (ARNs).    db-cluster-snapshot-id - Accepts DB cluster snapshot identifiers.
     snapshot-type - Accepts types of DB cluster snapshots.    engine - Accepts names of
  database engines.
- `"IncludePublic"`: Specifies whether to include manual DB cluster snapshots that are
  public and can be copied or restored by any Amazon Web Services account. By default, the
  public snapshots are not included. You can share a manual DB cluster snapshot as public by
  using the ModifyDBClusterSnapshotAttribute API action.
- `"IncludeShared"`: Specifies whether to include shared manual DB cluster snapshots from
  other Amazon Web Services accounts that this Amazon Web Services account has been given
  permission to copy or restore. By default, these snapshots are not included. You can give
  an Amazon Web Services account permission to restore a manual DB cluster snapshot from
  another Amazon Web Services account by the ModifyDBClusterSnapshotAttribute API action.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeDBClusterSnapshots request. If this parameter is specified, the response includes
  only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"SnapshotType"`: The type of DB cluster snapshots to be returned. You can specify one of
  the following values:    automated - Return all DB cluster snapshots that have been
  automatically taken by Amazon RDS for my Amazon Web Services account.    manual - Return
  all DB cluster snapshots that have been taken by my Amazon Web Services account.    shared
  - Return all manual DB cluster snapshots that have been shared to my Amazon Web Services
  account.    public - Return all DB cluster snapshots that have been marked as public.   If
  you don't specify a SnapshotType value, then both automated and manual DB cluster snapshots
  are returned. You can include shared DB cluster snapshots with these results by enabling
  the IncludeShared parameter. You can include public DB cluster snapshots with these results
  by enabling the IncludePublic parameter. The IncludeShared and IncludePublic parameters
  don't apply for SnapshotType values of manual or automated. The IncludePublic parameter
  doesn't apply when SnapshotType is set to shared. The IncludeShared parameter doesn't apply
  when SnapshotType is set to public.
"""
function describe_dbcluster_snapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBClusterSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbcluster_snapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusterSnapshots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbclusters()
    describe_dbclusters(params::Dict{String,<:Any})

Describes existing Amazon Aurora DB clusters and Multi-AZ DB clusters. This API supports
pagination. For more information on Amazon Aurora DB clusters, see  What is Amazon Aurora?
in the Amazon Aurora User Guide. For more information on Multi-AZ DB clusters, see
Multi-AZ DB cluster deployments in the Amazon RDS User Guide. This operation can also
return information for Amazon Neptune DB instances and Amazon DocumentDB instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBClusterIdentifier"`: The user-supplied DB cluster identifier or the Amazon Resource
  Name (ARN) of the DB cluster. If this parameter is specified, information for only the
  specific DB cluster is returned. This parameter isn't case-sensitive. Constraints:   If
  supplied, must match an existing DB cluster identifier.
- `"Filters"`: A filter that specifies one or more DB clusters to describe. Supported
  Filters:    clone-group-id - Accepts clone group identifiers. The results list only
  includes information about the DB clusters associated with these clone groups.
  db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon Resource Names (ARNs).
  The results list only includes information about the DB clusters identified by these ARNs.
    db-cluster-resource-id - Accepts DB cluster resource identifiers. The results list will
  only include information about the DB clusters identified by these DB cluster resource
  identifiers.    domain - Accepts Active Directory directory IDs. The results list only
  includes information about the DB clusters associated with these domains.    engine -
  Accepts engine names. The results list only includes information about the DB clusters for
  these engines.
- `"IncludeShared"`: Specifies whether the output includes information about clusters
  shared from other Amazon Web Services accounts.
- `"Marker"`: An optional pagination token provided by a previous DescribeDBClusters
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100
"""
function describe_dbclusters(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds("DescribeDBClusters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_dbclusters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBClusters", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_dbengine_versions()
    describe_dbengine_versions(params::Dict{String,<:Any})

Describes the properties of specific versions of DB engines.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBParameterGroupFamily"`: The name of a specific DB parameter group family to return
  details for. Constraints:   If supplied, must match an existing DB parameter group family.
- `"DefaultOnly"`: Specifies whether to return only the default version of the specified
  engine or the engine and major version combination.
- `"Engine"`: The database engine to return version details for. Valid Values:
  aurora-mysql     aurora-postgresql     custom-oracle-ee     custom-oracle-ee-cdb
  custom-oracle-se2     custom-oracle-se2-cdb     db2-ae     db2-se     mariadb     mysql
  oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee
      sqlserver-se     sqlserver-ex     sqlserver-web
- `"EngineVersion"`: A specific database engine version to return details for. Example:
  5.1.49
- `"Filters"`: A filter that specifies one or more DB engine versions to describe.
  Supported filters:    db-parameter-group-family - Accepts parameter groups family names.
  The results list only includes information about the DB engine versions for these parameter
  group families.    engine - Accepts engine names. The results list only includes
  information about the DB engine versions for these engines.    engine-mode - Accepts DB
  engine modes. The results list only includes information about the DB engine versions for
  these engine modes. Valid DB engine modes are the following:    global     multimaster
  parallelquery     provisioned     serverless       engine-version - Accepts engine
  versions. The results list only includes information about the DB engine versions for these
  engine versions.    status - Accepts engine version statuses. The results list only
  includes information about the DB engine versions for these statuses. Valid statuses are
  the following:    available     deprecated
- `"IncludeAll"`: Specifies whether to also list the engine versions that aren't available.
  The default is to list only available engine versions.
- `"ListSupportedCharacterSets"`: Specifies whether to list the supported character sets
  for each engine version. If this parameter is enabled and the requested engine supports the
  CharacterSetName parameter for CreateDBInstance, the response includes a list of supported
  character sets for each engine version. For RDS Custom, the default is not to list
  supported character sets. If you enable this parameter, RDS Custom returns no results.
- `"ListSupportedTimezones"`: Specifies whether to list the supported time zones for each
  engine version. If this parameter is enabled and the requested engine supports the TimeZone
  parameter for CreateDBInstance, the response includes a list of supported time zones for
  each engine version. For RDS Custom, the default is not to list supported time zones. If
  you enable this parameter, RDS Custom returns no results.
- `"Marker"`: An optional pagination token provided by a previous request. If this
  parameter is specified, the response includes only records beyond the marker, up to the
  value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more than
  the MaxRecords value is available, a pagination token called a marker is included in the
  response so you can retrieve the remaining results. Default: 100 Constraints: Minimum 20,
  maximum 100.
"""
function describe_dbengine_versions(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBEngineVersions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbengine_versions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBEngineVersions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbinstance_automated_backups()
    describe_dbinstance_automated_backups(params::Dict{String,<:Any})

Displays backups for both current and deleted instances. For example, use this operation to
find details about automated backups for previously deleted instances. Current instances
with retention periods greater than zero (0) are returned for both the
DescribeDBInstanceAutomatedBackups and DescribeDBInstances operations. All parameters are
optional.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceAutomatedBackupsArn"`: The Amazon Resource Name (ARN) of the replicated
  automated backups, for example,
  arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE. This setting
  doesn't apply to RDS Custom.
- `"DBInstanceIdentifier"`: (Optional) The user-supplied instance identifier. If this
  parameter is specified, it must match the identifier of an existing DB instance. It returns
  information from the specific DB instance's automated backup. This parameter isn't
  case-sensitive.
- `"DbiResourceId"`: The resource ID of the DB instance that is the source of the automated
  backup. This parameter isn't case-sensitive.
- `"Filters"`: A filter that specifies which resources to return based on status. Supported
  filters are the following:    status     active - Automated backups for current instances.
    creating - Automated backups that are waiting for the first automated snapshot to be
  available.    retained - Automated backups for deleted instances and after backup
  replication is stopped.      db-instance-id - Accepts DB instance identifiers and Amazon
  Resource Names (ARNs). The results list includes only information about the DB instance
  automated backups identified by these ARNs.    dbi-resource-id - Accepts DB resource
  identifiers and Amazon Resource Names (ARNs). The results list includes only information
  about the DB instance resources identified by these ARNs.   Returns all resources by
  default. The status for each resource is specified in the response.
- `"Marker"`: The pagination token provided in the previous request. If this parameter is
  specified the response includes only records beyond the marker, up to MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results.
"""
function describe_dbinstance_automated_backups(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBInstanceAutomatedBackups";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbinstance_automated_backups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBInstanceAutomatedBackups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbinstances()
    describe_dbinstances(params::Dict{String,<:Any})

Describes provisioned RDS instances. This API supports pagination.  This operation can also
return information for Amazon Neptune DB instances and Amazon DocumentDB instances.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceIdentifier"`: The user-supplied instance identifier or the Amazon Resource
  Name (ARN) of the DB instance. If this parameter is specified, information from only the
  specific DB instance is returned. This parameter isn't case-sensitive. Constraints:   If
  supplied, must match the identifier of an existing DB instance.
- `"Filters"`: A filter that specifies one or more DB instances to describe. Supported
  Filters:    db-cluster-id - Accepts DB cluster identifiers and DB cluster Amazon Resource
  Names (ARNs). The results list only includes information about the DB instances associated
  with the DB clusters identified by these ARNs.    db-instance-id - Accepts DB instance
  identifiers and DB instance Amazon Resource Names (ARNs). The results list only includes
  information about the DB instances identified by these ARNs.    dbi-resource-id - Accepts
  DB instance resource identifiers. The results list only includes information about the DB
  instances identified by these DB instance resource identifiers.    domain - Accepts Active
  Directory directory IDs. The results list only includes information about the DB instances
  associated with these domains.    engine - Accepts engine names. The results list only
  includes information about the DB instances for these engines.
- `"Marker"`: An optional pagination token provided by a previous DescribeDBInstances
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbinstances(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBInstances"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbinstances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dblog_files(dbinstance_identifier)
    describe_dblog_files(dbinstance_identifier, params::Dict{String,<:Any})

Returns a list of DB log files for the DB instance. This command doesn't apply to RDS
Custom.

# Arguments
- `dbinstance_identifier`: The customer-assigned name of the DB instance that contains the
  log files you want to list. Constraints:   Must match the identifier of an existing
  DBInstance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FileLastWritten"`: Filters the available log files for files written since the
  specified date, in POSIX timestamp format with milliseconds.
- `"FileSize"`: Filters the available log files for files larger than the specified size.
- `"FilenameContains"`: Filters the available log files for log file names that contain the
  specified string.
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: The pagination token provided in the previous request. If this parameter is
  specified the response includes only records beyond the marker, up to MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results.
"""
function describe_dblog_files(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBLogFiles",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dblog_files(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeDBLogFiles",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbparameter_groups()
    describe_dbparameter_groups(params::Dict{String,<:Any})

Returns a list of DBParameterGroup descriptions. If a DBParameterGroupName is specified,
the list will contain only the description of the specified DB parameter group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBParameterGroupName"`: The name of a specific DB parameter group to return details
  for. Constraints:   If supplied, must match the name of an existing
  DBClusterParameterGroup.
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous DescribeDBParameterGroups
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbparameter_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBParameterGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbparameter_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBParameterGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbparameters(dbparameter_group_name)
    describe_dbparameters(dbparameter_group_name, params::Dict{String,<:Any})

Returns the detailed parameter list for a particular DB parameter group.

# Arguments
- `dbparameter_group_name`: The name of a specific DB parameter group to return details
  for. Constraints:   If supplied, must match the name of an existing DBParameterGroup.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous DescribeDBParameters
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"Source"`: The parameter types to return. Default: All parameter types returned Valid
  Values: user | system | engine-default
"""
function describe_dbparameters(
    DBParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBParameters",
        Dict{String,Any}("DBParameterGroupName" => DBParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbparameters(
    DBParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeDBParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBParameterGroupName" => DBParameterGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbproxies()
    describe_dbproxies(params::Dict{String,<:Any})

Returns information about DB proxies.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBProxyName"`: The name of the DB proxy. If you omit this parameter, the output
  includes information about all DB proxies owned by your Amazon Web Services account ID.
- `"Filters"`: This parameter is not currently supported.
- `"Marker"`: An optional pagination token provided by a previous request. If this
  parameter is specified, the response includes only records beyond the marker, up to the
  value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that the remaining results can be retrieved. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbproxies(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds("DescribeDBProxies"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_dbproxies(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBProxies", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_dbproxy_endpoints()
    describe_dbproxy_endpoints(params::Dict{String,<:Any})

Returns information about DB proxy endpoints.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBProxyEndpointName"`: The name of a DB proxy endpoint to describe. If you omit this
  parameter, the output includes information about all DB proxy endpoints associated with the
  specified proxy.
- `"DBProxyName"`: The name of the DB proxy whose endpoints you want to describe. If you
  omit this parameter, the output includes information about all DB proxy endpoints
  associated with all your DB proxies.
- `"Filters"`: This parameter is not currently supported.
- `"Marker"`: An optional pagination token provided by a previous request. If this
  parameter is specified, the response includes only records beyond the marker, up to the
  value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that the remaining results can be retrieved. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbproxy_endpoints(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBProxyEndpoints"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbproxy_endpoints(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBProxyEndpoints",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbproxy_target_groups(dbproxy_name)
    describe_dbproxy_target_groups(dbproxy_name, params::Dict{String,<:Any})

Returns information about DB proxy target groups, represented by DBProxyTargetGroup data
structures.

# Arguments
- `dbproxy_name`: The identifier of the DBProxy associated with the target group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter is not currently supported.
- `"Marker"`: An optional pagination token provided by a previous request. If this
  parameter is specified, the response includes only records beyond the marker, up to the
  value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that the remaining results can be retrieved. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"TargetGroupName"`: The identifier of the DBProxyTargetGroup to describe.
"""
function describe_dbproxy_target_groups(
    DBProxyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBProxyTargetGroups",
        Dict{String,Any}("DBProxyName" => DBProxyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbproxy_target_groups(
    DBProxyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeDBProxyTargetGroups",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DBProxyName" => DBProxyName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbproxy_targets(dbproxy_name)
    describe_dbproxy_targets(dbproxy_name, params::Dict{String,<:Any})

Returns information about DBProxyTarget objects. This API supports pagination.

# Arguments
- `dbproxy_name`: The identifier of the DBProxyTarget to describe.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter is not currently supported.
- `"Marker"`: An optional pagination token provided by a previous request. If this
  parameter is specified, the response includes only records beyond the marker, up to the
  value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that the remaining results can be retrieved. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"TargetGroupName"`: The identifier of the DBProxyTargetGroup to describe.
"""
function describe_dbproxy_targets(
    DBProxyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBProxyTargets",
        Dict{String,Any}("DBProxyName" => DBProxyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbproxy_targets(
    DBProxyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeDBProxyTargets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DBProxyName" => DBProxyName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbrecommendations()
    describe_dbrecommendations(params::Dict{String,<:Any})

Describes the recommendations to resolve the issues for your DB instances, DB clusters, and
DB parameter groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A filter that specifies one or more recommendations to describe. Supported
  Filters:    recommendation-id - Accepts a list of recommendation identifiers. The results
  list only includes the recommendations whose identifier is one of the specified filter
  values.    status - Accepts a list of recommendation statuses. Valid values:    active -
  The recommendations which are ready for you to apply.    pending - The applied or scheduled
  recommendations which are in progress.    resolved - The recommendations which are
  completed.    dismissed - The recommendations that you dismissed.   The results list only
  includes the recommendations whose status is one of the specified filter values.
  severity - Accepts a list of recommendation severities. The results list only includes the
  recommendations whose severity is one of the specified filter values. Valid values:    high
      medium     low     informational       type-id - Accepts a list of recommendation type
  identifiers. The results list only includes the recommendations whose type is one of the
  specified filter values.    dbi-resource-id - Accepts a list of database resource
  identifiers. The results list only includes the recommendations that generated for the
  specified databases.    cluster-resource-id - Accepts a list of cluster resource
  identifiers. The results list only includes the recommendations that generated for the
  specified clusters.    pg-arn - Accepts a list of parameter group ARNs. The results list
  only includes the recommendations that generated for the specified parameter groups.
  cluster-pg-arn - Accepts a list of cluster parameter group ARNs. The results list only
  includes the recommendations that generated for the specified cluster parameter groups.
- `"LastUpdatedAfter"`: A filter to include only the recommendations that were updated
  after this specified time.
- `"LastUpdatedBefore"`: A filter to include only the recommendations that were updated
  before this specified time.
- `"Locale"`: The language that you choose to return the list of recommendations. Valid
  values:    en     en_UK     de     es     fr     id     it     ja     ko     pt_BR
  zh_TW     zh_CN
- `"Marker"`: An optional pagination token provided by a previous DescribeDBRecommendations
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of recommendations to include in the response. If more
  records exist than the specified MaxRecords value, a pagination token called a marker is
  included in the response so that you can retrieve the remaining results.
"""
function describe_dbrecommendations(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBRecommendations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbrecommendations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBRecommendations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbsecurity_groups()
    describe_dbsecurity_groups(params::Dict{String,<:Any})

Returns a list of DBSecurityGroup descriptions. If a DBSecurityGroupName is specified, the
list will contain only the descriptions of the specified DB security group.  EC2-Classic
was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a VPC, we
recommend that you migrate as soon as possible. For more information, see Migrate from
EC2-Classic to a VPC in the Amazon EC2 User Guide, the blog EC2-Classic Networking is
Retiring – Here’s How to Prepare, and Moving a DB instance not in a VPC into a VPC in
the Amazon RDS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBSecurityGroupName"`: The name of the DB security group to return details for.
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous DescribeDBSecurityGroups
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbsecurity_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBSecurityGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbsecurity_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBSecurityGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbshard_groups()
    describe_dbshard_groups(params::Dict{String,<:Any})

Describes existing Aurora Limitless Database DB shard groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBShardGroupIdentifier"`: The user-supplied DB shard group identifier or the Amazon
  Resource Name (ARN) of the DB shard group. If this parameter is specified, information for
  only the specific DB shard group is returned. This parameter isn't case-sensitive.
  Constraints:   If supplied, must match an existing DB shard group identifier.
- `"Filters"`: A filter that specifies one or more DB shard groups to describe.
- `"Marker"`: An optional pagination token provided by a previous DescribeDBShardGroups
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100
"""
function describe_dbshard_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBShardGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbshard_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBShardGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbsnapshot_attributes(dbsnapshot_identifier)
    describe_dbsnapshot_attributes(dbsnapshot_identifier, params::Dict{String,<:Any})

Returns a list of DB snapshot attribute names and values for a manual DB snapshot. When
sharing snapshots with other Amazon Web Services accounts, DescribeDBSnapshotAttributes
returns the restore attribute and a list of IDs for the Amazon Web Services accounts that
are authorized to copy or restore the manual DB snapshot. If all is included in the list of
values for the restore attribute, then the manual DB snapshot is public and can be copied
or restored by all Amazon Web Services accounts. To add or remove access for an Amazon Web
Services account to copy or restore a manual DB snapshot, or to make the manual DB snapshot
public or private, use the ModifyDBSnapshotAttribute API action.

# Arguments
- `dbsnapshot_identifier`: The identifier for the DB snapshot to describe the attributes
  for.

"""
function describe_dbsnapshot_attributes(
    DBSnapshotIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBSnapshotAttributes",
        Dict{String,Any}("DBSnapshotIdentifier" => DBSnapshotIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbsnapshot_attributes(
    DBSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeDBSnapshotAttributes",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBSnapshotIdentifier" => DBSnapshotIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbsnapshot_tenant_databases()
    describe_dbsnapshot_tenant_databases(params::Dict{String,<:Any})

Describes the tenant databases that exist in a DB snapshot. This command only applies to
RDS for Oracle DB instances in the multi-tenant configuration. You can use this command to
inspect the tenant databases within a snapshot before restoring it. You can't directly
interact with the tenant databases in a DB snapshot. If you restore a snapshot that was
taken from DB instance using the multi-tenant configuration, you restore all its tenant
databases.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceIdentifier"`: The ID of the DB instance used to create the DB snapshots. This
  parameter isn't case-sensitive. Constraints:   If supplied, must match the identifier of an
  existing DBInstance.
- `"DBSnapshotIdentifier"`: The ID of a DB snapshot that contains the tenant databases to
  describe. This value is stored as a lowercase string. Constraints:   If you specify this
  parameter, the value must match the ID of an existing DB snapshot.   If you specify an
  automatic snapshot, you must also specify SnapshotType.
- `"DbiResourceId"`: A specific DB resource identifier to describe.
- `"Filters"`: A filter that specifies one or more tenant databases to describe. Supported
  filters:    tenant-db-name - Tenant database names. The results list only includes
  information about the tenant databases that match these tenant DB names.
  tenant-database-resource-id - Tenant database resource identifiers. The results list only
  includes information about the tenant databases contained within the DB snapshots.
  dbi-resource-id - DB instance resource identifiers. The results list only includes
  information about snapshots containing tenant databases contained within the DB instances
  identified by these resource identifiers.    db-instance-id - Accepts DB instance
  identifiers and DB instance Amazon Resource Names (ARNs).    db-snapshot-id - Accepts DB
  snapshot identifiers.    snapshot-type - Accepts types of DB snapshots.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeDBSnapshotTenantDatabases request. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results.
- `"SnapshotType"`: The type of DB snapshots to be returned. You can specify one of the
  following values:    automated – All DB snapshots that have been automatically taken by
  Amazon RDS for my Amazon Web Services account.    manual – All DB snapshots that have
  been taken by my Amazon Web Services account.    shared – All manual DB snapshots that
  have been shared to my Amazon Web Services account.    public – All DB snapshots that
  have been marked as public.    awsbackup – All DB snapshots managed by the Amazon Web
  Services Backup service.
"""
function describe_dbsnapshot_tenant_databases(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBSnapshotTenantDatabases";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_dbsnapshot_tenant_databases(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBSnapshotTenantDatabases",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbsnapshots()
    describe_dbsnapshots(params::Dict{String,<:Any})

Returns information about DB snapshots. This API action supports pagination.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceIdentifier"`: The ID of the DB instance to retrieve the list of DB snapshots
  for. This parameter isn't case-sensitive. Constraints:   If supplied, must match the
  identifier of an existing DBInstance.
- `"DBSnapshotIdentifier"`: A specific DB snapshot identifier to describe. This value is
  stored as a lowercase string. Constraints:   If supplied, must match the identifier of an
  existing DBSnapshot.   If this identifier is for an automated snapshot, the SnapshotType
  parameter must also be specified.
- `"DbiResourceId"`: A specific DB resource ID to describe.
- `"Filters"`: A filter that specifies one or more DB snapshots to describe. Supported
  filters:    db-instance-id - Accepts DB instance identifiers and DB instance Amazon
  Resource Names (ARNs).    db-snapshot-id - Accepts DB snapshot identifiers.
  dbi-resource-id - Accepts identifiers of source DB instances.    snapshot-type - Accepts
  types of DB snapshots.    engine - Accepts names of database engines.
- `"IncludePublic"`: Specifies whether to include manual DB cluster snapshots that are
  public and can be copied or restored by any Amazon Web Services account. By default, the
  public snapshots are not included. You can share a manual DB snapshot as public by using
  the ModifyDBSnapshotAttribute API. This setting doesn't apply to RDS Custom.
- `"IncludeShared"`: Specifies whether to include shared manual DB cluster snapshots from
  other Amazon Web Services accounts that this Amazon Web Services account has been given
  permission to copy or restore. By default, these snapshots are not included. You can give
  an Amazon Web Services account permission to restore a manual DB snapshot from another
  Amazon Web Services account by using the ModifyDBSnapshotAttribute API action. This setting
  doesn't apply to RDS Custom.
- `"Marker"`: An optional pagination token provided by a previous DescribeDBSnapshots
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"SnapshotType"`: The type of snapshots to be returned. You can specify one of the
  following values:    automated - Return all DB snapshots that have been automatically taken
  by Amazon RDS for my Amazon Web Services account.    manual - Return all DB snapshots that
  have been taken by my Amazon Web Services account.    shared - Return all manual DB
  snapshots that have been shared to my Amazon Web Services account.    public - Return all
  DB snapshots that have been marked as public.    awsbackup - Return the DB snapshots
  managed by the Amazon Web Services Backup service. For information about Amazon Web
  Services Backup, see the  Amazon Web Services Backup Developer Guide.   The awsbackup type
  does not apply to Aurora.   If you don't specify a SnapshotType value, then both automated
  and manual snapshots are returned. Shared and public DB snapshots are not included in the
  returned results by default. You can include shared snapshots with these results by
  enabling the IncludeShared parameter. You can include public snapshots with these results
  by enabling the IncludePublic parameter. The IncludeShared and IncludePublic parameters
  don't apply for SnapshotType values of manual or automated. The IncludePublic parameter
  doesn't apply when SnapshotType is set to shared. The IncludeShared parameter doesn't apply
  when SnapshotType is set to public.
"""
function describe_dbsnapshots(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBSnapshots"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbsnapshots(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBSnapshots",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_dbsubnet_groups()
    describe_dbsubnet_groups(params::Dict{String,<:Any})

Returns a list of DBSubnetGroup descriptions. If a DBSubnetGroupName is specified, the list
will contain only the descriptions of the specified DBSubnetGroup. For an overview of CIDR
ranges, go to the Wikipedia Tutorial.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBSubnetGroupName"`: The name of the DB subnet group to return details for.
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous DescribeDBSubnetGroups
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_dbsubnet_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeDBSubnetGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_dbsubnet_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeDBSubnetGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_engine_default_cluster_parameters(dbparameter_group_family)
    describe_engine_default_cluster_parameters(dbparameter_group_family, params::Dict{String,<:Any})

Returns the default engine and system parameter information for the cluster database
engine. For more information on Amazon Aurora, see  What is Amazon Aurora? in the Amazon
Aurora User Guide.

# Arguments
- `dbparameter_group_family`: The name of the DB cluster parameter group family to return
  engine parameter information for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeEngineDefaultClusterParameters request. If this parameter is specified, the
  response includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_engine_default_cluster_parameters(
    DBParameterGroupFamily; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeEngineDefaultClusterParameters",
        Dict{String,Any}("DBParameterGroupFamily" => DBParameterGroupFamily);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_engine_default_cluster_parameters(
    DBParameterGroupFamily,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeEngineDefaultClusterParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBParameterGroupFamily" => DBParameterGroupFamily),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_engine_default_parameters(dbparameter_group_family)
    describe_engine_default_parameters(dbparameter_group_family, params::Dict{String,<:Any})

Returns the default engine and system parameter information for the specified database
engine.

# Arguments
- `dbparameter_group_family`: The name of the DB parameter group family. Valid Values:
  aurora-mysql5.7     aurora-mysql8.0     aurora-postgresql10     aurora-postgresql11
  aurora-postgresql12     aurora-postgresql13     aurora-postgresql14     custom-oracle-ee-19
      custom-oracle-ee-cdb-19     db2-ae     db2-se     mariadb10.2     mariadb10.3
  mariadb10.4     mariadb10.5     mariadb10.6     mysql5.7     mysql8.0     oracle-ee-19
  oracle-ee-cdb-19     oracle-ee-cdb-21     oracle-se2-19     oracle-se2-cdb-19
  oracle-se2-cdb-21     postgres10     postgres11     postgres12     postgres13
  postgres14     sqlserver-ee-11.0     sqlserver-ee-12.0     sqlserver-ee-13.0
  sqlserver-ee-14.0     sqlserver-ee-15.0     sqlserver-ex-11.0     sqlserver-ex-12.0
  sqlserver-ex-13.0     sqlserver-ex-14.0     sqlserver-ex-15.0     sqlserver-se-11.0
  sqlserver-se-12.0     sqlserver-se-13.0     sqlserver-se-14.0     sqlserver-se-15.0
  sqlserver-web-11.0     sqlserver-web-12.0     sqlserver-web-13.0     sqlserver-web-14.0
  sqlserver-web-15.0

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeEngineDefaultParameters request. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_engine_default_parameters(
    DBParameterGroupFamily; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeEngineDefaultParameters",
        Dict{String,Any}("DBParameterGroupFamily" => DBParameterGroupFamily);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_engine_default_parameters(
    DBParameterGroupFamily,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeEngineDefaultParameters",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBParameterGroupFamily" => DBParameterGroupFamily),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_event_categories()
    describe_event_categories(params::Dict{String,<:Any})

Displays a list of categories for all event source types, or, if specified, for a specified
source type. You can also see this list in the \"Amazon RDS event categories and event
messages\" section of the  Amazon RDS User Guide  or the  Amazon Aurora User Guide .

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
- `"SourceType"`: The type of source that is generating the events. For RDS Proxy events,
  specify db-proxy. Valid Values: db-instance | db-cluster | db-parameter-group |
  db-security-group | db-snapshot | db-cluster-snapshot | db-proxy
"""
function describe_event_categories(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeEventCategories"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_event_categories(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeEventCategories",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_event_subscriptions()
    describe_event_subscriptions(params::Dict{String,<:Any})

Lists all the subscription descriptions for a customer account. The description for a
subscription includes SubscriptionName, SNSTopicARN, CustomerID, SourceType, SourceID,
CreationTime, and Status. If you specify a SubscriptionName, lists the description for that
subscription.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords .
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"SubscriptionName"`: The name of the RDS event notification subscription you want to
  describe.
"""
function describe_event_subscriptions(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeEventSubscriptions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_event_subscriptions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeEventSubscriptions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_events()
    describe_events(params::Dict{String,<:Any})

Returns events related to DB instances, DB clusters, DB parameter groups, DB security
groups, DB snapshots, DB cluster snapshots, and RDS Proxies for the past 14 days. Events
specific to a particular DB instance, DB cluster, DB parameter group, DB security group, DB
snapshot, DB cluster snapshot group, or RDS Proxy can be obtained by providing the name as
a parameter. For more information on working with events, see Monitoring Amazon RDS events
in the Amazon RDS User Guide and Monitoring Amazon Aurora events in the Amazon Aurora User
Guide.  By default, RDS returns events that were generated in the past hour.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Duration"`: The number of minutes to retrieve events for. Default: 60
- `"EndTime"`: The end of the time interval for which to retrieve events, specified in ISO
  8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia page.
  Example: 2009-07-08T18:00Z
- `"EventCategories"`: A list of event categories that trigger notifications for a event
  notification subscription.
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous DescribeEvents request.
  If this parameter is specified, the response includes only records beyond the marker, up to
  the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"SourceIdentifier"`: The identifier of the event source for which events are returned.
  If not specified, then all sources are included in the response. Constraints:   If
  SourceIdentifier is supplied, SourceType must also be provided.   If the source type is a
  DB instance, a DBInstanceIdentifier value must be supplied.   If the source type is a DB
  cluster, a DBClusterIdentifier value must be supplied.   If the source type is a DB
  parameter group, a DBParameterGroupName value must be supplied.   If the source type is a
  DB security group, a DBSecurityGroupName value must be supplied.   If the source type is a
  DB snapshot, a DBSnapshotIdentifier value must be supplied.   If the source type is a DB
  cluster snapshot, a DBClusterSnapshotIdentifier value must be supplied.   If the source
  type is an RDS Proxy, a DBProxyName value must be supplied.   Can't end with a hyphen or
  contain two consecutive hyphens.
- `"SourceType"`: The event source to retrieve events for. If no value is specified, all
  events are returned.
- `"StartTime"`: The beginning of the time interval to retrieve events for, specified in
  ISO 8601 format. For more information about ISO 8601, go to the ISO8601 Wikipedia page.
  Example: 2009-07-08T18:00Z
"""
function describe_events(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds("DescribeEvents"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function describe_events(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeEvents", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    describe_export_tasks()
    describe_export_tasks(params::Dict{String,<:Any})

Returns information about a snapshot or cluster export to Amazon S3. This API operation
supports pagination.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExportTaskIdentifier"`: The identifier of the snapshot or cluster export task to be
  described.
- `"Filters"`: Filters specify one or more snapshot or cluster exports to describe. The
  filters are specified as name-value pairs that define what to include in the output. Filter
  names and values are case-sensitive. Supported filters include the following:
  export-task-identifier - An identifier for the snapshot or cluster export task.
  s3-bucket - The Amazon S3 bucket the data is exported to.    source-arn - The Amazon
  Resource Name (ARN) of the snapshot or cluster exported to Amazon S3.    status - The
  status of the export task. Must be lowercase. Valid statuses are the following:    canceled
      canceling     complete     failed     in_progress     starting
- `"Marker"`: An optional pagination token provided by a previous DescribeExportTasks
  request. If you specify this parameter, the response includes only records beyond the
  marker, up to the value specified by the MaxRecords parameter.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified value, a pagination token called a marker is included in the
  response. You can use the marker in a later DescribeExportTasks request to retrieve the
  remaining results. Default: 100 Constraints: Minimum 20, maximum 100.
- `"SourceArn"`: The Amazon Resource Name (ARN) of the snapshot or cluster exported to
  Amazon S3.
- `"SourceType"`: The type of source for the export.
"""
function describe_export_tasks(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeExportTasks"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_export_tasks(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeExportTasks",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_global_clusters()
    describe_global_clusters(params::Dict{String,<:Any})

Returns information about Aurora global database clusters. This API supports pagination.
For more information on Amazon Aurora, see  What is Amazon Aurora? in the Amazon Aurora
User Guide.  This action only applies to Aurora DB clusters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A filter that specifies one or more global database clusters to describe.
  This parameter is case-sensitive. Currently, the only supported filter is region. If used,
  the request returns information about any global cluster with at least one member (primary
  or secondary) in the specified Amazon Web Services Regions.
- `"GlobalClusterIdentifier"`: The user-supplied DB cluster identifier. If this parameter
  is specified, information from only the specific DB cluster is returned. This parameter
  isn't case-sensitive. Constraints:   If supplied, must match an existing
  DBClusterIdentifier.
- `"Marker"`: An optional pagination token provided by a previous DescribeGlobalClusters
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_global_clusters(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeGlobalClusters"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_global_clusters(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeGlobalClusters",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_integrations()
    describe_integrations(params::Dict{String,<:Any})

Describe one or more zero-ETL integrations with Amazon Redshift.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A filter that specifies one or more resources to return.
- `"IntegrationIdentifier"`: The unique identifier of the integration.
- `"Marker"`: An optional pagination token provided by a previous DescribeIntegrations
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_integrations(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeIntegrations"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_integrations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeIntegrations",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_option_group_options(engine_name)
    describe_option_group_options(engine_name, params::Dict{String,<:Any})

Describes all available options for the specified engine.

# Arguments
- `engine_name`: The name of the engine to describe options for. Valid Values:    db2-ae
   db2-se     mariadb     mysql     oracle-ee     oracle-ee-cdb     oracle-se2
  oracle-se2-cdb     postgres     sqlserver-ee     sqlserver-se     sqlserver-ex
  sqlserver-web

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
- `"MajorEngineVersion"`: If specified, filters the results to include only options for the
  specified major engine version.
- `"Marker"`: An optional pagination token provided by a previous request. If this
  parameter is specified, the response includes only records beyond the marker, up to the
  value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
"""
function describe_option_group_options(
    EngineName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeOptionGroupOptions",
        Dict{String,Any}("EngineName" => EngineName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_option_group_options(
    EngineName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeOptionGroupOptions",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("EngineName" => EngineName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_option_groups()
    describe_option_groups(params::Dict{String,<:Any})

Describes the available option groups.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EngineName"`: A filter to only include option groups associated with this database
  engine. Valid Values:    db2-ae     db2-se     mariadb     mysql     oracle-ee
  oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee
  sqlserver-se     sqlserver-ex     sqlserver-web
- `"Filters"`: This parameter isn't currently supported.
- `"MajorEngineVersion"`: Filters the list of option groups to only include groups
  associated with a specific database engine version. If specified, then EngineName must also
  be specified.
- `"Marker"`: An optional pagination token provided by a previous DescribeOptionGroups
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"OptionGroupName"`: The name of the option group to describe. Can't be supplied together
  with EngineName or MajorEngineVersion.
"""
function describe_option_groups(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeOptionGroups"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_option_groups(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeOptionGroups",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_orderable_dbinstance_options(engine)
    describe_orderable_dbinstance_options(engine, params::Dict{String,<:Any})

Describes the orderable DB instance options for a specified DB engine.

# Arguments
- `engine`: The name of the database engine to describe DB instance options for. Valid
  Values:    aurora-mysql     aurora-postgresql     custom-oracle-ee     custom-oracle-ee-cdb
      custom-oracle-se2     custom-oracle-se2-cdb     db2-ae     db2-se     mariadb     mysql
      oracle-ee     oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres
  sqlserver-ee     sqlserver-se     sqlserver-ex     sqlserver-web

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AvailabilityZoneGroup"`: The Availability Zone group associated with a Local Zone.
  Specify this parameter to retrieve available options for the Local Zones in the group. Omit
  this parameter to show the available options in the specified Amazon Web Services Region.
  This setting doesn't apply to RDS Custom DB instances.
- `"DBInstanceClass"`: A filter to include only the available options for the specified DB
  instance class.
- `"EngineVersion"`: A filter to include only the available options for the specified
  engine version.
- `"Filters"`: This parameter isn't currently supported.
- `"LicenseModel"`: A filter to include only the available options for the specified
  license model. RDS Custom supports only the BYOL licensing model.
- `"Marker"`: An optional pagination token provided by a previous
  DescribeOrderableDBInstanceOptions request. If this parameter is specified, the response
  includes only records beyond the marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 1000.
- `"Vpc"`: Specifies whether to show only VPC or non-VPC offerings. RDS Custom supports
  only VPC offerings. RDS Custom supports only VPC offerings. If you describe non-VPC
  offerings for RDS Custom, the output shows VPC offerings.
"""
function describe_orderable_dbinstance_options(
    Engine; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeOrderableDBInstanceOptions",
        Dict{String,Any}("Engine" => Engine);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_orderable_dbinstance_options(
    Engine, params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeOrderableDBInstanceOptions",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("Engine" => Engine), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_pending_maintenance_actions()
    describe_pending_maintenance_actions(params::Dict{String,<:Any})

Returns a list of resources (for example, DB instances) that have at least one pending
maintenance action.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: A filter that specifies one or more resources to return pending maintenance
  actions for. Supported filters:    db-cluster-id - Accepts DB cluster identifiers and DB
  cluster Amazon Resource Names (ARNs). The results list only includes pending maintenance
  actions for the DB clusters identified by these ARNs.    db-instance-id - Accepts DB
  instance identifiers and DB instance ARNs. The results list only includes pending
  maintenance actions for the DB instances identified by these ARNs.
- `"Marker"`: An optional pagination token provided by a previous
  DescribePendingMaintenanceActions request. If this parameter is specified, the response
  includes only records beyond the marker, up to a number of records specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"ResourceIdentifier"`: The ARN of a resource to return pending maintenance actions for.
"""
function describe_pending_maintenance_actions(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribePendingMaintenanceActions";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_pending_maintenance_actions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribePendingMaintenanceActions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_dbinstances()
    describe_reserved_dbinstances(params::Dict{String,<:Any})

Returns information about reserved DB instances for this account, or about a specified
reserved DB instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceClass"`: The DB instance class filter value. Specify this parameter to show
  only those reservations matching the specified DB instances class.
- `"Duration"`: The duration filter value, specified in years or seconds. Specify this
  parameter to show only reservations for this duration. Valid Values: 1 | 3 | 31536000 |
  94608000
- `"Filters"`: This parameter isn't currently supported.
- `"LeaseId"`: The lease identifier filter value. Specify this parameter to show only the
  reservation that matches the specified lease ID.  Amazon Web Services Support might request
  the lease ID for an issue related to a reserved DB instance.
- `"Marker"`: An optional pagination token provided by a previous request. If this
  parameter is specified, the response includes only records beyond the marker, up to the
  value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more than
  the MaxRecords value is available, a pagination token called a marker is included in the
  response so you can retrieve the remaining results. Default: 100 Constraints: Minimum 20,
  maximum 100.
- `"MultiAZ"`: Specifies whether to show only those reservations that support Multi-AZ.
- `"OfferingType"`: The offering type filter value. Specify this parameter to show only the
  available offerings matching the specified offering type. Valid Values: \"Partial Upfront\"
  | \"All Upfront\" | \"No Upfront\"
- `"ProductDescription"`: The product description filter value. Specify this parameter to
  show only those reservations matching the specified product description.
- `"ReservedDBInstanceId"`: The reserved DB instance identifier filter value. Specify this
  parameter to show only the reservation that matches the specified reservation ID.
- `"ReservedDBInstancesOfferingId"`: The offering identifier filter value. Specify this
  parameter to show only purchased reservations matching the specified offering identifier.
"""
function describe_reserved_dbinstances(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeReservedDBInstances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_dbinstances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeReservedDBInstances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_reserved_dbinstances_offerings()
    describe_reserved_dbinstances_offerings(params::Dict{String,<:Any})

Lists available reserved DB instance offerings.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceClass"`: The DB instance class filter value. Specify this parameter to show
  only the available offerings matching the specified DB instance class.
- `"Duration"`: Duration filter value, specified in years or seconds. Specify this
  parameter to show only reservations for this duration. Valid Values: 1 | 3 | 31536000 |
  94608000
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous request. If this
  parameter is specified, the response includes only records beyond the marker, up to the
  value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more than
  the MaxRecords value is available, a pagination token called a marker is included in the
  response so you can retrieve the remaining results. Default: 100 Constraints: Minimum 20,
  maximum 100.
- `"MultiAZ"`: Specifies whether to show only those reservations that support Multi-AZ.
- `"OfferingType"`: The offering type filter value. Specify this parameter to show only the
  available offerings matching the specified offering type. Valid Values: \"Partial Upfront\"
  | \"All Upfront\" | \"No Upfront\"
- `"ProductDescription"`: Product description filter value. Specify this parameter to show
  only the available offerings that contain the specified product description.  The results
  show offerings that partially match the filter value.
- `"ReservedDBInstancesOfferingId"`: The offering identifier filter value. Specify this
  parameter to show only the available offering that matches the specified reservation
  identifier. Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706
"""
function describe_reserved_dbinstances_offerings(;
    aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeReservedDBInstancesOfferings";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_reserved_dbinstances_offerings(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeReservedDBInstancesOfferings",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_source_regions()
    describe_source_regions(params::Dict{String,<:Any})

Returns a list of the source Amazon Web Services Regions where the current Amazon Web
Services Region can create a read replica, copy a DB snapshot from, or replicate automated
backups from. Use this operation to determine whether cross-Region features are supported
between other Regions and your current Region. This operation supports pagination. To
return information about the Regions that are enabled for your account, or all Regions, use
the EC2 operation DescribeRegions. For more information, see  DescribeRegions in the Amazon
EC2 API Reference.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
- `"Marker"`: An optional pagination token provided by a previous DescribeSourceRegions
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so you can retrieve the remaining results. Default: 100 Constraints:
  Minimum 20, maximum 100.
- `"RegionName"`: The source Amazon Web Services Region name. For example, us-east-1.
  Constraints:   Must specify a valid Amazon Web Services Region name.
"""
function describe_source_regions(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeSourceRegions"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_source_regions(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeSourceRegions",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_tenant_databases()
    describe_tenant_databases(params::Dict{String,<:Any})

Describes the tenant databases in a DB instance that uses the multi-tenant configuration.
Only RDS for Oracle CDB instances are supported.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceIdentifier"`: The user-supplied DB instance identifier, which must match the
  identifier of an existing instance owned by the Amazon Web Services account. This parameter
  isn't case-sensitive.
- `"Filters"`: A filter that specifies one or more database tenants to describe. Supported
  filters:    tenant-db-name - Tenant database names. The results list only includes
  information about the tenant databases that match these tenant DB names.
  tenant-database-resource-id - Tenant database resource identifiers.    dbi-resource-id - DB
  instance resource identifiers. The results list only includes information about the tenants
  contained within the DB instances identified by these resource identifiers.
- `"Marker"`: An optional pagination token provided by a previous DescribeTenantDatabases
  request. If this parameter is specified, the response includes only records beyond the
  marker, up to the value specified by MaxRecords.
- `"MaxRecords"`: The maximum number of records to include in the response. If more records
  exist than the specified MaxRecords value, a pagination token called a marker is included
  in the response so that you can retrieve the remaining results.
- `"TenantDBName"`: The user-supplied tenant database name, which must match the name of an
  existing tenant database on the specified DB instance owned by your Amazon Web Services
  account. This parameter isn’t case-sensitive.
"""
function describe_tenant_databases(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "DescribeTenantDatabases"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function describe_tenant_databases(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeTenantDatabases",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    describe_valid_dbinstance_modifications(dbinstance_identifier)
    describe_valid_dbinstance_modifications(dbinstance_identifier, params::Dict{String,<:Any})

You can call DescribeValidDBInstanceModifications to learn what modifications you can make
to your DB instance. You can use this information when you call ModifyDBInstance. This
command doesn't apply to RDS Custom.

# Arguments
- `dbinstance_identifier`: The customer identifier or the ARN of your DB instance.

"""
function describe_valid_dbinstance_modifications(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DescribeValidDBInstanceModifications",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function describe_valid_dbinstance_modifications(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DescribeValidDBInstanceModifications",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    disable_http_endpoint(resource_arn)
    disable_http_endpoint(resource_arn, params::Dict{String,<:Any})

Disables the HTTP endpoint for the specified DB cluster. Disabling this endpoint disables
RDS Data API. For more information, see Using RDS Data API in the Amazon Aurora User Guide.
 This operation applies only to Aurora PostgreSQL Serverless v2 and provisioned DB
clusters. To disable the HTTP endpoint for Aurora Serverless v1 DB clusters, use the
EnableHttpEndpoint parameter of the ModifyDBCluster operation.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the DB cluster.

"""
function disable_http_endpoint(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DisableHttpEndpoint",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function disable_http_endpoint(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DisableHttpEndpoint",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    download_dblog_file_portion(dbinstance_identifier, log_file_name)
    download_dblog_file_portion(dbinstance_identifier, log_file_name, params::Dict{String,<:Any})

Downloads all or a portion of the specified log file, up to 1 MB in size. This command
doesn't apply to RDS Custom.

# Arguments
- `dbinstance_identifier`: The customer-assigned name of the DB instance that contains the
  log files you want to list. Constraints:   Must match the identifier of an existing
  DBInstance.
- `log_file_name`: The name of the log file to be downloaded.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Marker"`: The pagination token provided in the previous request or \"0\". If the Marker
  parameter is specified the response includes only records beyond the marker until the end
  of the file or up to NumberOfLines.
- `"NumberOfLines"`: The number of lines to download. If the number of lines specified
  results in a file over 1 MB in size, the file is truncated at 1 MB in size. If the
  NumberOfLines parameter is specified, then the block of lines returned can be from the
  beginning or the end of the log file, depending on the value of the Marker parameter.   If
  neither Marker or NumberOfLines are specified, the entire log file is returned up to a
  maximum of 10000 lines, starting with the most recent log entries first.   If NumberOfLines
  is specified and Marker isn't specified, then the most recent lines from the end of the log
  file are returned.   If Marker is specified as \"0\", then the specified number of lines
  from the beginning of the log file are returned.   You can download the log file in blocks
  of lines by specifying the size of the block using the NumberOfLines parameter, and by
  specifying a value of \"0\" for the Marker parameter in your first request. Include the
  Marker value returned in the response as the Marker value for the next request, continuing
  until the AdditionalDataPending response element returns false.
"""
function download_dblog_file_portion(
    DBInstanceIdentifier, LogFileName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "DownloadDBLogFilePortion",
        Dict{String,Any}(
            "DBInstanceIdentifier" => DBInstanceIdentifier, "LogFileName" => LogFileName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function download_dblog_file_portion(
    DBInstanceIdentifier,
    LogFileName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "DownloadDBLogFilePortion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "LogFileName" => LogFileName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    enable_http_endpoint(resource_arn)
    enable_http_endpoint(resource_arn, params::Dict{String,<:Any})

Enables the HTTP endpoint for the DB cluster. By default, the HTTP endpoint isn't enabled.
When enabled, this endpoint provides a connectionless web service API (RDS Data API) for
running SQL queries on the Aurora DB cluster. You can also query your database from inside
the RDS console with the RDS query editor. For more information, see Using RDS Data API in
the Amazon Aurora User Guide.  This operation applies only to Aurora PostgreSQL Serverless
v2 and provisioned DB clusters. To enable the HTTP endpoint for Aurora Serverless v1 DB
clusters, use the EnableHttpEndpoint parameter of the ModifyDBCluster operation.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the DB cluster.

"""
function enable_http_endpoint(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "EnableHttpEndpoint",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function enable_http_endpoint(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "EnableHttpEndpoint",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    failover_dbcluster(dbcluster_identifier)
    failover_dbcluster(dbcluster_identifier, params::Dict{String,<:Any})

Forces a failover for a DB cluster. For an Aurora DB cluster, failover for a DB cluster
promotes one of the Aurora Replicas (read-only instances) in the DB cluster to be the
primary DB instance (the cluster writer). For a Multi-AZ DB cluster, after RDS terminates
the primary DB instance, the internal monitoring system detects that the primary DB
instance is unhealthy and promotes a readable standby (read-only instances) in the DB
cluster to be the primary DB instance (the cluster writer). Failover times are typically
less than 35 seconds. An Amazon Aurora DB cluster automatically fails over to an Aurora
Replica, if one exists, when the primary DB instance fails. A Multi-AZ DB cluster
automatically fails over to a readable standby DB instance when the primary DB instance
fails. To simulate a failure of a primary instance for testing, you can force a failover.
Because each instance in a DB cluster has its own endpoint address, make sure to clean up
and re-establish any existing connections that use those endpoint addresses when the
failover is complete. For more information on Amazon Aurora DB clusters, see  What is
Amazon Aurora? in the Amazon Aurora User Guide. For more information on Multi-AZ DB
clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The identifier of the DB cluster to force a failover for. This
  parameter isn't case-sensitive. Constraints:   Must match the identifier of an existing DB
  cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"TargetDBInstanceIdentifier"`: The name of the DB instance to promote to the primary DB
  instance. Specify the DB instance identifier for an Aurora Replica or a Multi-AZ readable
  standby in the DB cluster, for example mydbcluster-replica1. This setting isn't supported
  for RDS for MySQL Multi-AZ DB clusters.
"""
function failover_dbcluster(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "FailoverDBCluster",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function failover_dbcluster(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "FailoverDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    failover_global_cluster(global_cluster_identifier, target_db_cluster_identifier)
    failover_global_cluster(global_cluster_identifier, target_db_cluster_identifier, params::Dict{String,<:Any})

Promotes the specified secondary DB cluster to be the primary DB cluster in the global
database cluster to fail over or switch over a global database. Switchover operations were
previously called \"managed planned failovers.\"  Although this operation can be used
either to fail over or to switch over a global database cluster, its intended use is for
global database failover. To switch over a global database cluster, we recommend that you
use the SwitchoverGlobalCluster operation instead.  How you use this operation depends on
whether you are failing over or switching over your global database cluster:   Failing over
- Specify the AllowDataLoss parameter and don't specify the Switchover parameter.
Switching over - Specify the Switchover parameter or omit it, but don't specify the
AllowDataLoss parameter.    About failing over and switching over  While failing over and
switching over a global database cluster both change the primary DB cluster, you use these
operations for different reasons:    Failing over - Use this operation to respond to an
unplanned event, such as a Regional disaster in the primary Region. Failing over can result
in a loss of write transaction data that wasn't replicated to the chosen secondary before
the failover event occurred. However, the recovery process that promotes a DB instance on
the chosen seconday DB cluster to be the primary writer DB instance guarantees that the
data is in a transactionally consistent state. For more information about failing over an
Amazon Aurora global database, see Performing managed failovers for Aurora global databases
in the Amazon Aurora User Guide.    Switching over - Use this operation on a healthy global
database cluster for planned events, such as Regional rotation or to fail back to the
original primary DB cluster after a failover operation. With this operation, there is no
data loss. For more information about switching over an Amazon Aurora global database, see
Performing switchovers for Aurora global databases in the Amazon Aurora User Guide.

# Arguments
- `global_cluster_identifier`: The identifier of the global database cluster (Aurora global
  database) this operation should apply to. The identifier is the unique key assigned by the
  user when the Aurora global database is created. In other words, it's the name of the
  Aurora global database. Constraints:   Must match the identifier of an existing global
  database cluster.
- `target_db_cluster_identifier`: The identifier of the secondary Aurora DB cluster that
  you want to promote to the primary for the global database cluster. Use the Amazon Resource
  Name (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web
  Services Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowDataLoss"`: Specifies whether to allow data loss for this global database cluster
  operation. Allowing data loss triggers a global failover operation. If you don't specify
  AllowDataLoss, the global database cluster operation defaults to a switchover. Constraints:
    Can't be specified together with the Switchover parameter.
- `"Switchover"`: Specifies whether to switch over this global database cluster.
  Constraints:   Can't be specified together with the AllowDataLoss parameter.
"""
function failover_global_cluster(
    GlobalClusterIdentifier,
    TargetDbClusterIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "FailoverGlobalCluster",
        Dict{String,Any}(
            "GlobalClusterIdentifier" => GlobalClusterIdentifier,
            "TargetDbClusterIdentifier" => TargetDbClusterIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function failover_global_cluster(
    GlobalClusterIdentifier,
    TargetDbClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "FailoverGlobalCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalClusterIdentifier" => GlobalClusterIdentifier,
                    "TargetDbClusterIdentifier" => TargetDbClusterIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_name)
    list_tags_for_resource(resource_name, params::Dict{String,<:Any})

Lists all tags on an Amazon RDS resource. For an overview on tagging an Amazon RDS
resource, see Tagging Amazon RDS Resources in the Amazon RDS User Guide.

# Arguments
- `resource_name`: The Amazon RDS resource with tags to be listed. This value is an Amazon
  Resource Name (ARN). For information about creating an ARN, see  Constructing an ARN for
  Amazon RDS in the Amazon RDS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Filters"`: This parameter isn't currently supported.
"""
function list_tags_for_resource(
    ResourceName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ListTagsForResource",
        Dict{String,Any}("ResourceName" => ResourceName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    ResourceName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ListTagsForResource",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceName" => ResourceName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_activity_stream()
    modify_activity_stream(params::Dict{String,<:Any})

Changes the audit policy state of a database activity stream to either locked (default) or
unlocked. A locked policy is read-only, whereas an unlocked policy is read/write. If your
activity stream is started and locked, you can unlock it, customize your audit policy, and
then lock your activity stream. Restarting the activity stream isn't required. For more
information, see  Modifying a database activity stream in the Amazon RDS User Guide.  This
operation is supported for RDS for Oracle and Microsoft SQL Server.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AuditPolicyState"`: The audit policy state. When a policy is unlocked, it is
  read/write. When it is locked, it is read-only. You can edit your audit policy only when
  the activity stream is unlocked or stopped.
- `"ResourceArn"`: The Amazon Resource Name (ARN) of the RDS for Oracle or Microsoft SQL
  Server DB instance. For example, arn:aws:rds:us-east-1:12345667890:db:my-orcl-db.
"""
function modify_activity_stream(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "ModifyActivityStream"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function modify_activity_stream(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyActivityStream",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_certificates()
    modify_certificates(params::Dict{String,<:Any})

Override the system-default Secure Sockets Layer/Transport Layer Security (SSL/TLS)
certificate for Amazon RDS for new DB instances, or remove the override. By using this
operation, you can specify an RDS-approved SSL/TLS certificate for new DB instances that is
different from the default certificate provided by RDS. You can also use this operation to
remove the override, so that new DB instances use the default certificate provided by RDS.
You might need to override the default certificate in the following situations:   You
already migrated your applications to support the latest certificate authority (CA)
certificate, but the new CA certificate is not yet the RDS default CA certificate for the
specified Amazon Web Services Region.   RDS has already moved to a new default CA
certificate for the specified Amazon Web Services Region, but you are still in the process
of supporting the new CA certificate. In this case, you temporarily need additional time to
finish your application changes.   For more information about rotating your SSL/TLS
certificate for RDS DB engines, see  Rotating Your SSL/TLS Certificate in the Amazon RDS
User Guide. For more information about rotating your SSL/TLS certificate for Aurora DB
engines, see  Rotating Your SSL/TLS Certificate in the Amazon Aurora User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CertificateIdentifier"`: The new default certificate identifier to override the current
  one with. To determine the valid values, use the describe-certificates CLI command or the
  DescribeCertificates API operation.
- `"RemoveCustomerOverride"`: Specifies whether to remove the override for the default
  certificate. If the override is removed, the default certificate is the system default.
"""
function modify_certificates(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds("ModifyCertificates"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET)
end
function modify_certificates(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyCertificates", params; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end

"""
    modify_current_dbcluster_capacity(dbcluster_identifier)
    modify_current_dbcluster_capacity(dbcluster_identifier, params::Dict{String,<:Any})

Set the capacity of an Aurora Serverless v1 DB cluster to a specific value. Aurora
Serverless v1 scales seamlessly based on the workload on the DB cluster. In some cases, the
capacity might not scale fast enough to meet a sudden change in workload, such as a large
number of new transactions. Call ModifyCurrentDBClusterCapacity to set the capacity
explicitly. After this call sets the DB cluster capacity, Aurora Serverless v1 can
automatically scale the DB cluster based on the cooldown period for scaling up and the
cooldown period for scaling down. For more information about Aurora Serverless v1, see
Using Amazon Aurora Serverless v1 in the Amazon Aurora User Guide.  If you call
ModifyCurrentDBClusterCapacity with the default TimeoutAction, connections that prevent
Aurora Serverless v1 from finding a scaling point might be dropped. For more information
about scaling points, see  Autoscaling for Aurora Serverless v1 in the Amazon Aurora User
Guide.   This operation only applies to Aurora Serverless v1 DB clusters.

# Arguments
- `dbcluster_identifier`: The DB cluster identifier for the cluster being modified. This
  parameter isn't case-sensitive. Constraints:   Must match the identifier of an existing DB
  cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Capacity"`: The DB cluster capacity. When you change the capacity of a paused Aurora
  Serverless v1 DB cluster, it automatically resumes. Constraints:   For Aurora MySQL, valid
  capacity values are 1, 2, 4, 8, 16, 32, 64, 128, and 256.   For Aurora PostgreSQL, valid
  capacity values are 2, 4, 8, 16, 32, 64, 192, and 384.
- `"SecondsBeforeTimeout"`: The amount of time, in seconds, that Aurora Serverless v1 tries
  to find a scaling point to perform seamless scaling before enforcing the timeout action.
  The default is 300. Specify a value between 10 and 600 seconds.
- `"TimeoutAction"`: The action to take when the timeout is reached, either
  ForceApplyCapacityChange or RollbackCapacityChange.  ForceApplyCapacityChange, the default,
  sets the capacity to the specified value as soon as possible.  RollbackCapacityChange
  ignores the capacity change if a scaling point isn't found in the timeout period.
"""
function modify_current_dbcluster_capacity(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyCurrentDBClusterCapacity",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_current_dbcluster_capacity(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyCurrentDBClusterCapacity",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_custom_dbengine_version(engine, engine_version)
    modify_custom_dbengine_version(engine, engine_version, params::Dict{String,<:Any})

Modifies the status of a custom engine version (CEV). You can find CEVs to modify by
calling DescribeDBEngineVersions.  The MediaImport service that imports files from Amazon
S3 to create CEVs isn't integrated with Amazon Web Services CloudTrail. If you turn on data
logging for Amazon RDS in CloudTrail, calls to the ModifyCustomDbEngineVersion event aren't
logged. However, you might see calls from the API gateway that accesses your Amazon S3
bucket. These calls originate from the MediaImport service for the
ModifyCustomDbEngineVersion event.  For more information, see Modifying CEV status in the
Amazon RDS User Guide.

# Arguments
- `engine`: The database engine. RDS Custom for Oracle supports the following values:
  custom-oracle-ee     custom-oracle-ee-cdb     custom-oracle-se2     custom-oracle-se2-cdb
- `engine_version`: The custom engine version (CEV) that you want to modify. This option is
  required for RDS Custom for Oracle, but optional for Amazon RDS. The combination of Engine
  and EngineVersion is unique per customer per Amazon Web Services Region.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Description"`: An optional description of your CEV.
- `"Status"`: The availability status to be assigned to the CEV. Valid values are as
  follows:  available  You can use this CEV to create a new RDS Custom DB instance.  inactive
   You can create a new RDS Custom instance by restoring a DB snapshot with this CEV. You
  can't patch or create new instances with this CEV.   You can change any status to any
  status. A typical reason to change status is to prevent the accidental use of a CEV, or to
  make a deprecated CEV eligible for use again. For example, you might change the status of
  your CEV from available to inactive, and from inactive back to available. To change the
  availability status of the CEV, it must not currently be in use by an RDS Custom instance,
  snapshot, or automated backup.
"""
function modify_custom_dbengine_version(
    Engine, EngineVersion; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyCustomDBEngineVersion",
        Dict{String,Any}("Engine" => Engine, "EngineVersion" => EngineVersion);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_custom_dbengine_version(
    Engine,
    EngineVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyCustomDBEngineVersion",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("Engine" => Engine, "EngineVersion" => EngineVersion),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbcluster(dbcluster_identifier)
    modify_dbcluster(dbcluster_identifier, params::Dict{String,<:Any})

Modifies the settings of an Amazon Aurora DB cluster or a Multi-AZ DB cluster. You can
change one or more settings by specifying these parameters and the new values in the
request. For more information on Amazon Aurora DB clusters, see  What is Amazon Aurora? in
the Amazon Aurora User Guide. For more information on Multi-AZ DB clusters, see  Multi-AZ
DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The DB cluster identifier for the cluster being modified. This
  parameter isn't case-sensitive. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB
  clusters Constraints:   Must match the identifier of an existing DB cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocatedStorage"`: The amount of storage in gibibytes (GiB) to allocate to each DB
  instance in the Multi-AZ DB cluster. Valid for Cluster Type: Multi-AZ DB clusters only
- `"AllowEngineModeChange"`: Specifies whether engine mode changes from serverless to
  provisioned are allowed. Valid for Cluster Type: Aurora Serverless v1 DB clusters only
  Constraints:   You must allow engine mode changes when specifying a different value for the
  EngineMode parameter from the DB cluster's current engine mode.
- `"AllowMajorVersionUpgrade"`: Specifies whether major version upgrades are allowed. Valid
  for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Constraints:   You must allow
  major version upgrades when specifying a value for the EngineVersion parameter that is a
  different major version than the DB cluster's current version.
- `"ApplyImmediately"`: Specifies whether the modifications in this request and any pending
  modifications are asynchronously applied as soon as possible, regardless of the
  PreferredMaintenanceWindow setting for the DB cluster. If this parameter is disabled,
  changes to the DB cluster are applied during the next maintenance window. Most
  modifications can be applied immediately or during the next scheduled maintenance window.
  Some modifications, such as turning on deletion protection and changing the master
  password, are applied immediately—regardless of when you choose to apply them. By
  default, this parameter is disabled. Valid for Cluster Type: Aurora DB clusters and
  Multi-AZ DB clusters
- `"AutoMinorVersionUpgrade"`: Specifies whether minor engine upgrades are applied
  automatically to the DB cluster during the maintenance window. By default, minor engine
  upgrades are applied automatically. Valid for Cluster Type: Multi-AZ DB clusters only
- `"AwsBackupRecoveryPointArn"`: The Amazon Resource Name (ARN) of the recovery point in
  Amazon Web Services Backup.
- `"BacktrackWindow"`: The target backtrack window, in seconds. To disable backtracking,
  set this value to 0. Valid for Cluster Type: Aurora MySQL DB clusters only Default: 0
  Constraints:   If specified, this value must be set to a number from 0 to 259,200 (72
  hours).
- `"BackupRetentionPeriod"`: The number of days for which automated backups are retained.
  Specify a minimum value of 1. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB
  clusters Default: 1  Constraints:   Must be a value from 1 to 35.
- `"CACertificateIdentifier"`: The CA certificate identifier to use for the DB cluster's
  server certificate. For more information, see Using SSL/TLS to encrypt a connection to a DB
  instance in the Amazon RDS User Guide. Valid for Cluster Type: Multi-AZ DB clusters
- `"CloudwatchLogsExportConfiguration"`: The configuration setting for the log types to be
  enabled for export to CloudWatch Logs for a specific DB cluster. Valid for Cluster Type:
  Aurora DB clusters and Multi-AZ DB clusters The following values are valid for each DB
  engine:   Aurora MySQL - audit | error | general | slowquery    Aurora PostgreSQL -
  postgresql    RDS for MySQL - error | general | slowquery    RDS for PostgreSQL -
  postgresql | upgrade    For more information about exporting CloudWatch Logs for Amazon
  RDS, see  Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide.
  For more information about exporting CloudWatch Logs for Amazon Aurora, see Publishing
  Database Logs to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the DB cluster to
  snapshots of the DB cluster. The default is not to copy them. Valid for Cluster Type:
  Aurora DB clusters and Multi-AZ DB clusters
- `"DBClusterInstanceClass"`: The compute and memory capacity of each DB instance in the
  Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are available
  in all Amazon Web Services Regions, or for all database engines. For the full list of DB
  instance classes and availability for your engine, see  DB Instance Class in the Amazon RDS
  User Guide. Valid for Cluster Type: Multi-AZ DB clusters only
- `"DBClusterParameterGroupName"`: The name of the DB cluster parameter group to use for
  the DB cluster. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
- `"DBInstanceParameterGroupName"`: The name of the DB parameter group to apply to all
  instances of the DB cluster.  When you apply a parameter group using the
  DBInstanceParameterGroupName parameter, the DB cluster isn't rebooted automatically. Also,
  parameter changes are applied immediately rather than during the next maintenance window.
  Valid for Cluster Type: Aurora DB clusters only Default: The existing name setting
  Constraints:   The DB parameter group must be in the same DB parameter group family as this
  DB cluster.   The DBInstanceParameterGroupName parameter is valid in combination with the
  AllowMajorVersionUpgrade parameter for a major version upgrade only.
- `"DeletionProtection"`: Specifies whether the DB cluster has deletion protection enabled.
  The database can't be deleted when deletion protection is enabled. By default, deletion
  protection isn't enabled. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB
  clusters
- `"Domain"`: The Active Directory directory ID to move the DB cluster to. Specify none to
  remove the cluster from its current domain. The domain must be created prior to this
  operation. For more information, see Kerberos Authentication in the Amazon Aurora User
  Guide. Valid for Cluster Type: Aurora DB clusters only
- `"DomainIAMRoleName"`: The name of the IAM role to use when making API calls to the
  Directory Service. Valid for Cluster Type: Aurora DB clusters only
- `"EnableGlobalWriteForwarding"`: Specifies whether to enable this DB cluster to forward
  write operations to the primary cluster of a global cluster (Aurora global database). By
  default, write operations are not allowed on Aurora DB clusters that are secondary clusters
  in an Aurora global database. You can set this value only on Aurora DB clusters that are
  members of an Aurora global database. With this parameter enabled, a secondary cluster can
  forward writes to the current primary cluster, and the resulting changes are replicated
  back to this cluster. For the primary DB cluster of an Aurora global database, this value
  is used immediately if the primary is demoted by a global cluster API operation, but it
  does nothing until then. Valid for Cluster Type: Aurora DB clusters only
- `"EnableHttpEndpoint"`: Specifies whether to enable the HTTP endpoint for an Aurora
  Serverless v1 DB cluster. By default, the HTTP endpoint isn't enabled. When enabled, the
  HTTP endpoint provides a connectionless web service API (RDS Data API) for running SQL
  queries on the Aurora Serverless v1 DB cluster. You can also query your database from
  inside the RDS console with the RDS query editor. For more information, see Using RDS Data
  API in the Amazon Aurora User Guide.  This parameter applies only to Aurora Serverless v1
  DB clusters. To enable or disable the HTTP endpoint for an Aurora PostgreSQL Serverless v2
  or provisioned DB cluster, use the EnableHttpEndpoint and DisableHttpEndpoint operations.
  Valid for Cluster Type: Aurora DB clusters only
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. For more information, see  IAM Database Authentication in the Amazon
  Aurora User Guide. Valid for Cluster Type: Aurora DB clusters only
- `"EnableLimitlessDatabase"`: Specifies whether to enable Aurora Limitless Database. You
  must enable Aurora Limitless Database to create a DB shard group. Valid for: Aurora DB
  clusters only
- `"EnableLocalWriteForwarding"`: Specifies whether read replicas can forward write
  operations to the writer DB instance in the DB cluster. By default, write operations aren't
  allowed on reader DB instances. Valid for: Aurora DB clusters only
- `"EnablePerformanceInsights"`: Specifies whether to turn on Performance Insights for the
  DB cluster. For more information, see  Using Amazon Performance Insights in the Amazon RDS
  User Guide. Valid for Cluster Type: Multi-AZ DB clusters only
- `"EngineMode"`: The DB engine mode of the DB cluster, either provisioned or serverless.
  The DB engine mode can be modified only from serverless to provisioned.  For more
  information, see  CreateDBCluster. Valid for Cluster Type: Aurora DB clusters only
- `"EngineVersion"`: The version number of the database engine to which you want to
  upgrade. Changing this parameter results in an outage. The change is applied during the
  next maintenance window unless ApplyImmediately is enabled. If the cluster that you're
  modifying has one or more read replicas, all replicas must be running an engine version
  that's the same or later than the version you specify. To list all of the available engine
  versions for Aurora MySQL, use the following command:  aws rds describe-db-engine-versions
  --engine aurora-mysql --query \"DBEngineVersions[].EngineVersion\"  To list all of the
  available engine versions for Aurora PostgreSQL, use the following command:  aws rds
  describe-db-engine-versions --engine aurora-postgresql --query
  \"DBEngineVersions[].EngineVersion\"  To list all of the available engine versions for RDS
  for MySQL, use the following command:  aws rds describe-db-engine-versions --engine mysql
  --query \"DBEngineVersions[].EngineVersion\"  To list all of the available engine versions
  for RDS for PostgreSQL, use the following command:  aws rds describe-db-engine-versions
  --engine postgres --query \"DBEngineVersions[].EngineVersion\"  Valid for Cluster Type:
  Aurora DB clusters and Multi-AZ DB clusters
- `"Iops"`: The amount of Provisioned IOPS (input/output operations per second) to be
  initially allocated for each DB instance in the Multi-AZ DB cluster. For information about
  valid IOPS values, see Amazon RDS Provisioned IOPS storage in the Amazon RDS User Guide.
  Valid for Cluster Type: Multi-AZ DB clusters only Constraints:   Must be a multiple between
  .5 and 50 of the storage amount for the DB cluster.
- `"ManageMasterUserPassword"`: Specifies whether to manage the master user password with
  Amazon Web Services Secrets Manager. If the DB cluster doesn't manage the master user
  password with Amazon Web Services Secrets Manager, you can turn on this management. In this
  case, you can't specify MasterUserPassword. If the DB cluster already manages the master
  user password with Amazon Web Services Secrets Manager, and you specify that the master
  user password is not managed with Amazon Web Services Secrets Manager, then you must
  specify MasterUserPassword. In this case, RDS deletes the secret and uses the new password
  for the master user specified by MasterUserPassword. For more information, see Password
  management with Amazon Web Services Secrets Manager in the Amazon RDS User Guide and
  Password management with Amazon Web Services Secrets Manager in the Amazon Aurora User
  Guide.  Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
- `"MasterUserPassword"`: The new password for the master database user. Valid for Cluster
  Type: Aurora DB clusters and Multi-AZ DB clusters Constraints:   Must contain from 8 to 41
  characters.   Can contain any printable ASCII character except \"/\", \"\"\", or \"@\".
  Can't be specified if ManageMasterUserPassword is turned on.
- `"MasterUserSecretKmsKeyId"`: The Amazon Web Services KMS key identifier to encrypt a
  secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
  This setting is valid only if both of the following conditions are met:   The DB cluster
  doesn't manage the master user password in Amazon Web Services Secrets Manager. If the DB
  cluster already manages the master user password in Amazon Web Services Secrets Manager,
  you can't change the KMS key that is used to encrypt the secret.   You are turning on
  ManageMasterUserPassword to manage the master user password in Amazon Web Services Secrets
  Manager. If you are turning on ManageMasterUserPassword and don't specify
  MasterUserSecretKmsKeyId, then the aws/secretsmanager KMS key is used to encrypt the
  secret. If the secret is in a different Amazon Web Services account, then you can't use the
  aws/secretsmanager KMS key to encrypt the secret, and you must use a customer managed KMS
  key.   The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or
  alias name for the KMS key. To use a KMS key in a different Amazon Web Services account,
  specify the key ARN or alias ARN. There is a default KMS key for your Amazon Web Services
  account. Your Amazon Web Services account has a different default KMS key for each Amazon
  Web Services Region. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
- `"MonitoringInterval"`: The interval, in seconds, between points when Enhanced Monitoring
  metrics are collected for the DB cluster. To turn off collecting Enhanced Monitoring
  metrics, specify 0. If MonitoringRoleArn is specified, also set MonitoringInterval to a
  value other than 0. Valid for Cluster Type: Multi-AZ DB clusters only Valid Values: 0 | 1 |
  5 | 10 | 15 | 30 | 60  Default: 0
- `"MonitoringRoleArn"`: The Amazon Resource Name (ARN) for the IAM role that permits RDS
  to send Enhanced Monitoring metrics to Amazon CloudWatch Logs. An example is
  arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role, see
  To create an IAM role for Amazon RDS Enhanced Monitoring in the Amazon RDS User Guide.  If
  MonitoringInterval is set to a value other than 0, supply a MonitoringRoleArn value. Valid
  for Cluster Type: Multi-AZ DB clusters only
- `"NetworkType"`: The network type of the DB cluster. The network type is determined by
  the DBSubnetGroup specified for the DB cluster. A DBSubnetGroup can support only the IPv4
  protocol or the IPv4 and the IPv6 protocols (DUAL). For more information, see  Working with
  a DB instance in a VPC in the Amazon Aurora User Guide.  Valid for Cluster Type: Aurora DB
  clusters only Valid Values: IPV4 | DUAL
- `"NewDBClusterIdentifier"`: The new DB cluster identifier for the DB cluster when
  renaming a DB cluster. This value is stored as a lowercase string. Valid for Cluster Type:
  Aurora DB clusters and Multi-AZ DB clusters Constraints:   Must contain from 1 to 63
  letters, numbers, or hyphens.   The first character must be a letter.   Can't end with a
  hyphen or contain two consecutive hyphens.   Example: my-cluster2
- `"OptionGroupName"`: The option group to associate the DB cluster with. DB clusters are
  associated with a default option group that can't be modified.
- `"PerformanceInsightsKMSKeyId"`: The Amazon Web Services KMS key identifier for
  encryption of Performance Insights data. The Amazon Web Services KMS key identifier is the
  key ARN, key ID, alias ARN, or alias name for the KMS key. If you don't specify a value for
  PerformanceInsightsKMSKeyId, then Amazon RDS uses your default KMS key. There is a default
  KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
  different default KMS key for each Amazon Web Services Region. Valid for Cluster Type:
  Multi-AZ DB clusters only
- `"PerformanceInsightsRetentionPeriod"`: The number of days to retain Performance Insights
  data. Valid for Cluster Type: Multi-AZ DB clusters only Valid Values:    7     month * 31,
  where month is a number of months from 1-23. Examples: 93 (3 months * 31), 341 (11 months *
  31), 589 (19 months * 31)    731    Default: 7 days If you specify a retention period that
  isn't valid, such as 94, Amazon RDS issues an error.
- `"Port"`: The port number on which the DB cluster accepts connections. Valid for Cluster
  Type: Aurora DB clusters only Valid Values: 1150-65535  Default: The same port as the
  original DB cluster.
- `"PreferredBackupWindow"`: The daily time range during which automated backups are
  created if automated backups are enabled, using the BackupRetentionPeriod parameter. The
  default is a 30-minute window selected at random from an 8-hour block of time for each
  Amazon Web Services Region. To view the time blocks available, see  Backup window in the
  Amazon Aurora User Guide. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB
  clusters Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in Universal
  Coordinated Time (UTC).   Must not conflict with the preferred maintenance window.   Must
  be at least 30 minutes.
- `"PreferredMaintenanceWindow"`: The weekly time range during which system maintenance can
  occur, in Universal Coordinated Time (UTC). Valid for Cluster Type: Aurora DB clusters and
  Multi-AZ DB clusters The default is a 30-minute window selected at random from an 8-hour
  block of time for each Amazon Web Services Region, occurring on a random day of the week.
  To see the time blocks available, see  Adjusting the Preferred DB Cluster Maintenance
  Window in the Amazon Aurora User Guide. Constraints:   Must be in the format
  ddd:hh24:mi-ddd:hh24:mi.   Days must be one of Mon | Tue | Wed | Thu | Fri | Sat | Sun.
  Must be in Universal Coordinated Time (UTC).   Must be at least 30 minutes.
- `"RotateMasterUserPassword"`: Specifies whether to rotate the secret managed by Amazon
  Web Services Secrets Manager for the master user password. This setting is valid only if
  the master user password is managed by RDS in Amazon Web Services Secrets Manager for the
  DB cluster. The secret value contains the updated password. For more information, see
  Password management with Amazon Web Services Secrets Manager in the Amazon RDS User Guide
  and Password management with Amazon Web Services Secrets Manager in the Amazon Aurora User
  Guide.  Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Constraints:
  You must apply the change immediately when rotating the master user password.
- `"ScalingConfiguration"`: The scaling properties of the DB cluster. You can only modify
  scaling properties for DB clusters in serverless DB engine mode. Valid for Cluster Type:
  Aurora DB clusters only
- `"ServerlessV2ScalingConfiguration"`:
- `"StorageType"`: The storage type to associate with the DB cluster. For information on
  storage types for Aurora DB clusters, see Storage configurations for Amazon Aurora DB
  clusters. For information on storage types for Multi-AZ DB clusters, see Settings for
  creating Multi-AZ DB clusters. When specified for a Multi-AZ DB cluster, a value for the
  Iops parameter is required. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB
  clusters Valid Values:   Aurora DB clusters - aurora | aurora-iopt1    Multi-AZ DB clusters
  - io1 | io2 | gp3    Default:   Aurora DB clusters - aurora    Multi-AZ DB clusters - io1
- `"VpcSecurityGroupIds"`: A list of EC2 VPC security groups to associate with this DB
  cluster. Valid for Cluster Type: Aurora DB clusters and Multi-AZ DB clusters
"""
function modify_dbcluster(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBCluster",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbcluster(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbcluster_endpoint(dbcluster_endpoint_identifier)
    modify_dbcluster_endpoint(dbcluster_endpoint_identifier, params::Dict{String,<:Any})

Modifies the properties of an endpoint in an Amazon Aurora DB cluster.  This operation only
applies to Aurora DB clusters.

# Arguments
- `dbcluster_endpoint_identifier`: The identifier of the endpoint to modify. This parameter
  is stored as a lowercase string.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EndpointType"`: The type of the endpoint. One of: READER, WRITER, ANY.
- `"ExcludedMembers"`: List of DB instance identifiers that aren't part of the custom
  endpoint group. All other eligible instances are reachable through the custom endpoint.
  Only relevant if the list of static members is empty.
- `"StaticMembers"`: List of DB instance identifiers that are part of the custom endpoint
  group.
"""
function modify_dbcluster_endpoint(
    DBClusterEndpointIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBClusterEndpoint",
        Dict{String,Any}("DBClusterEndpointIdentifier" => DBClusterEndpointIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbcluster_endpoint(
    DBClusterEndpointIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBClusterEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterEndpointIdentifier" => DBClusterEndpointIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbcluster_parameter_group(dbcluster_parameter_group_name, parameter)
    modify_dbcluster_parameter_group(dbcluster_parameter_group_name, parameter, params::Dict{String,<:Any})

Modifies the parameters of a DB cluster parameter group. To modify more than one parameter,
submit a list of the following: ParameterName, ParameterValue, and ApplyMethod. A maximum
of 20 parameters can be modified in a single request.  After you create a DB cluster
parameter group, you should wait at least 5 minutes before creating your first DB cluster
that uses that DB cluster parameter group as the default parameter group. This allows
Amazon RDS to fully complete the create operation before the parameter group is used as the
default for a new DB cluster. This is especially important for parameters that are critical
when creating the default database for a DB cluster, such as the character set for the
default database defined by the character_set_database parameter. You can use the Parameter
Groups option of the Amazon RDS console or the DescribeDBClusterParameters operation to
verify that your DB cluster parameter group has been created or modified. If the modified
DB cluster parameter group is used by an Aurora Serverless v1 cluster, Aurora applies the
update immediately. The cluster restart might interrupt your workload. In that case, your
application must reopen any connections and retry any transactions that were active when
the parameter changes took effect.  For more information on Amazon Aurora DB clusters, see
What is Amazon Aurora? in the Amazon Aurora User Guide. For more information on Multi-AZ DB
clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_parameter_group_name`: The name of the DB cluster parameter group to modify.
- `parameter`: A list of parameters in the DB cluster parameter group to modify. Valid
  Values (for the application method): immediate | pending-reboot   You can use the immediate
  value with dynamic parameters only. You can use the pending-reboot value for both dynamic
  and static parameters. When the application method is immediate, changes to dynamic
  parameters are applied immediately to the DB clusters associated with the parameter group.
  When the application method is pending-reboot, changes to dynamic and static parameters are
  applied after a reboot without failover to the DB clusters associated with the parameter
  group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Parameters"`: A list of parameters in the DB cluster parameter group to modify. Valid
  Values (for the application method): immediate | pending-reboot   You can use the immediate
  value with dynamic parameters only. You can use the pending-reboot value for both dynamic
  and static parameters. When the application method is immediate, changes to dynamic
  parameters are applied immediately to the DB clusters associated with the parameter group.
  When the application method is pending-reboot, changes to dynamic and static parameters are
  applied after a reboot without failover to the DB clusters associated with the parameter
  group.
"""
function modify_dbcluster_parameter_group(
    DBClusterParameterGroupName,
    Parameter;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBClusterParameterGroup",
        Dict{String,Any}(
            "DBClusterParameterGroupName" => DBClusterParameterGroupName,
            "Parameter" => Parameter,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbcluster_parameter_group(
    DBClusterParameterGroupName,
    Parameter,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterParameterGroupName" => DBClusterParameterGroupName,
                    "Parameter" => Parameter,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbcluster_snapshot_attribute(attribute_name, dbcluster_snapshot_identifier)
    modify_dbcluster_snapshot_attribute(attribute_name, dbcluster_snapshot_identifier, params::Dict{String,<:Any})

Adds an attribute and values to, or removes an attribute and values from, a manual DB
cluster snapshot. To share a manual DB cluster snapshot with other Amazon Web Services
accounts, specify restore as the AttributeName and use the ValuesToAdd parameter to add a
list of IDs of the Amazon Web Services accounts that are authorized to restore the manual
DB cluster snapshot. Use the value all to make the manual DB cluster snapshot public, which
means that it can be copied or restored by all Amazon Web Services accounts.  Don't add the
all value for any manual DB cluster snapshots that contain private information that you
don't want available to all Amazon Web Services accounts.  If a manual DB cluster snapshot
is encrypted, it can be shared, but only by specifying a list of authorized Amazon Web
Services account IDs for the ValuesToAdd parameter. You can't use all as a value for that
parameter in this case. To view which Amazon Web Services accounts have access to copy or
restore a manual DB cluster snapshot, or whether a manual DB cluster snapshot is public or
private, use the DescribeDBClusterSnapshotAttributes API operation. The accounts are
returned as values for the restore attribute.

# Arguments
- `attribute_name`: The name of the DB cluster snapshot attribute to modify. To manage
  authorization for other Amazon Web Services accounts to copy or restore a manual DB cluster
  snapshot, set this value to restore.  To view the list of attributes available to modify,
  use the DescribeDBClusterSnapshotAttributes API operation.
- `dbcluster_snapshot_identifier`: The identifier for the DB cluster snapshot to modify the
  attributes for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ValuesToAdd"`: A list of DB cluster snapshot attributes to add to the attribute
  specified by AttributeName. To authorize other Amazon Web Services accounts to copy or
  restore a manual DB cluster snapshot, set this list to include one or more Amazon Web
  Services account IDs, or all to make the manual DB cluster snapshot restorable by any
  Amazon Web Services account. Do not add the all value for any manual DB cluster snapshots
  that contain private information that you don't want available to all Amazon Web Services
  accounts.
- `"ValuesToRemove"`: A list of DB cluster snapshot attributes to remove from the attribute
  specified by AttributeName. To remove authorization for other Amazon Web Services accounts
  to copy or restore a manual DB cluster snapshot, set this list to include one or more
  Amazon Web Services account identifiers, or all to remove authorization for any Amazon Web
  Services account to copy or restore the DB cluster snapshot. If you specify all, an Amazon
  Web Services account whose account ID is explicitly added to the restore attribute can
  still copy or restore a manual DB cluster snapshot.
"""
function modify_dbcluster_snapshot_attribute(
    AttributeName,
    DBClusterSnapshotIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBClusterSnapshotAttribute",
        Dict{String,Any}(
            "AttributeName" => AttributeName,
            "DBClusterSnapshotIdentifier" => DBClusterSnapshotIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbcluster_snapshot_attribute(
    AttributeName,
    DBClusterSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBClusterSnapshotAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AttributeName" => AttributeName,
                    "DBClusterSnapshotIdentifier" => DBClusterSnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbinstance(dbinstance_identifier)
    modify_dbinstance(dbinstance_identifier, params::Dict{String,<:Any})

Modifies settings for a DB instance. You can change one or more database configuration
parameters by specifying these parameters and the new values in the request. To learn what
modifications you can make to your DB instance, call DescribeValidDBInstanceModifications
before you call ModifyDBInstance.

# Arguments
- `dbinstance_identifier`: The identifier of DB instance to modify. This value is stored as
  a lowercase string. Constraints:   Must match the identifier of an existing DB instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocatedStorage"`: The new amount of storage in gibibytes (GiB) to allocate for the DB
  instance. For RDS for Db2, MariaDB, RDS for MySQL, RDS for Oracle, and RDS for PostgreSQL,
  the value supplied must be at least 10% greater than the current value. Values that are not
  at least 10% greater than the existing value are rounded up so that they are 10% greater
  than the current value. For the valid values for allocated storage for each engine, see
  CreateDBInstance. Constraints:   When you increase the allocated storage for a DB instance
  that uses Provisioned IOPS (gp3, io1, or io2 storage type), you must also specify the Iops
  parameter. You can use the current value for Iops.
- `"AllowMajorVersionUpgrade"`: Specifies whether major version upgrades are allowed.
  Changing this parameter doesn't result in an outage and the change is asynchronously
  applied as soon as possible. This setting doesn't apply to RDS Custom DB instances.
  Constraints:   Major version upgrades must be allowed when specifying a value for the
  EngineVersion parameter that's a different major version than the DB instance's current
  version.
- `"ApplyImmediately"`: Specifies whether the modifications in this request and any pending
  modifications are asynchronously applied as soon as possible, regardless of the
  PreferredMaintenanceWindow setting for the DB instance. By default, this parameter is
  disabled. If this parameter is disabled, changes to the DB instance are applied during the
  next maintenance window. Some parameter changes can cause an outage and are applied on the
  next call to RebootDBInstance, or the next failure reboot. Review the table of parameters
  in Modifying a DB Instance in the Amazon RDS User Guide to see the impact of enabling or
  disabling ApplyImmediately for each modified parameter and to determine when the changes
  are applied.
- `"AutoMinorVersionUpgrade"`: Specifies whether minor version upgrades are applied
  automatically to the DB instance during the maintenance window. An outage occurs when all
  the following conditions are met:   The automatic upgrade is enabled for the maintenance
  window.   A newer minor version is available.   RDS has enabled automatic patching for the
  engine version.   If any of the preceding conditions isn't met, Amazon RDS applies the
  change as soon as possible and doesn't cause an outage. For an RDS Custom DB instance,
  don't enable this setting. Otherwise, the operation returns an error.
- `"AutomationMode"`: The automation mode of the RDS Custom DB instance. If full, the DB
  instance automates monitoring and instance recovery. If all paused, the instance pauses
  automation for the duration set by ResumeFullAutomationModeMinutes.
- `"AwsBackupRecoveryPointArn"`: The Amazon Resource Name (ARN) of the recovery point in
  Amazon Web Services Backup. This setting doesn't apply to RDS Custom DB instances.
- `"BackupRetentionPeriod"`: The number of days to retain automated backups. Setting this
  parameter to a positive number enables backups. Setting this parameter to 0 disables
  automated backups.  Enabling and disabling backups can result in a brief I/O suspension
  that lasts from a few seconds to a few minutes, depending on the size and class of your DB
  instance.  These changes are applied during the next maintenance window unless the
  ApplyImmediately parameter is enabled for this request. If you change the parameter from
  one non-zero value to another non-zero value, the change is asynchronously applied as soon
  as possible. This setting doesn't apply to Amazon Aurora DB instances. The retention period
  for automated backups is managed by the DB cluster. For more information, see
  ModifyDBCluster. Default: Uses existing setting Constraints:   Must be a value from 0 to
  35.   Can't be set to 0 if the DB instance is a source to read replicas.   Can't be set to
  0 for an RDS Custom for Oracle DB instance.
- `"CACertificateIdentifier"`: The CA certificate identifier to use for the DB instance's
  server certificate. This setting doesn't apply to RDS Custom DB instances. For more
  information, see Using SSL/TLS to encrypt a connection to a DB instance in the Amazon RDS
  User Guide and  Using SSL/TLS to encrypt a connection to a DB cluster in the Amazon Aurora
  User Guide.
- `"CertificateRotationRestart"`: Specifies whether the DB instance is restarted when you
  rotate your SSL/TLS certificate. By default, the DB instance is restarted when you rotate
  your SSL/TLS certificate. The certificate is not updated until the DB instance is
  restarted.  Set this parameter only if you are not using SSL/TLS to connect to the DB
  instance.  If you are using SSL/TLS to connect to the DB instance, follow the appropriate
  instructions for your DB engine to rotate your SSL/TLS certificate:   For more information
  about rotating your SSL/TLS certificate for RDS DB engines, see  Rotating Your SSL/TLS
  Certificate. in the Amazon RDS User Guide.    For more information about rotating your
  SSL/TLS certificate for Aurora DB engines, see  Rotating Your SSL/TLS Certificate in the
  Amazon Aurora User Guide.   This setting doesn't apply to RDS Custom DB instances.
- `"CloudwatchLogsExportConfiguration"`: The log types to be enabled for export to
  CloudWatch Logs for a specific DB instance. A change to the
  CloudwatchLogsExportConfiguration parameter is always applied to the DB instance
  immediately. Therefore, the ApplyImmediately parameter has no effect. This setting doesn't
  apply to RDS Custom DB instances.
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the DB instance to
  snapshots of the DB instance. By default, tags aren't copied. This setting doesn't apply to
  Amazon Aurora DB instances. Copying tags to snapshots is managed by the DB cluster. Setting
  this value for an Aurora DB instance has no effect on the DB cluster setting. For more
  information, see ModifyDBCluster.
- `"DBInstanceClass"`: The new compute and memory capacity of the DB instance, for example
  db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions,
  or for all database engines. For the full list of DB instance classes, and availability for
  your engine, see DB Instance Class in the Amazon RDS User Guide or Aurora DB instance
  classes in the Amazon Aurora User Guide. For RDS Custom, see DB instance class support for
  RDS Custom for Oracle and  DB instance class support for RDS Custom for SQL Server. If you
  modify the DB instance class, an outage occurs during the change. The change is applied
  during the next maintenance window, unless you specify ApplyImmediately in your request.
  Default: Uses existing setting Constraints:   If you are modifying the DB instance class
  and upgrading the engine version at the same time, the currently running engine version
  must be supported on the specified DB instance class. Otherwise, the operation returns an
  error. In this case, first run the operation to upgrade the engine version, and then run it
  again to modify the DB instance class.
- `"DBParameterGroupName"`: The name of the DB parameter group to apply to the DB instance.
  Changing this setting doesn't result in an outage. The parameter group name itself is
  changed immediately, but the actual parameter changes are not applied until you reboot the
  instance without failover. In this case, the DB instance isn't rebooted automatically, and
  the parameter changes aren't applied during the next maintenance window. However, if you
  modify dynamic parameters in the newly associated DB parameter group, these changes are
  applied immediately without a reboot. This setting doesn't apply to RDS Custom DB
  instances. Default: Uses existing setting Constraints:   Must be in the same DB parameter
  group family as the DB instance.
- `"DBPortNumber"`: The port number on which the database accepts connections. The value of
  the DBPortNumber parameter must not match any of the port values specified for options in
  the option group for the DB instance. If you change the DBPortNumber value, your database
  restarts regardless of the value of the ApplyImmediately parameter. This setting doesn't
  apply to RDS Custom DB instances. Valid Values: 1150-65535  Default:   Amazon Aurora - 3306
     RDS for Db2 - 50000    RDS for MariaDB - 3306    RDS for Microsoft SQL Server - 1433
  RDS for MySQL - 3306    RDS for Oracle - 1521    RDS for PostgreSQL - 5432    Constraints:
   For RDS for Microsoft SQL Server, the value can't be 1234, 1434, 3260, 3343, 3389, 47001,
  or 49152-49156.
- `"DBSecurityGroups"`: A list of DB security groups to authorize on this DB instance.
  Changing this setting doesn't result in an outage and the change is asynchronously applied
  as soon as possible. This setting doesn't apply to RDS Custom DB instances. Constraints:
  If supplied, must match existing DB security groups.
- `"DBSubnetGroupName"`: The new DB subnet group for the DB instance. You can use this
  parameter to move your DB instance to a different VPC. If your DB instance isn't in a VPC,
  you can also use this parameter to move your DB instance into a VPC. For more information,
  see Working with a DB instance in a VPC in the Amazon RDS User Guide. Changing the subnet
  group causes an outage during the change. The change is applied during the next maintenance
  window, unless you enable ApplyImmediately. This setting doesn't apply to RDS Custom DB
  instances. Constraints:   If supplied, must match existing DB subnet group.   Example:
  mydbsubnetgroup
- `"DedicatedLogVolume"`: Indicates whether the DB instance has a dedicated log volume
  (DLV) enabled.
- `"DeletionProtection"`: Specifies whether the DB instance has deletion protection
  enabled. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled. For more information, see  Deleting a DB Instance. This
  setting doesn't apply to Amazon Aurora DB instances. You can enable or disable deletion
  protection for the DB cluster. For more information, see ModifyDBCluster. DB instances in a
  DB cluster can be deleted even when deletion protection is enabled for the DB cluster.
- `"DisableDomain"`: Specifies whether to remove the DB instance from the Active Directory
  domain.
- `"Domain"`: The Active Directory directory ID to move the DB instance to. Specify none to
  remove the instance from its current domain. You must create the domain before this
  operation. Currently, you can create only Db2, MySQL, Microsoft SQL Server, Oracle, and
  PostgreSQL DB instances in an Active Directory Domain. For more information, see  Kerberos
  Authentication in the Amazon RDS User Guide. This setting doesn't apply to RDS Custom DB
  instances.
- `"DomainAuthSecretArn"`: The ARN for the Secrets Manager secret with the credentials for
  the user joining the domain. Example:
  arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456
- `"DomainDnsIps"`: The IPv4 DNS IP addresses of your primary and secondary Active
  Directory domain controllers. Constraints:   Two IP addresses must be provided. If there
  isn't a secondary domain controller, use the IP address of the primary domain controller
  for both entries in the list.   Example: 123.124.125.126,234.235.236.237
- `"DomainFqdn"`: The fully qualified domain name (FQDN) of an Active Directory domain.
  Constraints:   Can't be longer than 64 characters.   Example:
  mymanagedADtest.mymanagedAD.mydomain
- `"DomainIAMRoleName"`: The name of the IAM role to use when making API calls to the
  Directory Service. This setting doesn't apply to RDS Custom DB instances.
- `"DomainOu"`: The Active Directory organizational unit for your DB instance to join.
  Constraints:   Must be in the distinguished name format.   Can't be longer than 64
  characters.   Example: OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain
- `"EnableCustomerOwnedIp"`: Specifies whether to enable a customer-owned IP address (CoIP)
  for an RDS on Outposts DB instance. A CoIP provides local or external connectivity to
  resources in your Outpost subnets through your on-premises network. For some use cases, a
  CoIP can provide lower latency for connections to the DB instance from outside of its
  virtual private cloud (VPC) on your local network. For more information about RDS on
  Outposts, see Working with Amazon RDS on Amazon Web Services Outposts in the Amazon RDS
  User Guide. For more information about CoIPs, see Customer-owned IP addresses in the Amazon
  Web Services Outposts User Guide.
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. This setting doesn't apply to Amazon Aurora. Mapping Amazon Web
  Services IAM accounts to database accounts is managed by the DB cluster. For more
  information about IAM database authentication, see  IAM Database Authentication for MySQL
  and PostgreSQL in the Amazon RDS User Guide.  This setting doesn't apply to RDS Custom DB
  instances.
- `"EnablePerformanceInsights"`: Specifies whether to enable Performance Insights for the
  DB instance. For more information, see Using Amazon Performance Insights in the Amazon RDS
  User Guide. This setting doesn't apply to RDS Custom DB instances.
- `"Engine"`: The target Oracle DB engine when you convert a non-CDB to a CDB. This
  intermediate step is necessary to upgrade an Oracle Database 19c non-CDB to an Oracle
  Database 21c CDB. Note the following requirements:   Make sure that you specify
  oracle-ee-cdb or oracle-se2-cdb.   Make sure that your DB engine runs Oracle Database 19c
  with an April 2021 or later RU.   Note the following limitations:   You can't convert a CDB
  to a non-CDB.   You can't convert a replica database.   You can't convert a non-CDB to a
  CDB and upgrade the engine version in the same command.   You can't convert the existing
  custom parameter or option group when it has options or parameters that are permanent or
  persistent. In this situation, the DB instance reverts to the default option and parameter
  group. To avoid reverting to the default, specify a new parameter group with
  --db-parameter-group-name and a new option group with --option-group-name.
- `"EngineVersion"`: The version number of the database engine to upgrade to. Changing this
  parameter results in an outage and the change is applied during the next maintenance window
  unless the ApplyImmediately parameter is enabled for this request. For major version
  upgrades, if a nondefault DB parameter group is currently in use, a new DB parameter group
  in the DB parameter group family for the new engine version must be specified. The new DB
  parameter group can be the default for that DB parameter group family. If you specify only
  a major version, Amazon RDS updates the DB instance to the default minor version if the
  current minor version is lower. For information about valid engine versions, see
  CreateDBInstance, or call DescribeDBEngineVersions. If the instance that you're modifying
  is acting as a read replica, the engine version that you specify must be the same or higher
  than the version that the source DB instance or cluster is running. In RDS Custom for
  Oracle, this parameter is supported for read replicas only if they are in the
  PATCH_DB_FAILURE lifecycle. Constraints:   If you are upgrading the engine version and
  modifying the DB instance class at the same time, the currently running engine version must
  be supported on the specified DB instance class. Otherwise, the operation returns an error.
  In this case, first run the operation to upgrade the engine version, and then run it again
  to modify the DB instance class.
- `"Iops"`: The new Provisioned IOPS (I/O operations per second) value for the RDS
  instance. Changing this setting doesn't result in an outage and the change is applied
  during the next maintenance window unless the ApplyImmediately parameter is enabled for
  this request. If you are migrating from Provisioned IOPS to standard storage, set this
  value to 0. The DB instance will require a reboot for the change in storage type to take
  effect. If you choose to migrate your DB instance from using standard storage to using
  Provisioned IOPS, or from using Provisioned IOPS to using standard storage, the process can
  take time. The duration of the migration depends on several factors such as database load,
  storage size, storage type (standard or Provisioned IOPS), amount of IOPS provisioned (if
  any), and the number of prior scale storage operations. Typical migration times are under
  24 hours, but the process can take up to several days in some cases. During the migration,
  the DB instance is available for use, but might experience performance degradation. While
  the migration takes place, nightly backups for the instance are suspended. No other Amazon
  RDS operations can take place for the instance, including modifying the instance, rebooting
  the instance, deleting the instance, creating a read replica for the instance, and creating
  a DB snapshot of the instance. Constraints:   For RDS for MariaDB, RDS for MySQL, RDS for
  Oracle, and RDS for PostgreSQL - The value supplied must be at least 10% greater than the
  current value. Values that are not at least 10% greater than the existing value are rounded
  up so that they are 10% greater than the current value.   When you increase the Provisioned
  IOPS, you must also specify the AllocatedStorage parameter. You can use the current value
  for AllocatedStorage.   Default: Uses existing setting
- `"LicenseModel"`: The license model for the DB instance. This setting doesn't apply to
  Amazon Aurora or RDS Custom DB instances. Valid Values:   RDS for Db2 -
  bring-your-own-license    RDS for MariaDB - general-public-license    RDS for Microsoft SQL
  Server - license-included    RDS for MySQL - general-public-license    RDS for Oracle -
  bring-your-own-license | license-included    RDS for PostgreSQL - postgresql-license
- `"ManageMasterUserPassword"`: Specifies whether to manage the master user password with
  Amazon Web Services Secrets Manager. If the DB instance doesn't manage the master user
  password with Amazon Web Services Secrets Manager, you can turn on this management. In this
  case, you can't specify MasterUserPassword. If the DB instance already manages the master
  user password with Amazon Web Services Secrets Manager, and you specify that the master
  user password is not managed with Amazon Web Services Secrets Manager, then you must
  specify MasterUserPassword. In this case, Amazon RDS deletes the secret and uses the new
  password for the master user specified by MasterUserPassword. For more information, see
  Password management with Amazon Web Services Secrets Manager in the Amazon RDS User Guide.
  Constraints:   Can't manage the master user password with Amazon Web Services Secrets
  Manager if MasterUserPassword is specified.
- `"MasterUserPassword"`: The new password for the master user. Changing this parameter
  doesn't result in an outage and the change is asynchronously applied as soon as possible.
  Between the time of the request and the completion of the request, the MasterUserPassword
  element exists in the PendingModifiedValues element of the operation response.  Amazon RDS
  API operations never return the password, so this operation provides a way to regain access
  to a primary instance user if the password is lost. This includes restoring privileges that
  might have been accidentally revoked.  This setting doesn't apply to the following DB
  instances:   Amazon Aurora (The password for the master user is managed by the DB cluster.
  For more information, see ModifyDBCluster.)   RDS Custom   Default: Uses existing setting
  Constraints:   Can't be specified if ManageMasterUserPassword is turned on.   Can include
  any printable ASCII character except \"/\", \"\"\", or \"@\". For RDS for Oracle, can't
  include the \"&amp;\" (ampersand) or the \"'\" (single quotes) character.   Length
  Constraints:   RDS for Db2 - Must contain from 8 to 255 characters.   RDS for MariaDB -
  Must contain from 8 to 41 characters.   RDS for Microsoft SQL Server - Must contain from 8
  to 128 characters.   RDS for MySQL - Must contain from 8 to 41 characters.   RDS for Oracle
  - Must contain from 8 to 30 characters.   RDS for PostgreSQL - Must contain from 8 to 128
  characters.
- `"MasterUserSecretKmsKeyId"`: The Amazon Web Services KMS key identifier to encrypt a
  secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
  This setting is valid only if both of the following conditions are met:   The DB instance
  doesn't manage the master user password in Amazon Web Services Secrets Manager. If the DB
  instance already manages the master user password in Amazon Web Services Secrets Manager,
  you can't change the KMS key used to encrypt the secret.   You are turning on
  ManageMasterUserPassword to manage the master user password in Amazon Web Services Secrets
  Manager. If you are turning on ManageMasterUserPassword and don't specify
  MasterUserSecretKmsKeyId, then the aws/secretsmanager KMS key is used to encrypt the
  secret. If the secret is in a different Amazon Web Services account, then you can't use the
  aws/secretsmanager KMS key to encrypt the secret, and you must use a customer managed KMS
  key.   The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or
  alias name for the KMS key. To use a KMS key in a different Amazon Web Services account,
  specify the key ARN or alias ARN. There is a default KMS key for your Amazon Web Services
  account. Your Amazon Web Services account has a different default KMS key for each Amazon
  Web Services Region.
- `"MaxAllocatedStorage"`: The upper limit in gibibytes (GiB) to which Amazon RDS can
  automatically scale the storage of the DB instance. For more information about this
  setting, including limitations that apply to it, see  Managing capacity automatically with
  Amazon RDS storage autoscaling in the Amazon RDS User Guide. This setting doesn't apply to
  RDS Custom DB instances.
- `"MonitoringInterval"`: The interval, in seconds, between points when Enhanced Monitoring
  metrics are collected for the DB instance. To disable collection of Enhanced Monitoring
  metrics, specify 0. If MonitoringRoleArn is specified, set MonitoringInterval to a value
  other than 0. This setting doesn't apply to RDS Custom DB instances. Valid Values: 0 | 1 |
  5 | 10 | 15 | 30 | 60  Default: 0
- `"MonitoringRoleArn"`: The ARN for the IAM role that permits RDS to send enhanced
  monitoring metrics to Amazon CloudWatch Logs. For example,
  arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role, see
  To create an IAM role for Amazon RDS Enhanced Monitoring in the Amazon RDS User Guide.  If
  MonitoringInterval is set to a value other than 0, supply a MonitoringRoleArn value. This
  setting doesn't apply to RDS Custom DB instances.
- `"MultiAZ"`: Specifies whether the DB instance is a Multi-AZ deployment. Changing this
  parameter doesn't result in an outage. The change is applied during the next maintenance
  window unless the ApplyImmediately parameter is enabled for this request. This setting
  doesn't apply to RDS Custom DB instances.
- `"MultiTenant"`: Specifies whether the to convert your DB instance from the single-tenant
  conﬁguration to the multi-tenant conﬁguration. This parameter is supported only for RDS
  for Oracle CDB instances. During the conversion, RDS creates an initial tenant database and
  associates the DB name, master user name, character set, and national character set
  metadata with this database. The tags associated with the instance also propagate to the
  initial tenant database. You can add more tenant databases to your DB instance by using the
  CreateTenantDatabase operation.  The conversion to the multi-tenant configuration is
  permanent and irreversible, so you can't later convert back to the single-tenant
  configuration. When you specify this parameter, you must also specify ApplyImmediately.
- `"NetworkType"`: The network type of the DB instance. The network type is determined by
  the DBSubnetGroup specified for the DB instance. A DBSubnetGroup can support only the IPv4
  protocol or the IPv4 and the IPv6 protocols (DUAL). For more information, see  Working with
  a DB instance in a VPC in the Amazon RDS User Guide.  Valid Values: IPV4 | DUAL
- `"NewDBInstanceIdentifier"`: The new identifier for the DB instance when renaming a DB
  instance. When you change the DB instance identifier, an instance reboot occurs immediately
  if you enable ApplyImmediately, or will occur during the next maintenance window if you
  disable ApplyImmediately. This value is stored as a lowercase string. This setting doesn't
  apply to RDS Custom DB instances. Constraints:   Must contain from 1 to 63 letters,
  numbers, or hyphens.   The first character must be a letter.   Can't end with a hyphen or
  contain two consecutive hyphens.   Example: mydbinstance
- `"OptionGroupName"`: The option group to associate the DB instance with. Changing this
  parameter doesn't result in an outage, with one exception. If the parameter change results
  in an option group that enables OEM, it can cause a brief period, lasting less than a
  second, during which new connections are rejected but existing connections aren't
  interrupted. The change is applied during the next maintenance window unless the
  ApplyImmediately parameter is enabled for this request. Permanent options, such as the TDE
  option for Oracle Advanced Security TDE, can't be removed from an option group, and that
  option group can't be removed from a DB instance after it is associated with a DB instance.
  This setting doesn't apply to RDS Custom DB instances.
- `"PerformanceInsightsKMSKeyId"`: The Amazon Web Services KMS key identifier for
  encryption of Performance Insights data. The Amazon Web Services KMS key identifier is the
  key ARN, key ID, alias ARN, or alias name for the KMS key. If you don't specify a value for
  PerformanceInsightsKMSKeyId, then Amazon RDS uses your default KMS key. There is a default
  KMS key for your Amazon Web Services account. Your Amazon Web Services account has a
  different default KMS key for each Amazon Web Services Region. This setting doesn't apply
  to RDS Custom DB instances.
- `"PerformanceInsightsRetentionPeriod"`: The number of days to retain Performance Insights
  data. This setting doesn't apply to RDS Custom DB instances. Valid Values:    7     month *
  31, where month is a number of months from 1-23. Examples: 93 (3 months * 31), 341 (11
  months * 31), 589 (19 months * 31)    731    Default: 7 days If you specify a retention
  period that isn't valid, such as 94, Amazon RDS returns an error.
- `"PreferredBackupWindow"`: The daily time range during which automated backups are
  created if automated backups are enabled, as determined by the BackupRetentionPeriod
  parameter. Changing this parameter doesn't result in an outage and the change is
  asynchronously applied as soon as possible. The default is a 30-minute window selected at
  random from an 8-hour block of time for each Amazon Web Services Region. For more
  information, see Backup window in the Amazon RDS User Guide. This setting doesn't apply to
  Amazon Aurora DB instances. The daily time range for creating automated backups is managed
  by the DB cluster. For more information, see ModifyDBCluster. Constraints:   Must be in the
  format hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict
  with the preferred maintenance window.   Must be at least 30 minutes.
- `"PreferredMaintenanceWindow"`: The weekly time range during which system maintenance can
  occur, which might result in an outage. Changing this parameter doesn't result in an
  outage, except in the following situation, and the change is asynchronously applied as soon
  as possible. If there are pending actions that cause a reboot, and the maintenance window
  is changed to include the current time, then changing this parameter causes a reboot of the
  DB instance. If you change this window to the current time, there must be at least 30
  minutes between the current time and end of the window to ensure pending changes are
  applied. For more information, see Amazon RDS Maintenance Window in the Amazon RDS User
  Guide.  Default: Uses existing setting Constraints:   Must be in the format
  ddd:hh24:mi-ddd:hh24:mi.   The day values must be mon | tue | wed | thu | fri | sat | sun.
    Must be in Universal Coordinated Time (UTC).   Must not conflict with the preferred
  backup window.   Must be at least 30 minutes.
- `"ProcessorFeatures"`: The number of CPU cores and the number of threads per core for the
  DB instance class of the DB instance. This setting doesn't apply to RDS Custom DB instances.
- `"PromotionTier"`: The order of priority in which an Aurora Replica is promoted to the
  primary instance after a failure of the existing primary instance. For more information,
  see  Fault Tolerance for an Aurora DB Cluster in the Amazon Aurora User Guide. This setting
  doesn't apply to RDS Custom DB instances. Default: 1  Valid Values: 0 - 15
- `"PubliclyAccessible"`: Specifies whether the DB instance is publicly accessible. When
  the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to
  the private IP address from within the DB cluster's virtual private cloud (VPC). It
  resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB
  cluster is ultimately controlled by the security group it uses. That public access isn't
  permitted if the security group assigned to the DB cluster doesn't permit it. When the DB
  instance isn't publicly accessible, it is an internal DB instance with a DNS name that
  resolves to a private IP address.  PubliclyAccessible only applies to DB instances in a
  VPC. The DB instance must be part of a public subnet and PubliclyAccessible must be enabled
  for it to be publicly accessible. Changes to the PubliclyAccessible parameter are applied
  immediately regardless of the value of the ApplyImmediately parameter.
- `"ReplicaMode"`: A value that sets the open mode of a replica database to either mounted
  or read-only.  Currently, this parameter is only supported for Oracle DB instances.
  Mounted DB replicas are included in Oracle Enterprise Edition. The main use case for
  mounted replicas is cross-Region disaster recovery. The primary database doesn't use Active
  Data Guard to transmit information to the mounted replica. Because it doesn't accept user
  connections, a mounted replica can't serve a read-only workload. For more information, see
  Working with Oracle Read Replicas for Amazon RDS in the Amazon RDS User Guide. This setting
  doesn't apply to RDS Custom DB instances.
- `"ResumeFullAutomationModeMinutes"`: The number of minutes to pause the automation. When
  the time period ends, RDS Custom resumes full automation. Default: 60  Constraints:   Must
  be at least 60.   Must be no more than 1,440.
- `"RotateMasterUserPassword"`: Specifies whether to rotate the secret managed by Amazon
  Web Services Secrets Manager for the master user password. This setting is valid only if
  the master user password is managed by RDS in Amazon Web Services Secrets Manager for the
  DB cluster. The secret value contains the updated password. For more information, see
  Password management with Amazon Web Services Secrets Manager in the Amazon RDS User Guide.
  Constraints:   You must apply the change immediately when rotating the master user
  password.
- `"StorageThroughput"`: The storage throughput value for the DB instance. This setting
  applies only to the gp3 storage type. This setting doesn't apply to Amazon Aurora or RDS
  Custom DB instances.
- `"StorageType"`: The storage type to associate with the DB instance. If you specify io1,
  io2, or gp3 you must also include a value for the Iops parameter. If you choose to migrate
  your DB instance from using standard storage to using Provisioned IOPS, or from using
  Provisioned IOPS to using standard storage, the process can take time. The duration of the
  migration depends on several factors such as database load, storage size, storage type
  (standard or Provisioned IOPS), amount of IOPS provisioned (if any), and the number of
  prior scale storage operations. Typical migration times are under 24 hours, but the process
  can take up to several days in some cases. During the migration, the DB instance is
  available for use, but might experience performance degradation. While the migration takes
  place, nightly backups for the instance are suspended. No other Amazon RDS operations can
  take place for the instance, including modifying the instance, rebooting the instance,
  deleting the instance, creating a read replica for the instance, and creating a DB snapshot
  of the instance. Valid Values: gp2 | gp3 | io1 | io2 | standard  Default: io1, if the Iops
  parameter is specified. Otherwise, gp2.
- `"TdeCredentialArn"`: The ARN from the key store with which to associate the instance for
  TDE encryption. This setting doesn't apply to RDS Custom DB instances.
- `"TdeCredentialPassword"`: The password for the given ARN from the key store in order to
  access the device. This setting doesn't apply to RDS Custom DB instances.
- `"UseDefaultProcessorFeatures"`: Specifies whether the DB instance class of the DB
  instance uses its default processor features. This setting doesn't apply to RDS Custom DB
  instances.
- `"VpcSecurityGroupIds"`: A list of Amazon EC2 VPC security groups to associate with this
  DB instance. This change is asynchronously applied as soon as possible. This setting
  doesn't apply to the following DB instances:   Amazon Aurora (The associated list of EC2
  VPC security groups is managed by the DB cluster. For more information, see
  ModifyDBCluster.)   RDS Custom   Constraints:   If supplied, must match existing VPC
  security group IDs.
"""
function modify_dbinstance(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBInstance",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbinstance(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbparameter_group(dbparameter_group_name, parameter)
    modify_dbparameter_group(dbparameter_group_name, parameter, params::Dict{String,<:Any})

Modifies the parameters of a DB parameter group. To modify more than one parameter, submit
a list of the following: ParameterName, ParameterValue, and ApplyMethod. A maximum of 20
parameters can be modified in a single request.  After you modify a DB parameter group, you
should wait at least 5 minutes before creating your first DB instance that uses that DB
parameter group as the default parameter group. This allows Amazon RDS to fully complete
the modify operation before the parameter group is used as the default for a new DB
instance. This is especially important for parameters that are critical when creating the
default database for a DB instance, such as the character set for the default database
defined by the character_set_database parameter. You can use the Parameter Groups option of
the Amazon RDS console or the DescribeDBParameters command to verify that your DB parameter
group has been created or modified.

# Arguments
- `dbparameter_group_name`: The name of the DB parameter group. Constraints:   If supplied,
  must match the name of an existing DBParameterGroup.
- `parameter`: An array of parameter names, values, and the application methods for the
  parameter update. At least one parameter name, value, and application method must be
  supplied; later arguments are optional. A maximum of 20 parameters can be modified in a
  single request. Valid Values (for the application method): immediate | pending-reboot  You
  can use the immediate value with dynamic parameters only. You can use the pending-reboot
  value for both dynamic and static parameters. When the application method is immediate,
  changes to dynamic parameters are applied immediately to the DB instances associated with
  the parameter group. When the application method is pending-reboot, changes to dynamic and
  static parameters are applied after a reboot without failover to the DB instances
  associated with the parameter group.  You can't use pending-reboot with dynamic parameters
  on RDS for SQL Server DB instances. Use immediate.  For more information on modifying DB
  parameters, see Working with DB parameter groups in the Amazon RDS User Guide.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Parameters"`: An array of parameter names, values, and the application methods for the
  parameter update. At least one parameter name, value, and application method must be
  supplied; later arguments are optional. A maximum of 20 parameters can be modified in a
  single request. Valid Values (for the application method): immediate | pending-reboot  You
  can use the immediate value with dynamic parameters only. You can use the pending-reboot
  value for both dynamic and static parameters. When the application method is immediate,
  changes to dynamic parameters are applied immediately to the DB instances associated with
  the parameter group. When the application method is pending-reboot, changes to dynamic and
  static parameters are applied after a reboot without failover to the DB instances
  associated with the parameter group.  You can't use pending-reboot with dynamic parameters
  on RDS for SQL Server DB instances. Use immediate.  For more information on modifying DB
  parameters, see Working with DB parameter groups in the Amazon RDS User Guide.
"""
function modify_dbparameter_group(
    DBParameterGroupName, Parameter; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBParameterGroup",
        Dict{String,Any}(
            "DBParameterGroupName" => DBParameterGroupName, "Parameter" => Parameter
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbparameter_group(
    DBParameterGroupName,
    Parameter,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBParameterGroupName" => DBParameterGroupName, "Parameter" => Parameter
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbproxy(dbproxy_name)
    modify_dbproxy(dbproxy_name, params::Dict{String,<:Any})

Changes the settings for an existing DB proxy.

# Arguments
- `dbproxy_name`: The identifier for the DBProxy to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Auth"`: The new authentication settings for the DBProxy.
- `"DebugLogging"`: Whether the proxy includes detailed information about SQL statements in
  its logs. This information helps you to debug issues involving SQL behavior or the
  performance and scalability of the proxy connections. The debug information includes the
  text of SQL statements that you submit through the proxy. Thus, only enable this setting
  when needed for debugging, and only when you have security measures in place to safeguard
  any sensitive information that appears in the logs.
- `"IdleClientTimeout"`: The number of seconds that a connection to the proxy can be
  inactive before the proxy disconnects it. You can set this value higher or lower than the
  connection timeout limit for the associated database.
- `"NewDBProxyName"`: The new identifier for the DBProxy. An identifier must begin with a
  letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen
  or contain two consecutive hyphens.
- `"RequireTLS"`: Whether Transport Layer Security (TLS) encryption is required for
  connections to the proxy. By enabling this setting, you can enforce encrypted TLS
  connections to the proxy, even if the associated database doesn't use TLS.
- `"RoleArn"`: The Amazon Resource Name (ARN) of the IAM role that the proxy uses to access
  secrets in Amazon Web Services Secrets Manager.
- `"SecurityGroups"`: The new list of security groups for the DBProxy.
"""
function modify_dbproxy(DBProxyName; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "ModifyDBProxy",
        Dict{String,Any}("DBProxyName" => DBProxyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbproxy(
    DBProxyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBProxy",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DBProxyName" => DBProxyName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbproxy_endpoint(dbproxy_endpoint_name)
    modify_dbproxy_endpoint(dbproxy_endpoint_name, params::Dict{String,<:Any})

Changes the settings for an existing DB proxy endpoint.

# Arguments
- `dbproxy_endpoint_name`: The name of the DB proxy sociated with the DB proxy endpoint
  that you want to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"NewDBProxyEndpointName"`: The new identifier for the DBProxyEndpoint. An identifier
  must begin with a letter and must contain only ASCII letters, digits, and hyphens; it can't
  end with a hyphen or contain two consecutive hyphens.
- `"VpcSecurityGroupIds"`: The VPC security group IDs for the DB proxy endpoint. When the
  DB proxy endpoint uses a different VPC than the original proxy, you also specify a
  different set of security group IDs than for the original proxy.
"""
function modify_dbproxy_endpoint(
    DBProxyEndpointName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBProxyEndpoint",
        Dict{String,Any}("DBProxyEndpointName" => DBProxyEndpointName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbproxy_endpoint(
    DBProxyEndpointName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBProxyEndpoint",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBProxyEndpointName" => DBProxyEndpointName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbproxy_target_group(dbproxy_name, target_group_name)
    modify_dbproxy_target_group(dbproxy_name, target_group_name, params::Dict{String,<:Any})

Modifies the properties of a DBProxyTargetGroup.

# Arguments
- `dbproxy_name`: The name of the proxy.
- `target_group_name`: The name of the target group to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ConnectionPoolConfig"`: The settings that determine the size and behavior of the
  connection pool for the target group.
- `"NewName"`: The new name for the modified DBProxyTarget. An identifier must begin with a
  letter and must contain only ASCII letters, digits, and hyphens; it can't end with a hyphen
  or contain two consecutive hyphens.
"""
function modify_dbproxy_target_group(
    DBProxyName, TargetGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBProxyTargetGroup",
        Dict{String,Any}(
            "DBProxyName" => DBProxyName, "TargetGroupName" => TargetGroupName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbproxy_target_group(
    DBProxyName,
    TargetGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBProxyTargetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBProxyName" => DBProxyName, "TargetGroupName" => TargetGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbrecommendation(recommendation_id)
    modify_dbrecommendation(recommendation_id, params::Dict{String,<:Any})

Updates the recommendation status and recommended action status for the specified
recommendation.

# Arguments
- `recommendation_id`: The identifier of the recommendation to update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Locale"`: The language of the modified recommendation.
- `"RecommendedActionUpdates"`: The list of recommended action status to update. You can
  update multiple recommended actions at one time.
- `"Status"`: The recommendation status to update. Valid values:   active   dismissed
"""
function modify_dbrecommendation(
    RecommendationId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBRecommendation",
        Dict{String,Any}("RecommendationId" => RecommendationId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbrecommendation(
    RecommendationId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBRecommendation",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("RecommendationId" => RecommendationId), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbshard_group(dbshard_group_identifier)
    modify_dbshard_group(dbshard_group_identifier, params::Dict{String,<:Any})

Modifies the settings of an Aurora Limitless Database DB shard group. You can change one or
more settings by specifying these parameters and the new values in the request.

# Arguments
- `dbshard_group_identifier`: The name of the DB shard group to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MaxACU"`: The maximum capacity of the DB shard group in Aurora capacity units (ACUs).
"""
function modify_dbshard_group(
    DBShardGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBShardGroup",
        Dict{String,Any}("DBShardGroupIdentifier" => DBShardGroupIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbshard_group(
    DBShardGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBShardGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBShardGroupIdentifier" => DBShardGroupIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbsnapshot(dbsnapshot_identifier)
    modify_dbsnapshot(dbsnapshot_identifier, params::Dict{String,<:Any})

Updates a manual DB snapshot with a new engine version. The snapshot can be encrypted or
unencrypted, but not shared or public.  Amazon RDS supports upgrading DB snapshots for
MySQL, PostgreSQL, and Oracle. This operation doesn't apply to RDS Custom or RDS for Db2.

# Arguments
- `dbsnapshot_identifier`: The identifier of the DB snapshot to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"EngineVersion"`: The engine version to upgrade the DB snapshot to. The following are
  the database engines and engine versions that are available when you upgrade a DB snapshot.
   MySQL  For the list of engine versions that are available for upgrading a DB snapshot, see
   Upgrading a MySQL DB snapshot engine version in the Amazon RDS User Guide.   Oracle
  19.0.0.0.ru-2022-01.rur-2022-01.r1 (supported for 12.2.0.1 DB snapshots)
  19.0.0.0.ru-2022-07.rur-2022-07.r1 (supported for 12.1.0.2 DB snapshots)    12.1.0.2.v8
  (supported for 12.1.0.1 DB snapshots)    11.2.0.4.v12 (supported for 11.2.0.2 DB snapshots)
     11.2.0.4.v11 (supported for 11.2.0.3 DB snapshots)    PostgreSQL  For the list of engine
  versions that are available for upgrading a DB snapshot, see  Upgrading a PostgreSQL DB
  snapshot engine version in the Amazon RDS User Guide.
- `"OptionGroupName"`: The option group to identify with the upgraded DB snapshot. You can
  specify this parameter when you upgrade an Oracle DB snapshot. The same option group
  considerations apply when upgrading a DB snapshot as when upgrading a DB instance. For more
  information, see Option group considerations in the Amazon RDS User Guide.
"""
function modify_dbsnapshot(
    DBSnapshotIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBSnapshot",
        Dict{String,Any}("DBSnapshotIdentifier" => DBSnapshotIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbsnapshot(
    DBSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBSnapshotIdentifier" => DBSnapshotIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbsnapshot_attribute(attribute_name, dbsnapshot_identifier)
    modify_dbsnapshot_attribute(attribute_name, dbsnapshot_identifier, params::Dict{String,<:Any})

Adds an attribute and values to, or removes an attribute and values from, a manual DB
snapshot. To share a manual DB snapshot with other Amazon Web Services accounts, specify
restore as the AttributeName and use the ValuesToAdd parameter to add a list of IDs of the
Amazon Web Services accounts that are authorized to restore the manual DB snapshot. Uses
the value all to make the manual DB snapshot public, which means it can be copied or
restored by all Amazon Web Services accounts.  Don't add the all value for any manual DB
snapshots that contain private information that you don't want available to all Amazon Web
Services accounts.  If the manual DB snapshot is encrypted, it can be shared, but only by
specifying a list of authorized Amazon Web Services account IDs for the ValuesToAdd
parameter. You can't use all as a value for that parameter in this case. To view which
Amazon Web Services accounts have access to copy or restore a manual DB snapshot, or
whether a manual DB snapshot public or private, use the DescribeDBSnapshotAttributes API
operation. The accounts are returned as values for the restore attribute.

# Arguments
- `attribute_name`: The name of the DB snapshot attribute to modify. To manage
  authorization for other Amazon Web Services accounts to copy or restore a manual DB
  snapshot, set this value to restore.  To view the list of attributes available to modify,
  use the DescribeDBSnapshotAttributes API operation.
- `dbsnapshot_identifier`: The identifier for the DB snapshot to modify the attributes for.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ValuesToAdd"`: A list of DB snapshot attributes to add to the attribute specified by
  AttributeName. To authorize other Amazon Web Services accounts to copy or restore a manual
  snapshot, set this list to include one or more Amazon Web Services account IDs, or all to
  make the manual DB snapshot restorable by any Amazon Web Services account. Do not add the
  all value for any manual DB snapshots that contain private information that you don't want
  available to all Amazon Web Services accounts.
- `"ValuesToRemove"`: A list of DB snapshot attributes to remove from the attribute
  specified by AttributeName. To remove authorization for other Amazon Web Services accounts
  to copy or restore a manual snapshot, set this list to include one or more Amazon Web
  Services account identifiers, or all to remove authorization for any Amazon Web Services
  account to copy or restore the DB snapshot. If you specify all, an Amazon Web Services
  account whose account ID is explicitly added to the restore attribute can still copy or
  restore the manual DB snapshot.
"""
function modify_dbsnapshot_attribute(
    AttributeName, DBSnapshotIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBSnapshotAttribute",
        Dict{String,Any}(
            "AttributeName" => AttributeName, "DBSnapshotIdentifier" => DBSnapshotIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbsnapshot_attribute(
    AttributeName,
    DBSnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBSnapshotAttribute",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "AttributeName" => AttributeName,
                    "DBSnapshotIdentifier" => DBSnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_dbsubnet_group(dbsubnet_group_name, subnet_identifier)
    modify_dbsubnet_group(dbsubnet_group_name, subnet_identifier, params::Dict{String,<:Any})

Modifies an existing DB subnet group. DB subnet groups must contain at least one subnet in
at least two AZs in the Amazon Web Services Region.

# Arguments
- `dbsubnet_group_name`: The name for the DB subnet group. This value is stored as a
  lowercase string. You can't modify the default subnet group. Constraints: Must match the
  name of an existing DBSubnetGroup. Must not be default. Example: mydbsubnetgroup
- `subnet_identifier`: The EC2 subnet IDs for the DB subnet group.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBSubnetGroupDescription"`: The description for the DB subnet group.
- `"SubnetIds"`: The EC2 subnet IDs for the DB subnet group.
"""
function modify_dbsubnet_group(
    DBSubnetGroupName, SubnetIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyDBSubnetGroup",
        Dict{String,Any}(
            "DBSubnetGroupName" => DBSubnetGroupName, "SubnetIdentifier" => SubnetIdentifier
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_dbsubnet_group(
    DBSubnetGroupName,
    SubnetIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyDBSubnetGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBSubnetGroupName" => DBSubnetGroupName,
                    "SubnetIdentifier" => SubnetIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_event_subscription(subscription_name)
    modify_event_subscription(subscription_name, params::Dict{String,<:Any})

Modifies an existing RDS event notification subscription. You can't modify the source
identifiers using this call. To change source identifiers for a subscription, use the
AddSourceIdentifierToSubscription and RemoveSourceIdentifierFromSubscription calls. You can
see a list of the event categories for a given source type (SourceType) in Events in the
Amazon RDS User Guide or by using the DescribeEventCategories operation.

# Arguments
- `subscription_name`: The name of the RDS event notification subscription.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Enabled"`: Specifies whether to activate the subscription.
- `"EventCategories"`: A list of event categories for a source type (SourceType) that you
  want to subscribe to. You can see a list of the categories for a given source type in
  Events in the Amazon RDS User Guide or by using the DescribeEventCategories operation.
- `"SnsTopicArn"`: The Amazon Resource Name (ARN) of the SNS topic created for event
  notification. The ARN is created by Amazon SNS when you create a topic and subscribe to it.
- `"SourceType"`: The type of source that is generating the events. For example, if you
  want to be notified of events generated by a DB instance, you would set this parameter to
  db-instance. For RDS Proxy events, specify db-proxy. If this value isn't specified, all
  events are returned. Valid Values: db-instance | db-cluster | db-parameter-group |
  db-security-group | db-snapshot | db-cluster-snapshot | db-proxy | zero-etl |
  custom-engine-version | blue-green-deployment
"""
function modify_event_subscription(
    SubscriptionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyEventSubscription",
        Dict{String,Any}("SubscriptionName" => SubscriptionName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_event_subscription(
    SubscriptionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyEventSubscription",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("SubscriptionName" => SubscriptionName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_global_cluster()
    modify_global_cluster(params::Dict{String,<:Any})

Modifies a setting for an Amazon Aurora global database cluster. You can change one or more
database configuration parameters by specifying these parameters and the new values in the
request. For more information on Amazon Aurora, see  What is Amazon Aurora? in the Amazon
Aurora User Guide.  This operation only applies to Aurora global database clusters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllowMajorVersionUpgrade"`: Specifies whether to allow major version upgrades.
  Constraints: Must be enabled if you specify a value for the EngineVersion parameter that's
  a different major version than the global cluster's current version. If you upgrade the
  major version of a global database, the cluster and DB instance parameter groups are set to
  the default parameter groups for the new version. Apply any custom parameter groups after
  completing the upgrade.
- `"DeletionProtection"`: Specifies whether to enable deletion protection for the global
  database cluster. The global database cluster can't be deleted when deletion protection is
  enabled.
- `"EngineVersion"`: The version number of the database engine to which you want to
  upgrade.  To list all of the available engine versions for aurora-mysql (for MySQL-based
  Aurora global databases), use the following command:  aws rds describe-db-engine-versions
  --engine aurora-mysql --query '*[]|[?SupportsGlobalDatabases == `true`].[EngineVersion]'
  To list all of the available engine versions for aurora-postgresql (for PostgreSQL-based
  Aurora global databases), use the following command:  aws rds describe-db-engine-versions
  --engine aurora-postgresql --query '*[]|[?SupportsGlobalDatabases ==
  `true`].[EngineVersion]'
- `"GlobalClusterIdentifier"`: The cluster identifier for the global cluster to modify.
  This parameter isn't case-sensitive. Constraints:   Must match the identifier of an
  existing global database cluster.
- `"NewGlobalClusterIdentifier"`: The new cluster identifier for the global database
  cluster. This value is stored as a lowercase string. Constraints:   Must contain from 1 to
  63 letters, numbers, or hyphens.   The first character must be a letter.   Can't end with a
  hyphen or contain two consecutive hyphens.   Example: my-cluster2
"""
function modify_global_cluster(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "ModifyGlobalCluster"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function modify_global_cluster(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyGlobalCluster",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_integration(integration_identifier)
    modify_integration(integration_identifier, params::Dict{String,<:Any})

Modifies a zero-ETL integration with Amazon Redshift.  Currently, you can only modify
integrations that have Aurora MySQL source DB clusters. Integrations with Aurora PostgreSQL
and RDS sources currently don't support modifying the integration.

# Arguments
- `integration_identifier`: The unique identifier of the integration to modify.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DataFilter"`: A new data filter for the integration. For more information, see Data
  filtering for Aurora zero-ETL integrations with Amazon Redshift.
- `"Description"`: A new description for the integration.
- `"IntegrationName"`: A new name for the integration.
"""
function modify_integration(
    IntegrationIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyIntegration",
        Dict{String,Any}("IntegrationIdentifier" => IntegrationIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_integration(
    IntegrationIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyIntegration",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("IntegrationIdentifier" => IntegrationIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_option_group(option_group_name)
    modify_option_group(option_group_name, params::Dict{String,<:Any})

Modifies an existing option group.

# Arguments
- `option_group_name`: The name of the option group to be modified. Permanent options, such
  as the TDE option for Oracle Advanced Security TDE, can't be removed from an option group,
  and that option group can't be removed from a DB instance once it is associated with a DB
  instance

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplyImmediately"`: Specifies whether to apply the change immediately or during the
  next maintenance window for each instance associated with the option group.
- `"OptionsToInclude"`: Options in this list are added to the option group or, if already
  present, the specified configuration is used to update the existing configuration.
- `"OptionsToRemove"`: Options in this list are removed from the option group.
"""
function modify_option_group(
    OptionGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyOptionGroup",
        Dict{String,Any}("OptionGroupName" => OptionGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_option_group(
    OptionGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyOptionGroup",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("OptionGroupName" => OptionGroupName), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    modify_tenant_database(dbinstance_identifier, tenant_dbname)
    modify_tenant_database(dbinstance_identifier, tenant_dbname, params::Dict{String,<:Any})

Modifies an existing tenant database in a DB instance. You can change the tenant database
name or the master user password. This operation is supported only for RDS for Oracle CDB
instances using the multi-tenant configuration.

# Arguments
- `dbinstance_identifier`: The identifier of the DB instance that contains the tenant
  database that you are modifying. This parameter isn't case-sensitive. Constraints:   Must
  match the identifier of an existing DB instance.
- `tenant_dbname`: The user-supplied name of the tenant database that you want to modify.
  This parameter isn’t case-sensitive. Constraints:   Must match the identifier of an
  existing tenant database.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"MasterUserPassword"`: The new password for the master user of the specified tenant
  database in your DB instance.  Amazon RDS operations never return the password, so this
  action provides a way to regain access to a tenant database user if the password is lost.
  This includes restoring privileges that might have been accidentally revoked.  Constraints:
    Can include any printable ASCII character except /, \" (double quote), @, &amp;
  (ampersand), and ' (single quote).   Length constraints:   Must contain between 8 and 30
  characters.
- `"NewTenantDBName"`: The new name of the tenant database when renaming a tenant database.
  This parameter isn’t case-sensitive. Constraints:   Can't be the string null or any other
  reserved word.   Can't be longer than 8 characters.
"""
function modify_tenant_database(
    DBInstanceIdentifier, TenantDBName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ModifyTenantDatabase",
        Dict{String,Any}(
            "DBInstanceIdentifier" => DBInstanceIdentifier, "TenantDBName" => TenantDBName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function modify_tenant_database(
    DBInstanceIdentifier,
    TenantDBName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ModifyTenantDatabase",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "TenantDBName" => TenantDBName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    promote_read_replica(dbinstance_identifier)
    promote_read_replica(dbinstance_identifier, params::Dict{String,<:Any})

Promotes a read replica DB instance to a standalone DB instance.    Backup duration is a
function of the amount of changes to the database since the previous backup. If you plan to
promote a read replica to a standalone instance, we recommend that you enable backups and
complete at least one backup prior to promotion. In addition, a read replica cannot be
promoted to a standalone instance when it is in the backing-up status. If you have enabled
backups on your read replica, configure the automated backup window so that daily backups
do not interfere with read replica promotion.   This command doesn't apply to Aurora MySQL,
Aurora PostgreSQL, or RDS Custom.

# Arguments
- `dbinstance_identifier`: The DB instance identifier. This value is stored as a lowercase
  string. Constraints:   Must match the identifier of an existing read replica DB instance.
  Example: mydbinstance

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BackupRetentionPeriod"`: The number of days for which automated backups are retained.
  Setting this parameter to a positive number enables backups. Setting this parameter to 0
  disables automated backups. Default: 1 Constraints:   Must be a value from 0 to 35.   Can't
  be set to 0 if the DB instance is a source to read replicas.
- `"PreferredBackupWindow"`: The daily time range during which automated backups are
  created if automated backups are enabled, using the BackupRetentionPeriod parameter. The
  default is a 30-minute window selected at random from an 8-hour block of time for each
  Amazon Web Services Region. To see the time blocks available, see  Adjusting the Preferred
  Maintenance Window in the Amazon RDS User Guide.  Constraints:   Must be in the format
  hh24:mi-hh24:mi.   Must be in Universal Coordinated Time (UTC).   Must not conflict with
  the preferred maintenance window.   Must be at least 30 minutes.
"""
function promote_read_replica(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "PromoteReadReplica",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function promote_read_replica(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "PromoteReadReplica",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    promote_read_replica_dbcluster(dbcluster_identifier)
    promote_read_replica_dbcluster(dbcluster_identifier, params::Dict{String,<:Any})

Promotes a read replica DB cluster to a standalone DB cluster.

# Arguments
- `dbcluster_identifier`: The identifier of the DB cluster read replica to promote. This
  parameter isn't case-sensitive. Constraints:   Must match the identifier of an existing DB
  cluster read replica.   Example: my-cluster-replica1

"""
function promote_read_replica_dbcluster(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "PromoteReadReplicaDBCluster",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function promote_read_replica_dbcluster(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "PromoteReadReplicaDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    purchase_reserved_dbinstances_offering(reserved_dbinstances_offering_id)
    purchase_reserved_dbinstances_offering(reserved_dbinstances_offering_id, params::Dict{String,<:Any})

Purchases a reserved DB instance offering.

# Arguments
- `reserved_dbinstances_offering_id`: The ID of the Reserved DB instance offering to
  purchase. Example: 438012d3-4052-4cc7-b2e3-8d3372e0e706

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBInstanceCount"`: The number of instances to reserve. Default: 1
- `"ReservedDBInstanceId"`: Customer-specified identifier to track this reservation.
  Example: myreservationID
- `"Tags"`:
"""
function purchase_reserved_dbinstances_offering(
    ReservedDBInstancesOfferingId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "PurchaseReservedDBInstancesOffering",
        Dict{String,Any}("ReservedDBInstancesOfferingId" => ReservedDBInstancesOfferingId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function purchase_reserved_dbinstances_offering(
    ReservedDBInstancesOfferingId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "PurchaseReservedDBInstancesOffering",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ReservedDBInstancesOfferingId" => ReservedDBInstancesOfferingId
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_dbcluster(dbcluster_identifier)
    reboot_dbcluster(dbcluster_identifier, params::Dict{String,<:Any})

You might need to reboot your DB cluster, usually for maintenance reasons. For example, if
you make certain modifications, or if you change the DB cluster parameter group associated
with the DB cluster, reboot the DB cluster for the changes to take effect. Rebooting a DB
cluster restarts the database engine service. Rebooting a DB cluster results in a momentary
outage, during which the DB cluster status is set to rebooting. Use this operation only for
a non-Aurora Multi-AZ DB cluster. For more information on Multi-AZ DB clusters, see
Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The DB cluster identifier. This parameter is stored as a
  lowercase string. Constraints:   Must match the identifier of an existing DBCluster.

"""
function reboot_dbcluster(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RebootDBCluster",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_dbcluster(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RebootDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_dbinstance(dbinstance_identifier)
    reboot_dbinstance(dbinstance_identifier, params::Dict{String,<:Any})

You might need to reboot your DB instance, usually for maintenance reasons. For example, if
you make certain modifications, or if you change the DB parameter group associated with the
DB instance, you must reboot the instance for the changes to take effect. Rebooting a DB
instance restarts the database engine service. Rebooting a DB instance results in a
momentary outage, during which the DB instance status is set to rebooting. For more
information about rebooting, see Rebooting a DB Instance in the Amazon RDS User Guide.
This command doesn't apply to RDS Custom. If your DB instance is part of a Multi-AZ DB
cluster, you can reboot the DB cluster with the RebootDBCluster operation.

# Arguments
- `dbinstance_identifier`: The DB instance identifier. This parameter is stored as a
  lowercase string. Constraints:   Must match the identifier of an existing DBInstance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ForceFailover"`: Specifies whether the reboot is conducted through a Multi-AZ failover.
  Constraint: You can't enable force failover if the instance isn't configured for Multi-AZ.
"""
function reboot_dbinstance(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RebootDBInstance",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_dbinstance(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RebootDBInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reboot_dbshard_group(dbshard_group_identifier)
    reboot_dbshard_group(dbshard_group_identifier, params::Dict{String,<:Any})

You might need to reboot your DB shard group, usually for maintenance reasons. For example,
if you make certain modifications, reboot the DB shard group for the changes to take
effect. This operation applies only to Aurora Limitless Database DBb shard groups.

# Arguments
- `dbshard_group_identifier`: The name of the DB shard group to reboot.

"""
function reboot_dbshard_group(
    DBShardGroupIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RebootDBShardGroup",
        Dict{String,Any}("DBShardGroupIdentifier" => DBShardGroupIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reboot_dbshard_group(
    DBShardGroupIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RebootDBShardGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBShardGroupIdentifier" => DBShardGroupIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    register_dbproxy_targets(dbproxy_name)
    register_dbproxy_targets(dbproxy_name, params::Dict{String,<:Any})

Associate one or more DBProxyTarget data structures with a DBProxyTargetGroup.

# Arguments
- `dbproxy_name`: The identifier of the DBProxy that is associated with the
  DBProxyTargetGroup.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBClusterIdentifiers"`: One or more DB cluster identifiers.
- `"DBInstanceIdentifiers"`: One or more DB instance identifiers.
- `"TargetGroupName"`: The identifier of the DBProxyTargetGroup.
"""
function register_dbproxy_targets(
    DBProxyName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RegisterDBProxyTargets",
        Dict{String,Any}("DBProxyName" => DBProxyName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function register_dbproxy_targets(
    DBProxyName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RegisterDBProxyTargets",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("DBProxyName" => DBProxyName), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_from_global_cluster()
    remove_from_global_cluster(params::Dict{String,<:Any})

Detaches an Aurora secondary cluster from an Aurora global database cluster. The cluster
becomes a standalone cluster with read-write capability instead of being read-only and
receiving data from a primary cluster in a different Region.  This operation only applies
to Aurora DB clusters.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DbClusterIdentifier"`: The Amazon Resource Name (ARN) identifying the cluster that was
  detached from the Aurora global database cluster.
- `"GlobalClusterIdentifier"`: The cluster identifier to detach from the Aurora global
  database cluster.
"""
function remove_from_global_cluster(; aws_config::AbstractAWSConfig=current_aws_config())
    return rds(
        "RemoveFromGlobalCluster"; aws_config=aws_config, feature_set=SERVICE_FEATURE_SET
    )
end
function remove_from_global_cluster(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RemoveFromGlobalCluster",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_role_from_dbcluster(dbcluster_identifier, role_arn)
    remove_role_from_dbcluster(dbcluster_identifier, role_arn, params::Dict{String,<:Any})

Removes the asssociation of an Amazon Web Services Identity and Access Management (IAM)
role from a DB cluster. For more information on Amazon Aurora DB clusters, see  What is
Amazon Aurora? in the Amazon Aurora User Guide. For more information on Multi-AZ DB
clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The name of the DB cluster to disassociate the IAM role from.
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role to disassociate from the
  Aurora DB cluster, for example arn:aws:iam::123456789012:role/AuroraAccessRole.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"FeatureName"`: The name of the feature for the DB cluster that the IAM role is to be
  disassociated from. For information about supported feature names, see DBEngineVersion.
"""
function remove_role_from_dbcluster(
    DBClusterIdentifier, RoleArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RemoveRoleFromDBCluster",
        Dict{String,Any}(
            "DBClusterIdentifier" => DBClusterIdentifier, "RoleArn" => RoleArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_role_from_dbcluster(
    DBClusterIdentifier,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RemoveRoleFromDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterIdentifier" => DBClusterIdentifier, "RoleArn" => RoleArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_role_from_dbinstance(dbinstance_identifier, feature_name, role_arn)
    remove_role_from_dbinstance(dbinstance_identifier, feature_name, role_arn, params::Dict{String,<:Any})

Disassociates an Amazon Web Services Identity and Access Management (IAM) role from a DB
instance.

# Arguments
- `dbinstance_identifier`: The name of the DB instance to disassociate the IAM role from.
- `feature_name`: The name of the feature for the DB instance that the IAM role is to be
  disassociated from. For information about supported feature names, see DBEngineVersion.
- `role_arn`: The Amazon Resource Name (ARN) of the IAM role to disassociate from the DB
  instance, for example, arn:aws:iam::123456789012:role/AccessRole.

"""
function remove_role_from_dbinstance(
    DBInstanceIdentifier,
    FeatureName,
    RoleArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RemoveRoleFromDBInstance",
        Dict{String,Any}(
            "DBInstanceIdentifier" => DBInstanceIdentifier,
            "FeatureName" => FeatureName,
            "RoleArn" => RoleArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_role_from_dbinstance(
    DBInstanceIdentifier,
    FeatureName,
    RoleArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RemoveRoleFromDBInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "FeatureName" => FeatureName,
                    "RoleArn" => RoleArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_source_identifier_from_subscription(source_identifier, subscription_name)
    remove_source_identifier_from_subscription(source_identifier, subscription_name, params::Dict{String,<:Any})

Removes a source identifier from an existing RDS event notification subscription.

# Arguments
- `source_identifier`: The source identifier to be removed from the subscription, such as
  the DB instance identifier for a DB instance or the name of a security group.
- `subscription_name`: The name of the RDS event notification subscription you want to
  remove a source identifier from.

"""
function remove_source_identifier_from_subscription(
    SourceIdentifier, SubscriptionName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RemoveSourceIdentifierFromSubscription",
        Dict{String,Any}(
            "SourceIdentifier" => SourceIdentifier, "SubscriptionName" => SubscriptionName
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_source_identifier_from_subscription(
    SourceIdentifier,
    SubscriptionName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RemoveSourceIdentifierFromSubscription",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "SourceIdentifier" => SourceIdentifier,
                    "SubscriptionName" => SubscriptionName,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    remove_tags_from_resource(resource_name, tag_keys)
    remove_tags_from_resource(resource_name, tag_keys, params::Dict{String,<:Any})

Removes metadata tags from an Amazon RDS resource. For an overview on tagging an Amazon RDS
resource, see Tagging Amazon RDS Resources in the Amazon RDS User Guide.

# Arguments
- `resource_name`: The Amazon RDS resource that the tags are removed from. This value is an
  Amazon Resource Name (ARN). For information about creating an ARN, see  Constructing an ARN
  for Amazon RDS in the Amazon RDS User Guide.
- `tag_keys`: The tag key (name) of the tag to be removed.

"""
function remove_tags_from_resource(
    ResourceName, TagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RemoveTagsFromResource",
        Dict{String,Any}("ResourceName" => ResourceName, "TagKeys" => TagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function remove_tags_from_resource(
    ResourceName,
    TagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RemoveTagsFromResource",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("ResourceName" => ResourceName, "TagKeys" => TagKeys),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_dbcluster_parameter_group(dbcluster_parameter_group_name)
    reset_dbcluster_parameter_group(dbcluster_parameter_group_name, params::Dict{String,<:Any})

Modifies the parameters of a DB cluster parameter group to the default value. To reset
specific parameters submit a list of the following: ParameterName and ApplyMethod. To reset
the entire DB cluster parameter group, specify the DBClusterParameterGroupName and
ResetAllParameters parameters. When resetting the entire group, dynamic parameters are
updated immediately and static parameters are set to pending-reboot to take effect on the
next DB instance restart or RebootDBInstance request. You must call RebootDBInstance for
every DB instance in your DB cluster that you want the updated static parameter to apply
to. For more information on Amazon Aurora DB clusters, see  What is Amazon Aurora? in the
Amazon Aurora User Guide. For more information on Multi-AZ DB clusters, see  Multi-AZ DB
cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_parameter_group_name`: The name of the DB cluster parameter group to reset.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Parameters"`: A list of parameter names in the DB cluster parameter group to reset to
  the default values. You can't use this parameter if the ResetAllParameters parameter is
  enabled.
- `"ResetAllParameters"`: Specifies whether to reset all parameters in the DB cluster
  parameter group to their default values. You can't use this parameter if there is a list of
  parameter names specified for the Parameters parameter.
"""
function reset_dbcluster_parameter_group(
    DBClusterParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ResetDBClusterParameterGroup",
        Dict{String,Any}("DBClusterParameterGroupName" => DBClusterParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_dbcluster_parameter_group(
    DBClusterParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ResetDBClusterParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterParameterGroupName" => DBClusterParameterGroupName
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    reset_dbparameter_group(dbparameter_group_name)
    reset_dbparameter_group(dbparameter_group_name, params::Dict{String,<:Any})

Modifies the parameters of a DB parameter group to the engine/system default value. To
reset specific parameters, provide a list of the following: ParameterName and ApplyMethod.
To reset the entire DB parameter group, specify the DBParameterGroup name and
ResetAllParameters parameters. When resetting the entire group, dynamic parameters are
updated immediately and static parameters are set to pending-reboot to take effect on the
next DB instance restart or RebootDBInstance request.

# Arguments
- `dbparameter_group_name`: The name of the DB parameter group. Constraints:   Must match
  the name of an existing DBParameterGroup.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Parameters"`: To reset the entire DB parameter group, specify the DBParameterGroup name
  and ResetAllParameters parameters. To reset specific parameters, provide a list of the
  following: ParameterName and ApplyMethod. A maximum of 20 parameters can be modified in a
  single request.  MySQL  Valid Values (for Apply method): immediate | pending-reboot  You
  can use the immediate value with dynamic parameters only. You can use the pending-reboot
  value for both dynamic and static parameters, and changes are applied when DB instance
  reboots.  MariaDB  Valid Values (for Apply method): immediate | pending-reboot  You can use
  the immediate value with dynamic parameters only. You can use the pending-reboot value for
  both dynamic and static parameters, and changes are applied when DB instance reboots.
  Oracle  Valid Values (for Apply method): pending-reboot
- `"ResetAllParameters"`: Specifies whether to reset all parameters in the DB parameter
  group to default values. By default, all parameters in the DB parameter group are reset to
  default values.
"""
function reset_dbparameter_group(
    DBParameterGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "ResetDBParameterGroup",
        Dict{String,Any}("DBParameterGroupName" => DBParameterGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function reset_dbparameter_group(
    DBParameterGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "ResetDBParameterGroup",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBParameterGroupName" => DBParameterGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_dbcluster_from_s3(dbcluster_identifier, engine, master_username, s3_bucket_name, s3_ingestion_role_arn, source_engine, source_engine_version)
    restore_dbcluster_from_s3(dbcluster_identifier, engine, master_username, s3_bucket_name, s3_ingestion_role_arn, source_engine, source_engine_version, params::Dict{String,<:Any})

Creates an Amazon Aurora DB cluster from MySQL data stored in an Amazon S3 bucket. Amazon
RDS must be authorized to access the Amazon S3 bucket and the data must be created using
the Percona XtraBackup utility as described in  Migrating Data from MySQL by Using an
Amazon S3 Bucket in the Amazon Aurora User Guide.  This operation only restores the DB
cluster, not the DB instances for that DB cluster. You must invoke the CreateDBInstance
operation to create DB instances for the restored DB cluster, specifying the identifier of
the restored DB cluster in DBClusterIdentifier. You can create DB instances only after the
RestoreDBClusterFromS3 operation has completed and the DB cluster is available.  For more
information on Amazon Aurora, see  What is Amazon Aurora? in the Amazon Aurora User Guide.
This operation only applies to Aurora DB clusters. The source DB engine must be MySQL.

# Arguments
- `dbcluster_identifier`: The name of the DB cluster to create from the source data in the
  Amazon S3 bucket. This parameter isn't case-sensitive. Constraints:   Must contain from 1
  to 63 letters, numbers, or hyphens.   First character must be a letter.   Can't end with a
  hyphen or contain two consecutive hyphens.   Example: my-cluster1
- `engine`: The name of the database engine to be used for this DB cluster. Valid Values:
  aurora-mysql (for Aurora MySQL)
- `master_username`: The name of the master user for the restored DB cluster. Constraints:
   Must be 1 to 16 letters or numbers.   First character must be a letter.   Can't be a
  reserved word for the chosen database engine.
- `s3_bucket_name`: The name of the Amazon S3 bucket that contains the data used to create
  the Amazon Aurora DB cluster.
- `s3_ingestion_role_arn`: The Amazon Resource Name (ARN) of the Amazon Web Services
  Identity and Access Management (IAM) role that authorizes Amazon RDS to access the Amazon
  S3 bucket on your behalf.
- `source_engine`: The identifier for the database engine that was backed up to create the
  files stored in the Amazon S3 bucket. Valid Values: mysql
- `source_engine_version`: The version of the database that the backup files were created
  from. MySQL versions 5.7 and 8.0 are supported. Example: 5.7.40, 8.0.28

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AvailabilityZones"`: A list of Availability Zones (AZs) where instances in the restored
  DB cluster can be created.
- `"BacktrackWindow"`: The target backtrack window, in seconds. To disable backtracking,
  set this value to 0.  Currently, Backtrack is only supported for Aurora MySQL DB clusters.
  Default: 0 Constraints:   If specified, this value must be set to a number from 0 to
  259,200 (72 hours).
- `"BackupRetentionPeriod"`: The number of days for which automated backups of the restored
  DB cluster are retained. You must specify a minimum value of 1. Default: 1 Constraints:
  Must be a value from 1 to 35
- `"CharacterSetName"`: A value that indicates that the restored DB cluster should be
  associated with the specified CharacterSet.
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the restored DB cluster
  to snapshots of the restored DB cluster. The default is not to copy them.
- `"DBClusterParameterGroupName"`: The name of the DB cluster parameter group to associate
  with the restored DB cluster. If this argument is omitted, the default parameter group for
  the engine version is used. Constraints:   If supplied, must match the name of an existing
  DBClusterParameterGroup.
- `"DBSubnetGroupName"`: A DB subnet group to associate with the restored DB cluster.
  Constraints: If supplied, must match the name of an existing DBSubnetGroup. Example:
  mydbsubnetgroup
- `"DatabaseName"`: The database name for the restored DB cluster.
- `"DeletionProtection"`: Specifies whether to enable deletion protection for the DB
  cluster. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled.
- `"Domain"`: Specify the Active Directory directory ID to restore the DB cluster in. The
  domain must be created prior to this operation. For Amazon Aurora DB clusters, Amazon RDS
  can use Kerberos Authentication to authenticate users that connect to the DB cluster. For
  more information, see Kerberos Authentication in the Amazon Aurora User Guide.
- `"DomainIAMRoleName"`: Specify the name of the IAM role to be used when making API calls
  to the Directory Service.
- `"EnableCloudwatchLogsExports"`: The list of logs that the restored DB cluster is to
  export to CloudWatch Logs. The values in the list depend on the DB engine being used.
  Aurora MySQL  Possible values are audit, error, general, and slowquery. For more
  information about exporting CloudWatch Logs for Amazon Aurora, see Publishing Database Logs
  to Amazon CloudWatch Logs in the Amazon Aurora User Guide.
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. For more information, see  IAM Database Authentication in the Amazon
  Aurora User Guide.
- `"EngineLifecycleSupport"`: The life cycle type for this DB cluster.  By default, this
  value is set to open-source-rds-extended-support, which enrolls your DB cluster into Amazon
  RDS Extended Support. At the end of standard support, you can avoid charges for Extended
  Support by setting the value to open-source-rds-extended-support-disabled. In this case,
  RDS automatically upgrades your restored DB cluster to a higher engine version, if the
  major engine version is past its end of standard support date.  You can use this setting to
  enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can
  run the selected major engine version on your DB cluster past the end of standard support
  for that engine version. For more information, see the following sections:   Amazon Aurora
  (PostgreSQL only) - Using Amazon RDS Extended Support in the Amazon Aurora User Guide
  Amazon RDS - Using Amazon RDS Extended Support in the Amazon RDS User Guide    Valid for
  Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Valid Values:
  open-source-rds-extended-support | open-source-rds-extended-support-disabled  Default:
  open-source-rds-extended-support
- `"EngineVersion"`: The version number of the database engine to use. To list all of the
  available engine versions for aurora-mysql (Aurora MySQL), use the following command:  aws
  rds describe-db-engine-versions --engine aurora-mysql --query
  \"DBEngineVersions[].EngineVersion\"   Aurora MySQL  Examples: 5.7.mysql_aurora.2.12.0,
  8.0.mysql_aurora.3.04.0
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier for an encrypted DB cluster. The
  Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name for
  the KMS key. To use a KMS key in a different Amazon Web Services account, specify the key
  ARN or alias ARN. If the StorageEncrypted parameter is enabled, and you do not specify a
  value for the KmsKeyId parameter, then Amazon RDS will use your default KMS key. There is a
  default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
  a different default KMS key for each Amazon Web Services Region.
- `"ManageMasterUserPassword"`: Specifies whether to manage the master user password with
  Amazon Web Services Secrets Manager. For more information, see Password management with
  Amazon Web Services Secrets Manager in the Amazon RDS User Guide and Password management
  with Amazon Web Services Secrets Manager in the Amazon Aurora User Guide.  Constraints:
  Can't manage the master user password with Amazon Web Services Secrets Manager if
  MasterUserPassword is specified.
- `"MasterUserPassword"`: The password for the master database user. This password can
  contain any printable ASCII character except \"/\", \"\"\", or \"@\". Constraints:   Must
  contain from 8 to 41 characters.   Can't be specified if ManageMasterUserPassword is turned
  on.
- `"MasterUserSecretKmsKeyId"`: The Amazon Web Services KMS key identifier to encrypt a
  secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
  This setting is valid only if the master user password is managed by RDS in Amazon Web
  Services Secrets Manager for the DB cluster. The Amazon Web Services KMS key identifier is
  the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a
  different Amazon Web Services account, specify the key ARN or alias ARN. If you don't
  specify MasterUserSecretKmsKeyId, then the aws/secretsmanager KMS key is used to encrypt
  the secret. If the secret is in a different Amazon Web Services account, then you can't use
  the aws/secretsmanager KMS key to encrypt the secret, and you must use a customer managed
  KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
  Services account has a different default KMS key for each Amazon Web Services Region.
- `"NetworkType"`: The network type of the DB cluster. Valid Values:    IPV4     DUAL
  The network type is determined by the DBSubnetGroup specified for the DB cluster. A
  DBSubnetGroup can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (DUAL).
  For more information, see  Working with a DB instance in a VPC in the Amazon Aurora User
  Guide.
- `"OptionGroupName"`: A value that indicates that the restored DB cluster should be
  associated with the specified option group. Permanent options can't be removed from an
  option group. An option group can't be removed from a DB cluster once it is associated with
  a DB cluster.
- `"Port"`: The port number on which the instances in the restored DB cluster accept
  connections. Default: 3306
- `"PreferredBackupWindow"`: The daily time range during which automated backups are
  created if automated backups are enabled using the BackupRetentionPeriod parameter. The
  default is a 30-minute window selected at random from an 8-hour block of time for each
  Amazon Web Services Region. To view the time blocks available, see  Backup window in the
  Amazon Aurora User Guide. Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be
  in Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance
  window.   Must be at least 30 minutes.
- `"PreferredMaintenanceWindow"`: The weekly time range during which system maintenance can
  occur, in Universal Coordinated Time (UTC). Format: ddd:hh24:mi-ddd:hh24:mi  The default is
  a 30-minute window selected at random from an 8-hour block of time for each Amazon Web
  Services Region, occurring on a random day of the week. To see the time blocks available,
  see  Adjusting the Preferred Maintenance Window in the Amazon Aurora User Guide. Valid
  Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun. Constraints: Minimum 30-minute window.
- `"S3Prefix"`: The prefix for all of the file names that contain the data used to create
  the Amazon Aurora DB cluster. If you do not specify a SourceS3Prefix value, then the Amazon
  Aurora DB cluster is created by using all of the files in the Amazon S3 bucket.
- `"ServerlessV2ScalingConfiguration"`:
- `"StorageEncrypted"`: Specifies whether the restored DB cluster is encrypted.
- `"StorageType"`: Specifies the storage type to be associated with the DB cluster. Valid
  Values: aurora, aurora-iopt1  Default: aurora  Valid for: Aurora DB clusters only
- `"Tags"`:
- `"VpcSecurityGroupIds"`: A list of EC2 VPC security groups to associate with the restored
  DB cluster.
"""
function restore_dbcluster_from_s3(
    DBClusterIdentifier,
    Engine,
    MasterUsername,
    S3BucketName,
    S3IngestionRoleArn,
    SourceEngine,
    SourceEngineVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBClusterFromS3",
        Dict{String,Any}(
            "DBClusterIdentifier" => DBClusterIdentifier,
            "Engine" => Engine,
            "MasterUsername" => MasterUsername,
            "S3BucketName" => S3BucketName,
            "S3IngestionRoleArn" => S3IngestionRoleArn,
            "SourceEngine" => SourceEngine,
            "SourceEngineVersion" => SourceEngineVersion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_dbcluster_from_s3(
    DBClusterIdentifier,
    Engine,
    MasterUsername,
    S3BucketName,
    S3IngestionRoleArn,
    SourceEngine,
    SourceEngineVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBClusterFromS3",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterIdentifier" => DBClusterIdentifier,
                    "Engine" => Engine,
                    "MasterUsername" => MasterUsername,
                    "S3BucketName" => S3BucketName,
                    "S3IngestionRoleArn" => S3IngestionRoleArn,
                    "SourceEngine" => SourceEngine,
                    "SourceEngineVersion" => SourceEngineVersion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_dbcluster_from_snapshot(dbcluster_identifier, engine, snapshot_identifier)
    restore_dbcluster_from_snapshot(dbcluster_identifier, engine, snapshot_identifier, params::Dict{String,<:Any})

Creates a new DB cluster from a DB snapshot or DB cluster snapshot. The target DB cluster
is created from the source snapshot with a default configuration. If you don't specify a
security group, the new DB cluster is associated with the default security group.  This
operation only restores the DB cluster, not the DB instances for that DB cluster. You must
invoke the CreateDBInstance operation to create DB instances for the restored DB cluster,
specifying the identifier of the restored DB cluster in DBClusterIdentifier. You can create
DB instances only after the RestoreDBClusterFromSnapshot operation has completed and the DB
cluster is available.  For more information on Amazon Aurora DB clusters, see  What is
Amazon Aurora? in the Amazon Aurora User Guide. For more information on Multi-AZ DB
clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The name of the DB cluster to create from the DB snapshot or DB
  cluster snapshot. This parameter isn't case-sensitive. Constraints:   Must contain from 1
  to 63 letters, numbers, or hyphens   First character must be a letter   Can't end with a
  hyphen or contain two consecutive hyphens   Example: my-snapshot-id  Valid for: Aurora DB
  clusters and Multi-AZ DB clusters
- `engine`: The database engine to use for the new DB cluster. Default: The same as source
  Constraint: Must be compatible with the engine of the source Valid for: Aurora DB clusters
  and Multi-AZ DB clusters
- `snapshot_identifier`: The identifier for the DB snapshot or DB cluster snapshot to
  restore from. You can use either the name or the Amazon Resource Name (ARN) to specify a DB
  cluster snapshot. However, you can use only the ARN to specify a DB snapshot. Constraints:
   Must match the identifier of an existing Snapshot.   Valid for: Aurora DB clusters and
  Multi-AZ DB clusters

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AvailabilityZones"`: Provides the list of Availability Zones (AZs) where instances in
  the restored DB cluster can be created. Valid for: Aurora DB clusters only
- `"BacktrackWindow"`: The target backtrack window, in seconds. To disable backtracking,
  set this value to 0.  Currently, Backtrack is only supported for Aurora MySQL DB clusters.
  Default: 0 Constraints:   If specified, this value must be set to a number from 0 to
  259,200 (72 hours).   Valid for: Aurora DB clusters only
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the restored DB cluster
  to snapshots of the restored DB cluster. The default is not to copy them. Valid for: Aurora
  DB clusters and Multi-AZ DB clusters
- `"DBClusterInstanceClass"`: The compute and memory capacity of the each DB instance in
  the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are
  available in all Amazon Web Services Regions, or for all database engines. For the full
  list of DB instance classes, and availability for your engine, see DB Instance Class in the
  Amazon RDS User Guide.  Valid for: Multi-AZ DB clusters only
- `"DBClusterParameterGroupName"`: The name of the DB cluster parameter group to associate
  with this DB cluster. If this argument is omitted, the default DB cluster parameter group
  for the specified engine is used. Constraints:   If supplied, must match the name of an
  existing default DB cluster parameter group.   Must be 1 to 255 letters, numbers, or
  hyphens.   First character must be a letter.   Can't end with a hyphen or contain two
  consecutive hyphens.   Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"DBSubnetGroupName"`: The name of the DB subnet group to use for the new DB cluster.
  Constraints: If supplied, must match the name of an existing DB subnet group. Example:
  mydbsubnetgroup  Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"DatabaseName"`: The database name for the restored DB cluster. Valid for: Aurora DB
  clusters and Multi-AZ DB clusters
- `"DeletionProtection"`: Specifies whether to enable deletion protection for the DB
  cluster. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled. Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"Domain"`: The Active Directory directory ID to restore the DB cluster in. The domain
  must be created prior to this operation. Currently, only MySQL, Microsoft SQL Server,
  Oracle, and PostgreSQL DB instances can be created in an Active Directory Domain. For more
  information, see  Kerberos Authentication in the Amazon RDS User Guide. Valid for: Aurora
  DB clusters only
- `"DomainIAMRoleName"`: The name of the IAM role to be used when making API calls to the
  Directory Service. Valid for: Aurora DB clusters only
- `"EnableCloudwatchLogsExports"`: The list of logs that the restored DB cluster is to
  export to Amazon CloudWatch Logs. The values in the list depend on the DB engine being
  used.  RDS for MySQL  Possible values are error, general, and slowquery.  RDS for
  PostgreSQL  Possible values are postgresql and upgrade.  Aurora MySQL  Possible values are
  audit, error, general, and slowquery.  Aurora PostgreSQL  Possible value is postgresql. For
  more information about exporting CloudWatch Logs for Amazon RDS, see Publishing Database
  Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide. For more information about
  exporting CloudWatch Logs for Amazon Aurora, see Publishing Database Logs to Amazon
  CloudWatch Logs in the Amazon Aurora User Guide. Valid for: Aurora DB clusters and Multi-AZ
  DB clusters
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. For more information, see  IAM Database Authentication in the Amazon
  Aurora User Guide. Valid for: Aurora DB clusters only
- `"EngineLifecycleSupport"`: The life cycle type for this DB cluster.  By default, this
  value is set to open-source-rds-extended-support, which enrolls your DB cluster into Amazon
  RDS Extended Support. At the end of standard support, you can avoid charges for Extended
  Support by setting the value to open-source-rds-extended-support-disabled. In this case,
  RDS automatically upgrades your restored DB cluster to a higher engine version, if the
  major engine version is past its end of standard support date.  You can use this setting to
  enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can
  run the selected major engine version on your DB cluster past the end of standard support
  for that engine version. For more information, see the following sections:   Amazon Aurora
  (PostgreSQL only) - Using Amazon RDS Extended Support in the Amazon Aurora User Guide
  Amazon RDS - Using Amazon RDS Extended Support in the Amazon RDS User Guide    Valid for
  Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Valid Values:
  open-source-rds-extended-support | open-source-rds-extended-support-disabled  Default:
  open-source-rds-extended-support
- `"EngineMode"`: The DB engine mode of the DB cluster, either provisioned or serverless.
  For more information, see  CreateDBCluster. Valid for: Aurora DB clusters only
- `"EngineVersion"`: The version of the database engine to use for the new DB cluster. If
  you don't specify an engine version, the default version for the database engine in the
  Amazon Web Services Region is used. To list all of the available engine versions for Aurora
  MySQL, use the following command:  aws rds describe-db-engine-versions --engine
  aurora-mysql --query \"DBEngineVersions[].EngineVersion\"  To list all of the available
  engine versions for Aurora PostgreSQL, use the following command:  aws rds
  describe-db-engine-versions --engine aurora-postgresql --query
  \"DBEngineVersions[].EngineVersion\"  To list all of the available engine versions for RDS
  for MySQL, use the following command:  aws rds describe-db-engine-versions --engine mysql
  --query \"DBEngineVersions[].EngineVersion\"  To list all of the available engine versions
  for RDS for PostgreSQL, use the following command:  aws rds describe-db-engine-versions
  --engine postgres --query \"DBEngineVersions[].EngineVersion\"   Aurora MySQL  See Database
  engine updates for Amazon Aurora MySQL in the Amazon Aurora User Guide.  Aurora PostgreSQL
  See Amazon Aurora PostgreSQL releases and engine versions in the Amazon Aurora User Guide.
  MySQL  See Amazon RDS for MySQL in the Amazon RDS User Guide.   PostgreSQL  See Amazon RDS
  for PostgreSQL versions and extensions in the Amazon RDS User Guide.  Valid for: Aurora DB
  clusters and Multi-AZ DB clusters
- `"Iops"`: The amount of Provisioned IOPS (input/output operations per second) to be
  initially allocated for each DB instance in the Multi-AZ DB cluster. For information about
  valid IOPS values, see Amazon RDS Provisioned IOPS storage in the Amazon RDS User Guide.
  Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB
  instance. Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier to use when restoring an
  encrypted DB cluster from a DB snapshot or DB cluster snapshot. The Amazon Web Services KMS
  key identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a
  KMS key in a different Amazon Web Services account, specify the key ARN or alias ARN. When
  you don't specify a value for the KmsKeyId parameter, then the following occurs:   If the
  DB snapshot or DB cluster snapshot in SnapshotIdentifier is encrypted, then the restored DB
  cluster is encrypted using the KMS key that was used to encrypt the DB snapshot or DB
  cluster snapshot.   If the DB snapshot or DB cluster snapshot in SnapshotIdentifier isn't
  encrypted, then the restored DB cluster isn't encrypted.   Valid for: Aurora DB clusters
  and Multi-AZ DB clusters
- `"NetworkType"`: The network type of the DB cluster. Valid Values:    IPV4     DUAL
  The network type is determined by the DBSubnetGroup specified for the DB cluster. A
  DBSubnetGroup can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (DUAL).
  For more information, see  Working with a DB instance in a VPC in the Amazon Aurora User
  Guide.  Valid for: Aurora DB clusters only
- `"OptionGroupName"`: The name of the option group to use for the restored DB cluster. DB
  clusters are associated with a default option group that can't be modified.
- `"Port"`: The port number on which the new DB cluster accepts connections. Constraints:
  This value must be 1150-65535  Default: The same port as the original DB cluster. Valid
  for: Aurora DB clusters and Multi-AZ DB clusters
- `"PubliclyAccessible"`: Specifies whether the DB cluster is publicly accessible. When the
  DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
  private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to
  the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is
  ultimately controlled by the security group it uses. That public access is not permitted if
  the security group assigned to the DB cluster doesn't permit it. When the DB cluster isn't
  publicly accessible, it is an internal DB cluster with a DNS name that resolves to a
  private IP address. Default: The default behavior varies depending on whether
  DBSubnetGroupName is specified. If DBSubnetGroupName isn't specified, and
  PubliclyAccessible isn't specified, the following applies:   If the default VPC in the
  target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
    If the default VPC in the target Region has an internet gateway attached to it, the DB
  cluster is public.   If DBSubnetGroupName is specified, and PubliclyAccessible isn't
  specified, the following applies:   If the subnets are part of a VPC that doesn’t have an
  internet gateway attached to it, the DB cluster is private.   If the subnets are part of a
  VPC that has an internet gateway attached to it, the DB cluster is public.   Valid for:
  Aurora DB clusters and Multi-AZ DB clusters
- `"RdsCustomClusterConfiguration"`: Reserved for future use.
- `"ScalingConfiguration"`: For DB clusters in serverless DB engine mode, the scaling
  properties of the DB cluster. Valid for: Aurora DB clusters only
- `"ServerlessV2ScalingConfiguration"`:
- `"StorageType"`: Specifies the storage type to be associated with the DB cluster. When
  specified for a Multi-AZ DB cluster, a value for the Iops parameter is required. Valid
  Values: aurora, aurora-iopt1 (Aurora DB clusters); io1 (Multi-AZ DB clusters) Default:
  aurora (Aurora DB clusters); io1 (Multi-AZ DB clusters) Valid for: Aurora DB clusters and
  Multi-AZ DB clusters
- `"Tags"`: The tags to be assigned to the restored DB cluster. Valid for: Aurora DB
  clusters and Multi-AZ DB clusters
- `"VpcSecurityGroupIds"`: A list of VPC security groups that the new DB cluster will
  belong to. Valid for: Aurora DB clusters and Multi-AZ DB clusters
"""
function restore_dbcluster_from_snapshot(
    DBClusterIdentifier,
    Engine,
    SnapshotIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBClusterFromSnapshot",
        Dict{String,Any}(
            "DBClusterIdentifier" => DBClusterIdentifier,
            "Engine" => Engine,
            "SnapshotIdentifier" => SnapshotIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_dbcluster_from_snapshot(
    DBClusterIdentifier,
    Engine,
    SnapshotIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBClusterFromSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBClusterIdentifier" => DBClusterIdentifier,
                    "Engine" => Engine,
                    "SnapshotIdentifier" => SnapshotIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_dbcluster_to_point_in_time(dbcluster_identifier)
    restore_dbcluster_to_point_in_time(dbcluster_identifier, params::Dict{String,<:Any})

Restores a DB cluster to an arbitrary point in time. Users can restore to any point in time
before LatestRestorableTime for up to BackupRetentionPeriod days. The target DB cluster is
created from the source DB cluster with the same configuration as the original DB cluster,
except that the new DB cluster is created with the default DB security group.  For Aurora,
this operation only restores the DB cluster, not the DB instances for that DB cluster. You
must invoke the CreateDBInstance operation to create DB instances for the restored DB
cluster, specifying the identifier of the restored DB cluster in DBClusterIdentifier. You
can create DB instances only after the RestoreDBClusterToPointInTime operation has
completed and the DB cluster is available.  For more information on Amazon Aurora DB
clusters, see  What is Amazon Aurora? in the Amazon Aurora User Guide. For more information
on Multi-AZ DB clusters, see  Multi-AZ DB cluster deployments in the Amazon RDS User Guide.

# Arguments
- `dbcluster_identifier`: The name of the new DB cluster to be created. Constraints:   Must
  contain from 1 to 63 letters, numbers, or hyphens   First character must be a letter
  Can't end with a hyphen or contain two consecutive hyphens   Valid for: Aurora DB clusters
  and Multi-AZ DB clusters

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BacktrackWindow"`: The target backtrack window, in seconds. To disable backtracking,
  set this value to 0. Default: 0 Constraints:   If specified, this value must be set to a
  number from 0 to 259,200 (72 hours).   Valid for: Aurora MySQL DB clusters only
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the restored DB cluster
  to snapshots of the restored DB cluster. The default is not to copy them. Valid for: Aurora
  DB clusters and Multi-AZ DB clusters
- `"DBClusterInstanceClass"`: The compute and memory capacity of the each DB instance in
  the Multi-AZ DB cluster, for example db.m6gd.xlarge. Not all DB instance classes are
  available in all Amazon Web Services Regions, or for all database engines. For the full
  list of DB instance classes, and availability for your engine, see DB instance class in the
  Amazon RDS User Guide. Valid for: Multi-AZ DB clusters only
- `"DBClusterParameterGroupName"`: The name of the custom DB cluster parameter group to
  associate with this DB cluster. If the DBClusterParameterGroupName parameter is omitted,
  the default DB cluster parameter group for the specified engine is used. Constraints:   If
  supplied, must match the name of an existing DB cluster parameter group.   Must be 1 to 255
  letters, numbers, or hyphens.   First character must be a letter.   Can't end with a hyphen
  or contain two consecutive hyphens.   Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"DBSubnetGroupName"`: The DB subnet group name to use for the new DB cluster.
  Constraints: If supplied, must match the name of an existing DBSubnetGroup. Example:
  mydbsubnetgroup  Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"DeletionProtection"`: Specifies whether to enable deletion protection for the DB
  cluster. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled. Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"Domain"`: The Active Directory directory ID to restore the DB cluster in. The domain
  must be created prior to this operation. For Amazon Aurora DB clusters, Amazon RDS can use
  Kerberos Authentication to authenticate users that connect to the DB cluster. For more
  information, see Kerberos Authentication in the Amazon Aurora User Guide. Valid for: Aurora
  DB clusters only
- `"DomainIAMRoleName"`: The name of the IAM role to be used when making API calls to the
  Directory Service. Valid for: Aurora DB clusters only
- `"EnableCloudwatchLogsExports"`: The list of logs that the restored DB cluster is to
  export to CloudWatch Logs. The values in the list depend on the DB engine being used.  RDS
  for MySQL  Possible values are error, general, and slowquery.  RDS for PostgreSQL  Possible
  values are postgresql and upgrade.  Aurora MySQL  Possible values are audit, error,
  general, and slowquery.  Aurora PostgreSQL  Possible value is postgresql. For more
  information about exporting CloudWatch Logs for Amazon RDS, see Publishing Database Logs to
  Amazon CloudWatch Logs in the Amazon RDS User Guide. For more information about exporting
  CloudWatch Logs for Amazon Aurora, see Publishing Database Logs to Amazon CloudWatch Logs
  in the Amazon Aurora User Guide. Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. For more information, see  IAM Database Authentication in the Amazon
  Aurora User Guide. Valid for: Aurora DB clusters only
- `"EngineLifecycleSupport"`: The life cycle type for this DB cluster.  By default, this
  value is set to open-source-rds-extended-support, which enrolls your DB cluster into Amazon
  RDS Extended Support. At the end of standard support, you can avoid charges for Extended
  Support by setting the value to open-source-rds-extended-support-disabled. In this case,
  RDS automatically upgrades your restored DB cluster to a higher engine version, if the
  major engine version is past its end of standard support date.  You can use this setting to
  enroll your DB cluster into Amazon RDS Extended Support. With RDS Extended Support, you can
  run the selected major engine version on your DB cluster past the end of standard support
  for that engine version. For more information, see the following sections:   Amazon Aurora
  (PostgreSQL only) - Using Amazon RDS Extended Support in the Amazon Aurora User Guide
  Amazon RDS - Using Amazon RDS Extended Support in the Amazon RDS User Guide    Valid for
  Cluster Type: Aurora DB clusters and Multi-AZ DB clusters Valid Values:
  open-source-rds-extended-support | open-source-rds-extended-support-disabled  Default:
  open-source-rds-extended-support
- `"EngineMode"`: The engine mode of the new cluster. Specify provisioned or serverless,
  depending on the type of the cluster you are creating. You can create an Aurora Serverless
  v1 clone from a provisioned cluster, or a provisioned clone from an Aurora Serverless v1
  cluster. To create a clone that is an Aurora Serverless v1 cluster, the original cluster
  must be an Aurora Serverless v1 cluster or an encrypted provisioned cluster. Valid for:
  Aurora DB clusters only
- `"Iops"`: The amount of Provisioned IOPS (input/output operations per second) to be
  initially allocated for each DB instance in the Multi-AZ DB cluster. For information about
  valid IOPS values, see Amazon RDS Provisioned IOPS storage in the Amazon RDS User Guide.
  Constraints: Must be a multiple between .5 and 50 of the storage amount for the DB
  instance. Valid for: Multi-AZ DB clusters only
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier to use when restoring an
  encrypted DB cluster from an encrypted DB cluster. The Amazon Web Services KMS key
  identifier is the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS
  key in a different Amazon Web Services account, specify the key ARN or alias ARN. You can
  restore to a new DB cluster and encrypt the new DB cluster with a KMS key that is different
  from the KMS key used to encrypt the source DB cluster. The new DB cluster is encrypted
  with the KMS key identified by the KmsKeyId parameter. If you don't specify a value for the
  KmsKeyId parameter, then the following occurs:   If the DB cluster is encrypted, then the
  restored DB cluster is encrypted using the KMS key that was used to encrypt the source DB
  cluster.   If the DB cluster isn't encrypted, then the restored DB cluster isn't encrypted.
    If DBClusterIdentifier refers to a DB cluster that isn't encrypted, then the restore
  request is rejected. Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"NetworkType"`: The network type of the DB cluster. Valid Values:    IPV4     DUAL
  The network type is determined by the DBSubnetGroup specified for the DB cluster. A
  DBSubnetGroup can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (DUAL).
  For more information, see  Working with a DB instance in a VPC in the Amazon Aurora User
  Guide.  Valid for: Aurora DB clusters only
- `"OptionGroupName"`: The name of the option group for the new DB cluster. DB clusters are
  associated with a default option group that can't be modified.
- `"Port"`: The port number on which the new DB cluster accepts connections. Constraints: A
  value from 1150-65535. Default: The default port for the engine. Valid for: Aurora DB
  clusters and Multi-AZ DB clusters
- `"PubliclyAccessible"`: Specifies whether the DB cluster is publicly accessible. When the
  DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to the
  private IP address from within the DB cluster's virtual private cloud (VPC). It resolves to
  the public IP address from outside of the DB cluster's VPC. Access to the DB cluster is
  ultimately controlled by the security group it uses. That public access is not permitted if
  the security group assigned to the DB cluster doesn't permit it. When the DB cluster isn't
  publicly accessible, it is an internal DB cluster with a DNS name that resolves to a
  private IP address. Default: The default behavior varies depending on whether
  DBSubnetGroupName is specified. If DBSubnetGroupName isn't specified, and
  PubliclyAccessible isn't specified, the following applies:   If the default VPC in the
  target Region doesn’t have an internet gateway attached to it, the DB cluster is private.
    If the default VPC in the target Region has an internet gateway attached to it, the DB
  cluster is public.   If DBSubnetGroupName is specified, and PubliclyAccessible isn't
  specified, the following applies:   If the subnets are part of a VPC that doesn’t have an
  internet gateway attached to it, the DB cluster is private.   If the subnets are part of a
  VPC that has an internet gateway attached to it, the DB cluster is public.   Valid for:
  Multi-AZ DB clusters only
- `"RdsCustomClusterConfiguration"`: Reserved for future use.
- `"RestoreToTime"`: The date and time to restore the DB cluster to. Valid Values: Value
  must be a time in Universal Coordinated Time (UTC) format Constraints:   Must be before the
  latest restorable time for the DB instance   Must be specified if UseLatestRestorableTime
  parameter isn't provided   Can't be specified if the UseLatestRestorableTime parameter is
  enabled   Can't be specified if the RestoreType parameter is copy-on-write    Example:
  2015-03-07T23:45:00Z  Valid for: Aurora DB clusters and Multi-AZ DB clusters
- `"RestoreType"`: The type of restore to be performed. You can specify one of the
  following values:    full-copy - The new DB cluster is restored as a full copy of the
  source DB cluster.    copy-on-write - The new DB cluster is restored as a clone of the
  source DB cluster.   If you don't specify a RestoreType value, then the new DB cluster is
  restored as a full copy of the source DB cluster. Valid for: Aurora DB clusters and
  Multi-AZ DB clusters
- `"ScalingConfiguration"`: For DB clusters in serverless DB engine mode, the scaling
  properties of the DB cluster. Valid for: Aurora DB clusters only
- `"ServerlessV2ScalingConfiguration"`:
- `"SourceDBClusterIdentifier"`: The identifier of the source DB cluster from which to
  restore. Constraints:   Must match the identifier of an existing DBCluster.   Valid for:
  Aurora DB clusters and Multi-AZ DB clusters
- `"SourceDbClusterResourceId"`: The resource ID of the source DB cluster from which to
  restore.
- `"StorageType"`: Specifies the storage type to be associated with the DB cluster. When
  specified for a Multi-AZ DB cluster, a value for the Iops parameter is required. Valid
  Values: aurora, aurora-iopt1 (Aurora DB clusters); io1 (Multi-AZ DB clusters) Default:
  aurora (Aurora DB clusters); io1 (Multi-AZ DB clusters) Valid for: Aurora DB clusters and
  Multi-AZ DB clusters
- `"Tags"`:
- `"UseLatestRestorableTime"`: Specifies whether to restore the DB cluster to the latest
  restorable backup time. By default, the DB cluster isn't restored to the latest restorable
  backup time. Constraints: Can't be specified if RestoreToTime parameter is provided. Valid
  for: Aurora DB clusters and Multi-AZ DB clusters
- `"VpcSecurityGroupIds"`: A list of VPC security groups that the new DB cluster belongs
  to. Valid for: Aurora DB clusters and Multi-AZ DB clusters
"""
function restore_dbcluster_to_point_in_time(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RestoreDBClusterToPointInTime",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_dbcluster_to_point_in_time(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBClusterToPointInTime",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_dbinstance_from_dbsnapshot(dbinstance_identifier)
    restore_dbinstance_from_dbsnapshot(dbinstance_identifier, params::Dict{String,<:Any})

Creates a new DB instance from a DB snapshot. The target database is created from the
source database restore point with most of the source's original configuration, including
the default security group and DB parameter group. By default, the new DB instance is
created as a Single-AZ deployment, except when the instance is a SQL Server instance that
has an option group associated with mirroring. In this case, the instance becomes a
Multi-AZ deployment, not a Single-AZ deployment. If you want to replace your original DB
instance with the new, restored DB instance, then rename your original DB instance before
you call the RestoreDBInstanceFromDBSnapshot operation. RDS doesn't allow two DB instances
with the same name. After you have renamed your original DB instance with a different
identifier, then you can pass the original name of the DB instance as the
DBInstanceIdentifier in the call to the RestoreDBInstanceFromDBSnapshot operation. The
result is that you replace the original DB instance with the DB instance created from the
snapshot. If you are restoring from a shared manual DB snapshot, the DBSnapshotIdentifier
must be the ARN of the shared DB snapshot.  This command doesn't apply to Aurora MySQL and
Aurora PostgreSQL. For Aurora, use RestoreDBClusterFromSnapshot.

# Arguments
- `dbinstance_identifier`: The name of the DB instance to create from the DB snapshot. This
  parameter isn't case-sensitive. Constraints:   Must contain from 1 to 63 numbers, letters,
  or hyphens.   First character must be a letter.   Can't end with a hyphen or contain two
  consecutive hyphens.   Example: my-snapshot-id

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocatedStorage"`: The amount of storage (in gibibytes) to allocate initially for the
  DB instance. Follow the allocation rules specified in CreateDBInstance.  Be sure to
  allocate enough storage for your new DB instance so that the restore operation can succeed.
  You can also allocate additional storage for future growth.
- `"AutoMinorVersionUpgrade"`: Specifies whether to automatically apply minor version
  upgrades to the DB instance during the maintenance window. If you restore an RDS Custom DB
  instance, you must disable this parameter.
- `"AvailabilityZone"`: The Availability Zone (AZ) where the DB instance will be created.
  Default: A random, system-chosen Availability Zone. Constraint: You can't specify the
  AvailabilityZone parameter if the DB instance is a Multi-AZ deployment. Example: us-east-1a
- `"BackupTarget"`: Specifies where automated backups and manual snapshots are stored for
  the restored DB instance. Possible values are outposts (Amazon Web Services Outposts) and
  region (Amazon Web Services Region). The default is region. For more information, see
  Working with Amazon RDS on Amazon Web Services Outposts in the Amazon RDS User Guide.
- `"CACertificateIdentifier"`: The CA certificate identifier to use for the DB instance's
  server certificate. This setting doesn't apply to RDS Custom DB instances. For more
  information, see Using SSL/TLS to encrypt a connection to a DB instance in the Amazon RDS
  User Guide and  Using SSL/TLS to encrypt a connection to a DB cluster in the Amazon Aurora
  User Guide.
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the restored DB instance
  to snapshots of the DB instance. In most cases, tags aren't copied by default. However,
  when you restore a DB instance from a DB snapshot, RDS checks whether you specify new tags.
  If yes, the new tags are added to the restored DB instance. If there are no new tags, RDS
  looks for the tags from the source DB instance for the DB snapshot, and then adds those
  tags to the restored DB instance. For more information, see  Copying tags to DB instance
  snapshots in the Amazon RDS User Guide.
- `"CustomIamInstanceProfile"`: The instance profile associated with the underlying Amazon
  EC2 instance of an RDS Custom DB instance. The instance profile must meet the following
  requirements:   The profile must exist in your account.   The profile must have an IAM role
  that Amazon EC2 has permissions to assume.   The instance profile name and the associated
  IAM role name must start with the prefix AWSRDSCustom.   For the list of permissions
  required for the IAM role, see  Configure IAM and your VPC in the Amazon RDS User Guide.
  This setting is required for RDS Custom.
- `"DBClusterSnapshotIdentifier"`: The identifier for the Multi-AZ DB cluster snapshot to
  restore from. For more information on Multi-AZ DB clusters, see  Multi-AZ DB cluster
  deployments in the Amazon RDS User Guide. Constraints:   Must match the identifier of an
  existing Multi-AZ DB cluster snapshot.   Can't be specified when DBSnapshotIdentifier is
  specified.   Must be specified when DBSnapshotIdentifier isn't specified.   If you are
  restoring from a shared manual Multi-AZ DB cluster snapshot, the
  DBClusterSnapshotIdentifier must be the ARN of the shared snapshot.   Can't be the
  identifier of an Aurora DB cluster snapshot.
- `"DBInstanceClass"`: The compute and memory capacity of the Amazon RDS DB instance, for
  example db.m4.large. Not all DB instance classes are available in all Amazon Web Services
  Regions, or for all database engines. For the full list of DB instance classes, and
  availability for your engine, see DB Instance Class in the Amazon RDS User Guide.  Default:
  The same DBInstanceClass as the original DB instance.
- `"DBName"`: The name of the database for the restored DB instance. This parameter only
  applies to RDS for Oracle and RDS for SQL Server DB instances. It doesn't apply to the
  other engines or to RDS Custom DB instances.
- `"DBParameterGroupName"`: The name of the DB parameter group to associate with this DB
  instance. If you don't specify a value for DBParameterGroupName, then RDS uses the default
  DBParameterGroup for the specified DB engine. This setting doesn't apply to RDS Custom.
  Constraints:   If supplied, must match the name of an existing DB parameter group.   Must
  be 1 to 255 letters, numbers, or hyphens.   First character must be a letter.   Can't end
  with a hyphen or contain two consecutive hyphens.
- `"DBSnapshotIdentifier"`: The identifier for the DB snapshot to restore from.
  Constraints:   Must match the identifier of an existing DB snapshot.   Can't be specified
  when DBClusterSnapshotIdentifier is specified.   Must be specified when
  DBClusterSnapshotIdentifier isn't specified.   If you are restoring from a shared manual DB
  snapshot, the DBSnapshotIdentifier must be the ARN of the shared DB snapshot.
- `"DBSubnetGroupName"`: The name of the DB subnet group to use for the new instance.
  Constraints:   If supplied, must match the name of an existing DB subnet group.   Example:
  mydbsubnetgroup
- `"DedicatedLogVolume"`: Specifies whether to enable a dedicated log volume (DLV) for the
  DB instance.
- `"DeletionProtection"`: Specifies whether to enable deletion protection for the DB
  instance. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled. For more information, see  Deleting a DB Instance.
- `"Domain"`: The Active Directory directory ID to restore the DB instance in. The domain/
  must be created prior to this operation. Currently, you can create only Db2, MySQL,
  Microsoft SQL Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain.
  For more information, see  Kerberos Authentication in the Amazon RDS User Guide. This
  setting doesn't apply to RDS Custom.
- `"DomainAuthSecretArn"`: The ARN for the Secrets Manager secret with the credentials for
  the user joining the domain. Constraints:   Can't be longer than 64 characters.   Example:
  arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456
- `"DomainDnsIps"`: The IPv4 DNS IP addresses of your primary and secondary Active
  Directory domain controllers. Constraints:   Two IP addresses must be provided. If there
  isn't a secondary domain controller, use the IP address of the primary domain controller
  for both entries in the list.   Example: 123.124.125.126,234.235.236.237
- `"DomainFqdn"`: The fully qualified domain name (FQDN) of an Active Directory domain.
  Constraints:   Can't be longer than 64 characters.   Example:
  mymanagedADtest.mymanagedAD.mydomain
- `"DomainIAMRoleName"`: The name of the IAM role to use when making API calls to the
  Directory Service. This setting doesn't apply to RDS Custom DB instances.
- `"DomainOu"`: The Active Directory organizational unit for your DB instance to join.
  Constraints:   Must be in the distinguished name format.   Can't be longer than 64
  characters.   Example: OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain
- `"EnableCloudwatchLogsExports"`: The list of logs for the restored DB instance to export
  to CloudWatch Logs. The values in the list depend on the DB engine. For more information,
  see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS User Guide. This
  setting doesn't apply to RDS Custom.
- `"EnableCustomerOwnedIp"`: Specifies whether to enable a customer-owned IP address (CoIP)
  for an RDS on Outposts DB instance. A CoIP provides local or external connectivity to
  resources in your Outpost subnets through your on-premises network. For some use cases, a
  CoIP can provide lower latency for connections to the DB instance from outside of its
  virtual private cloud (VPC) on your local network. This setting doesn't apply to RDS
  Custom. For more information about RDS on Outposts, see Working with Amazon RDS on Amazon
  Web Services Outposts in the Amazon RDS User Guide. For more information about CoIPs, see
  Customer-owned IP addresses in the Amazon Web Services Outposts User Guide.
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping is disabled. For more information about IAM database authentication, see  IAM
  Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide.  This
  setting doesn't apply to RDS Custom.
- `"Engine"`: The database engine to use for the new instance. This setting doesn't apply
  to RDS Custom. Default: The same as source Constraint: Must be compatible with the engine
  of the source. For example, you can restore a MariaDB 10.1 DB instance from a MySQL 5.6
  snapshot. Valid Values:    db2-ae     db2-se     mariadb     mysql     oracle-ee
  oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee
  sqlserver-se     sqlserver-ex     sqlserver-web
- `"EngineLifecycleSupport"`: The life cycle type for this DB instance.  By default, this
  value is set to open-source-rds-extended-support, which enrolls your DB instance into
  Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
  Extended Support by setting the value to open-source-rds-extended-support-disabled. In this
  case, RDS automatically upgrades your restored DB instance to a higher engine version, if
  the major engine version is past its end of standard support date.  You can use this
  setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended
  Support, you can run the selected major engine version on your DB instance past the end of
  standard support for that engine version. For more information, see Using Amazon RDS
  Extended Support in the Amazon RDS User Guide. This setting applies only to RDS for MySQL
  and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by
  the DB cluster. Valid Values: open-source-rds-extended-support |
  open-source-rds-extended-support-disabled  Default: open-source-rds-extended-support
- `"Iops"`: Specifies the amount of provisioned IOPS for the DB instance, expressed in I/O
  operations per second. If this parameter isn't specified, the IOPS value is taken from the
  backup. If this parameter is set to 0, the new instance is converted to a non-PIOPS
  instance. The conversion takes additional time, though your DB instance is available for
  connections before the conversion starts. The provisioned IOPS value must follow the
  requirements for your database engine. For more information, see Amazon RDS Provisioned
  IOPS storage in the Amazon RDS User Guide.  Constraints: Must be an integer greater than
  1000.
- `"LicenseModel"`: License model information for the restored DB instance.  License models
  for RDS for Db2 require additional configuration. The Bring Your Own License (BYOL) model
  requires a custom parameter group. The Db2 license through Amazon Web Services Marketplace
  model requires an Amazon Web Services Marketplace subscription. For more information, see
  RDS for Db2 licensing options in the Amazon RDS User Guide.  This setting doesn't apply to
  Amazon Aurora or RDS Custom DB instances. Valid Values:   RDS for Db2 -
  bring-your-own-license | marketplace-license    RDS for MariaDB - general-public-license
  RDS for Microsoft SQL Server - license-included    RDS for MySQL - general-public-license
   RDS for Oracle - bring-your-own-license | license-included    RDS for PostgreSQL -
  postgresql-license    Default: Same as the source.
- `"MultiAZ"`: Specifies whether the DB instance is a Multi-AZ deployment. This setting
  doesn't apply to RDS Custom. Constraint: You can't specify the AvailabilityZone parameter
  if the DB instance is a Multi-AZ deployment.
- `"NetworkType"`: The network type of the DB instance. Valid Values:    IPV4     DUAL
  The network type is determined by the DBSubnetGroup specified for the DB instance. A
  DBSubnetGroup can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (DUAL).
  For more information, see  Working with a DB instance in a VPC in the Amazon RDS User
  Guide.
- `"OptionGroupName"`: The name of the option group to be used for the restored DB
  instance. Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't
  be removed from an option group, and that option group can't be removed from a DB instance
  after it is associated with a DB instance. This setting doesn't apply to RDS Custom.
- `"Port"`: The port number on which the database accepts connections. Default: The same
  port as the original DB instance Constraints: Value must be 1150-65535
- `"ProcessorFeatures"`: The number of CPU cores and the number of threads per core for the
  DB instance class of the DB instance. This setting doesn't apply to RDS Custom.
- `"PubliclyAccessible"`: Specifies whether the DB instance is publicly accessible. When
  the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to
  the private IP address from within the DB instance's virtual private cloud (VPC). It
  resolves to the public IP address from outside of the DB instance's VPC. Access to the DB
  instance is ultimately controlled by the security group it uses. That public access is not
  permitted if the security group assigned to the DB instance doesn't permit it. When the DB
  instance isn't publicly accessible, it is an internal DB instance with a DNS name that
  resolves to a private IP address. For more information, see CreateDBInstance.
- `"StorageThroughput"`: Specifies the storage throughput value for the DB instance. This
  setting doesn't apply to RDS Custom or Amazon Aurora.
- `"StorageType"`: Specifies the storage type to be associated with the DB instance. Valid
  Values: gp2 | gp3 | io1 | io2 | standard  If you specify io1, io2, or gp3, you must also
  include a value for the Iops parameter. Default: io1 if the Iops parameter is specified,
  otherwise gp2
- `"Tags"`:
- `"TdeCredentialArn"`: The ARN from the key store with which to associate the instance for
  TDE encryption. This setting doesn't apply to RDS Custom.
- `"TdeCredentialPassword"`: The password for the given ARN from the key store in order to
  access the device. This setting doesn't apply to RDS Custom.
- `"UseDefaultProcessorFeatures"`: Specifies whether the DB instance class of the DB
  instance uses its default processor features. This setting doesn't apply to RDS Custom.
- `"VpcSecurityGroupIds"`: A list of EC2 VPC security groups to associate with this DB
  instance. Default: The default EC2 VPC security group for the DB subnet group's VPC.
"""
function restore_dbinstance_from_dbsnapshot(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RestoreDBInstanceFromDBSnapshot",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_dbinstance_from_dbsnapshot(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBInstanceFromDBSnapshot",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_dbinstance_from_s3(dbinstance_class, dbinstance_identifier, engine, s3_bucket_name, s3_ingestion_role_arn, source_engine, source_engine_version)
    restore_dbinstance_from_s3(dbinstance_class, dbinstance_identifier, engine, s3_bucket_name, s3_ingestion_role_arn, source_engine, source_engine_version, params::Dict{String,<:Any})

Amazon Relational Database Service (Amazon RDS) supports importing MySQL databases by using
backup files. You can create a backup of your on-premises database, store it on Amazon
Simple Storage Service (Amazon S3), and then restore the backup file onto a new Amazon RDS
DB instance running MySQL. For more information, see Importing Data into an Amazon RDS
MySQL DB Instance in the Amazon RDS User Guide.  This operation doesn't apply to RDS Custom.

# Arguments
- `dbinstance_class`: The compute and memory capacity of the DB instance, for example
  db.m4.large. Not all DB instance classes are available in all Amazon Web Services Regions,
  or for all database engines. For the full list of DB instance classes, and availability for
  your engine, see DB Instance Class in the Amazon RDS User Guide.  Importing from Amazon S3
  isn't supported on the db.t2.micro DB instance class.
- `dbinstance_identifier`: The DB instance identifier. This parameter is stored as a
  lowercase string. Constraints:   Must contain from 1 to 63 letters, numbers, or hyphens.
  First character must be a letter.   Can't end with a hyphen or contain two consecutive
  hyphens.   Example: mydbinstance
- `engine`: The name of the database engine to be used for this instance. Valid Values:
  mysql
- `s3_bucket_name`: The name of your Amazon S3 bucket that contains your database backup
  file.
- `s3_ingestion_role_arn`: An Amazon Web Services Identity and Access Management (IAM) role
  with a trust policy and a permissions policy that allows Amazon RDS to access your Amazon
  S3 bucket. For information about this role, see  Creating an IAM role manually in the
  Amazon RDS User Guide.
- `source_engine`: The name of the engine of your source database. Valid Values: mysql
- `source_engine_version`: The version of the database that the backup files were created
  from. MySQL versions 5.6 and 5.7 are supported. Example: 5.6.40

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocatedStorage"`: The amount of storage (in gibibytes) to allocate initially for the
  DB instance. Follow the allocation rules specified in CreateDBInstance.  Be sure to
  allocate enough storage for your new DB instance so that the restore operation can succeed.
  You can also allocate additional storage for future growth.
- `"AutoMinorVersionUpgrade"`: Specifies whether to automatically apply minor engine
  upgrades to the DB instance during the maintenance window. By default, minor engine
  upgrades are not applied automatically.
- `"AvailabilityZone"`: The Availability Zone that the DB instance is created in. For
  information about Amazon Web Services Regions and Availability Zones, see Regions and
  Availability Zones in the Amazon RDS User Guide.  Default: A random, system-chosen
  Availability Zone in the endpoint's Amazon Web Services Region. Example: us-east-1d
  Constraint: The AvailabilityZone parameter can't be specified if the DB instance is a
  Multi-AZ deployment. The specified Availability Zone must be in the same Amazon Web
  Services Region as the current endpoint.
- `"BackupRetentionPeriod"`: The number of days for which automated backups are retained.
  Setting this parameter to a positive number enables backups. For more information, see
  CreateDBInstance.
- `"CACertificateIdentifier"`: The CA certificate identifier to use for the DB instance's
  server certificate. This setting doesn't apply to RDS Custom DB instances. For more
  information, see Using SSL/TLS to encrypt a connection to a DB instance in the Amazon RDS
  User Guide and  Using SSL/TLS to encrypt a connection to a DB cluster in the Amazon Aurora
  User Guide.
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the DB instance to
  snapshots of the DB instance. By default, tags are not copied.
- `"DBName"`: The name of the database to create when the DB instance is created. Follow
  the naming rules specified in CreateDBInstance.
- `"DBParameterGroupName"`: The name of the DB parameter group to associate with this DB
  instance. If you do not specify a value for DBParameterGroupName, then the default
  DBParameterGroup for the specified DB engine is used.
- `"DBSecurityGroups"`: A list of DB security groups to associate with this DB instance.
  Default: The default DB security group for the database engine.
- `"DBSubnetGroupName"`: A DB subnet group to associate with this DB instance. Constraints:
  If supplied, must match the name of an existing DBSubnetGroup. Example: mydbsubnetgroup
- `"DedicatedLogVolume"`: Specifies whether to enable a dedicated log volume (DLV) for the
  DB instance.
- `"DeletionProtection"`: Specifies whether to enable deletion protection for the DB
  instance. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled. For more information, see  Deleting a DB Instance.
- `"EnableCloudwatchLogsExports"`: The list of logs that the restored DB instance is to
  export to CloudWatch Logs. The values in the list depend on the DB engine being used. For
  more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS
  User Guide.
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. For more information about IAM database authentication, see  IAM
  Database Authentication for MySQL and PostgreSQL in the Amazon RDS User Guide.
- `"EnablePerformanceInsights"`: Specifies whether to enable Performance Insights for the
  DB instance. For more information, see Using Amazon Performance Insights in the Amazon RDS
  User Guide.
- `"EngineLifecycleSupport"`: The life cycle type for this DB instance.  By default, this
  value is set to open-source-rds-extended-support, which enrolls your DB instance into
  Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
  Extended Support by setting the value to open-source-rds-extended-support-disabled. In this
  case, RDS automatically upgrades your restored DB instance to a higher engine version, if
  the major engine version is past its end of standard support date.  You can use this
  setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended
  Support, you can run the selected major engine version on your DB instance past the end of
  standard support for that engine version. For more information, see Using Amazon RDS
  Extended Support in the Amazon RDS User Guide. This setting applies only to RDS for MySQL
  and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by
  the DB cluster. Valid Values: open-source-rds-extended-support |
  open-source-rds-extended-support-disabled  Default: open-source-rds-extended-support
- `"EngineVersion"`: The version number of the database engine to use. Choose the latest
  minor version of your database engine. For information about engine versions, see
  CreateDBInstance, or call DescribeDBEngineVersions.
- `"Iops"`: The amount of Provisioned IOPS (input/output operations per second) to allocate
  initially for the DB instance. For information about valid IOPS values, see Amazon RDS
  Provisioned IOPS storage in the Amazon RDS User Guide.
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier for an encrypted DB instance.
  The Amazon Web Services KMS key identifier is the key ARN, key ID, alias ARN, or alias name
  for the KMS key. To use a KMS key in a different Amazon Web Services account, specify the
  key ARN or alias ARN. If the StorageEncrypted parameter is enabled, and you do not specify
  a value for the KmsKeyId parameter, then Amazon RDS will use your default KMS key. There is
  a default KMS key for your Amazon Web Services account. Your Amazon Web Services account
  has a different default KMS key for each Amazon Web Services Region.
- `"LicenseModel"`: The license model for this DB instance. Use general-public-license.
- `"ManageMasterUserPassword"`: Specifies whether to manage the master user password with
  Amazon Web Services Secrets Manager. For more information, see Password management with
  Amazon Web Services Secrets Manager in the Amazon RDS User Guide.  Constraints:   Can't
  manage the master user password with Amazon Web Services Secrets Manager if
  MasterUserPassword is specified.
- `"MasterUserPassword"`: The password for the master user. Constraints:   Can't be
  specified if ManageMasterUserPassword is turned on.   Can include any printable ASCII
  character except \"/\", \"\"\", or \"@\". For RDS for Oracle, can't include the \"&amp;\"
  (ampersand) or the \"'\" (single quotes) character.   Length Constraints:   RDS for Db2 -
  Must contain from 8 to 128 characters.   RDS for MariaDB - Must contain from 8 to 41
  characters.   RDS for Microsoft SQL Server - Must contain from 8 to 128 characters.   RDS
  for MySQL - Must contain from 8 to 41 characters.   RDS for Oracle - Must contain from 8 to
  30 characters.   RDS for PostgreSQL - Must contain from 8 to 128 characters.
- `"MasterUserSecretKmsKeyId"`: The Amazon Web Services KMS key identifier to encrypt a
  secret that is automatically generated and managed in Amazon Web Services Secrets Manager.
  This setting is valid only if the master user password is managed by RDS in Amazon Web
  Services Secrets Manager for the DB instance. The Amazon Web Services KMS key identifier is
  the key ARN, key ID, alias ARN, or alias name for the KMS key. To use a KMS key in a
  different Amazon Web Services account, specify the key ARN or alias ARN. If you don't
  specify MasterUserSecretKmsKeyId, then the aws/secretsmanager KMS key is used to encrypt
  the secret. If the secret is in a different Amazon Web Services account, then you can't use
  the aws/secretsmanager KMS key to encrypt the secret, and you must use a customer managed
  KMS key. There is a default KMS key for your Amazon Web Services account. Your Amazon Web
  Services account has a different default KMS key for each Amazon Web Services Region.
- `"MasterUsername"`: The name for the master user. Constraints:   Must be 1 to 16 letters
  or numbers.   First character must be a letter.   Can't be a reserved word for the chosen
  database engine.
- `"MaxAllocatedStorage"`: The upper limit in gibibytes (GiB) to which Amazon RDS can
  automatically scale the storage of the DB instance. For more information about this
  setting, including limitations that apply to it, see  Managing capacity automatically with
  Amazon RDS storage autoscaling in the Amazon RDS User Guide.
- `"MonitoringInterval"`: The interval, in seconds, between points when Enhanced Monitoring
  metrics are collected for the DB instance. To disable collecting Enhanced Monitoring
  metrics, specify 0. If MonitoringRoleArn is specified, then you must also set
  MonitoringInterval to a value other than 0. Valid Values: 0, 1, 5, 10, 15, 30, 60 Default:
  0
- `"MonitoringRoleArn"`: The ARN for the IAM role that permits RDS to send enhanced
  monitoring metrics to Amazon CloudWatch Logs. For example,
  arn:aws:iam:123456789012:role/emaccess. For information on creating a monitoring role, see
  Setting Up and Enabling Enhanced Monitoring in the Amazon RDS User Guide.  If
  MonitoringInterval is set to a value other than 0, then you must supply a MonitoringRoleArn
  value.
- `"MultiAZ"`: Specifies whether the DB instance is a Multi-AZ deployment. If the DB
  instance is a Multi-AZ deployment, you can't set the AvailabilityZone parameter.
- `"NetworkType"`: The network type of the DB instance. Valid Values:    IPV4     DUAL
  The network type is determined by the DBSubnetGroup specified for the DB instance. A
  DBSubnetGroup can support only the IPv4 protocol or the IPv4 and the IPv6 protocols (DUAL).
  For more information, see  Working with a DB instance in a VPC in the Amazon RDS User
  Guide.
- `"OptionGroupName"`: The name of the option group to associate with this DB instance. If
  this argument is omitted, the default option group for the specified engine is used.
- `"PerformanceInsightsKMSKeyId"`: The Amazon Web Services KMS key identifier for
  encryption of Performance Insights data. The Amazon Web Services KMS key identifier is the
  key ARN, key ID, alias ARN, or alias name for the KMS key. If you do not specify a value
  for PerformanceInsightsKMSKeyId, then Amazon RDS uses your default KMS key. There is a
  default KMS key for your Amazon Web Services account. Your Amazon Web Services account has
  a different default KMS key for each Amazon Web Services Region.
- `"PerformanceInsightsRetentionPeriod"`: The number of days to retain Performance Insights
  data. The default is 7 days. The following values are valid:   7    month * 31, where month
  is a number of months from 1-23   731   For example, the following values are valid:   93
  (3 months * 31)   341 (11 months * 31)   589 (19 months * 31)   731   If you specify a
  retention period such as 94, which isn't a valid value, RDS issues an error.
- `"Port"`: The port number on which the database accepts connections. Type: Integer Valid
  Values: 1150-65535  Default: 3306
- `"PreferredBackupWindow"`: The time range each day during which automated backups are
  created if automated backups are enabled. For more information, see Backup window in the
  Amazon RDS User Guide.  Constraints:   Must be in the format hh24:mi-hh24:mi.   Must be in
  Universal Coordinated Time (UTC).   Must not conflict with the preferred maintenance
  window.   Must be at least 30 minutes.
- `"PreferredMaintenanceWindow"`: The time range each week during which system maintenance
  can occur, in Universal Coordinated Time (UTC). For more information, see Amazon RDS
  Maintenance Window in the Amazon RDS User Guide.  Constraints:   Must be in the format
  ddd:hh24:mi-ddd:hh24:mi.   Valid Days: Mon, Tue, Wed, Thu, Fri, Sat, Sun.   Must be in
  Universal Coordinated Time (UTC).   Must not conflict with the preferred backup window.
  Must be at least 30 minutes.
- `"ProcessorFeatures"`: The number of CPU cores and the number of threads per core for the
  DB instance class of the DB instance.
- `"PubliclyAccessible"`: Specifies whether the DB instance is publicly accessible. When
  the DB instance is publicly accessible, its Domain Name System (DNS) endpoint resolves to
  the private IP address from within the DB instance's virtual private cloud (VPC). It
  resolves to the public IP address from outside of the DB instance's VPC. Access to the DB
  instance is ultimately controlled by the security group it uses. That public access is not
  permitted if the security group assigned to the DB instance doesn't permit it. When the DB
  instance isn't publicly accessible, it is an internal DB instance with a DNS name that
  resolves to a private IP address. For more information, see CreateDBInstance.
- `"S3Prefix"`: The prefix of your Amazon S3 bucket.
- `"StorageEncrypted"`: Specifies whether the new DB instance is encrypted or not.
- `"StorageThroughput"`: Specifies the storage throughput value for the DB instance. This
  setting doesn't apply to RDS Custom or Amazon Aurora.
- `"StorageType"`: Specifies the storage type to be associated with the DB instance. Valid
  Values: gp2 | gp3 | io1 | io2 | standard  If you specify io1, io2, or gp3, you must also
  include a value for the Iops parameter. Default: io1 if the Iops parameter is specified;
  otherwise gp2
- `"Tags"`: A list of tags to associate with this DB instance. For more information, see
  Tagging Amazon RDS Resources in the Amazon RDS User Guide.
- `"UseDefaultProcessorFeatures"`: Specifies whether the DB instance class of the DB
  instance uses its default processor features.
- `"VpcSecurityGroupIds"`: A list of VPC security groups to associate with this DB instance.
"""
function restore_dbinstance_from_s3(
    DBInstanceClass,
    DBInstanceIdentifier,
    Engine,
    S3BucketName,
    S3IngestionRoleArn,
    SourceEngine,
    SourceEngineVersion;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBInstanceFromS3",
        Dict{String,Any}(
            "DBInstanceClass" => DBInstanceClass,
            "DBInstanceIdentifier" => DBInstanceIdentifier,
            "Engine" => Engine,
            "S3BucketName" => S3BucketName,
            "S3IngestionRoleArn" => S3IngestionRoleArn,
            "SourceEngine" => SourceEngine,
            "SourceEngineVersion" => SourceEngineVersion,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_dbinstance_from_s3(
    DBInstanceClass,
    DBInstanceIdentifier,
    Engine,
    S3BucketName,
    S3IngestionRoleArn,
    SourceEngine,
    SourceEngineVersion,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBInstanceFromS3",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "DBInstanceClass" => DBInstanceClass,
                    "DBInstanceIdentifier" => DBInstanceIdentifier,
                    "Engine" => Engine,
                    "S3BucketName" => S3BucketName,
                    "S3IngestionRoleArn" => S3IngestionRoleArn,
                    "SourceEngine" => SourceEngine,
                    "SourceEngineVersion" => SourceEngineVersion,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    restore_dbinstance_to_point_in_time(target_dbinstance_identifier)
    restore_dbinstance_to_point_in_time(target_dbinstance_identifier, params::Dict{String,<:Any})

Restores a DB instance to an arbitrary point in time. You can restore to any point in time
before the time identified by the LatestRestorableTime property. You can restore to a point
up to the number of days specified by the BackupRetentionPeriod property. The target
database is created with most of the original configuration, but in a system-selected
Availability Zone, with the default security group, the default subnet group, and the
default DB parameter group. By default, the new DB instance is created as a single-AZ
deployment except when the instance is a SQL Server instance that has an option group that
is associated with mirroring; in this case, the instance becomes a mirrored deployment and
not a single-AZ deployment.  This operation doesn't apply to Aurora MySQL and Aurora
PostgreSQL. For Aurora, use RestoreDBClusterToPointInTime.

# Arguments
- `target_dbinstance_identifier`: The name of the new DB instance to create. Constraints:
  Must contain from 1 to 63 letters, numbers, or hyphens.   First character must be a letter.
    Can't end with a hyphen or contain two consecutive hyphens.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"AllocatedStorage"`: The amount of storage (in gibibytes) to allocate initially for the
  DB instance. Follow the allocation rules specified in CreateDBInstance.  Be sure to
  allocate enough storage for your new DB instance so that the restore operation can succeed.
  You can also allocate additional storage for future growth.
- `"AutoMinorVersionUpgrade"`: Specifies whether minor version upgrades are applied
  automatically to the DB instance during the maintenance window. This setting doesn't apply
  to RDS Custom.
- `"AvailabilityZone"`: The Availability Zone (AZ) where the DB instance will be created.
  Default: A random, system-chosen Availability Zone. Constraints:   You can't specify the
  AvailabilityZone parameter if the DB instance is a Multi-AZ deployment.   Example:
  us-east-1a
- `"BackupTarget"`: The location for storing automated backups and manual snapshots for the
  restored DB instance. Valid Values:    outposts (Amazon Web Services Outposts)    region
  (Amazon Web Services Region)   Default: region  For more information, see Working with
  Amazon RDS on Amazon Web Services Outposts in the Amazon RDS User Guide.
- `"CACertificateIdentifier"`: The CA certificate identifier to use for the DB instance's
  server certificate. This setting doesn't apply to RDS Custom DB instances. For more
  information, see Using SSL/TLS to encrypt a connection to a DB instance in the Amazon RDS
  User Guide and  Using SSL/TLS to encrypt a connection to a DB cluster in the Amazon Aurora
  User Guide.
- `"CopyTagsToSnapshot"`: Specifies whether to copy all tags from the restored DB instance
  to snapshots of the DB instance. By default, tags are not copied.
- `"CustomIamInstanceProfile"`: The instance profile associated with the underlying Amazon
  EC2 instance of an RDS Custom DB instance. The instance profile must meet the following
  requirements:   The profile must exist in your account.   The profile must have an IAM role
  that Amazon EC2 has permissions to assume.   The instance profile name and the associated
  IAM role name must start with the prefix AWSRDSCustom.   For the list of permissions
  required for the IAM role, see  Configure IAM and your VPC in the Amazon RDS User Guide.
  This setting is required for RDS Custom.
- `"DBInstanceClass"`: The compute and memory capacity of the Amazon RDS DB instance, for
  example db.m4.large. Not all DB instance classes are available in all Amazon Web Services
  Regions, or for all database engines. For the full list of DB instance classes, and
  availability for your engine, see DB Instance Class in the Amazon RDS User Guide. Default:
  The same DB instance class as the original DB instance.
- `"DBName"`: The database name for the restored DB instance. This parameter doesn't apply
  to the following DB instances:   RDS Custom   RDS for Db2   RDS for MariaDB   RDS for MySQL
  
- `"DBParameterGroupName"`: The name of the DB parameter group to associate with this DB
  instance. If you do not specify a value for DBParameterGroupName, then the default
  DBParameterGroup for the specified DB engine is used. This setting doesn't apply to RDS
  Custom. Constraints:   If supplied, must match the name of an existing DB parameter group.
   Must be 1 to 255 letters, numbers, or hyphens.   First character must be a letter.   Can't
  end with a hyphen or contain two consecutive hyphens.
- `"DBSubnetGroupName"`: The DB subnet group name to use for the new instance. Constraints:
    If supplied, must match the name of an existing DB subnet group.   Example:
  mydbsubnetgroup
- `"DedicatedLogVolume"`: Specifies whether to enable a dedicated log volume (DLV) for the
  DB instance.
- `"DeletionProtection"`: Specifies whether the DB instance has deletion protection
  enabled. The database can't be deleted when deletion protection is enabled. By default,
  deletion protection isn't enabled. For more information, see  Deleting a DB Instance.
- `"Domain"`: The Active Directory directory ID to restore the DB instance in. Create the
  domain before running this command. Currently, you can create only the MySQL, Microsoft SQL
  Server, Oracle, and PostgreSQL DB instances in an Active Directory Domain. This setting
  doesn't apply to RDS Custom. For more information, see  Kerberos Authentication in the
  Amazon RDS User Guide.
- `"DomainAuthSecretArn"`: The ARN for the Secrets Manager secret with the credentials for
  the user joining the domain. Constraints:   Can't be longer than 64 characters.   Example:
  arn:aws:secretsmanager:region:account-number:secret:myselfmanagedADtestsecret-123456
- `"DomainDnsIps"`: The IPv4 DNS IP addresses of your primary and secondary Active
  Directory domain controllers. Constraints:   Two IP addresses must be provided. If there
  isn't a secondary domain controller, use the IP address of the primary domain controller
  for both entries in the list.   Example: 123.124.125.126,234.235.236.237
- `"DomainFqdn"`: The fully qualified domain name (FQDN) of an Active Directory domain.
  Constraints:   Can't be longer than 64 characters.   Example:
  mymanagedADtest.mymanagedAD.mydomain
- `"DomainIAMRoleName"`: The name of the IAM role to use when making API calls to the
  Directory Service. This setting doesn't apply to RDS Custom DB instances.
- `"DomainOu"`: The Active Directory organizational unit for your DB instance to join.
  Constraints:   Must be in the distinguished name format.   Can't be longer than 64
  characters.   Example: OU=mymanagedADtestOU,DC=mymanagedADtest,DC=mymanagedAD,DC=mydomain
- `"EnableCloudwatchLogsExports"`: The list of logs that the restored DB instance is to
  export to CloudWatch Logs. The values in the list depend on the DB engine being used. For
  more information, see Publishing Database Logs to Amazon CloudWatch Logs in the Amazon RDS
  User Guide. This setting doesn't apply to RDS Custom.
- `"EnableCustomerOwnedIp"`: Specifies whether to enable a customer-owned IP address (CoIP)
  for an RDS on Outposts DB instance. A CoIP provides local or external connectivity to
  resources in your Outpost subnets through your on-premises network. For some use cases, a
  CoIP can provide lower latency for connections to the DB instance from outside of its
  virtual private cloud (VPC) on your local network. This setting doesn't apply to RDS
  Custom. For more information about RDS on Outposts, see Working with Amazon RDS on Amazon
  Web Services Outposts in the Amazon RDS User Guide. For more information about CoIPs, see
  Customer-owned IP addresses in the Amazon Web Services Outposts User Guide.
- `"EnableIAMDatabaseAuthentication"`: Specifies whether to enable mapping of Amazon Web
  Services Identity and Access Management (IAM) accounts to database accounts. By default,
  mapping isn't enabled. This setting doesn't apply to RDS Custom. For more information about
  IAM database authentication, see  IAM Database Authentication for MySQL and PostgreSQL in
  the Amazon RDS User Guide.
- `"Engine"`: The database engine to use for the new instance. This setting doesn't apply
  to RDS Custom. Valid Values:    db2-ae     db2-se     mariadb     mysql     oracle-ee
  oracle-ee-cdb     oracle-se2     oracle-se2-cdb     postgres     sqlserver-ee
  sqlserver-se     sqlserver-ex     sqlserver-web    Default: The same as source Constraints:
    Must be compatible with the engine of the source.
- `"EngineLifecycleSupport"`: The life cycle type for this DB instance.  By default, this
  value is set to open-source-rds-extended-support, which enrolls your DB instance into
  Amazon RDS Extended Support. At the end of standard support, you can avoid charges for
  Extended Support by setting the value to open-source-rds-extended-support-disabled. In this
  case, RDS automatically upgrades your restored DB instance to a higher engine version, if
  the major engine version is past its end of standard support date.  You can use this
  setting to enroll your DB instance into Amazon RDS Extended Support. With RDS Extended
  Support, you can run the selected major engine version on your DB instance past the end of
  standard support for that engine version. For more information, see Using Amazon RDS
  Extended Support in the Amazon RDS User Guide. This setting applies only to RDS for MySQL
  and RDS for PostgreSQL. For Amazon Aurora DB instances, the life cycle type is managed by
  the DB cluster. Valid Values: open-source-rds-extended-support |
  open-source-rds-extended-support-disabled  Default: open-source-rds-extended-support
- `"Iops"`: The amount of Provisioned IOPS (input/output operations per second) to
  initially allocate for the DB instance. This setting doesn't apply to SQL Server.
  Constraints:   Must be an integer greater than 1000.
- `"LicenseModel"`: The license model information for the restored DB instance.  License
  models for RDS for Db2 require additional configuration. The Bring Your Own License (BYOL)
  model requires a custom parameter group. The Db2 license through Amazon Web Services
  Marketplace model requires an Amazon Web Services Marketplace subscription. For more
  information, see RDS for Db2 licensing options in the Amazon RDS User Guide.  This setting
  doesn't apply to Amazon Aurora or RDS Custom DB instances. Valid Values:   RDS for Db2 -
  bring-your-own-license | marketplace-license    RDS for MariaDB - general-public-license
  RDS for Microsoft SQL Server - license-included    RDS for MySQL - general-public-license
   RDS for Oracle - bring-your-own-license | license-included    RDS for PostgreSQL -
  postgresql-license    Default: Same as the source.
- `"MaxAllocatedStorage"`: The upper limit in gibibytes (GiB) to which Amazon RDS can
  automatically scale the storage of the DB instance. For more information about this
  setting, including limitations that apply to it, see  Managing capacity automatically with
  Amazon RDS storage autoscaling in the Amazon RDS User Guide. This setting doesn't apply to
  RDS Custom.
- `"MultiAZ"`: Secifies whether the DB instance is a Multi-AZ deployment. This setting
  doesn't apply to RDS Custom. Constraints:   You can't specify the AvailabilityZone
  parameter if the DB instance is a Multi-AZ deployment.
- `"NetworkType"`: The network type of the DB instance. The network type is determined by
  the DBSubnetGroup specified for the DB instance. A DBSubnetGroup can support only the IPv4
  protocol or the IPv4 and the IPv6 protocols (DUAL). For more information, see  Working with
  a DB instance in a VPC in the Amazon RDS User Guide.  Valid Values:    IPV4     DUAL
- `"OptionGroupName"`: The name of the option group to use for the restored DB instance.
  Permanent options, such as the TDE option for Oracle Advanced Security TDE, can't be
  removed from an option group, and that option group can't be removed from a DB instance
  after it is associated with a DB instance This setting doesn't apply to RDS Custom.
- `"Port"`: The port number on which the database accepts connections. Default: The same
  port as the original DB instance. Constraints:   The value must be 1150-65535.
- `"ProcessorFeatures"`: The number of CPU cores and the number of threads per core for the
  DB instance class of the DB instance. This setting doesn't apply to RDS Custom.
- `"PubliclyAccessible"`: Specifies whether the DB instance is publicly accessible. When
  the DB cluster is publicly accessible, its Domain Name System (DNS) endpoint resolves to
  the private IP address from within the DB cluster's virtual private cloud (VPC). It
  resolves to the public IP address from outside of the DB cluster's VPC. Access to the DB
  cluster is ultimately controlled by the security group it uses. That public access isn't
  permitted if the security group assigned to the DB cluster doesn't permit it. When the DB
  instance isn't publicly accessible, it is an internal DB instance with a DNS name that
  resolves to a private IP address. For more information, see CreateDBInstance.
- `"RestoreTime"`: The date and time to restore from. Constraints:   Must be a time in
  Universal Coordinated Time (UTC) format.   Must be before the latest restorable time for
  the DB instance.   Can't be specified if the UseLatestRestorableTime parameter is enabled.
   Example: 2009-09-07T23:45:00Z
- `"SourceDBInstanceAutomatedBackupsArn"`: The Amazon Resource Name (ARN) of the replicated
  automated backups from which to restore, for example,
  arn:aws:rds:us-east-1:123456789012:auto-backup:ab-L2IJCEXJP7XQ7HOJ4SIEXAMPLE. This setting
  doesn't apply to RDS Custom.
- `"SourceDBInstanceIdentifier"`: The identifier of the source DB instance from which to
  restore. Constraints:   Must match the identifier of an existing DB instance.
- `"SourceDbiResourceId"`: The resource ID of the source DB instance from which to restore.
- `"StorageThroughput"`: The storage throughput value for the DB instance. This setting
  doesn't apply to RDS Custom or Amazon Aurora.
- `"StorageType"`: The storage type to associate with the DB instance. Valid Values: gp2 |
  gp3 | io1 | io2 | standard  Default: io1, if the Iops parameter is specified. Otherwise,
  gp2. Constraints:   If you specify io1, io2, or gp3, you must also include a value for the
  Iops parameter.
- `"Tags"`:
- `"TdeCredentialArn"`: The ARN from the key store with which to associate the instance for
  TDE encryption. This setting doesn't apply to RDS Custom.
- `"TdeCredentialPassword"`: The password for the given ARN from the key store in order to
  access the device. This setting doesn't apply to RDS Custom.
- `"UseDefaultProcessorFeatures"`: Specifies whether the DB instance class of the DB
  instance uses its default processor features. This setting doesn't apply to RDS Custom.
- `"UseLatestRestorableTime"`: Specifies whether the DB instance is restored from the
  latest backup time. By default, the DB instance isn't restored from the latest backup time.
  Constraints:   Can't be specified if the RestoreTime parameter is provided.
- `"VpcSecurityGroupIds"`: A list of EC2 VPC security groups to associate with this DB
  instance. Default: The default EC2 VPC security group for the DB subnet group's VPC.
"""
function restore_dbinstance_to_point_in_time(
    TargetDBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RestoreDBInstanceToPointInTime",
        Dict{String,Any}("TargetDBInstanceIdentifier" => TargetDBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function restore_dbinstance_to_point_in_time(
    TargetDBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RestoreDBInstanceToPointInTime",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "TargetDBInstanceIdentifier" => TargetDBInstanceIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    revoke_dbsecurity_group_ingress(dbsecurity_group_name)
    revoke_dbsecurity_group_ingress(dbsecurity_group_name, params::Dict{String,<:Any})

Revokes ingress from a DBSecurityGroup for previously authorized IP ranges or EC2 or VPC
security groups. Required parameters for this API are one of CIDRIP, EC2SecurityGroupId for
VPC, or (EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId).
EC2-Classic was retired on August 15, 2022. If you haven't migrated from EC2-Classic to a
VPC, we recommend that you migrate as soon as possible. For more information, see Migrate
from EC2-Classic to a VPC in the Amazon EC2 User Guide, the blog EC2-Classic Networking is
Retiring – Here’s How to Prepare, and Moving a DB instance not in a VPC into a VPC in
the Amazon RDS User Guide.

# Arguments
- `dbsecurity_group_name`: The name of the DB security group to revoke ingress from.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"CIDRIP"`: The IP range to revoke access from. Must be a valid CIDR range. If CIDRIP is
  specified, EC2SecurityGroupName, EC2SecurityGroupId and EC2SecurityGroupOwnerId can't be
  provided.
- `"EC2SecurityGroupId"`: The id of the EC2 security group to revoke access from. For VPC
  DB security groups, EC2SecurityGroupId must be provided. Otherwise, EC2SecurityGroupOwnerId
  and either EC2SecurityGroupName or EC2SecurityGroupId must be provided.
- `"EC2SecurityGroupName"`: The name of the EC2 security group to revoke access from. For
  VPC DB security groups, EC2SecurityGroupId must be provided. Otherwise,
  EC2SecurityGroupOwnerId and either EC2SecurityGroupName or EC2SecurityGroupId must be
  provided.
- `"EC2SecurityGroupOwnerId"`: The Amazon Web Services account number of the owner of the
  EC2 security group specified in the EC2SecurityGroupName parameter. The Amazon Web Services
  access key ID isn't an acceptable value. For VPC DB security groups, EC2SecurityGroupId
  must be provided. Otherwise, EC2SecurityGroupOwnerId and either EC2SecurityGroupName or
  EC2SecurityGroupId must be provided.
"""
function revoke_dbsecurity_group_ingress(
    DBSecurityGroupName; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "RevokeDBSecurityGroupIngress",
        Dict{String,Any}("DBSecurityGroupName" => DBSecurityGroupName);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function revoke_dbsecurity_group_ingress(
    DBSecurityGroupName,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "RevokeDBSecurityGroupIngress",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBSecurityGroupName" => DBSecurityGroupName),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_activity_stream(kms_key_id, mode, resource_arn)
    start_activity_stream(kms_key_id, mode, resource_arn, params::Dict{String,<:Any})

Starts a database activity stream to monitor activity on the database. For more
information, see  Monitoring Amazon Aurora with Database Activity Streams in the Amazon
Aurora User Guide or  Monitoring Amazon RDS with Database Activity Streams in the Amazon
RDS User Guide.

# Arguments
- `kms_key_id`: The Amazon Web Services KMS key identifier for encrypting messages in the
  database activity stream. The Amazon Web Services KMS key identifier is the key ARN, key
  ID, alias ARN, or alias name for the KMS key.
- `mode`: Specifies the mode of the database activity stream. Database events such as a
  change or access generate an activity stream event. The database session can handle these
  events either synchronously or asynchronously.
- `resource_arn`: The Amazon Resource Name (ARN) of the DB cluster, for example,
  arn:aws:rds:us-east-1:12345667890:cluster:das-cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplyImmediately"`: Specifies whether or not the database activity stream is to start
  as soon as possible, regardless of the maintenance window for the database.
- `"EngineNativeAuditFieldsIncluded"`: Specifies whether the database activity stream
  includes engine-native audit fields. This option applies to an Oracle or Microsoft SQL
  Server DB instance. By default, no engine-native audit fields are included.
"""
function start_activity_stream(
    KmsKeyId, Mode, ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "StartActivityStream",
        Dict{String,Any}(
            "KmsKeyId" => KmsKeyId, "Mode" => Mode, "ResourceArn" => ResourceArn
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_activity_stream(
    KmsKeyId,
    Mode,
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StartActivityStream",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "KmsKeyId" => KmsKeyId, "Mode" => Mode, "ResourceArn" => ResourceArn
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_dbcluster(dbcluster_identifier)
    start_dbcluster(dbcluster_identifier, params::Dict{String,<:Any})

Starts an Amazon Aurora DB cluster that was stopped using the Amazon Web Services console,
the stop-db-cluster CLI command, or the StopDBCluster operation. For more information, see
Stopping and Starting an Aurora Cluster in the Amazon Aurora User Guide.  This operation
only applies to Aurora DB clusters.

# Arguments
- `dbcluster_identifier`: The DB cluster identifier of the Amazon Aurora DB cluster to be
  started. This parameter is stored as a lowercase string.

"""
function start_dbcluster(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "StartDBCluster",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_dbcluster(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StartDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_dbinstance(dbinstance_identifier)
    start_dbinstance(dbinstance_identifier, params::Dict{String,<:Any})

Starts an Amazon RDS DB instance that was stopped using the Amazon Web Services console,
the stop-db-instance CLI command, or the StopDBInstance operation. For more information,
see  Starting an Amazon RDS DB instance That Was Previously Stopped in the Amazon RDS User
Guide.   This command doesn't apply to RDS Custom, Aurora MySQL, and Aurora PostgreSQL. For
Aurora DB clusters, use StartDBCluster instead.

# Arguments
- `dbinstance_identifier`: The user-supplied instance identifier.

"""
function start_dbinstance(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "StartDBInstance",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_dbinstance(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StartDBInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_dbinstance_automated_backups_replication(source_dbinstance_arn)
    start_dbinstance_automated_backups_replication(source_dbinstance_arn, params::Dict{String,<:Any})

Enables replication of automated backups to a different Amazon Web Services Region. This
command doesn't apply to RDS Custom. For more information, see  Replicating Automated
Backups to Another Amazon Web Services Region in the Amazon RDS User Guide.

# Arguments
- `source_dbinstance_arn`: The Amazon Resource Name (ARN) of the source DB instance for the
  replicated automated backups, for example, arn:aws:rds:us-west-2:123456789012:db:mydatabase.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"BackupRetentionPeriod"`: The retention period for the replicated automated backups.
- `"KmsKeyId"`: The Amazon Web Services KMS key identifier for encryption of the replicated
  automated backups. The KMS key ID is the Amazon Resource Name (ARN) for the KMS encryption
  key in the destination Amazon Web Services Region, for example,
  arn:aws:kms:us-east-1:123456789012:key/AKIAIOSFODNN7EXAMPLE.
- `"PreSignedUrl"`: In an Amazon Web Services GovCloud (US) Region, an URL that contains a
  Signature Version 4 signed request for the StartDBInstanceAutomatedBackupsReplication
  operation to call in the Amazon Web Services Region of the source DB instance. The
  presigned URL must be a valid request for the StartDBInstanceAutomatedBackupsReplication
  API operation that can run in the Amazon Web Services Region that contains the source DB
  instance. This setting applies only to Amazon Web Services GovCloud (US) Regions. It's
  ignored in other Amazon Web Services Regions. To learn how to generate a Signature Version
  4 signed request, see  Authenticating Requests: Using Query Parameters (Amazon Web Services
  Signature Version 4) and  Signature Version 4 Signing Process.  If you are using an Amazon
  Web Services SDK tool or the CLI, you can specify SourceRegion (or --source-region for the
  CLI) instead of specifying PreSignedUrl manually. Specifying SourceRegion autogenerates a
  presigned URL that is a valid request for the operation that can run in the source Amazon
  Web Services Region.
"""
function start_dbinstance_automated_backups_replication(
    SourceDBInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "StartDBInstanceAutomatedBackupsReplication",
        Dict{String,Any}("SourceDBInstanceArn" => SourceDBInstanceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_dbinstance_automated_backups_replication(
    SourceDBInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StartDBInstanceAutomatedBackupsReplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SourceDBInstanceArn" => SourceDBInstanceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    start_export_task(export_task_identifier, iam_role_arn, kms_key_id, s3_bucket_name, source_arn)
    start_export_task(export_task_identifier, iam_role_arn, kms_key_id, s3_bucket_name, source_arn, params::Dict{String,<:Any})

Starts an export of DB snapshot or DB cluster data to Amazon S3. The provided IAM role must
have access to the S3 bucket. You can't export snapshot data from Db2 or RDS Custom DB
instances. You can't export cluster data from Multi-AZ DB clusters. For more information on
exporting DB snapshot data, see Exporting DB snapshot data to Amazon S3 in the Amazon RDS
User Guide or Exporting DB cluster snapshot data to Amazon S3 in the Amazon Aurora User
Guide. For more information on exporting DB cluster data, see Exporting DB cluster data to
Amazon S3 in the Amazon Aurora User Guide.

# Arguments
- `export_task_identifier`: A unique identifier for the export task. This ID isn't an
  identifier for the Amazon S3 bucket where the data is to be exported.
- `iam_role_arn`: The name of the IAM role to use for writing to the Amazon S3 bucket when
  exporting a snapshot or cluster. In the IAM policy attached to your IAM role, include the
  following required actions to allow the transfer of files from Amazon RDS or Amazon Aurora
  to an S3 bucket:   s3:PutObject*   s3:GetObject*   s3:ListBucket   s3:DeleteObject*
  s3:GetBucketLocation    In the policy, include the resources to identify the S3 bucket and
  objects in the bucket. The following list of resources shows the Amazon Resource Name (ARN)
  format for accessing S3:    arn:aws:s3:::your-s3-bucket      arn:aws:s3:::your-s3-bucket/*
  
- `kms_key_id`: The ID of the Amazon Web Services KMS key to use to encrypt the data
  exported to Amazon S3. The Amazon Web Services KMS key identifier is the key ARN, key ID,
  alias ARN, or alias name for the KMS key. The caller of this operation must be authorized
  to run the following operations. These can be set in the Amazon Web Services KMS key
  policy:   kms:Encrypt   kms:Decrypt   kms:GenerateDataKey
  kms:GenerateDataKeyWithoutPlaintext   kms:ReEncryptFrom   kms:ReEncryptTo   kms:CreateGrant
    kms:DescribeKey   kms:RetireGrant
- `s3_bucket_name`: The name of the Amazon S3 bucket to export the snapshot or cluster data
  to.
- `source_arn`: The Amazon Resource Name (ARN) of the snapshot or cluster to export to
  Amazon S3.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ExportOnly"`: The data to be exported from the snapshot or cluster. If this parameter
  isn't provided, all of the data is exported. Valid Values:    database - Export all the
  data from a specified database.    database.table table-name - Export a table of the
  snapshot or cluster. This format is valid only for RDS for MySQL, RDS for MariaDB, and
  Aurora MySQL.    database.schema schema-name - Export a database schema of the snapshot or
  cluster. This format is valid only for RDS for PostgreSQL and Aurora PostgreSQL.
  database.schema.table table-name - Export a table of the database schema. This format is
  valid only for RDS for PostgreSQL and Aurora PostgreSQL.
- `"S3Prefix"`: The Amazon S3 bucket prefix to use as the file name and path of the
  exported data.
"""
function start_export_task(
    ExportTaskIdentifier,
    IamRoleArn,
    KmsKeyId,
    S3BucketName,
    SourceArn;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StartExportTask",
        Dict{String,Any}(
            "ExportTaskIdentifier" => ExportTaskIdentifier,
            "IamRoleArn" => IamRoleArn,
            "KmsKeyId" => KmsKeyId,
            "S3BucketName" => S3BucketName,
            "SourceArn" => SourceArn,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function start_export_task(
    ExportTaskIdentifier,
    IamRoleArn,
    KmsKeyId,
    S3BucketName,
    SourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StartExportTask",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "ExportTaskIdentifier" => ExportTaskIdentifier,
                    "IamRoleArn" => IamRoleArn,
                    "KmsKeyId" => KmsKeyId,
                    "S3BucketName" => S3BucketName,
                    "SourceArn" => SourceArn,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_activity_stream(resource_arn)
    stop_activity_stream(resource_arn, params::Dict{String,<:Any})

Stops a database activity stream that was started using the Amazon Web Services console,
the start-activity-stream CLI command, or the StartActivityStream operation. For more
information, see  Monitoring Amazon Aurora with Database Activity Streams in the Amazon
Aurora User Guide or  Monitoring Amazon RDS with Database Activity Streams in the Amazon
RDS User Guide.

# Arguments
- `resource_arn`: The Amazon Resource Name (ARN) of the DB cluster for the database
  activity stream. For example, arn:aws:rds:us-east-1:12345667890:cluster:das-cluster.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"ApplyImmediately"`: Specifies whether or not the database activity stream is to stop as
  soon as possible, regardless of the maintenance window for the database.
"""
function stop_activity_stream(
    ResourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "StopActivityStream",
        Dict{String,Any}("ResourceArn" => ResourceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_activity_stream(
    ResourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StopActivityStream",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("ResourceArn" => ResourceArn), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_dbcluster(dbcluster_identifier)
    stop_dbcluster(dbcluster_identifier, params::Dict{String,<:Any})

Stops an Amazon Aurora DB cluster. When you stop a DB cluster, Aurora retains the DB
cluster's metadata, including its endpoints and DB parameter groups. Aurora also retains
the transaction logs so you can do a point-in-time restore if necessary. For more
information, see  Stopping and Starting an Aurora Cluster in the Amazon Aurora User Guide.
This operation only applies to Aurora DB clusters.

# Arguments
- `dbcluster_identifier`: The DB cluster identifier of the Amazon Aurora DB cluster to be
  stopped. This parameter is stored as a lowercase string.

"""
function stop_dbcluster(
    DBClusterIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "StopDBCluster",
        Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_dbcluster(
    DBClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StopDBCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBClusterIdentifier" => DBClusterIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_dbinstance(dbinstance_identifier)
    stop_dbinstance(dbinstance_identifier, params::Dict{String,<:Any})

Stops an Amazon RDS DB instance. When you stop a DB instance, Amazon RDS retains the DB
instance's metadata, including its endpoint, DB parameter group, and option group
membership. Amazon RDS also retains the transaction logs so you can do a point-in-time
restore if necessary. For more information, see  Stopping an Amazon RDS DB Instance
Temporarily in the Amazon RDS User Guide.   This command doesn't apply to RDS Custom,
Aurora MySQL, and Aurora PostgreSQL. For Aurora clusters, use StopDBCluster instead.

# Arguments
- `dbinstance_identifier`: The user-supplied instance identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"DBSnapshotIdentifier"`: The user-supplied instance identifier of the DB Snapshot
  created immediately before the DB instance is stopped.
"""
function stop_dbinstance(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "StopDBInstance",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_dbinstance(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StopDBInstance",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    stop_dbinstance_automated_backups_replication(source_dbinstance_arn)
    stop_dbinstance_automated_backups_replication(source_dbinstance_arn, params::Dict{String,<:Any})

Stops automated backup replication for a DB instance. This command doesn't apply to RDS
Custom, Aurora MySQL, and Aurora PostgreSQL. For more information, see  Replicating
Automated Backups to Another Amazon Web Services Region in the Amazon RDS User Guide.

# Arguments
- `source_dbinstance_arn`: The Amazon Resource Name (ARN) of the source DB instance for
  which to stop replicating automate backups, for example,
  arn:aws:rds:us-west-2:123456789012:db:mydatabase.

"""
function stop_dbinstance_automated_backups_replication(
    SourceDBInstanceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "StopDBInstanceAutomatedBackupsReplication",
        Dict{String,Any}("SourceDBInstanceArn" => SourceDBInstanceArn);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function stop_dbinstance_automated_backups_replication(
    SourceDBInstanceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "StopDBInstanceAutomatedBackupsReplication",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("SourceDBInstanceArn" => SourceDBInstanceArn),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    switchover_blue_green_deployment(blue_green_deployment_identifier)
    switchover_blue_green_deployment(blue_green_deployment_identifier, params::Dict{String,<:Any})

Switches over a blue/green deployment. Before you switch over, production traffic is routed
to the databases in the blue environment. After you switch over, production traffic is
routed to the databases in the green environment. For more information, see Using Amazon
RDS Blue/Green Deployments for database updates in the Amazon RDS User Guide and Using
Amazon RDS Blue/Green Deployments for database updates in the Amazon Aurora User Guide.

# Arguments
- `blue_green_deployment_identifier`: The unique identifier of the blue/green deployment.
  Constraints:   Must match an existing blue/green deployment identifier.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"SwitchoverTimeout"`: The amount of time, in seconds, for the switchover to complete.
  Default: 300 If the switchover takes longer than the specified duration, then any changes
  are rolled back, and no changes are made to the environments.
"""
function switchover_blue_green_deployment(
    BlueGreenDeploymentIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "SwitchoverBlueGreenDeployment",
        Dict{String,Any}("BlueGreenDeploymentIdentifier" => BlueGreenDeploymentIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function switchover_blue_green_deployment(
    BlueGreenDeploymentIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "SwitchoverBlueGreenDeployment",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "BlueGreenDeploymentIdentifier" => BlueGreenDeploymentIdentifier
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    switchover_global_cluster(global_cluster_identifier, target_db_cluster_identifier)
    switchover_global_cluster(global_cluster_identifier, target_db_cluster_identifier, params::Dict{String,<:Any})

Switches over the specified secondary DB cluster to be the new primary DB cluster in the
global database cluster. Switchover operations were previously called \"managed planned
failovers.\" Aurora promotes the specified secondary cluster to assume full read/write
capabilities and demotes the current primary cluster to a secondary (read-only) cluster,
maintaining the orginal replication topology. All secondary clusters are synchronized with
the primary at the beginning of the process so the new primary continues operations for the
Aurora global database without losing any data. Your database is unavailable for a short
time while the primary and selected secondary clusters are assuming their new roles. For
more information about switching over an Aurora global database, see Performing switchovers
for Amazon Aurora global databases in the Amazon Aurora User Guide.  This operation is
intended for controlled environments, for operations such as \"regional rotation\" or to
fall back to the original primary after a global database failover.

# Arguments
- `global_cluster_identifier`: The identifier of the global database cluster to switch
  over. This parameter isn't case-sensitive. Constraints:   Must match the identifier of an
  existing global database cluster (Aurora global database).
- `target_db_cluster_identifier`: The identifier of the secondary Aurora DB cluster to
  promote to the new primary for the global database cluster. Use the Amazon Resource Name
  (ARN) for the identifier so that Aurora can locate the cluster in its Amazon Web Services
  Region.

"""
function switchover_global_cluster(
    GlobalClusterIdentifier,
    TargetDbClusterIdentifier;
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "SwitchoverGlobalCluster",
        Dict{String,Any}(
            "GlobalClusterIdentifier" => GlobalClusterIdentifier,
            "TargetDbClusterIdentifier" => TargetDbClusterIdentifier,
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function switchover_global_cluster(
    GlobalClusterIdentifier,
    TargetDbClusterIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "SwitchoverGlobalCluster",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}(
                    "GlobalClusterIdentifier" => GlobalClusterIdentifier,
                    "TargetDbClusterIdentifier" => TargetDbClusterIdentifier,
                ),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    switchover_read_replica(dbinstance_identifier)
    switchover_read_replica(dbinstance_identifier, params::Dict{String,<:Any})

Switches over an Oracle standby database in an Oracle Data Guard environment, making it the
new primary database. Issue this command in the Region that hosts the current standby
database.

# Arguments
- `dbinstance_identifier`: The DB instance identifier of the current standby database. This
  value is stored as a lowercase string. Constraints:   Must match the identiﬁer of an
  existing Oracle read replica DB instance.

"""
function switchover_read_replica(
    DBInstanceIdentifier; aws_config::AbstractAWSConfig=current_aws_config()
)
    return rds(
        "SwitchoverReadReplica",
        Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function switchover_read_replica(
    DBInstanceIdentifier,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return rds(
        "SwitchoverReadReplica",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("DBInstanceIdentifier" => DBInstanceIdentifier),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
