# This file is auto-generated by AWSMetadata.jl
using AWS
using AWS.AWSServices: tnb
using AWS.Compat
using AWS.UUIDs

"""
    cancel_sol_network_operation(ns_lcm_op_occ_id)
    cancel_sol_network_operation(ns_lcm_op_occ_id, params::Dict{String,<:Any})

Cancels a network operation. A network operation is any operation that is done to your
network, such as network instance instantiation or termination.

# Arguments
- `ns_lcm_op_occ_id`: The identifier of the network operation.

"""
function cancel_sol_network_operation(
    nsLcmOpOccId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_lcm_op_occs/$(nsLcmOpOccId)/cancel";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function cancel_sol_network_operation(
    nsLcmOpOccId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_lcm_op_occs/$(nsLcmOpOccId)/cancel",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sol_function_package()
    create_sol_function_package(params::Dict{String,<:Any})

Creates a function package. A function package is a .zip file in CSAR (Cloud Service
Archive) format that contains a network function (an ETSI standard telecommunication
application) and function package descriptor that uses the TOSCA standard to describe how
the network functions should run on your network. For more information, see Function
packages in the Amazon Web Services Telco Network Builder User Guide.  Creating a function
package is the first step for creating a network in AWS TNB. This request creates an empty
container with an ID. The next step is to upload the actual CSAR zip file into that empty
container. To upload function package content, see PutSolFunctionPackageContent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A tag is a label that you assign to an Amazon Web Services resource. Each tag
  consists of a key and an optional value. You can use tags to search and filter your
  resources or track your Amazon Web Services costs.
"""
function create_sol_function_package(; aws_config::AbstractAWSConfig=current_aws_config())
    return tnb(
        "POST",
        "/sol/vnfpkgm/v1/vnf_packages";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sol_function_package(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "POST",
        "/sol/vnfpkgm/v1/vnf_packages",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sol_network_instance(ns_name, nsd_info_id)
    create_sol_network_instance(ns_name, nsd_info_id, params::Dict{String,<:Any})

Creates a network instance. A network instance is a single network created in Amazon Web
Services TNB that can be deployed and on which life-cycle operations (like terminate,
update, and delete) can be performed. Creating a network instance is the third step after
creating a network package. For more information about network instances, Network instances
in the Amazon Web Services Telco Network Builder User Guide. Once you create a network
instance, you can instantiate it. To instantiate a network, see
InstantiateSolNetworkInstance.

# Arguments
- `ns_name`: Network instance name.
- `nsd_info_id`: ID for network service descriptor.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"nsDescription"`: Network instance description.
- `"tags"`: A tag is a label that you assign to an Amazon Web Services resource. Each tag
  consists of a key and an optional value. You can use tags to search and filter your
  resources or track your Amazon Web Services costs.
"""
function create_sol_network_instance(
    nsName, nsdInfoId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_instances",
        Dict{String,Any}("nsName" => nsName, "nsdInfoId" => nsdInfoId);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sol_network_instance(
    nsName,
    nsdInfoId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_instances",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("nsName" => nsName, "nsdInfoId" => nsdInfoId),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    create_sol_network_package()
    create_sol_network_package(params::Dict{String,<:Any})

Creates a network package. A network package is a .zip file in CSAR (Cloud Service Archive)
format defines the function packages you want to deploy and the Amazon Web Services
infrastructure you want to deploy them on. For more information, see Network instances in
the Amazon Web Services Telco Network Builder User Guide.  A network package consists of a
network service descriptor (NSD) file (required) and any additional files (optional), such
as scripts specific to your needs. For example, if you have multiple function packages in
your network package, you can use the NSD to define which network functions should run in
certain VPCs, subnets, or EKS clusters. This request creates an empty network package
container with an ID. Once you create a network package, you can upload the network package
content using PutSolNetworkPackageContent.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A tag is a label that you assign to an Amazon Web Services resource. Each tag
  consists of a key and an optional value. You can use tags to search and filter your
  resources or track your Amazon Web Services costs.
"""
function create_sol_network_package(; aws_config::AbstractAWSConfig=current_aws_config())
    return tnb(
        "POST",
        "/sol/nsd/v1/ns_descriptors";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function create_sol_network_package(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "POST",
        "/sol/nsd/v1/ns_descriptors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sol_function_package(vnf_pkg_id)
    delete_sol_function_package(vnf_pkg_id, params::Dict{String,<:Any})

Deletes a function package. A function package is a .zip file in CSAR (Cloud Service
Archive) format that contains a network function (an ETSI standard telecommunication
application) and function package descriptor that uses the TOSCA standard to describe how
the network functions should run on your network. To delete a function package, the package
must be in a disabled state. To disable a function package, see UpdateSolFunctionPackage.

# Arguments
- `vnf_pkg_id`: ID of the function package.

"""
function delete_sol_function_package(
    vnfPkgId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "DELETE",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sol_function_package(
    vnfPkgId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "DELETE",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sol_network_instance(ns_instance_id)
    delete_sol_network_instance(ns_instance_id, params::Dict{String,<:Any})

Deletes a network instance. A network instance is a single network created in Amazon Web
Services TNB that can be deployed and on which life-cycle operations (like terminate,
update, and delete) can be performed. To delete a network instance, the instance must be in
a stopped or terminated state. To terminate a network instance, see
TerminateSolNetworkInstance.

# Arguments
- `ns_instance_id`: Network instance ID.

"""
function delete_sol_network_instance(
    nsInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "DELETE",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sol_network_instance(
    nsInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "DELETE",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    delete_sol_network_package(nsd_info_id)
    delete_sol_network_package(nsd_info_id, params::Dict{String,<:Any})

Deletes network package. A network package is a .zip file in CSAR (Cloud Service Archive)
format defines the function packages you want to deploy and the Amazon Web Services
infrastructure you want to deploy them on. To delete a network package, the package must be
in a disable state. To disable a network package, see UpdateSolNetworkPackage.

# Arguments
- `nsd_info_id`: ID of the network service descriptor in the network package.

"""
function delete_sol_network_package(
    nsdInfoId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "DELETE",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function delete_sol_network_package(
    nsdInfoId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "DELETE",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_function_instance(vnf_instance_id)
    get_sol_function_instance(vnf_instance_id, params::Dict{String,<:Any})

Gets the details of a network function instance, including the instantation state and
metadata from the function package descriptor in the network function package. A network
function instance is a function in a function package .

# Arguments
- `vnf_instance_id`: ID of the network function.

"""
function get_sol_function_instance(
    vnfInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/vnflcm/v1/vnf_instances/$(vnfInstanceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_function_instance(
    vnfInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/vnflcm/v1/vnf_instances/$(vnfInstanceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_function_package(vnf_pkg_id)
    get_sol_function_package(vnf_pkg_id, params::Dict{String,<:Any})

Gets the details of an individual function package, such as the operational state and
whether the package is in use. A function package is a .zip file in CSAR (Cloud Service
Archive) format that contains a network function (an ETSI standard telecommunication
application) and function package descriptor that uses the TOSCA standard to describe how
the network functions should run on your network..

# Arguments
- `vnf_pkg_id`: ID of the function package.

"""
function get_sol_function_package(
    vnfPkgId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_function_package(
    vnfPkgId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_function_package_content(accept, vnf_pkg_id)
    get_sol_function_package_content(accept, vnf_pkg_id, params::Dict{String,<:Any})

Gets the contents of a function package. A function package is a .zip file in CSAR (Cloud
Service Archive) format that contains a network function (an ETSI standard
telecommunication application) and function package descriptor that uses the TOSCA standard
to describe how the network functions should run on your network.

# Arguments
- `accept`: The format of the package that you want to download from the function packages.
- `vnf_pkg_id`: ID of the function package.

"""
function get_sol_function_package_content(
    Accept, vnfPkgId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)/package_content",
        Dict{String,Any}("headers" => Dict{String,Any}("Accept" => Accept));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_function_package_content(
    Accept,
    vnfPkgId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)/package_content",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("headers" => Dict{String,Any}("Accept" => Accept)),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_function_package_descriptor(accept, vnf_pkg_id)
    get_sol_function_package_descriptor(accept, vnf_pkg_id, params::Dict{String,<:Any})

Gets a function package descriptor in a function package. A function package descriptor is
a .yaml file in a function package that uses the TOSCA standard to describe how the network
function in the function package should run on your network. A function package is a .zip
file in CSAR (Cloud Service Archive) format that contains a network function (an ETSI
standard telecommunication application) and function package descriptor that uses the TOSCA
standard to describe how the network functions should run on your network.

# Arguments
- `accept`: Indicates which content types, expressed as MIME types, the client is able to
  understand.
- `vnf_pkg_id`: ID of the function package.

"""
function get_sol_function_package_descriptor(
    Accept, vnfPkgId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)/vnfd",
        Dict{String,Any}("headers" => Dict{String,Any}("Accept" => Accept));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_function_package_descriptor(
    Accept,
    vnfPkgId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)/vnfd",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("headers" => Dict{String,Any}("Accept" => Accept)),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_network_instance(ns_instance_id)
    get_sol_network_instance(ns_instance_id, params::Dict{String,<:Any})

Gets the details of the network instance. A network instance is a single network created in
Amazon Web Services TNB that can be deployed and on which life-cycle operations (like
terminate, update, and delete) can be performed.

# Arguments
- `ns_instance_id`: ID of the network instance.

"""
function get_sol_network_instance(
    nsInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_network_instance(
    nsInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_network_operation(ns_lcm_op_occ_id)
    get_sol_network_operation(ns_lcm_op_occ_id, params::Dict{String,<:Any})

Gets the details of a network operation, including the tasks involved in the network
operation and the status of the tasks. A network operation is any operation that is done to
your network, such as network instance instantiation or termination.

# Arguments
- `ns_lcm_op_occ_id`: The identifier of the network operation.

"""
function get_sol_network_operation(
    nsLcmOpOccId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/nslcm/v1/ns_lcm_op_occs/$(nsLcmOpOccId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_network_operation(
    nsLcmOpOccId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/nslcm/v1/ns_lcm_op_occs/$(nsLcmOpOccId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_network_package(nsd_info_id)
    get_sol_network_package(nsd_info_id, params::Dict{String,<:Any})

Gets the details of a network package. A network package is a .zip file in CSAR (Cloud
Service Archive) format defines the function packages you want to deploy and the Amazon Web
Services infrastructure you want to deploy them on.

# Arguments
- `nsd_info_id`: ID of the network service descriptor in the network package.

"""
function get_sol_network_package(
    nsdInfoId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_network_package(
    nsdInfoId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_network_package_content(accept, nsd_info_id)
    get_sol_network_package_content(accept, nsd_info_id, params::Dict{String,<:Any})

Gets the contents of a network package. A network package is a .zip file in CSAR (Cloud
Service Archive) format defines the function packages you want to deploy and the Amazon Web
Services infrastructure you want to deploy them on.

# Arguments
- `accept`: The format of the package you want to download from the network package.
- `nsd_info_id`: ID of the network service descriptor in the network package.

"""
function get_sol_network_package_content(
    Accept, nsdInfoId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)/nsd_content",
        Dict{String,Any}("headers" => Dict{String,Any}("Accept" => Accept));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_network_package_content(
    Accept,
    nsdInfoId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)/nsd_content",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("headers" => Dict{String,Any}("Accept" => Accept)),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    get_sol_network_package_descriptor(nsd_info_id)
    get_sol_network_package_descriptor(nsd_info_id, params::Dict{String,<:Any})

Gets the content of the network service descriptor. A network service descriptor is a .yaml
file in a network package that uses the TOSCA standard to describe the network functions
you want to deploy and the Amazon Web Services infrastructure you want to deploy the
network functions on.

# Arguments
- `nsd_info_id`: ID of the network service descriptor in the network package.

"""
function get_sol_network_package_descriptor(
    nsdInfoId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)/nsd";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function get_sol_network_package_descriptor(
    nsdInfoId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)/nsd",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    instantiate_sol_network_instance(ns_instance_id)
    instantiate_sol_network_instance(ns_instance_id, params::Dict{String,<:Any})

Instantiates a network instance. A network instance is a single network created in Amazon
Web Services TNB that can be deployed and on which life-cycle operations (like terminate,
update, and delete) can be performed. Before you can instantiate a network instance, you
have to create a network instance. For more information, see CreateSolNetworkInstance.

# Arguments
- `ns_instance_id`: ID of the network instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"additionalParamsForNs"`: Provides values for the configurable properties.
- `"dry_run"`: A check for whether you have the required permissions for the action without
  actually making the request and provides an error response. If you have the required
  permissions, the error response is DryRunOperation. Otherwise, it is UnauthorizedOperation.
- `"tags"`: A tag is a label that you assign to an Amazon Web Services resource. Each tag
  consists of a key and an optional value. When you use this API, the tags are transferred to
  the network operation that is created. Use tags to search and filter your resources or
  track your Amazon Web Services costs.
"""
function instantiate_sol_network_instance(
    nsInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)/instantiate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function instantiate_sol_network_instance(
    nsInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)/instantiate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sol_function_instances()
    list_sol_function_instances(params::Dict{String,<:Any})

Lists network function instances. A network function instance is a function in a function
package .

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max_results"`: The maximum number of results to include in the response.
- `"nextpage_opaque_marker"`: The token for the next page of results.
"""
function list_sol_function_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return tnb(
        "GET",
        "/sol/vnflcm/v1/vnf_instances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_sol_function_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/vnflcm/v1/vnf_instances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sol_function_packages()
    list_sol_function_packages(params::Dict{String,<:Any})

Lists information about function packages. A function package is a .zip file in CSAR (Cloud
Service Archive) format that contains a network function (an ETSI standard
telecommunication application) and function package descriptor that uses the TOSCA standard
to describe how the network functions should run on your network.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max_results"`: The maximum number of results to include in the response.
- `"nextpage_opaque_marker"`: The token for the next page of results.
"""
function list_sol_function_packages(; aws_config::AbstractAWSConfig=current_aws_config())
    return tnb(
        "GET",
        "/sol/vnfpkgm/v1/vnf_packages";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_sol_function_packages(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/vnfpkgm/v1/vnf_packages",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sol_network_instances()
    list_sol_network_instances(params::Dict{String,<:Any})

Lists your network instances. A network instance is a single network created in Amazon Web
Services TNB that can be deployed and on which life-cycle operations (like terminate,
update, and delete) can be performed.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max_results"`: The maximum number of results to include in the response.
- `"nextpage_opaque_marker"`: The token for the next page of results.
"""
function list_sol_network_instances(; aws_config::AbstractAWSConfig=current_aws_config())
    return tnb(
        "GET",
        "/sol/nslcm/v1/ns_instances";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_sol_network_instances(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/nslcm/v1/ns_instances",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sol_network_operations()
    list_sol_network_operations(params::Dict{String,<:Any})

Lists details for a network operation, including when the operation started and the status
of the operation. A network operation is any operation that is done to your network, such
as network instance instantiation or termination.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max_results"`: The maximum number of results to include in the response.
- `"nextpage_opaque_marker"`: The token for the next page of results.
"""
function list_sol_network_operations(; aws_config::AbstractAWSConfig=current_aws_config())
    return tnb(
        "GET",
        "/sol/nslcm/v1/ns_lcm_op_occs";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_sol_network_operations(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/nslcm/v1/ns_lcm_op_occs",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_sol_network_packages()
    list_sol_network_packages(params::Dict{String,<:Any})

Lists network packages. A network package is a .zip file in CSAR (Cloud Service Archive)
format defines the function packages you want to deploy and the Amazon Web Services
infrastructure you want to deploy them on.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"max_results"`: The maximum number of results to include in the response.
- `"nextpage_opaque_marker"`: The token for the next page of results.
"""
function list_sol_network_packages(; aws_config::AbstractAWSConfig=current_aws_config())
    return tnb(
        "GET",
        "/sol/nsd/v1/ns_descriptors";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_sol_network_packages(
    params::AbstractDict{String}; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/sol/nsd/v1/ns_descriptors",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    list_tags_for_resource(resource_arn)
    list_tags_for_resource(resource_arn, params::Dict{String,<:Any})

Lists tags for AWS TNB resources.

# Arguments
- `resource_arn`: Resource ARN.

"""
function list_tags_for_resource(
    resourceArn; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "GET",
        "/tags/$(resourceArn)";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function list_tags_for_resource(
    resourceArn,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "GET",
        "/tags/$(resourceArn)",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_sol_function_package_content(file, vnf_pkg_id)
    put_sol_function_package_content(file, vnf_pkg_id, params::Dict{String,<:Any})

Uploads the contents of a function package. A function package is a .zip file in CSAR
(Cloud Service Archive) format that contains a network function (an ETSI standard
telecommunication application) and function package descriptor that uses the TOSCA standard
to describe how the network functions should run on your network.

# Arguments
- `file`: Function package file.
- `vnf_pkg_id`: Function package ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Content-Type"`: Function package content type.
"""
function put_sol_function_package_content(
    file, vnfPkgId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "PUT",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)/package_content",
        Dict{String,Any}("file" => file);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_sol_function_package_content(
    file,
    vnfPkgId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "PUT",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)/package_content",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("file" => file), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    put_sol_network_package_content(file, nsd_info_id)
    put_sol_network_package_content(file, nsd_info_id, params::Dict{String,<:Any})

Uploads the contents of a network package. A network package is a .zip file in CSAR (Cloud
Service Archive) format defines the function packages you want to deploy and the Amazon Web
Services infrastructure you want to deploy them on.

# Arguments
- `file`: Network package file.
- `nsd_info_id`: Network service descriptor info ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Content-Type"`: Network package content type.
"""
function put_sol_network_package_content(
    file, nsdInfoId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "PUT",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)/nsd_content",
        Dict{String,Any}("file" => file);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function put_sol_network_package_content(
    file,
    nsdInfoId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "PUT",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)/nsd_content",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("file" => file), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    tag_resource(resource_arn, tags)
    tag_resource(resource_arn, tags, params::Dict{String,<:Any})

Tags an AWS TNB resource. A tag is a label that you assign to an Amazon Web Services
resource. Each tag consists of a key and an optional value. You can use tags to search and
filter your resources or track your Amazon Web Services costs.

# Arguments
- `resource_arn`: Resource ARN.
- `tags`: A tag is a label that you assign to an Amazon Web Services resource. Each tag
  consists of a key and an optional value. You can use tags to search and filter your
  resources or track your Amazon Web Services costs.

"""
function tag_resource(resourceArn, tags; aws_config::AbstractAWSConfig=current_aws_config())
    return tnb(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tags" => tags);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function tag_resource(
    resourceArn,
    tags,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "POST",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tags" => tags), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    terminate_sol_network_instance(ns_instance_id)
    terminate_sol_network_instance(ns_instance_id, params::Dict{String,<:Any})

Terminates a network instance. A network instance is a single network created in Amazon Web
Services TNB that can be deployed and on which life-cycle operations (like terminate,
update, and delete) can be performed. You must terminate a network instance before you can
delete it.

# Arguments
- `ns_instance_id`: ID of the network instance.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"tags"`: A tag is a label that you assign to an Amazon Web Services resource. Each tag
  consists of a key and an optional value. When you use this API, the tags are transferred to
  the network operation that is created. Use tags to search and filter your resources or
  track your Amazon Web Services costs.
"""
function terminate_sol_network_instance(
    nsInstanceId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)/terminate";
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function terminate_sol_network_instance(
    nsInstanceId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)/terminate",
        params;
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    untag_resource(resource_arn, tag_keys)
    untag_resource(resource_arn, tag_keys, params::Dict{String,<:Any})

Untags an AWS TNB resource. A tag is a label that you assign to an Amazon Web Services
resource. Each tag consists of a key and an optional value. You can use tags to search and
filter your resources or track your Amazon Web Services costs.

# Arguments
- `resource_arn`: Resource ARN.
- `tag_keys`: Tag keys.

"""
function untag_resource(
    resourceArn, tagKeys; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}("tagKeys" => tagKeys);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function untag_resource(
    resourceArn,
    tagKeys,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "DELETE",
        "/tags/$(resourceArn)",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("tagKeys" => tagKeys), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sol_function_package(operational_state, vnf_pkg_id)
    update_sol_function_package(operational_state, vnf_pkg_id, params::Dict{String,<:Any})

Updates the operational state of function package. A function package is a .zip file in
CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard
telecommunication application) and function package descriptor that uses the TOSCA standard
to describe how the network functions should run on your network.

# Arguments
- `operational_state`: Operational state of the function package.
- `vnf_pkg_id`: ID of the function package.

"""
function update_sol_function_package(
    operationalState, vnfPkgId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "PATCH",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)",
        Dict{String,Any}("operationalState" => operationalState);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sol_function_package(
    operationalState,
    vnfPkgId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "PATCH",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)",
        Dict{String,Any}(
            mergewith(
                _merge, Dict{String,Any}("operationalState" => operationalState), params
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sol_network_instance(ns_instance_id, update_type)
    update_sol_network_instance(ns_instance_id, update_type, params::Dict{String,<:Any})

Update a network instance. A network instance is a single network created in Amazon Web
Services TNB that can be deployed and on which life-cycle operations (like terminate,
update, and delete) can be performed.

# Arguments
- `ns_instance_id`: ID of the network instance.
- `update_type`: The type of update.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"modifyVnfInfoData"`: Identifies the network function information parameters and/or the
  configurable properties of the network function to be modified.
- `"tags"`: A tag is a label that you assign to an Amazon Web Services resource. Each tag
  consists of a key and an optional value. When you use this API, the tags are transferred to
  the network operation that is created. Use tags to search and filter your resources or
  track your Amazon Web Services costs.
"""
function update_sol_network_instance(
    nsInstanceId, updateType; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)/update",
        Dict{String,Any}("updateType" => updateType);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sol_network_instance(
    nsInstanceId,
    updateType,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "POST",
        "/sol/nslcm/v1/ns_instances/$(nsInstanceId)/update",
        Dict{String,Any}(
            mergewith(_merge, Dict{String,Any}("updateType" => updateType), params)
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    update_sol_network_package(nsd_info_id, nsd_operational_state)
    update_sol_network_package(nsd_info_id, nsd_operational_state, params::Dict{String,<:Any})

Updates the operational state of a network package. A network package is a .zip file in
CSAR (Cloud Service Archive) format defines the function packages you want to deploy and
the Amazon Web Services infrastructure you want to deploy them on. A network service
descriptor is a .yaml file in a network package that uses the TOSCA standard to describe
the network functions you want to deploy and the Amazon Web Services infrastructure you
want to deploy the network functions on.

# Arguments
- `nsd_info_id`: ID of the network service descriptor in the network package.
- `nsd_operational_state`: Operational state of the network service descriptor in the
  network package.

"""
function update_sol_network_package(
    nsdInfoId, nsdOperationalState; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "PATCH",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)",
        Dict{String,Any}("nsdOperationalState" => nsdOperationalState);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function update_sol_network_package(
    nsdInfoId,
    nsdOperationalState,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "PATCH",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)",
        Dict{String,Any}(
            mergewith(
                _merge,
                Dict{String,Any}("nsdOperationalState" => nsdOperationalState),
                params,
            ),
        );
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_sol_function_package_content(file, vnf_pkg_id)
    validate_sol_function_package_content(file, vnf_pkg_id, params::Dict{String,<:Any})

Validates function package content. This can be used as a dry run before uploading function
package content with PutSolFunctionPackageContent. A function package is a .zip file in
CSAR (Cloud Service Archive) format that contains a network function (an ETSI standard
telecommunication application) and function package descriptor that uses the TOSCA standard
to describe how the network functions should run on your network.

# Arguments
- `file`: Function package file.
- `vnf_pkg_id`: Function package ID.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Content-Type"`: Function package content type.
"""
function validate_sol_function_package_content(
    file, vnfPkgId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "PUT",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)/package_content/validate",
        Dict{String,Any}("file" => file);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_sol_function_package_content(
    file,
    vnfPkgId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "PUT",
        "/sol/vnfpkgm/v1/vnf_packages/$(vnfPkgId)/package_content/validate",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("file" => file), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end

"""
    validate_sol_network_package_content(file, nsd_info_id)
    validate_sol_network_package_content(file, nsd_info_id, params::Dict{String,<:Any})

Validates network package content. This can be used as a dry run before uploading network
package content with PutSolNetworkPackageContent. A network package is a .zip file in CSAR
(Cloud Service Archive) format defines the function packages you want to deploy and the
Amazon Web Services infrastructure you want to deploy them on.

# Arguments
- `file`: Network package file.
- `nsd_info_id`: Network service descriptor file.

# Optional Parameters
Optional parameters can be passed as a `params::Dict{String,<:Any}`. Valid keys are:
- `"Content-Type"`: Network package content type.
"""
function validate_sol_network_package_content(
    file, nsdInfoId; aws_config::AbstractAWSConfig=current_aws_config()
)
    return tnb(
        "PUT",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)/nsd_content/validate",
        Dict{String,Any}("file" => file);
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
function validate_sol_network_package_content(
    file,
    nsdInfoId,
    params::AbstractDict{String};
    aws_config::AbstractAWSConfig=current_aws_config(),
)
    return tnb(
        "PUT",
        "/sol/nsd/v1/ns_descriptors/$(nsdInfoId)/nsd_content/validate",
        Dict{String,Any}(mergewith(_merge, Dict{String,Any}("file" => file), params));
        aws_config=aws_config,
        feature_set=SERVICE_FEATURE_SET,
    )
end
