# load some basic schemes

loadcolorscheme(:alpine, [
    RGB(0.277546, 0.355398, 0.484215),
    RGB(0.304739, 0.42573, 0.46747),
    RGB(0.336447, 0.468254, 0.376802),
    RGB(0.397271, 0.511821, 0.352482),
    RGB(0.495398, 0.562531, 0.427457),
    RGB(0.610225, 0.62717, 0.537364),
    RGB(0.735256, 0.728382, 0.656772),
    RGB(0.867237, 0.859925, 0.784232),
    RGB(1.0, 0.997467, 0.914244)], "general", "alpine")

loadcolorscheme(:aquamarine, [
    RGB(0.68069, 0.735561, 0.850004),
    RGB(0.762233, 0.803087, 0.873397),
    RGB(0.738044, 0.801736, 0.849202),
    RGB(0.653851, 0.759285, 0.801252),
    RGB(0.555381, 0.703512, 0.753383),
    RGB(0.488359, 0.662194, 0.729431),
    RGB(0.498514, 0.663109, 0.75323),
    RGB(0.631571, 0.734035, 0.848615)], "general")

loadcolorscheme(:army, [
    RGB(0.45684, 0.59295, 0.506035),
    RGB(0.458087, 0.591348, 0.443069),
    RGB(0.495384, 0.591978, 0.426517),
    RGB(0.547035, 0.593509, 0.425644),
    RGB(0.581442, 0.574029, 0.424784),
    RGB(0.597959, 0.551917, 0.433916),
    RGB(0.628709, 0.583197, 0.478777),
    RGB(0.701339, 0.695369, 0.570508),
    RGB(0.762737, 0.757717, 0.654841)], "general")

loadcolorscheme(:atlantic, [
    RGB(0.131838, 0.159976, 0.163333),
    RGB(0.230913, 0.290626, 0.293972),
    RGB(0.392506, 0.513992, 0.525327),
    RGB(0.484579, 0.662274, 0.695467),
    RGB(0.523077, 0.717819, 0.782847),
    RGB(0.566364, 0.722379, 0.819837),
    RGB(0.609652, 0.686364, 0.806245),
    RGB(0.479438, 0.4981, 0.622843)], "general")

loadcolorscheme(:auerbach, [
    RGB(0.0905657,0.0995937,0.164406),
    RGB(0.149226,0.0896605,0.102863),
    RGB(0.197664,0.108484,0.122217),
    RGB(0.161893,0.125261,0.155805),
    RGB(0.217886,0.137257,0.156931),
    RGB(0.260003,0.123735,0.140085),
    RGB(0.173018,0.162569,0.219974),
    RGB(0.253457,0.167713,0.19028),
    RGB(0.31546,0.150659,0.163398),
    RGB(0.311404,0.195824,0.21136),
    RGB(0.242903,0.217797,0.269898),
    RGB(0.418604,0.131818,0.144635),
    RGB(0.393078,0.206795,0.192464),
    RGB(0.331276,0.241246,0.259123),
    RGB(0.486078,0.207083,0.172862),
    RGB(0.398963,0.266367,0.260443),
    RGB(0.352032,0.300912,0.336166),
    RGB(0.467208,0.266899,0.22033),
    RGB(0.527449,0.246689,0.20115),
    RGB(0.581452,0.222479,0.203113),
    RGB(0.444542,0.319214,0.302479),
    RGB(0.573442,0.283624,0.23317),
    RGB(0.5255,0.32034,0.24441),
    RGB(0.455829,0.373011,0.383873),
    RGB(0.656635,0.276376,0.242455),
    RGB(0.510962,0.363525,0.317007),
    RGB(0.592265,0.359399,0.275303),
    RGB(0.199572,0.442875,0.682907),
    RGB(0.693679,0.319676,0.275121),
    RGB(0.554338,0.409578,0.353445),
    RGB(0.532236,0.435891,0.432553),
    RGB(0.712398,0.369779,0.314696),
    RGB(0.633594,0.424161,0.316022),
    RGB(0.606288,0.45822,0.389837),
    RGB(0.753075,0.419739,0.364871),
    RGB(0.593024,0.501589,0.494324),
    RGB(0.646968,0.497499,0.434377),
    RGB(0.68876,0.502248,0.367488),
    RGB(0.693004,0.540611,0.472076),
    RGB(0.808328,0.490766,0.437675),
    RGB(0.668921,0.571175,0.546619),
    RGB(0.74162,0.580912,0.42827),
    RGB(0.751641,0.60085,0.524057),
    RGB(0.73315,0.646258,0.620111),
    RGB(0.811892,0.669785,0.477094),
    RGB(0.813559,0.666601,0.583934),
    RGB(0.827819,0.732186,0.680818),
    RGB(0.884046,0.774829,0.570453),
    RGB(0.888407,0.816291,0.762794),
    RGB(0.949093,0.911894,0.891501)], "general", "palette of artist Auerbach's portrait of his wife Julia")

loadcolorscheme(:aurora, [
    RGB(0.258824, 0.258824, 0.258824),
    RGB(0.204175, 0.222746, 0.360176),
    RGB(0.23957, 0.205789, 0.388725),
    RGB(0.315771, 0.225764, 0.379871),
    RGB(0.399457, 0.284783, 0.361931),
    RGB(0.470886, 0.373235, 0.356136),
    RGB(0.521559, 0.473778, 0.376624),
    RGB(0.551878, 0.565319, 0.430435),
    RGB(0.568816, 0.626998, 0.517508),
    RGB(0.583572, 0.642176, 0.630673),
    RGB(0.609237, 0.602413, 0.755645),
    RGB(0.658459, 0.511458, 0.871022),
    RGB(0.741099, 0.389229, 0.948278),
    RGB(0.8619, 0.275798, 0.951756)], "general")

loadcolorscheme(:autumn, [
    RGB{Float64}(0.0233758,0.0181998,0.012548),
    RGB{Float64}(0.100989,0.0831826,0.0536865),
    RGB{Float64}(0.200013,0.125413,0.0426299),
    RGB{Float64}(0.177088,0.170121,0.134238),
    RGB{Float64}(0.30162,0.191351,0.0604868),
    RGB{Float64}(0.274507,0.251993,0.179413),
    RGB{Float64}(0.407273,0.25859,0.0791292),
    RGB{Float64}(0.302036,0.321205,0.306142),
    RGB{Float64}(0.416233,0.342677,0.198025),
    RGB{Float64}(0.529665,0.323623,0.0958113),
    RGB{Float64}(0.440347,0.433215,0.345927),
    RGB{Float64}(0.657612,0.391105,0.108081),
    RGB{Float64}(0.563732,0.436001,0.224606),
    RGB{Float64}(0.413598,0.481472,0.557762),
    RGB{Float64}(0.710565,0.502792,0.243539),
    RGB{Float64}(0.795472,0.479786,0.109355),
    RGB{Float64}(0.602762,0.553208,0.396679),
    RGB{Float64}(0.39496,0.580617,0.834524),
    RGB{Float64}(0.767112,0.62202,0.329779),
    RGB{Float64}(0.899358,0.580556,0.199535),
    RGB{Float64}(0.62188,0.660084,0.697445),
    RGB{Float64}(0.527565,0.722719,0.927447),
    RGB{Float64}(0.805007,0.698941,0.497836),
    RGB{Float64}(0.918061,0.670821,0.358338),
    RGB{Float64}(0.942659,0.760529,0.217276),
    RGB{Float64}(0.683966,0.834165,0.951374),
    RGB{Float64}(0.954946,0.803419,0.439133),
    RGB{Float64}(0.954791,0.849885,0.598371),
    RGB{Float64}(0.961593,0.912222,0.766808),
    RGB{Float64}(0.946942,0.967295,0.964988)
], "general", "what we call September/October/November")

loadcolorscheme(:avocado, [
    RGB(0.0, 0.0, 0.0),
    RGB(0.0, 0.442859, 0.0749256),
    RGB(0.289326, 0.685107, 0.108759),
    RGB(0.683989, 0.830896, 0.145815),
    RGB(1.0, 0.984375, 0.230411)], "general")

loadcolorscheme(:beach, [
    RGB(0.853407, 0.503288, 0.26041),
    RGB(0.879024, 0.628064, 0.283622),
    RGB(0.902009, 0.732143, 0.303912),
    RGB(0.875374, 0.776136, 0.387224),
    RGB(0.799766, 0.761697, 0.551801),
    RGB(0.723459, 0.731524, 0.768181),
    RGB(0.742358, 0.769362, 0.959202),
    RGB(1.0, 1.0, 1.0)], "general")

loadcolorscheme(:blackbody, [
    RGB(1.0000, 0.0475, 0.0000),
    RGB(1.0000, 0.0736, 0.0000),
    RGB(1.0000, 0.0994, 0.0000),
    RGB(1.0000, 0.1248, 0.0000),
    RGB(1.0000, 0.1493, 0.0000),
    RGB(1.0000, 0.1730, 0.0000),
    RGB(1.0000, 0.1957, 0.0000),
    RGB(1.0000, 0.2173, 0.0000),
    RGB(1.0000, 0.2378, 0.0000),
    RGB(1.0000, 0.2573, 0.0000),
    RGB(1.0000, 0.2812, 0.0076),
    RGB(1.0000, 0.3066, 0.0191),
    RGB(1.0000, 0.3316, 0.0322),
    RGB(1.0000, 0.3564, 0.0467),
    RGB(1.0000, 0.3808, 0.0627),
    RGB(1.0000, 0.4049, 0.0801),
    RGB(1.0000, 0.4285, 0.0988),
    RGB(1.0000, 0.4519, 0.1188),
    RGB(1.0000, 0.4748, 0.1399),
    RGB(1.0000, 0.4973, 0.1622),
    RGB(1.0000, 0.5195, 0.1855),
    RGB(1.0000, 0.5412, 0.2098),
    RGB(1.0000, 0.5625, 0.2349),
    RGB(1.0000, 0.5835, 0.2609),
    RGB(1.0000, 0.6040, 0.2877),
    RGB(1.0000, 0.6242, 0.3151),
    RGB(1.0000, 0.6440, 0.3432),
    RGB(1.0000, 0.6633, 0.3719),
    RGB(1.0000, 0.6823, 0.4010),
    RGB(1.0000, 0.7009, 0.4306),
    RGB(1.0000, 0.7192, 0.4606),
    RGB(1.0000, 0.7370, 0.4910),
    RGB(1.0000, 0.7545, 0.5217),
    RGB(1.0000, 0.7717, 0.5526),
    RGB(1.0000, 0.7884, 0.5837),
    RGB(1.0000, 0.8049, 0.6150),
    RGB(1.0000, 0.8209, 0.6464),
    RGB(1.0000, 0.8367, 0.6780),
    RGB(1.0000, 0.8521, 0.7095),
    RGB(1.0000, 0.8672, 0.7411),
    RGB(1.0000, 0.8819, 0.7728),
    RGB(1.0000, 0.8964, 0.8043),
    RGB(1.0000, 0.9105, 0.8359),
    RGB(1.0000, 0.9244, 0.8673),
    RGB(1.0000, 0.9379, 0.8987),
    RGB(1.0000, 0.9512, 0.9299),
    RGB(1.0000, 0.9641, 0.9610),
    RGB(1.0000, 0.9768, 0.9919),
    RGB(0.9778, 0.9673, 1.0000),
    RGB(0.9495, 0.9508, 1.0000),
    RGB(0.9229, 0.9351, 1.0000),
    RGB(0.8979, 0.9203, 1.0000),
    RGB(0.8744, 0.9062, 1.0000),
    RGB(0.8523, 0.8927, 1.0000),
    RGB(0.8314, 0.8800, 1.0000),
    RGB(0.8117, 0.8678, 1.0000),
    RGB(0.7931, 0.8562, 1.0000),
    RGB(0.7755, 0.8451, 1.0000),
    RGB(0.7588, 0.8345, 1.0000),
    RGB(0.7430, 0.8244, 1.0000),
    RGB(0.7279, 0.8147, 1.0000),
    RGB(0.7137, 0.8054, 1.0000),
    RGB(0.7001, 0.7965, 1.0000),
    RGB(0.6871, 0.7880, 1.0000),
    RGB(0.6747, 0.7798, 1.0000),
    RGB(0.6630, 0.7719, 1.0000),
    RGB(0.6517, 0.7643, 1.0000),
    RGB(0.6410, 0.7570, 1.0000),
    RGB(0.6307, 0.7500, 1.0000),
    RGB(0.6208, 0.7433, 1.0000),
    RGB(0.6114, 0.7368, 1.0000),
    RGB(0.6024, 0.7305, 1.0000),
    RGB(0.5937, 0.7244, 1.0000),
    RGB(0.5854, 0.7186, 1.0000),
    RGB(0.5774, 0.7129, 1.0000),
    RGB(0.5697, 0.7075, 1.0000),
    RGB(0.5623, 0.7022, 1.0000),
    RGB(0.5552, 0.6971, 1.0000),
    RGB(0.5483, 0.6921, 1.0000),
    RGB(0.5417, 0.6873, 1.0000),
    RGB(0.5353, 0.6827, 1.0000),
    RGB(0.5292, 0.6782, 1.0000),
    RGB(0.5233, 0.6738, 1.0000),
    RGB(0.5176, 0.6696, 1.0000),
    RGB(0.5120, 0.6655, 1.0000),
    RGB(0.5067, 0.6615, 1.0000),
    RGB(0.5015, 0.6577, 1.0000),
    RGB(0.4965, 0.6539, 1.0000),
    RGB(0.4917, 0.6503, 1.0000),
    RGB(0.4870, 0.6467, 1.0000),
    RGB(0.4825, 0.6433, 1.0000),
    RGB(0.4781, 0.6399, 1.0000),
    RGB(0.4738, 0.6367, 1.0000),
    RGB(0.4697, 0.6335, 1.0000),
    RGB(0.4657, 0.6304, 1.0000),
    RGB(0.4618, 0.6274, 1.0000),
    RGB(0.4580, 0.6245, 1.0000),
    RGB(0.4544, 0.6216, 1.0000),
    RGB(0.4508, 0.6188, 1.0000),
    RGB(0.4474, 0.6161, 1.0000),
    RGB(0.4440, 0.6134, 1.0000),
    RGB(0.4407, 0.6109, 1.0000),
    RGB(0.4375, 0.6083, 1.0000),
    RGB(0.4344, 0.6059, 1.0000),
    RGB(0.4314, 0.6035, 1.0000),
    RGB(0.4285, 0.6011, 1.0000),
    RGB(0.4256, 0.5988, 1.0000),
    RGB(0.4228, 0.5966, 1.0000),
    RGB(0.4201, 0.5944, 1.0000),
    RGB(0.4175, 0.5923, 1.0000),
    RGB(0.4149, 0.5902, 1.0000),
    RGB(0.4124, 0.5881, 1.0000),
    RGB(0.4099, 0.5861, 1.0000),
    RGB(0.4075, 0.5842, 1.0000),
    RGB(0.4052, 0.5822, 1.0000),
    RGB(0.4029, 0.5804, 1.0000),
    RGB(0.4006, 0.5785, 1.0000),
    RGB(0.3984, 0.5767, 1.0000),
    RGB(0.3963, 0.5750, 1.0000),
    RGB(0.3942, 0.5732, 1.0000),
    RGB(0.3922, 0.5716, 1.0000),
    RGB(0.3902, 0.5699, 1.0000),
    RGB(0.3883, 0.5683, 1.0000),
    RGB(0.3864, 0.5667, 1.0000),
    RGB(0.3845, 0.5651, 1.0000),
    RGB(0.3827, 0.5636, 1.0000),
    RGB(0.3809, 0.5621, 1.0000),
    RGB(0.3791, 0.5606, 1.0000),
    RGB(0.3774, 0.5592, 1.0000),
    RGB(0.3757, 0.5578, 1.0000),
    RGB(0.3741, 0.5564, 1.0000)], "general", "blackbody radiation")

loadcolorscheme(:bluegreenyellow, [
    RGB(0.122103, 0.00901808, 0.39826),
    RGB(0.0839935, 0.279645, 0.510102),
    RGB(0.097699, 0.498132, 0.548165),
    RGB(0.175507, 0.652273, 0.528496),
    RGB(0.329526, 0.762208, 0.474596),
    RGB(0.571909, 0.839991, 0.408102),
    RGB(0.914809, 0.897673, 0.350652)], "general")

loadcolorscheme(:bosch_garden, [
    RGB(0.07530125537056928, 0.07649729299614583, 0.03739579713464333),
    RGB(0.17922449019740094, 0.1633440970817033, 0.06494415075992625),
    RGB(0.13499752721320693, 0.2150800454892352, 0.2383452663078406),
    RGB(0.28151602379944357, 0.24238004830954396, 0.1491460305280029),
    RGB(0.2750424441862694, 0.268919103027835, 0.04689764438509079),
    RGB(0.1088844856592186, 0.31652262593100744, 0.41632264308114464),
    RGB(0.35388831995008413, 0.32426749599858934, 0.22447193247789052),
    RGB(0.36140811346759677, 0.352059864189544, 0.0932026796429643),
    RGB(0.3094835993612153, 0.3741315030509121, 0.36853592965423),
    RGB(0.5724547637264754, 0.30174692810158965, 0.13749992862689567),
    RGB(0.4650061145435198, 0.40355172863099376, 0.27914316311240445),
    RGB(0.4375894519368597, 0.431424779524875, 0.15298507258853966),
    RGB(0.25778514530812324, 0.4617778361344537, 0.5538334865196078),
    RGB(0.42604036658877265, 0.4797579946492113, 0.4560043267698763),
    RGB(0.6460723793474014, 0.44522793327471666, 0.2947425141656897),
    RGB(0.5246848111854685, 0.5018882811142014, 0.32144455202720323),
    RGB(0.5241623252167912, 0.5130522455516549, 0.20788535759294266),
    RGB(0.592555348077772, 0.5319836269513223, 0.4159007998414864),
    RGB(0.4396185227913203, 0.5765880756540323, 0.6067682647597576),
    RGB(0.5983132545795171, 0.5921102627406083, 0.28585314550986923),
    RGB(0.6032274117137337, 0.6074927907835672, 0.5372550908432298),
    RGB(0.6900441316793893, 0.5893076949291167, 0.4578506679389313),
    RGB(0.5281875878643276, 0.6594220878544274, 0.6830394931589577),
    RGB(0.6828492439650822, 0.6628704088601206, 0.33845402086611837),
    RGB(0.7287297912250598, 0.6614124640405774, 0.5554321859964335),
    RGB(0.7033546255072692, 0.7174909073224065, 0.6504570347898034),
    RGB(0.7551702441156565, 0.729795922084148, 0.42232693003647165),
    RGB(0.6253811345966959, 0.7435245080174927, 0.7605415603741497),
    RGB(0.8043409132937561, 0.7424514037724755, 0.6234620677964494),
    RGB(0.7795358409718735, 0.7836287708751883, 0.7135765240457057),
    RGB(0.8415044389204545, 0.8345875355113636, 0.7600355113636363),
    RGB(0.9058543033696058, 0.9009288016065757, 0.8380141319703904)], "general", "colors from artist Hieronymus Bosch painting The Garden of Earthly Delights")

loadcolorscheme(:bosch_hell, [
    RGB(0.028345470928858425, 0.021315651958756794, 0.013759352472819664),
    RGB(0.06741215235695605, 0.05796160378261147, 0.04115055096638387),
    RGB(0.15517539042108927, 0.08800923307812772, 0.03587809400556812),
    RGB(0.10600106287760125, 0.10666579841687178, 0.08685702897739986),
    RGB(0.1545331754107543, 0.15555763007219317, 0.13369400749937765),
    RGB(0.23600254650132862, 0.14819530558015945, 0.059120349867139065),
    RGB(0.23977737748543884, 0.19864132481421973, 0.13773473589074112),
    RGB(0.18953061348742473, 0.21357764346439959, 0.21067805193942615),
    RGB(0.3524786269032416, 0.21187473139734772, 0.06613956593811395),
    RGB(0.3252051878511236, 0.24494052844101125, 0.1489850333567416),
    RGB(0.2619575743299833, 0.27611952994137356, 0.24970359610552764),
    RGB(0.40906774529203055, 0.30328022652838427, 0.18162463325600436),
    RGB(0.20508919086402266, 0.3381672716005666, 0.4223121016288952),
    RGB(0.47921300685530915, 0.30690955002917153, 0.0953783638418903),
    RGB(0.3374502574906367, 0.34724270443196004, 0.30788565074906366),
    RGB(0.4902284613267272, 0.3784353065648225, 0.24892478667767687),
    RGB(0.4161610704787234, 0.4288697402165653, 0.3922130271656535),
    RGB(0.5889891179839634, 0.38592004939862545, 0.13798391859965636),
    RGB(0.611362675598335, 0.44938269597641345, 0.26363732440166493),
    RGB(0.5461262537147102, 0.47684255432763745, 0.3776612416419019),
    RGB(0.5595771296902269, 0.5517646296902269, 0.5011657395287958),
    RGB(0.6796276385967548, 0.5242720383864183, 0.3574359600360577),
    RGB(0.710294255239521, 0.5700581259356288, 0.20061634543413176),
    RGB(0.7288533653846154, 0.5927139423076924, 0.4406550480769231),
    RGB(0.6770326876829779, 0.6506070943120034, 0.5796182298201589),
    RGB(0.8231404850223965, 0.6359488731802911, 0.335692539193729),
    RGB(0.8110703930412372, 0.6642853307560138, 0.5028243127147767),
    RGB(0.78060809654228, 0.7387198840294419, 0.6550825380862718),
    RGB(0.9158942224017901, 0.7172873414967678, 0.4201947880407757),
    RGB(0.91901611328125, 0.7779931640625, 0.58317626953125),
    RGB(0.8750235733936812, 0.8200518059992901, 0.7297338147852325),
    RGB(0.9520800309480676, 0.9037519814311594, 0.8232634171195652)], "general", "colors from artist Hieronymus Bosch painting Hell")

loadcolorscheme(:botticelli, [
    RGB(0.05695005623735094, 0.0653929898638574, 0.05267668232432475),
    RGB(0.10517969694056904, 0.1094558088189137, 0.08376402353619686),
    RGB(0.16398935838222442, 0.15660910658901703, 0.11353151936119886),
    RGB(0.2073658219877758, 0.2190555982968868, 0.17999191535723577),
    RGB(0.3062247208387527, 0.19046422949116518, 0.09437030600672525),
    RGB(0.32436246232044275, 0.26736070580076354, 0.18194191661917383),
    RGB(0.2660323970209163, 0.3172576248825985, 0.27968318313943524),
    RGB(0.42559756049857084, 0.2945448301184646, 0.1636613471316209),
    RGB(0.38025390551516236, 0.38458966812380074, 0.28920406647400204),
    RGB(0.3214423140291426, 0.404061677405367, 0.3920521837798188),
    RGB(0.53012108909569, 0.35626319256132133, 0.16875019259213608),
    RGB(0.4933003317198597, 0.40333450061518283, 0.2767322220902219),
    RGB(0.6087596418053022, 0.44436533692288144, 0.2487504935061399),
    RGB(0.4453416607388567, 0.5038464935901826, 0.40763181529515047),
    RGB(0.5636288625328703, 0.47585983566005224, 0.34395477285883524),
    RGB(0.4121493837205374, 0.5195764715115034, 0.5224364681753173),
    RGB(0.639764417239067, 0.5228415485619008, 0.36737868161779363),
    RGB(0.5310965521671731, 0.5824881489303145, 0.4923385783209674),
    RGB(0.4858719278183829, 0.5920129288582213, 0.5904338714597408),
    RGB(0.7262367242174276, 0.5423773993519618, 0.28344792561456256),
    RGB(0.669830193649179, 0.5758211394298309, 0.4391156354454295),
    RGB(0.5609127628780718, 0.6496148393194706, 0.638371817403119),
    RGB(0.6143317355577689, 0.6491985834970223, 0.5619066905288255),
    RGB(0.7110355034481454, 0.6314810812961749, 0.5011619072121082),
    RGB(0.7893291188007846, 0.6376965711683945, 0.4275260927430653),
    RGB(0.7251755105554747, 0.679503276020049, 0.5748535784394039),
    RGB(0.6323954469364388, 0.7040931633143026, 0.6880193273198324),
    RGB(0.7420333185478368, 0.7245847443530777, 0.6517764987375461),
    RGB(0.8188664477703115, 0.7233408101710446, 0.5790436010995723),
    RGB(0.7243632688029112, 0.7929893723956861, 0.7726782275816884),
    RGB(0.8155937511095921, 0.780050045382321, 0.7101263880998455),
    RGB(0.8542077403613729, 0.8476678167301184, 0.8119314991489405)], "general",
"palette from artist Sandro Botticelli's painting The Birth of Venus, thought to have been painted in the mid 1480s. It depicts the goddess Venus, having emerged from the sea as an adult woman, arriving at the shore, Adobe Illustrator icon")

loadcolorscheme(:brass, [
    RGB(0.143801, 0.154009, 0.0471656),
    RGB(0.364383, 0.3345, 0.142088),
    RGB(0.656718, 0.592813, 0.276295),
    RGB(0.9467, 0.85568, 0.416617),
    RGB(0.861402, 0.78024, 0.385641),
    RGB(0.878462, 0.795697, 0.393286),
    RGB(0.738337, 0.670505, 0.326983),
    RGB(0.484833, 0.443357, 0.205342),
    RGB(0.17615, 0.166293, 0.0534371)], "general", "brass colors")

loadcolorscheme(:browncyan, [
    RGB(0.347677, 0.199863, 0.085069),
    RGB(0.560535, 0.419142, 0.29185),
    RGB(0.729634, 0.613774, 0.512),
    RGB(0.822643, 0.763401, 0.698769),
    RGB(0.836049, 0.882901, 0.85903),
    RGB(0.762289, 0.939134, 0.951842),
    RGB(0.639101, 0.925688, 0.971463),
    RGB(0.504741, 0.85335, 0.938049),
    RGB(0.342992, 0.650614, 0.772702)], "general")

loadcolorscheme(:canaletto, [
    RGB(0.034214766443250784, 0.0322387712720445, 0.06071185589675335),
    RGB(0.11843962825226598, 0.1092886311924143, 0.09978767221091664),
    RGB(0.20373838996508195, 0.17682640440323452, 0.12015488780854804),
    RGB(0.25642057042235167, 0.23668346307843674, 0.19188500576644904),
    RGB(0.3219638752377933, 0.2525465678503488, 0.10400334892200382),
    RGB(0.3323439460747135, 0.3057761994601266, 0.21840816205165683),
    RGB(0.36349907627313177, 0.3634167878805269, 0.3010799161693036),
    RGB(0.42860298137373576, 0.36582719942207814, 0.19897095808602444),
    RGB(0.44999717612006535, 0.44114185042320014, 0.30106263305398695),
    RGB(0.43109448284794943, 0.4823218327334206, 0.42877092877399653),
    RGB(0.5760701755017076, 0.4504364459825026, 0.20410077558420628),
    RGB(0.5222244602489486, 0.5135841599091506, 0.3700340990249658),
    RGB(0.4319331963513216, 0.5356499552049345, 0.6570045562653517),
    RGB(0.4810763685739917, 0.5489414516537952, 0.5182812743778765),
    RGB(0.6457118125642248, 0.547362134376835, 0.32200198753119497),
    RGB(0.48453299151903045, 0.5874298322463415, 0.7022980319567474),
    RGB(0.5485872670151096, 0.6147881456147178, 0.6014349160315074),
    RGB(0.6475778507036376, 0.6007698509626453, 0.44754419319097505),
    RGB(0.5712408612696148, 0.6610025112933904, 0.7328329321207798),
    RGB(0.7897583000905336, 0.6648884863209416, 0.37347556123748094),
    RGB(0.7583407886213543, 0.6970825137453787, 0.5190029613786457),
    RGB(0.629457547109979, 0.7203278640178191, 0.7832098239654577),
    RGB(0.6662353142511462, 0.7708403312850229, 0.8427053815906775),
    RGB(0.7851184890911054, 0.7673073645163903, 0.6592788889938974),
    RGB(0.7249150949617515, 0.7965102380638354, 0.8270414303613822),
    RGB(0.7125326057275897, 0.8136255563034147, 0.8755119159113555),
    RGB(0.8860522952630497, 0.8094429138409371, 0.5787322107480477),
    RGB(0.7697579579697761, 0.8572729968741567, 0.8917225940564002),
    RGB(0.8097069792384401, 0.8893310760558856, 0.9138026604312929),
    RGB(0.938019686123348, 0.9049865530601007, 0.7312358647341095),
    RGB(0.862142583930427, 0.9282232580320678, 0.9399599434976197),
    RGB(0.9484832069804526, 0.9778496734356529, 0.96414923157287)], "general",
"color palette from artist Canaletto The Grand Canal and the Church of the Salute")

loadcolorscheme(:candy, [
    RGB(0.405188, 0.204349, 0.343389),
    RGB(0.580744, 0.217841, 0.355177),
    RGB(0.738643, 0.266095, 0.407856),
    RGB(0.830192, 0.392727, 0.525158),
    RGB(0.831283, 0.533131, 0.662656),
    RGB(0.766146, 0.640731, 0.778398),
    RGB(0.696099, 0.729278, 0.860188),
    RGB(0.673284, 0.831207, 0.909501),
    RGB(0.659388, 0.872053, 0.882048)], "general")

loadcolorscheme(:cezanne, [
    RGB(0.03124343755934729, 0.13497559456853608, 0.1343021740281653),
    RGB(0.08163565679194464, 0.2312679635266445, 0.21562914542922565),
    RGB(0.143721203667775, 0.2826108867379123, 0.30067028093917536),
    RGB(0.22433365375739883, 0.3094564070630791, 0.23360081711742375),
    RGB(0.2130668013349915, 0.34214320245711294, 0.36697712891447626),
    RGB(0.09012271463586771, 0.4208351414374547, 0.29521700825926067),
    RGB(0.3401285979634336, 0.38838781488876783, 0.3195019970477602),
    RGB(0.2736945688594092, 0.4020403104485777, 0.4320134943181818),
    RGB(0.23003413138669573, 0.43081734000646615, 0.3227037443137989),
    RGB(0.31891761272031494, 0.4583815295953567, 0.5173135327498829),
    RGB(0.37497359398220304, 0.4591177501676393, 0.43170374930527866),
    RGB(0.46920766223359683, 0.4802076495768275, 0.3439224484825843),
    RGB(0.2616849763327821, 0.5273956217926892, 0.4026454804278036),
    RGB(0.35110190042329337, 0.5111817903808454, 0.6305902776405444),
    RGB(0.4186029623518417, 0.5135737668866703, 0.5262808806606872),
    RGB(0.5302048082346306, 0.5549230037094885, 0.4362107968350037),
    RGB(0.3849559252307765, 0.5942567602462403, 0.45880717030242935),
    RGB(0.4552433888133599, 0.5730863361939958, 0.614407956854176),
    RGB(0.42157203745237, 0.5883911735956997, 0.7246914844338832),
    RGB(0.5164704242794979, 0.5915166621481568, 0.5358315598897025),
    RGB(0.6633211303069481, 0.5963869875510885, 0.362493809429477),
    RGB(0.5170861076436062, 0.6363982661617588, 0.6886239448615252),
    RGB(0.5805242566658575, 0.6465162349622032, 0.598487269501932),
    RGB(0.6347937324837886, 0.6464270524274079, 0.4923752791806728),
    RGB(0.5559319690265486, 0.6996448114761815, 0.7876205046130672),
    RGB(0.6182146594909023, 0.6969109025039394, 0.6928766480119004),
    RGB(0.7068047231191804, 0.7155572442273129, 0.5948514577050396),
    RGB(0.7863434026348292, 0.714627450854261, 0.45545081888122685),
    RGB(0.7063674927635895, 0.7679233785692912, 0.7461676606540679),
    RGB(0.6509400680420826, 0.7852137890790488, 0.8515740841951183),
    RGB(0.8480242294444568, 0.8186986250083198, 0.6339557842278082),
    RGB(0.7806382366538815, 0.8810799476771491, 0.904943304680926)], "general", "color palette from artist Paul Cezanne Mont Sainte-Victoire 1887")

loadcolorscheme(:cherry, [
    RGB(0.215686, 0.215686, 0.215686),
    RGB(0.563899, 0.155919, 0.156577),
    RGB(0.747389, 0.178584, 0.180272),
    RGB(0.836168, 0.264453, 0.26819),
    RGB(0.880144, 0.397868, 0.404399),
    RGB(0.911942, 0.567676, 0.576412),
    RGB(0.949724, 0.768164, 0.776002),
    RGB(1.0, 1.0, 1.0)], "general")

loadcolorscheme(:cmyk, [
    RGB(0.300725, 0.680491, 0.901701),
    RGB(0.386403, 0.743518, 0.934237),
    RGB(0.496414, 0.645794, 0.86504),
    RGB(0.604318, 0.51771, 0.780231),
    RGB(0.699224, 0.432157, 0.70669),
    RGB(0.778582, 0.417821, 0.644854),
    RGB(0.843122, 0.472052, 0.589251),
    RGB(0.893588, 0.572795, 0.538951),
    RGB(0.928891, 0.68909, 0.500098),
    RGB(0.945344, 0.789625, 0.482689),
    RGB(0.936608, 0.84884, 0.493779),
    RGB(0.894001, 0.850082, 0.529271),
    RGB(0.806801, 0.785304, 0.566474),
    RGB(0.662204, 0.650797, 0.559579),
    RGB(0.444557, 0.438462, 0.440244),
    RGB(0.133532, 0.122103, 0.125444)], "general", "cyan to magenta to yellow to black (K)")

loadcolorscheme(:coffee, [
    RGB(0.406332, 0.330678, 0.278141),
    RGB(0.616382, 0.502629, 0.380121),
    RGB(0.723168, 0.559286, 0.323473),
    RGB(0.813935, 0.656425, 0.370324),
    RGB(0.91191, 0.830616, 0.618036),
    RGB(0.976303, 0.999222, 0.999207)], "general")

loadcolorscheme(:cubehelix, [
    RGB(0.0,0.0,0.0),
    RGB(0.00802,0.00136,0.00662),
    RGB(0.01578,0.00279,0.01353),
    RGB(0.02327,0.00432,0.02072),
    RGB(0.03046,0.00594,0.02817),
    RGB(0.03737,0.00767,0.03587),
    RGB(0.04396,0.00951,0.04379),
    RGB(0.05023,0.01147,0.05192),
    RGB(0.05618,0.01357,0.06024),
    RGB(0.06179,0.0158,0.06873),
    RGB(0.06706,0.01818,0.07738),
    RGB(0.07198,0.0207,0.08616),
    RGB(0.07655,0.02339,0.09505),
    RGB(0.08077,0.02623,0.10404),
    RGB(0.08462,0.02925,0.11311),
    RGB(0.08812,0.03243,0.12223),
    RGB(0.09125,0.0358,0.13139),
    RGB(0.09402,0.03934,0.14056),
    RGB(0.09644,0.04306,0.14973),
    RGB(0.0985,0.04697,0.15887),
    RGB(0.1002,0.05106,0.16797),
    RGB(0.10156,0.05535,0.17701),
    RGB(0.10257,0.05982,0.18596),
    RGB(0.10324,0.06448,0.19481),
    RGB(0.10359,0.06933,0.20354),
    RGB(0.10361,0.07436,0.21212),
    RGB(0.10332,0.07959,0.22055),
    RGB(0.10273,0.085,0.22881),
    RGB(0.10184,0.09059,0.23687),
    RGB(0.10067,0.09636,0.24472),
    RGB(0.09924,0.10231,0.25234),
    RGB(0.09755,0.10844,0.25972),
    RGB(0.09561,0.11473,0.26685),
    RGB(0.09345,0.12118,0.2737),
    RGB(0.09108,0.1278,0.28027),
    RGB(0.08851,0.13457,0.28655),
    RGB(0.08576,0.14149,0.29251),
    RGB(0.08284,0.14855,0.29815),
    RGB(0.07978,0.15574,0.30347),
    RGB(0.07659,0.16306,0.30844),
    RGB(0.07329,0.1705,0.31306),
    RGB(0.06989,0.17806,0.31732),
    RGB(0.06642,0.18572,0.32122),
    RGB(0.06289,0.19347,0.32475),
    RGB(0.05933,0.20132,0.3279),
    RGB(0.05575,0.20924,0.33067),
    RGB(0.05217,0.21723,0.33306),
    RGB(0.04861,0.22528,0.33506),
    RGB(0.0451,0.23338,0.33667),
    RGB(0.04164,0.24152,0.3379),
    RGB(0.03826,0.24969,0.33873),
    RGB(0.03499,0.25788,0.33918),
    RGB(0.03183,0.26608,0.33924),
    RGB(0.02881,0.27428,0.33892),
    RGB(0.02594,0.28248,0.33823),
    RGB(0.02325,0.29065,0.33716),
    RGB(0.02076,0.29879,0.33572),
    RGB(0.01847,0.30689,0.33393),
    RGB(0.01641,0.31495,0.33178),
    RGB(0.0146,0.32294,0.32929),
    RGB(0.01305,0.33086,0.32647),
    RGB(0.01177,0.33869,0.32332),
    RGB(0.01079,0.34644,0.31986),
    RGB(0.01012,0.35409,0.3161),
    RGB(0.00977,0.36163,0.31205),
    RGB(0.00975,0.36904,0.30772),
    RGB(0.01008,0.37633,0.30314),
    RGB(0.01078,0.38349,0.2983),
    RGB(0.01184,0.39049,0.29324),
    RGB(0.01329,0.39735,0.28796),
    RGB(0.01513,0.40404,0.28248),
    RGB(0.01738,0.41056,0.27682),
    RGB(0.02003,0.4169,0.271),
    RGB(0.0231,0.42306,0.26503),
    RGB(0.0266,0.42903,0.25893),
    RGB(0.03052,0.43481,0.25272),
    RGB(0.03488,0.44038,0.24642),
    RGB(0.03968,0.44574,0.24005),
    RGB(0.04491,0.45089,0.23362),
    RGB(0.0506,0.45582,0.22717),
    RGB(0.05672,0.46052,0.2207),
    RGB(0.06329,0.46501,0.21424),
    RGB(0.0703,0.46926,0.20781),
    RGB(0.07776,0.47328,0.20143),
    RGB(0.08565,0.47707,0.19511),
    RGB(0.09398,0.48062,0.18889),
    RGB(0.10274,0.48394,0.18277),
    RGB(0.11193,0.48701,0.17678),
    RGB(0.12153,0.48985,0.17094),
    RGB(0.13155,0.49245,0.16527),
    RGB(0.14197,0.4948,0.15978),
    RGB(0.15279,0.49693,0.1545),
    RGB(0.16399,0.49881,0.14944),
    RGB(0.17556,0.50047,0.14463),
    RGB(0.1875,0.50189,0.14008),
    RGB(0.19979,0.50309,0.1358),
    RGB(0.21242,0.50406,0.13182),
    RGB(0.22537,0.50481,0.12815),
    RGB(0.23864,0.50534,0.1248),
    RGB(0.25219,0.50566,0.1218),
    RGB(0.26603,0.50578,0.11915),
    RGB(0.28013,0.50569,0.11687),
    RGB(0.29448,0.50541,0.11497),
    RGB(0.30905,0.50495,0.11347),
    RGB(0.32384,0.5043,0.11238),
    RGB(0.33881,0.50348,0.1117),
    RGB(0.35396,0.50249,0.11146),
    RGB(0.36927,0.50135,0.11164),
    RGB(0.38471,0.50005,0.11228),
    RGB(0.40027,0.49862,0.11337),
    RGB(0.41592,0.49705,0.11491),
    RGB(0.43165,0.49536,0.11692),
    RGB(0.44743,0.49355,0.11941),
    RGB(0.46324,0.49165,0.12237),
    RGB(0.47907,0.48964,0.1258),
    RGB(0.49489,0.48756,0.12971),
    RGB(0.51068,0.4854,0.13411),
    RGB(0.52642,0.48318,0.13899),
    RGB(0.54209,0.4809,0.14434),
    RGB(0.55767,0.47859,0.15018),
    RGB(0.57314,0.47624,0.15649),
    RGB(0.58848,0.47387,0.16328),
    RGB(0.60367,0.47149,0.17054),
    RGB(0.61868,0.46912,0.17826),
    RGB(0.6335,0.46676,0.18643),
    RGB(0.64812,0.46442,0.19506),
    RGB(0.6625,0.46212,0.20413),
    RGB(0.67664,0.45986,0.21363),
    RGB(0.69051,0.45766,0.22356),
    RGB(0.7041,0.45552,0.2339),
    RGB(0.7174,0.45346,0.24464),
    RGB(0.73037,0.45149,0.25578),
    RGB(0.74302,0.44962,0.26729),
    RGB(0.75532,0.44785,0.27916),
    RGB(0.76727,0.4462,0.29139),
    RGB(0.77884,0.44468,0.30395),
    RGB(0.79002,0.4433,0.31683),
    RGB(0.80081,0.44206,0.33002),
    RGB(0.81118,0.44097,0.34349),
    RGB(0.82114,0.44005,0.35723),
    RGB(0.83067,0.4393,0.37123),
    RGB(0.83976,0.43873,0.38546),
    RGB(0.84841,0.43834,0.3999),
    RGB(0.8566,0.43814,0.41454),
    RGB(0.86434,0.43814,0.42936),
    RGB(0.87161,0.43835,0.44433),
    RGB(0.87841,0.43877,0.45945),
    RGB(0.88474,0.43941,0.47468),
    RGB(0.89059,0.44027,0.49001),
    RGB(0.89597,0.44136,0.50541),
    RGB(0.90088,0.44267,0.52087),
    RGB(0.9053,0.44422,0.53637),
    RGB(0.90926,0.44601,0.55188),
    RGB(0.91274,0.44803,0.56739),
    RGB(0.91575,0.4503,0.58287),
    RGB(0.91829,0.45281,0.5983),
    RGB(0.92038,0.45557,0.61367),
    RGB(0.92201,0.45857,0.62895),
    RGB(0.92319,0.46182,0.64412),
    RGB(0.92393,0.46531,0.65916),
    RGB(0.92424,0.46905,0.67406),
    RGB(0.92413,0.47303,0.6888),
    RGB(0.9236,0.47725,0.70335),
    RGB(0.92268,0.48171,0.7177),
    RGB(0.92136,0.48641,0.73183),
    RGB(0.91967,0.49135,0.74573),
    RGB(0.91761,0.49651,0.75937),
    RGB(0.9152,0.5019,0.77275),
    RGB(0.91246,0.50751,0.78584),
    RGB(0.90939,0.51334,0.79863),
    RGB(0.90602,0.51938,0.81111),
    RGB(0.90236,0.52562,0.82326),
    RGB(0.89843,0.53207,0.83508),
    RGB(0.89424,0.53871,0.84654),
    RGB(0.88981,0.54553,0.85765),
    RGB(0.88517,0.55253,0.86838),
    RGB(0.88032,0.5597,0.87873),
    RGB(0.8753,0.56704,0.88869),
    RGB(0.87011,0.57453,0.89825),
    RGB(0.86477,0.58217,0.90741),
    RGB(0.85932,0.58994,0.91615),
    RGB(0.85376,0.59785,0.92448),
    RGB(0.84811,0.60587,0.9324),
    RGB(0.8424,0.61401,0.93988),
    RGB(0.83665,0.62224,0.94695),
    RGB(0.83087,0.63056,0.95358),
    RGB(0.82508,0.63897,0.95979),
    RGB(0.81932,0.64744,0.96558),
    RGB(0.81358,0.65597,0.97093),
    RGB(0.80791,0.66456,0.97587),
    RGB(0.8023,0.67318,0.98038),
    RGB(0.79679,0.68184,0.98448),
    RGB(0.79139,0.69051,0.98817),
    RGB(0.78612,0.69919,0.99146),
    RGB(0.781,0.70786,0.99435),
    RGB(0.77604,0.71653,0.99684),
    RGB(0.77127,0.72517,0.99896),
    RGB(0.76669,0.73378,1.0),
    RGB(0.76233,0.74235,1.0),
    RGB(0.7582,0.75087,1.0),
    RGB(0.75431,0.75932,1.0),
    RGB(0.75069,0.76771,1.0),
    RGB(0.74733,0.77601,1.0),
    RGB(0.74427,0.78422,1.0),
    RGB(0.7415,0.79234,1.0),
    RGB(0.73903,0.80035,1.0),
    RGB(0.73689,0.80824,1.0),
    RGB(0.73508,0.81601,1.0),
    RGB(0.7336,0.82365,0.99879),
    RGB(0.73247,0.83116,0.99707),
    RGB(0.73169,0.83852,0.99516),
    RGB(0.73127,0.84573,0.99309),
    RGB(0.73122,0.85278,0.99086),
    RGB(0.73153,0.85968,0.9885),
    RGB(0.73222,0.8664,0.98603),
    RGB(0.73327,0.87296,0.98347),
    RGB(0.73471,0.87933,0.98083),
    RGB(0.73652,0.88553,0.97813),
    RGB(0.7387,0.89155,0.9754),
    RGB(0.74126,0.89738,0.97265),
    RGB(0.74419,0.90302,0.96991),
    RGB(0.74749,0.90847,0.96718),
    RGB(0.75115,0.91373,0.9645),
    RGB(0.75518,0.9188,0.96188),
    RGB(0.75955,0.92367,0.95934),
    RGB(0.76427,0.92835,0.95689),
    RGB(0.76933,0.93284,0.95457),
    RGB(0.77471,0.93715,0.95237),
    RGB(0.78042,0.94126,0.95033),
    RGB(0.78643,0.94518,0.94846),
    RGB(0.79274,0.94892,0.94677),
    RGB(0.79933,0.95249,0.94528),
    RGB(0.80619,0.95587,0.94402),
    RGB(0.81332,0.95908,0.94298),
    RGB(0.82068,0.96213,0.9422),
    RGB(0.82827,0.96501,0.94167),
    RGB(0.83608,0.96773,0.94142),
    RGB(0.84408,0.9703,0.94145),
    RGB(0.85225,0.97273,0.94179),
    RGB(0.86059,0.97502,0.94243),
    RGB(0.86907,0.97718,0.94339),
    RGB(0.87768,0.97922,0.94468),
    RGB(0.88639,0.98115,0.94631),
    RGB(0.89518,0.98296,0.94828),
    RGB(0.90404,0.98468,0.9506),
    RGB(0.91295,0.98632,0.95327),
    RGB(0.92188,0.98787,0.9563),
    RGB(0.93081,0.98936,0.9597),
    RGB(0.93973,0.99078,0.96346),
    RGB(0.94862,0.99216,0.96759),
    RGB(0.95745,0.9935,0.97209),
    RGB(0.96619,0.99481,0.97695),
    RGB(0.97484,0.99611,0.98217),
    RGB(0.98338,0.9974,0.98776),
    RGB(0.99177,0.99869,0.9937),
    RGB(1.0,1.0,1.0)
], "general", "Unlike most other color schemes, cubehelix was designed by Dave Green to be monotonically increasing in terms of perceived brightness. Also, when printed on a black and white postscript printer, the scheme results in a greyscale with monotonically increasing brightness. This color scheme is named cubehelix because the r,g,b values produced can be visualised as a squashed helix around the diagonal in the r,g,b color cube. https://www.mrao.cam.ac.uk/~dag/CUBEHELIX/")

loadcolorscheme(:darkrainbow, [
    RGB(0.237736, 0.340215, 0.575113),
    RGB(0.253651, 0.344893, 0.558151),
    RGB(0.264425, 0.423024, 0.3849),
    RGB(0.291469, 0.47717, 0.271411),
    RGB(0.416394, 0.555345, 0.24182),
    RGB(0.624866, 0.673302, 0.264296),
    RGB(0.813033, 0.766292, 0.303458),
    RGB(0.877875, 0.731045, 0.326896),
    RGB(0.812807, 0.518694, 0.303459),
    RGB(0.72987, 0.239399, 0.230961),
    RGB(0.72987, 0.239399, 0.230961)], "general")

loadcolorscheme(:darkterrain, [
    RGB(0.0, 0.0675975, 0.467384),
    RGB(0.161984, 0.248617, 0.483617),
    RGB(0.29126, 0.390772, 0.493561),
    RGB(0.356813, 0.44685, 0.477766),
    RGB(0.410156, 0.479749, 0.448332),
    RGB(0.449097, 0.487625, 0.405831),
    RGB(0.466483, 0.463526, 0.350901),
    RGB(0.468481, 0.417383, 0.288117),
    RGB(0.469845, 0.374163, 0.235271),
    RGB(0.483797, 0.359707, 0.217583),
    RGB(0.526719, 0.397452, 0.263694),
    RGB(0.633185, 0.525937, 0.420695),
    RGB(0.812397, 0.757547, 0.703722),
    RGB(1.0, 1.0, 1.0)], "general")

loadcolorscheme(:deepsea, [
    RGB(0.16791, 0.0, 0.301671),
    RGB(0.305814, 0.0607622, 0.601948),
    RGB(0.235431, 0.32765, 0.833291),
    RGB(0.282325, 0.661868, 0.973082),
    RGB(0.772061, 0.92462, 0.998703)], "general", "dark blue fading to light blue")

loadcolorscheme(:fall, [
    RGB(0.259739, 0.395895, 0.39585),
    RGB(0.355047, 0.395763, 0.286168),
    RGB(0.442859, 0.324335, 0.236759),
    RGB(0.58078, 0.330282, 0.220121),
    RGB(0.765749, 0.461911, 0.220057),
    RGB(0.934051, 0.667165, 0.231683),
    RGB(0.961303, 0.793622, 0.261418)], "general", "autumnal")

loadcolorscheme(:fruitpunch, [
    RGB(1.0, 0.499474, 0.0),
    RGB(0.989146, 0.606517, 0.00227297),
    RGB(0.89853, 0.670191, 0.038923),
    RGB(0.80904, 0.658225, 0.163438),
    RGB(0.769483, 0.571276, 0.370227),
    RGB(0.79659, 0.442924, 0.594615),
    RGB(0.875012, 0.339677, 0.712848),
    RGB(0.957321, 0.360967, 0.542092)], "general")

loadcolorscheme(:fuchsia, [
    RGB(0.1, 0.1, 0.1),
    RGB(0.356675, 0.216956, 0.334404),
    RGB(0.587, 0.343432, 0.54366),
    RGB(0.783404, 0.563621, 0.743292),
    RGB(0.923313, 0.823714, 0.906672),
    RGB(0.969142, 0.931897, 0.965022)], "general")

loadcolorscheme(:grays1, [
    RGB(0.1, 0.1, 0.1),
    RGB(0.225356, 0.246889, 0.268731),
    RGB(0.333565, 0.367922, 0.391532),
    RGB(0.51593, 0.541278, 0.547958),
    RGB(0.753644, 0.757794, 0.737969),
    RGB(0.917794, 0.920966, 0.881936)], "general")

loadcolorscheme(:grayyellow, [
    RGB(0.180514, 0.213809, 0.295109),
    RGB(0.261894, 0.294381, 0.38358),
    RGB(0.367557, 0.398803, 0.488766),
    RGB(0.493342, 0.521493, 0.603431),
    RGB(0.627984, 0.649468, 0.711806),
    RGB(0.755671, 0.764793, 0.791993),
    RGB(0.859884, 0.847747, 0.817471),
    RGB(0.927424, 0.879934, 0.757948),
    RGB(0.951528, 0.846543, 0.579805),
    RGB(0.932982, 0.73698, 0.246387)], "general")

loadcolorscheme(:greenbrownterrain, [
    RGB(0.0, 0.0, 0.0),
    RGB(0.113011, 0.15859, 0.177864),
    RGB(0.243544, 0.319899, 0.300598),
    RGB(0.374957, 0.459638, 0.373664),
    RGB(0.494897, 0.563845, 0.405964),
    RGB(0.594858, 0.627401, 0.408311),
    RGB(0.670023, 0.652618, 0.39249),
    RGB(0.719352, 0.647968, 0.370849),
    RGB(0.745885, 0.626946, 0.356408),
    RGB(0.757222, 0.607129, 0.363424),
    RGB(0.766146, 0.609435, 0.408375),
    RGB(0.791364, 0.657634, 0.511331),
    RGB(0.85831, 0.77812, 0.697653),
    RGB(1.0, 1.0, 1.0)], "general")

loadcolorscheme(:greenpink, [
    RGB(0.0, 0.24239, 0.0232242),
    RGB(0.000161089, 0.454438, 0.0436387),
    RGB(0.0079099, 0.681698, 0.0703023),
    RGB(0.0737601, 0.865914, 0.132145),
    RGB(0.247568, 0.946477, 0.271094),
    RGB(0.466763, 0.972142, 0.469781),
    RGB(0.693792, 0.977211, 0.692552),
    RGB(0.876702, 0.949231, 0.875876),
    RGB(0.970858, 0.851801, 0.969678),
    RGB(0.996234, 0.67739, 0.993242),
    RGB(0.994265, 0.472067, 0.989473),
    RGB(0.966567, 0.301923, 0.962316),
    RGB(0.874018, 0.204385, 0.872946),
    RGB(0.682624, 0.146568, 0.682702),
    RGB(0.455855, 0.0967564, 0.454813),
    RGB(0.244327, 0.0512856, 0.24126)], "general")

loadcolorscheme(:hokusai, [
    RGB(0.08544447666417647, 0.08902665213502144, 0.15332964308182284),
    RGB(0.08735333692735853, 0.11887849681980253, 0.2245133264541828),
    RGB(0.1112499123425623, 0.1548582529847975, 0.26017051593933216),
    RGB(0.12487343986255078, 0.19141895226850417, 0.30135480901481065),
    RGB(0.14171281527190893, 0.2423162759310023, 0.3453436138360526),
    RGB(0.25922168619172214, 0.2543680497740247, 0.1454935032112274),
    RGB(0.15686607347532716, 0.28899421177478996, 0.39631133793218587),
    RGB(0.2363338813365753, 0.32182699215296195, 0.36183309962606836),
    RGB(0.18482122134362958, 0.33145931325330297, 0.4383020194959913),
    RGB(0.3312189063433393, 0.3241429118130227, 0.23467485252389486),
    RGB(0.22202972664484352, 0.3807905706532755, 0.47982599546983945),
    RGB(0.3082226663925913, 0.4190151949541284, 0.4565791608966592),
    RGB(0.4167268747314138, 0.41538897990975504, 0.3315330226686721),
    RGB(0.36086778389090163, 0.5022365160654179, 0.5107717711786017),
    RGB(0.5107678440737127, 0.5098865774189312, 0.43096666346081675),
    RGB(0.4178792132396287, 0.5679397081219008, 0.5247375213840694),
    RGB(0.6075662006578948, 0.5331537828947369, 0.34789843750000005),
    RGB(0.4362963558265396, 0.6095564328053198, 0.5766399619960944),
    RGB(0.6054093758458783, 0.6086856904709851, 0.5240535271826264),
    RGB(0.4733262248995667, 0.6467575909268921, 0.6079213027590737),
    RGB(0.7462330577040964, 0.6157514615336075, 0.3838256853544642),
    RGB(0.5269858610642322, 0.6824740695330109, 0.6354083783087361),
    RGB(0.7045971276838914, 0.6736042316737542, 0.5637327616161337),
    RGB(0.7965068096381885, 0.6635059591310094, 0.4416234809182799),
    RGB(0.6373411771442556, 0.7180070682936319, 0.6556317890446548),
    RGB(0.7395867252762949, 0.7092235168105087, 0.5965619502102887),
    RGB(0.7622383245824175, 0.7364337208296908, 0.6238943851398521),
    RGB(0.7878104545824131, 0.7649941178363802, 0.6490985340750478),
    RGB(0.7427913557778212, 0.7943431026299625, 0.7153181535819979),
    RGB(0.8224642804446194, 0.8033270521837498, 0.6761185569545544),
    RGB(0.8536700191827608, 0.8375037571025991, 0.7087303099107102),
    RGB(0.8859117460189212, 0.8711084173742508, 0.7462206147534963)], "general",
    "from one of the many copies of artist Hokusai's The Great Wave off Kanagawa (神奈川沖浪裏 Kanagawa-oki namiura, \"In the well of a wave off Kanagawa\"), also known as The Great Wave or simply The Wave, a woodblock print published sometime between 1830 and 1833. It depicts an enormous wave threatening boats off the coast of the prefecture of Kanagawa.")

loadcolorscheme(:holbein, [
    RGB(0.042662393203256474, 0.02802781621742958, 0.09345865243295302),
    RGB(0.048739302593371066, 0.054687733474372606, 0.12868916747396916),
    RGB(0.09216232278380455, 0.05061246854724288, 0.10938267844474661),
    RGB(0.09734481834394257, 0.09215702545289688, 0.1597421763684055),
    RGB(0.044130384392163526, 0.13365558685490314, 0.05714657295736369),
    RGB(0.1594560471823359, 0.10450368682863677, 0.13658728615328797),
    RGB(0.08886225606972697, 0.19219059816410375, 0.05793056085537265),
    RGB(0.233454426308657, 0.15031675407966683, 0.14128085572664342),
    RGB(0.1942570316037161, 0.18552187679578938, 0.22835444610237524),
    RGB(0.3774453190586125, 0.10756020210066396, 0.16476151394241775),
    RGB(0.13425310656865483, 0.24943732530813123, 0.04262637573605111),
    RGB(0.3102966317361909, 0.2280519647410573, 0.179985231614082),
    RGB(0.17787293627524134, 0.3070956479256294, 0.049662789336366066),
    RGB(0.5028148136936065, 0.1713443641018544, 0.23327977961527818),
    RGB(0.2972067311552241, 0.2863051954853828, 0.312155214428008),
    RGB(0.417232227334902, 0.3156076029603538, 0.21190840098725708),
    RGB(0.22443005792612783, 0.3714088110111059, 0.0615584662168757),
    RGB(0.39885129516333556, 0.38488450701226434, 0.396332334665285),
    RGB(0.2817958430874348, 0.44030931009160923, 0.09138715813063834),
    RGB(0.6888742814355752, 0.31467484420314873, 0.42894870572089494),
    RGB(0.25923014996239185, 0.4700067870910116, 0.5633594043813464),
    RGB(0.5545343137254901, 0.45300116170499205, 0.3005763230679869),
    RGB(0.4882884290320054, 0.48853312796950865, 0.5006705460632799),
    RGB(0.6277637275551018, 0.5341593268657987, 0.47335339811505406),
    RGB(0.6024822602296472, 0.615540183398135, 0.6211341562620204),
    RGB(0.7506640557436189, 0.5930157744125423, 0.5804383848928862),
    RGB(0.7425832389565632, 0.6321002714799723, 0.37999169574735564),
    RGB(0.7178898842190311, 0.7277756181590902, 0.7154923898848542),
    RGB(0.8483361148197597, 0.7598727469959947, 0.6140990070093458),
    RGB(0.9426792964971233, 0.7107300656152945, 0.8020825378035741),
    RGB(0.8141683874150125, 0.8257315671728905, 0.8082325618971152),
    RGB(0.9332364663223651, 0.9402859332477733, 0.938574315391514)], "general",
    "color palette from Hans Holbein the Younger's The Ambassadors")

loadcolorscheme(:island, [
    RGB(0.76321, 0.364813, 0.209552),
    RGB(0.53493, 0.600597, 0.574225),
    RGB(0.529615, 0.738927, 0.757626),
    RGB(0.629644, 0.832021, 0.85439),
    RGB(0.754036, 0.896586, 0.894485),
    RGB(0.848762, 0.931545, 0.877407),
    RGB(0.881935, 0.931717, 0.797277),
    RGB(0.843881, 0.897455, 0.65882),
    RGB(0.752088, 0.840237, 0.484239),
    RGB(0.661036, 0.784207, 0.310994)], "general")

loadcolorscheme(:jet, [
    RGB(0.0,0.0,0.498),
    RGB(0.0,0.0,1.0),
    RGB(0.0,0.498,1.0),
    RGB(0.0,1.0,1.0),
    RGB(0.498,1.0,0.498),
    RGB(1.0,1.0,0.0),
    RGB(1.0,0.498,0.0),
    RGB(1.0,0.0,0.0),
    RGB(0.498,0.0,0.0)], "general")

loadcolorscheme(:klimt, [
    RGB(0.12642371160582694, 0.10155590851079735, 0.06521509280816797),
    RGB(0.17341530343637526, 0.1580490510876886, 0.12789282588831835),
    RGB(0.1056201722585537, 0.16790053593853665, 0.4987027295990902),
    RGB(0.2747303954566959, 0.1981650932198556, 0.05313506341181484),
    RGB(0.24069163258745707, 0.2625538321712157, 0.2036282655560269),
    RGB(0.3403918457551433, 0.25326675968726237, 0.1031260022562681),
    RGB(0.39485959942719373, 0.288251902004456, 0.07276833322232437),
    RGB(0.5573552634358627, 0.16698222987437328, 0.3685287536617655),
    RGB(0.41148312703099454, 0.3131397266819744, 0.15041865607635727),
    RGB(0.4689053055974436, 0.34388561613022656, 0.09766112191794975),
    RGB(0.48156761754360256, 0.36744312006635393, 0.17529879436657353),
    RGB(0.328851092202626, 0.4460810797888617, 0.4424772414320685),
    RGB(0.5549338411283542, 0.4083078444696042, 0.11649851699759549),
    RGB(0.5421219104682069, 0.41542303304695216, 0.20370223285355382),
    RGB(0.8315269873798431, 0.29168586350769593, 0.07490453794892965),
    RGB(0.6006855101386596, 0.4632735301710637, 0.23762817381375148),
    RGB(0.6474334125639397, 0.479605710069336, 0.15277766933183418),
    RGB(0.6017428586787187, 0.4970994277611892, 0.3736984914072896),
    RGB(0.6839623117584637, 0.5218890097596884, 0.24808057772377867),
    RGB(0.6955492855986042, 0.5791983500753971, 0.46232155275893605),
    RGB(0.5026239601347205, 0.6487882257265982, 0.5569860119379672),
    RGB(0.7600131657182279, 0.5837154672426399, 0.29378257820440806),
    RGB(0.8108150109476894, 0.6032291200635099, 0.1609542277471953),
    RGB(0.7512199469806996, 0.6637227049849953, 0.5433727617445188),
    RGB(0.8577602019020023, 0.6776515682961584, 0.345391726601763),
    RGB(0.9070877810014496, 0.6930846540550745, 0.23105285631410982),
    RGB(0.8145481378080879, 0.7299779681968399, 0.6071367380317696),
    RGB(0.9060906143611074, 0.7489363908921588, 0.4481677803447054),
    RGB(0.9627465753814504, 0.7548465518900728, 0.30782980160652046),
    RGB(0.8819382550756218, 0.7943603725039735, 0.6753772766584465),
    RGB(0.9857574000407269, 0.8049734765075166, 0.3884906042012011),
    RGB(0.9718323944040534, 0.837311923157504, 0.5147269428404451)], "general",
    "color palette from artist Gustav Klimt's The Kiss")

loadcolorscheme(:lake, [
    RGB(0.293416, 0.0574044, 0.529412),
    RGB(0.563821, 0.527565, 0.909499),
    RGB(0.762631, 0.846998, 0.914031),
    RGB(0.941176, 0.906538, 0.834043)], "general")

loadcolorscheme(:leonardo, [
    RGB(0.05482025926320272, 0.016508952654741622, 0.019315160361063788),
    RGB(0.07508160782698388, 0.034110215845969745, 0.039708343938094984),
    RGB(0.10884977211887092, 0.033667530751245296, 0.026120424375656533),
    RGB(0.10025110094110237, 0.05342427394738222, 0.04975936729231899),
    RGB(0.11004568002009293, 0.06764950003139521, 0.07202128202310687),
    RGB(0.1520114897984492, 0.06721701384356317, 0.04758612657624729),
    RGB(0.16121466572057147, 0.10737190368841328, 0.07491505937992286),
    RGB(0.2272468746270438, 0.09450818887496519, 0.053122482545649836),
    RGB(0.24275776450376843, 0.14465569383748178, 0.09254885719488251),
    RGB(0.19832488479851235, 0.16827798680930195, 0.08146721610879516),
    RGB(0.29030547394827216, 0.1566704731433784, 0.06955958896758961),
    RGB(0.3486958875330028, 0.14413808439049522, 0.06517845643634491),
    RGB(0.2631529920611145, 0.22896210929698424, 0.1119250237167965),
    RGB(0.35775151767110114, 0.23955578484799914, 0.08566681526152695),
    RGB(0.42895506355552904, 0.19814294026377038, 0.07315576139822164),
    RGB(0.3359280058835734, 0.30177882691623686, 0.14764230985832),
    RGB(0.5168174153887967, 0.2588008525490645, 0.07751817567374263),
    RGB(0.44056726473192726, 0.3387984774995975, 0.10490250831857457),
    RGB(0.4048595970607235, 0.40823989479512734, 0.2096109034699151),
    RGB(0.619694338941659, 0.33787470822764315, 0.0871136546089913),
    RGB(0.5108290351302369, 0.41506713362977327, 0.13590312315603137),
    RGB(0.5272516131642648, 0.4706039514608196, 0.21392546020040532),
    RGB(0.5942622209175139, 0.47822315473126586, 0.14678522310513448),
    RGB(0.735266714513005, 0.4318652289706696, 0.1049661472744881),
    RGB(0.6201870982552801, 0.5227924127640037, 0.2167074150596878),
    RGB(0.6929049533440698, 0.5663098519207086, 0.18551505068207655),
    RGB(0.6814114992549445, 0.5814898147520997, 0.27039081549715527),
    RGB(0.8500397772474145, 0.5401215248181611, 0.1362117676724628),
    RGB(0.7575520588269891, 0.6334254649343621, 0.25145144950124687),
    RGB(0.8164723313500291, 0.6970150665478066, 0.32242062463720045),
    RGB(0.9330273170314637, 0.6651641943114455, 0.19865164906805746),
    RGB(0.9724409077178674, 0.7907008712807734, 0.2851364857083522)], "general",
    "color palette from artist Leonardo Da Vinci's Mona Lisa")

loadcolorscheme(:lighttemperaturemap, [
    RGB(0.165698, 0.282261, 0.936187),
    RGB(0.358007, 0.574105, 0.948836),
    RGB(0.546319, 0.783703, 0.966583),
    RGB(0.713848, 0.924666, 0.981842),
    RGB(0.866087, 0.99559, 0.992172),
    RGB(0.997223, 0.994827, 0.825925),
    RGB(0.981765, 0.945724, 0.654917),
    RGB(0.943297, 0.818753, 0.479667),
    RGB(0.894942, 0.622553, 0.310567),
    RGB(0.845274, 0.369528, 0.19115)], "general")

loadcolorscheme(:lightterrain, [
    RGB(0.54938, 0.772213, 0.848103),
    RGB(0.522608, 0.678921, 0.681891),
    RGB(0.534412, 0.632018, 0.572058),
    RGB(0.575277, 0.626692, 0.516273),
    RGB(0.633373, 0.652733, 0.505381),
    RGB(0.697565, 0.698101, 0.528031),
    RGB(0.759012, 0.751306, 0.57361),
    RGB(0.811726, 0.802843, 0.633639),
    RGB(0.852431, 0.845908, 0.701864),
    RGB(0.880069, 0.876629, 0.773246),
    RGB(0.895256, 0.894033, 0.842152),
    RGB(0.9, 0.9, 0.9)], "general")

loadcolorscheme(:mint, [
    RGB(0.465278, 0.97641, 0.637812),
    RGB(0.64413, 0.960182, 0.753403),
    RGB(0.780073, 0.918494, 0.82706),
    RGB(0.871422, 0.849165, 0.858016),
    RGB(0.916493, 0.750014, 0.845498),
    RGB(0.913603, 0.61886, 0.788739)], "general")

loadcolorscheme(:munch, [
    RGB(0.04370105415584468, 0.0797743106556198, 0.05326460581723035),
    RGB(0.10087973308344687, 0.13815762830286352, 0.10788206355321264),
    RGB(0.11998226317503255, 0.18561368842648857, 0.17444656396065567),
    RGB(0.18403206700902572, 0.1999222218324974, 0.15349233321610617),
    RGB(0.18872550758484852, 0.2539997469326301, 0.23716825253472776),
    RGB(0.2562632590403489, 0.24748428047869472, 0.17937711102341158),
    RGB(0.3041188913151755, 0.293442281539497, 0.21976472785198706),
    RGB(0.25452834608276004, 0.3268140090476007, 0.3089322061000445),
    RGB(0.3799746672093435, 0.3138318891071006, 0.20707188613343144),
    RGB(0.5278659405241642, 0.268360105309936, 0.13057271889015895),
    RGB(0.36084589623043173, 0.359842293230572, 0.2889380589152619),
    RGB(0.4480760579685158, 0.3654419838852657, 0.24369187163328915),
    RGB(0.76038072698486, 0.22403996210871788, 0.021587993638057856),
    RGB(0.6781234796639856, 0.3070021203619616, 0.1358136635638298),
    RGB(0.35195702780071625, 0.4345784885800602, 0.4075752914772542),
    RGB(0.45302715958321577, 0.4179807860969217, 0.32056363388733794),
    RGB(0.540615442032449, 0.40350206481244, 0.2546859542791382),
    RGB(0.7912692374717853, 0.2942453997221221, 0.06544836260693082),
    RGB(0.7165040163618426, 0.3905670552621543, 0.20373259714714467),
    RGB(0.52247765572825, 0.4771088039697663, 0.36610960720287955),
    RGB(0.6106768131533986, 0.46200432559225285, 0.2963682056759585),
    RGB(0.8150165432112134, 0.3725317672551659, 0.11246457926581419),
    RGB(0.7851206735225371, 0.4611132572437486, 0.2497651637651373),
    RGB(0.8333022145293948, 0.43871387491754615, 0.17691613350820415),
    RGB(0.5190092299151033, 0.5609798887176433, 0.4607245172511509),
    RGB(0.7056946798123541, 0.5045384631507928, 0.3090015269665058),
    RGB(0.6491388230714483, 0.5636001022887561, 0.39415207008933456),
    RGB(0.8487088084643593, 0.5440920173122827, 0.26945255135631263),
    RGB(0.7637453418111413, 0.5788684735471106, 0.3628719106147751),
    RGB(0.8702364497615486, 0.636771075632364, 0.3662237830013715),
    RGB(0.7761487609122928, 0.6702795423203283, 0.4581189486987741),
    RGB(0.9111398633608918, 0.773604674815757, 0.5772137218959261)], "general",
    "color palette from artist Edvard Munch's The Scream")

loadcolorscheme(:neon, [
    RGB(0.720287, 0.923781, 0.297597),
    RGB(0.741831, 0.759184, 0.2915),
    RGB(0.763375, 0.594586, 0.285403),
    RGB(0.784919, 0.429989, 0.279306),
    RGB(0.824907, 0.318689, 0.25001),
    RGB(0.858159, 0.314389, 0.27497),
    RGB(0.857705, 0.331729, 0.385417),
    RGB(0.840408, 0.290678, 0.51353),
    RGB(0.823111, 0.249627, 0.641643),
    RGB(0.805814, 0.208576, 0.769757)], "general")

loadcolorscheme(:pastel, [
    RGB(0.761959, 0.470832, 0.940597),
    RGB(0.809695, 0.585618, 0.953269),
    RGB(0.866514, 0.647659, 0.771795),
    RGB(0.909422, 0.699383, 0.647465),
    RGB(0.937061, 0.764486, 0.598975),
    RGB(0.954654, 0.842244, 0.587209),
    RGB(0.962197, 0.913524, 0.594117),
    RGB(0.948179, 0.953299, 0.634088),
    RGB(0.891128, 0.944422, 0.72627),
    RGB(0.771259, 0.887462, 0.856246),
    RGB(0.594516, 0.801371, 0.955499),
    RGB(0.431296, 0.709773, 0.927077)], "general")

loadcolorscheme(:pearl, [
    RGB(0.904982, 0.837568, 0.77612),
    RGB(0.928729, 0.910113, 0.867731),
    RGB(0.827846, 0.847694, 0.803109),
    RGB(0.705154, 0.745586, 0.717455),
    RGB(0.621107, 0.662018, 0.68002),
    RGB(0.605727, 0.62858, 0.713699),
    RGB(0.666448, 0.65519, 0.807337),
    RGB(0.791875, 0.729616, 0.920763),
    RGB(0.951461, 0.811566, 0.982544)], "general")

loadcolorscheme(:picasso, [
    RGB(0.12620164907144776, 0.06438983516873843, 0.02992720014504996),
    RGB(0.17082791099665337, 0.09623273959502825, 0.10760591014870545),
    RGB(0.22090871123522818, 0.10797456814387428, 0.04927915500799452),
    RGB(0.21443606485047814, 0.12209443814206533, 0.23205741030644608),
    RGB(0.24749418598954442, 0.1461705132785429, 0.11715449332907231),
    RGB(0.3052460487170861, 0.21319319514315668, 0.22207468819558812),
    RGB(0.3221349270280516, 0.18952651156178923, 0.4257302880970432),
    RGB(0.34322599852626945, 0.2241075407222085, 0.0682191994676853),
    RGB(0.2983748908321754, 0.22983596215407193, 0.710573624160747),
    RGB(0.38492363460299334, 0.30810662141580997, 0.2891718745423659),
    RGB(0.5154690397477357, 0.2598066357885096, 0.0913804509676161),
    RGB(0.6265407201460099, 0.3166491316460198, 0.4047876935026574),
    RGB(0.4669069530073177, 0.4256386807333295, 0.17062779222262467),
    RGB(0.47114296873791145, 0.41689334807820266, 0.42637549539085834),
    RGB(0.6967961972699439, 0.3447457390122092, 0.13584430842594167),
    RGB(0.8595173069470013, 0.3133759352140054, 0.046673911011227115),
    RGB(0.6372799092776805, 0.4899536520516032, 0.10221005446745841),
    RGB(0.8936334539365032, 0.40038632418053416, 0.10830001017451005),
    RGB(0.6011893756460063, 0.550452434163043, 0.5593264938339808),
    RGB(0.6213060413256103, 0.5748847875587834, 0.30441688151048457),
    RGB(0.4771377402326945, 0.6583197940699455, 0.3054610702157145),
    RGB(0.7490290644161852, 0.6207578397172274, 0.1507526690218718),
    RGB(0.5052034492655822, 0.7238673162202902, 0.48434549018877515),
    RGB(0.6205296317397206, 0.7227284504703257, 0.2028838898249612),
    RGB(0.6872106592962746, 0.6832039356917561, 0.7169835949700509),
    RGB(0.776942853267807, 0.7450425887417288, 0.3576227141824618),
    RGB(0.8260991005048138, 0.7785540745867074, 0.15455227758976428),
    RGB(0.7699880652828216, 0.7750835016443945, 0.798698308259566),
    RGB(0.8922317410283542, 0.8648865021676146, 0.11820486040774877),
    RGB(0.9164024872500107, 0.8932144802182452, 0.2645823906383936),
    RGB(0.9138583501747527, 0.8947252831872871, 0.4746384235017161),
    RGB(0.888973781274151, 0.8810887553888843, 0.8827283350559141)], "general",
    "color palette from artist Pablo Picasso's The Weeping Woman.")

loadcolorscheme(:pigeon, [
    RGB(0.195819, 0.174945, 0.218631),
    RGB(0.316089, 0.333408, 0.367098),
    RGB(0.390402, 0.464561, 0.429587),
    RGB(0.600788, 0.611074, 0.601862),
    RGB(0.860933, 0.776316, 0.843276),
    RGB(1.0, 1.0, 1.0)], "general")

loadcolorscheme(:plum, [
    RGB(0.0, 0.0, 0.0),
    RGB(0.283922, 0.0658863, 0.0672204),
    RGB(0.425528, 0.129261, 0.189587),
    RGB(0.479567, 0.203905, 0.332877),
    RGB(0.500788, 0.303597, 0.46287),
    RGB(0.543941, 0.442117, 0.545342),
    RGB(0.663774, 0.633245, 0.546072),
    RGB(0.915038, 0.890761, 0.430838)], "general")

loadcolorscheme(:rainbow, [
    RGB(0.471412, 0.108766, 0.527016),
    RGB(0.31106, 0.11758, 0.664469),
    RGB(0.250728, 0.225386, 0.769152),
    RGB(0.24408, 0.361242, 0.816084),
    RGB(0.266122, 0.486664, 0.802529),
    RGB(0.305919, 0.585575, 0.739666),
    RGB(0.36048, 0.655759, 0.645692),
    RGB(0.429842, 0.701849, 0.540321),
    RGB(0.513417, 0.72992, 0.440682),
    RGB(0.607651, 0.743718, 0.358588),
    RGB(0.705038, 0.742591, 0.299167),
    RGB(0.794549, 0.721158, 0.260829),
    RGB(0.863512, 0.670771, 0.236564),
    RGB(0.901014, 0.582826, 0.216542),
    RGB(0.902853, 0.453964, 0.192014),
    RGB(0.878107, 0.293208, 0.160481),
    RGB(0.857359, 0.131106, 0.132128)], "general")

loadcolorscheme(:redblue, [
    RGB(0.450385, 0.157961, 0.217975),
    RGB(0.599449, 0.262748, 0.294618),
    RGB(0.721701, 0.434448, 0.400225),
    RGB(0.813151, 0.617722, 0.507726),
    RGB(0.865768, 0.767491, 0.623596),
    RGB(0.857126, 0.848339, 0.734867),
    RGB(0.771923, 0.848195, 0.811697),
    RGB(0.61971, 0.781131, 0.831119),
    RGB(0.433786, 0.670834, 0.793785),
    RGB(0.256859, 0.523007, 0.711644),
    RGB(0.139681, 0.311666, 0.550652)], "general")

loadcolorscheme(:redgreensplit, [
    RGB(1.0, 0.0, 0.0),
    RGB(1.0, 0.532004, 0.532004),
    RGB(1.0, 1.0, 1.0),
    RGB(0.516977, 0.759672, 0.55607),
    RGB(0.0, 0.502449, 0.0809339)], "general")

loadcolorscheme(:rembrandt, [
    RGB(0.031663851406301846, 0.03492594286146479, 0.031003618124638095),
    RGB(0.04529340060564456, 0.04989234100446206, 0.045304957123243686),
    RGB(0.05747028102054473, 0.0635903364289073, 0.05674786425742395),
    RGB(0.086241770162247, 0.05993081347069881, 0.03249912597183947),
    RGB(0.07733335322551768, 0.08021975579857174, 0.06593659241908853),
    RGB(0.1196474818596075, 0.09119434759343707, 0.053562672116452964),
    RGB(0.0986558345957793, 0.10196107268584344, 0.08326960471213128),
    RGB(0.16486950354701338, 0.09967927690935524, 0.03900067376498974),
    RGB(0.13514238095539147, 0.12431747027723188, 0.09080749901556313),
    RGB(0.18636162788767924, 0.13671903288393764, 0.07542421275286053),
    RGB(0.23350706870800883, 0.13286319953428002, 0.03877649498014964),
    RGB(0.18313604300489003, 0.16695509905692527, 0.12174872957523301),
    RGB(0.24850425259092432, 0.1810739634103426, 0.08926667550102935),
    RGB(0.31806883272208086, 0.16576652834542305, 0.033310333831808585),
    RGB(0.2460591601422271, 0.2246302758213956, 0.15771973507641288),
    RGB(0.32103846288679067, 0.23233344239818018, 0.09830771770122464),
    RGB(0.39092579315289483, 0.24066280919519628, 0.04061547768417279),
    RGB(0.5124676703682612, 0.171165626581878, 0.04048619020501139),
    RGB(0.33665486631150426, 0.297446105254561, 0.19463793222596373),
    RGB(0.4436992922145901, 0.30167129072693216, 0.08857002897259772),
    RGB(0.43824722775240854, 0.3698866563178705, 0.2283917396419224),
    RGB(0.5309861244422538, 0.35286221885700947, 0.10669510253450244),
    RGB(0.6028470940225349, 0.42502655722834043, 0.1742236237984595),
    RGB(0.520628817626527, 0.4585008926931203, 0.3284970750665932),
    RGB(0.6865695516914383, 0.5064393554536306, 0.2470544371226196),
    RGB(0.6427293207423279, 0.575999079865911, 0.44220110761680953),
    RGB(0.7762395639474773, 0.598004387665426, 0.32005604127894954),
    RGB(0.8631632977546732, 0.694364993501825, 0.40919448553810417),
    RGB(0.7852916563988829, 0.7189996354936751, 0.576854361754559),
    RGB(0.9445661567249457, 0.8016677558279054, 0.5137283417609416),
    RGB(0.9447413960951767, 0.8705809733859705, 0.6717839422870341),
    RGB(0.9678855020491803, 0.9538263270412989, 0.8386529102301387)], "general",
    "color palette from artist Rembrandt's The Night Watch")

loadcolorscheme(:rose, [
    RGB(0.151125, 0.307698, 0.0888533),
    RGB(0.391873, 0.387803, 0.226078),
    RGB(0.691229, 0.536224, 0.368141),
    RGB(0.816631, 0.534426, 0.382173),
    RGB(0.752037, 0.349792, 0.258647),
    RGB(0.697932, 0.135622, 0.111376)], "general")

loadcolorscheme(:rust, [
    RGB(0.0, 0.00505074, 0.191104),
    RGB(0.777778, 0.368595, 0.070239),
    RGB(1.0, 0.472465, 0.0357061)], "general")

loadcolorscheme(:sandyterrain, [
    RGB(0.658579, 0.316091, 0.207507),
    RGB(0.742127, 0.402321, 0.239443),
    RGB(0.824658, 0.544191, 0.268712),
    RGB(0.895144, 0.6923, 0.292626),
    RGB(0.926205, 0.761424, 0.30301),
    RGB(0.932006, 0.77464, 0.304936),
    RGB(0.913171, 0.762585, 0.298615),
    RGB(0.816335, 0.700506, 0.267824),
    RGB(0.615762, 0.571419, 0.21246),
    RGB(0.437278, 0.454937, 0.189928),
    RGB(0.290517, 0.358022, 0.190234)], "general")

loadcolorscheme(:sienna, [
    RGB(0.466987, 0.173327, 0.0693065),
    RGB(0.794293, 0.358873, 0.0979057),
    RGB(0.915381, 0.591867, 0.320798),
    RGB(0.923632, 0.792035, 0.603304),
    RGB(0.912428, 0.879103, 0.810742)], "general")

loadcolorscheme(:sun, [
    RGB(0.468742, 0.0, 0.0158236),
    RGB(0.822129, 0.122225, 0.0039559),
    RGB(0.969963, 0.376081, 0.0322881),
    RGB(1.0, 0.646929, 0.0801709),
    RGB(1.0, 0.820127, 0.126955)], "general")

loadcolorscheme(:southwest, [
    RGB(0.396811, 0.31014, 0.204105),
    RGB(0.611882, 0.281795, 0.14969),
    RGB(0.673598, 0.379359, 0.158461),
    RGB(0.726732, 0.538136, 0.31593),
    RGB(0.790903, 0.676559, 0.433065),
    RGB(0.844861, 0.775622, 0.420917),
    RGB(0.831964, 0.810543, 0.372854),
    RGB(0.72478, 0.755004, 0.274138),
    RGB(0.559215, 0.681633, 0.459675),
    RGB(0.35082, 0.595178, 0.853742)], "general")

loadcolorscheme(:starrynight, [
    RGB(0.0863508, 0.145602, 0.203418),
    RGB(0.179449, 0.285129, 0.326534),
    RGB(0.260705, 0.406664, 0.445423),
    RGB(0.406613, 0.556979, 0.562914),
    RGB(0.575819, 0.695886, 0.635552),
    RGB(0.74555, 0.811361, 0.650903),
    RGB(0.866077, 0.862389, 0.597576),
    RGB(0.942459, 0.855345, 0.495749),
    RGB(0.957885, 0.809857, 0.369177)], "general",
    "color palette extracted from artist Vincent Van Gogh's The Starry Night")

loadcolorscheme(:sunset, [
    RGB(0.0, 0.0, 0.0),
    RGB(0.372793, 0.1358, 0.506503),
    RGB(0.788287, 0.259816, 0.270778),
    RGB(0.979377, 0.451467, 0.0511329),
    RGB(1.0, 0.682688, 0.129771),
    RGB(1.0, 0.882236, 0.491094),
    RGB(1.0, 1.0, 1.0)], "general")

loadcolorscheme(:temperaturemap, [
    RGB(0.178927, 0.305394, 0.933501),
    RGB(0.308746, 0.441842, 0.940894),
    RGB(0.453318, 0.567063, 0.950106),
    RGB(0.642359, 0.720535, 0.964988),
    RGB(0.819984, 0.859297, 0.982692),
    RGB(0.935699, 0.951565, 0.993729),
    RGB(0.984192, 0.987731, 0.911643),
    RGB(0.995282, 0.992317, 0.727853),
    RGB(0.992503, 0.986373, 0.425376),
    RGB(0.955963, 0.863115, 0.283425),
    RGB(0.904227, 0.657999, 0.241797),
    RGB(0.858405, 0.449932, 0.203562),
    RGB(0.817319, 0.134127, 0.164218)], "general")

loadcolorscheme(:thermometer, [
    RGB(0.163302, 0.119982, 0.79353),
    RGB(0.254221, 0.313173, 0.892833),
    RGB(0.407119, 0.543513, 0.938275),
    RGB(0.572715, 0.73338, 0.95065),
    RGB(0.720374, 0.855234, 0.928635),
    RGB(0.831017, 0.903518, 0.868326),
    RGB(0.894452, 0.880139, 0.77279),
    RGB(0.907999, 0.789417, 0.652903),
    RGB(0.874505, 0.639254, 0.522424),
    RGB(0.79915, 0.446142, 0.391971),
    RGB(0.685695, 0.242449, 0.268261),
    RGB(0.534081, 0.0853132, 0.16669)], "general")

loadcolorscheme(:valentine, [
    RGB(0.518837, 0.110552, 0.199207),
    RGB(0.615689, 0.163604, 0.26703),
    RGB(0.70464, 0.280653, 0.382068),
    RGB(0.815506, 0.460722, 0.553805),
    RGB(0.925798, 0.669084, 0.745464),
    RGB(0.960723, 0.837263, 0.874006)], "general")

loadcolorscheme(:vangogh, [
    RGB(0.07805214539327196, 0.0622190753445267, 0.0905010963922489),
    RGB(0.0696892120133937, 0.09805612436075063, 0.16553643605405555),
    RGB(0.17610607806485293, 0.10685455625012509, 0.12237488523063118),
    RGB(0.05051215908688022, 0.12015953504192445, 0.26225036728209034),
    RGB(0.05957217304861151, 0.17340703962434809, 0.37658447326703615),
    RGB(0.1409369146097852, 0.1857851983476936, 0.24329127025304403),
    RGB(0.05804015488280965, 0.2474447349248433, 0.5087095617504419),
    RGB(0.1513367872447275, 0.25793916445427134, 0.39854810928260026),
    RGB(0.1576213077908921, 0.3175357408269634, 0.5366570356447785),
    RGB(0.3640877030698965, 0.3344693985951321, 0.19957647099207956),
    RGB(0.09736876618982297, 0.3612834560194511, 0.6410241400040954),
    RGB(0.29409627581434244, 0.4177799847171043, 0.4593000319185568),
    RGB(0.21939844542397666, 0.4199038232901013, 0.6420021648686134),
    RGB(0.17342184458623464, 0.47288681176623193, 0.7439866613092387),
    RGB(0.496305458923572, 0.5309315796587063, 0.4018228840207263),
    RGB(0.2488936853706148, 0.5692718610060864, 0.820713773699468),
    RGB(0.3638249472506294, 0.5790539462854447, 0.6647968085264223),
    RGB(0.6399905578579894, 0.5797102447122106, 0.1699043653702972),
    RGB(0.3393005540166205, 0.6839740136561111, 0.8937515413569421),
    RGB(0.5891725241528718, 0.674433354132298, 0.5631278946707245),
    RGB(0.5405652543911175, 0.7449315659748567, 0.7663406534769982),
    RGB(0.7467832820601881, 0.7382723663590278, 0.39463723991283567),
    RGB(0.9229964281335081, 0.7423932834896501, 0.12528769806514253),
    RGB(0.48050065038933315, 0.8175108681326418, 0.9487882866068096),
    RGB(0.7692885597283127, 0.8362472142739805, 0.6545687687740542),
    RGB(0.9265773506595326, 0.8674818804760465, 0.36996512136706877),
    RGB(0.7105809231208425, 0.919514337453825, 0.9261193665689855),
    RGB(0.9515717841286133, 0.9260476308866568, 0.5531104604358869),
    RGB(0.959731486940972, 0.9627244597914443, 0.7235686748215752),
    RGB(0.9493538255802926, 0.9788824950318931, 0.8911107310285581)], "general",
    "from artist Vincent Van Gogh's painting The Starry Night, painted in June, 1889, depicting the view from the east-facing window of his asylum room at Saint-Rémy-de-Provence.")

loadcolorscheme(:vermeer, [
    RGB(0.045319841827409044, 0.04074539053177987, 0.033174030819406126),
    RGB(0.06194243196273512, 0.05903050212040492, 0.05139710689483695),
    RGB(0.08816176863597491, 0.0835588842566198, 0.07360482587419233),
    RGB(0.13589105506184534, 0.12496376250139292, 0.10750044399097393),
    RGB(0.13386551500190413, 0.15368833646156357, 0.18878465705075895),
    RGB(0.21173310699403425, 0.17519303482027762, 0.14096354869292801),
    RGB(0.17996939913746793, 0.2070443073628604, 0.26464616411985914),
    RGB(0.2945700001795375, 0.2382915360032556, 0.1795805255661416),
    RGB(0.24696726683222958, 0.28479321881898456, 0.3563823641004415),
    RGB(0.3889407172514908, 0.3005446534177714, 0.20366980742693805),
    RGB(0.25860358796296296, 0.3600943287037037, 0.5883686342592592),
    RGB(0.4782302701536857, 0.3621716499137274, 0.2210574477850006),
    RGB(0.3613315436919348, 0.4056514659351016, 0.43954963730308333),
    RGB(0.5434377913300187, 0.4329732170602859, 0.2760291232908639),
    RGB(0.5837851705568315, 0.4300883337730461, 0.1826211279409026),
    RGB(0.3658180832967516, 0.477609882572432, 0.7369900268876207),
    RGB(0.4691998237602445, 0.5157112750034727, 0.5437278615085429),
    RGB(0.6146638217664138, 0.5070899333848459, 0.3527431189706846),
    RGB(0.6926040167796138, 0.4964618194160787, 0.1419014574823617),
    RGB(0.6571624824438203, 0.5631724016853933, 0.2716476474719101),
    RGB(0.48940105254910155, 0.5809150386544087, 0.8034713879022148),
    RGB(0.7060268163419319, 0.5929742527671057, 0.41343897216886205),
    RGB(0.6334678286815325, 0.6562377235483389, 0.6145755387608501),
    RGB(0.7807461580576952, 0.6900127199441173, 0.3227402629889745),
    RGB(0.8024232937630247, 0.6774566308177037, 0.4892053841669147),
    RGB(0.6246020147710802, 0.7081286234973143, 0.8637438453832381),
    RGB(0.8466289893617022, 0.759079454787234, 0.587123670212766),
    RGB(0.8909264179888798, 0.7963500347504747, 0.3911536733794413),
    RGB(0.9108101703440042, 0.8264047024230633, 0.6766773246816413),
    RGB(0.9481923826365111, 0.8763149891872409, 0.5495049783744819),
    RGB(0.9564577470648753, 0.8846308778140886, 0.7723396650326797),
    RGB(0.9689316860465117, 0.9673077588593577, 0.9478145764119602)], "general",
    "from the Girl with a Pearl Earring, an oil painting by 17th-century
    Dutch artist Johannes Vermeer. The deep green background has faded to
    black with time.")

loadcolorscheme(:watermelon, [
    RGB(0.1, 0.1, 0.1),
    RGB(0.28648, 0.371759, 0.214236),
    RGB(0.430592, 0.585007, 0.337497),
    RGB(0.574146, 0.749759, 0.493268),
    RGB(0.727637, 0.854188, 0.660719),
    RGB(0.870242, 0.864625, 0.774702),
    RGB(0.949819, 0.725559, 0.725754),
    RGB(0.882911, 0.359638, 0.360092)], "general")

loadcolorscheme(:CMRmap, [
    	Colors.RGB{Float64}(0.0,0.0,0.0),
    	Colors.RGB{Float64}(0.012,0.012,0.04),
    	Colors.RGB{Float64}(0.024,0.024,0.08),
    	Colors.RGB{Float64}(0.036,0.036,0.12),
    	Colors.RGB{Float64}(0.048,0.048,0.16),
    	Colors.RGB{Float64}(0.06,0.06,0.2),
    	Colors.RGB{Float64}(0.072,0.072,0.24),
    	Colors.RGB{Float64}(0.084,0.084,0.28),
    	Colors.RGB{Float64}(0.096,0.096,0.32),
    	Colors.RGB{Float64}(0.108,0.108,0.36),
    	Colors.RGB{Float64}(0.12,0.12,0.4),
    	Colors.RGB{Float64}(0.132,0.132,0.44),
    	Colors.RGB{Float64}(0.144,0.144,0.48),
    	Colors.RGB{Float64}(0.156,0.15,0.51),
    	Colors.RGB{Float64}(0.168,0.15,0.53),
    	Colors.RGB{Float64}(0.18,0.15,0.55),
    	Colors.RGB{Float64}(0.192,0.15,0.5700000000000001),
    	Colors.RGB{Float64}(0.20400000000000001,0.15,0.5900000000000001),
    	Colors.RGB{Float64}(0.21599999999999997,0.15,0.61),
    	Colors.RGB{Float64}(0.22799999999999998,0.15,0.63),
    	Colors.RGB{Float64}(0.24,0.15,0.65),
    	Colors.RGB{Float64}(0.252,0.15,0.6699999999999999),
    	Colors.RGB{Float64}(0.264,0.15,0.69),
    	Colors.RGB{Float64}(0.276,0.15,0.71),
    	Colors.RGB{Float64}(0.288,0.15,0.73),
    	Colors.RGB{Float64}(0.3,0.15,0.75),
    	Colors.RGB{Float64}(0.324,0.154,0.73),
    	Colors.RGB{Float64}(0.34800000000000003,0.158,0.71),
    	Colors.RGB{Float64}(0.37200000000000005,0.162,0.69),
    	Colors.RGB{Float64}(0.3959999999999999,0.16599999999999998,0.67),
    	Colors.RGB{Float64}(0.41999999999999993,0.16999999999999998,0.65),
    	Colors.RGB{Float64}(0.44399999999999995,0.174,0.63),
    	Colors.RGB{Float64}(0.46799999999999997,0.178,0.61),
    	Colors.RGB{Float64}(0.492,0.182,0.59),
    	Colors.RGB{Float64}(0.516,0.18600000000000003,0.57),
    	Colors.RGB{Float64}(0.5399999999999999,0.19,0.55),
    	Colors.RGB{Float64}(0.564,0.194,0.53),
    	Colors.RGB{Float64}(0.588,0.198,0.51),
    	Colors.RGB{Float64}(0.616,0.202,0.486),
    	Colors.RGB{Float64}(0.648,0.20600000000000002,0.45799999999999996),
    	Colors.RGB{Float64}(0.68,0.21000000000000002,0.42999999999999994),
    	Colors.RGB{Float64}(0.712,0.214,0.4020000000000001),
    	Colors.RGB{Float64}(0.744,0.218,0.37400000000000005),
    	Colors.RGB{Float64}(0.776,0.222,0.34600000000000003),
    	Colors.RGB{Float64}(0.808,0.226,0.318),
    	Colors.RGB{Float64}(0.8400000000000001,0.23,0.29),
    	Colors.RGB{Float64}(0.8720000000000001,0.234,0.26199999999999996),
    	Colors.RGB{Float64}(0.9039999999999999,0.238,0.2340000000000001),
    	Colors.RGB{Float64}(0.9359999999999999,0.242,0.20600000000000007),
    	Colors.RGB{Float64}(0.968,0.246,0.17800000000000005),
    	Colors.RGB{Float64}(1.0,0.25,0.15000000000000002),
    	Colors.RGB{Float64}(0.992,0.27,0.13799999999999998),
    	Colors.RGB{Float64}(0.984,0.29000000000000004,0.12599999999999997),
    	Colors.RGB{Float64}(0.976,0.31000000000000005,0.11399999999999996),
    	Colors.RGB{Float64}(0.968,0.33000000000000007,0.10199999999999995),
    	Colors.RGB{Float64}(0.96,0.3500000000000001,0.08999999999999994),
    	Colors.RGB{Float64}(0.952,0.3700000000000001,0.07799999999999993),
    	Colors.RGB{Float64}(0.9440000000000001,0.3899999999999999,0.06600000000000006),
    	Colors.RGB{Float64}(0.936,0.4099999999999999,0.05400000000000005),
    	Colors.RGB{Float64}(0.928,0.42999999999999994,0.04200000000000004),
    	Colors.RGB{Float64}(0.92,0.44999999999999996,0.030000000000000027),
    	Colors.RGB{Float64}(0.912,0.47,0.018000000000000016),
    	Colors.RGB{Float64}(0.904,0.49,0.006000000000000005),
    	Colors.RGB{Float64}(0.9,0.51,0.0040000000000000036),
    	Colors.RGB{Float64}(0.9,0.53,0.01200000000000001),
    	Colors.RGB{Float64}(0.9,0.55,0.020000000000000018),
    	Colors.RGB{Float64}(0.9,0.5700000000000001,0.028000000000000025),
    	Colors.RGB{Float64}(0.9,0.5900000000000001,0.03600000000000003),
    	Colors.RGB{Float64}(0.9,0.6100000000000001,0.04400000000000004),
    	Colors.RGB{Float64}(0.9,0.6299999999999999,0.05199999999999996),
    	Colors.RGB{Float64}(0.9,0.6499999999999999,0.05999999999999997),
    	Colors.RGB{Float64}(0.9,0.6699999999999999,0.06799999999999998),
    	Colors.RGB{Float64}(0.9,0.69,0.07599999999999998),
    	Colors.RGB{Float64}(0.9,0.71,0.08399999999999999),
    	Colors.RGB{Float64}(0.9,0.73,0.092),
    	Colors.RGB{Float64}(0.9,0.75,0.1),
    	Colors.RGB{Float64}(0.9,0.762,0.13200000000000003),
    	Colors.RGB{Float64}(0.9,0.774,0.16400000000000006),
    	Colors.RGB{Float64}(0.9,0.786,0.1960000000000001),
    	Colors.RGB{Float64}(0.9,0.798,0.22800000000000012),
    	Colors.RGB{Float64}(0.9,0.81,0.2600000000000001),
    	Colors.RGB{Float64}(0.9,0.8220000000000001,0.29200000000000015),
    	Colors.RGB{Float64}(0.9,0.834,0.32399999999999984),
    	Colors.RGB{Float64}(0.9,0.846,0.35599999999999987),
    	Colors.RGB{Float64}(0.9,0.858,0.3879999999999999),
    	Colors.RGB{Float64}(0.9,0.87,0.41999999999999993),
    	Colors.RGB{Float64}(0.9,0.882,0.45199999999999996),
    	Colors.RGB{Float64}(0.9,0.894,0.484),
    	Colors.RGB{Float64}(0.904,0.904,0.52),
    	Colors.RGB{Float64}(0.912,0.912,0.56),
    	Colors.RGB{Float64}(0.92,0.92,0.6000000000000001),
    	Colors.RGB{Float64}(0.928,0.928,0.6400000000000001),
    	Colors.RGB{Float64}(0.936,0.936,0.6800000000000002),
    	Colors.RGB{Float64}(0.9440000000000001,0.9440000000000001,0.7200000000000002),
    	Colors.RGB{Float64}(0.952,0.952,0.7599999999999998),
    	Colors.RGB{Float64}(0.96,0.96,0.7999999999999998),
    	Colors.RGB{Float64}(0.968,0.968,0.8399999999999999),
    	Colors.RGB{Float64}(0.976,0.976,0.8799999999999999),
    	Colors.RGB{Float64}(0.984,0.984,0.9199999999999999),
    	Colors.RGB{Float64}(0.992,0.992,0.96),
    ], "general", "Carey Rappaport's CMRmap 'A Color Map for Effective Black and-White Rendering of Color-Scale Images' by Carey Rappaport")

loadcolorscheme(:julia_colorscheme, [
    	Colors.RGB{Float64}(0.584,0.345,0.698),
    	Colors.RGB{Float64}(0.592566,0.340556,0.677879),
    	Colors.RGB{Float64}(0.601131,0.336111,0.657758),
    	Colors.RGB{Float64}(0.609697,0.331667,0.637636),
    	Colors.RGB{Float64}(0.618263,0.327222,0.617515),
    	Colors.RGB{Float64}(0.626828,0.322778,0.597394),
    	Colors.RGB{Float64}(0.635394,0.318333,0.577273),
    	Colors.RGB{Float64}(0.64396,0.313889,0.557152),
    	Colors.RGB{Float64}(0.652525,0.309444,0.53703),
    	Colors.RGB{Float64}(0.661091,0.305,0.516909),
    	Colors.RGB{Float64}(0.669657,0.300556,0.496788),
    	Colors.RGB{Float64}(0.678222,0.296111,0.476667),
    	Colors.RGB{Float64}(0.686788,0.291667,0.456545),
    	Colors.RGB{Float64}(0.695354,0.287222,0.436424),
    	Colors.RGB{Float64}(0.703919,0.282778,0.416303),
    	Colors.RGB{Float64}(0.712485,0.278333,0.396182),
    	Colors.RGB{Float64}(0.721051,0.273889,0.376061),
    	Colors.RGB{Float64}(0.729616,0.269444,0.355939),
    	Colors.RGB{Float64}(0.738182,0.265,0.335818),
    	Colors.RGB{Float64}(0.746747,0.260556,0.315697),
    	Colors.RGB{Float64}(0.755313,0.256111,0.295576),
    	Colors.RGB{Float64}(0.763879,0.251667,0.275455),
    	Colors.RGB{Float64}(0.772444,0.247222,0.255333),
    	Colors.RGB{Float64}(0.78101,0.242778,0.235212),
    	Colors.RGB{Float64}(0.789576,0.238333,0.215091),
    	Colors.RGB{Float64}(0.793091,0.236823,0.199742),
    	Colors.RGB{Float64}(0.781455,0.244116,0.198712),
    	Colors.RGB{Float64}(0.769818,0.251409,0.197682),
    	Colors.RGB{Float64}(0.758182,0.258702,0.196652),
    	Colors.RGB{Float64}(0.746545,0.265995,0.195621),
    	Colors.RGB{Float64}(0.734909,0.273288,0.194591),
    	Colors.RGB{Float64}(0.723273,0.280581,0.193561),
    	Colors.RGB{Float64}(0.711636,0.287874,0.19253),
    	Colors.RGB{Float64}(0.7,0.295167,0.1915),
    	Colors.RGB{Float64}(0.688364,0.30246,0.19047),
    	Colors.RGB{Float64}(0.676727,0.309753,0.189439),
    	Colors.RGB{Float64}(0.665091,0.317045,0.188409),
    	Colors.RGB{Float64}(0.653455,0.324338,0.187379),
    	Colors.RGB{Float64}(0.641818,0.331631,0.186348),
    	Colors.RGB{Float64}(0.630182,0.338924,0.185318),
    	Colors.RGB{Float64}(0.618545,0.346217,0.184288),
    	Colors.RGB{Float64}(0.606909,0.35351,0.183258),
    	Colors.RGB{Float64}(0.595273,0.360803,0.182227),
    	Colors.RGB{Float64}(0.583636,0.368096,0.181197),
    	Colors.RGB{Float64}(0.572,0.375389,0.180167),
    	Colors.RGB{Float64}(0.560364,0.382682,0.179136),
    	Colors.RGB{Float64}(0.548727,0.389975,0.178106),
    	Colors.RGB{Float64}(0.537091,0.397268,0.177076),
    	Colors.RGB{Float64}(0.525455,0.404561,0.176045),
    	Colors.RGB{Float64}(0.513818,0.411854,0.175015),
    	Colors.RGB{Float64}(0.502182,0.419146,0.173985),
    	Colors.RGB{Float64}(0.490545,0.426439,0.172955),
    	Colors.RGB{Float64}(0.478909,0.433732,0.171924),
    	Colors.RGB{Float64}(0.467273,0.441025,0.170894),
    	Colors.RGB{Float64}(0.455636,0.448318,0.169864),
    	Colors.RGB{Float64}(0.444,0.455611,0.168833),
    	Colors.RGB{Float64}(0.432364,0.462904,0.167803),
    	Colors.RGB{Float64}(0.420727,0.470197,0.166773),
    	Colors.RGB{Float64}(0.409091,0.47749,0.165742),
    	Colors.RGB{Float64}(0.397455,0.484783,0.164712),
    	Colors.RGB{Float64}(0.385818,0.492076,0.163682),
    	Colors.RGB{Float64}(0.374182,0.499369,0.162652),
    	Colors.RGB{Float64}(0.362545,0.506662,0.161621),
    	Colors.RGB{Float64}(0.350909,0.513955,0.160591),
    	Colors.RGB{Float64}(0.339273,0.521247,0.159561),
    	Colors.RGB{Float64}(0.327636,0.52854,0.15853),
    	Colors.RGB{Float64}(0.316,0.535833,0.1575),
    	Colors.RGB{Float64}(0.304364,0.543126,0.15647),
    	Colors.RGB{Float64}(0.292727,0.550419,0.155439),
    	Colors.RGB{Float64}(0.281091,0.557712,0.154409),
    	Colors.RGB{Float64}(0.269455,0.565005,0.153379),
    	Colors.RGB{Float64}(0.257818,0.572298,0.152348),
    	Colors.RGB{Float64}(0.246182,0.579591,0.151318),
    	Colors.RGB{Float64}(0.234545,0.586884,0.150288),
    	Colors.RGB{Float64}(0.222909,0.594177,0.149258),
    	Colors.RGB{Float64}(0.23103,0.588394,0.165636),
    	Colors.RGB{Float64}(0.245737,0.578253,0.187818),
    	Colors.RGB{Float64}(0.260444,0.568111,0.21),
    	Colors.RGB{Float64}(0.275152,0.55797,0.232182),
    	Colors.RGB{Float64}(0.289859,0.547828,0.254364),
    	Colors.RGB{Float64}(0.304566,0.537687,0.276545),
    	Colors.RGB{Float64}(0.319273,0.527545,0.298727),
    	Colors.RGB{Float64}(0.33398,0.517404,0.320909),
    	Colors.RGB{Float64}(0.348687,0.507263,0.343091),
    	Colors.RGB{Float64}(0.363394,0.497121,0.365273),
    	Colors.RGB{Float64}(0.378101,0.48698,0.387455),
    	Colors.RGB{Float64}(0.392808,0.476838,0.409636),
    	Colors.RGB{Float64}(0.407515,0.466697,0.431818),
    	Colors.RGB{Float64}(0.422222,0.456556,0.454),
    	Colors.RGB{Float64}(0.436929,0.446414,0.476182),
    	Colors.RGB{Float64}(0.451636,0.436273,0.498364),
    	Colors.RGB{Float64}(0.466343,0.426131,0.520545),
    	Colors.RGB{Float64}(0.481051,0.41599,0.542727),
    	Colors.RGB{Float64}(0.495758,0.405848,0.564909),
    	Colors.RGB{Float64}(0.510465,0.395707,0.587091),
    	Colors.RGB{Float64}(0.525172,0.385566,0.609273),
    	Colors.RGB{Float64}(0.539879,0.375424,0.631455),
    	Colors.RGB{Float64}(0.554586,0.365283,0.653636),
    	Colors.RGB{Float64}(0.569293,0.355141,0.675818),
    	Colors.RGB{Float64}(0.584,0.345,0.698),
    ], "general", "the Julia colors continuous cyclical colorscheme, purple to red to green back to purple")

loadcolorscheme(:turbo, [
    RGB(0.18995,0.07176,0.23217),
    RGB(0.19483,0.08339,0.26149),
    RGB(0.19956,0.09498,0.29024),
    RGB(0.20415,0.10652,0.31844),
    RGB(0.20860,0.11802,0.34607),
    RGB(0.21291,0.12947,0.37314),
    RGB(0.21708,0.14087,0.39964),
    RGB(0.22111,0.15223,0.42558),
    RGB(0.22500,0.16354,0.45096),
    RGB(0.22875,0.17481,0.47578),
    RGB(0.23236,0.18603,0.50004),
    RGB(0.23582,0.19720,0.52373),
    RGB(0.23915,0.20833,0.54686),
    RGB(0.24234,0.21941,0.56942),
    RGB(0.24539,0.23044,0.59142),
    RGB(0.24830,0.24143,0.61286),
    RGB(0.25107,0.25237,0.63374),
    RGB(0.25369,0.26327,0.65406),
    RGB(0.25618,0.27412,0.67381),
    RGB(0.25853,0.28492,0.69300),
    RGB(0.26074,0.29568,0.71162),
    RGB(0.26280,0.30639,0.72968),
    RGB(0.26473,0.31706,0.74718),
    RGB(0.26652,0.32768,0.76412),
    RGB(0.26816,0.33825,0.78050),
    RGB(0.26967,0.34878,0.79631),
    RGB(0.27103,0.35926,0.81156),
    RGB(0.27226,0.36970,0.82624),
    RGB(0.27334,0.38008,0.84037),
    RGB(0.27429,0.39043,0.85393),
    RGB(0.27509,0.40072,0.86692),
    RGB(0.27576,0.41097,0.87936),
    RGB(0.27628,0.42118,0.89123),
    RGB(0.27667,0.43134,0.90254),
    RGB(0.27691,0.44145,0.91328),
    RGB(0.27701,0.45152,0.92347),
    RGB(0.27698,0.46153,0.93309),
    RGB(0.27680,0.47151,0.94214),
    RGB(0.27648,0.48144,0.95064),
    RGB(0.27603,0.49132,0.95857),
    RGB(0.27543,0.50115,0.96594),
    RGB(0.27469,0.51094,0.97275),
    RGB(0.27381,0.52069,0.97899),
    RGB(0.27273,0.53040,0.98461),
    RGB(0.27106,0.54015,0.98930),
    RGB(0.26878,0.54995,0.99303),
    RGB(0.26592,0.55979,0.99583),
    RGB(0.26252,0.56967,0.99773),
    RGB(0.25862,0.57958,0.99876),
    RGB(0.25425,0.58950,0.99896),
    RGB(0.24946,0.59943,0.99835),
    RGB(0.24427,0.60937,0.99697),
    RGB(0.23874,0.61931,0.99485),
    RGB(0.23288,0.62923,0.99202),
    RGB(0.22676,0.63913,0.98851),
    RGB(0.22039,0.64901,0.98436),
    RGB(0.21382,0.65886,0.97959),
    RGB(0.20708,0.66866,0.97423),
    RGB(0.20021,0.67842,0.96833),
    RGB(0.19326,0.68812,0.96190),
    RGB(0.18625,0.69775,0.95498),
    RGB(0.17923,0.70732,0.94761),
    RGB(0.17223,0.71680,0.93981),
    RGB(0.16529,0.72620,0.93161),
    RGB(0.15844,0.73551,0.92305),
    RGB(0.15173,0.74472,0.91416),
    RGB(0.14519,0.75381,0.90496),
    RGB(0.13886,0.76279,0.89550),
    RGB(0.13278,0.77165,0.88580),
    RGB(0.12698,0.78037,0.87590),
    RGB(0.12151,0.78896,0.86581),
    RGB(0.11639,0.79740,0.85559),
    RGB(0.11167,0.80569,0.84525),
    RGB(0.10738,0.81381,0.83484),
    RGB(0.10357,0.82177,0.82437),
    RGB(0.10026,0.82955,0.81389),
    RGB(0.09750,0.83714,0.80342),
    RGB(0.09532,0.84455,0.79299),
    RGB(0.09377,0.85175,0.78264),
    RGB(0.09287,0.85875,0.77240),
    RGB(0.09267,0.86554,0.76230),
    RGB(0.09320,0.87211,0.75237),
    RGB(0.09451,0.87844,0.74265),
    RGB(0.09662,0.88454,0.73316),
    RGB(0.09958,0.89040,0.72393),
    RGB(0.10342,0.89600,0.71500),
    RGB(0.10815,0.90142,0.70599),
    RGB(0.11374,0.90673,0.69651),
    RGB(0.12014,0.91193,0.68660),
    RGB(0.12733,0.91701,0.67627),
    RGB(0.13526,0.92197,0.66556),
    RGB(0.14391,0.92680,0.65448),
    RGB(0.15323,0.93151,0.64308),
    RGB(0.16319,0.93609,0.63137),
    RGB(0.17377,0.94053,0.61938),
    RGB(0.18491,0.94484,0.60713),
    RGB(0.19659,0.94901,0.59466),
    RGB(0.20877,0.95304,0.58199),
    RGB(0.22142,0.95692,0.56914),
    RGB(0.23449,0.96065,0.55614),
    RGB(0.24797,0.96423,0.54303),
    RGB(0.26180,0.96765,0.52981),
    RGB(0.27597,0.97092,0.51653),
    RGB(0.29042,0.97403,0.50321),
    RGB(0.30513,0.97697,0.48987),
    RGB(0.32006,0.97974,0.47654),
    RGB(0.33517,0.98234,0.46325),
    RGB(0.35043,0.98477,0.45002),
    RGB(0.36581,0.98702,0.43688),
    RGB(0.38127,0.98909,0.42386),
    RGB(0.39678,0.99098,0.41098),
    RGB(0.41229,0.99268,0.39826),
    RGB(0.42778,0.99419,0.38575),
    RGB(0.44321,0.99551,0.37345),
    RGB(0.45854,0.99663,0.36140),
    RGB(0.47375,0.99755,0.34963),
    RGB(0.48879,0.99828,0.33816),
    RGB(0.50362,0.99879,0.32701),
    RGB(0.51822,0.99910,0.31622),
    RGB(0.53255,0.99919,0.30581),
    RGB(0.54658,0.99907,0.29581),
    RGB(0.56026,0.99873,0.28623),
    RGB(0.57357,0.99817,0.27712),
    RGB(0.58646,0.99739,0.26849),
    RGB(0.59891,0.99638,0.26038),
    RGB(0.61088,0.99514,0.25280),
    RGB(0.62233,0.99366,0.24579),
    RGB(0.63323,0.99195,0.23937),
    RGB(0.64362,0.98999,0.23356),
    RGB(0.65394,0.98775,0.22835),
    RGB(0.66428,0.98524,0.22370),
    RGB(0.67462,0.98246,0.21960),
    RGB(0.68494,0.97941,0.21602),
    RGB(0.69525,0.97610,0.21294),
    RGB(0.70553,0.97255,0.21032),
    RGB(0.71577,0.96875,0.20815),
    RGB(0.72596,0.96470,0.20640),
    RGB(0.73610,0.96043,0.20504),
    RGB(0.74617,0.95593,0.20406),
    RGB(0.75617,0.95121,0.20343),
    RGB(0.76608,0.94627,0.20311),
    RGB(0.77591,0.94113,0.20310),
    RGB(0.78563,0.93579,0.20336),
    RGB(0.79524,0.93025,0.20386),
    RGB(0.80473,0.92452,0.20459),
    RGB(0.81410,0.91861,0.20552),
    RGB(0.82333,0.91253,0.20663),
    RGB(0.83241,0.90627,0.20788),
    RGB(0.84133,0.89986,0.20926),
    RGB(0.85010,0.89328,0.21074),
    RGB(0.85868,0.88655,0.21230),
    RGB(0.86709,0.87968,0.21391),
    RGB(0.87530,0.87267,0.21555),
    RGB(0.88331,0.86553,0.21719),
    RGB(0.89112,0.85826,0.21880),
    RGB(0.89870,0.85087,0.22038),
    RGB(0.90605,0.84337,0.22188),
    RGB(0.91317,0.83576,0.22328),
    RGB(0.92004,0.82806,0.22456),
    RGB(0.92666,0.82025,0.22570),
    RGB(0.93301,0.81236,0.22667),
    RGB(0.93909,0.80439,0.22744),
    RGB(0.94489,0.79634,0.22800),
    RGB(0.95039,0.78823,0.22831),
    RGB(0.95560,0.78005,0.22836),
    RGB(0.96049,0.77181,0.22811),
    RGB(0.96507,0.76352,0.22754),
    RGB(0.96931,0.75519,0.22663),
    RGB(0.97323,0.74682,0.22536),
    RGB(0.97679,0.73842,0.22369),
    RGB(0.98000,0.73000,0.22161),
    RGB(0.98289,0.72140,0.21918),
    RGB(0.98549,0.71250,0.21650),
    RGB(0.98781,0.70330,0.21358),
    RGB(0.98986,0.69382,0.21043),
    RGB(0.99163,0.68408,0.20706),
    RGB(0.99314,0.67408,0.20348),
    RGB(0.99438,0.66386,0.19971),
    RGB(0.99535,0.65341,0.19577),
    RGB(0.99607,0.64277,0.19165),
    RGB(0.99654,0.63193,0.18738),
    RGB(0.99675,0.62093,0.18297),
    RGB(0.99672,0.60977,0.17842),
    RGB(0.99644,0.59846,0.17376),
    RGB(0.99593,0.58703,0.16899),
    RGB(0.99517,0.57549,0.16412),
    RGB(0.99419,0.56386,0.15918),
    RGB(0.99297,0.55214,0.15417),
    RGB(0.99153,0.54036,0.14910),
    RGB(0.98987,0.52854,0.14398),
    RGB(0.98799,0.51667,0.13883),
    RGB(0.98590,0.50479,0.13367),
    RGB(0.98360,0.49291,0.12849),
    RGB(0.98108,0.48104,0.12332),
    RGB(0.97837,0.46920,0.11817),
    RGB(0.97545,0.45740,0.11305),
    RGB(0.97234,0.44565,0.10797),
    RGB(0.96904,0.43399,0.10294),
    RGB(0.96555,0.42241,0.09798),
    RGB(0.96187,0.41093,0.09310),
    RGB(0.95801,0.39958,0.08831),
    RGB(0.95398,0.38836,0.08362),
    RGB(0.94977,0.37729,0.07905),
    RGB(0.94538,0.36638,0.07461),
    RGB(0.94084,0.35566,0.07031),
    RGB(0.93612,0.34513,0.06616),
    RGB(0.93125,0.33482,0.06218),
    RGB(0.92623,0.32473,0.05837),
    RGB(0.92105,0.31489,0.05475),
    RGB(0.91572,0.30530,0.05134),
    RGB(0.91024,0.29599,0.04814),
    RGB(0.90463,0.28696,0.04516),
    RGB(0.89888,0.27824,0.04243),
    RGB(0.89298,0.26981,0.03993),
    RGB(0.88691,0.26152,0.03753),
    RGB(0.88066,0.25334,0.03521),
    RGB(0.87422,0.24526,0.03297),
    RGB(0.86760,0.23730,0.03082),
    RGB(0.86079,0.22945,0.02875),
    RGB(0.85380,0.22170,0.02677),
    RGB(0.84662,0.21407,0.02487),
    RGB(0.83926,0.20654,0.02305),
    RGB(0.83172,0.19912,0.02131),
    RGB(0.82399,0.19182,0.01966),
    RGB(0.81608,0.18462,0.01809),
    RGB(0.80799,0.17753,0.01660),
    RGB(0.79971,0.17055,0.01520),
    RGB(0.79125,0.16368,0.01387),
    RGB(0.78260,0.15693,0.01264),
    RGB(0.77377,0.15028,0.01148),
    RGB(0.76476,0.14374,0.01041),
    RGB(0.75556,0.13731,0.00942),
    RGB(0.74617,0.13098,0.00851),
    RGB(0.73661,0.12477,0.00769),
    RGB(0.72686,0.11867,0.00695),
    RGB(0.71692,0.11268,0.00629),
    RGB(0.70680,0.10680,0.00571),
    RGB(0.69650,0.10102,0.00522),
    RGB(0.68602,0.09536,0.00481),
    RGB(0.67535,0.08980,0.00449),
    RGB(0.66449,0.08436,0.00424),
    RGB(0.65345,0.07902,0.00408),
    RGB(0.64223,0.07380,0.00401),
    RGB(0.63082,0.06868,0.00401),
    RGB(0.61923,0.06367,0.00410),
    RGB(0.60746,0.05878,0.00427),
    RGB(0.59550,0.05399,0.00453),
    RGB(0.58336,0.04931,0.00486),
    RGB(0.57103,0.04474,0.00529),
    RGB(0.55852,0.04028,0.00579),
    RGB(0.54583,0.03593,0.00638),
    RGB(0.53295,0.03169,0.00705),
    RGB(0.51989,0.02756,0.00780),
    RGB(0.50664,0.02354,0.00863),
    RGB(0.49321,0.01963,0.00955),
    RGB(0.47960,0.01583,0.01055)], "general", "turbo, improved rainbow colormap, anton mikhailov")

loadcolorscheme(:dracula, [
    RGB{Float64}(0.54,0.0,0.0),
    RGB{Float64}(0.8,0.0,0.0),
    RGB{Float64}(0.17,0.85,0.68),
    RGB{Float64}(0.306,0.9,0.860),
    RGB{Float64}(0.384,0.5734,0.96),
    RGB{Float64}(0.323633,0.1026,0.54),
    RGB{Float64}(0.5219,0.152,0.8),
    RGB{Float64}(0.7251853,0.304,0.98),
    RGB{Float64}(0.63,0.0,0.64),
    RGB{Float64}(1.0,0.0,1.0),
    RGB{Float64}(0.68,0.265,0.64),
    RGB{Float64}(0.65,0.04,0.30672),
    RGB{Float64}(0.99,0.297,0.4588),
    RGB{Float64}(0.88,0.044,0.19253)], "general", "Count Dracula, vampire")

loadcolorscheme(:vanhelsing, [
    RGB{Float64}(0.028626,0.021,0.03),
    RGB{Float64}(0.12,0.152175,0.25),
    RGB{Float64}(0.054,0.190448,0.3),
    RGB{Float64}(0.236,0.29299,0.4),
    RGB{Float64}(0.2268,0.42,0.3045),
    RGB{Float64}(0.21,0.227465,0.42),
    RGB{Float64}(0.1333,0.18042585,0.43),
    RGB{Float64}(0.14500,0.5,0.3056375),
    RGB{Float64}(0.19440,0.24192,0.54),
    RGB{Float64}(0.18300,0.40411,0.61),
    RGB{Float64}(0.3072,0.4788,0.64),
    RGB{Float64}(0.143,0.65,0.3637),
    RGB{Float64}(0.1188,0.66,0.5312845),
    RGB{Float64}(0.4422,0.57516,0.67),
    RGB{Float64}(0.4828,0.648,0.68),
    RGB{Float64}(0.4161,0.4527,0.73),
    RGB{Float64}(0.8,0.31616,0.16),
    RGB{Float64}(0.8,0.48656,0.08),
    RGB{Float64}(0.5481,0.71,0.87),
    RGB{Float64}(0.9,0.549,0.045),
    RGB{Float64}(0.387,0.9,0.7010415),
    RGB{Float64}(0.69,0.73,0.92),
    RGB{Float64}(0.3948,0.71192,0.94)], "general", "some colors used in the 1997 Van Helsing movie")

loadcolorscheme(:gold, [
    RGB(0.446, 0.333, 0.08),
    RGB(0.45, 0.297, 0.105),
    RGB(0.497, 0.329, 0.117),
    RGB(0.549, 0.363, 0.125),
    RGB(0.596, 0.507, 0.217),
    RGB(0.599, 0.4, 0.136),
    RGB(0.621, 0.559, 0.34),
    RGB(0.626, 0.463, 0.113),
    RGB(0.643, 0.44, 0.148),
    RGB(0.654, 0.56, 0.249),
    RGB(0.682, 0.481, 0.163),
    RGB(0.716, 0.613, 0.285),
    RGB(0.72, 0.522, 0.178),
    RGB(0.727, 0.553, 0.158),
    RGB(0.758, 0.566, 0.194),
    RGB(0.767, 0.664, 0.333),
    RGB(0.797, 0.612, 0.213),
    RGB(0.809, 0.712, 0.391),
    RGB(0.835, 0.661, 0.236),
    RGB(0.848, 0.66, 0.191),
    RGB(0.872, 0.716, 0.266),
    RGB(0.872, 0.771, 0.438),
    RGB(0.875, 0.705, 0.246),
    RGB(0.907, 0.778, 0.306),
    RGB(0.923, 0.828, 0.495),
    RGB(0.925, 0.759, 0.308),
    RGB(0.939, 0.845, 0.366),
    RGB(0.964, 0.908, 0.454),
    RGB(0.979, 0.835, 0.384),
    RGB(0.98, 0.892, 0.543),
    RGB(0.98, 0.953, 0.576),
    RGB(0.99, 0.983, 0.734),
    RGB(0.995, 0.913, 0.463),
    RGB(0.995, 0.973, 0.571),
    RGB(0.995, 0.996, 0.933),
    RGB(0.996, 0.991, 0.655)], "general", "gold, golden, gilt")

loadcolorscheme(:cividis, [
    RGB(0.0000, 0.1262, 0.3015),
    RGB(0.0000, 0.1292, 0.3077),
    RGB(0.0000, 0.1321, 0.3142),
    RGB(0.0000, 0.1350, 0.3205),
    RGB(0.0000, 0.1379, 0.3269),
    RGB(0.0000, 0.1408, 0.3334),
    RGB(0.0000, 0.1437, 0.3400),
    RGB(0.0000, 0.1465, 0.3467),
    RGB(0.0000, 0.1492, 0.3537),
    RGB(0.0000, 0.1519, 0.3606),
    RGB(0.0000, 0.1546, 0.3676),
    RGB(0.0000, 0.1574, 0.3746),
    RGB(0.0000, 0.1601, 0.3817),
    RGB(0.0000, 0.1629, 0.3888),
    RGB(0.0000, 0.1657, 0.3960),
    RGB(0.0000, 0.1685, 0.4031),
    RGB(0.0000, 0.1714, 0.4102),
    RGB(0.0000, 0.1743, 0.4172),
    RGB(0.0000, 0.1773, 0.4241),
    RGB(0.0000, 0.1798, 0.4307),
    RGB(0.0000, 0.1817, 0.4347),
    RGB(0.0000, 0.1834, 0.4363),
    RGB(0.0000, 0.1852, 0.4368),
    RGB(0.0000, 0.1872, 0.4368),
    RGB(0.0000, 0.1901, 0.4365),
    RGB(0.0000, 0.1930, 0.4361),
    RGB(0.0000, 0.1958, 0.4356),
    RGB(0.0000, 0.1987, 0.4349),
    RGB(0.0000, 0.2015, 0.4343),
    RGB(0.0000, 0.2044, 0.4336),
    RGB(0.0000, 0.2073, 0.4329),
    RGB(0.0055, 0.2101, 0.4322),
    RGB(0.0236, 0.2130, 0.4314),
    RGB(0.0416, 0.2158, 0.4308),
    RGB(0.0576, 0.2187, 0.4301),
    RGB(0.0710, 0.2215, 0.4293),
    RGB(0.0827, 0.2244, 0.4287),
    RGB(0.0932, 0.2272, 0.4280),
    RGB(0.1030, 0.2300, 0.4274),
    RGB(0.1120, 0.2329, 0.4268),
    RGB(0.1204, 0.2357, 0.4262),
    RGB(0.1283, 0.2385, 0.4256),
    RGB(0.1359, 0.2414, 0.4251),
    RGB(0.1431, 0.2442, 0.4245),
    RGB(0.1500, 0.2470, 0.4241),
    RGB(0.1566, 0.2498, 0.4236),
    RGB(0.1630, 0.2526, 0.4232),
    RGB(0.1692, 0.2555, 0.4228),
    RGB(0.1752, 0.2583, 0.4224),
    RGB(0.1811, 0.2611, 0.4220),
    RGB(0.1868, 0.2639, 0.4217),
    RGB(0.1923, 0.2667, 0.4214),
    RGB(0.1977, 0.2695, 0.4212),
    RGB(0.2030, 0.2723, 0.4209),
    RGB(0.2082, 0.2751, 0.4207),
    RGB(0.2133, 0.2780, 0.4205),
    RGB(0.2183, 0.2808, 0.4204),
    RGB(0.2232, 0.2836, 0.4203),
    RGB(0.2281, 0.2864, 0.4202),
    RGB(0.2328, 0.2892, 0.4201),
    RGB(0.2375, 0.2920, 0.4200),
    RGB(0.2421, 0.2948, 0.4200),
    RGB(0.2466, 0.2976, 0.4200),
    RGB(0.2511, 0.3004, 0.4201),
    RGB(0.2556, 0.3032, 0.4201),
    RGB(0.2599, 0.3060, 0.4202),
    RGB(0.2643, 0.3088, 0.4203),
    RGB(0.2686, 0.3116, 0.4205),
    RGB(0.2728, 0.3144, 0.4206),
    RGB(0.2770, 0.3172, 0.4208),
    RGB(0.2811, 0.3200, 0.4210),
    RGB(0.2853, 0.3228, 0.4212),
    RGB(0.2894, 0.3256, 0.4215),
    RGB(0.2934, 0.3284, 0.4218),
    RGB(0.2974, 0.3312, 0.4221),
    RGB(0.3014, 0.3340, 0.4224),
    RGB(0.3054, 0.3368, 0.4227),
    RGB(0.3093, 0.3396, 0.4231),
    RGB(0.3132, 0.3424, 0.4236),
    RGB(0.3170, 0.3453, 0.4240),
    RGB(0.3209, 0.3481, 0.4244),
    RGB(0.3247, 0.3509, 0.4249),
    RGB(0.3285, 0.3537, 0.4254),
    RGB(0.3323, 0.3565, 0.4259),
    RGB(0.3361, 0.3593, 0.4264),
    RGB(0.3398, 0.3622, 0.4270),
    RGB(0.3435, 0.3650, 0.4276),
    RGB(0.3472, 0.3678, 0.4282),
    RGB(0.3509, 0.3706, 0.4288),
    RGB(0.3546, 0.3734, 0.4294),
    RGB(0.3582, 0.3763, 0.4302),
    RGB(0.3619, 0.3791, 0.4308),
    RGB(0.3655, 0.3819, 0.4316),
    RGB(0.3691, 0.3848, 0.4322),
    RGB(0.3727, 0.3876, 0.4331),
    RGB(0.3763, 0.3904, 0.4338),
    RGB(0.3798, 0.3933, 0.4346),
    RGB(0.3834, 0.3961, 0.4355),
    RGB(0.3869, 0.3990, 0.4364),
    RGB(0.3905, 0.4018, 0.4372),
    RGB(0.3940, 0.4047, 0.4381),
    RGB(0.3975, 0.4075, 0.4390),
    RGB(0.4010, 0.4104, 0.4400),
    RGB(0.4045, 0.4132, 0.4409),
    RGB(0.4080, 0.4161, 0.4419),
    RGB(0.4114, 0.4189, 0.4430),
    RGB(0.4149, 0.4218, 0.4440),
    RGB(0.4183, 0.4247, 0.4450),
    RGB(0.4218, 0.4275, 0.4462),
    RGB(0.4252, 0.4304, 0.4473),
    RGB(0.4286, 0.4333, 0.4485),
    RGB(0.4320, 0.4362, 0.4496),
    RGB(0.4354, 0.4390, 0.4508),
    RGB(0.4388, 0.4419, 0.4521),
    RGB(0.4422, 0.4448, 0.4534),
    RGB(0.4456, 0.4477, 0.4547),
    RGB(0.4489, 0.4506, 0.4561),
    RGB(0.4523, 0.4535, 0.4575),
    RGB(0.4556, 0.4564, 0.4589),
    RGB(0.4589, 0.4593, 0.4604),
    RGB(0.4622, 0.4622, 0.4620),
    RGB(0.4656, 0.4651, 0.4635),
    RGB(0.4689, 0.4680, 0.4650),
    RGB(0.4722, 0.4709, 0.4665),
    RGB(0.4756, 0.4738, 0.4679),
    RGB(0.4790, 0.4767, 0.4691),
    RGB(0.4825, 0.4797, 0.4701),
    RGB(0.4861, 0.4826, 0.4707),
    RGB(0.4897, 0.4856, 0.4714),
    RGB(0.4934, 0.4886, 0.4719),
    RGB(0.4971, 0.4915, 0.4723),
    RGB(0.5008, 0.4945, 0.4727),
    RGB(0.5045, 0.4975, 0.4730),
    RGB(0.5083, 0.5005, 0.4732),
    RGB(0.5121, 0.5035, 0.4734),
    RGB(0.5158, 0.5065, 0.4736),
    RGB(0.5196, 0.5095, 0.4737),
    RGB(0.5234, 0.5125, 0.4738),
    RGB(0.5272, 0.5155, 0.4739),
    RGB(0.5310, 0.5186, 0.4739),
    RGB(0.5349, 0.5216, 0.4738),
    RGB(0.5387, 0.5246, 0.4739),
    RGB(0.5425, 0.5277, 0.4738),
    RGB(0.5464, 0.5307, 0.4736),
    RGB(0.5502, 0.5338, 0.4735),
    RGB(0.5541, 0.5368, 0.4733),
    RGB(0.5579, 0.5399, 0.4732),
    RGB(0.5618, 0.5430, 0.4729),
    RGB(0.5657, 0.5461, 0.4727),
    RGB(0.5696, 0.5491, 0.4723),
    RGB(0.5735, 0.5522, 0.4720),
    RGB(0.5774, 0.5553, 0.4717),
    RGB(0.5813, 0.5584, 0.4714),
    RGB(0.5852, 0.5615, 0.4709),
    RGB(0.5892, 0.5646, 0.4705),
    RGB(0.5931, 0.5678, 0.4701),
    RGB(0.5970, 0.5709, 0.4696),
    RGB(0.6010, 0.5740, 0.4691),
    RGB(0.6050, 0.5772, 0.4685),
    RGB(0.6089, 0.5803, 0.4680),
    RGB(0.6129, 0.5835, 0.4673),
    RGB(0.6168, 0.5866, 0.4668),
    RGB(0.6208, 0.5898, 0.4662),
    RGB(0.6248, 0.5929, 0.4655),
    RGB(0.6288, 0.5961, 0.4649),
    RGB(0.6328, 0.5993, 0.4641),
    RGB(0.6368, 0.6025, 0.4632),
    RGB(0.6408, 0.6057, 0.4625),
    RGB(0.6449, 0.6089, 0.4617),
    RGB(0.6489, 0.6121, 0.4609),
    RGB(0.6529, 0.6153, 0.4600),
    RGB(0.6570, 0.6185, 0.4591),
    RGB(0.6610, 0.6217, 0.4583),
    RGB(0.6651, 0.6250, 0.4573),
    RGB(0.6691, 0.6282, 0.4562),
    RGB(0.6732, 0.6315, 0.4553),
    RGB(0.6773, 0.6347, 0.4543),
    RGB(0.6813, 0.6380, 0.4532),
    RGB(0.6854, 0.6412, 0.4521),
    RGB(0.6895, 0.6445, 0.4511),
    RGB(0.6936, 0.6478, 0.4499),
    RGB(0.6977, 0.6511, 0.4487),
    RGB(0.7018, 0.6544, 0.4475),
    RGB(0.7060, 0.6577, 0.4463),
    RGB(0.7101, 0.6610, 0.4450),
    RGB(0.7142, 0.6643, 0.4437),
    RGB(0.7184, 0.6676, 0.4424),
    RGB(0.7225, 0.6710, 0.4409),
    RGB(0.7267, 0.6743, 0.4396),
    RGB(0.7308, 0.6776, 0.4382),
    RGB(0.7350, 0.6810, 0.4368),
    RGB(0.7392, 0.6844, 0.4352),
    RGB(0.7434, 0.6877, 0.4338),
    RGB(0.7476, 0.6911, 0.4322),
    RGB(0.7518, 0.6945, 0.4307),
    RGB(0.7560, 0.6979, 0.4290),
    RGB(0.7602, 0.7013, 0.4273),
    RGB(0.7644, 0.7047, 0.4258),
    RGB(0.7686, 0.7081, 0.4241),
    RGB(0.7729, 0.7115, 0.4223),
    RGB(0.7771, 0.7150, 0.4205),
    RGB(0.7814, 0.7184, 0.4188),
    RGB(0.7856, 0.7218, 0.4168),
    RGB(0.7899, 0.7253, 0.4150),
    RGB(0.7942, 0.7288, 0.4129),
    RGB(0.7985, 0.7322, 0.4111),
    RGB(0.8027, 0.7357, 0.4090),
    RGB(0.8070, 0.7392, 0.4070),
    RGB(0.8114, 0.7427, 0.4049),
    RGB(0.8157, 0.7462, 0.4028),
    RGB(0.8200, 0.7497, 0.4007),
    RGB(0.8243, 0.7532, 0.3984),
    RGB(0.8287, 0.7568, 0.3961),
    RGB(0.8330, 0.7603, 0.3938),
    RGB(0.8374, 0.7639, 0.3915),
    RGB(0.8417, 0.7674, 0.3892),
    RGB(0.8461, 0.7710, 0.3869),
    RGB(0.8505, 0.7745, 0.3843),
    RGB(0.8548, 0.7781, 0.3818),
    RGB(0.8592, 0.7817, 0.3793),
    RGB(0.8636, 0.7853, 0.3766),
    RGB(0.8681, 0.7889, 0.3739),
    RGB(0.8725, 0.7926, 0.3712),
    RGB(0.8769, 0.7962, 0.3684),
    RGB(0.8813, 0.7998, 0.3657),
    RGB(0.8858, 0.8035, 0.3627),
    RGB(0.8902, 0.8071, 0.3599),
    RGB(0.8947, 0.8108, 0.3569),
    RGB(0.8992, 0.8145, 0.3538),
    RGB(0.9037, 0.8182, 0.3507),
    RGB(0.9082, 0.8219, 0.3474),
    RGB(0.9127, 0.8256, 0.3442),
    RGB(0.9172, 0.8293, 0.3409),
    RGB(0.9217, 0.8330, 0.3374),
    RGB(0.9262, 0.8367, 0.3340),
    RGB(0.9308, 0.8405, 0.3306),
    RGB(0.9353, 0.8442, 0.3268),
    RGB(0.9399, 0.8480, 0.3232),
    RGB(0.9444, 0.8518, 0.3195),
    RGB(0.9490, 0.8556, 0.3155),
    RGB(0.9536, 0.8593, 0.3116),
    RGB(0.9582, 0.8632, 0.3076),
    RGB(0.9628, 0.8670, 0.3034),
    RGB(0.9674, 0.8708, 0.2990),
    RGB(0.9721, 0.8746, 0.2947),
    RGB(0.9767, 0.8785, 0.2901),
    RGB(0.9814, 0.8823, 0.2856),
    RGB(0.9860, 0.8862, 0.2807),
    RGB(0.9907, 0.8901, 0.2759),
    RGB(0.9954, 0.8940, 0.2708),
    RGB(1.0000, 0.8979, 0.2655),
    RGB(1.0000, 0.9018, 0.2600),
    RGB(1.0000, 0.9057, 0.2593),
    RGB(1.0000, 0.9094, 0.2634),
    RGB(1.0000, 0.9131, 0.2680),
    RGB(1.0000, 0.9169, 0.2731)], "general", "Cividis color scale for R")

loadcolorscheme(:twelvebitrainbow, [
    RGB(0.533,0.067,0.467),
    RGB(0.667,0.2,0.333),
    RGB(0.8,0.4,0.4),
    RGB(0.933,0.6,0.267),
    RGB(0.933,0.867,0.0),
    RGB(0.6,0.867,0.333),
    RGB(0.267,0.867,0.533),
    RGB(0.133,0.8,0.733),
    RGB(0.0,0.733,0.8),
    RGB(0.0,0.6,0.8),
    RGB(0.2,0.4,0.733),
    RGB(0.4,0.2,0.6)], "general", "12bitrainbow, https://iamkate.com/data/12-bit-rainbow/")
