#! format: off
#! source: https://github.com/alexeyovchinnikov/SIAN-Julia

import AbstractAlgebra

function SEIR2(; np=AbstractAlgebra, internal_ordering=:degrevlex, k=np.QQ)
    R, (Cu_7,Cu_6,E_6,S_5,In_5,Cu_5,E_5,N_5,S_4,In_4,Cu_4,E_4,N_4,S_3,In_3,Cu_3,E_3,N_3,S_2,In_2,Cu_2,E_2,N_2,S_1,In_1,Cu_1,E_1,N_1,S_0,In_0,Cu_0,E_0,N_0,z_aux,b_0,nu_0,a_0) = np.polynomial_ring(k, [:Cu_7,:Cu_6,:E_6,:S_5,:In_5,:Cu_5,:E_5,:N_5,:S_4,:In_4,:Cu_4,:E_4,:N_4,:S_3,:In_3,:Cu_3,:E_3,:N_3,:S_2,:In_2,:Cu_2,:E_2,:N_2,:S_1,:In_1,:Cu_1,:E_1,:N_1,:S_0,:In_0,:Cu_0,:E_0,:N_0,:z_aux,:b_0,:nu_0,:a_0], internal_ordering=internal_ordering)
    sys = [
    		-N_0 + 80964352216573,
		N_1,
		-Cu_0 + 41597937022849,
		-E_0*nu_0 + Cu_1,
		-Cu_1 + 940788553279991621384065315,
		-E_1*nu_0 + Cu_2,
		-S_0*In_0*b_0 + E_0*N_0*nu_0 + E_1*N_0,
		-Cu_2 + k(69788017940669611501972212892493035693147749697150361460)//k(80964352216573),
		-E_2*nu_0 + Cu_3,
		-In_1*S_0*b_0 - S_1*In_0*b_0 + N_1*E_0*nu_0 + E_1*N_0*nu_0 + E_1*N_1 + E_2*N_0,
		S_0*In_0*b_0 + S_1*N_0,
		-E_0*nu_0 + In_0*a_0 + In_1,
		-Cu_3 - k(1578325878458462490141137695660527025884253299682271709762499055315603596256303176705)//k(6555226329849289258295864329),
		-E_3*nu_0 + Cu_4,
		-2*S_1*In_1*b_0 - In_2*S_0*b_0 - S_2*In_0*b_0 + 2*E_1*N_1*nu_0 + N_2*E_0*nu_0 + E_2*N_0*nu_0 + N_2*E_1 + 2*E_2*N_1 + E_3*N_0,
		In_1*S_0*b_0 + S_1*In_0*b_0 + S_1*N_1 + S_2*N_0,
		-E_1*nu_0 + In_1*a_0 + In_2,
		N_2,
		-Cu_4 + k(39724860946473717882046143179153515091018822696413730784970058542424892498330734467497214839359165414691943463900)//k(530739653429270994392935402214310033324517),
		-E_4*nu_0 + Cu_5,
		-3*In_2*S_1*b_0 - 3*S_2*In_1*b_0 - In_3*S_0*b_0 - S_3*In_0*b_0 + 3*N_2*E_1*nu_0 + 3*E_2*N_1*nu_0 + N_3*E_0*nu_0 + E_3*N_0*nu_0 + 3*E_2*N_2 + N_3*E_1 + 3*E_3*N_1 + E_4*N_0,
		2*S_1*In_1*b_0 + In_2*S_0*b_0 + S_2*In_0*b_0 + N_2*S_1 + 2*S_2*N_1 + S_3*N_0,
		-E_2*nu_0 + In_2*a_0 + In_3,
		N_3,
		-Cu_5 - k(1233940473623174696455772314427206607427887278333728312197501690591774742318295349817082596630902236063520884771338641792793233816610414448460)//k(42970992235549382855557155286802175838977691465174620241),
		-E_5*nu_0 + Cu_6,
		-6*S_2*In_2*b_0 - 4*In_3*S_1*b_0 - 4*S_3*In_1*b_0 - In_4*S_0*b_0 - S_4*In_0*b_0 + 6*E_2*N_2*nu_0 + 4*N_3*E_1*nu_0 + 4*E_3*N_1*nu_0 + N_4*E_0*nu_0 + E_4*N_0*nu_0 + 4*N_3*E_2 + 6*E_3*N_2 + N_4*E_1 + 4*E_4*N_1 + E_5*N_0,
		3*In_2*S_1*b_0 + 3*S_2*In_1*b_0 + In_3*S_0*b_0 + S_3*In_0*b_0 + 3*S_2*N_2 + N_3*S_1 + 3*S_3*N_1 + S_4*N_0,
		N_4,
		-E_3*nu_0 + In_3*a_0 + In_4,
		-Cu_6 + k(45991582006525566095280181375122952038782929491517390643924828373631315653644411274122337091276973673781805636460456466062287660102633800230193668015166503043985099070085)//k(3479118550454643848329731169935892110921492759908709268345911861454093),
		-E_6*nu_0 + Cu_7,
		-10*In_3*S_2*b_0 - 10*S_3*In_2*b_0 - 5*In_4*S_1*b_0 - 5*S_4*In_1*b_0 - In_5*S_0*b_0 - S_5*In_0*b_0 + 10*N_3*E_2*nu_0 + 10*E_3*N_2*nu_0 + 5*N_4*E_1*nu_0 + 5*E_4*N_1*nu_0 + N_5*E_0*nu_0 + E_5*N_0*nu_0 + 10*E_3*N_3 + 5*N_4*E_2 + 10*E_4*N_2 + N_5*E_1 + 5*E_5*N_1 + E_6*N_0,
		N_5,
		-E_4*nu_0 + In_4*a_0 + In_5,
		6*S_2*In_2*b_0 + 4*In_3*S_1*b_0 + 4*S_3*In_1*b_0 + In_4*S_0*b_0 + S_4*In_0*b_0 + 4*N_3*S_2 + 6*S_3*N_2 + N_4*S_1 + 4*S_4*N_1 + S_5*N_0,
		-N_1,
		-N_2,
		-N_3,
		-N_4,
		-N_5,
		-Cu_7 - k(1998034673792540316415546696194472963463855736041977870292600294761543400246522208133578754587636457899320553198562340583500095456750215457680311795499674943864876220232443791049807547557519404549380)//k(281684579722222686398416548672376254969196746317300676559729758085223587063433283289),
		N_0*z_aux - 1
    ]
end
