/*
 * Decompiled with CFR 0.152.
 */
package io.sf.carte.echosvg.ext.awt.image.spi;

import io.sf.carte.echosvg.ext.awt.image.spi.ErrorConstants;
import io.sf.carte.echosvg.ext.awt.image.spi.RegistryEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public abstract class AbstractRegistryEntry
implements RegistryEntry,
ErrorConstants {
    String name;
    float priority;
    List<String> exts;
    List<String> mimeTypes;

    public AbstractRegistryEntry(String name, float priority, String[] exts, String[] mimeTypes) {
        this.name = name;
        this.priority = priority;
        this.exts = new ArrayList<String>(exts.length);
        for (String ext : exts) {
            this.exts.add(ext);
        }
        this.exts = Collections.unmodifiableList(this.exts);
        this.mimeTypes = new ArrayList<String>(mimeTypes.length);
        for (String mimeType : mimeTypes) {
            this.mimeTypes.add(mimeType);
        }
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
    }

    public AbstractRegistryEntry(String name, float priority, String ext, String mimeType) {
        this.name = name;
        this.priority = priority;
        this.exts = new ArrayList<String>(1);
        this.exts.add(ext);
        this.exts = Collections.unmodifiableList(this.exts);
        this.mimeTypes = new ArrayList<String>(1);
        this.mimeTypes.add(mimeType);
        this.mimeTypes = Collections.unmodifiableList(this.mimeTypes);
    }

    @Override
    public String getFormatName() {
        return this.name;
    }

    @Override
    public List<String> getStandardExtensions() {
        return this.exts;
    }

    @Override
    public List<String> getMimeTypes() {
        return this.mimeTypes;
    }

    @Override
    public float getPriority() {
        return this.priority;
    }
}

