/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.math.Elliptic;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;

public class AdamsHemisphereOblique
extends AbstractProjection {
    public static final String PROJECTION_NAME = "Adams Hemisphere Oblique";
    public static final int PROPERTIES = 0x201000;
    private static final double MODULUS = 0.7071067811865476;
    private static final double MODULUS2 = 0.5000000000000001;
    private static final double CAP_K = 1.854074677301372;
    private static final double TWO_K = 3.708149354602744;
    private static final double MAX_X_OVER_RS = 1.854074677301372;
    private static final double MAX_Y_OVER_RS = 1.854074677301372;
    private double kRS_;
    private double twoKRS_;
    private LonLatRotator rotMatrives_;

    public AdamsHemisphereOblique(int width, int height) {
        this(width, height, 0, 0);
    }

    public AdamsHemisphereOblique(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 0x201000, width, height, xmargin, ymargin, 1.854074677301372, 1.854074677301372);
        this.rotMatrives_ = new LonLatRotator(this.lambdaC_, this.phiC_);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        if (this.rotMatrives_ != null) {
            this.rotMatrives_.setAngles(lon, lat);
        }
    }

    @Override
    protected final void finishScaling() {
        this.kRS_ = 1.854074677301372 * this.rS_;
        this.twoKRS_ = 3.708149354602744 * this.rS_;
    }

    @Override
    public boolean isRecenterableLat() {
        return true;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double ttemp;
        double[] llP = this.rotMatrives_.rotate(lon, lat);
        double lambdaRad = Math.toRadians(MapUtils.normalizeMP180(llP[0]));
        double phiRad = Math.toRadians(llP[1]);
        double absLambdaRad = Math.abs(lambdaRad);
        if (absLambdaRad > 1.5707963267948966) {
            return null;
        }
        double sinLambda = Math.sin(absLambdaRad);
        double absPhiRad = Math.abs(phiRad);
        double cosPhi = Math.cos(absPhiRad);
        double sinPhi = Math.sin(absPhiRad);
        double cosA = cosPhi * sinLambda;
        double cosB = sinPhi;
        double sinA = Math.sqrt(1.0 - cosA * cosA);
        double sinB = Math.sqrt(1.0 - cosB * cosB);
        double cosAcosB = cosA * cosB;
        double sinAsinB = sinA * sinB;
        double sinM = Math.sqrt(1.0 + cosAcosB - sinAsinB);
        double sinN = Math.sqrt(1.0 - cosAcosB - sinAsinB);
        double mmm = Math.asin(sinM);
        double nnn = Math.asin(sinN);
        if (sinPhi + cosA < 0.0) {
            mmm = -mmm;
        }
        if (sinPhi - cosA < 0.0) {
            nnn = -nnn;
        }
        double xx = Elliptic.ellipticF(mmm, 0.5000000000000001);
        double yy = Elliptic.ellipticF(nnn, 0.5000000000000001);
        if (lambdaRad < 0.0 && phiRad < 0.0) {
            xx = -xx;
            yy = -yy;
        } else if (lambdaRad < 0.0) {
            ttemp = yy;
            yy = xx;
            xx = ttemp;
        } else if (phiRad < 0.0) {
            ttemp = yy;
            yy = -xx;
            xx = -ttemp;
        }
        double x = (double)this.outCenterX_ + xx * this.rS_;
        double y = (double)this.outCenterY_ - yy * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        double absX = Math.abs(x);
        double absY = Math.abs(y);
        if (absX > this.kRS_ || absY > this.kRS_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_;
        double[] llRot = this.transformXYrs2LLRot(xOverRS, yOverRS);
        if (llRot == null || Double.isNaN(llRot[0]) || Double.isNaN(llRot[1])) {
            return null;
        }
        double[] ll = this.rotMatrives_.inverse(llRot[0], llRot[1]);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        AdamsHemisphereOblique adamsHemisphereOblique = this;
        synchronized (adamsHemisphereOblique) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_;
                for (int ix = -this.dxMax_; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double[] llRot = this.transformXYrs2LLRot(xOverRS, yOverRS);
                    if (llRot == null) continue;
                    double[] ll = this.rotMatrives_.inverse(llRot[0], llRot[1]);
                    this.setInvPoint(ix, iy, ll[0], ll[1]);
                }
            }
        }
    }

    private void setInvPoint(int ix, int iy, double lon, double lat) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    private double[] transformXYrs2LLRot(double x, double y) {
        double cosB;
        double xx = Math.abs(x);
        double yy = Math.abs(y);
        double[] jacobiM = Elliptic.jacobiSnCnDn(xx, 0.5000000000000001);
        double[] jacobiN = Elliptic.jacobiSnCnDn(yy, 0.5000000000000001);
        double sinM = jacobiM[0];
        double sinN = jacobiN[0];
        double sinSqM = sinM * sinM;
        double sinSqN = sinN * sinN;
        double sinAsinB = -0.5 * (sinSqM + sinSqN - 2.0);
        double cosAcosB = 0.5 * (sinSqM - sinSqN);
        double cosAplusB = cosAcosB - sinAsinB;
        double cosAminusB = cosAcosB + sinAsinB;
        double aPlusB = Math.acos(cosAplusB);
        double aMinusB = y * x < 0.0 ? -Math.acos(cosAminusB) : Math.acos(cosAminusB);
        double a = 0.5 * (aPlusB + aMinusB);
        double b = 0.5 * (aPlusB - aMinusB);
        double cosA = Math.cos(a);
        double sinPhi = cosB = Math.cos(b);
        double phiRad = x < 0.0 ? -Math.asin(sinPhi) : Math.asin(sinPhi);
        double cosPhi = Math.cos(phiRad);
        double sinLambda = cosA / cosPhi;
        double lambdaRad = x < 0.0 ? -Math.asin(sinLambda) : Math.asin(sinLambda);
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new double[]{lambda, phi};
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawRect(g2d, (double)this.outCenterX_ - this.kRS_, (double)this.outCenterY_ - this.kRS_, this.twoKRS_, this.twoKRS_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        super.drawParallel(g2d, lat, label);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double absLambda = Math.abs(this.lonToLambda(lon));
        super.drawMeridian(g2d, lon, maxLat, label);
    }
}

