/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatEdges;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Shape;
import java.awt.geom.Area;
import java.awt.geom.Path2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MercatorRegional
extends AbstractProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Mercator Regional";
    public static final int PROPERTIES = 2101252;
    private static final double DEFAULT_TOPLAT = 85.05;
    private static final double MAX_X_OVER_RS = Math.PI;
    private static final double MAX_Y_OVER_RS = Math.log(Math.tan(1.527599427808037));
    private double widthDeg_ = 1.0;
    private double halfWidthDeg_ = 1.0;
    private final ProjDoubleParameter wdthParam_ = new ProjDoubleParameter("Angular distance between left and right sides", "Width", "\u00b0", 90.0, 0.001666667, 360.0, true, true);
    private double yOffset_;
    private double topLat_;
    private double botLat_;
    private Path2D.Double borderPath_;

    public MercatorRegional(int width, int height) {
        this(width, height, 0, 0);
    }

    public MercatorRegional(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 2101252, width, height, xmargin, ymargin, Math.PI, MAX_Y_OVER_RS);
        this.addParameter(this.wdthParam_);
        this.finishConstruction();
        this.borderPath_ = new Path2D.Double();
    }

    @Override
    public boolean isRecenterableLat() {
        return true;
    }

    @Override
    public void setCenter(double lon, double lat) {
        if (Math.abs(lat) > 89.99999) {
            super.setCenter(lon, Math.signum(lat) * 89.99999);
        } else {
            super.setCenter(lon, lat);
        }
        this.finishScaling();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.wdthParam_)) {
            this.setWidthDeg(this.wdthParam_.getValue());
        } else if (p != this.getParameter(0)) {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
    }

    public ProjDoubleParameter getWidthParam() {
        return this.wdthParam_;
    }

    public double getWidthDeg() {
        return this.widthDeg_;
    }

    private void setWidthDeg(double w) {
        LOGGER.trace("w {}", (Object)w);
        this.widthDeg_ = w;
        this.halfWidthDeg_ = 0.5 * w;
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        double halfWidthRad = Math.toRadians(this.halfWidthDeg_);
        double ratio = (double)this.getUsedHeight() / (double)this.getUsedWidth();
        this.setMaxXYOverRS(halfWidthRad, ratio * halfWidthRad);
    }

    @Override
    protected final void finishScaling() {
        this.yOffset_ = Math.log(Math.tan(0.7853981633974483 + 0.5 * Math.toRadians(this.phiC_))) * this.rS_;
        LOGGER.trace("yOffset {}", (Object)this.yOffset_);
        double yyy = this.yOffset_ + (double)this.dyMax_;
        double phiRad = 2.0 * Math.atan(Math.exp(yyy * this.invRS_)) - 1.5707963267948966;
        this.topLat_ = Math.toDegrees(phiRad);
        yyy = this.yOffset_ - (double)this.dyMax_;
        phiRad = 2.0 * Math.atan(Math.exp(yyy * this.invRS_)) - 1.5707963267948966;
        this.botLat_ = Math.toDegrees(phiRad);
        LOGGER.trace("topLat {}, botLat {}", (Object)this.topLat_, (Object)this.botLat_);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double x = this.lonToLambdaRad(lon);
        if (Math.abs(x) > this.halfWidthDeg_) {
            return null;
        }
        double y = Math.log(Math.tan(0.7853981633974483 + 0.5 * Math.toRadians(lat)));
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - (y * this.rS_ - this.yOffset_);
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double yyy = y + this.yOffset_;
        double phiRad = 2.0 * Math.atan(Math.exp(yyy * this.invRS_)) - 1.5707963267948966;
        double lambdaRad = x * this.invRS_;
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        double lambda = Math.toDegrees(lambdaRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        MercatorRegional mercatorRegional = this;
        synchronized (mercatorRegional) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double x;
                double lambdaRad;
                double y = (double)iy + 0.5;
                double yyy = y + this.yOffset_;
                double phiRad = 2.0 * Math.atan(Math.exp(yyy * this.invRS_)) - 1.5707963267948966;
                double phi = Math.toDegrees(phiRad);
                for (int ix = 0; ix < this.dxMax_ && !((lambdaRad = (x = (double)ix + 0.5) * this.invRS_) > Math.PI); ++ix) {
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), phi);
                }
            }
        }
    }

    private void setInvPoints(int ix, int iy, double lambda, double phi) {
        int row = this.outCenterY_ - iy - 1;
        int col = this.outCenterX_ + ix;
        int colF = this.outCenterX_ - ix - 1;
        this.setInverseArrayLocation(col, row, this.lambdaC_ + lambda, phi);
        this.setInverseArrayLocation(colF, row, this.lambdaC_ - lambda, phi);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        int ww = this.getWidth();
        int hh = this.getHeight();
        Insets ins = this.getInsets();
        this.borderPath_.reset();
        this.borderPath_.moveTo(ins.left, ins.top);
        this.borderPath_.lineTo(ins.left, hh - ins.bottom);
        this.borderPath_.lineTo(ww - ins.right, hh - ins.bottom);
        this.borderPath_.lineTo(ww - ins.right, ins.top);
        this.borderPath_.closePath();
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(g2x.getStroke()));
        g2x.draw(this.borderPath_);
        g2x.dispose();
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        Point2D.Double dot = this.transformLL2XY(this.lambdaC_, lat);
        if (dot == null) {
            return;
        }
        int ww = this.getWidth();
        int hh = this.getHeight();
        Insets ins = this.getInsets();
        if (dot.y <= (double)ins.top - 0.5) {
            return;
        }
        if (dot.y >= (double)(hh - ins.bottom) + 0.5) {
            return;
        }
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, ins.left, dot.y, ww - ins.right, dot.y);
            return;
        }
        FontMetrics fm = g2d.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = ww - ins.right - fh2 - w;
        g2d.drawString(label, labelx, (float)(dot.y + (double)fh2 - (double)(0.5f * (float)des)));
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, dot.y - (double)fh2, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, ins.left, dot.y, ww - ins.right, dot.y);
        g2x.dispose();
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        Point2D.Double dot = this.transformLL2XY(lon, this.phiC_);
        if (dot == null) {
            return;
        }
        int ww = this.getWidth();
        int hh = this.getHeight();
        Insets ins = this.getInsets();
        if (dot.x <= (double)ins.left + 0.5) {
            return;
        }
        if (dot.x >= (double)(ww - ins.right) - 0.5) {
            return;
        }
        float top = ins.top;
        float bottom = hh - ins.bottom;
        if (label == null || label.length() == 0) {
            GraphicUtils.drawLine(g2d, dot.x, top, dot.x, bottom);
            return;
        }
        Graphics2D g2x = (Graphics2D)g2d.create();
        Shape oldclip = g2x.getClip();
        if (oldclip == null) {
            oldclip = this.getMarginRectClose();
        }
        FontMetrics fm = g2x.getFontMetrics();
        int w = fm.stringWidth(label);
        int des = fm.getDescent();
        int fh = fm.getHeight();
        int fh2 = fh / 2;
        int fh4 = fh / 4;
        float labelx = (float)(dot.x - 0.5 * (double)w);
        float labely = top + 0.75f * (bottom - top);
        g2x.drawString(label, labelx, labely - (float)des);
        Rectangle2D.Double textRect = new Rectangle2D.Double(labelx - (float)fh4, labely - (float)fh, w + fh2, fh);
        Area clipArea = new Area(oldclip);
        Area textArea = new Area(textRect);
        clipArea.subtract(textArea);
        g2x.setClip(clipArea);
        GraphicUtils.drawLine(g2x, dot.x, top, dot.x, bottom);
        g2x.dispose();
    }

    @Override
    public LonLatEdges getBounds() {
        double llLeft = this.lambdaC_ - 0.5 * this.widthDeg_;
        double llRight = this.lambdaC_ + 0.5 * this.widthDeg_;
        return new LonLatEdges(llLeft, this.topLat_, llRight, this.botLat_);
    }
}

