/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.math.Circles;
import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Stroke;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class ProjGraphicUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final double VERY_SMALL_VALUE = 1.0E-8;

    static final void drawRect(Graphics2D g2d, double x, double y, double width, double height) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        Rectangle2D.Double rect = new Rectangle2D.Double(x, y, width, height);
        g2d.draw(rect);
    }

    static final void drawRectBorder(Graphics2D g2d, double x, double y, double width, double height) {
        BasicStroke bstroke;
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        Graphics2D g2x = (Graphics2D)g2d.create();
        Stroke oldstroke = g2x.getStroke();
        if (oldstroke instanceof BasicStroke && ((bstroke = (BasicStroke)oldstroke).getLineJoin() != 0 || bstroke.getEndCap() != 2)) {
            g2x.setStroke(ProjGraphicUtils.getSquareMiterStroke(bstroke.getLineWidth()));
        }
        ProjGraphicUtils.drawRect(g2x, x, y, width, height);
        g2x.dispose();
    }

    static final void drawEllipse(Graphics2D g2d, double centerX, double centerY, double wRadius, double hRadius) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        Graphics2D g2x = (Graphics2D)g2d.create();
        g2x.translate(centerX, centerY);
        g2x.draw(new Ellipse2D.Double(-wRadius, -hRadius, 2.0 * wRadius, 2.0 * hRadius));
        g2x.dispose();
    }

    static final ArrayList<Point2D.Double> drawCroppedLine(Graphics2D g2d, AbstractProjection proj, Point2D.Double dot1, Point2D.Double dot2) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        return ProjGraphicUtils.drawCroppedLine(g2d, proj.getMarginRect0(), dot1, dot2);
    }

    static final ArrayList<Point2D.Double> drawCroppedLine(Graphics2D g2d, Rectangle2D.Double cropRect, Point2D.Double dot1, Point2D.Double dot2) {
        if (!new Line2D.Double(dot1, dot2).intersects(cropRect)) {
            return null;
        }
        if (cropRect.contains(dot1) && cropRect.contains(dot2)) {
            GraphicUtils.drawLine(g2d, dot1, dot2);
            return null;
        }
        double x1 = dot1.x;
        double y1 = dot1.y;
        double x2 = dot2.x;
        double y2 = dot2.y;
        double lMargin = cropRect.x;
        double tMargin = cropRect.y;
        double rMargin = cropRect.x + cropRect.width;
        double bMargin = cropRect.y + cropRect.height;
        if (x1 < lMargin && x2 < lMargin || x1 > rMargin && x2 > rMargin || y1 < tMargin && y2 < tMargin || y1 > bMargin && y2 > bMargin) {
            LOGGER.trace("Redundant test actually checked, and is true!");
            return null;
        }
        if (Math.abs(x2 - x1) < 1.0E-8) {
            if (y1 < tMargin) {
                y1 = tMargin;
            } else if (y1 > bMargin) {
                y1 = bMargin;
            }
            if (y2 < tMargin) {
                y2 = tMargin;
            } else if (y2 > bMargin) {
                y2 = bMargin;
            }
        } else if (Math.abs(y2 - y1) < 1.0E-8) {
            if (x1 < lMargin) {
                x1 = lMargin;
            } else if (x1 > rMargin) {
                x1 = rMargin;
            }
            if (x2 > rMargin) {
                x2 = rMargin;
            } else if (x2 < lMargin) {
                x2 = lMargin;
            }
        } else {
            double slope = (y2 - y1) / (x2 - x1);
            if (!cropRect.contains(x1, y1)) {
                if (x1 < lMargin) {
                    y1 = slope * (lMargin - x2) + y2;
                    x1 = lMargin;
                } else if (x1 > rMargin) {
                    y1 = slope * (rMargin - x2) + y2;
                    x1 = rMargin;
                }
                if (y1 < tMargin) {
                    x1 = (tMargin - y1) / slope + x1;
                    y1 = tMargin;
                } else if (y1 > bMargin) {
                    x1 = (bMargin - y1) / slope + x1;
                    y1 = bMargin;
                }
            }
            if (!cropRect.contains(x2, y2)) {
                if (x2 > rMargin) {
                    y2 = slope * (rMargin - x1) + y1;
                    x2 = rMargin;
                } else if (x2 < lMargin) {
                    y2 = slope * (lMargin - x1) + y1;
                    x2 = lMargin;
                }
                if (y2 < tMargin) {
                    x2 = (tMargin - y2) / slope + x2;
                    y2 = tMargin;
                } else if (y2 > bMargin) {
                    x2 = (bMargin - y2) / slope + x2;
                    y2 = bMargin;
                }
            }
        }
        if (Math.abs(x2 - x1) < 1.0E-5 && Math.abs(y2 - y1) < 1.0E-5) {
            return null;
        }
        GraphicUtils.drawLine(g2d, x1, y1, x2, y2);
        ArrayList<Point2D.Double> cropPts = new ArrayList<Point2D.Double>(2);
        if (x1 != dot1.x || y1 != dot1.y) {
            cropPts.add(new Point2D.Double(x1, y1));
        }
        if (x2 != dot2.x || y2 != dot2.y) {
            cropPts.add(new Point2D.Double(x2, y2));
        }
        return cropPts;
    }

    static final void drawBezier(Graphics2D g2d, Point2D.Double ... points) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        ArrayList<Point2D.Double> segment = new ArrayList<Point2D.Double>(points.length);
        Point2D.Double prevPt = null;
        for (Point2D.Double point : points) {
            if (point == null) {
                if (prevPt != null) {
                    ProjGraphicUtils.drawBezier(g2d, segment);
                    segment.clear();
                }
                prevPt = null;
                continue;
            }
            segment.add(point);
            prevPt = new Point2D.Double(point.x, point.y);
        }
        ProjGraphicUtils.drawBezier(g2d, segment);
    }

    static final void drawBezier(Graphics2D g2d, ArrayList<Point2D.Double> points) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        if (points.size() < 2) {
            return;
        }
        Point2D.Double first = points.get(0);
        Point2D.Double last = points.get(points.size() - 1);
        boolean closed = first.x == last.x && first.y == last.y;
        Bezier b = new Bezier(closed, points);
        if (b != null) {
            b.draw(g2d);
        }
    }

    static final ArrayList<Point2D.Double> drawCroppedCircularArc(Graphics2D g2d, AbstractProjection proj, Point2D.Double dot1, Point2D.Double dot2, Point2D.Double dot3) {
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        return ProjGraphicUtils.drawCroppedCircularArc(g2d, proj.getMarginRect0(), dot1, dot2, dot3);
    }

    static final ArrayList<Point2D.Double> drawCroppedCircularArc(Graphics2D g2d, Rectangle2D.Double marginRect, Point2D.Double dot1, Point2D.Double dot2, Point2D.Double dot3) {
        double dy;
        double dx;
        double dx2;
        double dy2;
        Objects.requireNonNull(g2d, "Graphics object cannot be null");
        double x1 = dot1.x;
        double y1 = dot1.y;
        double x2 = dot2.x;
        double y2 = dot2.y;
        double x3 = dot3.x;
        double y3 = dot3.y;
        double lMargin = marginRect.x;
        double tMargin = marginRect.y;
        double rMargin = marginRect.x + marginRect.width;
        double bMargin = marginRect.y + marginRect.height;
        if (y1 <= tMargin && y2 <= tMargin && y3 <= tMargin || y1 >= bMargin && y2 >= bMargin && y3 >= bMargin || x1 <= lMargin && x2 <= lMargin && x3 <= lMargin || x1 >= rMargin && x2 >= rMargin && x3 >= rMargin) {
            return null;
        }
        Point2D.Double dot0 = Circles.getCenter(dot1, dot2, dot3);
        if (dot0 == null) {
            ProjGraphicUtils.drawCroppedLine(g2d, marginRect, dot1, dot3);
            return null;
        }
        double x0 = dot0.x;
        double y0 = dot0.y;
        double dx1 = x1 - x0;
        double dy1 = y1 - y0;
        double r2 = dx1 * dx1 + dy1 * dy1;
        double radius = Math.sqrt(r2);
        Arc2D.Double arc = Circles.getArc(x1, y1, x2, y2, x3, y3);
        Rectangle2D arcRect = arc.getBounds2D();
        if (marginRect.contains(arc.getBounds2D())) {
            g2d.draw(arc);
            return null;
        }
        if (!marginRect.intersects(arcRect)) {
            return null;
        }
        double arcStart = arc.getAngleStart();
        double arcExtent = arc.getAngleExtent();
        double arcEnd = arcStart + arcExtent;
        if (arcExtent < 0.0) {
            arcStart += arcExtent;
            arcExtent = -arcExtent;
            arcEnd = arcStart + arcExtent;
        }
        ArrayList<Point2D.Double> crossPts = new ArrayList<Point2D.Double>(9);
        if (Math.abs(y0 - tMargin) <= radius) {
            dy2 = y0 - tMargin;
            dx2 = Math.sqrt(r2 - dy2 * dy2);
            double trx = x0 + dx2;
            double tlx = x0 - dx2;
            if (trx >= lMargin && trx <= rMargin) {
                crossPts.add(new Point2D.Double(trx, tMargin));
            }
            if (tlx >= lMargin && tlx <= rMargin) {
                crossPts.add(new Point2D.Double(tlx, tMargin));
            }
        }
        if (Math.abs(x0 - lMargin) <= radius) {
            dx = x0 - lMargin;
            dy = Math.sqrt(r2 - dx * dx);
            double lty = y0 - dy;
            double lby = y0 + dy;
            if (lty >= tMargin && lty <= bMargin) {
                crossPts.add(new Point2D.Double(lMargin, lty));
            }
            if (lby >= tMargin && lby <= bMargin) {
                crossPts.add(new Point2D.Double(lMargin, lby));
            }
        }
        if (Math.abs(y0 - bMargin) <= radius) {
            dy2 = y0 - bMargin;
            dx2 = Math.sqrt(r2 - dy2 * dy2);
            double blx = x0 - dx2;
            double brx = x0 + dx2;
            if (blx >= lMargin && blx <= rMargin) {
                crossPts.add(new Point2D.Double(blx, bMargin));
            }
            if (brx >= lMargin && brx <= rMargin) {
                crossPts.add(new Point2D.Double(brx, bMargin));
            }
        }
        if (Math.abs(x0 - rMargin) <= radius) {
            dx = x0 - rMargin;
            dy = Math.sqrt(r2 - dx * dx);
            double rby = y0 + dy;
            double rty = y0 - dy;
            if (rby >= tMargin && rby <= bMargin) {
                crossPts.add(new Point2D.Double(rMargin, rby));
            }
            if (rty >= tMargin && rty <= bMargin) {
                crossPts.add(new Point2D.Double(rMargin, rty));
            }
        }
        Arc2D.Double segment = new Arc2D.Double();
        for (int i = 0; i < crossPts.size(); ++i) {
            Point2D.Double midpt;
            double crossAngle;
            int prev = i > 0 ? i - 1 : crossPts.size() - 1;
            Point2D.Double thisCross = crossPts.get(i);
            Point2D.Double prevCross = crossPts.get(prev);
            double crossRad = Math.atan2(-(thisCross.y - y0), thisCross.x - x0);
            double prevRad = Math.atan2(-(prevCross.y - y0), prevCross.x - x0);
            double prevAngle = Math.toDegrees(prevRad);
            for (crossAngle = Math.toDegrees(crossRad); crossAngle < 0.0; crossAngle += 360.0) {
            }
            while (prevAngle < 0.0) {
                prevAngle += 360.0;
            }
            if (crossAngle - prevAngle < 0.0) {
                crossAngle += 360.0;
            }
            if (arc.containsAngle(crossAngle)) {
                if (arc.containsAngle(prevAngle)) {
                    midpt = ProjGraphicUtils.getPointAtRadiusAndAngle(x0, y0, radius, 0.5 * (crossAngle + prevAngle));
                    if (!marginRect.contains(midpt.x, midpt.y)) continue;
                    segment.setArcByCenter(x0, y0, radius, prevAngle, crossAngle - prevAngle, 0);
                    g2d.draw(segment);
                    continue;
                }
                if (!(prevAngle < arcStart)) continue;
                midpt = ProjGraphicUtils.getPointAtRadiusAndAngle(x0, y0, radius, 0.5 * (crossAngle + arcStart));
                if (!marginRect.contains(midpt.x, midpt.y)) continue;
                segment.setArcByCenter(x0, y0, radius, arcStart, crossAngle - arcStart, 0);
                g2d.draw(segment);
                continue;
            }
            if (!(crossAngle > arcEnd) || !arc.containsAngle(prevAngle)) continue;
            midpt = ProjGraphicUtils.getPointAtRadiusAndAngle(x0, y0, radius, 0.5 * (arcEnd + prevAngle));
            if (!marginRect.contains(midpt.x, midpt.y)) continue;
            segment.setArcByCenter(x0, y0, radius, prevAngle, arcEnd - prevAngle, 0);
            g2d.draw(segment);
        }
        return crossPts;
    }

    private static Point2D.Double getPointAtRadiusAndAngle(double x0, double y0, double radius, double angle) {
        double angleRad = Math.toRadians(angle);
        double x = x0 + radius * Math.cos(angleRad);
        double y = y0 - radius * Math.sin(angleRad);
        return new Point2D.Double(x, y);
    }

    static BasicStroke getSquareMiterStroke(Stroke ostroke) {
        return ProjGraphicUtils.getSquareMiterStroke(((BasicStroke)ostroke).getLineWidth());
    }

    static BasicStroke getSquareMiterStroke(float width) {
        return new BasicStroke(width, 2, 0);
    }

    static BasicStroke getButtRoundStroke(Stroke ostroke) {
        return ProjGraphicUtils.getButtRoundStroke(((BasicStroke)ostroke).getLineWidth());
    }

    static BasicStroke getButtRoundStroke(float width) {
        return new BasicStroke(width, 0, 1);
    }

    private ProjGraphicUtils() {
    }
}

