/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.Bezier;
import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.MapUtils;
import gov.nasa.giss.map.proj.BiSymmetricProjection;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SolovevModifiedBonne
extends BiSymmetricProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Solov'ev Modified Bonne";
    public static final int PROPERTIES = 512;
    private static final double DEFAULT_PHI1 = 52.3;
    private static final double PHI1 = 52.3;
    private static final double PHI1_RAD = Math.toRadians(52.3);
    private static final double COT_PHI1 = 1.0 / Math.tan(PHI1_RAD);
    private static final double CONST_C1 = 1.02;
    private static final double CONST_C2 = 0.95;
    private static final double INV_C1 = 0.9803921568627451;
    private static final double INV_C2 = 1.0526315789473684;
    private static final double CENTER_LON = 90.0;
    private static final double MAX_DLAMBDA = 110.0;
    private static final double MAX_DLAMBDA_RAD = Math.toRadians(110.0);
    private static final double ALMOST_MAX_DLAMBDA = 109.99999;
    private static final double C2_MAX_DLAMBDA_RAD = 0.95 * MAX_DLAMBDA_RAD;
    private static final double MIN_PHI = 30.0;
    private static final double MIN_PHI_RAD;
    private static final double LAT_OF_MAX_Y;
    private static final double MAX_X_OVER_RS;
    private static final double MAX_Y_OVER_RS;
    private static final double Y_SHIFT;
    private double outCenterYShift_;

    public SolovevModifiedBonne(int width, int height) {
        this(width, height, 0, 0);
    }

    public SolovevModifiedBonne(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 512, width, height, xmargin, ymargin, MAX_X_OVER_RS, MAX_Y_OVER_RS);
        this.finishConstruction();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(90.0, lat);
    }

    @Override
    public boolean isRecenterableLon() {
        return false;
    }

    @Override
    public boolean isRecenterableLat() {
        return false;
    }

    @Override
    protected final void finishScaling() {
        this.outCenterYShift_ = (double)this.outCenterY_ - Y_SHIFT * this.rS_;
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (lat < 30.0) {
            return null;
        }
        double phiRad = Math.toRadians(lat);
        double rhoRad = COT_PHI1 + 1.02 * (PHI1_RAD - phiRad);
        if (Math.abs(rhoRad) < 1.0E-5) {
            return new Point2D.Double(this.outCenterX_, this.outCenterYShift_);
        }
        double lambda = MapUtils.normalizeMP180(lon - 90.0);
        if (Math.abs(lambda) > 110.0) {
            return null;
        }
        double lambdaRad = Math.toRadians(lambda);
        double thetaRad = 0.95 * lambdaRad * Math.cos(phiRad) / rhoRad;
        double x = rhoRad * Math.sin(thetaRad);
        double y = COT_PHI1 - rhoRad * Math.cos(thetaRad) + Y_SHIFT;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double x = xx - (double)this.outCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (Math.abs(x) > (double)this.dxMax_ || Math.abs(y) > (double)this.dyMax_) {
            return null;
        }
        double xOverRS = x * this.invRS_;
        double yOverRS = y * this.invRS_ - Y_SHIFT;
        double y1 = COT_PHI1 - yOverRS;
        double pmFac = 1.0;
        double rhoRad = 1.0 * Math.hypot(xOverRS, y1);
        double phiRad = (COT_PHI1 - rhoRad) * 0.9803921568627451 + PHI1_RAD;
        if (Math.abs(phiRad) > 1.5707963267948966) {
            return null;
        }
        double thetaRad = Math.atan2(1.0 * xOverRS, 1.0 * y1);
        double lambdaRad = thetaRad * rhoRad * 1.0526315789473684 / Math.cos(phiRad);
        if (Math.abs(lambdaRad) > Math.PI) {
            return null;
        }
        double lambda = Math.toDegrees(lambdaRad);
        if (Math.abs(lambda) > 110.0) {
            return null;
        }
        double phi = Math.toDegrees(phiRad);
        if (phi < 30.0) {
            return null;
        }
        return new PointLL(90.0 + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        SolovevModifiedBonne solovevModifiedBonne = this;
        synchronized (solovevModifiedBonne) {
            double pmFac = 1.0;
            block3: for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverRS = y * this.invRS_ - Y_SHIFT;
                double y1 = COT_PHI1 - yOverRS;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double xOverRS = x * this.invRS_;
                    double rhoRad = 1.0 * Math.hypot(xOverRS, y1);
                    double phiRad = (COT_PHI1 - rhoRad) * 0.9803921568627451 + PHI1_RAD;
                    if (Math.abs(phiRad) > 1.5707963267948966) continue;
                    double thetaRad = Math.atan2(1.0 * xOverRS, 1.0 * y1);
                    double lambdaRad = thetaRad * rhoRad * 1.0526315789473684 / Math.cos(phiRad);
                    double lambda = Math.toDegrees(lambdaRad);
                    double phi = Math.toDegrees(phiRad);
                    if (lambda > 110.0) {
                        if (!(Math.abs(52.3) < 11.5232593818)) continue;
                        continue block3;
                    }
                    if (phi < 30.0) continue;
                    this.setInvPoints(ix, iy, lambda, phi);
                }
            }
        }
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        Bezier bcurve = this.makeMeridianBezier(199.99999, 90.0);
        if (bcurve != null) {
            bcurve.draw(g2d);
        }
        if ((bcurve = this.makeMeridianBezier(-19.999989999999997, 90.0)) != null) {
            bcurve.draw(g2d);
        }
        double lon1 = -19.999989999999997;
        double lon2 = 90.0;
        double lon3 = 199.99999;
        Point2D.Double dot1 = this.transformLL2XY(-19.999989999999997, 30.0);
        Point2D.Double dot2 = this.transformLL2XY(90.0, 30.0);
        Point2D.Double dot3 = this.transformLL2XY(199.99999, 30.0);
        if (dot1 == null || dot2 == null || dot3 == null) {
            return;
        }
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (lat <= 30.0) {
            return;
        }
        double lon1 = -19.999989999999997;
        double lon2 = 90.0;
        double lon3 = 199.99999;
        Point2D.Double dot1 = this.transformLL2XY(-19.999989999999997, lat);
        Point2D.Double dot2 = this.transformLL2XY(90.0, lat);
        Point2D.Double dot3 = this.transformLL2XY(199.99999, lat);
        if (dot1 == null || dot2 == null || dot3 == null) {
            return;
        }
        GraphicUtils.drawCircularArc(g2d, dot1, dot2, dot3);
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        double dlon = MapUtils.normalize360(lon - 90.0);
        if (Math.abs(dlon - 180.0) < 1.0E-5) {
            return;
        }
        try {
            Bezier bcurve = this.makeMeridianBezier(lon, maxLat);
            if (bcurve != null) {
                bcurve.draw(g2d);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private Bezier makeMeridianBezier(double lon, double maxLat) {
        Point2D.Double dot;
        ArrayList<Point2D.Double> ptlist = new ArrayList<Point2D.Double>(400);
        double lat = 20.0;
        while (lat < maxLat) {
            double absLat;
            dot = this.transformLL2XY(lon, lat);
            if (dot != null) {
                ptlist.add(new Point2D.Double(dot.x, dot.y));
            }
            if ((absLat = Math.abs(lat)) >= maxLat - 1.0) {
                lat += 0.1;
                continue;
            }
            if (absLat >= 85.0) {
                lat += 0.25;
                continue;
            }
            lat += 0.5;
        }
        dot = this.transformLL2XY(lon, maxLat);
        ptlist.add(new Point2D.Double(dot.x, dot.y));
        return new Bezier(false, ptlist);
    }

    private static double latitudeOfLobeMaxY() {
        double drhoRad = -1.02;
        double phiRad = Math.toRadians(60.0);
        for (int iter = 0; iter < 33; ++iter) {
            double sinPhi = Math.sin(phiRad);
            double cosPhi = Math.cos(phiRad);
            double rhoRad = COT_PHI1 + 1.02 * (PHI1_RAD - phiRad);
            double rhoRad2 = rhoRad * rhoRad;
            double thetaRad = C2_MAX_DLAMBDA_RAD * cosPhi / rhoRad;
            double sinTheta = Math.sin(thetaRad);
            double cosTheta = Math.cos(thetaRad);
            double dthetaRad = -C2_MAX_DLAMBDA_RAD * sinPhi / rhoRad + thetaRad * 1.02 / rhoRad;
            double d2thetaRad = -C2_MAX_DLAMBDA_RAD * cosPhi / rhoRad + C2_MAX_DLAMBDA_RAD * sinPhi * -1.02 / rhoRad2 + dthetaRad * 1.02 / rhoRad + thetaRad * 1.02 * 1.02 / rhoRad2;
            double dsinTheta = cosTheta * dthetaRad;
            double dcosTheta = -sinTheta * dthetaRad;
            double d2cosTheta = -(dsinTheta * dthetaRad + sinTheta * d2thetaRad);
            double func = 1.02 * cosTheta - rhoRad * dcosTheta;
            double dfunc = 1.02 * dcosTheta - -1.02 * dcosTheta - rhoRad * d2cosTheta;
            double dphiRad = -func / dfunc;
            phiRad += dphiRad;
            if (Math.abs(dphiRad) < 1.0E-8) break;
        }
        return Math.toDegrees(phiRad);
    }

    static {
        double phiRad = MIN_PHI_RAD = Math.toRadians(30.0);
        double rhoRad = COT_PHI1 + 1.02 * (PHI1_RAD - phiRad);
        double thetaRad = C2_MAX_DLAMBDA_RAD * Math.cos(phiRad) / rhoRad;
        MAX_X_OVER_RS = rhoRad * Math.sin(thetaRad);
        LAT_OF_MAX_Y = SolovevModifiedBonne.latitudeOfLobeMaxY();
        double phiRad2 = Math.toRadians(LAT_OF_MAX_Y);
        double rhoRad2 = COT_PHI1 + 1.02 * (PHI1_RAD - phiRad2);
        double thetaRad2 = C2_MAX_DLAMBDA_RAD * Math.cos(phiRad2) / rhoRad2;
        double yTop = COT_PHI1 - rhoRad2 * Math.cos(thetaRad2);
        phiRad2 = MIN_PHI_RAD;
        rhoRad2 = COT_PHI1 + 1.02 * (PHI1_RAD - phiRad2);
        double yBot = COT_PHI1 - rhoRad2;
        MAX_Y_OVER_RS = 0.5 * Math.abs(yTop - yBot);
        Y_SHIFT = -0.5 * (yTop + yBot);
    }
}

