/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.graphics.GraphicUtils;
import gov.nasa.giss.map.LonLatRotator;
import gov.nasa.giss.map.proj.AbstractProjection;
import gov.nasa.giss.map.proj.ProjDoubleParameter;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjGraphicUtils;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.geom.Point2D;

public abstract class TwoHemisphereAzimuthalProjection
extends AbstractProjection {
    public static final int PROPERTIES = 44040256;
    private final double radiusFactor_;
    protected double rhoBorder_;
    protected double rhoBorder2_;
    protected int leftCenterX_;
    protected int rightCenterX_;
    private double leftLambdaC_;
    private double leftPhiC_;
    private double rightLambdaC_;
    private double rightPhiC_;
    private double sinLeftPhiC_;
    private double cosLeftPhiC_;
    private final ProjDoubleParameter rotateParam_;
    private double thirdRotation_;
    private final LonLatRotator leftRotMatrices_;
    private final LonLatRotator rightRotMatrices_;

    public TwoHemisphereAzimuthalProjection(String name, int properties, int width, int height, int xmargin, int ymargin, double rMaxOverR) {
        super(name, properties, width, height, xmargin, ymargin, 2.04 * rMaxOverR, rMaxOverR);
        this.rotateParam_ = new ProjDoubleParameter("Azimuth (clockwise)", "Azimuth", "\u00b0", this.thirdRotation_, -360.0, 360.0, true, true);
        this.addParameter(this.rotateParam_);
        this.radiusFactor_ = rMaxOverR;
        this.leftRotMatrices_ = new LonLatRotator();
        this.rightRotMatrices_ = new LonLatRotator();
        this.setCenter(this.lambdaC_, this.phiC_);
        this.autoscale();
    }

    @Override
    public void setCenter(double lon, double lat) {
        super.setCenter(lon, lat);
        this.leftLambdaC_ = lon;
        this.leftPhiC_ = lat;
        this.rightLambdaC_ = lon + 180.0;
        this.rightPhiC_ = -lat;
        double leftPhiCRad = Math.toRadians(this.leftPhiC_);
        this.sinLeftPhiC_ = Math.sin(leftPhiCRad);
        this.cosLeftPhiC_ = Math.cos(leftPhiCRad);
        this.setPlagalRotation(this.thirdRotation_);
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.rotateParam_)) {
            this.setPlagalRotation(this.rotateParam_.getValue());
        }
    }

    private void setPlagalRotation(double angle) {
        this.thirdRotation_ = angle;
        if (this.leftRotMatrices_ != null) {
            this.leftRotMatrices_.setAngles(this.leftLambdaC_, this.leftPhiC_, this.thirdRotation_);
            this.rightRotMatrices_.setAngles(this.rightLambdaC_, this.rightPhiC_, -this.thirdRotation_);
        }
    }

    @Override
    protected final void finishScaling() {
        this.rhoBorder_ = this.radiusFactor_ * this.rS_;
        this.rhoBorder2_ = this.rhoBorder_ * this.rhoBorder_;
        Insets ins = this.getInsets();
        this.leftCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + ins.left));
        this.rightCenterX_ = (int)(0.5 * (double)(this.outCenterX_ + this.getWidth() - ins.right));
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        double leftLambdaRad = Math.toRadians(lon - this.leftLambdaC_);
        double phiRad = Math.toRadians(lat);
        double cosZ = this.sinLeftPhiC_ * Math.sin(phiRad) + this.cosLeftPhiC_ * Math.cos(phiRad) * Math.cos(leftLambdaRad);
        boolean leftside = cosZ >= 0.0;
        double[] llP = leftside ? this.leftRotMatrices_.rotate(lon, lat) : this.rightRotMatrices_.rotate(lon, lat);
        double lambdaPRad = Math.toRadians(llP[0]);
        double phiPRad = Math.toRadians(llP[1]);
        double cosPhiP = Math.cos(phiPRad);
        double sinPhiP = Math.sin(phiPRad);
        double k = this.getKForLambdaPPhiP(lambdaPRad, phiPRad);
        double x = k > 0.0 ? k * cosPhiP * Math.sin(lambdaPRad) : 0.0;
        double y = k > 0.0 ? k * sinPhiP : 0.0;
        x = leftside ? (double)this.leftCenterX_ + x * this.rS_ : (double)this.rightCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    protected abstract double getKForLambdaPPhiP(double var1, double var3);

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        boolean leftside = xx < (double)this.outCenterX_;
        double x = leftside ? xx - (double)this.leftCenterX_ : xx - (double)this.rightCenterX_;
        double y = (double)this.outCenterY_ - yy;
        if (x == 0.0 && y == 0.0) {
            if (leftside) {
                return this.getCenter();
            }
            return new PointLL(this.rightLambdaC_, this.rightPhiC_);
        }
        double rho2 = x * x + y * y;
        if (rho2 > this.rhoBorder2_) {
            return null;
        }
        double rho = Math.sqrt(rho2);
        double z = this.getZRadForRho(rho);
        double sinZ = Math.sin(z);
        double cosZ = Math.cos(z);
        double lambdaPRad = Math.atan2(x * sinZ, rho * cosZ);
        double phiPRad = Math.asin(y * sinZ / rho);
        double lambdaP = Math.toDegrees(lambdaPRad);
        double phiP = Math.toDegrees(phiPRad);
        double[] ll = leftside ? this.leftRotMatrices_.inverse(lambdaP, phiP) : this.rightRotMatrices_.inverse(lambdaP, phiP);
        return new PointLL(ll[0], ll[1]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        TwoHemisphereAzimuthalProjection twoHemisphereAzimuthalProjection = this;
        synchronized (twoHemisphereAzimuthalProjection) {
            for (int iy = -this.dyMax_; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double y2 = y * y;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double x = (double)ix + 0.5;
                    double rho2 = x * x + y2;
                    if (rho2 > this.rhoBorder2_) continue;
                    double rho = Math.sqrt(rho2);
                    double z = this.getZRadForRho(rho);
                    double sinZ = Math.sin(z);
                    double cosZ = Math.cos(z);
                    double phiPRad = Math.asin(y * sinZ / rho);
                    double lambdaPRad = Math.atan2(x * sinZ, rho * cosZ);
                    double phiP = Math.toDegrees(phiPRad);
                    double lambdaP = Math.toDegrees(lambdaPRad);
                    this.setInvPoints(ix, iy, lambdaP, phiP);
                }
            }
        }
    }

    protected abstract double getZRadForRho(double var1);

    protected void setInvPoints(int ix, int iy, double lambdaP, double phiP) {
        double[] llTR = this.leftRotMatrices_.inverse(lambdaP, phiP);
        double[] llBR = this.leftRotMatrices_.inverse(lambdaP, -phiP);
        double[] llBL = this.leftRotMatrices_.inverse(-lambdaP, -phiP);
        double[] llTL = this.leftRotMatrices_.inverse(-lambdaP, phiP);
        this.setInvPoint(true, ix, iy, llTR[0], llTR[1]);
        this.setInvPoint(true, ix, -iy - 1, llBR[0], llBR[1]);
        this.setInvPoint(true, -ix - 1, -iy - 1, llBL[0], llBL[1]);
        this.setInvPoint(true, -ix - 1, iy, llTL[0], llTL[1]);
        llTR = this.rightRotMatrices_.inverse(lambdaP, phiP);
        llBR = this.rightRotMatrices_.inverse(lambdaP, -phiP);
        llBL = this.rightRotMatrices_.inverse(-lambdaP, -phiP);
        llTL = this.rightRotMatrices_.inverse(-lambdaP, phiP);
        this.setInvPoint(false, ix, iy, llTR[0], llTR[1]);
        this.setInvPoint(false, ix, -iy - 1, llBR[0], llBR[1]);
        this.setInvPoint(false, -ix - 1, -iy - 1, llBL[0], llBL[1]);
        this.setInvPoint(false, -ix - 1, iy, llTL[0], llTL[1]);
    }

    private void setInvPoint(boolean leftside, int ix, int iy, double lon, double lat) {
        int col = leftside ? this.leftCenterX_ + ix : this.rightCenterX_ + ix;
        int row = this.outCenterY_ - iy - 1;
        this.setInverseArrayLocation(col, row, lon, lat);
    }

    @Override
    protected void drawBorderLines(Graphics2D g2d) {
        ProjGraphicUtils.drawEllipse(g2d, this.leftCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
        ProjGraphicUtils.drawEllipse(g2d, this.rightCenterX_, this.outCenterY_, this.rhoBorder_, this.rhoBorder_);
    }

    @Override
    protected void drawParallel(Graphics2D g2d, double lat, String label) {
        if (Math.abs(this.phiC_) > 89.99999) {
            Point2D.Double dot;
            if (Math.abs(lat) < 1.0E-5) {
                return;
            }
            if (lat < 0.0) {
                return;
            }
            Point2D.Double double_ = dot = this.phiC_ > 89.99999 ? this.transformLL2XYIgnoreMargins(this.lambdaC_, lat) : this.transformLL2XYIgnoreMargins(this.lambdaC_, -lat);
            if (dot == null) {
                return;
            }
            double r = Math.hypot((double)this.leftCenterX_ - dot.x, (double)this.outCenterY_ - dot.y);
            ProjGraphicUtils.drawEllipse(g2d, this.leftCenterX_, this.outCenterY_, r, r);
            ProjGraphicUtils.drawEllipse(g2d, this.rightCenterX_, this.outCenterY_, r, r);
        } else {
            super.drawParallel(g2d, lat, label);
        }
    }

    @Override
    protected void drawMeridian(Graphics2D g2d, double lon, double maxLat, String label) {
        if (this.phiC_ > 89.99999 || this.phiC_ < -89.99999) {
            Point2D.Double dotN = this.transformLL2XYIgnoreMargins(lon, maxLat);
            Point2D.Double dotS = this.transformLL2XYIgnoreMargins(lon, -maxLat);
            Point2D.Double dotEN = this.transformLL2XYIgnoreMargins(lon, 1.0E-5);
            Point2D.Double dotES = this.transformLL2XYIgnoreMargins(lon, -1.0E-5);
            GraphicUtils.drawLine(g2d, dotN, dotEN);
            GraphicUtils.drawLine(g2d, dotS, dotES);
        } else {
            super.drawMeridian(g2d, lon, maxLat, label);
        }
    }
}

