/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.map.proj;

import gov.nasa.giss.map.proj.ConcavePoleProjection;
import gov.nasa.giss.map.proj.ProjExtraParameter;
import gov.nasa.giss.map.proj.ProjListEnum;
import gov.nasa.giss.map.proj.ProjListParameter;
import gov.nasa.giss.map.proj.ProjParameterEvent;
import gov.nasa.giss.math.PointLL;
import java.awt.geom.Point2D;
import java.lang.invoke.MethodHandles;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Wagner9
extends ConcavePoleProjection {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String PROJECTION_NAME = "Wagner IX";
    public static final int PROPERTIES = 262176;
    private ProjListParameter variantParam_ = new ProjListParameter("Variant", "Variant", Variant.class, 0);
    private Variant variant_;
    private double mm_;
    private double nn_;
    private double invM_;
    private double invN_;
    private double ca_;
    private double cx_;
    private double cy_;
    private double invCa_;
    private double invCx_;
    private double invCy_;

    public Wagner9(int width, int height) {
        this(width, height, 0, 0);
    }

    public Wagner9(int width, int height, int xmargin, int ymargin) {
        super(PROJECTION_NAME, 262176, width, height, xmargin, ymargin, 2.0, 1.0);
        this.addParameter(this.variantParam_);
        this.finishConstruction();
    }

    @Override
    public void parameterChanged(ProjParameterEvent e) {
        ProjExtraParameter p;
        ProjExtraParameter projExtraParameter = p = e == null ? null : (ProjExtraParameter)e.getSource();
        if (p == null || p.equals(this.variantParam_)) {
            int varIndex = this.variantParam_.getIndex();
            this.variant_ = Variant.values()[varIndex];
            LOGGER.trace("variant {}", (Object)this.variant_);
        } else {
            LOGGER.debug("Event source does not match a projection parameter.");
        }
        this.autoscale();
    }

    @Override
    protected final void prepareScaling() {
        this.mm_ = this.variant_.getCM();
        this.nn_ = this.variant_.getCN();
        this.ca_ = this.variant_.getCA();
        this.cx_ = this.variant_.getCX();
        this.cy_ = this.variant_.getCY();
        this.invM_ = 1.0 / this.mm_;
        this.invN_ = 1.0 / this.nn_;
        this.invCa_ = 1.0 / this.ca_;
        this.invCx_ = 1.0 / this.cx_;
        this.invCy_ = 1.0 / this.cy_;
        double cosTerm = Math.cos(this.mm_ * 1.5707963267948966) * Math.cos(this.nn_ * Math.PI);
        double wfactor = this.ca_ * this.cx_ * this.nn_ * Math.PI;
        double hfactor = this.cy_ * Math.acos(cosTerm) * Math.sin(this.mm_ * 1.5707963267948966) / Math.sqrt(1.0 - cosTerm * cosTerm);
        this.setMaxXYOverRS(wfactor, hfactor);
    }

    @Override
    protected final Point2D.Double transformLL2XYIgnoreMargins(double lon, double lat) {
        if (Math.abs(lat) < 1.0E-10) {
            double x = this.ca_ * this.cx_ * this.nn_ * this.lonToLambdaRad(lon);
            return new Point2D.Double((double)this.outCenterX_ + x * this.rS_, this.outCenterY_);
        }
        double lambdaRad = this.lonToLambdaRad(lon);
        double phiRad = Math.toRadians(lat);
        if (Math.abs(lambdaRad) < 1.0E-10) {
            double y = this.cy_ * this.mm_ * phiRad;
            return new Point2D.Double(this.outCenterX_, (double)this.outCenterY_ - y * this.rS_);
        }
        double psiRad = this.mm_ * phiRad;
        double deltaRad = Math.acos(Math.cos(psiRad) * Math.cos(this.nn_ * lambdaRad));
        double x = 0.0;
        double y = 0.0;
        double cosAlpha = Math.sin(psiRad) / Math.sin(deltaRad);
        double sinAlpha = Math.sqrt(1.0 - cosAlpha * cosAlpha);
        x = this.cx_ * deltaRad * sinAlpha;
        y = this.cy_ * deltaRad * cosAlpha;
        if (lambdaRad < 0.0) {
            x *= -1.0;
        }
        x *= this.ca_;
        x = (double)this.outCenterX_ + x * this.rS_;
        y = (double)this.outCenterY_ - y * this.rS_;
        return new Point2D.Double(x, y);
    }

    @Override
    public PointLL transformXY2LL(double xx, double yy) {
        double lambdaRad;
        double phiRad;
        double absY;
        double xxx = xx - (double)this.outCenterX_;
        double yyy = (double)this.outCenterY_ - yy;
        if (Math.abs(xxx) > (double)this.dxMax_ || Math.abs(yyy) > (double)this.dyMax_) {
            return null;
        }
        double absX = Math.abs(xxx * this.invCa_);
        double deltaRad = Math.hypot(absX * this.invCx_, (absY = Math.abs(yyy)) * this.invCy_) * this.invRS_;
        if (deltaRad > 1.0E-5) {
            double yOverRS = absY * this.invRS_;
            double phiTerm = yOverRS * Math.sin(deltaRad) / (deltaRad * this.cy_);
            if (phiTerm > 1.0) {
                return null;
            }
            phiRad = Math.asin(phiTerm) * this.invM_;
            if (Math.abs(phiRad) > 1.5707963267948966) {
                return null;
            }
            double d = lambdaRad = phiRad == 1.5707963267948966 ? 0.0 : Math.acos(Math.cos(deltaRad) / Math.cos(this.mm_ * phiRad)) * this.invN_;
            if (Math.abs(lambdaRad) > Math.PI) {
                return null;
            }
        } else {
            phiRad = 0.0;
            lambdaRad = 0.0;
        }
        if (xxx < 0.0) {
            lambdaRad = -lambdaRad;
        }
        if (yyy < 0.0) {
            phiRad = -phiRad;
        }
        double lambda = Math.toDegrees(lambdaRad);
        double phi = Math.toDegrees(phiRad);
        return new PointLL(this.lambdaC_ + lambda, phi);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void calculateInverseArray() {
        Wagner9 wagner9 = this;
        synchronized (wagner9) {
            block3: for (int iy = 0; iy < this.dyMax_; ++iy) {
                double y = (double)iy + 0.5;
                double yOverCy = y * this.invCy_;
                double yOverRS = y * this.invRS_;
                for (int ix = 0; ix < this.dxMax_; ++ix) {
                    double lambdaRad;
                    double phiRad;
                    double xx = (double)ix + 0.5;
                    double x = xx * this.invCa_;
                    double deltaRad = Math.hypot(x * this.invCx_, yOverCy) * this.invRS_;
                    if (deltaRad > 1.0E-5) {
                        double phiTerm = yOverRS * Math.sin(deltaRad) / (deltaRad * this.cy_);
                        if (phiTerm > 1.0 || (phiRad = Math.asin(phiTerm) * this.invM_) > 1.5707963267948966) continue;
                        if (phiRad < 1.5707963267948966) {
                            lambdaRad = Math.acos(Math.cos(deltaRad) / Math.cos(this.mm_ * phiRad)) * this.invN_;
                            if (lambdaRad > Math.PI) {
                                continue block3;
                            }
                        } else {
                            lambdaRad = 0.0;
                        }
                    } else {
                        phiRad = 0.0;
                        lambdaRad = 0.0;
                    }
                    this.setInvPoints(ix, iy, Math.toDegrees(lambdaRad), Math.toDegrees(phiRad));
                }
            }
        }
    }

    private static enum Variant implements ProjListEnum
    {
        WAGNER9("Wagner IX", 70.0, 50.0, 200.0, 100.0),
        COMPRESSED("Wagner IX Compressed", 70.0, 50.0, 200.0, 88.0),
        CANTERSW09("Canters W09", 67.131, 86.562, 206.79, 80.748),
        GOTTWAGNER("Gott-Wagner", 60.0, 51.9615, 173.205, 100.0),
        FRANCULA4("Fran\u010dula IV", 73.0, 90.0, 269.0, 59.0),
        FRANCULA13("Fran\u010dula XIII", 62.0, 69.0, 220.0, 77.0);

        private String text_;
        private double varCm_;
        private double varCn_;
        private double varCa_;
        private double varCx_;
        private double varCy_;

        private Variant(String text, double psi1, double lambda1, double cp, double ca) {
            this.text_ = text;
            this.varCa_ = ca / 100.0;
            this.varCm_ = psi1 / 90.0;
            this.varCn_ = lambda1 / 180.0;
            double varK = Math.sqrt(cp / 100.0 * psi1 / lambda1);
            this.varCx_ = varK / Math.sqrt(this.varCm_ * this.varCn_);
            this.varCy_ = 1.0 / (varK * Math.sqrt(this.varCm_ * this.varCn_));
        }

        double getCM() {
            return this.varCm_;
        }

        double getCN() {
            return this.varCn_;
        }

        double getCA() {
            return this.varCa_;
        }

        double getCX() {
            return this.varCx_;
        }

        double getCY() {
            return this.varCy_;
        }

        public String toString() {
            return this.text_;
        }

        @Override
        public boolean matches(String str) {
            return this.nameMatches(str) || this.textMatches(str);
        }

        public boolean nameMatches(String str) {
            return this.name().equalsIgnoreCase(str);
        }

        public boolean textMatches(String str) {
            return this.text_.equalsIgnoreCase(str);
        }
    }
}

