/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.data.nc.NcDimension;
import gov.nasa.giss.panoply.dialog.PanExportAnimationDialog;
import gov.nasa.giss.panoply.io.PanFileUtils;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.task.PanExportAnimationTask;
import gov.nasa.giss.panoply.util.PanAnimationFormat;
import gov.nasa.giss.panoply.util.PanExportAnimationOption;
import gov.nasa.giss.panoply.util.PanProperties;
import gov.nasa.giss.util.task.TaskEvent;
import gov.nasa.giss.util.task.TaskListener;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.invoke.MethodHandles;
import java.util.Hashtable;
import javax.swing.AbstractAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanExportAnimationAction
extends AbstractAction
implements TaskListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    public static final String DOT = ".";
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("export-animation");
    private final PanPlotFrame parent_;
    private File file_;
    private String fnameRoot_;
    private NcDimension[] dimensions_;
    private PanExportAnimationTask exportTask_;
    private boolean animationInProgress_;

    public PanExportAnimationAction(PanPlotFrame parent) {
        super(ACTION_NAME);
        this.parent_ = parent;
    }

    public void cancel() {
        if (this.animationInProgress_) {
            this.exportTask_.cancel();
        } else {
            LOGGER.trace("No animation in progress for this frame.");
        }
    }

    public File getFile() {
        return this.file_;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        File file;
        PanPlotFrame.setControlWindoidsEnabled(false);
        this.parent_.setControlWindoidsVisible(false);
        PanExportAnimationDialog aod = new PanExportAnimationDialog(this.parent_);
        aod.setVisible(true);
        if (!aod.isSuccessful()) {
            PanPlotFrame.setControlWindoidsEnabled(true);
            this.parent_.setControlWindoidsVisible(true);
            return;
        }
        Hashtable<PanExportAnimationOption, Object> opts = aod.getOptions();
        this.dimensions_ = aod.getDimensions();
        aod.dispose();
        if (this.dimensions_.length == 2 && this.dimensions_[0] == null && this.dimensions_[1] == null) {
            LOGGER.trace("No animation dimension selected; this will be a single-frame movie.");
        }
        PanAnimationFormat format = (PanAnimationFormat)opts.get((Object)PanExportAnimationOption.FORMAT);
        String fnameExt = format.getExtension().toLowerCase();
        if (this.fnameRoot_ == null) {
            this.fnameRoot_ = this.parent_.getTitle();
        }
        if ((file = PanFileUtils.showSingleTypeSaveFileChooser(this.parent_, "Export animation as\u2026", this.fnameRoot_, fnameExt)) == null) {
            PanPlotFrame.setControlWindoidsEnabled(true);
            this.parent_.setControlWindoidsVisible(true);
            return;
        }
        this.file_ = file;
        this.exportTask_ = new PanExportAnimationTask(this.file_, this.parent_, this.dimensions_, opts);
        this.parent_.toFront();
        this.parent_.setAnimating(true);
        this.exportTask_.addTaskListener(this);
        this.setEnabled(false);
        this.animationInProgress_ = true;
        this.parent_.addTask(this.exportTask_);
    }

    @Override
    public void taskCommenced(TaskEvent e) {
        this.animationInProgress_ = true;
    }

    @Override
    public void taskCompleted(TaskEvent e) {
        this.animationInProgress_ = false;
        this.setEnabled(true);
    }

    @Override
    public void taskCanceled(TaskEvent e) {
        this.animationInProgress_ = false;
        this.setEnabled(true);
    }
}

