/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanToggleAutoscaleAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private static final String ACTION_NAME = PanProperties.MENU_PROPS.getString("autofit-scale");
    private final PanPlotMeta pmeta_;
    private boolean busy_;
    private long last_;

    public PanToggleAutoscaleAction(PanPlotMeta pmeta) {
        super(ACTION_NAME);
        this.pmeta_ = pmeta;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source;
        PanPlotFrame pframe = this.pmeta_.getFrame();
        if (pframe == null) {
            return;
        }
        if (this.busy_) {
            LOGGER.debug("busy");
            return;
        }
        this.busy_ = true;
        long now = System.currentTimeMillis();
        Object object = source = e == null ? null : e.getSource();
        if (now - this.last_ >= 200L) {
            if (source instanceof JCheckBoxMenuItem) {
                boolean oldval = this.pmeta_.getBoolean("scale.autofit");
                this.pmeta_.setBoolean("scale.autofit", !oldval);
            } else if (source instanceof JCheckBox) {
                boolean newval = ((JCheckBox)source).isSelected();
                this.pmeta_.setBoolean("scale.autofit", newval);
            } else if (source == null) {
                LOGGER.trace("Null source?");
            } else {
                LOGGER.trace("Unexpected source: {}", (Object)source.getClass());
            }
        }
        EventQueue.invokeLater(() -> pframe.refreshMenu("plot-menu"));
        this.last_ = now;
        this.busy_ = false;
    }
}

