/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.action;

import gov.nasa.giss.panoply.plot.PanPlotMeta;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.util.PanPlotSectionID;
import gov.nasa.giss.panoply.util.PanProperties;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.lang.invoke.MethodHandles;
import javax.swing.AbstractAction;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PanTogglePlotSectionAction
extends AbstractAction {
    private static final Logger LOGGER = LoggerFactory.getLogger(MethodHandles.lookup().lookupClass());
    private final PanPlotMeta pmeta_;
    private final String actionID_;
    private long last_;
    private boolean busy_;

    public PanTogglePlotSectionAction(PanPlotMeta pmeta, String actionID) {
        super(PanProperties.MENU_PROPS.getString(actionID));
        this.pmeta_ = pmeta;
        this.actionID_ = actionID;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object source;
        if (this.busy_) {
            return;
        }
        this.busy_ = true;
        PanPlotSectionID sid = PanPlotSectionID.matching(this.actionID_);
        if (sid == null) {
            this.busy_ = false;
            throw new RuntimeException("Unknown action ID: " + this.actionID_);
        }
        String pkey = sid.getParamKey();
        long now = System.currentTimeMillis();
        Object object = source = e == null ? null : e.getSource();
        if (now - this.last_ >= 200L) {
            if (source instanceof JCheckBoxMenuItem) {
                boolean oldval = this.pmeta_.getBoolean(pkey);
                this.pmeta_.setBoolean(pkey, !oldval);
            } else if (source instanceof JCheckBox) {
                boolean newval = ((JCheckBox)source).isSelected();
                this.pmeta_.setBoolean(pkey, newval);
            } else if (source == null) {
                LOGGER.trace("Null source?");
            } else {
                LOGGER.trace("Unexpected source: {}", (Object)source.getClass());
            }
        }
        PanPlotFrame pframe = this.pmeta_.getFrame();
        EventQueue.invokeLater(() -> {
            pframe.resizeToFitDisplay();
            pframe.refreshMenu("plot-menu");
        });
        this.last_ = now;
        this.busy_ = false;
    }
}

