/*
 * Decompiled with CFR 0.152.
 */
package gov.nasa.giss.panoply.menu;

import gov.nasa.giss.panoply.action.PanCloseWindoidAction;
import gov.nasa.giss.panoply.action.PanCloseWindowAction;
import gov.nasa.giss.panoply.action.PanDumpSettingsAction;
import gov.nasa.giss.panoply.action.PanExportCLScriptAction;
import gov.nasa.giss.panoply.action.PanExportGridAction;
import gov.nasa.giss.panoply.action.PanOpenLocalFileAction;
import gov.nasa.giss.panoply.action.PanOpenLocalZarrStoreAction;
import gov.nasa.giss.panoply.action.PanOpenRemoteCatalogAction;
import gov.nasa.giss.panoply.action.PanOpenRemoteDatasetAction;
import gov.nasa.giss.panoply.action.PanSaveImageAction;
import gov.nasa.giss.panoply.action.PanSaveImageAsAction;
import gov.nasa.giss.panoply.action.PanSaveLogAsAction;
import gov.nasa.giss.panoply.colortable.PanColorTableFrame;
import gov.nasa.giss.panoply.log.PanLoggingFrame;
import gov.nasa.giss.panoply.macos.PanHiddenMacFrame;
import gov.nasa.giss.panoply.menu.PanExportMenu;
import gov.nasa.giss.panoply.menu.PanMenu;
import gov.nasa.giss.panoply.overlay.PanOverlayFrame;
import gov.nasa.giss.panoply.plotui.PanPlotFrame;
import gov.nasa.giss.panoply.plotui.PanPlotWindoid;
import gov.nasa.giss.panoply.ui.PanDisplayFrame;
import gov.nasa.giss.panoply.ui.PanFrame;
import gov.nasa.giss.panoply.util.PanQuitHandler;
import gov.nasa.giss.panoply.util.PanUtils;
import gov.nasa.giss.ui.GuiUtils;
import gov.nasa.giss.ui.menu.GissMenuItem;
import gov.nasa.giss.util.GissPrintAction;
import gov.nasa.giss.util.PlatformUtils;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.print.Printable;
import javax.swing.AbstractAction;
import javax.swing.JMenuItem;

public class PanFileMenu
extends PanMenu {
    private PanCloseWindoidAction closeWindoidAction_;

    public PanFileMenu(PanFrame parent) {
        super(parent, "file-menu");
        boolean isMacOS = PlatformUtils.isMacintosh();
        boolean parentIsPlot = parent instanceof PanPlotFrame;
        this.add(this.makeItemFromProperties("new", null)).setEnabled(false);
        AbstractAction a = new PanOpenLocalFileAction(parent);
        GissMenuItem jmi = this.makeItemFromProperties("open-local", a);
        this.add(jmi).setEnabled(true);
        if (PanUtils.isDevoZarrDirectoryStore()) {
            a = new PanOpenLocalZarrStoreAction(parent);
            jmi = this.makeItemFromProperties("open-zarr-store", a);
            this.add(jmi).setEnabled(true);
        }
        a = new PanOpenRemoteDatasetAction(parent);
        jmi = this.makeItemFromProperties("open-remote-data", a);
        this.add(jmi).setEnabled(true);
        a = new PanOpenRemoteCatalogAction(parent);
        jmi = this.makeItemFromProperties("open-remote-catalog", a);
        this.add(jmi).setEnabled(true);
        if (isMacOS) {
            this.addSeparator();
        }
        a = isMacOS && parent instanceof PanHiddenMacFrame ? null : new PanCloseWindowAction(parent);
        jmi = this.makeItemFromProperties("close-window", a);
        this.add(jmi).setEnabled(a != null);
        this.closeWindoidAction_ = parent instanceof PanPlotFrame ? new PanCloseWindoidAction(parent) : null;
        GissMenuItem jmi2 = this.makeItemFromProperties("close-windoid", this.closeWindoidAction_);
        this.add(jmi2).setEnabled(this.closeWindoidAction_ != null);
        if (!isMacOS) {
            this.addSeparator();
        }
        PanSaveImageAction a1 = null;
        PanSaveImageAsAction a2 = null;
        if (parent instanceof PanDisplayFrame) {
            a2 = new PanSaveImageAsAction((PanDisplayFrame)parent);
            a1 = new PanSaveImageAction((PanDisplayFrame)parent, a2);
        }
        GissMenuItem jmi1 = this.makeItemFromProperties("save-image", a1);
        GissMenuItem jmi22 = this.makeItemFromProperties("save-image-as", a2);
        this.add(jmi1).setEnabled(a1 != null);
        this.add(jmi22).setEnabled(a2 != null);
        if (PanUtils.isBeta() || parent instanceof PanLoggingFrame) {
            a = null;
            if (parent instanceof PanLoggingFrame) {
                a = new PanSaveLogAsAction((PanLoggingFrame)parent);
            }
            jmi = this.makeItemFromProperties("save-logging-as", a);
            this.add(jmi).setEnabled(a != null);
        }
        this.addSeparator();
        a = parentIsPlot ? new PanExportCLScriptAction((PanPlotFrame)parent) : null;
        jmi = this.makeItemFromProperties("export-cl-script", a);
        this.add(jmi).setEnabled(a != null);
        if (PanUtils.isDevoSavedSettings()) {
            a = parentIsPlot ? new PanDumpSettingsAction((PanPlotFrame)parent) : null;
            jmi = this.makeItemFromProperties("dump-settings", a);
            this.add(jmi).setEnabled(a != null);
        }
        if (PanUtils.isDevo()) {
            a = parentIsPlot ? new PanExportGridAction((PanPlotFrame)parent) : null;
            jmi = this.makeItemFromProperties("export-plotted-grid", a);
            this.add(jmi).setEnabled(a != null);
        }
        this.add(new PanExportMenu(parent));
        jmi2 = this.makeItemFromProperties("export-kmz", null);
        this.add(jmi2).setEnabled(false);
        jmi2 = this.makeItemFromProperties("export-animation", null);
        this.add(jmi2).setEnabled(false);
        this.addSeparator();
        a = parent instanceof Printable ? new GissPrintAction((Printable)((Object)parent)) : null;
        jmi = this.makeItemFromProperties("print", a);
        this.add(jmi).setEnabled(a != null);
        if (!PlatformUtils.isMacintosh()) {
            this.addSeparator();
            a = new AbstractAction(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PanQuitHandler.quit();
                }
            };
            jmi = this.makeItemFromProperties("quit", a);
            this.add(jmi).setEnabled(true);
        }
    }

    @Override
    public void refresh() {
        super.refresh();
        if (this.closeWindoidAction_ != null) {
            Window ww = GuiUtils.getFocusedWindow();
            this.closeWindoidAction_.setEnabled(ww instanceof PanPlotWindoid);
        }
        boolean animating = PanPlotFrame.isAnimationInProgress();
        JMenuItem jmi = this.getItemForName("open-local");
        jmi.setEnabled(!animating);
        jmi = this.getItemForName("open-remote-data");
        jmi.setEnabled(!animating);
        jmi = this.getItemForName("open-remote-catalog");
        jmi.setEnabled(!animating);
        if (this.pframe_ instanceof PanColorTableFrame) {
            jmi = this.getItemForName("save-image");
            jmi.setEnabled(!animating);
            jmi = this.getItemForName("save-image-as");
            jmi.setEnabled(!animating);
            jmi = this.getItemForName("print");
            jmi.setEnabled(!animating);
        } else if (this.pframe_ instanceof PanOverlayFrame) {
            jmi = this.getItemForName("save-image-as");
            jmi.setEnabled(!animating);
            jmi = this.getItemForName("print");
            jmi.setEnabled(!animating);
        }
    }
}

